// Compiled by ClojureScript 0.0-2138
goog.provide('shannon.distributions');
goog.require('cljs.core');
goog.require('shannon.compatibility');
goog.require('shannon.compatibility');
shannon.distributions.harmonic_number = (function harmonic_number(n){if((n <= 0))
{return 0;
} else
{var exact = (function exact(n__$1){var i = 1.0;var v = 0.0;while(true){
if((i <= n__$1))
{{
var G__5253 = (i + 1.0);
var G__5254 = (v + (1 / i));
i = G__5253;
v = G__5254;
continue;
}
} else
{return v;
}
break;
}
});
var approx = (function approx(n__$1){var a = (1.0 + n__$1);var b = (2.0 * n__$1);var c = (1.0 + b);var d = (c + (2.0 * shannon.compatibility.pow.call(null,n__$1,2.0)));var e = (6.0 * n__$1);var f = shannon.compatibility.pow.call(null,n__$1,2.0);return (((((-1 + 0.5772156649015329) + (- (((1.0 + e) + (6.0 * f)) / (180.0 * shannon.compatibility.pow.call(null,d,3))))) + ((((((-1.0 + (-42.0 * f)) + (-14.0 * n__$1)) + (140.0 * shannon.compatibility.pow.call(null,n__$1,4.0))) + (168.0 * shannon.compatibility.pow.call(null,n__$1,5.0))) + (56.0 * shannon.compatibility.pow.call(null,n__$1,6.0))) / (2520.0 * shannon.compatibility.pow.call(null,d,7.0)))) + (c * shannon.compatibility.atan.call(null,(1 / c)))) + (0.5 * shannon.compatibility.ln.call(null,(d / 2.0))));
});
if((n < 50))
{var n0 = shannon.compatibility.floor.call(null,n);var y0 = exact.call(null,n0);if((n === n0))
{return y0;
} else
{var n1 = (n0 + 1.0);var y1 = (y0 + (1 / n1));var a = (n1 - n);var b = (1.0 - a);return ((a * y0) + (b * y1));
}
} else
{return approx.call(null,n);
}
}
});
shannon.distributions.nth_harmonic = cljs.core.memoize.call(null,(function (n){return shannon.distributions.harmonic_number.call(null,n);
}));
shannon.distributions.zipf_pmf = (function zipf_pmf(k,N){if((k < 1))
{return 0.0;
} else
{if((k > N))
{return 0.0;
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{return ((1.0 / k) / shannon.distributions.nth_harmonic.call(null,N));
} else
{return null;
}
}
}
});
shannon.distributions.zipf_cdf = (function zipf_cdf(k,N){if((k <= 0))
{return 0.0;
} else
{if((k >= N))
{return 1.0;
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{return (shannon.distributions.harmonic_number.call(null,k) / shannon.distributions.nth_harmonic.call(null,N));
} else
{return null;
}
}
}
});
shannon.distributions.zipf_breakpoint = cljs.core.memoize.call(null,(function (k,N){return shannon.distributions.zipf_cdf.call(null,k,N);
}));
shannon.distributions.inverse_zipf_cdf = (function inverse_zipf_cdf(p,N){var newton = (function newton(x){var a = (1.0 + x);var b = (a * x);var c = shannon.compatibility.pow.call(null,(1.0 + (2.0 * b)),8.0);var d = (1.0 + (2.0 * x));return (x + (((45.0 * c) * ((p * shannon.distributions.nth_harmonic.call(null,N)) - shannon.distributions.harmonic_number.call(null,x))) / ((((8.0 * b) * d) * (1.0 + (b * (7.0 + (b * (17.0 + ((12.0 * b) * ((2.0 + x) + shannon.compatibility.pow.call(null,x,2.0))))))))) + ((90.0 * c) * shannon.compatibility.atan.call(null,(1 / d))))));
});
if((p <= 0))
{return 0;
} else
{if((p >= 1))
{return N;
} else
{if((p < shannon.distributions.zipf_breakpoint.call(null,50,N)))
{var k = 1;var pk = shannon.distributions.zipf_pmf.call(null,1,N);while(true){
if((pk < p))
{{
var G__5255 = (k + 1);
var G__5256 = (pk + shannon.distributions.zipf_pmf.call(null,(k + 1),N));
k = G__5255;
pk = G__5256;
continue;
}
} else
{return (k - 1);
}
break;
}
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{var guess = 50.0;var epsilon = 0.5;var x1 = guess;var x0 = 0.0;var i = 0;while(true){
if((i > 100))
{return null;
} else
{if((shannon.compatibility.abs.call(null,(x1 - x0)) > epsilon))
{{
var G__5257 = newton.call(null,x1);
var G__5258 = x1;
var G__5259 = (i + 1);
x1 = G__5257;
x0 = G__5258;
i = G__5259;
continue;
}
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{return shannon.compatibility.round.call(null,x1);
} else
{return null;
}
}
}
break;
}
} else
{return null;
}
}
}
}
});
shannon.distributions.DiscreteDistribution = (function (){var obj5261 = {};return obj5261;
})();
shannon.distributions.next_lower = (function next_lower(o,k){if((function (){var and__3397__auto__ = o;if(and__3397__auto__)
{return o.shannon$distributions$DiscreteDistribution$next_lower$arity$2;
} else
{return and__3397__auto__;
}
})())
{return o.shannon$distributions$DiscreteDistribution$next_lower$arity$2(o,k);
} else
{var x__4030__auto__ = (((o == null))?null:o);return (function (){var or__3409__auto__ = (shannon.distributions.next_lower[goog.typeOf(x__4030__auto__)]);if(or__3409__auto__)
{return or__3409__auto__;
} else
{var or__3409__auto____$1 = (shannon.distributions.next_lower["_"]);if(or__3409__auto____$1)
{return or__3409__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"DiscreteDistribution.next-lower",o);
}
}
})().call(null,o,k);
}
});
shannon.distributions.next_higher = (function next_higher(o,k){if((function (){var and__3397__auto__ = o;if(and__3397__auto__)
{return o.shannon$distributions$DiscreteDistribution$next_higher$arity$2;
} else
{return and__3397__auto__;
}
})())
{return o.shannon$distributions$DiscreteDistribution$next_higher$arity$2(o,k);
} else
{var x__4030__auto__ = (((o == null))?null:o);return (function (){var or__3409__auto__ = (shannon.distributions.next_higher[goog.typeOf(x__4030__auto__)]);if(or__3409__auto__)
{return or__3409__auto__;
} else
{var or__3409__auto____$1 = (shannon.distributions.next_higher["_"]);if(or__3409__auto____$1)
{return or__3409__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"DiscreteDistribution.next-higher",o);
}
}
})().call(null,o,k);
}
});
shannon.distributions.cdf = (function cdf(o,k){if((function (){var and__3397__auto__ = o;if(and__3397__auto__)
{return o.shannon$distributions$DiscreteDistribution$cdf$arity$2;
} else
{return and__3397__auto__;
}
})())
{return o.shannon$distributions$DiscreteDistribution$cdf$arity$2(o,k);
} else
{var x__4030__auto__ = (((o == null))?null:o);return (function (){var or__3409__auto__ = (shannon.distributions.cdf[goog.typeOf(x__4030__auto__)]);if(or__3409__auto__)
{return or__3409__auto__;
} else
{var or__3409__auto____$1 = (shannon.distributions.cdf["_"]);if(or__3409__auto____$1)
{return or__3409__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"DiscreteDistribution.cdf",o);
}
}
})().call(null,o,k);
}
});
shannon.distributions.inverse_cdf = (function inverse_cdf(o,interval){if((function (){var and__3397__auto__ = o;if(and__3397__auto__)
{return o.shannon$distributions$DiscreteDistribution$inverse_cdf$arity$2;
} else
{return and__3397__auto__;
}
})())
{return o.shannon$distributions$DiscreteDistribution$inverse_cdf$arity$2(o,interval);
} else
{var x__4030__auto__ = (((o == null))?null:o);return (function (){var or__3409__auto__ = (shannon.distributions.inverse_cdf[goog.typeOf(x__4030__auto__)]);if(or__3409__auto__)
{return or__3409__auto__;
} else
{var or__3409__auto____$1 = (shannon.distributions.inverse_cdf["_"]);if(or__3409__auto____$1)
{return or__3409__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"DiscreteDistribution.inverse-cdf",o);
}
}
})().call(null,o,interval);
}
});

/**
* @constructor
*/
shannon.distributions.ZipfDistribution = (function (N){
this.N = N;
})
shannon.distributions.ZipfDistribution.cljs$lang$type = true;
shannon.distributions.ZipfDistribution.cljs$lang$ctorStr = "shannon.distributions/ZipfDistribution";
shannon.distributions.ZipfDistribution.cljs$lang$ctorPrWriter = (function (this__3971__auto__,writer__3972__auto__,opt__3973__auto__){return cljs.core._write.call(null,writer__3972__auto__,"shannon.distributions/ZipfDistribution");
});
shannon.distributions.ZipfDistribution.prototype.shannon$distributions$DiscreteDistribution$ = true;
shannon.distributions.ZipfDistribution.prototype.shannon$distributions$DiscreteDistribution$next_lower$arity$2 = (function (_,k){var self__ = this;
var ___$1 = this;if((k === 0))
{return null;
} else
{return (k - 1);
}
});
shannon.distributions.ZipfDistribution.prototype.shannon$distributions$DiscreteDistribution$next_higher$arity$2 = (function (_,k){var self__ = this;
var ___$1 = this;if((k >= (self__.N - 1)))
{return null;
} else
{return (k + 1);
}
});
shannon.distributions.ZipfDistribution.prototype.shannon$distributions$DiscreteDistribution$cdf$arity$2 = (function (_,k){var self__ = this;
var ___$1 = this;return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [shannon.distributions.zipf_cdf.call(null,k,self__.N),shannon.distributions.zipf_cdf.call(null,(k + 1),self__.N)], null);
});
shannon.distributions.ZipfDistribution.prototype.shannon$distributions$DiscreteDistribution$inverse_cdf$arity$2 = (function (_,p){var self__ = this;
var ___$1 = this;return shannon.distributions.inverse_zipf_cdf.call(null,p,self__.N);
});
shannon.distributions.__GT_ZipfDistribution = (function __GT_ZipfDistribution(N){return (new shannon.distributions.ZipfDistribution(N));
});
shannon.distributions.zipf_distribution = (function zipf_distribution(N){return (new shannon.distributions.ZipfDistribution(N));
});

/**
* @constructor
*/
shannon.distributions.UniformDistribution = (function (N){
this.N = N;
})
shannon.distributions.UniformDistribution.cljs$lang$type = true;
shannon.distributions.UniformDistribution.cljs$lang$ctorStr = "shannon.distributions/UniformDistribution";
shannon.distributions.UniformDistribution.cljs$lang$ctorPrWriter = (function (this__3971__auto__,writer__3972__auto__,opt__3973__auto__){return cljs.core._write.call(null,writer__3972__auto__,"shannon.distributions/UniformDistribution");
});
shannon.distributions.UniformDistribution.prototype.shannon$distributions$DiscreteDistribution$ = true;
shannon.distributions.UniformDistribution.prototype.shannon$distributions$DiscreteDistribution$next_lower$arity$2 = (function (_,k){var self__ = this;
var ___$1 = this;if((k === 0))
{return null;
} else
{return (k - 1);
}
});
shannon.distributions.UniformDistribution.prototype.shannon$distributions$DiscreteDistribution$next_higher$arity$2 = (function (_,k){var self__ = this;
var ___$1 = this;if((k >= (self__.N - 1)))
{return null;
} else
{return (k + 1);
}
});
shannon.distributions.UniformDistribution.prototype.shannon$distributions$DiscreteDistribution$cdf$arity$2 = (function (_,k){var self__ = this;
var ___$1 = this;return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(k / self__.N),((k + 1) / self__.N)], null);
});
shannon.distributions.UniformDistribution.prototype.shannon$distributions$DiscreteDistribution$inverse_cdf$arity$2 = (function (_,p){var self__ = this;
var ___$1 = this;return shannon.compatibility.round.call(null,shannon.compatibility.floor.call(null,(self__.N * p)));
});
shannon.distributions.__GT_UniformDistribution = (function __GT_UniformDistribution(N){return (new shannon.distributions.UniformDistribution(N));
});
shannon.distributions.uniform_distribution = (function uniform_distribution(N){return (new shannon.distributions.UniformDistribution(N));
});
shannon.distributions.gcdf = (function gcdf(k,mu){return (1.0 - shannon.compatibility.pow.call(null,(mu / (1.0 + mu)),(1.0 + shannon.compatibility.floor.call(null,k))));
});

/**
* @constructor
*/
shannon.distributions.GeometricDistribution = (function (mu){
this.mu = mu;
})
shannon.distributions.GeometricDistribution.cljs$lang$type = true;
shannon.distributions.GeometricDistribution.cljs$lang$ctorStr = "shannon.distributions/GeometricDistribution";
shannon.distributions.GeometricDistribution.cljs$lang$ctorPrWriter = (function (this__3971__auto__,writer__3972__auto__,opt__3973__auto__){return cljs.core._write.call(null,writer__3972__auto__,"shannon.distributions/GeometricDistribution");
});
shannon.distributions.GeometricDistribution.prototype.shannon$distributions$DiscreteDistribution$ = true;
shannon.distributions.GeometricDistribution.prototype.shannon$distributions$DiscreteDistribution$next_lower$arity$2 = (function (_,k){var self__ = this;
var ___$1 = this;if((k === 0))
{return null;
} else
{return (k - 1);
}
});
shannon.distributions.GeometricDistribution.prototype.shannon$distributions$DiscreteDistribution$next_higher$arity$2 = (function (_,k){var self__ = this;
var ___$1 = this;return (k + 1);
});
shannon.distributions.GeometricDistribution.prototype.shannon$distributions$DiscreteDistribution$cdf$arity$2 = (function (_,k){var self__ = this;
var ___$1 = this;return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [shannon.distributions.gcdf.call(null,(k - 1),self__.mu),shannon.distributions.gcdf.call(null,k,self__.mu)], null);
});
shannon.distributions.GeometricDistribution.prototype.shannon$distributions$DiscreteDistribution$inverse_cdf$arity$2 = (function (_,p){var self__ = this;
var ___$1 = this;return shannon.compatibility.ceiling.call(null,((shannon.compatibility.ln.call(null,(1.0 - p)) / shannon.compatibility.ln.call(null,(self__.mu / (1.0 + self__.mu)))) - 1.0));
});
shannon.distributions.__GT_GeometricDistribution = (function __GT_GeometricDistribution(mu){return (new shannon.distributions.GeometricDistribution(mu));
});
shannon.distributions.geometric_distribution = (function geometric_distribution(mu){return (new shannon.distributions.GeometricDistribution(mu));
});
shannon.distributions.ln_gamma = (function ln_gamma(z){var ln_sqrt_2_pi = 0.9189385332046728;var g = 9.0;var lanczos_coef = new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [1.0000000000000002,5716.400188274341,-14815.30426768414,14291.492776574785,-6348.160217641459,1301.608286058322,-108.17670535143696,2.605696505611756,-0.007423452510201416,5.384136432509564E-8,-4.023533141268236E-9], null);if((z < 0.5))
{return (shannon.compatibility.ln.call(null,(shannon.compatibility.pi / shannon.compatibility.sin.call(null,(shannon.compatibility.pi * z)))) - ln_gamma.call(null,(1.0 - z)));
} else
{var z__$1 = (z - 1.0);var base = ((z__$1 + g) + 0.5);var sum = 0.0;var i = (cljs.core.count.call(null,lanczos_coef) - 1);while(true){
if((i >= 1))
{{
var G__5262 = (sum + (cljs.core.nth.call(null,lanczos_coef,i) / (z__$1 + i)));
var G__5263 = (i - 1);
sum = G__5262;
i = G__5263;
continue;
}
} else
{var sum__$1 = (sum + cljs.core.nth.call(null,lanczos_coef,0));return (((ln_sqrt_2_pi + shannon.compatibility.ln.call(null,sum__$1)) + (- base)) + (shannon.compatibility.ln.call(null,base) * (z__$1 + 0.5)));
}
break;
}
}
});
shannon.distributions.benford_distribution = (function benford_distribution(base,digits){var min_d = shannon.compatibility.pow.call(null,base,(digits - 1));var max_d = (shannon.compatibility.pow.call(null,base,digits) - 1);var ln_base = shannon.compatibility.ln.call(null,base);var gamma_d1 = shannon.distributions.ln_gamma.call(null,min_d);var gamma_d2 = shannon.distributions.ln_gamma.call(null,(1.0 + min_d));var epsilon = 0.5;var benford_cdf = (function benford_cdf(d){if((d < min_d))
{return 0.0;
} else
{if((d >= max_d))
{return 1.0;
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{return (((((- shannon.distributions.ln_gamma.call(null,(1.0 + d))) + gamma_d1) + shannon.distributions.ln_gamma.call(null,(2.0 + d))) + (- gamma_d2)) / ln_base);
} else
{return null;
}
}
}
});
var newton = (function newton(d,p){var a = (d + 1.0);return ((d + (- (a * shannon.compatibility.ln.call(null,a)))) + ((a * ((digits + p) + -1.0)) * ln_base));
});
var benford_inverse_cdf = (function benford_inverse_cdf(p,d0){var i = 1;var d = d0;while(true){
var dn = (function (){var x__3716__auto__ = min_d;var y__3717__auto__ = (function (){var x__3723__auto__ = max_d;var y__3724__auto__ = newton.call(null,d,p);return ((x__3723__auto__ < y__3724__auto__) ? x__3723__auto__ : y__3724__auto__);
})();return ((x__3716__auto__ > y__3717__auto__) ? x__3716__auto__ : y__3717__auto__);
})();if((i >= 100))
{return null;
} else
{if((shannon.compatibility.abs.call(null,(dn - d)) < epsilon))
{return shannon.compatibility.round.call(null,dn);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{{
var G__5270 = (i + 1);
var G__5271 = (function (){var x__3716__auto__ = (function (){var x__3723__auto__ = dn;var y__3724__auto__ = max_d;return ((x__3723__auto__ < y__3724__auto__) ? x__3723__auto__ : y__3724__auto__);
})();var y__3717__auto__ = min_d;return ((x__3716__auto__ > y__3717__auto__) ? x__3716__auto__ : y__3717__auto__);
})();
i = G__5270;
d = G__5271;
continue;
}
} else
{return null;
}
}
}
break;
}
});
var d0 = benford_inverse_cdf.call(null,0.5,min_d);if(typeof shannon.distributions.t5267 !== 'undefined')
{} else
{
/**
* @constructor
*/
shannon.distributions.t5267 = (function (d0,max_d,benford_distribution,min_d,gamma_d2,digits,ln_base,newton,gamma_d1,benford_inverse_cdf,epsilon,base,benford_cdf,meta5268){
this.d0 = d0;
this.max_d = max_d;
this.benford_distribution = benford_distribution;
this.min_d = min_d;
this.gamma_d2 = gamma_d2;
this.digits = digits;
this.ln_base = ln_base;
this.newton = newton;
this.gamma_d1 = gamma_d1;
this.benford_inverse_cdf = benford_inverse_cdf;
this.epsilon = epsilon;
this.base = base;
this.benford_cdf = benford_cdf;
this.meta5268 = meta5268;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
shannon.distributions.t5267.cljs$lang$type = true;
shannon.distributions.t5267.cljs$lang$ctorStr = "shannon.distributions/t5267";
shannon.distributions.t5267.cljs$lang$ctorPrWriter = (function (this__3971__auto__,writer__3972__auto__,opt__3973__auto__){return cljs.core._write.call(null,writer__3972__auto__,"shannon.distributions/t5267");
});
shannon.distributions.t5267.prototype.shannon$distributions$DiscreteDistribution$ = true;
shannon.distributions.t5267.prototype.shannon$distributions$DiscreteDistribution$next_lower$arity$2 = (function (_,d){var self__ = this;
var ___$1 = this;if((d <= self__.min_d))
{return null;
} else
{return (d - 1);
}
});
shannon.distributions.t5267.prototype.shannon$distributions$DiscreteDistribution$next_higher$arity$2 = (function (_,d){var self__ = this;
var ___$1 = this;if((d >= self__.max_d))
{return null;
} else
{return (d + 1);
}
});
shannon.distributions.t5267.prototype.shannon$distributions$DiscreteDistribution$cdf$arity$2 = (function (_,d){var self__ = this;
var ___$1 = this;return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.benford_cdf.call(null,(d - 1)),self__.benford_cdf.call(null,d)], null);
});
shannon.distributions.t5267.prototype.shannon$distributions$DiscreteDistribution$inverse_cdf$arity$2 = (function (_,p){var self__ = this;
var ___$1 = this;return self__.benford_inverse_cdf.call(null,p,self__.d0);
});
shannon.distributions.t5267.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_5269){var self__ = this;
var _5269__$1 = this;return self__.meta5268;
});
shannon.distributions.t5267.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_5269,meta5268__$1){var self__ = this;
var _5269__$1 = this;return (new shannon.distributions.t5267(self__.d0,self__.max_d,self__.benford_distribution,self__.min_d,self__.gamma_d2,self__.digits,self__.ln_base,self__.newton,self__.gamma_d1,self__.benford_inverse_cdf,self__.epsilon,self__.base,self__.benford_cdf,meta5268__$1));
});
shannon.distributions.__GT_t5267 = (function __GT_t5267(d0__$1,max_d__$1,benford_distribution__$1,min_d__$1,gamma_d2__$1,digits__$1,ln_base__$1,newton__$1,gamma_d1__$1,benford_inverse_cdf__$1,epsilon__$1,base__$1,benford_cdf__$1,meta5268){return (new shannon.distributions.t5267(d0__$1,max_d__$1,benford_distribution__$1,min_d__$1,gamma_d2__$1,digits__$1,ln_base__$1,newton__$1,gamma_d1__$1,benford_inverse_cdf__$1,epsilon__$1,base__$1,benford_cdf__$1,meta5268));
});
}
return (new shannon.distributions.t5267(d0,max_d,benford_distribution,min_d,gamma_d2,digits,ln_base,newton,gamma_d1,benford_inverse_cdf,epsilon,base,benford_cdf,null));
});
shannon.distributions.pdf__GT_cdf = (function pdf__GT_cdf(prs){return cljs.core.zipmap.call(null,cljs.core.keys.call(null,prs),cljs.core.reduce.call(null,(function (cdf,p){var last = cljs.core.peek.call(null,cdf);var last_p = (cljs.core.truth_(last)?cljs.core.nth.call(null,last,1):null);var interval = (cljs.core.truth_(last_p)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [last_p,(last_p + p)], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [0,p], null));return cljs.core.conj.call(null,cdf,interval);
}),cljs.core.PersistentVector.EMPTY,cljs.core.vals.call(null,prs)));
});
shannon.distributions.invert_map = (function() {
var invert_map = null;
var invert_map__1 = (function (m){return invert_map.call(null,m,cljs.core.identity);
});
var invert_map__2 = (function (m,f){return cljs.core.zipmap.call(null,cljs.core.map.call(null,f,cljs.core.vals.call(null,m)),cljs.core.keys.call(null,m));
});
invert_map = function(m,f){
switch(arguments.length){
case 1:
return invert_map__1.call(this,m);
case 2:
return invert_map__2.call(this,m,f);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
invert_map.cljs$core$IFn$_invoke$arity$1 = invert_map__1;
invert_map.cljs$core$IFn$_invoke$arity$2 = invert_map__2;
return invert_map;
})()
;
shannon.distributions.custom_distribution = (function custom_distribution(prs){var nzprs = cljs.core.select_keys.call(null,prs,(function (){var iter__4120__auto__ = (function iter__5284(s__5285){return (new cljs.core.LazySeq(null,(function (){var s__5285__$1 = s__5285;while(true){
var temp__4092__auto__ = cljs.core.seq.call(null,s__5285__$1);if(temp__4092__auto__)
{var s__5285__$2 = temp__4092__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,s__5285__$2))
{var c__4118__auto__ = cljs.core.chunk_first.call(null,s__5285__$2);var size__4119__auto__ = cljs.core.count.call(null,c__4118__auto__);var b__5287 = cljs.core.chunk_buffer.call(null,size__4119__auto__);if((function (){var i__5286 = 0;while(true){
if((i__5286 < size__4119__auto__))
{var vec__5290 = cljs.core._nth.call(null,c__4118__auto__,i__5286);var k = cljs.core.nth.call(null,vec__5290,0,null);var v = cljs.core.nth.call(null,vec__5290,1,null);if((v > 0))
{cljs.core.chunk_append.call(null,b__5287,k);
{
var G__5295 = (i__5286 + 1);
i__5286 = G__5295;
continue;
}
} else
{{
var G__5296 = (i__5286 + 1);
i__5286 = G__5296;
continue;
}
}
} else
{return true;
}
break;
}
})())
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__5287),iter__5284.call(null,cljs.core.chunk_rest.call(null,s__5285__$2)));
} else
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__5287),null);
}
} else
{var vec__5291 = cljs.core.first.call(null,s__5285__$2);var k = cljs.core.nth.call(null,vec__5291,0,null);var v = cljs.core.nth.call(null,vec__5291,1,null);if((v > 0))
{return cljs.core.cons.call(null,k,iter__5284.call(null,cljs.core.rest.call(null,s__5285__$2)));
} else
{{
var G__5297 = cljs.core.rest.call(null,s__5285__$2);
s__5285__$1 = G__5297;
continue;
}
}
}
} else
{return null;
}
break;
}
}),null,null));
});return iter__4120__auto__.call(null,prs);
})());var norm_c = (1 / cljs.core.reduce.call(null,cljs.core._PLUS_,cljs.core.vals.call(null,nzprs)));var pdf = cljs.core.into.call(null,cljs.core.sorted_map.call(null),cljs.core.zipmap.call(null,cljs.core.keys.call(null,nzprs),cljs.core.map.call(null,((function (nzprs,norm_c){
return (function (p1__5272_SHARP_){return (norm_c * p1__5272_SHARP_);
});})(nzprs,norm_c))
,cljs.core.vals.call(null,nzprs))));var cdf = shannon.distributions.pdf__GT_cdf.call(null,pdf);var inverse = cljs.core.into.call(null,cljs.core.sorted_map.call(null),shannon.distributions.invert_map.call(null,cdf,cljs.core.second));var key_vec = cljs.core.vec.call(null,cljs.core.vals.call(null,inverse));var key_indices = cljs.core.apply.call(null,cljs.core.conj,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.call(null,((function (nzprs,norm_c,pdf,cdf,inverse,key_vec){
return (function (i,x){return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x,i], null);
});})(nzprs,norm_c,pdf,cdf,inverse,key_vec))
,key_vec));if(typeof shannon.distributions.t5292 !== 'undefined')
{} else
{
/**
* @constructor
*/
shannon.distributions.t5292 = (function (key_indices,key_vec,inverse,cdf,pdf,norm_c,nzprs,prs,custom_distribution,meta5293){
this.key_indices = key_indices;
this.key_vec = key_vec;
this.inverse = inverse;
this.cdf = cdf;
this.pdf = pdf;
this.norm_c = norm_c;
this.nzprs = nzprs;
this.prs = prs;
this.custom_distribution = custom_distribution;
this.meta5293 = meta5293;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
shannon.distributions.t5292.cljs$lang$type = true;
shannon.distributions.t5292.cljs$lang$ctorStr = "shannon.distributions/t5292";
shannon.distributions.t5292.cljs$lang$ctorPrWriter = (function (this__3971__auto__,writer__3972__auto__,opt__3973__auto__){return cljs.core._write.call(null,writer__3972__auto__,"shannon.distributions/t5292");
});
shannon.distributions.t5292.prototype.shannon$distributions$DiscreteDistribution$ = true;
shannon.distributions.t5292.prototype.shannon$distributions$DiscreteDistribution$next_higher$arity$2 = (function (_,x){var self__ = this;
var ___$1 = this;var i = cljs.core.get.call(null,self__.key_indices,x);if((i < (cljs.core.count.call(null,self__.key_vec) - 1)))
{return cljs.core.nth.call(null,self__.key_vec,(i + 1));
} else
{return null;
}
});
shannon.distributions.t5292.prototype.shannon$distributions$DiscreteDistribution$next_lower$arity$2 = (function (_,x){var self__ = this;
var ___$1 = this;var i = cljs.core.get.call(null,self__.key_indices,x);if((i === 0))
{return null;
} else
{return cljs.core.nth.call(null,self__.key_vec,(i - 1));
}
});
shannon.distributions.t5292.prototype.shannon$distributions$DiscreteDistribution$cdf$arity$2 = (function (_,x){var self__ = this;
var ___$1 = this;return cljs.core.get.call(null,self__.cdf,x);
});
shannon.distributions.t5292.prototype.shannon$distributions$DiscreteDistribution$inverse_cdf$arity$2 = (function (_,p){var self__ = this;
var ___$1 = this;return cljs.core.second.call(null,cljs.core.first.call(null,cljs.core.subseq.call(null,self__.inverse,cljs.core._GT__EQ_,(p + 2.0E-16))));
});
shannon.distributions.t5292.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_5294){var self__ = this;
var _5294__$1 = this;return self__.meta5293;
});
shannon.distributions.t5292.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_5294,meta5293__$1){var self__ = this;
var _5294__$1 = this;return (new shannon.distributions.t5292(self__.key_indices,self__.key_vec,self__.inverse,self__.cdf,self__.pdf,self__.norm_c,self__.nzprs,self__.prs,self__.custom_distribution,meta5293__$1));
});
shannon.distributions.__GT_t5292 = (function __GT_t5292(key_indices__$1,key_vec__$1,inverse__$1,cdf__$1,pdf__$1,norm_c__$1,nzprs__$1,prs__$1,custom_distribution__$1,meta5293){return (new shannon.distributions.t5292(key_indices__$1,key_vec__$1,inverse__$1,cdf__$1,pdf__$1,norm_c__$1,nzprs__$1,prs__$1,custom_distribution__$1,meta5293));
});
}
return (new shannon.distributions.t5292(key_indices,key_vec,inverse,cdf,pdf,norm_c,nzprs,prs,custom_distribution,null));
});

/**
* @constructor
*/
shannon.distributions.ConstantDistribution = (function (value){
this.value = value;
})
shannon.distributions.ConstantDistribution.cljs$lang$type = true;
shannon.distributions.ConstantDistribution.cljs$lang$ctorStr = "shannon.distributions/ConstantDistribution";
shannon.distributions.ConstantDistribution.cljs$lang$ctorPrWriter = (function (this__3971__auto__,writer__3972__auto__,opt__3973__auto__){return cljs.core._write.call(null,writer__3972__auto__,"shannon.distributions/ConstantDistribution");
});
shannon.distributions.ConstantDistribution.prototype.shannon$distributions$DiscreteDistribution$ = true;
shannon.distributions.ConstantDistribution.prototype.shannon$distributions$DiscreteDistribution$next_higher$arity$2 = (function (_,___$1){var self__ = this;
var ___$2 = this;return null;
});
shannon.distributions.ConstantDistribution.prototype.shannon$distributions$DiscreteDistribution$next_lower$arity$2 = (function (_,___$1){var self__ = this;
var ___$2 = this;return null;
});
shannon.distributions.ConstantDistribution.prototype.shannon$distributions$DiscreteDistribution$cdf$arity$2 = (function (_,___$1){var self__ = this;
var ___$2 = this;return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [0,1], null);
});
shannon.distributions.ConstantDistribution.prototype.shannon$distributions$DiscreteDistribution$inverse_cdf$arity$2 = (function (_,___$1){var self__ = this;
var ___$2 = this;return self__.value;
});
shannon.distributions.__GT_ConstantDistribution = (function __GT_ConstantDistribution(value){return (new shannon.distributions.ConstantDistribution(value));
});
shannon.distributions.constant_distribution = (function constant_distribution(value){return (new shannon.distributions.ConstantDistribution(value));
});
