// Compiled by ClojureScript 0.0-2138
goog.provide('shannon.core');
goog.require('cljs.core');
goog.require('shannon.distributions');
goog.require('shannon.compatibility');
goog.require('shannon.distributions');
goog.require('shannon.compatibility');
goog.require('shannon.ngrams.en');
goog.require('shannon.ngrams.en');
shannon.core.coding_precision = 48;
shannon.core.whole = 2.81474976710656E14;
shannon.core.half = (shannon.core.whole / 2.0);
shannon.core.quarter = (shannon.core.whole / 4.0);
shannon.core.EmitsBits = (function (){var obj5058 = {};return obj5058;
})();
shannon.core.read_BANG_ = (function read_BANG_(o){if((function (){var and__3397__auto__ = o;if(and__3397__auto__)
{return o.shannon$core$EmitsBits$read_BANG_$arity$1;
} else
{return and__3397__auto__;
}
})())
{return o.shannon$core$EmitsBits$read_BANG_$arity$1(o);
} else
{var x__4030__auto__ = (((o == null))?null:o);return (function (){var or__3409__auto__ = (shannon.core.read_BANG_[goog.typeOf(x__4030__auto__)]);if(or__3409__auto__)
{return or__3409__auto__;
} else
{var or__3409__auto____$1 = (shannon.core.read_BANG_["_"]);if(or__3409__auto____$1)
{return or__3409__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"EmitsBits.read!",o);
}
}
})().call(null,o);
}
});
shannon.core.source = (function source(o){if((function (){var and__3397__auto__ = o;if(and__3397__auto__)
{return o.shannon$core$EmitsBits$source$arity$1;
} else
{return and__3397__auto__;
}
})())
{return o.shannon$core$EmitsBits$source$arity$1(o);
} else
{var x__4030__auto__ = (((o == null))?null:o);return (function (){var or__3409__auto__ = (shannon.core.source[goog.typeOf(x__4030__auto__)]);if(or__3409__auto__)
{return or__3409__auto__;
} else
{var or__3409__auto____$1 = (shannon.core.source["_"]);if(or__3409__auto____$1)
{return or__3409__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"EmitsBits.source",o);
}
}
})().call(null,o);
}
});
shannon.core.ConsumesBits = (function (){var obj5060 = {};return obj5060;
})();
shannon.core.write_BANG_ = (function write_BANG_(o,bit){if((function (){var and__3397__auto__ = o;if(and__3397__auto__)
{return o.shannon$core$ConsumesBits$write_BANG_$arity$2;
} else
{return and__3397__auto__;
}
})())
{return o.shannon$core$ConsumesBits$write_BANG_$arity$2(o,bit);
} else
{var x__4030__auto__ = (((o == null))?null:o);return (function (){var or__3409__auto__ = (shannon.core.write_BANG_[goog.typeOf(x__4030__auto__)]);if(or__3409__auto__)
{return or__3409__auto__;
} else
{var or__3409__auto____$1 = (shannon.core.write_BANG_["_"]);if(or__3409__auto____$1)
{return or__3409__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"ConsumesBits.write!",o);
}
}
})().call(null,o,bit);
}
});
shannon.core.target = (function target(o){if((function (){var and__3397__auto__ = o;if(and__3397__auto__)
{return o.shannon$core$ConsumesBits$target$arity$1;
} else
{return and__3397__auto__;
}
})())
{return o.shannon$core$ConsumesBits$target$arity$1(o);
} else
{var x__4030__auto__ = (((o == null))?null:o);return (function (){var or__3409__auto__ = (shannon.core.target[goog.typeOf(x__4030__auto__)]);if(or__3409__auto__)
{return or__3409__auto__;
} else
{var or__3409__auto____$1 = (shannon.core.target["_"]);if(or__3409__auto____$1)
{return or__3409__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"ConsumesBits.target",o);
}
}
})().call(null,o);
}
});
shannon.core.DistributionCoder = (function (){var obj5062 = {};return obj5062;
})();
shannon.core.encode_symbol = (function encode_symbol(c,distribution,sym){if((function (){var and__3397__auto__ = c;if(and__3397__auto__)
{return c.shannon$core$DistributionCoder$encode_symbol$arity$3;
} else
{return and__3397__auto__;
}
})())
{return c.shannon$core$DistributionCoder$encode_symbol$arity$3(c,distribution,sym);
} else
{var x__4030__auto__ = (((c == null))?null:c);return (function (){var or__3409__auto__ = (shannon.core.encode_symbol[goog.typeOf(x__4030__auto__)]);if(or__3409__auto__)
{return or__3409__auto__;
} else
{var or__3409__auto____$1 = (shannon.core.encode_symbol["_"]);if(or__3409__auto____$1)
{return or__3409__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"DistributionCoder.encode-symbol",c);
}
}
})().call(null,c,distribution,sym);
}
});
shannon.core.decode_symbol = (function decode_symbol(c,distribution){if((function (){var and__3397__auto__ = c;if(and__3397__auto__)
{return c.shannon$core$DistributionCoder$decode_symbol$arity$2;
} else
{return and__3397__auto__;
}
})())
{return c.shannon$core$DistributionCoder$decode_symbol$arity$2(c,distribution);
} else
{var x__4030__auto__ = (((c == null))?null:c);return (function (){var or__3409__auto__ = (shannon.core.decode_symbol[goog.typeOf(x__4030__auto__)]);if(or__3409__auto__)
{return or__3409__auto__;
} else
{var or__3409__auto____$1 = (shannon.core.decode_symbol["_"]);if(or__3409__auto____$1)
{return or__3409__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"DistributionCoder.decode-symbol",c);
}
}
})().call(null,c,distribution);
}
});
shannon.core.BitCoder = (function (){var obj5064 = {};return obj5064;
})();
shannon.core.with_bits_BANG_ = (function with_bits_BANG_(c,bits){if((function (){var and__3397__auto__ = c;if(and__3397__auto__)
{return c.shannon$core$BitCoder$with_bits_BANG_$arity$2;
} else
{return and__3397__auto__;
}
})())
{return c.shannon$core$BitCoder$with_bits_BANG_$arity$2(c,bits);
} else
{var x__4030__auto__ = (((c == null))?null:c);return (function (){var or__3409__auto__ = (shannon.core.with_bits_BANG_[goog.typeOf(x__4030__auto__)]);if(or__3409__auto__)
{return or__3409__auto__;
} else
{var or__3409__auto____$1 = (shannon.core.with_bits_BANG_["_"]);if(or__3409__auto____$1)
{return or__3409__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"BitCoder.with-bits!",c);
}
}
})().call(null,c,bits);
}
});
shannon.core.finalize_BANG_ = (function finalize_BANG_(c){if((function (){var and__3397__auto__ = c;if(and__3397__auto__)
{return c.shannon$core$BitCoder$finalize_BANG_$arity$1;
} else
{return and__3397__auto__;
}
})())
{return c.shannon$core$BitCoder$finalize_BANG_$arity$1(c);
} else
{var x__4030__auto__ = (((c == null))?null:c);return (function (){var or__3409__auto__ = (shannon.core.finalize_BANG_[goog.typeOf(x__4030__auto__)]);if(or__3409__auto__)
{return or__3409__auto__;
} else
{var or__3409__auto____$1 = (shannon.core.finalize_BANG_["_"]);if(or__3409__auto____$1)
{return or__3409__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"BitCoder.finalize!",c);
}
}
})().call(null,c);
}
});

/**
* @constructor
*/
shannon.core.JSArrayBitSource = (function (input){
this.input = input;
})
shannon.core.JSArrayBitSource.cljs$lang$type = true;
shannon.core.JSArrayBitSource.cljs$lang$ctorStr = "shannon.core/JSArrayBitSource";
shannon.core.JSArrayBitSource.cljs$lang$ctorPrWriter = (function (this__3971__auto__,writer__3972__auto__,opt__3973__auto__){return cljs.core._write.call(null,writer__3972__auto__,"shannon.core/JSArrayBitSource");
});
shannon.core.JSArrayBitSource.prototype.shannon$core$EmitsBits$ = true;
shannon.core.JSArrayBitSource.prototype.shannon$core$EmitsBits$read_BANG_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return shift(self__.input);
});
shannon.core.JSArrayBitSource.prototype.shannon$core$EmitsBits$source$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return self__.input;
});
shannon.core.__GT_JSArrayBitSource = (function __GT_JSArrayBitSource(input){return (new shannon.core.JSArrayBitSource(input));
});

/**
* @constructor
*/
shannon.core.JSArrayBitSink = (function (output){
this.output = output;
})
shannon.core.JSArrayBitSink.cljs$lang$type = true;
shannon.core.JSArrayBitSink.cljs$lang$ctorStr = "shannon.core/JSArrayBitSink";
shannon.core.JSArrayBitSink.cljs$lang$ctorPrWriter = (function (this__3971__auto__,writer__3972__auto__,opt__3973__auto__){return cljs.core._write.call(null,writer__3972__auto__,"shannon.core/JSArrayBitSink");
});
shannon.core.JSArrayBitSink.prototype.shannon$core$BitCoder$ = true;
shannon.core.JSArrayBitSink.prototype.shannon$core$BitCoder$finalize_BANG_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return self__.output;
});
shannon.core.JSArrayBitSink.prototype.shannon$core$ConsumesBits$ = true;
shannon.core.JSArrayBitSink.prototype.shannon$core$ConsumesBits$write_BANG_$arity$2 = (function (_,bit){var self__ = this;
var ___$1 = this;return push(self__.output,bit);
});
shannon.core.JSArrayBitSink.prototype.shannon$core$ConsumesBits$target$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return self__.output;
});
shannon.core.__GT_JSArrayBitSink = (function __GT_JSArrayBitSink(output){return (new shannon.core.JSArrayBitSink(output));
});
shannon.core.AsBits = (function (){var obj5066 = {};return obj5066;
})();
shannon.core.bit_source = (function bit_source(o){if((function (){var and__3397__auto__ = o;if(and__3397__auto__)
{return o.shannon$core$AsBits$bit_source$arity$1;
} else
{return and__3397__auto__;
}
})())
{return o.shannon$core$AsBits$bit_source$arity$1(o);
} else
{var x__4030__auto__ = (((o == null))?null:o);return (function (){var or__3409__auto__ = (shannon.core.bit_source[goog.typeOf(x__4030__auto__)]);if(or__3409__auto__)
{return or__3409__auto__;
} else
{var or__3409__auto____$1 = (shannon.core.bit_source["_"]);if(or__3409__auto____$1)
{return or__3409__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"AsBits.bit-source",o);
}
}
})().call(null,o);
}
});
shannon.core.bit_sink = (function bit_sink(o){if((function (){var and__3397__auto__ = o;if(and__3397__auto__)
{return o.shannon$core$AsBits$bit_sink$arity$1;
} else
{return and__3397__auto__;
}
})())
{return o.shannon$core$AsBits$bit_sink$arity$1(o);
} else
{var x__4030__auto__ = (((o == null))?null:o);return (function (){var or__3409__auto__ = (shannon.core.bit_sink[goog.typeOf(x__4030__auto__)]);if(or__3409__auto__)
{return or__3409__auto__;
} else
{var or__3409__auto____$1 = (shannon.core.bit_sink["_"]);if(or__3409__auto____$1)
{return or__3409__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"AsBits.bit-sink",o);
}
}
})().call(null,o);
}
});
shannon.core.default_bit_sink = (function default_bit_sink(){return shannon.core.bit_sink.call(null,(new shannon.core.JSArrayBitSink([])));
});
shannon.core.update_interval = (function update_interval(p__5067,p__5068){var vec__5071 = p__5067;var la = cljs.core.nth.call(null,vec__5071,0,null);var lb = cljs.core.nth.call(null,vec__5071,1,null);var vec__5072 = p__5068;var cx = cljs.core.nth.call(null,vec__5072,0,null);var dx = cljs.core.nth.call(null,vec__5072,1,null);if(cljs.core.not_any_QMARK_.call(null,cljs.core.nil_QMARK_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cx,dx], null)))
{var w = (lb - la);return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(la + shannon.compatibility.roundd.call(null,(w * (cx / shannon.core.whole)))),(la + shannon.compatibility.roundd.call(null,(w * (dx / shannon.core.whole))))], null);
} else
{return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [la,lb], null);
}
});
shannon.core.rescale_interval = (function rescale_interval(p__5073){var vec__5075 = p__5073;var a = cljs.core.nth.call(null,vec__5075,0,null);var b = cljs.core.nth.call(null,vec__5075,1,null);var a__$1 = shannon.compatibility.roundd.call(null,(shannon.core.whole * a));var b__$1 = shannon.compatibility.roundd.call(null,(shannon.core.whole * b));if((a__$1 === 0))
{return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a__$1,(b__$1 - 1)], null);
} else
{if((b__$1 === shannon.core.whole))
{return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(a__$1 + 1),b__$1], null);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(a__$1 + 1),(b__$1 - 1)], null);
} else
{return null;
}
}
}
});
shannon.core.rescaled_inverse_cdf = (function rescaled_inverse_cdf(distribution,znorm){var z = shannon.compatibility.roundd.call(null,(shannon.core.whole * znorm));var i = shannon.distributions.inverse_cdf.call(null,distribution,znorm);while(true){
var vec__5077 = shannon.core.rescale_interval.call(null,shannon.distributions.cdf.call(null,distribution,i));var a = cljs.core.nth.call(null,vec__5077,0,null);var b = cljs.core.nth.call(null,vec__5077,1,null);var interval = vec__5077;if((z < (a - 1)))
{{
var G__5078 = shannon.distributions.next_lower.call(null,distribution,i);
i = G__5078;
continue;
}
} else
{if((z > (b + 1)))
{{
var G__5079 = shannon.distributions.next_higher.call(null,distribution,i);
i = G__5079;
continue;
}
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,interval], null);
} else
{return null;
}
}
}
break;
}
});
shannon.core.emit_bits = (function emit_bits(bits,i,s){var r_5080 = !(i);shannon.core.write_BANG_.call(null,bits,i);
var j_5081 = s;while(true){
if((j_5081 > 0))
{shannon.core.write_BANG_.call(null,bits,r_5080);
{
var G__5082 = (j_5081 - 1);
j_5081 = G__5082;
continue;
}
} else
{}
break;
}
return bits;
});

/**
* @constructor
*/
shannon.core.ArithmeticCoder = (function (a,b,s,z,bits){
this.a = a;
this.b = b;
this.s = s;
this.z = z;
this.bits = bits;
})
shannon.core.ArithmeticCoder.cljs$lang$type = true;
shannon.core.ArithmeticCoder.cljs$lang$ctorStr = "shannon.core/ArithmeticCoder";
shannon.core.ArithmeticCoder.cljs$lang$ctorPrWriter = (function (this__3971__auto__,writer__3972__auto__,opt__3973__auto__){return cljs.core._write.call(null,writer__3972__auto__,"shannon.core/ArithmeticCoder");
});
shannon.core.ArithmeticCoder.prototype.shannon$core$BitCoder$ = true;
shannon.core.ArithmeticCoder.prototype.shannon$core$BitCoder$with_bits_BANG_$arity$2 = (function (_,newbits){var self__ = this;
var ___$1 = this;var i = (shannon.core.coding_precision - 1);var z__$1 = 0.0;while(true){
if((i >= 0))
{{
var G__5086 = (i - 1);
var G__5087 = (z__$1 + (cljs.core.truth_(shannon.core.read_BANG_.call(null,newbits))?shannon.compatibility.pow.call(null,2,i):0.0));
i = G__5086;
z__$1 = G__5087;
continue;
}
} else
{return (new shannon.core.ArithmeticCoder(self__.a,self__.b,self__.s,z__$1,newbits));
}
break;
}
});
shannon.core.ArithmeticCoder.prototype.shannon$core$BitCoder$finalize_BANG_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;var s__$1 = (self__.s + 1);if((self__.a <= shannon.core.quarter))
{shannon.core.emit_bits.call(null,self__.bits,false,s__$1);
} else
{shannon.core.emit_bits.call(null,self__.bits,true,s__$1);
}
shannon.core.finalize_BANG_.call(null,self__.bits);
return self__.bits;
});
shannon.core.ArithmeticCoder.prototype.shannon$core$DistributionCoder$ = true;
shannon.core.ArithmeticCoder.prototype.shannon$core$DistributionCoder$encode_symbol$arity$3 = (function (_,distribution,sym){var self__ = this;
var ___$1 = this;var vec__5083 = shannon.core.update_interval.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.a,self__.b], null),shannon.core.rescale_interval.call(null,shannon.distributions.cdf.call(null,distribution,sym)));var a__$1 = cljs.core.nth.call(null,vec__5083,0,null);var b__$1 = cljs.core.nth.call(null,vec__5083,1,null);var a__$2 = a__$1;var b__$2 = b__$1;var s__$1 = self__.s;var bits__$1 = self__.bits;while(true){
if((b__$2 < shannon.core.half))
{{
var G__5088 = (2.0 * a__$2);
var G__5089 = (2.0 * b__$2);
var G__5090 = 0;
var G__5091 = shannon.core.emit_bits.call(null,bits__$1,false,s__$1);
a__$2 = G__5088;
b__$2 = G__5089;
s__$1 = G__5090;
bits__$1 = G__5091;
continue;
}
} else
{if((a__$2 > shannon.core.half))
{{
var G__5092 = (2.0 * (a__$2 - shannon.core.half));
var G__5093 = (2.0 * (b__$2 - shannon.core.half));
var G__5094 = 0;
var G__5095 = shannon.core.emit_bits.call(null,bits__$1,true,s__$1);
a__$2 = G__5092;
b__$2 = G__5093;
s__$1 = G__5094;
bits__$1 = G__5095;
continue;
}
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{var a__$3 = a__$2;var b__$3 = b__$2;var s__$2 = s__$1;while(true){
if(((a__$3 > shannon.core.quarter)) && ((b__$3 < (shannon.core.whole - shannon.core.quarter))))
{{
var G__5096 = (2.0 * (a__$3 - shannon.core.quarter));
var G__5097 = (2.0 * (b__$3 - shannon.core.quarter));
var G__5098 = (s__$2 + 1);
a__$3 = G__5096;
b__$3 = G__5097;
s__$2 = G__5098;
continue;
}
} else
{return (new shannon.core.ArithmeticCoder(a__$3,b__$3,s__$2,self__.z,bits__$1));
}
break;
}
} else
{return null;
}
}
}
break;
}
});
shannon.core.ArithmeticCoder.prototype.shannon$core$DistributionCoder$decode_symbol$arity$2 = (function (_,distribution){var self__ = this;
var ___$1 = this;var update_z = (function update_z(z__$1,bits__$1){if(cljs.core.truth_(shannon.core.read_BANG_.call(null,bits__$1)))
{return (z__$1 + 1);
} else
{return z__$1;
}
});
var znorm = ((self__.z - self__.a) / (self__.b - self__.a));var vec__5084 = shannon.core.rescaled_inverse_cdf.call(null,distribution,znorm);var sym = cljs.core.nth.call(null,vec__5084,0,null);var cdf_interval = cljs.core.nth.call(null,vec__5084,1,null);var vec__5085 = shannon.core.update_interval.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.a,self__.b], null),cdf_interval);var a__$1 = cljs.core.nth.call(null,vec__5085,0,null);var b__$1 = cljs.core.nth.call(null,vec__5085,1,null);var a__$2 = a__$1;var b__$2 = b__$1;var z__$1 = self__.z;while(true){
if((b__$2 < shannon.core.half))
{{
var G__5099 = (2.0 * a__$2);
var G__5100 = (2.0 * b__$2);
var G__5101 = update_z.call(null,(2.0 * z__$1),self__.bits);
a__$2 = G__5099;
b__$2 = G__5100;
z__$1 = G__5101;
continue;
}
} else
{if((a__$2 > shannon.core.half))
{{
var G__5102 = (2.0 * (a__$2 - shannon.core.half));
var G__5103 = (2.0 * (b__$2 - shannon.core.half));
var G__5104 = update_z.call(null,(2.0 * (z__$1 - shannon.core.half)),self__.bits);
a__$2 = G__5102;
b__$2 = G__5103;
z__$1 = G__5104;
continue;
}
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{var a__$3 = a__$2;var b__$3 = b__$2;var z__$2 = z__$1;while(true){
if(((a__$3 > shannon.core.quarter)) && ((b__$3 < (shannon.core.whole - shannon.core.quarter))))
{{
var G__5105 = (2.0 * (a__$3 - shannon.core.quarter));
var G__5106 = (2.0 * (b__$3 - shannon.core.quarter));
var G__5107 = update_z.call(null,(2.0 * (z__$2 - shannon.core.quarter)),self__.bits);
a__$3 = G__5105;
b__$3 = G__5106;
z__$2 = G__5107;
continue;
}
} else
{return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sym,(new shannon.core.ArithmeticCoder(a__$3,b__$3,self__.s,z__$2,self__.bits))], null);
}
break;
}
} else
{return null;
}
}
}
break;
}
});
shannon.core.__GT_ArithmeticCoder = (function __GT_ArithmeticCoder(a,b,s,z,bits){return (new shannon.core.ArithmeticCoder(a,b,s,z,bits));
});

/**
* @constructor
*/
shannon.core.StatefulCoder = (function (coder){
this.coder = coder;
})
shannon.core.StatefulCoder.cljs$lang$type = true;
shannon.core.StatefulCoder.cljs$lang$ctorStr = "shannon.core/StatefulCoder";
shannon.core.StatefulCoder.cljs$lang$ctorPrWriter = (function (this__3971__auto__,writer__3972__auto__,opt__3973__auto__){return cljs.core._write.call(null,writer__3972__auto__,"shannon.core/StatefulCoder");
});
shannon.core.StatefulCoder.prototype.shannon$core$BitCoder$ = true;
shannon.core.StatefulCoder.prototype.shannon$core$BitCoder$finalize_BANG_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return shannon.core.finalize_BANG_.call(null,cljs.core.deref.call(null,self__.coder));
});
shannon.core.StatefulCoder.prototype.shannon$core$DistributionCoder$ = true;
shannon.core.StatefulCoder.prototype.shannon$core$DistributionCoder$encode_symbol$arity$3 = (function (_,distribution,sym){var self__ = this;
var ___$1 = this;return cljs.core.swap_BANG_.call(null,self__.coder,(function (coder__$1){return shannon.core.encode_symbol.call(null,coder__$1,distribution,sym);
}));
});
shannon.core.StatefulCoder.prototype.shannon$core$DistributionCoder$decode_symbol$arity$2 = (function (_,distribution){var self__ = this;
var ___$1 = this;var sym = cljs.core.atom.call(null,null);cljs.core.swap_BANG_.call(null,self__.coder,(function (coder__$1){var vec__5108 = shannon.core.decode_symbol.call(null,coder__$1,distribution);var s = cljs.core.nth.call(null,vec__5108,0,null);var c = cljs.core.nth.call(null,vec__5108,1,null);cljs.core.reset_BANG_.call(null,sym,s);
return c;
}));
return cljs.core.deref.call(null,sym);
});
shannon.core.__GT_StatefulCoder = (function __GT_StatefulCoder(coder){return (new shannon.core.StatefulCoder(coder));
});
shannon.core.empty_coder = (function() {
var empty_coder = null;
var empty_coder__0 = (function (){return (new shannon.core.ArithmeticCoder(0.0,shannon.core.whole,0,0.0,null));
});
var empty_coder__1 = (function (bit_io){return (new shannon.core.ArithmeticCoder(0.0,shannon.core.whole,0,0.0,bit_io));
});
empty_coder = function(bit_io){
switch(arguments.length){
case 0:
return empty_coder__0.call(this);
case 1:
return empty_coder__1.call(this,bit_io);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
empty_coder.cljs$core$IFn$_invoke$arity$0 = empty_coder__0;
empty_coder.cljs$core$IFn$_invoke$arity$1 = empty_coder__1;
return empty_coder;
})()
;
shannon.core.input_stateful_coder = (function input_stateful_coder(source){return (new shannon.core.StatefulCoder(cljs.core.atom.call(null,shannon.core.with_bits_BANG_.call(null,shannon.core.empty_coder.call(null),source))));
});
shannon.core.output_stateful_coder = (function() {
var output_stateful_coder = null;
var output_stateful_coder__0 = (function (){return (new shannon.core.StatefulCoder(cljs.core.atom.call(null,shannon.core.empty_coder.call(null,shannon.core.default_bit_sink.call(null)))));
});
var output_stateful_coder__1 = (function (sink){return (new shannon.core.StatefulCoder(cljs.core.atom.call(null,shannon.core.empty_coder.call(null,sink))));
});
output_stateful_coder = function(sink){
switch(arguments.length){
case 0:
return output_stateful_coder__0.call(this);
case 1:
return output_stateful_coder__1.call(this,sink);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
output_stateful_coder.cljs$core$IFn$_invoke$arity$0 = output_stateful_coder__0;
output_stateful_coder.cljs$core$IFn$_invoke$arity$1 = output_stateful_coder__1;
return output_stateful_coder;
})()
;
shannon.core.Codeable = (function (){var obj5110 = {};return obj5110;
})();
shannon.core.encode = (function() {
var encode = null;
var encode__2 = (function (o,scoder){if((function (){var and__3397__auto__ = o;if(and__3397__auto__)
{return o.shannon$core$Codeable$encode$arity$2;
} else
{return and__3397__auto__;
}
})())
{return o.shannon$core$Codeable$encode$arity$2(o,scoder);
} else
{var x__4030__auto__ = (((o == null))?null:o);return (function (){var or__3409__auto__ = (shannon.core.encode[goog.typeOf(x__4030__auto__)]);if(or__3409__auto__)
{return or__3409__auto__;
} else
{var or__3409__auto____$1 = (shannon.core.encode["_"]);if(or__3409__auto____$1)
{return or__3409__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Codeable.encode",o);
}
}
})().call(null,o,scoder);
}
});
var encode__3 = (function (o,scoder,sym){if((function (){var and__3397__auto__ = o;if(and__3397__auto__)
{return o.shannon$core$Codeable$encode$arity$3;
} else
{return and__3397__auto__;
}
})())
{return o.shannon$core$Codeable$encode$arity$3(o,scoder,sym);
} else
{var x__4030__auto__ = (((o == null))?null:o);return (function (){var or__3409__auto__ = (shannon.core.encode[goog.typeOf(x__4030__auto__)]);if(or__3409__auto__)
{return or__3409__auto__;
} else
{var or__3409__auto____$1 = (shannon.core.encode["_"]);if(or__3409__auto____$1)
{return or__3409__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Codeable.encode",o);
}
}
})().call(null,o,scoder,sym);
}
});
var encode__4 = (function (o,scoder,sym,typehint){if((function (){var and__3397__auto__ = o;if(and__3397__auto__)
{return o.shannon$core$Codeable$encode$arity$4;
} else
{return and__3397__auto__;
}
})())
{return o.shannon$core$Codeable$encode$arity$4(o,scoder,sym,typehint);
} else
{var x__4030__auto__ = (((o == null))?null:o);return (function (){var or__3409__auto__ = (shannon.core.encode[goog.typeOf(x__4030__auto__)]);if(or__3409__auto__)
{return or__3409__auto__;
} else
{var or__3409__auto____$1 = (shannon.core.encode["_"]);if(or__3409__auto____$1)
{return or__3409__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Codeable.encode",o);
}
}
})().call(null,o,scoder,sym,typehint);
}
});
encode = function(o,scoder,sym,typehint){
switch(arguments.length){
case 2:
return encode__2.call(this,o,scoder);
case 3:
return encode__3.call(this,o,scoder,sym);
case 4:
return encode__4.call(this,o,scoder,sym,typehint);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
encode.cljs$core$IFn$_invoke$arity$2 = encode__2;
encode.cljs$core$IFn$_invoke$arity$3 = encode__3;
encode.cljs$core$IFn$_invoke$arity$4 = encode__4;
return encode;
})()
;
shannon.core.decode = (function decode(o,scoder){if((function (){var and__3397__auto__ = o;if(and__3397__auto__)
{return o.shannon$core$Codeable$decode$arity$2;
} else
{return and__3397__auto__;
}
})())
{return o.shannon$core$Codeable$decode$arity$2(o,scoder);
} else
{var x__4030__auto__ = (((o == null))?null:o);return (function (){var or__3409__auto__ = (shannon.core.decode[goog.typeOf(x__4030__auto__)]);if(or__3409__auto__)
{return or__3409__auto__;
} else
{var or__3409__auto____$1 = (shannon.core.decode["_"]);if(or__3409__auto____$1)
{return or__3409__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Codeable.decode",o);
}
}
})().call(null,o,scoder);
}
});

/**
* @constructor
*/
shannon.core.AtomCoder = (function (distribution){
this.distribution = distribution;
})
shannon.core.AtomCoder.cljs$lang$type = true;
shannon.core.AtomCoder.cljs$lang$ctorStr = "shannon.core/AtomCoder";
shannon.core.AtomCoder.cljs$lang$ctorPrWriter = (function (this__3971__auto__,writer__3972__auto__,opt__3973__auto__){return cljs.core._write.call(null,writer__3972__auto__,"shannon.core/AtomCoder");
});
shannon.core.AtomCoder.prototype.shannon$core$Codeable$ = true;
shannon.core.AtomCoder.prototype.shannon$core$Codeable$encode$arity$3 = (function (_,scoder,sym){var self__ = this;
var ___$1 = this;return shannon.core.encode_symbol.call(null,scoder,self__.distribution,sym);
});
shannon.core.AtomCoder.prototype.shannon$core$Codeable$decode$arity$2 = (function (_,scoder){var self__ = this;
var ___$1 = this;return shannon.core.decode_symbol.call(null,scoder,self__.distribution);
});
shannon.core.__GT_AtomCoder = (function __GT_AtomCoder(distribution){return (new shannon.core.AtomCoder(distribution));
});
shannon.core.uniform = (function uniform(N){return (new shannon.core.AtomCoder(shannon.distributions.uniform_distribution.call(null,N)));
});
shannon.core.zipf = (function zipf(N){return (new shannon.core.AtomCoder(shannon.distributions.zipf_distribution.call(null,N)));
});
shannon.core.geometric = (function geometric(mu){return (new shannon.core.AtomCoder(shannon.distributions.geometric_distribution.call(null,mu)));
});
shannon.core.benford = (function benford(base,digits){return (new shannon.core.AtomCoder(shannon.distributions.benford_distribution.call(null,base,digits)));
});
shannon.core.custom = (function custom(options){return (new shannon.core.AtomCoder(shannon.distributions.custom_distribution.call(null,options)));
});
shannon.core.constant = (function constant(value){return (new shannon.core.AtomCoder(shannon.distributions.constant_distribution.call(null,value)));
});

/**
* @constructor
*/
shannon.core.FixedArrayCoder = (function (coders){
this.coders = coders;
})
shannon.core.FixedArrayCoder.cljs$lang$type = true;
shannon.core.FixedArrayCoder.cljs$lang$ctorStr = "shannon.core/FixedArrayCoder";
shannon.core.FixedArrayCoder.cljs$lang$ctorPrWriter = (function (this__3971__auto__,writer__3972__auto__,opt__3973__auto__){return cljs.core._write.call(null,writer__3972__auto__,"shannon.core/FixedArrayCoder");
});
shannon.core.FixedArrayCoder.prototype.shannon$core$Codeable$ = true;
shannon.core.FixedArrayCoder.prototype.shannon$core$Codeable$encode$arity$3 = (function (_,scoder,syms){var self__ = this;
var ___$1 = this;var c = self__.coders;var s = syms;while(true){
if(cljs.core.truth_(c))
{shannon.core.encode.call(null,cljs.core.first.call(null,c),scoder,cljs.core.first.call(null,s));
{
var G__5111 = cljs.core.next.call(null,c);
var G__5112 = cljs.core.next.call(null,s);
c = G__5111;
s = G__5112;
continue;
}
} else
{return null;
}
break;
}
});
shannon.core.FixedArrayCoder.prototype.shannon$core$Codeable$decode$arity$2 = (function (_,scoder){var self__ = this;
var ___$1 = this;return cljs.core.map.call(null,(function (c){return shannon.core.decode.call(null,c,scoder);
}),self__.coders);
});
shannon.core.__GT_FixedArrayCoder = (function __GT_FixedArrayCoder(coders){return (new shannon.core.FixedArrayCoder(coders));
});
shannon.core.fixed_array = (function fixed_array(coders){return (new shannon.core.FixedArrayCoder(coders));
});
shannon.core.uint32coder = shannon.core.zipf.call(null,4.294967296E9);
shannon.core.uniform_uint32coder = shannon.core.uniform.call(null,4.294967296E9);
shannon.core.lencoder = shannon.core.custom.call(null,new cljs.core.PersistentArrayMap(null, 2, [1,0.6,2,0.4], null));
shannon.core.short64coder = shannon.core.uint32coder;
shannon.core.long64coder = shannon.core.fixed_array.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [shannon.core.uniform_uint32coder,shannon.core.uint32coder], null));

/**
* @constructor
*/
shannon.core.UInt64Coder = (function (){
})
shannon.core.UInt64Coder.cljs$lang$type = true;
shannon.core.UInt64Coder.cljs$lang$ctorStr = "shannon.core/UInt64Coder";
shannon.core.UInt64Coder.cljs$lang$ctorPrWriter = (function (this__3971__auto__,writer__3972__auto__,opt__3973__auto__){return cljs.core._write.call(null,writer__3972__auto__,"shannon.core/UInt64Coder");
});
shannon.core.UInt64Coder.prototype.shannon$core$Codeable$ = true;
shannon.core.UInt64Coder.prototype.shannon$core$Codeable$encode$arity$3 = (function (_,scoder,sym){var self__ = this;
var ___$1 = this;var arr = shannon.compatibility.num__GT_arr.call(null,shannon.compatibility.round.call(null,sym));var len = (((cljs.core.nth.call(null,arr,1) === 0))?1:2);shannon.core.encode.call(null,shannon.core.lencoder,scoder,len);
if((len > 1))
{return shannon.core.encode.call(null,shannon.core.long64coder,scoder,arr);
} else
{return shannon.core.encode.call(null,shannon.core.short64coder,scoder,cljs.core.nth.call(null,arr,0));
}
});
shannon.core.UInt64Coder.prototype.shannon$core$Codeable$decode$arity$2 = (function (_,scoder){var self__ = this;
var ___$1 = this;var len = shannon.core.decode.call(null,shannon.core.lencoder,scoder);var arr = (((len > 1))?shannon.core.decode.call(null,shannon.core.long64coder,scoder):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [shannon.core.decode.call(null,shannon.core.short64coder,scoder),0], null));return shannon.compatibility.arr__GT_num.call(null,arr);
});
shannon.core.__GT_UInt64Coder = (function __GT_UInt64Coder(){return (new shannon.core.UInt64Coder());
});
shannon.core.uint64coder = (new shannon.core.UInt64Coder());

/**
* @constructor
*/
shannon.core.TransformCoder = (function (coder,encodefn,decodefn){
this.coder = coder;
this.encodefn = encodefn;
this.decodefn = decodefn;
})
shannon.core.TransformCoder.cljs$lang$type = true;
shannon.core.TransformCoder.cljs$lang$ctorStr = "shannon.core/TransformCoder";
shannon.core.TransformCoder.cljs$lang$ctorPrWriter = (function (this__3971__auto__,writer__3972__auto__,opt__3973__auto__){return cljs.core._write.call(null,writer__3972__auto__,"shannon.core/TransformCoder");
});
shannon.core.TransformCoder.prototype.shannon$core$Codeable$ = true;
shannon.core.TransformCoder.prototype.shannon$core$Codeable$encode$arity$3 = (function (_,scoder,sym){var self__ = this;
var ___$1 = this;return shannon.core.encode.call(null,self__.coder,scoder,self__.encodefn.call(null,sym));
});
shannon.core.TransformCoder.prototype.shannon$core$Codeable$decode$arity$2 = (function (_,scoder){var self__ = this;
var ___$1 = this;return self__.decodefn.call(null,shannon.core.decode.call(null,self__.coder,scoder));
});
shannon.core.__GT_TransformCoder = (function __GT_TransformCoder(coder,encodefn,decodefn){return (new shannon.core.TransformCoder(coder,encodefn,decodefn));
});
shannon.core.transform = (function transform(coder,encodefn,decodefn){return (new shannon.core.TransformCoder(coder,encodefn,decodefn));
});
shannon.core.offset_zipf = (function offset_zipf(low,mid,high){var total_range = ((high - low) + 1);var high_range = ((high - mid) + 1);var low_range = (mid - low);var low_coder = shannon.core.transform.call(null,shannon.core.zipf.call(null,low_range),((function (total_range,high_range,low_range){
return (function (p1__5113_SHARP_){return ((mid - p1__5113_SHARP_) - 1);
});})(total_range,high_range,low_range))
,((function (total_range,high_range,low_range){
return (function (p1__5114_SHARP_){return (mid - (p1__5114_SHARP_ + 1));
});})(total_range,high_range,low_range))
);var high_coder = shannon.core.transform.call(null,shannon.core.zipf.call(null,high_range),((function (total_range,high_range,low_range,low_coder){
return (function (p1__5115_SHARP_){return (p1__5115_SHARP_ - mid);
});})(total_range,high_range,low_range,low_coder))
,((function (total_range,high_range,low_range,low_coder){
return (function (p1__5116_SHARP_){return (p1__5116_SHARP_ + mid);
});})(total_range,high_range,low_range,low_coder))
);var coders5127 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"else","else",1017020587),high_coder,new cljs.core.Keyword(null,"low","low",1014011590),low_coder], null);var flag5128 = shannon.core.custom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"else","else",1017020587),(high_range / total_range),new cljs.core.Keyword(null,"low","low",1014011590),(low_range / total_range)], null));if(typeof shannon.core.t5133 !== 'undefined')
{} else
{
/**
* @constructor
*/
shannon.core.t5133 = (function (total_range,flag5128,high,coders5127,mid,offset_zipf,low_coder,low,high_coder,low_range,high_range,meta5134){
this.total_range = total_range;
this.flag5128 = flag5128;
this.high = high;
this.coders5127 = coders5127;
this.mid = mid;
this.offset_zipf = offset_zipf;
this.low_coder = low_coder;
this.low = low;
this.high_coder = high_coder;
this.low_range = low_range;
this.high_range = high_range;
this.meta5134 = meta5134;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
shannon.core.t5133.cljs$lang$type = true;
shannon.core.t5133.cljs$lang$ctorStr = "shannon.core/t5133";
shannon.core.t5133.cljs$lang$ctorPrWriter = (function (this__3971__auto__,writer__3972__auto__,opt__3973__auto__){return cljs.core._write.call(null,writer__3972__auto__,"shannon.core/t5133");
});
shannon.core.t5133.prototype.shannon$core$Codeable$ = true;
shannon.core.t5133.prototype.shannon$core$Codeable$encode$arity$4 = (function (this5131,scoder5129,sym5130,typehint5132){var self__ = this;
var this5131__$1 = this;shannon.core.encode.call(null,self__.flag5128,scoder5129,typehint5132);
return shannon.core.encode.call(null,self__.coders5127.call(null,typehint5132),scoder5129,sym5130);
});
shannon.core.t5133.prototype.shannon$core$Codeable$encode$arity$3 = (function (this5131,scoder5129,sym5130){var self__ = this;
var this5131__$1 = this;if((function (p1__5117_SHARP_){return (p1__5117_SHARP_ < self__.mid);
}).call(null,sym5130))
{return shannon.core.encode.call(null,this5131__$1,scoder5129,sym5130,new cljs.core.Keyword(null,"low","low",1014011590));
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{shannon.core.encode.call(null,self__.flag5128,scoder5129,new cljs.core.Keyword(null,"else","else",1017020587));
return shannon.core.encode.call(null,self__.high_coder,scoder5129,sym5130);
} else
{return null;
}
}
});
shannon.core.t5133.prototype.shannon$core$Codeable$decode$arity$2 = (function (this5131,scoder5129){var self__ = this;
var this5131__$1 = this;var k__4567__auto__ = shannon.core.decode.call(null,self__.flag5128,scoder5129);return shannon.core.decode.call(null,(function (){var or__3409__auto__ = self__.coders5127.call(null,k__4567__auto__);if(cljs.core.truth_(or__3409__auto__))
{return or__3409__auto__;
} else
{return self__.high_coder;
}
})(),scoder5129);
});
shannon.core.t5133.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_5135){var self__ = this;
var _5135__$1 = this;return self__.meta5134;
});
shannon.core.t5133.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_5135,meta5134__$1){var self__ = this;
var _5135__$1 = this;return (new shannon.core.t5133(self__.total_range,self__.flag5128,self__.high,self__.coders5127,self__.mid,self__.offset_zipf,self__.low_coder,self__.low,self__.high_coder,self__.low_range,self__.high_range,meta5134__$1));
});
shannon.core.__GT_t5133 = (function __GT_t5133(total_range__$1,flag5128__$1,high__$1,coders5127__$1,mid__$1,offset_zipf__$1,low_coder__$1,low__$1,high_coder__$1,low_range__$1,high_range__$1,meta5134){return (new shannon.core.t5133(total_range__$1,flag5128__$1,high__$1,coders5127__$1,mid__$1,offset_zipf__$1,low_coder__$1,low__$1,high_coder__$1,low_range__$1,high_range__$1,meta5134));
});
}
return (new shannon.core.t5133(total_range,flag5128,high,coders5127,mid,offset_zipf,low_coder,low,high_coder,low_range,high_range,null));
});
shannon.core.int32coder = shannon.core.offset_zipf.call(null,(- 2.147483648E9),0,(2.147483648E9 - 1));
shannon.core.signcoder = shannon.core.uniform.call(null,2);

/**
* @constructor
*/
shannon.core.SignCoder = (function (numcoder){
this.numcoder = numcoder;
})
shannon.core.SignCoder.cljs$lang$type = true;
shannon.core.SignCoder.cljs$lang$ctorStr = "shannon.core/SignCoder";
shannon.core.SignCoder.cljs$lang$ctorPrWriter = (function (this__3971__auto__,writer__3972__auto__,opt__3973__auto__){return cljs.core._write.call(null,writer__3972__auto__,"shannon.core/SignCoder");
});
shannon.core.SignCoder.prototype.shannon$core$Codeable$ = true;
shannon.core.SignCoder.prototype.shannon$core$Codeable$encode$arity$3 = (function (_,scoder,sym){var self__ = this;
var ___$1 = this;var sign = (((sym < 0))?1:0);shannon.core.encode.call(null,shannon.core.signcoder,scoder,sign);
return shannon.core.encode.call(null,self__.numcoder,scoder,shannon.compatibility.abs.call(null,sym));
});
shannon.core.SignCoder.prototype.shannon$core$Codeable$decode$arity$2 = (function (_,scoder){var self__ = this;
var ___$1 = this;var sign = shannon.core.decode.call(null,shannon.core.signcoder,scoder);var num = shannon.core.decode.call(null,self__.numcoder,scoder);if((sign > 0))
{return (- num);
} else
{return num;
}
});
shannon.core.__GT_SignCoder = (function __GT_SignCoder(numcoder){return (new shannon.core.SignCoder(numcoder));
});
shannon.core.signed = (function signed(coder){return (new shannon.core.SignCoder(coder));
});
shannon.core.int32coder = shannon.core.signed.call(null,shannon.core.uint32coder);
shannon.core.int64coder = shannon.core.signed.call(null,shannon.core.uint64coder);
shannon.core.split_float64 = (function split_float64(x){var vec__5138 = shannon.compatibility.get_float_parts.call(null,x);var m = cljs.core.nth.call(null,vec__5138,0,null);var e = cljs.core.nth.call(null,vec__5138,1,null);var vec__5139 = shannon.compatibility.num__GT_arr.call(null,m);var l32 = cljs.core.nth.call(null,vec__5139,0,null);var h21 = cljs.core.nth.call(null,vec__5139,1,null);return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(e + 51),h21,l32], null);
});
shannon.core.join_float64 = (function join_float64(e,h21,l32){var m = shannon.compatibility.arr__GT_num.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [l32,h21], null));if((e === -1023))
{return (m * 4.9E-324);
} else
{return (shannon.compatibility.pow.call(null,2,e) + (shannon.compatibility.pow.call(null,2,(e - 52)) * m));
}
});
shannon.core.small_pr = (1 / 4.294967296E9);
shannon.core.exp = shannon.core.offset_zipf.call(null,-1023,0,1024);
shannon.core.unif_h21 = shannon.core.uniform.call(null,2097152.0);
shannon.core.unif_l32 = shannon.core.uniform.call(null,4.294967296E9);
shannon.core.mcoder = shannon.core.fixed_array.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [shannon.core.unif_h21,shannon.core.unif_l32], null));

/**
* @constructor
*/
shannon.core.UDoubleCoder = (function (){
})
shannon.core.UDoubleCoder.cljs$lang$type = true;
shannon.core.UDoubleCoder.cljs$lang$ctorStr = "shannon.core/UDoubleCoder";
shannon.core.UDoubleCoder.cljs$lang$ctorPrWriter = (function (this__3971__auto__,writer__3972__auto__,opt__3973__auto__){return cljs.core._write.call(null,writer__3972__auto__,"shannon.core/UDoubleCoder");
});
shannon.core.UDoubleCoder.prototype.shannon$core$Codeable$ = true;
shannon.core.UDoubleCoder.prototype.shannon$core$Codeable$encode$arity$3 = (function (_,scoder,sym){var self__ = this;
var ___$1 = this;if(cljs.core.truth_(shannon.compatibility.is_nan_QMARK_.call(null,sym)))
{shannon.core.encode.call(null,shannon.core.exp,scoder,1024);
return shannon.core.encode.call(null,shannon.core.mcoder,scoder,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [0,1], null));
} else
{if(shannon.compatibility.is_infinite_QMARK_.call(null,sym))
{shannon.core.encode.call(null,shannon.core.exp,scoder,1024);
return shannon.core.encode.call(null,shannon.core.mcoder,scoder,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [0,0], null));
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{var vec__5140 = shannon.core.split_float64.call(null,sym);var e = cljs.core.nth.call(null,vec__5140,0,null);var h21 = cljs.core.nth.call(null,vec__5140,1,null);var l32 = cljs.core.nth.call(null,vec__5140,2,null);shannon.core.encode.call(null,shannon.core.exp,scoder,e);
return shannon.core.encode.call(null,shannon.core.mcoder,scoder,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [h21,l32], null));
} else
{return null;
}
}
}
});
shannon.core.UDoubleCoder.prototype.shannon$core$Codeable$decode$arity$2 = (function (_,scoder){var self__ = this;
var ___$1 = this;var e = shannon.core.decode.call(null,shannon.core.exp,scoder);var vec__5141 = shannon.core.decode.call(null,shannon.core.mcoder,scoder);var h21 = cljs.core.nth.call(null,vec__5141,0,null);var l32 = cljs.core.nth.call(null,vec__5141,1,null);if((e === 1024))
{if((l32 === 0))
{return shannon.compatibility.fInfinity;
} else
{return shannon.compatibility.fNaN;
}
} else
{return shannon.core.join_float64.call(null,e,h21,l32);
}
});
shannon.core.__GT_UDoubleCoder = (function __GT_UDoubleCoder(){return (new shannon.core.UDoubleCoder());
});
shannon.core.doublecoder = shannon.core.signed.call(null,(new shannon.core.UDoubleCoder()));
shannon.core.booleancoder = shannon.core.custom.call(null,new cljs.core.PersistentArrayMap(null, 2, [true,0.5,false,0.5], null));
shannon.core.one_indexed = (function one_indexed(coder){return shannon.core.transform.call(null,coder,cljs.core.dec,cljs.core.inc);
});
shannon.core.year = shannon.core.offset_zipf.call(null,0,2015,9999);
shannon.core.month = shannon.core.one_indexed.call(null,shannon.core.uniform.call(null,12));
shannon.core.days_in_month = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"normal","normal",4269125721),new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, [31,28,31,30,31,30,31,31,30,31,30,31], null),new cljs.core.Keyword(null,"leap","leap",1017221850),new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, [31,29,31,30,31,30,31,31,30,31,30,31], null)], null);
shannon.core.days = cljs.core.apply.call(null,cljs.core.conj,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,(function (d){return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [d,shannon.core.one_indexed.call(null,shannon.core.uniform.call(null,d))], null);
}),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [28,29,30,31], null)));
shannon.core.hours = shannon.core.uniform.call(null,24);
shannon.core.minutes = shannon.core.uniform.call(null,60);
shannon.core.seconds_59 = shannon.core.uniform.call(null,60);
shannon.core.seconds_60 = shannon.core.uniform.call(null,61);
shannon.core.milliseconds = shannon.core.uniform.call(null,1000);
shannon.core.leap_year_QMARK_ = (function leap_year_QMARK_(year){return (((year & 3) === 0)) && ((!((cljs.core.mod.call(null,year,25) === 0))) || (((year & 15) === 0)));
});
shannon.core.day_coder = (function day_coder(year,month){var num_days = cljs.core.nth.call(null,cljs.core.get.call(null,shannon.core.days_in_month,((shannon.core.leap_year_QMARK_.call(null,year))?new cljs.core.Keyword(null,"leap","leap",1017221850):new cljs.core.Keyword(null,"normal","normal",4269125721))),(month - 1));return cljs.core.get.call(null,shannon.core.days,num_days);
});
shannon.core.sec_coder = (function sec_coder(mins){if((mins === 59))
{return shannon.core.seconds_60;
} else
{return shannon.core.seconds_59;
}
});

/**
* @constructor
*/
shannon.core.UTCDateCoder = (function (){
})
shannon.core.UTCDateCoder.cljs$lang$type = true;
shannon.core.UTCDateCoder.cljs$lang$ctorStr = "shannon.core/UTCDateCoder";
shannon.core.UTCDateCoder.cljs$lang$ctorPrWriter = (function (this__3971__auto__,writer__3972__auto__,opt__3973__auto__){return cljs.core._write.call(null,writer__3972__auto__,"shannon.core/UTCDateCoder");
});
shannon.core.UTCDateCoder.prototype.shannon$core$Codeable$ = true;
shannon.core.UTCDateCoder.prototype.shannon$core$Codeable$encode$arity$3 = (function (_,scoder,sym){var self__ = this;
var ___$1 = this;var vec__5142 = shannon.compatibility.decompose_date.call(null,sym);var yr = cljs.core.nth.call(null,vec__5142,0,null);var mo = cljs.core.nth.call(null,vec__5142,1,null);var d = cljs.core.nth.call(null,vec__5142,2,null);var hr = cljs.core.nth.call(null,vec__5142,3,null);var mn = cljs.core.nth.call(null,vec__5142,4,null);var s = cljs.core.nth.call(null,vec__5142,5,null);var ms = cljs.core.nth.call(null,vec__5142,6,null);shannon.core.encode.call(null,shannon.core.year,scoder,yr);
shannon.core.encode.call(null,shannon.core.month,scoder,mo);
shannon.core.encode.call(null,shannon.core.day_coder.call(null,yr,mo),scoder,d);
shannon.core.encode.call(null,shannon.core.hours,scoder,hr);
shannon.core.encode.call(null,shannon.core.minutes,scoder,mn);
shannon.core.encode.call(null,shannon.core.sec_coder.call(null,mn),scoder,s);
return shannon.core.encode.call(null,shannon.core.milliseconds,scoder,ms);
});
shannon.core.UTCDateCoder.prototype.shannon$core$Codeable$decode$arity$2 = (function (_,scoder){var self__ = this;
var ___$1 = this;var yr = shannon.core.decode.call(null,shannon.core.year,scoder);var mo = shannon.core.decode.call(null,shannon.core.month,scoder);var d = shannon.core.decode.call(null,shannon.core.day_coder.call(null,yr,mo),scoder);var hr = shannon.core.decode.call(null,shannon.core.hours,scoder);var mn = shannon.core.decode.call(null,shannon.core.minutes,scoder);var s = shannon.core.decode.call(null,shannon.core.sec_coder.call(null,mn),scoder);var ms = shannon.core.decode.call(null,shannon.core.milliseconds,scoder);return shannon.compatibility.recompose_date.call(null,yr,mo,d,hr,mn,s,ms);
});
shannon.core.__GT_UTCDateCoder = (function __GT_UTCDateCoder(){return (new shannon.core.UTCDateCoder());
});
shannon.core.date_coder = (new shannon.core.UTCDateCoder());

/**
* @constructor
*/
shannon.core.VariableArrayCoder = (function (coder,countcoder){
this.coder = coder;
this.countcoder = countcoder;
})
shannon.core.VariableArrayCoder.cljs$lang$type = true;
shannon.core.VariableArrayCoder.cljs$lang$ctorStr = "shannon.core/VariableArrayCoder";
shannon.core.VariableArrayCoder.cljs$lang$ctorPrWriter = (function (this__3971__auto__,writer__3972__auto__,opt__3973__auto__){return cljs.core._write.call(null,writer__3972__auto__,"shannon.core/VariableArrayCoder");
});
shannon.core.VariableArrayCoder.prototype.shannon$core$Codeable$ = true;
shannon.core.VariableArrayCoder.prototype.shannon$core$Codeable$encode$arity$3 = (function (_,scoder,sym){var self__ = this;
var ___$1 = this;shannon.core.encode.call(null,self__.countcoder,scoder,cljs.core.count.call(null,sym));
var seq__5143 = cljs.core.seq.call(null,sym);var chunk__5144 = null;var count__5145 = 0;var i__5146 = 0;while(true){
if((i__5146 < count__5145))
{var s = cljs.core._nth.call(null,chunk__5144,i__5146);shannon.core.encode.call(null,self__.coder,scoder,s);
{
var G__5147 = seq__5143;
var G__5148 = chunk__5144;
var G__5149 = count__5145;
var G__5150 = (i__5146 + 1);
seq__5143 = G__5147;
chunk__5144 = G__5148;
count__5145 = G__5149;
i__5146 = G__5150;
continue;
}
} else
{var temp__4092__auto__ = cljs.core.seq.call(null,seq__5143);if(temp__4092__auto__)
{var seq__5143__$1 = temp__4092__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,seq__5143__$1))
{var c__4151__auto__ = cljs.core.chunk_first.call(null,seq__5143__$1);{
var G__5151 = cljs.core.chunk_rest.call(null,seq__5143__$1);
var G__5152 = c__4151__auto__;
var G__5153 = cljs.core.count.call(null,c__4151__auto__);
var G__5154 = 0;
seq__5143 = G__5151;
chunk__5144 = G__5152;
count__5145 = G__5153;
i__5146 = G__5154;
continue;
}
} else
{var s = cljs.core.first.call(null,seq__5143__$1);shannon.core.encode.call(null,self__.coder,scoder,s);
{
var G__5155 = cljs.core.next.call(null,seq__5143__$1);
var G__5156 = null;
var G__5157 = 0;
var G__5158 = 0;
seq__5143 = G__5155;
chunk__5144 = G__5156;
count__5145 = G__5157;
i__5146 = G__5158;
continue;
}
}
} else
{return null;
}
}
break;
}
});
shannon.core.VariableArrayCoder.prototype.shannon$core$Codeable$decode$arity$2 = (function (_,scoder){var self__ = this;
var ___$1 = this;var cnt = shannon.core.decode.call(null,self__.countcoder,scoder);return cljs.core.repeatedly.call(null,cnt,(function (){return shannon.core.decode.call(null,self__.coder,scoder);
}));
});
shannon.core.__GT_VariableArrayCoder = (function __GT_VariableArrayCoder(coder,countcoder){return (new shannon.core.VariableArrayCoder(coder,countcoder));
});
shannon.core.variable_array = (function() {
var variable_array = null;
var variable_array__1 = (function (coder){return (new shannon.core.VariableArrayCoder(coder,shannon.core.uint64coder));
});
var variable_array__2 = (function (coder,countcoder){return (new shannon.core.VariableArrayCoder(coder,countcoder));
});
variable_array = function(coder,countcoder){
switch(arguments.length){
case 1:
return variable_array__1.call(this,coder);
case 2:
return variable_array__2.call(this,coder,countcoder);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
variable_array.cljs$core$IFn$_invoke$arity$1 = variable_array__1;
variable_array.cljs$core$IFn$_invoke$arity$2 = variable_array__2;
return variable_array;
})()
;

/**
* @constructor
*/
shannon.core.SparseArray = (function (maxcnt,valuecoder){
this.maxcnt = maxcnt;
this.valuecoder = valuecoder;
})
shannon.core.SparseArray.cljs$lang$type = true;
shannon.core.SparseArray.cljs$lang$ctorStr = "shannon.core/SparseArray";
shannon.core.SparseArray.cljs$lang$ctorPrWriter = (function (this__3971__auto__,writer__3972__auto__,opt__3973__auto__){return cljs.core._write.call(null,writer__3972__auto__,"shannon.core/SparseArray");
});
shannon.core.SparseArray.prototype.shannon$core$Codeable$ = true;
shannon.core.SparseArray.prototype.shannon$core$Codeable$encode$arity$3 = (function (_,scoder,sym){var self__ = this;
var ___$1 = this;var seq__5159 = cljs.core.seq.call(null,cljs.core.range.call(null,self__.maxcnt));var chunk__5160 = null;var count__5161 = 0;var i__5162 = 0;while(true){
if((i__5162 < count__5161))
{var i = cljs.core._nth.call(null,chunk__5160,i__5162);if(cljs.core.contains_QMARK_.call(null,sym,i))
{shannon.core.encode.call(null,shannon.core.booleancoder,scoder,true);
shannon.core.encode.call(null,self__.valuecoder,scoder,cljs.core.get.call(null,sym,i));
} else
{shannon.core.encode.call(null,shannon.core.booleancoder,scoder,false);
}
{
var G__5163 = seq__5159;
var G__5164 = chunk__5160;
var G__5165 = count__5161;
var G__5166 = (i__5162 + 1);
seq__5159 = G__5163;
chunk__5160 = G__5164;
count__5161 = G__5165;
i__5162 = G__5166;
continue;
}
} else
{var temp__4092__auto__ = cljs.core.seq.call(null,seq__5159);if(temp__4092__auto__)
{var seq__5159__$1 = temp__4092__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,seq__5159__$1))
{var c__4151__auto__ = cljs.core.chunk_first.call(null,seq__5159__$1);{
var G__5167 = cljs.core.chunk_rest.call(null,seq__5159__$1);
var G__5168 = c__4151__auto__;
var G__5169 = cljs.core.count.call(null,c__4151__auto__);
var G__5170 = 0;
seq__5159 = G__5167;
chunk__5160 = G__5168;
count__5161 = G__5169;
i__5162 = G__5170;
continue;
}
} else
{var i = cljs.core.first.call(null,seq__5159__$1);if(cljs.core.contains_QMARK_.call(null,sym,i))
{shannon.core.encode.call(null,shannon.core.booleancoder,scoder,true);
shannon.core.encode.call(null,self__.valuecoder,scoder,cljs.core.get.call(null,sym,i));
} else
{shannon.core.encode.call(null,shannon.core.booleancoder,scoder,false);
}
{
var G__5171 = cljs.core.next.call(null,seq__5159__$1);
var G__5172 = null;
var G__5173 = 0;
var G__5174 = 0;
seq__5159 = G__5171;
chunk__5160 = G__5172;
count__5161 = G__5173;
i__5162 = G__5174;
continue;
}
}
} else
{return null;
}
}
break;
}
});
shannon.core.SparseArray.prototype.shannon$core$Codeable$decode$arity$2 = (function (_,scoder){var self__ = this;
var ___$1 = this;var i = 0;var sarr = cljs.core.PersistentArrayMap.EMPTY;while(true){
if((i < self__.maxcnt))
{if(cljs.core.truth_(shannon.core.decode.call(null,shannon.core.booleancoder,scoder)))
{{
var G__5175 = (i + 1);
var G__5176 = cljs.core.assoc.call(null,sarr,i,shannon.core.decode.call(null,self__.valuecoder,scoder));
i = G__5175;
sarr = G__5176;
continue;
}
} else
{{
var G__5177 = (i + 1);
var G__5178 = sarr;
i = G__5177;
sarr = G__5178;
continue;
}
}
} else
{return sarr;
}
break;
}
});
shannon.core.__GT_SparseArray = (function __GT_SparseArray(maxcnt,valuecoder){return (new shannon.core.SparseArray(maxcnt,valuecoder));
});
shannon.core.sparse_array = (function sparse_array(maxcnt,valuecoder){return (new shannon.core.SparseArray(maxcnt,valuecoder));
});

/**
* @constructor
*/
shannon.core.PolymorphicCoder = (function (type_coder){
this.type_coder = type_coder;
})
shannon.core.PolymorphicCoder.cljs$lang$type = true;
shannon.core.PolymorphicCoder.cljs$lang$ctorStr = "shannon.core/PolymorphicCoder";
shannon.core.PolymorphicCoder.cljs$lang$ctorPrWriter = (function (this__3971__auto__,writer__3972__auto__,opt__3973__auto__){return cljs.core._write.call(null,writer__3972__auto__,"shannon.core/PolymorphicCoder");
});
shannon.core.PolymorphicCoder.prototype.shannon$core$Codeable$ = true;
shannon.core.PolymorphicCoder.prototype.shannon$core$Codeable$encode$arity$3 = (function (_,scoder,sym){var self__ = this;
var ___$1 = this;return shannon.core.encode.call(null,sym,scoder);
});
shannon.core.PolymorphicCoder.prototype.shannon$core$Codeable$decode$arity$2 = (function (_,scoder){var self__ = this;
var ___$1 = this;return shannon.core.decode.call(null,shannon.core.default_coder,scoder);
});
shannon.core.__GT_PolymorphicCoder = (function __GT_PolymorphicCoder(type_coder){return (new shannon.core.PolymorphicCoder(type_coder));
});
shannon.core.polymorphic = (new shannon.core.PolymorphicCoder(shannon.core.default_coder));
shannon.core.type_directory__GT_coder = (function type_directory__GT_coder(directory){var dist = cljs.core.zipmap.call(null,cljs.core.keys.call(null,directory),cljs.core.map.call(null,new cljs.core.Keyword(null,"pr","pr",1013907828),cljs.core.vals.call(null,directory)));var flag = shannon.core.custom.call(null,dist);if(typeof shannon.core.t5185 !== 'undefined')
{} else
{
/**
* @constructor
*/
shannon.core.t5185 = (function (flag,dist,directory,type_directory__GT_coder,meta5186){
this.flag = flag;
this.dist = dist;
this.directory = directory;
this.type_directory__GT_coder = type_directory__GT_coder;
this.meta5186 = meta5186;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
shannon.core.t5185.cljs$lang$type = true;
shannon.core.t5185.cljs$lang$ctorStr = "shannon.core/t5185";
shannon.core.t5185.cljs$lang$ctorPrWriter = (function (this__3971__auto__,writer__3972__auto__,opt__3973__auto__){return cljs.core._write.call(null,writer__3972__auto__,"shannon.core/t5185");
});
shannon.core.t5185.prototype.shannon$core$Codeable$ = true;
shannon.core.t5185.prototype.shannon$core$Codeable$encode$arity$4 = (function (_,scoder,sym,typehint){var self__ = this;
var ___$1 = this;shannon.core.encode.call(null,self__.flag,scoder,typehint);
return shannon.core.encode.call(null,cljs.core.get_in.call(null,self__.directory,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [typehint,new cljs.core.Keyword(null,"coder","coder",1108738967)], null)),scoder,sym);
});
shannon.core.t5185.prototype.shannon$core$Codeable$encode$arity$3 = (function (_,scoder,sym){var self__ = this;
var ___$1 = this;var specs = cljs.core.drop_while.call(null,(function (p__5189){var vec__5190 = p__5189;var k = cljs.core.nth.call(null,vec__5190,0,null);var v = cljs.core.nth.call(null,vec__5190,1,null);return cljs.core.not.call(null,v.call(null,new cljs.core.Keyword(null,"test","test",1017460740)).call(null,sym));
}),self__.directory);var vec__5188 = cljs.core.first.call(null,specs);var k = cljs.core.nth.call(null,vec__5188,0,null);var spec = cljs.core.nth.call(null,vec__5188,1,null);shannon.core.encode.call(null,self__.flag,scoder,k);
return shannon.core.encode.call(null,spec.call(null,new cljs.core.Keyword(null,"coder","coder",1108738967)),scoder,sym);
});
shannon.core.t5185.prototype.shannon$core$Codeable$decode$arity$2 = (function (_,scoder){var self__ = this;
var ___$1 = this;var k = shannon.core.decode.call(null,self__.flag,scoder);return shannon.core.decode.call(null,cljs.core.get_in.call(null,self__.directory,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,new cljs.core.Keyword(null,"coder","coder",1108738967)], null)),scoder);
});
shannon.core.t5185.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_5187){var self__ = this;
var _5187__$1 = this;return self__.meta5186;
});
shannon.core.t5185.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_5187,meta5186__$1){var self__ = this;
var _5187__$1 = this;return (new shannon.core.t5185(self__.flag,self__.dist,self__.directory,self__.type_directory__GT_coder,meta5186__$1));
});
shannon.core.__GT_t5185 = (function __GT_t5185(flag__$1,dist__$1,directory__$1,type_directory__GT_coder__$1,meta5186){return (new shannon.core.t5185(flag__$1,dist__$1,directory__$1,type_directory__GT_coder__$1,meta5186));
});
}
return (new shannon.core.t5185(flag,dist,directory,type_directory__GT_coder,null));
});
shannon.core.get_types_coder = (function get_types_coder(type_directory,types_coder){var or__3409__auto__ = cljs.core.deref.call(null,types_coder);if(cljs.core.truth_(or__3409__auto__))
{return or__3409__auto__;
} else
{return cljs.core.reset_BANG_.call(null,types_coder,shannon.core.type_directory__GT_coder.call(null,cljs.core.deref.call(null,type_directory)));
}
});

/**
* @constructor
*/
shannon.core.RegisteredTypesCoder = (function (type_directory,types_coder){
this.type_directory = type_directory;
this.types_coder = types_coder;
})
shannon.core.RegisteredTypesCoder.cljs$lang$type = true;
shannon.core.RegisteredTypesCoder.cljs$lang$ctorStr = "shannon.core/RegisteredTypesCoder";
shannon.core.RegisteredTypesCoder.cljs$lang$ctorPrWriter = (function (this__3971__auto__,writer__3972__auto__,opt__3973__auto__){return cljs.core._write.call(null,writer__3972__auto__,"shannon.core/RegisteredTypesCoder");
});
shannon.core.RegisteredTypesCoder.prototype.shannon$core$Codeable$ = true;
shannon.core.RegisteredTypesCoder.prototype.shannon$core$Codeable$encode$arity$4 = (function (_,scoder,sym,typehint){var self__ = this;
var ___$1 = this;return shannon.core.encode.call(null,shannon.core.get_types_coder.call(null,self__.type_directory,self__.types_coder),scoder,sym,typehint);
});
shannon.core.RegisteredTypesCoder.prototype.shannon$core$Codeable$encode$arity$3 = (function (_,scoder,sym){var self__ = this;
var ___$1 = this;return shannon.core.encode.call(null,shannon.core.get_types_coder.call(null,self__.type_directory,self__.types_coder),scoder,sym);
});
shannon.core.RegisteredTypesCoder.prototype.shannon$core$Codeable$decode$arity$2 = (function (_,scoder){var self__ = this;
var ___$1 = this;return shannon.core.decode.call(null,shannon.core.get_types_coder.call(null,self__.type_directory,self__.types_coder),scoder);
});
shannon.core.__GT_RegisteredTypesCoder = (function __GT_RegisteredTypesCoder(type_directory,types_coder){return (new shannon.core.RegisteredTypesCoder(type_directory,types_coder));
});
/**
* @param {...*} var_args
*/
shannon.core.register_type_BANG_ = (function() { 
var register_type_BANG___delegate = function (registry,name,p__5191){var map__5193 = p__5191;var map__5193__$1 = ((cljs.core.seq_QMARK_.call(null,map__5193))?cljs.core.apply.call(null,cljs.core.hash_map,map__5193):map__5193);var pr = cljs.core.get.call(null,map__5193__$1,new cljs.core.Keyword(null,"pr","pr",1013907828),1);var test = cljs.core.get.call(null,map__5193__$1,new cljs.core.Keyword(null,"test","test",1017460740));var coder = cljs.core.get.call(null,map__5193__$1,new cljs.core.Keyword(null,"coder","coder",1108738967));if(!(((function (){var and__3397__auto__ = registry;if(cljs.core.truth_(and__3397__auto__))
{var and__3397__auto____$1 = name;if(cljs.core.truth_(and__3397__auto____$1))
{var and__3397__auto____$2 = coder;if(cljs.core.truth_(and__3397__auto____$2))
{return test;
} else
{return and__3397__auto____$2;
}
} else
{return and__3397__auto____$1;
}
} else
{return and__3397__auto__;
}
})() == null)))
{} else
{throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"not","not",-1640422260,null),cljs.core.list(new cljs.core.Symbol(null,"nil?","nil?",-1637150201,null),cljs.core.list(new cljs.core.Symbol(null,"and","and",-1640434800,null),new cljs.core.Symbol(null,"registry","registry",1964222966,null),new cljs.core.Symbol(null,"name","name",-1637157820,null),new cljs.core.Symbol(null,"coder","coder",-1545696802,null),new cljs.core.Symbol(null,"test","test",-1636975029,null))))))].join('')));
}
cljs.core.swap_BANG_.call(null,registry.type_directory,cljs.core.assoc,name,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"pr","pr",1013907828),pr,new cljs.core.Keyword(null,"coder","coder",1108738967),coder,new cljs.core.Keyword(null,"test","test",1017460740),test], null));
return cljs.core.reset_BANG_.call(null,registry.types_coder,null);
};
var register_type_BANG_ = function (registry,name,var_args){
var p__5191 = null;if (arguments.length > 2) {
  p__5191 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);} 
return register_type_BANG___delegate.call(this,registry,name,p__5191);};
register_type_BANG_.cljs$lang$maxFixedArity = 2;
register_type_BANG_.cljs$lang$applyTo = (function (arglist__5194){
var registry = cljs.core.first(arglist__5194);
arglist__5194 = cljs.core.next(arglist__5194);
var name = cljs.core.first(arglist__5194);
var p__5191 = cljs.core.rest(arglist__5194);
return register_type_BANG___delegate(registry,name,p__5191);
});
register_type_BANG_.cljs$core$IFn$_invoke$arity$variadic = register_type_BANG___delegate;
return register_type_BANG_;
})()
;
shannon.core.unregister_type_BANG_ = (function unregister_type_BANG_(registry,name){cljs.core.swap_BANG_.call(null,registry.type_directory,cljs.core.dissoc,name);
return cljs.core.reset_BANG_.call(null,registry.types_coder,null);
});
shannon.core.default_coder = (new shannon.core.RegisteredTypesCoder(cljs.core.atom.call(null,null),cljs.core.atom.call(null,null)));
shannon.core.byte_coder = shannon.core.uniform.call(null,256);
shannon.core.bytes_coder = shannon.core.variable_array.call(null,shannon.core.byte_coder);
shannon.core.unicode_char_coder = shannon.core.transform.call(null,shannon.core.uniform.call(null,65536.0),shannon.compatibility.char__GT_int,shannon.compatibility.int__GT_char);
shannon.core.string_coder = (function string_coder(character_coder){return shannon.core.transform.call(null,shannon.core.variable_array.call(null,character_coder),(function (p1__5195_SHARP_){return cljs.core.map.call(null,cljs.core.str,p1__5195_SHARP_);
}),(function (p1__5196_SHARP_){return cljs.core.apply.call(null,cljs.core.str,p1__5196_SHARP_);
}));
});
shannon.core.unicode_coder = shannon.core.string_coder.call(null,shannon.core.unicode_char_coder);
shannon.core.unigram_coder = (function unigram_coder(unigrams,model_pr){var ucoder = shannon.core.custom.call(null,unigrams);var coders5207 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"else","else",1017020587),shannon.core.unicode_char_coder,new cljs.core.Keyword(null,"modeled","modeled",2240861434),ucoder], null);var flag5208 = shannon.core.custom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"else","else",1017020587),(1 - model_pr),new cljs.core.Keyword(null,"modeled","modeled",2240861434),model_pr], null));if(typeof shannon.core.t5213 !== 'undefined')
{} else
{
/**
* @constructor
*/
shannon.core.t5213 = (function (flag5208,coders5207,ucoder,model_pr,unigrams,unigram_coder,meta5214){
this.flag5208 = flag5208;
this.coders5207 = coders5207;
this.ucoder = ucoder;
this.model_pr = model_pr;
this.unigrams = unigrams;
this.unigram_coder = unigram_coder;
this.meta5214 = meta5214;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
shannon.core.t5213.cljs$lang$type = true;
shannon.core.t5213.cljs$lang$ctorStr = "shannon.core/t5213";
shannon.core.t5213.cljs$lang$ctorPrWriter = (function (this__3971__auto__,writer__3972__auto__,opt__3973__auto__){return cljs.core._write.call(null,writer__3972__auto__,"shannon.core/t5213");
});
shannon.core.t5213.prototype.shannon$core$Codeable$ = true;
shannon.core.t5213.prototype.shannon$core$Codeable$encode$arity$4 = (function (this5211,scoder5209,sym5210,typehint5212){var self__ = this;
var this5211__$1 = this;shannon.core.encode.call(null,self__.flag5208,scoder5209,typehint5212);
return shannon.core.encode.call(null,self__.coders5207.call(null,typehint5212),scoder5209,sym5210);
});
shannon.core.t5213.prototype.shannon$core$Codeable$encode$arity$3 = (function (this5211,scoder5209,sym5210){var self__ = this;
var this5211__$1 = this;if((function (p1__5197_SHARP_){return cljs.core.contains_QMARK_.call(null,self__.unigrams,p1__5197_SHARP_);
}).call(null,sym5210))
{return shannon.core.encode.call(null,this5211__$1,scoder5209,sym5210,new cljs.core.Keyword(null,"modeled","modeled",2240861434));
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{shannon.core.encode.call(null,self__.flag5208,scoder5209,new cljs.core.Keyword(null,"else","else",1017020587));
return shannon.core.encode.call(null,shannon.core.unicode_char_coder,scoder5209,sym5210);
} else
{return null;
}
}
});
shannon.core.t5213.prototype.shannon$core$Codeable$decode$arity$2 = (function (this5211,scoder5209){var self__ = this;
var this5211__$1 = this;var k__4567__auto__ = shannon.core.decode.call(null,self__.flag5208,scoder5209);return shannon.core.decode.call(null,(function (){var or__3409__auto__ = self__.coders5207.call(null,k__4567__auto__);if(cljs.core.truth_(or__3409__auto__))
{return or__3409__auto__;
} else
{return shannon.core.unicode_char_coder;
}
})(),scoder5209);
});
shannon.core.t5213.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_5215){var self__ = this;
var _5215__$1 = this;return self__.meta5214;
});
shannon.core.t5213.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_5215,meta5214__$1){var self__ = this;
var _5215__$1 = this;return (new shannon.core.t5213(self__.flag5208,self__.coders5207,self__.ucoder,self__.model_pr,self__.unigrams,self__.unigram_coder,meta5214__$1));
});
shannon.core.__GT_t5213 = (function __GT_t5213(flag5208__$1,coders5207__$1,ucoder__$1,model_pr__$1,unigrams__$1,unigram_coder__$1,meta5214){return (new shannon.core.t5213(flag5208__$1,coders5207__$1,ucoder__$1,model_pr__$1,unigrams__$1,unigram_coder__$1,meta5214));
});
}
return (new shannon.core.t5213(flag5208,coders5207,ucoder,model_pr,unigrams,unigram_coder,null));
});
shannon.core.language_coder = (function language_coder(unigrams,model_pr){return shannon.core.string_coder.call(null,shannon.core.unigram_coder.call(null,unigrams,model_pr));
});
shannon.core.english_coder = shannon.core.language_coder.call(null,shannon.ngrams.en.unigrams,0.98);
shannon.core.average_codepoint = (function average_codepoint(s){var sample = cljs.core.take.call(null,20,s);return (cljs.core.reduce.call(null,cljs.core._PLUS_,cljs.core.map.call(null,shannon.compatibility.char__GT_int,sample)) / (function (){var x__3716__auto__ = 1;var y__3717__auto__ = cljs.core.count.call(null,sample);return ((x__3716__auto__ > y__3717__auto__) ? x__3716__auto__ : y__3717__auto__);
})());
});
shannon.core.adaptive_string_coder = (function (){var coders5217 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"else","else",1017020587),shannon.core.unicode_coder,new cljs.core.Keyword(null,"english","english",3705114082),shannon.core.english_coder], null);var flag5218 = shannon.core.custom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"else","else",1017020587),0.2,new cljs.core.Keyword(null,"english","english",3705114082),0.8], null));if(typeof shannon.core.t5223 !== 'undefined')
{} else
{
/**
* @constructor
*/
shannon.core.t5223 = (function (flag5218,coders5217,meta5224){
this.flag5218 = flag5218;
this.coders5217 = coders5217;
this.meta5224 = meta5224;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
shannon.core.t5223.cljs$lang$type = true;
shannon.core.t5223.cljs$lang$ctorStr = "shannon.core/t5223";
shannon.core.t5223.cljs$lang$ctorPrWriter = (function (this__3971__auto__,writer__3972__auto__,opt__3973__auto__){return cljs.core._write.call(null,writer__3972__auto__,"shannon.core/t5223");
});
shannon.core.t5223.prototype.shannon$core$Codeable$ = true;
shannon.core.t5223.prototype.shannon$core$Codeable$encode$arity$4 = (function (this5221,scoder5219,sym5220,typehint5222){var self__ = this;
var this5221__$1 = this;shannon.core.encode.call(null,self__.flag5218,scoder5219,typehint5222);
return shannon.core.encode.call(null,self__.coders5217.call(null,typehint5222),scoder5219,sym5220);
});
shannon.core.t5223.prototype.shannon$core$Codeable$encode$arity$3 = (function (this5221,scoder5219,sym5220){var self__ = this;
var this5221__$1 = this;if((function (p1__5216_SHARP_){return (shannon.core.average_codepoint.call(null,p1__5216_SHARP_) < 128.0);
}).call(null,sym5220))
{return shannon.core.encode.call(null,this5221__$1,scoder5219,sym5220,new cljs.core.Keyword(null,"english","english",3705114082));
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{shannon.core.encode.call(null,self__.flag5218,scoder5219,new cljs.core.Keyword(null,"else","else",1017020587));
return shannon.core.encode.call(null,shannon.core.unicode_coder,scoder5219,sym5220);
} else
{return null;
}
}
});
shannon.core.t5223.prototype.shannon$core$Codeable$decode$arity$2 = (function (this5221,scoder5219){var self__ = this;
var this5221__$1 = this;var k__4567__auto__ = shannon.core.decode.call(null,self__.flag5218,scoder5219);return shannon.core.decode.call(null,(function (){var or__3409__auto__ = self__.coders5217.call(null,k__4567__auto__);if(cljs.core.truth_(or__3409__auto__))
{return or__3409__auto__;
} else
{return shannon.core.unicode_coder;
}
})(),scoder5219);
});
shannon.core.t5223.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_5225){var self__ = this;
var _5225__$1 = this;return self__.meta5224;
});
shannon.core.t5223.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_5225,meta5224__$1){var self__ = this;
var _5225__$1 = this;return (new shannon.core.t5223(self__.flag5218,self__.coders5217,meta5224__$1));
});
shannon.core.__GT_t5223 = (function __GT_t5223(flag5218__$1,coders5217__$1,meta5224){return (new shannon.core.t5223(flag5218__$1,coders5217__$1,meta5224));
});
}
return (new shannon.core.t5223(flag5218,coders5217,null));
})();
shannon.core.symbol_coder = shannon.core.transform.call(null,shannon.core.english_coder,cljs.core.str,cljs.core.symbol);
shannon.core.keyword_coder = shannon.core.transform.call(null,shannon.core.english_coder,(function (p1__5226_SHARP_){return cljs.core.subs.call(null,[cljs.core.str(p1__5226_SHARP_)].join(''),1);
}),cljs.core.keyword);
shannon.core.nil_coder = shannon.core.constant.call(null,null);
shannon.core.coll_coder = shannon.core.variable_array.call(null,shannon.core.polymorphic);
shannon.core.list_coder = shannon.core.transform.call(null,shannon.core.variable_array.call(null,shannon.core.polymorphic),cljs.core.identity,(function (p1__5227_SHARP_){return cljs.core.into.call(null,cljs.core.List.EMPTY,cljs.core.reverse.call(null,p1__5227_SHARP_));
}));
shannon.core.vec_coder = shannon.core.transform.call(null,shannon.core.variable_array.call(null,shannon.core.polymorphic),cljs.core.identity,cljs.core.vec);
shannon.core.map_coder = shannon.core.transform.call(null,shannon.core.variable_array.call(null,shannon.core.fixed_array.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [shannon.core.polymorphic,shannon.core.polymorphic], null))),cljs.core.identity,(function (p1__5228_SHARP_){return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,cljs.core.vec,p1__5228_SHARP_));
}));
shannon.core.set_coder = shannon.core.transform.call(null,shannon.core.variable_array.call(null,shannon.core.polymorphic),cljs.core.identity,cljs.core.set);
shannon.core.atom_pr = 1.0;
shannon.core.coll_pr = 1.0;
shannon.core.register_type_BANG_.call(null,shannon.core.default_coder,new cljs.core.Keyword(null,"nil","nil",1014013315),new cljs.core.Keyword(null,"pr","pr",1013907828),shannon.core.atom_pr,new cljs.core.Keyword(null,"coder","coder",1108738967),shannon.core.nil_coder,new cljs.core.Keyword(null,"test","test",1017460740),cljs.core.nil_QMARK_);
(shannon.core.Codeable["null"] = true);
(shannon.core.encode["null"] = (function (o5229,s5230){return shannon.core.encode.call(null,shannon.core.default_coder,s5230,o5229,new cljs.core.Keyword(null,"nil","nil",1014013315));
}));
(shannon.core.decode["null"] = (function (o5229,s5230){return shannon.core.decode.call(null,shannon.core.default_coder,s5230);
}));
shannon.core.register_type_BANG_.call(null,shannon.core.default_coder,new cljs.core.Keyword(null,"boolean","boolean",1078615962),new cljs.core.Keyword(null,"pr","pr",1013907828),shannon.core.atom_pr,new cljs.core.Keyword(null,"coder","coder",1108738967),shannon.core.booleancoder,new cljs.core.Keyword(null,"test","test",1017460740),shannon.compatibility.is_boolean_QMARK_);
(shannon.core.Codeable["boolean"] = true);
(shannon.core.encode["boolean"] = (function (o5231,s5232){return shannon.core.encode.call(null,shannon.core.default_coder,s5232,o5231,new cljs.core.Keyword(null,"boolean","boolean",1078615962));
}));
(shannon.core.decode["boolean"] = (function (o5231,s5232){return shannon.core.decode.call(null,shannon.core.default_coder,s5232);
}));
shannon.core.register_type_BANG_.call(null,shannon.core.default_coder,new cljs.core.Keyword(null,"symbol","symbol",4421347594),new cljs.core.Keyword(null,"pr","pr",1013907828),shannon.core.atom_pr,new cljs.core.Keyword(null,"coder","coder",1108738967),shannon.core.symbol_coder,new cljs.core.Keyword(null,"test","test",1017460740),cljs.core.symbol_QMARK_);
cljs.core.Symbol.prototype.shannon$core$Codeable$ = true;
cljs.core.Symbol.prototype.shannon$core$Codeable$encode$arity$2 = (function (o5233,s5234){var o5233__$1 = this;return shannon.core.encode.call(null,shannon.core.default_coder,s5234,o5233__$1,new cljs.core.Keyword(null,"symbol","symbol",4421347594));
});
cljs.core.Symbol.prototype.shannon$core$Codeable$decode$arity$2 = (function (o5233,s5234){var o5233__$1 = this;return shannon.core.decode.call(null,shannon.core.default_coder,s5234);
});
shannon.core.register_type_BANG_.call(null,shannon.core.default_coder,new cljs.core.Keyword(null,"date","date",1016980256),new cljs.core.Keyword(null,"pr","pr",1013907828),shannon.core.atom_pr,new cljs.core.Keyword(null,"coder","coder",1108738967),shannon.core.date_coder,new cljs.core.Keyword(null,"test","test",1017460740),shannon.compatibility.is_date_QMARK_);
goog.date.Date.prototype.shannon$core$Codeable$ = true;
goog.date.Date.prototype.shannon$core$Codeable$encode$arity$2 = (function (o5235,s5236){var o5235__$1 = this;return shannon.core.encode.call(null,shannon.core.default_coder,s5236,o5235__$1,new cljs.core.Keyword(null,"date","date",1016980256));
});
goog.date.Date.prototype.shannon$core$Codeable$decode$arity$2 = (function (o5235,s5236){var o5235__$1 = this;return shannon.core.decode.call(null,shannon.core.default_coder,s5236);
});
goog.date.DateTime.prototype.shannon$core$Codeable$ = true;
goog.date.DateTime.prototype.shannon$core$Codeable$encode$arity$2 = (function (o5235,s5236){var o5235__$1 = this;return shannon.core.encode.call(null,shannon.core.default_coder,s5236,o5235__$1,new cljs.core.Keyword(null,"date","date",1016980256));
});
goog.date.DateTime.prototype.shannon$core$Codeable$decode$arity$2 = (function (o5235,s5236){var o5235__$1 = this;return shannon.core.decode.call(null,shannon.core.default_coder,s5236);
});
Date.prototype.shannon$core$Codeable$ = true;
Date.prototype.shannon$core$Codeable$encode$arity$2 = (function (o5235,s5236){var o5235__$1 = this;return shannon.core.encode.call(null,shannon.core.default_coder,s5236,o5235__$1,new cljs.core.Keyword(null,"date","date",1016980256));
});
Date.prototype.shannon$core$Codeable$decode$arity$2 = (function (o5235,s5236){var o5235__$1 = this;return shannon.core.decode.call(null,shannon.core.default_coder,s5236);
});
shannon.core.register_type_BANG_.call(null,shannon.core.default_coder,new cljs.core.Keyword(null,"string","string",4416885635),new cljs.core.Keyword(null,"pr","pr",1013907828),shannon.core.atom_pr,new cljs.core.Keyword(null,"coder","coder",1108738967),shannon.core.adaptive_string_coder,new cljs.core.Keyword(null,"test","test",1017460740),cljs.core.string_QMARK_);
(shannon.core.Codeable["string"] = true);
(shannon.core.encode["string"] = (function (o5237,s5238){return shannon.core.encode.call(null,shannon.core.default_coder,s5238,o5237,new cljs.core.Keyword(null,"string","string",4416885635));
}));
(shannon.core.decode["string"] = (function (o5237,s5238){return shannon.core.decode.call(null,shannon.core.default_coder,s5238);
}));
shannon.core.register_type_BANG_.call(null,shannon.core.default_coder,new cljs.core.Keyword(null,"keyword","keyword",4494463323),new cljs.core.Keyword(null,"pr","pr",1013907828),shannon.core.atom_pr,new cljs.core.Keyword(null,"coder","coder",1108738967),shannon.core.keyword_coder,new cljs.core.Keyword(null,"test","test",1017460740),cljs.core.keyword_QMARK_);
cljs.core.Keyword.prototype.shannon$core$Codeable$ = true;
cljs.core.Keyword.prototype.shannon$core$Codeable$encode$arity$2 = (function (o5239,s5240){var o5239__$1 = this;return shannon.core.encode.call(null,shannon.core.default_coder,s5240,o5239__$1,new cljs.core.Keyword(null,"keyword","keyword",4494463323));
});
cljs.core.Keyword.prototype.shannon$core$Codeable$decode$arity$2 = (function (o5239,s5240){var o5239__$1 = this;return shannon.core.decode.call(null,shannon.core.default_coder,s5240);
});
shannon.core.register_type_BANG_.call(null,shannon.core.default_coder,new cljs.core.Keyword(null,"integer","integer",2971956400),new cljs.core.Keyword(null,"pr","pr",1013907828),shannon.core.atom_pr,new cljs.core.Keyword(null,"coder","coder",1108738967),shannon.core.int64coder,new cljs.core.Keyword(null,"test","test",1017460740),cljs.core.integer_QMARK_);
shannon.core.register_type_BANG_.call(null,shannon.core.default_coder,new cljs.core.Keyword(null,"float","float",1111430606),new cljs.core.Keyword(null,"pr","pr",1013907828),shannon.core.atom_pr,new cljs.core.Keyword(null,"coder","coder",1108738967),shannon.core.doublecoder,new cljs.core.Keyword(null,"test","test",1017460740),shannon.compatibility.is_float_QMARK_);
(shannon.core.Codeable["number"] = true);
(shannon.core.encode["number"] = (function (o,s){return shannon.core.encode.call(null,shannon.core.default_coder,s,o,((cljs.core.integer_QMARK_.call(null,o))?new cljs.core.Keyword(null,"integer","integer",2971956400):new cljs.core.Keyword(null,"float","float",1111430606)));
}));
(shannon.core.decode["number"] = (function (_,s){return shannon.core.decode.call(null,shannon.core.default_coder,s);
}));
shannon.core.register_type_BANG_.call(null,shannon.core.default_coder,new cljs.core.Keyword(null,"list","list",1017226256),new cljs.core.Keyword(null,"pr","pr",1013907828),shannon.core.coll_pr,new cljs.core.Keyword(null,"coder","coder",1108738967),shannon.core.list_coder,new cljs.core.Keyword(null,"test","test",1017460740),cljs.core.list_QMARK_);
cljs.core.List.prototype.shannon$core$Codeable$ = true;
cljs.core.List.prototype.shannon$core$Codeable$encode$arity$2 = (function (o5241,s5242){var o5241__$1 = this;return shannon.core.encode.call(null,shannon.core.default_coder,s5242,o5241__$1,new cljs.core.Keyword(null,"list","list",1017226256));
});
cljs.core.List.prototype.shannon$core$Codeable$decode$arity$2 = (function (o5241,s5242){var o5241__$1 = this;return shannon.core.decode.call(null,shannon.core.default_coder,s5242);
});
cljs.core.EmptyList.prototype.shannon$core$Codeable$ = true;
cljs.core.EmptyList.prototype.shannon$core$Codeable$encode$arity$2 = (function (o5241,s5242){var o5241__$1 = this;return shannon.core.encode.call(null,shannon.core.default_coder,s5242,o5241__$1,new cljs.core.Keyword(null,"list","list",1017226256));
});
cljs.core.EmptyList.prototype.shannon$core$Codeable$decode$arity$2 = (function (o5241,s5242){var o5241__$1 = this;return shannon.core.decode.call(null,shannon.core.default_coder,s5242);
});
cljs.core.LazySeq.prototype.shannon$core$Codeable$ = true;
cljs.core.LazySeq.prototype.shannon$core$Codeable$encode$arity$2 = (function (o5241,s5242){var o5241__$1 = this;return shannon.core.encode.call(null,shannon.core.default_coder,s5242,o5241__$1,new cljs.core.Keyword(null,"list","list",1017226256));
});
cljs.core.LazySeq.prototype.shannon$core$Codeable$decode$arity$2 = (function (o5241,s5242){var o5241__$1 = this;return shannon.core.decode.call(null,shannon.core.default_coder,s5242);
});
shannon.core.register_type_BANG_.call(null,shannon.core.default_coder,new cljs.core.Keyword(null,"vector","vector",4488484021),new cljs.core.Keyword(null,"pr","pr",1013907828),shannon.core.coll_pr,new cljs.core.Keyword(null,"coder","coder",1108738967),shannon.core.vec_coder,new cljs.core.Keyword(null,"test","test",1017460740),cljs.core.vector_QMARK_);
cljs.core.PersistentVector.prototype.shannon$core$Codeable$ = true;
cljs.core.PersistentVector.prototype.shannon$core$Codeable$encode$arity$2 = (function (o5243,s5244){var o5243__$1 = this;return shannon.core.encode.call(null,shannon.core.default_coder,s5244,o5243__$1,new cljs.core.Keyword(null,"vector","vector",4488484021));
});
cljs.core.PersistentVector.prototype.shannon$core$Codeable$decode$arity$2 = (function (o5243,s5244){var o5243__$1 = this;return shannon.core.decode.call(null,shannon.core.default_coder,s5244);
});
shannon.core.register_type_BANG_.call(null,shannon.core.default_coder,new cljs.core.Keyword(null,"map","map",1014012110),new cljs.core.Keyword(null,"pr","pr",1013907828),shannon.core.coll_pr,new cljs.core.Keyword(null,"coder","coder",1108738967),shannon.core.map_coder,new cljs.core.Keyword(null,"test","test",1017460740),cljs.core.map_QMARK_);
cljs.core.PersistentArrayMap.prototype.shannon$core$Codeable$ = true;
cljs.core.PersistentArrayMap.prototype.shannon$core$Codeable$encode$arity$2 = (function (o5245,s5246){var o5245__$1 = this;return shannon.core.encode.call(null,shannon.core.default_coder,s5246,o5245__$1,new cljs.core.Keyword(null,"map","map",1014012110));
});
cljs.core.PersistentArrayMap.prototype.shannon$core$Codeable$decode$arity$2 = (function (o5245,s5246){var o5245__$1 = this;return shannon.core.decode.call(null,shannon.core.default_coder,s5246);
});
cljs.core.PersistentHashMap.prototype.shannon$core$Codeable$ = true;
cljs.core.PersistentHashMap.prototype.shannon$core$Codeable$encode$arity$2 = (function (o5245,s5246){var o5245__$1 = this;return shannon.core.encode.call(null,shannon.core.default_coder,s5246,o5245__$1,new cljs.core.Keyword(null,"map","map",1014012110));
});
cljs.core.PersistentHashMap.prototype.shannon$core$Codeable$decode$arity$2 = (function (o5245,s5246){var o5245__$1 = this;return shannon.core.decode.call(null,shannon.core.default_coder,s5246);
});
cljs.core.TransientHashMap.prototype.shannon$core$Codeable$ = true;
cljs.core.TransientHashMap.prototype.shannon$core$Codeable$encode$arity$2 = (function (o5245,s5246){var o5245__$1 = this;return shannon.core.encode.call(null,shannon.core.default_coder,s5246,o5245__$1,new cljs.core.Keyword(null,"map","map",1014012110));
});
cljs.core.TransientHashMap.prototype.shannon$core$Codeable$decode$arity$2 = (function (o5245,s5246){var o5245__$1 = this;return shannon.core.decode.call(null,shannon.core.default_coder,s5246);
});
cljs.core.PersistentTreeMap.prototype.shannon$core$Codeable$ = true;
cljs.core.PersistentTreeMap.prototype.shannon$core$Codeable$encode$arity$2 = (function (o5245,s5246){var o5245__$1 = this;return shannon.core.encode.call(null,shannon.core.default_coder,s5246,o5245__$1,new cljs.core.Keyword(null,"map","map",1014012110));
});
cljs.core.PersistentTreeMap.prototype.shannon$core$Codeable$decode$arity$2 = (function (o5245,s5246){var o5245__$1 = this;return shannon.core.decode.call(null,shannon.core.default_coder,s5246);
});
shannon.core.register_type_BANG_.call(null,shannon.core.default_coder,new cljs.core.Keyword(null,"set","set",1014018004),new cljs.core.Keyword(null,"pr","pr",1013907828),shannon.core.coll_pr,new cljs.core.Keyword(null,"coder","coder",1108738967),shannon.core.set_coder,new cljs.core.Keyword(null,"test","test",1017460740),cljs.core.set_QMARK_);
cljs.core.PersistentHashSet.prototype.shannon$core$Codeable$ = true;
cljs.core.PersistentHashSet.prototype.shannon$core$Codeable$encode$arity$2 = (function (o5247,s5248){var o5247__$1 = this;return shannon.core.encode.call(null,shannon.core.default_coder,s5248,o5247__$1,new cljs.core.Keyword(null,"set","set",1014018004));
});
cljs.core.PersistentHashSet.prototype.shannon$core$Codeable$decode$arity$2 = (function (o5247,s5248){var o5247__$1 = this;return shannon.core.decode.call(null,shannon.core.default_coder,s5248);
});
cljs.core.TransientHashSet.prototype.shannon$core$Codeable$ = true;
cljs.core.TransientHashSet.prototype.shannon$core$Codeable$encode$arity$2 = (function (o5247,s5248){var o5247__$1 = this;return shannon.core.encode.call(null,shannon.core.default_coder,s5248,o5247__$1,new cljs.core.Keyword(null,"set","set",1014018004));
});
cljs.core.TransientHashSet.prototype.shannon$core$Codeable$decode$arity$2 = (function (o5247,s5248){var o5247__$1 = this;return shannon.core.decode.call(null,shannon.core.default_coder,s5248);
});
cljs.core.PersistentTreeSet.prototype.shannon$core$Codeable$ = true;
cljs.core.PersistentTreeSet.prototype.shannon$core$Codeable$encode$arity$2 = (function (o5247,s5248){var o5247__$1 = this;return shannon.core.encode.call(null,shannon.core.default_coder,s5248,o5247__$1,new cljs.core.Keyword(null,"set","set",1014018004));
});
cljs.core.PersistentTreeSet.prototype.shannon$core$Codeable$decode$arity$2 = (function (o5247,s5248){var o5247__$1 = this;return shannon.core.decode.call(null,shannon.core.default_coder,s5248);
});
shannon.core.with_output = (function with_output(f){var sc = shannon.core.output_stateful_coder.call(null);f.call(null,sc);
return shannon.core.target.call(null,shannon.core.finalize_BANG_.call(null,sc));
});
shannon.core.with_input = (function with_input(f,source){var sc = shannon.core.input_stateful_coder.call(null,shannon.core.bit_source.call(null,source));return f.call(null,sc);
});
shannon.core.compress = (function() {
var compress = null;
var compress__1 = (function (o){return shannon.core.with_output.call(null,(function (p1__5249_SHARP_){return shannon.core.encode.call(null,o,p1__5249_SHARP_);
}));
});
var compress__2 = (function (o,coder){return shannon.core.with_output.call(null,(function (p1__5250_SHARP_){return shannon.core.encode.call(null,coder,p1__5250_SHARP_,o);
}));
});
compress = function(o,coder){
switch(arguments.length){
case 1:
return compress__1.call(this,o);
case 2:
return compress__2.call(this,o,coder);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
compress.cljs$core$IFn$_invoke$arity$1 = compress__1;
compress.cljs$core$IFn$_invoke$arity$2 = compress__2;
return compress;
})()
;
shannon.core.decompress = (function() {
var decompress = null;
var decompress__1 = (function (source){return shannon.core.with_input.call(null,(function (p1__5251_SHARP_){return shannon.core.decode.call(null,shannon.core.default_coder,p1__5251_SHARP_);
}),source);
});
var decompress__2 = (function (source,coder){return shannon.core.with_input.call(null,(function (p1__5252_SHARP_){return shannon.core.decode.call(null,coder,p1__5252_SHARP_);
}),source);
});
decompress = function(source,coder){
switch(arguments.length){
case 1:
return decompress__1.call(this,source);
case 2:
return decompress__2.call(this,source,coder);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
decompress.cljs$core$IFn$_invoke$arity$1 = decompress__1;
decompress.cljs$core$IFn$_invoke$arity$2 = decompress__2;
return decompress;
})()
;
