// Compiled by ClojureScript 0.0-2138
goog.provide('shannon.compatibility');
goog.require('cljs.core');
goog.require('goog.date.UtcDateTime');
goog.require('goog.date');
goog.require('goog.date');
shannon.compatibility.exception = Error;
shannon.compatibility.char__GT_int = (function char__GT_int(s){return s.charCodeAt(0);
});
shannon.compatibility.int__GT_char = (function int__GT_char(i){return String.fromCharCode(i);
});
shannon.compatibility.is_float_QMARK_ = cljs.core.every_pred.call(null,cljs.core.number_QMARK_,cljs.core.comp.call(null,cljs.core.not,cljs.core.integer_QMARK_));
shannon.compatibility.is_string_QMARK_ = cljs.core.every_pred.call(null,cljs.core.string_QMARK_,cljs.core.comp.call(null,cljs.core.not,cljs.core.keyword_QMARK_));
shannon.compatibility.is_date_QMARK_ = (function is_date_QMARK_(d){return cljs.core._EQ_.call(null,cljs.core.type.call(null,d),Date);
});
shannon.compatibility.is_boolean_QMARK_ = (function is_boolean_QMARK_(x){return cljs.core._EQ_.call(null,cljs.core.boolean$.call(null,x),x);
});
shannon.compatibility.is_nan_QMARK_ = (function is_nan_QMARK_(x){return isNaN(x);
});
shannon.compatibility.is_infinite_QMARK_ = (function is_infinite_QMARK_(x){return cljs.core.not.call(null,isFinite(x));
});
shannon.compatibility.fNaN = NaN;
shannon.compatibility.fInfinity = Infinity;
shannon.compatibility.pi = Math.PI;
shannon.compatibility.pow = (function pow(n,m){return Math.pow(n,m);
});
shannon.compatibility.atan = (function atan(x){return Math.atan(x);
});
shannon.compatibility.ln = (function ln(x){return Math.log(x);
});
shannon.compatibility.sin = (function sin(x){return Math.sin(x);
});
shannon.compatibility.abs = (function abs(x){return Math.abs(x);
});
shannon.compatibility.floor = (function floor(x){return Math.floor(x);
});
shannon.compatibility.round = (function round(x){return Math.round(x);
});
shannon.compatibility.roundd = (function roundd(x){return shannon.compatibility.round.call(null,x);
});
shannon.compatibility.ceiling = (function ceiling(x){return Math.ceil(x);
});
shannon.compatibility.num__GT_arr = (function num__GT_arr(n){var mag = 4.294967296E9;return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.mod.call(null,n,mag),shannon.compatibility.floor.call(null,(n / mag))], null);
});
shannon.compatibility.arr__GT_num = (function arr__GT_num(p__5018){var vec__5020 = p__5018;var low = cljs.core.nth.call(null,vec__5020,0,null);var high = cljs.core.nth.call(null,vec__5020,1,null);return ((high * 4.294967296E9) + low);
});
shannon.compatibility.get_float_parts = (function get_float_parts(x){var mantissa = (function mantissa(exp,x__$1){return shannon.compatibility.round.call(null,(((x__$1 / shannon.compatibility.pow.call(null,2,(exp + 51))) - 1) * 4503599627370496));
});
var exponent = (function exponent(x__$1){var exp = (function (){var x__3723__auto__ = 1023;var y__3724__auto__ = (function (){var x__3716__auto__ = -1023;var y__3717__auto__ = shannon.compatibility.round.call(null,(1.4426950408889634 * shannon.compatibility.ln.call(null,x__$1)));return ((x__3716__auto__ > y__3717__auto__) ? x__3716__auto__ : y__3717__auto__);
})();return ((x__3723__auto__ < y__3724__auto__) ? x__3723__auto__ : y__3724__auto__);
})();var man = (x__$1 / shannon.compatibility.pow.call(null,2,exp));var r = man;var e = exp;while(true){
if(((e < -1022)) || ((e > 1022)))
{return (e - 51);
} else
{if((r < 1))
{{
var G__5021 = (r * 2);
var G__5022 = (e - 1);
r = G__5021;
e = G__5022;
continue;
}
} else
{if((r >= 2))
{{
var G__5023 = (r / 2);
var G__5024 = (e + 1);
r = G__5023;
e = G__5024;
continue;
}
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{return (e - 51);
} else
{return null;
}
}
}
}
break;
}
});
if((x < 2.2250738585072014E-308))
{return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [shannon.compatibility.round.call(null,(x / 4.9E-324)),-1074], null);
} else
{var exp = exponent.call(null,x);var man = mantissa.call(null,exp,x);return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [man,exp], null);
}
});
shannon.compatibility.now = (function now(){return (new Date());
});
shannon.compatibility.decompose_date = (function decompose_date(d){var d__$1 = (new goog.date.UtcDateTime(d));return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [d__$1.getFullYear(),(d__$1.getUTCMonth() + 1),d__$1.getUTCDate(),d__$1.getUTCHours(),d__$1.getUTCMinutes(),d__$1.getUTCSeconds(),d__$1.getUTCMilliseconds()], null);
});
shannon.compatibility.recompose_date = (function recompose_date(year,month,day,hours,minutes,seconds,millisec){return (new Date((new goog.date.UtcDateTime(year,(month - 1),day,hours,minutes,seconds,millisec)).getTime()));
});
shannon.compatibility.bits__GT_bytearray = (function bits__GT_bytearray(bits){var bit_place_value = (function bit_place_value(index,bit){return ((cljs.core.truth_(bit)?1:0) << (7 - index));
});
var bits__GT_byte = (function bits__GT_byte(bits__$1){var v = cljs.core.reduce.call(null,cljs.core._PLUS_,cljs.core.map_indexed.call(null,bit_place_value,bits__$1));return v;
});
var byte_bits = cljs.core.partition.call(null,8,8,cljs.core.repeat.call(null,false),bits);var a = cljs.core.map.call(null,bits__GT_byte,byte_bits);return cljs.core.to_array.call(null,a);
});
shannon.compatibility.bytearray__GT_bits = (function bytearray__GT_bits(arr){var byte__GT_bits = (function byte__GT_bits(b){var u = b;return cljs.core.map.call(null,(function (p1__5025_SHARP_){return ((u & (1 << p1__5025_SHARP_)) != 0);
}),cljs.core.reverse.call(null,cljs.core.range.call(null,8)));
});
return cljs.core.flatten.call(null,cljs.core.map.call(null,byte__GT_bits,arr));
});
