(ns shannon.compatibility
  (:require                                
                                                               
                   [goog.date :as date]
                   [goog.date.UtcDateTime])
  (                  :require-macros [shannon.macros :as m])
                                 )

                                      

;; Exceptions
(def exception
                 
         js/Error)

;; Characters (characters are strings of length one for compatibility with javascript)
(defn char->int [s]
                             
         (.charCodeAt s 0))

(defn int->char [i]
                      
         (.fromCharCode js/String i))

;; Tests
(def is-float?
              
         (every-pred number? (comp not integer?)))
(def is-string?
               
         (every-pred string? (comp not keyword?)))

                        
                         
                                  
                                             
       (defn is-date? [d] (= (type d) js/Date))

(defn is-boolean? [x]
  (= (boolean x) x))

;; Math

                                                 
       (defn is-nan? [^number x] (js/isNaN x))

                                                           
       (defn is-infinite? [^number x] (not (js/isFinite x)))

(def fNaN
                   
         js/NaN)

(def fInfinity
                   
         js/Infinity)

(def pi
               
         (.-PI js/Math))

                                     
       (defn pow [n m] (.pow js/Math n m))

                                           
       (defn atan [^number x] (.atan js/Math x))

                                        
       (defn ln [^number x] (.log js/Math x))

                                         
       (defn sin [^number x] (.sin js/Math x))

                                         
       (defn abs [^number x] (.abs js/Math x))

                                             
       (defn floor [^number x] (.floor js/Math x))

                                             
       (defn round [^number x] (.round js/Math x))

(defn roundd [^double x]
  (double (round x)))

                                              
       (defn ceiling [^number x] (.ceil js/Math x))

;; working with longs
     
                        
                                                  

      
(defn num->arr [^number n]
  (let [mag (m/pow2 32)]
    [(mod n mag) (floor (/ n mag))]))

     
                                       
                                        

      
(defn arr->num [[^number low ^number high]]
  (+ (* high (m/pow2 32)) low))

;; float processing
     
                                 
                                        
                                                     
                                           
                   
                 
                           

      
(defn get-float-parts [^number x]
  (letfn
    [(mantissa [exp x]
               (round (* (- (/ x (pow 2 (+ exp 51))) 1) 4503599627370496)))
     (exponent [x]
               (let [exp (min 1023 (max -1023 (round (* 1.4426950408889634074 (ln x)))))
                     man (/ x (pow 2 exp))]
                 (loop [r man, e exp]
                   (cond
                    (or (< e -1022) (> e 1022)) (- e 51)
                    (< r 1) (recur (* r 2) (dec e))
                    (>= r 2) (recur (/ r 2) (inc e))
                    :else (- e 51)))))]
    (if (< x 2.2250738585072014e-308)
      [(round (/ x (m/pow2 -1074))) -1074]
      (let [exp (exponent x)
            man (mantissa exp x)]
        [man exp]))))

;; Dates
(defn now []
               
         (js/Date.))

     
                        
                                                                  
                                              
                    
                     
                   
                    
                      
                      
                              

      
(defn decompose-date [d]
  (let [d (date/UtcDateTime. d)]
    [(.getFullYear d)
     (inc (.getUTCMonth d))
     (.getUTCDate d)
     (.getUTCHours d)
     (.getUTCMinutes d)
     (.getUTCSeconds d)
     (.getUTCMilliseconds d)]))

(defn recompose-date [year month day hours minutes seconds millisec]
       
                                                                          

        
  (js/Date. (.getTime (date/UtcDateTime. year (dec month) day hours minutes seconds millisec))))

(defn bits->bytearray
                     
         [bits]
  (letfn
      [(bit-place-value [index bit]
         (bit-shift-left (if bit 1 0) (- 7 index)))
       (bits->byte [bits]
         (let [v (reduce + (map-indexed bit-place-value bits))]
                                 
                  v))]
    (let
        [byte-bits (partition 8 8 (repeat false) bits)
         a (map bits->byte byte-bits)]

                          
             (to-array a))))

(defn bytearray->bits
                    
         [arr]
  (letfn
      [(byte->bits [b]
         (let [u                        b]
           (map #(bit-test u %) (reverse (range 8)))))]
    (flatten (map byte->bits arr))))

;;;;;;;;;;;; This file autogenerated from src/cljx/shannon/compatibility.cljx
