// Compiled by ClojureScript 0.0-2138
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function fn_handler(f){if(typeof cljs.core.async.t9904 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t9904 = (function (f,fn_handler,meta9905){
this.f = f;
this.fn_handler = fn_handler;
this.meta9905 = meta9905;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t9904.cljs$lang$type = true;
cljs.core.async.t9904.cljs$lang$ctorStr = "cljs.core.async/t9904";
cljs.core.async.t9904.cljs$lang$ctorPrWriter = (function (this__3971__auto__,writer__3972__auto__,opt__3973__auto__){return cljs.core._write.call(null,writer__3972__auto__,"cljs.core.async/t9904");
});
cljs.core.async.t9904.prototype.cljs$core$async$impl$protocols$Handler$ = true;
cljs.core.async.t9904.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return true;
});
cljs.core.async.t9904.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return self__.f;
});
cljs.core.async.t9904.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_9906){var self__ = this;
var _9906__$1 = this;return self__.meta9905;
});
cljs.core.async.t9904.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_9906,meta9905__$1){var self__ = this;
var _9906__$1 = this;return (new cljs.core.async.t9904(self__.f,self__.fn_handler,meta9905__$1));
});
cljs.core.async.__GT_t9904 = (function __GT_t9904(f__$1,fn_handler__$1,meta9905){return (new cljs.core.async.t9904(f__$1,fn_handler__$1,meta9905));
});
}
return (new cljs.core.async.t9904(f,fn_handler,null));
});
/**
* Returns a fixed buffer of size n. When full, puts will block/park.
*/
cljs.core.async.buffer = (function buffer(n){return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
* Returns a buffer of size n. When full, puts will complete but
* val will be dropped (no transfer).
*/
cljs.core.async.dropping_buffer = (function dropping_buffer(n){return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
* Returns a buffer of size n. When full, puts will complete, and be
* buffered, but oldest elements in buffer will be dropped (not
* transferred).
*/
cljs.core.async.sliding_buffer = (function sliding_buffer(n){return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
* Returns true if a channel created with buff will never block. That is to say,
* puts into this buffer will never cause the buffer to be full.
*/
cljs.core.async.unblocking_buffer_QMARK_ = (function unblocking_buffer_QMARK_(buff){var G__9908 = buff;if(G__9908)
{var bit__4053__auto__ = null;if(cljs.core.truth_((function (){var or__3409__auto__ = bit__4053__auto__;if(cljs.core.truth_(or__3409__auto__))
{return or__3409__auto__;
} else
{return G__9908.cljs$core$async$impl$protocols$UnblockingBuffer$;
}
})()))
{return true;
} else
{if((!G__9908.cljs$lang$protocol_mask$partition$))
{return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,G__9908);
} else
{return false;
}
}
} else
{return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,G__9908);
}
});
/**
* Creates a channel with an optional buffer. If buf-or-n is a number,
* will create and use a fixed buffer of that size.
*/
cljs.core.async.chan = (function() {
var chan = null;
var chan__0 = (function (){return chan.call(null,null);
});
var chan__1 = (function (buf_or_n){var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,0))?null:buf_or_n);return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1));
});
chan = function(buf_or_n){
switch(arguments.length){
case 0:
return chan__0.call(this);
case 1:
return chan__1.call(this,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
chan.cljs$core$IFn$_invoke$arity$0 = chan__0;
chan.cljs$core$IFn$_invoke$arity$1 = chan__1;
return chan;
})()
;
/**
* Returns a channel that will close after msecs
*/
cljs.core.async.timeout = (function timeout(msecs){return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
* takes a val from port. Must be called inside a (go ...) block. Will
* return nil if closed. Will park if nothing is available.
*/
cljs.core.async._LT__BANG_ = (function _LT__BANG_(port){if(null)
{return null;
} else
{throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("<! used not in (go ...) block"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,null))].join('')));
}
});
/**
* Asynchronously takes a val from port, passing to fn1. Will pass nil
* if closed. If on-caller? (default true) is true, and value is
* immediately available, will call fn1 on calling thread.
* Returns nil.
*/
cljs.core.async.take_BANG_ = (function() {
var take_BANG_ = null;
var take_BANG___2 = (function (port,fn1){return take_BANG_.call(null,port,fn1,true);
});
var take_BANG___3 = (function (port,fn1,on_caller_QMARK_){var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));if(cljs.core.truth_(ret))
{var val_9909 = cljs.core.deref.call(null,ret);if(cljs.core.truth_(on_caller_QMARK_))
{fn1.call(null,val_9909);
} else
{cljs.core.async.impl.dispatch.run.call(null,(function (){return fn1.call(null,val_9909);
}));
}
} else
{}
return null;
});
take_BANG_ = function(port,fn1,on_caller_QMARK_){
switch(arguments.length){
case 2:
return take_BANG___2.call(this,port,fn1);
case 3:
return take_BANG___3.call(this,port,fn1,on_caller_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
take_BANG_.cljs$core$IFn$_invoke$arity$2 = take_BANG___2;
take_BANG_.cljs$core$IFn$_invoke$arity$3 = take_BANG___3;
return take_BANG_;
})()
;
cljs.core.async.nop = (function nop(){return null;
});
/**
* puts a val into port. nil values are not allowed. Must be called
* inside a (go ...) block. Will park if no buffer space is available.
*/
cljs.core.async._GT__BANG_ = (function _GT__BANG_(port,val){if(null)
{return null;
} else
{throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(">! used not in (go ...) block"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,null))].join('')));
}
});
/**
* Asynchronously puts a val into port, calling fn0 (if supplied) when
* complete. nil values are not allowed. Will throw if closed. If
* on-caller? (default true) is true, and the put is immediately
* accepted, will call fn0 on calling thread.  Returns nil.
*/
cljs.core.async.put_BANG_ = (function() {
var put_BANG_ = null;
var put_BANG___2 = (function (port,val){return put_BANG_.call(null,port,val,cljs.core.async.nop);
});
var put_BANG___3 = (function (port,val,fn0){return put_BANG_.call(null,port,val,fn0,true);
});
var put_BANG___4 = (function (port,val,fn0,on_caller_QMARK_){var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn0));if(cljs.core.truth_((function (){var and__3397__auto__ = ret;if(cljs.core.truth_(and__3397__auto__))
{return cljs.core.not_EQ_.call(null,fn0,cljs.core.async.nop);
} else
{return and__3397__auto__;
}
})()))
{if(cljs.core.truth_(on_caller_QMARK_))
{fn0.call(null);
} else
{cljs.core.async.impl.dispatch.run.call(null,fn0);
}
} else
{}
return null;
});
put_BANG_ = function(port,val,fn0,on_caller_QMARK_){
switch(arguments.length){
case 2:
return put_BANG___2.call(this,port,val);
case 3:
return put_BANG___3.call(this,port,val,fn0);
case 4:
return put_BANG___4.call(this,port,val,fn0,on_caller_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
put_BANG_.cljs$core$IFn$_invoke$arity$2 = put_BANG___2;
put_BANG_.cljs$core$IFn$_invoke$arity$3 = put_BANG___3;
put_BANG_.cljs$core$IFn$_invoke$arity$4 = put_BANG___4;
return put_BANG_;
})()
;
cljs.core.async.close_BANG_ = (function close_BANG_(port){return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function random_array(n){var a = (new Array(n));var n__4251__auto___9910 = n;var x_9911 = 0;while(true){
if((x_9911 < n__4251__auto___9910))
{(a[x_9911] = 0);
{
var G__9912 = (x_9911 + 1);
x_9911 = G__9912;
continue;
}
} else
{}
break;
}
var i = 1;while(true){
if(cljs.core._EQ_.call(null,i,n))
{return a;
} else
{var j = cljs.core.rand_int.call(null,i);(a[i] = (a[j]));
(a[j] = i);
{
var G__9913 = (i + 1);
i = G__9913;
continue;
}
}
break;
}
});
cljs.core.async.alt_flag = (function alt_flag(){var flag = cljs.core.atom.call(null,true);if(typeof cljs.core.async.t9917 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t9917 = (function (flag,alt_flag,meta9918){
this.flag = flag;
this.alt_flag = alt_flag;
this.meta9918 = meta9918;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t9917.cljs$lang$type = true;
cljs.core.async.t9917.cljs$lang$ctorStr = "cljs.core.async/t9917";
cljs.core.async.t9917.cljs$lang$ctorPrWriter = (function (this__3971__auto__,writer__3972__auto__,opt__3973__auto__){return cljs.core._write.call(null,writer__3972__auto__,"cljs.core.async/t9917");
});
cljs.core.async.t9917.prototype.cljs$core$async$impl$protocols$Handler$ = true;
cljs.core.async.t9917.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.deref.call(null,self__.flag);
});
cljs.core.async.t9917.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){var self__ = this;
var ___$1 = this;cljs.core.reset_BANG_.call(null,self__.flag,null);
return true;
});
cljs.core.async.t9917.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_9919){var self__ = this;
var _9919__$1 = this;return self__.meta9918;
});
cljs.core.async.t9917.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_9919,meta9918__$1){var self__ = this;
var _9919__$1 = this;return (new cljs.core.async.t9917(self__.flag,self__.alt_flag,meta9918__$1));
});
cljs.core.async.__GT_t9917 = (function __GT_t9917(flag__$1,alt_flag__$1,meta9918){return (new cljs.core.async.t9917(flag__$1,alt_flag__$1,meta9918));
});
}
return (new cljs.core.async.t9917(flag,alt_flag,null));
});
cljs.core.async.alt_handler = (function alt_handler(flag,cb){if(typeof cljs.core.async.t9923 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t9923 = (function (cb,flag,alt_handler,meta9924){
this.cb = cb;
this.flag = flag;
this.alt_handler = alt_handler;
this.meta9924 = meta9924;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t9923.cljs$lang$type = true;
cljs.core.async.t9923.cljs$lang$ctorStr = "cljs.core.async/t9923";
cljs.core.async.t9923.cljs$lang$ctorPrWriter = (function (this__3971__auto__,writer__3972__auto__,opt__3973__auto__){return cljs.core._write.call(null,writer__3972__auto__,"cljs.core.async/t9923");
});
cljs.core.async.t9923.prototype.cljs$core$async$impl$protocols$Handler$ = true;
cljs.core.async.t9923.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});
cljs.core.async.t9923.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){var self__ = this;
var ___$1 = this;cljs.core.async.impl.protocols.commit.call(null,self__.flag);
return self__.cb;
});
cljs.core.async.t9923.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_9925){var self__ = this;
var _9925__$1 = this;return self__.meta9924;
});
cljs.core.async.t9923.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_9925,meta9924__$1){var self__ = this;
var _9925__$1 = this;return (new cljs.core.async.t9923(self__.cb,self__.flag,self__.alt_handler,meta9924__$1));
});
cljs.core.async.__GT_t9923 = (function __GT_t9923(cb__$1,flag__$1,alt_handler__$1,meta9924){return (new cljs.core.async.t9923(cb__$1,flag__$1,alt_handler__$1,meta9924));
});
}
return (new cljs.core.async.t9923(cb,flag,alt_handler,null));
});
/**
* returns derefable [val port] if immediate, nil if enqueued
*/
cljs.core.async.do_alts = (function do_alts(fret,ports,opts){var flag = cljs.core.async.alt_flag.call(null);var n = cljs.core.count.call(null,ports);var idxs = cljs.core.async.random_array.call(null,n);var priority = new cljs.core.Keyword(null,"priority","priority",4143410454).cljs$core$IFn$_invoke$arity$1(opts);var ret = (function (){var i = 0;while(true){
if((i < n))
{var idx = (cljs.core.truth_(priority)?i:(idxs[i]));var port = cljs.core.nth.call(null,ports,idx);var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,0):null);var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,1);return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (){return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__9926_SHARP_){return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__9926_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));if(cljs.core.truth_(vbox))
{return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__3409__auto__ = wport;if(cljs.core.truth_(or__3409__auto__))
{return or__3409__auto__;
} else
{return port;
}
})()], null));
} else
{{
var G__9927 = (i + 1);
i = G__9927;
continue;
}
}
} else
{return null;
}
break;
}
})();var or__3409__auto__ = ret;if(cljs.core.truth_(or__3409__auto__))
{return or__3409__auto__;
} else
{if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",2558708147)))
{var temp__4092__auto__ = (function (){var and__3397__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);if(cljs.core.truth_(and__3397__auto__))
{return cljs.core.async.impl.protocols.commit.call(null,flag);
} else
{return and__3397__auto__;
}
})();if(cljs.core.truth_(temp__4092__auto__))
{var got = temp__4092__auto__;return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",2558708147).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",2558708147)], null));
} else
{return null;
}
} else
{return null;
}
}
});
/**
* Completes at most one of several channel operations. Must be called
* inside a (go ...) block. ports is a vector of channel endpoints, which
* can be either a channel to take from or a vector of
* [channel-to-put-to val-to-put], in any combination. Takes will be
* made as if by <!, and puts will be made as if by >!. Unless
* the :priority option is true, if more than one port operation is
* ready a non-deterministic choice will be made. If no operation is
* ready and a :default value is supplied, [default-val :default] will
* be returned, otherwise alts! will park until the first operation to
* become ready completes. Returns [val port] of the completed
* operation, where val is the value taken for takes, and nil for puts.
* 
* opts are passed as :key val ... Supported options:
* 
* :default val - the value to use if none of the operations are immediately ready
* :priority true - (default nil) when true, the operations will be tried in order.
* 
* Note: there is no guarantee that the port exps or val exprs will be
* used, nor in what order should they be, so they should not be
* depended upon for side effects.
* @param {...*} var_args
*/
cljs.core.async.alts_BANG_ = (function() { 
var alts_BANG___delegate = function (ports,p__9928){var map__9930 = p__9928;var map__9930__$1 = ((cljs.core.seq_QMARK_.call(null,map__9930))?cljs.core.apply.call(null,cljs.core.hash_map,map__9930):map__9930);var opts = map__9930__$1;if(null)
{return null;
} else
{throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("alts! used not in (go ...) block"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,null))].join('')));
}
};
var alts_BANG_ = function (ports,var_args){
var p__9928 = null;if (arguments.length > 1) {
  p__9928 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return alts_BANG___delegate.call(this,ports,p__9928);};
alts_BANG_.cljs$lang$maxFixedArity = 1;
alts_BANG_.cljs$lang$applyTo = (function (arglist__9931){
var ports = cljs.core.first(arglist__9931);
var p__9928 = cljs.core.rest(arglist__9931);
return alts_BANG___delegate(ports,p__9928);
});
alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = alts_BANG___delegate;
return alts_BANG_;
})()
;
/**
* Takes a function and a source channel, and returns a channel which
* contains the values produced by applying f to each value taken from
* the source channel
*/
cljs.core.async.map_LT_ = (function map_LT_(f,ch){if(typeof cljs.core.async.t9939 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t9939 = (function (ch,f,map_LT_,meta9940){
this.ch = ch;
this.f = f;
this.map_LT_ = map_LT_;
this.meta9940 = meta9940;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t9939.cljs$lang$type = true;
cljs.core.async.t9939.cljs$lang$ctorStr = "cljs.core.async/t9939";
cljs.core.async.t9939.cljs$lang$ctorPrWriter = (function (this__3971__auto__,writer__3972__auto__,opt__3973__auto__){return cljs.core._write.call(null,writer__3972__auto__,"cljs.core.async/t9939");
});
cljs.core.async.t9939.prototype.cljs$core$async$impl$protocols$WritePort$ = true;
cljs.core.async.t9939.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn0){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn0);
});
cljs.core.async.t9939.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;
cljs.core.async.t9939.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){var self__ = this;
var ___$1 = this;var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){if(typeof cljs.core.async.t9942 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t9942 = (function (fn1,_,meta9940,ch,f,map_LT_,meta9943){
this.fn1 = fn1;
this._ = _;
this.meta9940 = meta9940;
this.ch = ch;
this.f = f;
this.map_LT_ = map_LT_;
this.meta9943 = meta9943;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t9942.cljs$lang$type = true;
cljs.core.async.t9942.cljs$lang$ctorStr = "cljs.core.async/t9942";
cljs.core.async.t9942.cljs$lang$ctorPrWriter = (function (this__3971__auto__,writer__3972__auto__,opt__3973__auto__){return cljs.core._write.call(null,writer__3972__auto__,"cljs.core.async/t9942");
});
cljs.core.async.t9942.prototype.cljs$core$async$impl$protocols$Handler$ = true;
cljs.core.async.t9942.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$3){var self__ = this;
var ___$4 = this;return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});
cljs.core.async.t9942.prototype.cljs$core$async$impl$protocols$Handler$lock_id$arity$1 = (function (___$3){var self__ = this;
var ___$4 = this;return cljs.core.async.impl.protocols.lock_id.call(null,self__.fn1);
});
cljs.core.async.t9942.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$3){var self__ = this;
var ___$4 = this;var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);return ((function (f1,___$4){
return (function (p1__9932_SHARP_){return f1.call(null,(((p1__9932_SHARP_ == null))?null:self__.f.call(null,p1__9932_SHARP_)));
});
;})(f1,___$4))
});
cljs.core.async.t9942.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_9944){var self__ = this;
var _9944__$1 = this;return self__.meta9943;
});
cljs.core.async.t9942.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_9944,meta9943__$1){var self__ = this;
var _9944__$1 = this;return (new cljs.core.async.t9942(self__.fn1,self__._,self__.meta9940,self__.ch,self__.f,self__.map_LT_,meta9943__$1));
});
cljs.core.async.__GT_t9942 = (function __GT_t9942(fn1__$1,___$2,meta9940__$1,ch__$2,f__$2,map_LT___$2,meta9943){return (new cljs.core.async.t9942(fn1__$1,___$2,meta9940__$1,ch__$2,f__$2,map_LT___$2,meta9943));
});
}
return (new cljs.core.async.t9942(fn1,___$1,self__.meta9940,self__.ch,self__.f,self__.map_LT_,null));
})());if(cljs.core.truth_((function (){var and__3397__auto__ = ret;if(cljs.core.truth_(and__3397__auto__))
{return !((cljs.core.deref.call(null,ret) == null));
} else
{return and__3397__auto__;
}
})()))
{return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else
{return ret;
}
});
cljs.core.async.t9939.prototype.cljs$core$async$impl$protocols$Channel$ = true;
cljs.core.async.t9939.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});
cljs.core.async.t9939.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_9941){var self__ = this;
var _9941__$1 = this;return self__.meta9940;
});
cljs.core.async.t9939.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_9941,meta9940__$1){var self__ = this;
var _9941__$1 = this;return (new cljs.core.async.t9939(self__.ch,self__.f,self__.map_LT_,meta9940__$1));
});
cljs.core.async.__GT_t9939 = (function __GT_t9939(ch__$1,f__$1,map_LT___$1,meta9940){return (new cljs.core.async.t9939(ch__$1,f__$1,map_LT___$1,meta9940));
});
}
return (new cljs.core.async.t9939(ch,f,map_LT_,null));
});
/**
* Takes a function and a target channel, and returns a channel which
* applies f to each value before supplying it to the target channel.
*/
cljs.core.async.map_GT_ = (function map_GT_(f,ch){if(typeof cljs.core.async.t9948 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t9948 = (function (ch,f,map_GT_,meta9949){
this.ch = ch;
this.f = f;
this.map_GT_ = map_GT_;
this.meta9949 = meta9949;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t9948.cljs$lang$type = true;
cljs.core.async.t9948.cljs$lang$ctorStr = "cljs.core.async/t9948";
cljs.core.async.t9948.cljs$lang$ctorPrWriter = (function (this__3971__auto__,writer__3972__auto__,opt__3973__auto__){return cljs.core._write.call(null,writer__3972__auto__,"cljs.core.async/t9948");
});
cljs.core.async.t9948.prototype.cljs$core$async$impl$protocols$WritePort$ = true;
cljs.core.async.t9948.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn0){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn0);
});
cljs.core.async.t9948.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;
cljs.core.async.t9948.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});
cljs.core.async.t9948.prototype.cljs$core$async$impl$protocols$Channel$ = true;
cljs.core.async.t9948.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});
cljs.core.async.t9948.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_9950){var self__ = this;
var _9950__$1 = this;return self__.meta9949;
});
cljs.core.async.t9948.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_9950,meta9949__$1){var self__ = this;
var _9950__$1 = this;return (new cljs.core.async.t9948(self__.ch,self__.f,self__.map_GT_,meta9949__$1));
});
cljs.core.async.__GT_t9948 = (function __GT_t9948(ch__$1,f__$1,map_GT___$1,meta9949){return (new cljs.core.async.t9948(ch__$1,f__$1,map_GT___$1,meta9949));
});
}
return (new cljs.core.async.t9948(ch,f,map_GT_,null));
});
/**
* Takes a predicate and a target channel, and returns a channel which
* supplies only the values for which the predicate returns true to the
* target channel.
*/
cljs.core.async.filter_GT_ = (function filter_GT_(p,ch){if(typeof cljs.core.async.t9954 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t9954 = (function (ch,p,filter_GT_,meta9955){
this.ch = ch;
this.p = p;
this.filter_GT_ = filter_GT_;
this.meta9955 = meta9955;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t9954.cljs$lang$type = true;
cljs.core.async.t9954.cljs$lang$ctorStr = "cljs.core.async/t9954";
cljs.core.async.t9954.cljs$lang$ctorPrWriter = (function (this__3971__auto__,writer__3972__auto__,opt__3973__auto__){return cljs.core._write.call(null,writer__3972__auto__,"cljs.core.async/t9954");
});
cljs.core.async.t9954.prototype.cljs$core$async$impl$protocols$WritePort$ = true;
cljs.core.async.t9954.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn0){var self__ = this;
var ___$1 = this;if(cljs.core.truth_(self__.p.call(null,val)))
{return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn0);
} else
{return cljs.core.async.impl.channels.box.call(null,null);
}
});
cljs.core.async.t9954.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;
cljs.core.async.t9954.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});
cljs.core.async.t9954.prototype.cljs$core$async$impl$protocols$Channel$ = true;
cljs.core.async.t9954.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});
cljs.core.async.t9954.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_9956){var self__ = this;
var _9956__$1 = this;return self__.meta9955;
});
cljs.core.async.t9954.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_9956,meta9955__$1){var self__ = this;
var _9956__$1 = this;return (new cljs.core.async.t9954(self__.ch,self__.p,self__.filter_GT_,meta9955__$1));
});
cljs.core.async.__GT_t9954 = (function __GT_t9954(ch__$1,p__$1,filter_GT___$1,meta9955){return (new cljs.core.async.t9954(ch__$1,p__$1,filter_GT___$1,meta9955));
});
}
return (new cljs.core.async.t9954(ch,p,filter_GT_,null));
});
/**
* Takes a predicate and a target channel, and returns a channel which
* supplies only the values for which the predicate returns false to the
* target channel.
*/
cljs.core.async.remove_GT_ = (function remove_GT_(p,ch){return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
* Takes a predicate and a source channel, and returns a channel which
* contains only the values taken from the source channel for which the
* predicate returns true. The returned channel will be unbuffered by
* default, or a buf-or-n can be supplied. The channel will close
* when the source channel closes.
*/
cljs.core.async.filter_LT_ = (function() {
var filter_LT_ = null;
var filter_LT___2 = (function (p,ch){return filter_LT_.call(null,p,ch,null);
});
var filter_LT___3 = (function (p,ch,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__6234__auto___10039 = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,(function (){var f__6235__auto__ = (function (){var switch__6219__auto__ = (function (state_10018){var state_val_10019 = (state_10018[1]);if((state_val_10019 === 1))
{var state_10018__$1 = state_10018;var statearr_10020_10040 = state_10018__$1;(statearr_10020_10040[2] = null);
(statearr_10020_10040[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10019 === 2))
{var state_10018__$1 = state_10018;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_10018__$1,4,ch);
} else
{if((state_val_10019 === 3))
{var inst_10016 = (state_10018[2]);var state_10018__$1 = state_10018;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10018__$1,inst_10016);
} else
{if((state_val_10019 === 4))
{var inst_10000 = (state_10018[7]);var inst_10000__$1 = (state_10018[2]);var inst_10001 = (inst_10000__$1 == null);var state_10018__$1 = (function (){var statearr_10021 = state_10018;(statearr_10021[7] = inst_10000__$1);
return statearr_10021;
})();if(cljs.core.truth_(inst_10001))
{var statearr_10022_10041 = state_10018__$1;(statearr_10022_10041[1] = 5);
} else
{var statearr_10023_10042 = state_10018__$1;(statearr_10023_10042[1] = 6);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10019 === 5))
{var inst_10003 = cljs.core.async.close_BANG_.call(null,out);var state_10018__$1 = state_10018;var statearr_10024_10043 = state_10018__$1;(statearr_10024_10043[2] = inst_10003);
(statearr_10024_10043[1] = 7);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10019 === 6))
{var inst_10000 = (state_10018[7]);var inst_10005 = p.call(null,inst_10000);var state_10018__$1 = state_10018;if(cljs.core.truth_(inst_10005))
{var statearr_10025_10044 = state_10018__$1;(statearr_10025_10044[1] = 8);
} else
{var statearr_10026_10045 = state_10018__$1;(statearr_10026_10045[1] = 9);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10019 === 7))
{var inst_10014 = (state_10018[2]);var state_10018__$1 = state_10018;var statearr_10027_10046 = state_10018__$1;(statearr_10027_10046[2] = inst_10014);
(statearr_10027_10046[1] = 3);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10019 === 8))
{var inst_10000 = (state_10018[7]);var state_10018__$1 = state_10018;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10018__$1,11,out,inst_10000);
} else
{if((state_val_10019 === 9))
{var state_10018__$1 = state_10018;var statearr_10028_10047 = state_10018__$1;(statearr_10028_10047[2] = null);
(statearr_10028_10047[1] = 10);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10019 === 10))
{var inst_10011 = (state_10018[2]);var state_10018__$1 = (function (){var statearr_10029 = state_10018;(statearr_10029[8] = inst_10011);
return statearr_10029;
})();var statearr_10030_10048 = state_10018__$1;(statearr_10030_10048[2] = null);
(statearr_10030_10048[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10019 === 11))
{var inst_10008 = (state_10018[2]);var state_10018__$1 = state_10018;var statearr_10031_10049 = state_10018__$1;(statearr_10031_10049[2] = inst_10008);
(statearr_10031_10049[1] = 10);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
});return ((function (switch__6219__auto__){
return (function() {
var state_machine__6220__auto__ = null;
var state_machine__6220__auto____0 = (function (){var statearr_10035 = [null,null,null,null,null,null,null,null,null];(statearr_10035[0] = state_machine__6220__auto__);
(statearr_10035[1] = 1);
return statearr_10035;
});
var state_machine__6220__auto____1 = (function (state_10018){while(true){
var ret_value__6221__auto__ = (function (){try{while(true){
var result__6222__auto__ = switch__6219__auto__.call(null,state_10018);if(cljs.core.keyword_identical_QMARK_.call(null,result__6222__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__6222__auto__;
}
break;
}
}catch (e10036){if((e10036 instanceof Object))
{var ex__6223__auto__ = e10036;var statearr_10037_10050 = state_10018;(statearr_10037_10050[5] = ex__6223__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10018);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e10036;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6221__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__10051 = state_10018;
state_10018 = G__10051;
continue;
}
} else
{return ret_value__6221__auto__;
}
break;
}
});
state_machine__6220__auto__ = function(state_10018){
switch(arguments.length){
case 0:
return state_machine__6220__auto____0.call(this);
case 1:
return state_machine__6220__auto____1.call(this,state_10018);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__6220__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__6220__auto____0;
state_machine__6220__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__6220__auto____1;
return state_machine__6220__auto__;
})()
;})(switch__6219__auto__))
})();var state__6236__auto__ = (function (){var statearr_10038 = f__6235__auto__.call(null);(statearr_10038[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__6234__auto___10039);
return statearr_10038;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6236__auto__);
}));
return out;
});
filter_LT_ = function(p,ch,buf_or_n){
switch(arguments.length){
case 2:
return filter_LT___2.call(this,p,ch);
case 3:
return filter_LT___3.call(this,p,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
filter_LT_.cljs$core$IFn$_invoke$arity$2 = filter_LT___2;
filter_LT_.cljs$core$IFn$_invoke$arity$3 = filter_LT___3;
return filter_LT_;
})()
;
/**
* Takes a predicate and a source channel, and returns a channel which
* contains only the values taken from the source channel for which the
* predicate returns false. The returned channel will be unbuffered by
* default, or a buf-or-n can be supplied. The channel will close
* when the source channel closes.
*/
cljs.core.async.remove_LT_ = (function() {
var remove_LT_ = null;
var remove_LT___2 = (function (p,ch){return remove_LT_.call(null,p,ch,null);
});
var remove_LT___3 = (function (p,ch,buf_or_n){return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});
remove_LT_ = function(p,ch,buf_or_n){
switch(arguments.length){
case 2:
return remove_LT___2.call(this,p,ch);
case 3:
return remove_LT___3.call(this,p,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
remove_LT_.cljs$core$IFn$_invoke$arity$2 = remove_LT___2;
remove_LT_.cljs$core$IFn$_invoke$arity$3 = remove_LT___3;
return remove_LT_;
})()
;
cljs.core.async.mapcat_STAR_ = (function mapcat_STAR_(f,in$,out){var c__6234__auto__ = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,(function (){var f__6235__auto__ = (function (){var switch__6219__auto__ = (function (state_10203){var state_val_10204 = (state_10203[1]);if((state_val_10204 === 1))
{var state_10203__$1 = state_10203;var statearr_10205_10242 = state_10203__$1;(statearr_10205_10242[2] = null);
(statearr_10205_10242[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10204 === 2))
{var state_10203__$1 = state_10203;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_10203__$1,4,in$);
} else
{if((state_val_10204 === 3))
{var inst_10201 = (state_10203[2]);var state_10203__$1 = state_10203;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10203__$1,inst_10201);
} else
{if((state_val_10204 === 4))
{var inst_10149 = (state_10203[7]);var inst_10149__$1 = (state_10203[2]);var inst_10150 = (inst_10149__$1 == null);var state_10203__$1 = (function (){var statearr_10206 = state_10203;(statearr_10206[7] = inst_10149__$1);
return statearr_10206;
})();if(cljs.core.truth_(inst_10150))
{var statearr_10207_10243 = state_10203__$1;(statearr_10207_10243[1] = 5);
} else
{var statearr_10208_10244 = state_10203__$1;(statearr_10208_10244[1] = 6);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10204 === 5))
{var inst_10152 = cljs.core.async.close_BANG_.call(null,out);var state_10203__$1 = state_10203;var statearr_10209_10245 = state_10203__$1;(statearr_10209_10245[2] = inst_10152);
(statearr_10209_10245[1] = 7);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10204 === 6))
{var inst_10149 = (state_10203[7]);var inst_10154 = f.call(null,inst_10149);var inst_10159 = cljs.core.seq.call(null,inst_10154);var inst_10160 = inst_10159;var inst_10161 = null;var inst_10162 = 0;var inst_10163 = 0;var state_10203__$1 = (function (){var statearr_10210 = state_10203;(statearr_10210[8] = inst_10163);
(statearr_10210[9] = inst_10161);
(statearr_10210[10] = inst_10162);
(statearr_10210[11] = inst_10160);
return statearr_10210;
})();var statearr_10211_10246 = state_10203__$1;(statearr_10211_10246[2] = null);
(statearr_10211_10246[1] = 8);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10204 === 7))
{var inst_10199 = (state_10203[2]);var state_10203__$1 = state_10203;var statearr_10212_10247 = state_10203__$1;(statearr_10212_10247[2] = inst_10199);
(statearr_10212_10247[1] = 3);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10204 === 8))
{var inst_10163 = (state_10203[8]);var inst_10162 = (state_10203[10]);var inst_10165 = (inst_10163 < inst_10162);var inst_10166 = inst_10165;var state_10203__$1 = state_10203;if(cljs.core.truth_(inst_10166))
{var statearr_10213_10248 = state_10203__$1;(statearr_10213_10248[1] = 10);
} else
{var statearr_10214_10249 = state_10203__$1;(statearr_10214_10249[1] = 11);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10204 === 9))
{var inst_10196 = (state_10203[2]);var state_10203__$1 = (function (){var statearr_10215 = state_10203;(statearr_10215[12] = inst_10196);
return statearr_10215;
})();var statearr_10216_10250 = state_10203__$1;(statearr_10216_10250[2] = null);
(statearr_10216_10250[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10204 === 10))
{var inst_10163 = (state_10203[8]);var inst_10161 = (state_10203[9]);var inst_10168 = cljs.core._nth.call(null,inst_10161,inst_10163);var state_10203__$1 = state_10203;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10203__$1,13,out,inst_10168);
} else
{if((state_val_10204 === 11))
{var inst_10160 = (state_10203[11]);var inst_10174 = (state_10203[13]);var inst_10174__$1 = cljs.core.seq.call(null,inst_10160);var state_10203__$1 = (function (){var statearr_10220 = state_10203;(statearr_10220[13] = inst_10174__$1);
return statearr_10220;
})();if(inst_10174__$1)
{var statearr_10221_10251 = state_10203__$1;(statearr_10221_10251[1] = 14);
} else
{var statearr_10222_10252 = state_10203__$1;(statearr_10222_10252[1] = 15);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10204 === 12))
{var inst_10194 = (state_10203[2]);var state_10203__$1 = state_10203;var statearr_10223_10253 = state_10203__$1;(statearr_10223_10253[2] = inst_10194);
(statearr_10223_10253[1] = 9);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10204 === 13))
{var inst_10163 = (state_10203[8]);var inst_10161 = (state_10203[9]);var inst_10162 = (state_10203[10]);var inst_10160 = (state_10203[11]);var inst_10170 = (state_10203[2]);var inst_10171 = (inst_10163 + 1);var tmp10217 = inst_10161;var tmp10218 = inst_10162;var tmp10219 = inst_10160;var inst_10160__$1 = tmp10219;var inst_10161__$1 = tmp10217;var inst_10162__$1 = tmp10218;var inst_10163__$1 = inst_10171;var state_10203__$1 = (function (){var statearr_10224 = state_10203;(statearr_10224[8] = inst_10163__$1);
(statearr_10224[9] = inst_10161__$1);
(statearr_10224[10] = inst_10162__$1);
(statearr_10224[11] = inst_10160__$1);
(statearr_10224[14] = inst_10170);
return statearr_10224;
})();var statearr_10225_10254 = state_10203__$1;(statearr_10225_10254[2] = null);
(statearr_10225_10254[1] = 8);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10204 === 14))
{var inst_10174 = (state_10203[13]);var inst_10176 = cljs.core.chunked_seq_QMARK_.call(null,inst_10174);var state_10203__$1 = state_10203;if(inst_10176)
{var statearr_10226_10255 = state_10203__$1;(statearr_10226_10255[1] = 17);
} else
{var statearr_10227_10256 = state_10203__$1;(statearr_10227_10256[1] = 18);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10204 === 15))
{var state_10203__$1 = state_10203;var statearr_10228_10257 = state_10203__$1;(statearr_10228_10257[2] = null);
(statearr_10228_10257[1] = 16);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10204 === 16))
{var inst_10192 = (state_10203[2]);var state_10203__$1 = state_10203;var statearr_10229_10258 = state_10203__$1;(statearr_10229_10258[2] = inst_10192);
(statearr_10229_10258[1] = 12);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10204 === 17))
{var inst_10174 = (state_10203[13]);var inst_10178 = cljs.core.chunk_first.call(null,inst_10174);var inst_10179 = cljs.core.chunk_rest.call(null,inst_10174);var inst_10180 = cljs.core.count.call(null,inst_10178);var inst_10160 = inst_10179;var inst_10161 = inst_10178;var inst_10162 = inst_10180;var inst_10163 = 0;var state_10203__$1 = (function (){var statearr_10230 = state_10203;(statearr_10230[8] = inst_10163);
(statearr_10230[9] = inst_10161);
(statearr_10230[10] = inst_10162);
(statearr_10230[11] = inst_10160);
return statearr_10230;
})();var statearr_10231_10259 = state_10203__$1;(statearr_10231_10259[2] = null);
(statearr_10231_10259[1] = 8);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10204 === 18))
{var inst_10174 = (state_10203[13]);var inst_10183 = cljs.core.first.call(null,inst_10174);var state_10203__$1 = state_10203;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10203__$1,20,out,inst_10183);
} else
{if((state_val_10204 === 19))
{var inst_10189 = (state_10203[2]);var state_10203__$1 = state_10203;var statearr_10232_10260 = state_10203__$1;(statearr_10232_10260[2] = inst_10189);
(statearr_10232_10260[1] = 16);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10204 === 20))
{var inst_10174 = (state_10203[13]);var inst_10185 = (state_10203[2]);var inst_10186 = cljs.core.next.call(null,inst_10174);var inst_10160 = inst_10186;var inst_10161 = null;var inst_10162 = 0;var inst_10163 = 0;var state_10203__$1 = (function (){var statearr_10233 = state_10203;(statearr_10233[8] = inst_10163);
(statearr_10233[9] = inst_10161);
(statearr_10233[10] = inst_10162);
(statearr_10233[11] = inst_10160);
(statearr_10233[15] = inst_10185);
return statearr_10233;
})();var statearr_10234_10261 = state_10203__$1;(statearr_10234_10261[2] = null);
(statearr_10234_10261[1] = 8);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});return ((function (switch__6219__auto__){
return (function() {
var state_machine__6220__auto__ = null;
var state_machine__6220__auto____0 = (function (){var statearr_10238 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_10238[0] = state_machine__6220__auto__);
(statearr_10238[1] = 1);
return statearr_10238;
});
var state_machine__6220__auto____1 = (function (state_10203){while(true){
var ret_value__6221__auto__ = (function (){try{while(true){
var result__6222__auto__ = switch__6219__auto__.call(null,state_10203);if(cljs.core.keyword_identical_QMARK_.call(null,result__6222__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__6222__auto__;
}
break;
}
}catch (e10239){if((e10239 instanceof Object))
{var ex__6223__auto__ = e10239;var statearr_10240_10262 = state_10203;(statearr_10240_10262[5] = ex__6223__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10203);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e10239;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6221__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__10263 = state_10203;
state_10203 = G__10263;
continue;
}
} else
{return ret_value__6221__auto__;
}
break;
}
});
state_machine__6220__auto__ = function(state_10203){
switch(arguments.length){
case 0:
return state_machine__6220__auto____0.call(this);
case 1:
return state_machine__6220__auto____1.call(this,state_10203);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__6220__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__6220__auto____0;
state_machine__6220__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__6220__auto____1;
return state_machine__6220__auto__;
})()
;})(switch__6219__auto__))
})();var state__6236__auto__ = (function (){var statearr_10241 = f__6235__auto__.call(null);(statearr_10241[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__6234__auto__);
return statearr_10241;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6236__auto__);
}));
return c__6234__auto__;
});
/**
* Takes a function and a source channel, and returns a channel which
* contains the values in each collection produced by applying f to
* each value taken from the source channel. f must return a
* collection.
* 
* The returned channel will be unbuffered by default, or a buf-or-n
* can be supplied. The channel will close when the source channel
* closes.
*/
cljs.core.async.mapcat_LT_ = (function() {
var mapcat_LT_ = null;
var mapcat_LT___2 = (function (f,in$){return mapcat_LT_.call(null,f,in$,null);
});
var mapcat_LT___3 = (function (f,in$,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);cljs.core.async.mapcat_STAR_.call(null,f,in$,out);
return out;
});
mapcat_LT_ = function(f,in$,buf_or_n){
switch(arguments.length){
case 2:
return mapcat_LT___2.call(this,f,in$);
case 3:
return mapcat_LT___3.call(this,f,in$,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = mapcat_LT___2;
mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = mapcat_LT___3;
return mapcat_LT_;
})()
;
/**
* Takes a function and a target channel, and returns a channel which
* applies f to each value put, then supplies each element of the result
* to the target channel. f must return a collection.
* 
* The returned channel will be unbuffered by default, or a buf-or-n
* can be supplied. The target channel will be closed when the source
* channel closes.
*/
cljs.core.async.mapcat_GT_ = (function() {
var mapcat_GT_ = null;
var mapcat_GT___2 = (function (f,out){return mapcat_GT_.call(null,f,out,null);
});
var mapcat_GT___3 = (function (f,out,buf_or_n){var in$ = cljs.core.async.chan.call(null,buf_or_n);cljs.core.async.mapcat_STAR_.call(null,f,in$,out);
return in$;
});
mapcat_GT_ = function(f,out,buf_or_n){
switch(arguments.length){
case 2:
return mapcat_GT___2.call(this,f,out);
case 3:
return mapcat_GT___3.call(this,f,out,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = mapcat_GT___2;
mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = mapcat_GT___3;
return mapcat_GT_;
})()
;
/**
* Takes elements from the from channel and supplies them to the to
* channel. By default, the to channel will be closed when the
* from channel closes, but can be determined by the close?
* parameter.
*/
cljs.core.async.pipe = (function() {
var pipe = null;
var pipe__2 = (function (from,to){return pipe.call(null,from,to,true);
});
var pipe__3 = (function (from,to,close_QMARK_){var c__6234__auto___10344 = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,(function (){var f__6235__auto__ = (function (){var switch__6219__auto__ = (function (state_10323){var state_val_10324 = (state_10323[1]);if((state_val_10324 === 1))
{var state_10323__$1 = state_10323;var statearr_10325_10345 = state_10323__$1;(statearr_10325_10345[2] = null);
(statearr_10325_10345[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10324 === 2))
{var state_10323__$1 = state_10323;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_10323__$1,4,from);
} else
{if((state_val_10324 === 3))
{var inst_10321 = (state_10323[2]);var state_10323__$1 = state_10323;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10323__$1,inst_10321);
} else
{if((state_val_10324 === 4))
{var inst_10306 = (state_10323[7]);var inst_10306__$1 = (state_10323[2]);var inst_10307 = (inst_10306__$1 == null);var state_10323__$1 = (function (){var statearr_10326 = state_10323;(statearr_10326[7] = inst_10306__$1);
return statearr_10326;
})();if(cljs.core.truth_(inst_10307))
{var statearr_10327_10346 = state_10323__$1;(statearr_10327_10346[1] = 5);
} else
{var statearr_10328_10347 = state_10323__$1;(statearr_10328_10347[1] = 6);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10324 === 5))
{var state_10323__$1 = state_10323;if(cljs.core.truth_(close_QMARK_))
{var statearr_10329_10348 = state_10323__$1;(statearr_10329_10348[1] = 8);
} else
{var statearr_10330_10349 = state_10323__$1;(statearr_10330_10349[1] = 9);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10324 === 6))
{var inst_10306 = (state_10323[7]);var state_10323__$1 = state_10323;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10323__$1,11,to,inst_10306);
} else
{if((state_val_10324 === 7))
{var inst_10319 = (state_10323[2]);var state_10323__$1 = state_10323;var statearr_10331_10350 = state_10323__$1;(statearr_10331_10350[2] = inst_10319);
(statearr_10331_10350[1] = 3);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10324 === 8))
{var inst_10310 = cljs.core.async.close_BANG_.call(null,to);var state_10323__$1 = state_10323;var statearr_10332_10351 = state_10323__$1;(statearr_10332_10351[2] = inst_10310);
(statearr_10332_10351[1] = 10);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10324 === 9))
{var state_10323__$1 = state_10323;var statearr_10333_10352 = state_10323__$1;(statearr_10333_10352[2] = null);
(statearr_10333_10352[1] = 10);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10324 === 10))
{var inst_10313 = (state_10323[2]);var state_10323__$1 = state_10323;var statearr_10334_10353 = state_10323__$1;(statearr_10334_10353[2] = inst_10313);
(statearr_10334_10353[1] = 7);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10324 === 11))
{var inst_10316 = (state_10323[2]);var state_10323__$1 = (function (){var statearr_10335 = state_10323;(statearr_10335[8] = inst_10316);
return statearr_10335;
})();var statearr_10336_10354 = state_10323__$1;(statearr_10336_10354[2] = null);
(statearr_10336_10354[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
});return ((function (switch__6219__auto__){
return (function() {
var state_machine__6220__auto__ = null;
var state_machine__6220__auto____0 = (function (){var statearr_10340 = [null,null,null,null,null,null,null,null,null];(statearr_10340[0] = state_machine__6220__auto__);
(statearr_10340[1] = 1);
return statearr_10340;
});
var state_machine__6220__auto____1 = (function (state_10323){while(true){
var ret_value__6221__auto__ = (function (){try{while(true){
var result__6222__auto__ = switch__6219__auto__.call(null,state_10323);if(cljs.core.keyword_identical_QMARK_.call(null,result__6222__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__6222__auto__;
}
break;
}
}catch (e10341){if((e10341 instanceof Object))
{var ex__6223__auto__ = e10341;var statearr_10342_10355 = state_10323;(statearr_10342_10355[5] = ex__6223__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10323);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e10341;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6221__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__10356 = state_10323;
state_10323 = G__10356;
continue;
}
} else
{return ret_value__6221__auto__;
}
break;
}
});
state_machine__6220__auto__ = function(state_10323){
switch(arguments.length){
case 0:
return state_machine__6220__auto____0.call(this);
case 1:
return state_machine__6220__auto____1.call(this,state_10323);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__6220__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__6220__auto____0;
state_machine__6220__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__6220__auto____1;
return state_machine__6220__auto__;
})()
;})(switch__6219__auto__))
})();var state__6236__auto__ = (function (){var statearr_10343 = f__6235__auto__.call(null);(statearr_10343[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__6234__auto___10344);
return statearr_10343;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6236__auto__);
}));
return to;
});
pipe = function(from,to,close_QMARK_){
switch(arguments.length){
case 2:
return pipe__2.call(this,from,to);
case 3:
return pipe__3.call(this,from,to,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pipe.cljs$core$IFn$_invoke$arity$2 = pipe__2;
pipe.cljs$core$IFn$_invoke$arity$3 = pipe__3;
return pipe;
})()
;
/**
* Takes a predicate and a source channel and returns a vector of two
* channels, the first of which will contain the values for which the
* predicate returned true, the second those for which it returned
* false.
* 
* The out channels will be unbuffered by default, or two buf-or-ns can
* be supplied. The channels will close after the source channel has
* closed.
*/
cljs.core.async.split = (function() {
var split = null;
var split__2 = (function (p,ch){return split.call(null,p,ch,null,null);
});
var split__4 = (function (p,ch,t_buf_or_n,f_buf_or_n){var tc = cljs.core.async.chan.call(null,t_buf_or_n);var fc = cljs.core.async.chan.call(null,f_buf_or_n);var c__6234__auto___10443 = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,(function (){var f__6235__auto__ = (function (){var switch__6219__auto__ = (function (state_10421){var state_val_10422 = (state_10421[1]);if((state_val_10422 === 1))
{var state_10421__$1 = state_10421;var statearr_10423_10444 = state_10421__$1;(statearr_10423_10444[2] = null);
(statearr_10423_10444[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10422 === 2))
{var state_10421__$1 = state_10421;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_10421__$1,4,ch);
} else
{if((state_val_10422 === 3))
{var inst_10419 = (state_10421[2]);var state_10421__$1 = state_10421;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10421__$1,inst_10419);
} else
{if((state_val_10422 === 4))
{var inst_10402 = (state_10421[7]);var inst_10402__$1 = (state_10421[2]);var inst_10403 = (inst_10402__$1 == null);var state_10421__$1 = (function (){var statearr_10424 = state_10421;(statearr_10424[7] = inst_10402__$1);
return statearr_10424;
})();if(cljs.core.truth_(inst_10403))
{var statearr_10425_10445 = state_10421__$1;(statearr_10425_10445[1] = 5);
} else
{var statearr_10426_10446 = state_10421__$1;(statearr_10426_10446[1] = 6);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10422 === 5))
{var inst_10405 = cljs.core.async.close_BANG_.call(null,tc);var inst_10406 = cljs.core.async.close_BANG_.call(null,fc);var state_10421__$1 = (function (){var statearr_10427 = state_10421;(statearr_10427[8] = inst_10405);
return statearr_10427;
})();var statearr_10428_10447 = state_10421__$1;(statearr_10428_10447[2] = inst_10406);
(statearr_10428_10447[1] = 7);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10422 === 6))
{var inst_10402 = (state_10421[7]);var inst_10408 = p.call(null,inst_10402);var state_10421__$1 = state_10421;if(cljs.core.truth_(inst_10408))
{var statearr_10429_10448 = state_10421__$1;(statearr_10429_10448[1] = 9);
} else
{var statearr_10430_10449 = state_10421__$1;(statearr_10430_10449[1] = 10);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10422 === 7))
{var inst_10417 = (state_10421[2]);var state_10421__$1 = state_10421;var statearr_10431_10450 = state_10421__$1;(statearr_10431_10450[2] = inst_10417);
(statearr_10431_10450[1] = 3);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10422 === 8))
{var inst_10414 = (state_10421[2]);var state_10421__$1 = (function (){var statearr_10432 = state_10421;(statearr_10432[9] = inst_10414);
return statearr_10432;
})();var statearr_10433_10451 = state_10421__$1;(statearr_10433_10451[2] = null);
(statearr_10433_10451[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10422 === 9))
{var state_10421__$1 = state_10421;var statearr_10434_10452 = state_10421__$1;(statearr_10434_10452[2] = tc);
(statearr_10434_10452[1] = 11);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10422 === 10))
{var state_10421__$1 = state_10421;var statearr_10435_10453 = state_10421__$1;(statearr_10435_10453[2] = fc);
(statearr_10435_10453[1] = 11);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10422 === 11))
{var inst_10402 = (state_10421[7]);var inst_10412 = (state_10421[2]);var state_10421__$1 = state_10421;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10421__$1,8,inst_10412,inst_10402);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
});return ((function (switch__6219__auto__){
return (function() {
var state_machine__6220__auto__ = null;
var state_machine__6220__auto____0 = (function (){var statearr_10439 = [null,null,null,null,null,null,null,null,null,null];(statearr_10439[0] = state_machine__6220__auto__);
(statearr_10439[1] = 1);
return statearr_10439;
});
var state_machine__6220__auto____1 = (function (state_10421){while(true){
var ret_value__6221__auto__ = (function (){try{while(true){
var result__6222__auto__ = switch__6219__auto__.call(null,state_10421);if(cljs.core.keyword_identical_QMARK_.call(null,result__6222__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__6222__auto__;
}
break;
}
}catch (e10440){if((e10440 instanceof Object))
{var ex__6223__auto__ = e10440;var statearr_10441_10454 = state_10421;(statearr_10441_10454[5] = ex__6223__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10421);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e10440;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6221__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__10455 = state_10421;
state_10421 = G__10455;
continue;
}
} else
{return ret_value__6221__auto__;
}
break;
}
});
state_machine__6220__auto__ = function(state_10421){
switch(arguments.length){
case 0:
return state_machine__6220__auto____0.call(this);
case 1:
return state_machine__6220__auto____1.call(this,state_10421);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__6220__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__6220__auto____0;
state_machine__6220__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__6220__auto____1;
return state_machine__6220__auto__;
})()
;})(switch__6219__auto__))
})();var state__6236__auto__ = (function (){var statearr_10442 = f__6235__auto__.call(null);(statearr_10442[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__6234__auto___10443);
return statearr_10442;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6236__auto__);
}));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});
split = function(p,ch,t_buf_or_n,f_buf_or_n){
switch(arguments.length){
case 2:
return split__2.call(this,p,ch);
case 4:
return split__4.call(this,p,ch,t_buf_or_n,f_buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
split.cljs$core$IFn$_invoke$arity$2 = split__2;
split.cljs$core$IFn$_invoke$arity$4 = split__4;
return split;
})()
;
/**
* f should be a function of 2 arguments. Returns a channel containing
* the single result of applying f to init and the first item from the
* channel, then applying f to that result and the 2nd item, etc. If
* the channel closes without yielding items, returns init and f is not
* called. ch must close before reduce produces a result.
*/
cljs.core.async.reduce = (function reduce(f,init,ch){var c__6234__auto__ = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,(function (){var f__6235__auto__ = (function (){var switch__6219__auto__ = (function (state_10502){var state_val_10503 = (state_10502[1]);if((state_val_10503 === 7))
{var inst_10498 = (state_10502[2]);var state_10502__$1 = state_10502;var statearr_10504_10520 = state_10502__$1;(statearr_10504_10520[2] = inst_10498);
(statearr_10504_10520[1] = 3);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10503 === 6))
{var inst_10488 = (state_10502[7]);var inst_10491 = (state_10502[8]);var inst_10495 = f.call(null,inst_10488,inst_10491);var inst_10488__$1 = inst_10495;var state_10502__$1 = (function (){var statearr_10505 = state_10502;(statearr_10505[7] = inst_10488__$1);
return statearr_10505;
})();var statearr_10506_10521 = state_10502__$1;(statearr_10506_10521[2] = null);
(statearr_10506_10521[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10503 === 5))
{var inst_10488 = (state_10502[7]);var state_10502__$1 = state_10502;var statearr_10507_10522 = state_10502__$1;(statearr_10507_10522[2] = inst_10488);
(statearr_10507_10522[1] = 7);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10503 === 4))
{var inst_10491 = (state_10502[8]);var inst_10491__$1 = (state_10502[2]);var inst_10492 = (inst_10491__$1 == null);var state_10502__$1 = (function (){var statearr_10508 = state_10502;(statearr_10508[8] = inst_10491__$1);
return statearr_10508;
})();if(cljs.core.truth_(inst_10492))
{var statearr_10509_10523 = state_10502__$1;(statearr_10509_10523[1] = 5);
} else
{var statearr_10510_10524 = state_10502__$1;(statearr_10510_10524[1] = 6);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10503 === 3))
{var inst_10500 = (state_10502[2]);var state_10502__$1 = state_10502;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10502__$1,inst_10500);
} else
{if((state_val_10503 === 2))
{var state_10502__$1 = state_10502;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_10502__$1,4,ch);
} else
{if((state_val_10503 === 1))
{var inst_10488 = init;var state_10502__$1 = (function (){var statearr_10511 = state_10502;(statearr_10511[7] = inst_10488);
return statearr_10511;
})();var statearr_10512_10525 = state_10502__$1;(statearr_10512_10525[2] = null);
(statearr_10512_10525[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{return null;
}
}
}
}
}
}
}
});return ((function (switch__6219__auto__){
return (function() {
var state_machine__6220__auto__ = null;
var state_machine__6220__auto____0 = (function (){var statearr_10516 = [null,null,null,null,null,null,null,null,null];(statearr_10516[0] = state_machine__6220__auto__);
(statearr_10516[1] = 1);
return statearr_10516;
});
var state_machine__6220__auto____1 = (function (state_10502){while(true){
var ret_value__6221__auto__ = (function (){try{while(true){
var result__6222__auto__ = switch__6219__auto__.call(null,state_10502);if(cljs.core.keyword_identical_QMARK_.call(null,result__6222__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__6222__auto__;
}
break;
}
}catch (e10517){if((e10517 instanceof Object))
{var ex__6223__auto__ = e10517;var statearr_10518_10526 = state_10502;(statearr_10518_10526[5] = ex__6223__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10502);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e10517;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6221__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__10527 = state_10502;
state_10502 = G__10527;
continue;
}
} else
{return ret_value__6221__auto__;
}
break;
}
});
state_machine__6220__auto__ = function(state_10502){
switch(arguments.length){
case 0:
return state_machine__6220__auto____0.call(this);
case 1:
return state_machine__6220__auto____1.call(this,state_10502);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__6220__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__6220__auto____0;
state_machine__6220__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__6220__auto____1;
return state_machine__6220__auto__;
})()
;})(switch__6219__auto__))
})();var state__6236__auto__ = (function (){var statearr_10519 = f__6235__auto__.call(null);(statearr_10519[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__6234__auto__);
return statearr_10519;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6236__auto__);
}));
return c__6234__auto__;
});
/**
* Puts the contents of coll into the supplied channel.
* 
* By default the channel will be closed after the items are copied,
* but can be determined by the close? parameter.
* 
* Returns a channel which will close after the items are copied.
*/
cljs.core.async.onto_chan = (function() {
var onto_chan = null;
var onto_chan__2 = (function (ch,coll){return onto_chan.call(null,ch,coll,true);
});
var onto_chan__3 = (function (ch,coll,close_QMARK_){var c__6234__auto__ = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,(function (){var f__6235__auto__ = (function (){var switch__6219__auto__ = (function (state_10589){var state_val_10590 = (state_10589[1]);if((state_val_10590 === 1))
{var inst_10569 = cljs.core.seq.call(null,coll);var inst_10570 = inst_10569;var state_10589__$1 = (function (){var statearr_10591 = state_10589;(statearr_10591[7] = inst_10570);
return statearr_10591;
})();var statearr_10592_10610 = state_10589__$1;(statearr_10592_10610[2] = null);
(statearr_10592_10610[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10590 === 2))
{var inst_10570 = (state_10589[7]);var state_10589__$1 = state_10589;if(cljs.core.truth_(inst_10570))
{var statearr_10593_10611 = state_10589__$1;(statearr_10593_10611[1] = 4);
} else
{var statearr_10594_10612 = state_10589__$1;(statearr_10594_10612[1] = 5);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10590 === 3))
{var inst_10587 = (state_10589[2]);var state_10589__$1 = state_10589;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10589__$1,inst_10587);
} else
{if((state_val_10590 === 4))
{var inst_10570 = (state_10589[7]);var inst_10573 = cljs.core.first.call(null,inst_10570);var state_10589__$1 = state_10589;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10589__$1,7,ch,inst_10573);
} else
{if((state_val_10590 === 5))
{var state_10589__$1 = state_10589;if(cljs.core.truth_(close_QMARK_))
{var statearr_10595_10613 = state_10589__$1;(statearr_10595_10613[1] = 8);
} else
{var statearr_10596_10614 = state_10589__$1;(statearr_10596_10614[1] = 9);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10590 === 6))
{var inst_10585 = (state_10589[2]);var state_10589__$1 = state_10589;var statearr_10597_10615 = state_10589__$1;(statearr_10597_10615[2] = inst_10585);
(statearr_10597_10615[1] = 3);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10590 === 7))
{var inst_10570 = (state_10589[7]);var inst_10575 = (state_10589[2]);var inst_10576 = cljs.core.next.call(null,inst_10570);var inst_10570__$1 = inst_10576;var state_10589__$1 = (function (){var statearr_10598 = state_10589;(statearr_10598[8] = inst_10575);
(statearr_10598[7] = inst_10570__$1);
return statearr_10598;
})();var statearr_10599_10616 = state_10589__$1;(statearr_10599_10616[2] = null);
(statearr_10599_10616[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10590 === 8))
{var inst_10580 = cljs.core.async.close_BANG_.call(null,ch);var state_10589__$1 = state_10589;var statearr_10600_10617 = state_10589__$1;(statearr_10600_10617[2] = inst_10580);
(statearr_10600_10617[1] = 10);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10590 === 9))
{var state_10589__$1 = state_10589;var statearr_10601_10618 = state_10589__$1;(statearr_10601_10618[2] = null);
(statearr_10601_10618[1] = 10);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10590 === 10))
{var inst_10583 = (state_10589[2]);var state_10589__$1 = state_10589;var statearr_10602_10619 = state_10589__$1;(statearr_10602_10619[2] = inst_10583);
(statearr_10602_10619[1] = 6);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
});return ((function (switch__6219__auto__){
return (function() {
var state_machine__6220__auto__ = null;
var state_machine__6220__auto____0 = (function (){var statearr_10606 = [null,null,null,null,null,null,null,null,null];(statearr_10606[0] = state_machine__6220__auto__);
(statearr_10606[1] = 1);
return statearr_10606;
});
var state_machine__6220__auto____1 = (function (state_10589){while(true){
var ret_value__6221__auto__ = (function (){try{while(true){
var result__6222__auto__ = switch__6219__auto__.call(null,state_10589);if(cljs.core.keyword_identical_QMARK_.call(null,result__6222__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__6222__auto__;
}
break;
}
}catch (e10607){if((e10607 instanceof Object))
{var ex__6223__auto__ = e10607;var statearr_10608_10620 = state_10589;(statearr_10608_10620[5] = ex__6223__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10589);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e10607;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6221__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__10621 = state_10589;
state_10589 = G__10621;
continue;
}
} else
{return ret_value__6221__auto__;
}
break;
}
});
state_machine__6220__auto__ = function(state_10589){
switch(arguments.length){
case 0:
return state_machine__6220__auto____0.call(this);
case 1:
return state_machine__6220__auto____1.call(this,state_10589);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__6220__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__6220__auto____0;
state_machine__6220__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__6220__auto____1;
return state_machine__6220__auto__;
})()
;})(switch__6219__auto__))
})();var state__6236__auto__ = (function (){var statearr_10609 = f__6235__auto__.call(null);(statearr_10609[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__6234__auto__);
return statearr_10609;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6236__auto__);
}));
return c__6234__auto__;
});
onto_chan = function(ch,coll,close_QMARK_){
switch(arguments.length){
case 2:
return onto_chan__2.call(this,ch,coll);
case 3:
return onto_chan__3.call(this,ch,coll,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
onto_chan.cljs$core$IFn$_invoke$arity$2 = onto_chan__2;
onto_chan.cljs$core$IFn$_invoke$arity$3 = onto_chan__3;
return onto_chan;
})()
;
/**
* Creates and returns a channel which contains the contents of coll,
* closing when exhausted.
*/
cljs.core.async.to_chan = (function to_chan(coll){var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,100,coll));cljs.core.async.onto_chan.call(null,ch,coll);
return ch;
});
cljs.core.async.Mux = (function (){var obj10623 = {};return obj10623;
})();
cljs.core.async.muxch_STAR_ = (function muxch_STAR_(_){if((function (){var and__3397__auto__ = _;if(and__3397__auto__)
{return _.cljs$core$async$Mux$muxch_STAR_$arity$1;
} else
{return and__3397__auto__;
}
})())
{return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else
{var x__4030__auto__ = (((_ == null))?null:_);return (function (){var or__3409__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4030__auto__)]);if(or__3409__auto__)
{return or__3409__auto__;
} else
{var or__3409__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);if(or__3409__auto____$1)
{return or__3409__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
})().call(null,_);
}
});
cljs.core.async.Mult = (function (){var obj10625 = {};return obj10625;
})();
cljs.core.async.tap_STAR_ = (function tap_STAR_(m,ch,close_QMARK_){if((function (){var and__3397__auto__ = m;if(and__3397__auto__)
{return m.cljs$core$async$Mult$tap_STAR_$arity$3;
} else
{return and__3397__auto__;
}
})())
{return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else
{var x__4030__auto__ = (((m == null))?null:m);return (function (){var or__3409__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4030__auto__)]);if(or__3409__auto__)
{return or__3409__auto__;
} else
{var or__3409__auto____$1 = (cljs.core.async.tap_STAR_["_"]);if(or__3409__auto____$1)
{return or__3409__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
})().call(null,m,ch,close_QMARK_);
}
});
cljs.core.async.untap_STAR_ = (function untap_STAR_(m,ch){if((function (){var and__3397__auto__ = m;if(and__3397__auto__)
{return m.cljs$core$async$Mult$untap_STAR_$arity$2;
} else
{return and__3397__auto__;
}
})())
{return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else
{var x__4030__auto__ = (((m == null))?null:m);return (function (){var or__3409__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4030__auto__)]);if(or__3409__auto__)
{return or__3409__auto__;
} else
{var or__3409__auto____$1 = (cljs.core.async.untap_STAR_["_"]);if(or__3409__auto____$1)
{return or__3409__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
})().call(null,m,ch);
}
});
cljs.core.async.untap_all_STAR_ = (function untap_all_STAR_(m){if((function (){var and__3397__auto__ = m;if(and__3397__auto__)
{return m.cljs$core$async$Mult$untap_all_STAR_$arity$1;
} else
{return and__3397__auto__;
}
})())
{return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else
{var x__4030__auto__ = (((m == null))?null:m);return (function (){var or__3409__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4030__auto__)]);if(or__3409__auto__)
{return or__3409__auto__;
} else
{var or__3409__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);if(or__3409__auto____$1)
{return or__3409__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
})().call(null,m);
}
});
/**
* Creates and returns a mult(iple) of the supplied channel. Channels
* containing copies of the channel can be created with 'tap', and
* detached with 'untap'.
* 
* Each item is distributed to all taps in parallel and synchronously,
* i.e. each tap must accept before the next item is distributed. Use
* buffering/windowing to prevent slow taps from holding up the mult.
* 
* Items received when there are no taps get dropped.
* 
* If a tap put throws an exception, it will be removed from the mult.
*/
cljs.core.async.mult = (function mult(ch){var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);var m = (function (){if(typeof cljs.core.async.t10849 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t10849 = (function (cs,ch,mult,meta10850){
this.cs = cs;
this.ch = ch;
this.mult = mult;
this.meta10850 = meta10850;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t10849.cljs$lang$type = true;
cljs.core.async.t10849.cljs$lang$ctorStr = "cljs.core.async/t10849";
cljs.core.async.t10849.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__3971__auto__,writer__3972__auto__,opt__3973__auto__){return cljs.core._write.call(null,writer__3972__auto__,"cljs.core.async/t10849");
});})(cs))
;
cljs.core.async.t10849.prototype.cljs$core$async$Mult$ = true;
cljs.core.async.t10849.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$2,close_QMARK_){var self__ = this;
var ___$1 = this;cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$2,close_QMARK_);
return null;
});})(cs))
;
cljs.core.async.t10849.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$2){var self__ = this;
var ___$1 = this;cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$2);
return null;
});})(cs))
;
cljs.core.async.t10849.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){var self__ = this;
var ___$1 = this;cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);
return null;
});})(cs))
;
cljs.core.async.t10849.prototype.cljs$core$async$Mux$ = true;
cljs.core.async.t10849.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){var self__ = this;
var ___$1 = this;return self__.ch;
});})(cs))
;
cljs.core.async.t10849.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_10851){var self__ = this;
var _10851__$1 = this;return self__.meta10850;
});})(cs))
;
cljs.core.async.t10849.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_10851,meta10850__$1){var self__ = this;
var _10851__$1 = this;return (new cljs.core.async.t10849(self__.cs,self__.ch,self__.mult,meta10850__$1));
});})(cs))
;
cljs.core.async.__GT_t10849 = ((function (cs){
return (function __GT_t10849(cs__$1,ch__$1,mult__$1,meta10850){return (new cljs.core.async.t10849(cs__$1,ch__$1,mult__$1,meta10850));
});})(cs))
;
}
return (new cljs.core.async.t10849(cs,ch,mult,null));
})();var dchan = cljs.core.async.chan.call(null,1);var dctr = cljs.core.atom.call(null,null);var done = ((function (cs,m,dchan,dctr){
return (function (){if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === 0))
{return cljs.core.async.put_BANG_.call(null,dchan,true);
} else
{return null;
}
});})(cs,m,dchan,dctr))
;var c__6234__auto___11072 = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,(function (){var f__6235__auto__ = (function (){var switch__6219__auto__ = (function (state_10986){var state_val_10987 = (state_10986[1]);if((state_val_10987 === 32))
{var inst_10930 = (state_10986[7]);var inst_10854 = (state_10986[8]);var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_10986,31,Object,null,30);var inst_10937 = cljs.core.async.put_BANG_.call(null,inst_10930,inst_10854,done);var state_10986__$1 = state_10986;var statearr_10988_11073 = state_10986__$1;(statearr_10988_11073[2] = inst_10937);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10986__$1);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10987 === 1))
{var state_10986__$1 = state_10986;var statearr_10989_11074 = state_10986__$1;(statearr_10989_11074[2] = null);
(statearr_10989_11074[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10987 === 33))
{var inst_10943 = (state_10986[9]);var inst_10945 = cljs.core.chunked_seq_QMARK_.call(null,inst_10943);var state_10986__$1 = state_10986;if(inst_10945)
{var statearr_10990_11075 = state_10986__$1;(statearr_10990_11075[1] = 36);
} else
{var statearr_10991_11076 = state_10986__$1;(statearr_10991_11076[1] = 37);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10987 === 2))
{var state_10986__$1 = state_10986;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_10986__$1,4,ch);
} else
{if((state_val_10987 === 34))
{var state_10986__$1 = state_10986;var statearr_10992_11077 = state_10986__$1;(statearr_10992_11077[2] = null);
(statearr_10992_11077[1] = 35);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10987 === 3))
{var inst_10984 = (state_10986[2]);var state_10986__$1 = state_10986;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10986__$1,inst_10984);
} else
{if((state_val_10987 === 35))
{var inst_10968 = (state_10986[2]);var state_10986__$1 = state_10986;var statearr_10993_11078 = state_10986__$1;(statearr_10993_11078[2] = inst_10968);
(statearr_10993_11078[1] = 29);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10987 === 4))
{var inst_10854 = (state_10986[8]);var inst_10854__$1 = (state_10986[2]);var inst_10855 = (inst_10854__$1 == null);var state_10986__$1 = (function (){var statearr_10994 = state_10986;(statearr_10994[8] = inst_10854__$1);
return statearr_10994;
})();if(cljs.core.truth_(inst_10855))
{var statearr_10995_11079 = state_10986__$1;(statearr_10995_11079[1] = 5);
} else
{var statearr_10996_11080 = state_10986__$1;(statearr_10996_11080[1] = 6);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10987 === 36))
{var inst_10943 = (state_10986[9]);var inst_10947 = cljs.core.chunk_first.call(null,inst_10943);var inst_10948 = cljs.core.chunk_rest.call(null,inst_10943);var inst_10949 = cljs.core.count.call(null,inst_10947);var inst_10922 = inst_10948;var inst_10923 = inst_10947;var inst_10924 = inst_10949;var inst_10925 = 0;var state_10986__$1 = (function (){var statearr_10997 = state_10986;(statearr_10997[10] = inst_10922);
(statearr_10997[11] = inst_10924);
(statearr_10997[12] = inst_10923);
(statearr_10997[13] = inst_10925);
return statearr_10997;
})();var statearr_10998_11081 = state_10986__$1;(statearr_10998_11081[2] = null);
(statearr_10998_11081[1] = 25);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10987 === 5))
{var inst_10861 = cljs.core.deref.call(null,cs);var inst_10862 = cljs.core.seq.call(null,inst_10861);var inst_10863 = inst_10862;var inst_10864 = null;var inst_10865 = 0;var inst_10866 = 0;var state_10986__$1 = (function (){var statearr_10999 = state_10986;(statearr_10999[14] = inst_10866);
(statearr_10999[15] = inst_10863);
(statearr_10999[16] = inst_10864);
(statearr_10999[17] = inst_10865);
return statearr_10999;
})();var statearr_11000_11082 = state_10986__$1;(statearr_11000_11082[2] = null);
(statearr_11000_11082[1] = 8);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10987 === 37))
{var inst_10943 = (state_10986[9]);var inst_10952 = cljs.core.first.call(null,inst_10943);var state_10986__$1 = (function (){var statearr_11001 = state_10986;(statearr_11001[18] = inst_10952);
return statearr_11001;
})();var statearr_11002_11083 = state_10986__$1;(statearr_11002_11083[2] = null);
(statearr_11002_11083[1] = 41);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10987 === 6))
{var inst_10914 = (state_10986[19]);var inst_10913 = cljs.core.deref.call(null,cs);var inst_10914__$1 = cljs.core.keys.call(null,inst_10913);var inst_10915 = cljs.core.count.call(null,inst_10914__$1);var inst_10916 = cljs.core.reset_BANG_.call(null,dctr,inst_10915);var inst_10921 = cljs.core.seq.call(null,inst_10914__$1);var inst_10922 = inst_10921;var inst_10923 = null;var inst_10924 = 0;var inst_10925 = 0;var state_10986__$1 = (function (){var statearr_11003 = state_10986;(statearr_11003[20] = inst_10916);
(statearr_11003[19] = inst_10914__$1);
(statearr_11003[10] = inst_10922);
(statearr_11003[11] = inst_10924);
(statearr_11003[12] = inst_10923);
(statearr_11003[13] = inst_10925);
return statearr_11003;
})();var statearr_11004_11084 = state_10986__$1;(statearr_11004_11084[2] = null);
(statearr_11004_11084[1] = 25);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10987 === 38))
{var inst_10965 = (state_10986[2]);var state_10986__$1 = state_10986;var statearr_11005_11085 = state_10986__$1;(statearr_11005_11085[2] = inst_10965);
(statearr_11005_11085[1] = 35);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10987 === 7))
{var inst_10982 = (state_10986[2]);var state_10986__$1 = state_10986;var statearr_11006_11086 = state_10986__$1;(statearr_11006_11086[2] = inst_10982);
(statearr_11006_11086[1] = 3);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10987 === 39))
{var inst_10943 = (state_10986[9]);var inst_10961 = (state_10986[2]);var inst_10962 = cljs.core.next.call(null,inst_10943);var inst_10922 = inst_10962;var inst_10923 = null;var inst_10924 = 0;var inst_10925 = 0;var state_10986__$1 = (function (){var statearr_11007 = state_10986;(statearr_11007[21] = inst_10961);
(statearr_11007[10] = inst_10922);
(statearr_11007[11] = inst_10924);
(statearr_11007[12] = inst_10923);
(statearr_11007[13] = inst_10925);
return statearr_11007;
})();var statearr_11008_11087 = state_10986__$1;(statearr_11008_11087[2] = null);
(statearr_11008_11087[1] = 25);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10987 === 8))
{var inst_10866 = (state_10986[14]);var inst_10865 = (state_10986[17]);var inst_10868 = (inst_10866 < inst_10865);var inst_10869 = inst_10868;var state_10986__$1 = state_10986;if(cljs.core.truth_(inst_10869))
{var statearr_11009_11088 = state_10986__$1;(statearr_11009_11088[1] = 10);
} else
{var statearr_11010_11089 = state_10986__$1;(statearr_11010_11089[1] = 11);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10987 === 40))
{var inst_10952 = (state_10986[18]);var inst_10953 = (state_10986[2]);var inst_10954 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);var inst_10955 = cljs.core.async.untap_STAR_.call(null,m,inst_10952);var state_10986__$1 = (function (){var statearr_11011 = state_10986;(statearr_11011[22] = inst_10953);
(statearr_11011[23] = inst_10954);
return statearr_11011;
})();var statearr_11012_11090 = state_10986__$1;(statearr_11012_11090[2] = inst_10955);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10986__$1);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10987 === 9))
{var inst_10911 = (state_10986[2]);var state_10986__$1 = state_10986;var statearr_11013_11091 = state_10986__$1;(statearr_11013_11091[2] = inst_10911);
(statearr_11013_11091[1] = 7);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10987 === 41))
{var inst_10952 = (state_10986[18]);var inst_10854 = (state_10986[8]);var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_10986,40,Object,null,39);var inst_10959 = cljs.core.async.put_BANG_.call(null,inst_10952,inst_10854,done);var state_10986__$1 = state_10986;var statearr_11014_11092 = state_10986__$1;(statearr_11014_11092[2] = inst_10959);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10986__$1);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10987 === 10))
{var inst_10866 = (state_10986[14]);var inst_10864 = (state_10986[16]);var inst_10872 = cljs.core._nth.call(null,inst_10864,inst_10866);var inst_10873 = cljs.core.nth.call(null,inst_10872,0,null);var inst_10874 = cljs.core.nth.call(null,inst_10872,1,null);var state_10986__$1 = (function (){var statearr_11015 = state_10986;(statearr_11015[24] = inst_10873);
return statearr_11015;
})();if(cljs.core.truth_(inst_10874))
{var statearr_11016_11093 = state_10986__$1;(statearr_11016_11093[1] = 13);
} else
{var statearr_11017_11094 = state_10986__$1;(statearr_11017_11094[1] = 14);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10987 === 42))
{var state_10986__$1 = state_10986;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_10986__$1,45,dchan);
} else
{if((state_val_10987 === 11))
{var inst_10883 = (state_10986[25]);var inst_10863 = (state_10986[15]);var inst_10883__$1 = cljs.core.seq.call(null,inst_10863);var state_10986__$1 = (function (){var statearr_11018 = state_10986;(statearr_11018[25] = inst_10883__$1);
return statearr_11018;
})();if(inst_10883__$1)
{var statearr_11019_11095 = state_10986__$1;(statearr_11019_11095[1] = 16);
} else
{var statearr_11020_11096 = state_10986__$1;(statearr_11020_11096[1] = 17);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10987 === 43))
{var state_10986__$1 = state_10986;var statearr_11021_11097 = state_10986__$1;(statearr_11021_11097[2] = null);
(statearr_11021_11097[1] = 44);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10987 === 12))
{var inst_10909 = (state_10986[2]);var state_10986__$1 = state_10986;var statearr_11022_11098 = state_10986__$1;(statearr_11022_11098[2] = inst_10909);
(statearr_11022_11098[1] = 9);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10987 === 44))
{var inst_10979 = (state_10986[2]);var state_10986__$1 = (function (){var statearr_11023 = state_10986;(statearr_11023[26] = inst_10979);
return statearr_11023;
})();var statearr_11024_11099 = state_10986__$1;(statearr_11024_11099[2] = null);
(statearr_11024_11099[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10987 === 13))
{var inst_10873 = (state_10986[24]);var inst_10876 = cljs.core.async.close_BANG_.call(null,inst_10873);var state_10986__$1 = state_10986;var statearr_11025_11100 = state_10986__$1;(statearr_11025_11100[2] = inst_10876);
(statearr_11025_11100[1] = 15);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10987 === 45))
{var inst_10976 = (state_10986[2]);var state_10986__$1 = state_10986;var statearr_11029_11101 = state_10986__$1;(statearr_11029_11101[2] = inst_10976);
(statearr_11029_11101[1] = 44);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10987 === 14))
{var state_10986__$1 = state_10986;var statearr_11030_11102 = state_10986__$1;(statearr_11030_11102[2] = null);
(statearr_11030_11102[1] = 15);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10987 === 15))
{var inst_10866 = (state_10986[14]);var inst_10863 = (state_10986[15]);var inst_10864 = (state_10986[16]);var inst_10865 = (state_10986[17]);var inst_10879 = (state_10986[2]);var inst_10880 = (inst_10866 + 1);var tmp11026 = inst_10863;var tmp11027 = inst_10864;var tmp11028 = inst_10865;var inst_10863__$1 = tmp11026;var inst_10864__$1 = tmp11027;var inst_10865__$1 = tmp11028;var inst_10866__$1 = inst_10880;var state_10986__$1 = (function (){var statearr_11031 = state_10986;(statearr_11031[14] = inst_10866__$1);
(statearr_11031[27] = inst_10879);
(statearr_11031[15] = inst_10863__$1);
(statearr_11031[16] = inst_10864__$1);
(statearr_11031[17] = inst_10865__$1);
return statearr_11031;
})();var statearr_11032_11103 = state_10986__$1;(statearr_11032_11103[2] = null);
(statearr_11032_11103[1] = 8);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10987 === 16))
{var inst_10883 = (state_10986[25]);var inst_10885 = cljs.core.chunked_seq_QMARK_.call(null,inst_10883);var state_10986__$1 = state_10986;if(inst_10885)
{var statearr_11033_11104 = state_10986__$1;(statearr_11033_11104[1] = 19);
} else
{var statearr_11034_11105 = state_10986__$1;(statearr_11034_11105[1] = 20);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10987 === 17))
{var state_10986__$1 = state_10986;var statearr_11035_11106 = state_10986__$1;(statearr_11035_11106[2] = null);
(statearr_11035_11106[1] = 18);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10987 === 18))
{var inst_10907 = (state_10986[2]);var state_10986__$1 = state_10986;var statearr_11036_11107 = state_10986__$1;(statearr_11036_11107[2] = inst_10907);
(statearr_11036_11107[1] = 12);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10987 === 19))
{var inst_10883 = (state_10986[25]);var inst_10887 = cljs.core.chunk_first.call(null,inst_10883);var inst_10888 = cljs.core.chunk_rest.call(null,inst_10883);var inst_10889 = cljs.core.count.call(null,inst_10887);var inst_10863 = inst_10888;var inst_10864 = inst_10887;var inst_10865 = inst_10889;var inst_10866 = 0;var state_10986__$1 = (function (){var statearr_11037 = state_10986;(statearr_11037[14] = inst_10866);
(statearr_11037[15] = inst_10863);
(statearr_11037[16] = inst_10864);
(statearr_11037[17] = inst_10865);
return statearr_11037;
})();var statearr_11038_11108 = state_10986__$1;(statearr_11038_11108[2] = null);
(statearr_11038_11108[1] = 8);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10987 === 20))
{var inst_10883 = (state_10986[25]);var inst_10893 = cljs.core.first.call(null,inst_10883);var inst_10894 = cljs.core.nth.call(null,inst_10893,0,null);var inst_10895 = cljs.core.nth.call(null,inst_10893,1,null);var state_10986__$1 = (function (){var statearr_11039 = state_10986;(statearr_11039[28] = inst_10894);
return statearr_11039;
})();if(cljs.core.truth_(inst_10895))
{var statearr_11040_11109 = state_10986__$1;(statearr_11040_11109[1] = 22);
} else
{var statearr_11041_11110 = state_10986__$1;(statearr_11041_11110[1] = 23);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10987 === 21))
{var inst_10904 = (state_10986[2]);var state_10986__$1 = state_10986;var statearr_11042_11111 = state_10986__$1;(statearr_11042_11111[2] = inst_10904);
(statearr_11042_11111[1] = 18);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10987 === 22))
{var inst_10894 = (state_10986[28]);var inst_10897 = cljs.core.async.close_BANG_.call(null,inst_10894);var state_10986__$1 = state_10986;var statearr_11043_11112 = state_10986__$1;(statearr_11043_11112[2] = inst_10897);
(statearr_11043_11112[1] = 24);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10987 === 23))
{var state_10986__$1 = state_10986;var statearr_11044_11113 = state_10986__$1;(statearr_11044_11113[2] = null);
(statearr_11044_11113[1] = 24);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10987 === 24))
{var inst_10883 = (state_10986[25]);var inst_10900 = (state_10986[2]);var inst_10901 = cljs.core.next.call(null,inst_10883);var inst_10863 = inst_10901;var inst_10864 = null;var inst_10865 = 0;var inst_10866 = 0;var state_10986__$1 = (function (){var statearr_11045 = state_10986;(statearr_11045[29] = inst_10900);
(statearr_11045[14] = inst_10866);
(statearr_11045[15] = inst_10863);
(statearr_11045[16] = inst_10864);
(statearr_11045[17] = inst_10865);
return statearr_11045;
})();var statearr_11046_11114 = state_10986__$1;(statearr_11046_11114[2] = null);
(statearr_11046_11114[1] = 8);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10987 === 25))
{var inst_10924 = (state_10986[11]);var inst_10925 = (state_10986[13]);var inst_10927 = (inst_10925 < inst_10924);var inst_10928 = inst_10927;var state_10986__$1 = state_10986;if(cljs.core.truth_(inst_10928))
{var statearr_11047_11115 = state_10986__$1;(statearr_11047_11115[1] = 27);
} else
{var statearr_11048_11116 = state_10986__$1;(statearr_11048_11116[1] = 28);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10987 === 26))
{var inst_10914 = (state_10986[19]);var inst_10972 = (state_10986[2]);var inst_10973 = cljs.core.seq.call(null,inst_10914);var state_10986__$1 = (function (){var statearr_11049 = state_10986;(statearr_11049[30] = inst_10972);
return statearr_11049;
})();if(inst_10973)
{var statearr_11050_11117 = state_10986__$1;(statearr_11050_11117[1] = 42);
} else
{var statearr_11051_11118 = state_10986__$1;(statearr_11051_11118[1] = 43);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10987 === 27))
{var inst_10923 = (state_10986[12]);var inst_10925 = (state_10986[13]);var inst_10930 = cljs.core._nth.call(null,inst_10923,inst_10925);var state_10986__$1 = (function (){var statearr_11052 = state_10986;(statearr_11052[7] = inst_10930);
return statearr_11052;
})();var statearr_11053_11119 = state_10986__$1;(statearr_11053_11119[2] = null);
(statearr_11053_11119[1] = 32);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10987 === 28))
{var inst_10943 = (state_10986[9]);var inst_10922 = (state_10986[10]);var inst_10943__$1 = cljs.core.seq.call(null,inst_10922);var state_10986__$1 = (function (){var statearr_11057 = state_10986;(statearr_11057[9] = inst_10943__$1);
return statearr_11057;
})();if(inst_10943__$1)
{var statearr_11058_11120 = state_10986__$1;(statearr_11058_11120[1] = 33);
} else
{var statearr_11059_11121 = state_10986__$1;(statearr_11059_11121[1] = 34);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10987 === 29))
{var inst_10970 = (state_10986[2]);var state_10986__$1 = state_10986;var statearr_11060_11122 = state_10986__$1;(statearr_11060_11122[2] = inst_10970);
(statearr_11060_11122[1] = 26);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10987 === 30))
{var inst_10922 = (state_10986[10]);var inst_10924 = (state_10986[11]);var inst_10923 = (state_10986[12]);var inst_10925 = (state_10986[13]);var inst_10939 = (state_10986[2]);var inst_10940 = (inst_10925 + 1);var tmp11054 = inst_10922;var tmp11055 = inst_10924;var tmp11056 = inst_10923;var inst_10922__$1 = tmp11054;var inst_10923__$1 = tmp11056;var inst_10924__$1 = tmp11055;var inst_10925__$1 = inst_10940;var state_10986__$1 = (function (){var statearr_11061 = state_10986;(statearr_11061[31] = inst_10939);
(statearr_11061[10] = inst_10922__$1);
(statearr_11061[11] = inst_10924__$1);
(statearr_11061[12] = inst_10923__$1);
(statearr_11061[13] = inst_10925__$1);
return statearr_11061;
})();var statearr_11062_11123 = state_10986__$1;(statearr_11062_11123[2] = null);
(statearr_11062_11123[1] = 25);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_10987 === 31))
{var inst_10930 = (state_10986[7]);var inst_10931 = (state_10986[2]);var inst_10932 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);var inst_10933 = cljs.core.async.untap_STAR_.call(null,m,inst_10930);var state_10986__$1 = (function (){var statearr_11063 = state_10986;(statearr_11063[32] = inst_10932);
(statearr_11063[33] = inst_10931);
return statearr_11063;
})();var statearr_11064_11124 = state_10986__$1;(statearr_11064_11124[2] = inst_10933);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10986__$1);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});return ((function (switch__6219__auto__){
return (function() {
var state_machine__6220__auto__ = null;
var state_machine__6220__auto____0 = (function (){var statearr_11068 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_11068[0] = state_machine__6220__auto__);
(statearr_11068[1] = 1);
return statearr_11068;
});
var state_machine__6220__auto____1 = (function (state_10986){while(true){
var ret_value__6221__auto__ = (function (){try{while(true){
var result__6222__auto__ = switch__6219__auto__.call(null,state_10986);if(cljs.core.keyword_identical_QMARK_.call(null,result__6222__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__6222__auto__;
}
break;
}
}catch (e11069){if((e11069 instanceof Object))
{var ex__6223__auto__ = e11069;var statearr_11070_11125 = state_10986;(statearr_11070_11125[5] = ex__6223__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10986);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e11069;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6221__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__11126 = state_10986;
state_10986 = G__11126;
continue;
}
} else
{return ret_value__6221__auto__;
}
break;
}
});
state_machine__6220__auto__ = function(state_10986){
switch(arguments.length){
case 0:
return state_machine__6220__auto____0.call(this);
case 1:
return state_machine__6220__auto____1.call(this,state_10986);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__6220__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__6220__auto____0;
state_machine__6220__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__6220__auto____1;
return state_machine__6220__auto__;
})()
;})(switch__6219__auto__))
})();var state__6236__auto__ = (function (){var statearr_11071 = f__6235__auto__.call(null);(statearr_11071[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__6234__auto___11072);
return statearr_11071;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6236__auto__);
}));
return m;
});
/**
* Copies the mult source onto the supplied channel.
* 
* By default the channel will be closed when the source closes,
* but can be determined by the close? parameter.
*/
cljs.core.async.tap = (function() {
var tap = null;
var tap__2 = (function (mult,ch){return tap.call(null,mult,ch,true);
});
var tap__3 = (function (mult,ch,close_QMARK_){cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);
return ch;
});
tap = function(mult,ch,close_QMARK_){
switch(arguments.length){
case 2:
return tap__2.call(this,mult,ch);
case 3:
return tap__3.call(this,mult,ch,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
tap.cljs$core$IFn$_invoke$arity$2 = tap__2;
tap.cljs$core$IFn$_invoke$arity$3 = tap__3;
return tap;
})()
;
/**
* Disconnects a target channel from a mult
*/
cljs.core.async.untap = (function untap(mult,ch){return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
* Disconnects all target channels from a mult
*/
cljs.core.async.untap_all = (function untap_all(mult){return cljs.core.async.untap_all_STAR_.call(null,mult);
});
cljs.core.async.Mix = (function (){var obj11128 = {};return obj11128;
})();
cljs.core.async.admix_STAR_ = (function admix_STAR_(m,ch){if((function (){var and__3397__auto__ = m;if(and__3397__auto__)
{return m.cljs$core$async$Mix$admix_STAR_$arity$2;
} else
{return and__3397__auto__;
}
})())
{return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else
{var x__4030__auto__ = (((m == null))?null:m);return (function (){var or__3409__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4030__auto__)]);if(or__3409__auto__)
{return or__3409__auto__;
} else
{var or__3409__auto____$1 = (cljs.core.async.admix_STAR_["_"]);if(or__3409__auto____$1)
{return or__3409__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
})().call(null,m,ch);
}
});
cljs.core.async.unmix_STAR_ = (function unmix_STAR_(m,ch){if((function (){var and__3397__auto__ = m;if(and__3397__auto__)
{return m.cljs$core$async$Mix$unmix_STAR_$arity$2;
} else
{return and__3397__auto__;
}
})())
{return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else
{var x__4030__auto__ = (((m == null))?null:m);return (function (){var or__3409__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4030__auto__)]);if(or__3409__auto__)
{return or__3409__auto__;
} else
{var or__3409__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);if(or__3409__auto____$1)
{return or__3409__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
})().call(null,m,ch);
}
});
cljs.core.async.unmix_all_STAR_ = (function unmix_all_STAR_(m){if((function (){var and__3397__auto__ = m;if(and__3397__auto__)
{return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1;
} else
{return and__3397__auto__;
}
})())
{return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else
{var x__4030__auto__ = (((m == null))?null:m);return (function (){var or__3409__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4030__auto__)]);if(or__3409__auto__)
{return or__3409__auto__;
} else
{var or__3409__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);if(or__3409__auto____$1)
{return or__3409__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
})().call(null,m);
}
});
cljs.core.async.toggle_STAR_ = (function toggle_STAR_(m,state_map){if((function (){var and__3397__auto__ = m;if(and__3397__auto__)
{return m.cljs$core$async$Mix$toggle_STAR_$arity$2;
} else
{return and__3397__auto__;
}
})())
{return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else
{var x__4030__auto__ = (((m == null))?null:m);return (function (){var or__3409__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4030__auto__)]);if(or__3409__auto__)
{return or__3409__auto__;
} else
{var or__3409__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);if(or__3409__auto____$1)
{return or__3409__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
})().call(null,m,state_map);
}
});
cljs.core.async.solo_mode_STAR_ = (function solo_mode_STAR_(m,mode){if((function (){var and__3397__auto__ = m;if(and__3397__auto__)
{return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2;
} else
{return and__3397__auto__;
}
})())
{return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else
{var x__4030__auto__ = (((m == null))?null:m);return (function (){var or__3409__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4030__auto__)]);if(or__3409__auto__)
{return or__3409__auto__;
} else
{var or__3409__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);if(or__3409__auto____$1)
{return or__3409__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
})().call(null,m,mode);
}
});
/**
* Creates and returns a mix of one or more input channels which will
* be put on the supplied out channel. Input sources can be added to
* the mix with 'admix', and removed with 'unmix'. A mix supports
* soloing, muting and pausing multiple inputs atomically using
* 'toggle', and can solo using either muting or pausing as determined
* by 'solo-mode'.
* 
* Each channel can have zero or more boolean modes set via 'toggle':
* 
* :solo - when true, only this (ond other soloed) channel(s) will appear
* in the mix output channel. :mute and :pause states of soloed
* channels are ignored. If solo-mode is :mute, non-soloed
* channels are muted, if :pause, non-soloed channels are
* paused.
* 
* :mute - muted channels will have their contents consumed but not included in the mix
* :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
*/
cljs.core.async.mix = (function mix(out){var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",1120344424),null,new cljs.core.Keyword(null,"mute","mute",1017267595),null], null), null);var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",1017440337));var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1017267595));var change = cljs.core.async.chan.call(null);var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){if(cljs.core.truth_(attr.call(null,v)))
{return cljs.core.conj.call(null,ret,c);
} else
{return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){var chs = cljs.core.deref.call(null,cs);var mode = cljs.core.deref.call(null,solo_mode);var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",1017440337),chs);var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",1120344424),chs);return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1123523302),solos,new cljs.core.Keyword(null,"mutes","mutes",1118168300),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1017267595),chs),new cljs.core.Keyword(null,"reads","reads",1122290959),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",1120344424))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;var m = (function (){if(typeof cljs.core.async.t11238 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t11238 = (function (pick,out,attrs,cs,calc_state,solo_modes,mix,changed,change,solo_mode,meta11239){
this.pick = pick;
this.out = out;
this.attrs = attrs;
this.cs = cs;
this.calc_state = calc_state;
this.solo_modes = solo_modes;
this.mix = mix;
this.changed = changed;
this.change = change;
this.solo_mode = solo_mode;
this.meta11239 = meta11239;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t11238.cljs$lang$type = true;
cljs.core.async.t11238.cljs$lang$ctorStr = "cljs.core.async/t11238";
cljs.core.async.t11238.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__3971__auto__,writer__3972__auto__,opt__3973__auto__){return cljs.core._write.call(null,writer__3972__auto__,"cljs.core.async/t11238");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t11238.prototype.cljs$core$async$Mix$ = true;
cljs.core.async.t11238.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){var self__ = this;
var ___$1 = this;cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);
return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t11238.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){var self__ = this;
var ___$1 = this;cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);
return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t11238.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){var self__ = this;
var ___$1 = this;cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);
return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t11238.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){var self__ = this;
var ___$1 = this;cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);
return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t11238.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){var self__ = this;
var ___$1 = this;if(cljs.core.truth_(self__.solo_modes.call(null,mode)))
{} else
{throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",-1162732933,null),new cljs.core.Symbol(null,"mode","mode",-1637174436,null))))].join('')));
}
cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);
return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t11238.prototype.cljs$core$async$Mux$ = true;
cljs.core.async.t11238.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){var self__ = this;
var ___$1 = this;return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t11238.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_11240){var self__ = this;
var _11240__$1 = this;return self__.meta11239;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t11238.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_11240,meta11239__$1){var self__ = this;
var _11240__$1 = this;return (new cljs.core.async.t11238(self__.pick,self__.out,self__.attrs,self__.cs,self__.calc_state,self__.solo_modes,self__.mix,self__.changed,self__.change,self__.solo_mode,meta11239__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.__GT_t11238 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function __GT_t11238(pick__$1,out__$1,attrs__$1,cs__$1,calc_state__$1,solo_modes__$1,mix__$1,changed__$1,change__$1,solo_mode__$1,meta11239){return (new cljs.core.async.t11238(pick__$1,out__$1,attrs__$1,cs__$1,calc_state__$1,solo_modes__$1,mix__$1,changed__$1,change__$1,solo_mode__$1,meta11239));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
}
return (new cljs.core.async.t11238(pick,out,attrs,cs,calc_state,solo_modes,mix,changed,change,solo_mode,null));
})();var c__6234__auto___11347 = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,(function (){var f__6235__auto__ = (function (){var switch__6219__auto__ = (function (state_11305){var state_val_11306 = (state_11305[1]);if((state_val_11306 === 1))
{var inst_11244 = (state_11305[7]);var inst_11244__$1 = calc_state.call(null);var inst_11245 = cljs.core.seq_QMARK_.call(null,inst_11244__$1);var state_11305__$1 = (function (){var statearr_11307 = state_11305;(statearr_11307[7] = inst_11244__$1);
return statearr_11307;
})();if(inst_11245)
{var statearr_11308_11348 = state_11305__$1;(statearr_11308_11348[1] = 2);
} else
{var statearr_11309_11349 = state_11305__$1;(statearr_11309_11349[1] = 3);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11306 === 2))
{var inst_11244 = (state_11305[7]);var inst_11247 = cljs.core.apply.call(null,cljs.core.hash_map,inst_11244);var state_11305__$1 = state_11305;var statearr_11310_11350 = state_11305__$1;(statearr_11310_11350[2] = inst_11247);
(statearr_11310_11350[1] = 4);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11306 === 3))
{var inst_11244 = (state_11305[7]);var state_11305__$1 = state_11305;var statearr_11311_11351 = state_11305__$1;(statearr_11311_11351[2] = inst_11244);
(statearr_11311_11351[1] = 4);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11306 === 4))
{var inst_11244 = (state_11305[7]);var inst_11250 = (state_11305[2]);var inst_11251 = cljs.core.get.call(null,inst_11250,new cljs.core.Keyword(null,"reads","reads",1122290959));var inst_11252 = cljs.core.get.call(null,inst_11250,new cljs.core.Keyword(null,"mutes","mutes",1118168300));var inst_11253 = cljs.core.get.call(null,inst_11250,new cljs.core.Keyword(null,"solos","solos",1123523302));var inst_11254 = inst_11244;var state_11305__$1 = (function (){var statearr_11312 = state_11305;(statearr_11312[8] = inst_11252);
(statearr_11312[9] = inst_11253);
(statearr_11312[10] = inst_11251);
(statearr_11312[11] = inst_11254);
return statearr_11312;
})();var statearr_11313_11352 = state_11305__$1;(statearr_11313_11352[2] = null);
(statearr_11313_11352[1] = 5);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11306 === 5))
{var inst_11254 = (state_11305[11]);var inst_11257 = cljs.core.seq_QMARK_.call(null,inst_11254);var state_11305__$1 = state_11305;if(inst_11257)
{var statearr_11314_11353 = state_11305__$1;(statearr_11314_11353[1] = 7);
} else
{var statearr_11315_11354 = state_11305__$1;(statearr_11315_11354[1] = 8);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11306 === 6))
{var inst_11303 = (state_11305[2]);var state_11305__$1 = state_11305;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11305__$1,inst_11303);
} else
{if((state_val_11306 === 7))
{var inst_11254 = (state_11305[11]);var inst_11259 = cljs.core.apply.call(null,cljs.core.hash_map,inst_11254);var state_11305__$1 = state_11305;var statearr_11316_11355 = state_11305__$1;(statearr_11316_11355[2] = inst_11259);
(statearr_11316_11355[1] = 9);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11306 === 8))
{var inst_11254 = (state_11305[11]);var state_11305__$1 = state_11305;var statearr_11317_11356 = state_11305__$1;(statearr_11317_11356[2] = inst_11254);
(statearr_11317_11356[1] = 9);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11306 === 9))
{var inst_11262 = (state_11305[12]);var inst_11262__$1 = (state_11305[2]);var inst_11263 = cljs.core.get.call(null,inst_11262__$1,new cljs.core.Keyword(null,"reads","reads",1122290959));var inst_11264 = cljs.core.get.call(null,inst_11262__$1,new cljs.core.Keyword(null,"mutes","mutes",1118168300));var inst_11265 = cljs.core.get.call(null,inst_11262__$1,new cljs.core.Keyword(null,"solos","solos",1123523302));var state_11305__$1 = (function (){var statearr_11318 = state_11305;(statearr_11318[13] = inst_11265);
(statearr_11318[14] = inst_11264);
(statearr_11318[12] = inst_11262__$1);
return statearr_11318;
})();return cljs.core.async.impl.ioc_helpers.ioc_alts_BANG_.call(null,state_11305__$1,10,inst_11263);
} else
{if((state_val_11306 === 10))
{var inst_11270 = (state_11305[15]);var inst_11269 = (state_11305[16]);var inst_11268 = (state_11305[2]);var inst_11269__$1 = cljs.core.nth.call(null,inst_11268,0,null);var inst_11270__$1 = cljs.core.nth.call(null,inst_11268,1,null);var inst_11271 = (inst_11269__$1 == null);var inst_11272 = cljs.core._EQ_.call(null,inst_11270__$1,change);var inst_11273 = (inst_11271) || (inst_11272);var state_11305__$1 = (function (){var statearr_11319 = state_11305;(statearr_11319[15] = inst_11270__$1);
(statearr_11319[16] = inst_11269__$1);
return statearr_11319;
})();if(cljs.core.truth_(inst_11273))
{var statearr_11320_11357 = state_11305__$1;(statearr_11320_11357[1] = 11);
} else
{var statearr_11321_11358 = state_11305__$1;(statearr_11321_11358[1] = 12);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11306 === 11))
{var inst_11269 = (state_11305[16]);var inst_11275 = (inst_11269 == null);var state_11305__$1 = state_11305;if(cljs.core.truth_(inst_11275))
{var statearr_11322_11359 = state_11305__$1;(statearr_11322_11359[1] = 14);
} else
{var statearr_11323_11360 = state_11305__$1;(statearr_11323_11360[1] = 15);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11306 === 12))
{var inst_11265 = (state_11305[13]);var inst_11270 = (state_11305[15]);var inst_11284 = (state_11305[17]);var inst_11284__$1 = inst_11265.call(null,inst_11270);var state_11305__$1 = (function (){var statearr_11324 = state_11305;(statearr_11324[17] = inst_11284__$1);
return statearr_11324;
})();if(cljs.core.truth_(inst_11284__$1))
{var statearr_11325_11361 = state_11305__$1;(statearr_11325_11361[1] = 17);
} else
{var statearr_11326_11362 = state_11305__$1;(statearr_11326_11362[1] = 18);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11306 === 13))
{var inst_11301 = (state_11305[2]);var state_11305__$1 = state_11305;var statearr_11327_11363 = state_11305__$1;(statearr_11327_11363[2] = inst_11301);
(statearr_11327_11363[1] = 6);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11306 === 14))
{var inst_11270 = (state_11305[15]);var inst_11277 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_11270);var state_11305__$1 = state_11305;var statearr_11328_11364 = state_11305__$1;(statearr_11328_11364[2] = inst_11277);
(statearr_11328_11364[1] = 16);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11306 === 15))
{var state_11305__$1 = state_11305;var statearr_11329_11365 = state_11305__$1;(statearr_11329_11365[2] = null);
(statearr_11329_11365[1] = 16);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11306 === 16))
{var inst_11280 = (state_11305[2]);var inst_11281 = calc_state.call(null);var inst_11254 = inst_11281;var state_11305__$1 = (function (){var statearr_11330 = state_11305;(statearr_11330[11] = inst_11254);
(statearr_11330[18] = inst_11280);
return statearr_11330;
})();var statearr_11331_11366 = state_11305__$1;(statearr_11331_11366[2] = null);
(statearr_11331_11366[1] = 5);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11306 === 17))
{var inst_11284 = (state_11305[17]);var state_11305__$1 = state_11305;var statearr_11332_11367 = state_11305__$1;(statearr_11332_11367[2] = inst_11284);
(statearr_11332_11367[1] = 19);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11306 === 18))
{var inst_11265 = (state_11305[13]);var inst_11264 = (state_11305[14]);var inst_11270 = (state_11305[15]);var inst_11287 = cljs.core.empty_QMARK_.call(null,inst_11265);var inst_11288 = inst_11264.call(null,inst_11270);var inst_11289 = cljs.core.not.call(null,inst_11288);var inst_11290 = (inst_11287) && (inst_11289);var state_11305__$1 = state_11305;var statearr_11333_11368 = state_11305__$1;(statearr_11333_11368[2] = inst_11290);
(statearr_11333_11368[1] = 19);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11306 === 19))
{var inst_11292 = (state_11305[2]);var state_11305__$1 = state_11305;if(cljs.core.truth_(inst_11292))
{var statearr_11334_11369 = state_11305__$1;(statearr_11334_11369[1] = 20);
} else
{var statearr_11335_11370 = state_11305__$1;(statearr_11335_11370[1] = 21);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11306 === 20))
{var inst_11269 = (state_11305[16]);var state_11305__$1 = state_11305;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11305__$1,23,out,inst_11269);
} else
{if((state_val_11306 === 21))
{var state_11305__$1 = state_11305;var statearr_11336_11371 = state_11305__$1;(statearr_11336_11371[2] = null);
(statearr_11336_11371[1] = 22);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11306 === 22))
{var inst_11262 = (state_11305[12]);var inst_11298 = (state_11305[2]);var inst_11254 = inst_11262;var state_11305__$1 = (function (){var statearr_11337 = state_11305;(statearr_11337[11] = inst_11254);
(statearr_11337[19] = inst_11298);
return statearr_11337;
})();var statearr_11338_11372 = state_11305__$1;(statearr_11338_11372[2] = null);
(statearr_11338_11372[1] = 5);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11306 === 23))
{var inst_11295 = (state_11305[2]);var state_11305__$1 = state_11305;var statearr_11339_11373 = state_11305__$1;(statearr_11339_11373[2] = inst_11295);
(statearr_11339_11373[1] = 22);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});return ((function (switch__6219__auto__){
return (function() {
var state_machine__6220__auto__ = null;
var state_machine__6220__auto____0 = (function (){var statearr_11343 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_11343[0] = state_machine__6220__auto__);
(statearr_11343[1] = 1);
return statearr_11343;
});
var state_machine__6220__auto____1 = (function (state_11305){while(true){
var ret_value__6221__auto__ = (function (){try{while(true){
var result__6222__auto__ = switch__6219__auto__.call(null,state_11305);if(cljs.core.keyword_identical_QMARK_.call(null,result__6222__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__6222__auto__;
}
break;
}
}catch (e11344){if((e11344 instanceof Object))
{var ex__6223__auto__ = e11344;var statearr_11345_11374 = state_11305;(statearr_11345_11374[5] = ex__6223__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11305);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e11344;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6221__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__11375 = state_11305;
state_11305 = G__11375;
continue;
}
} else
{return ret_value__6221__auto__;
}
break;
}
});
state_machine__6220__auto__ = function(state_11305){
switch(arguments.length){
case 0:
return state_machine__6220__auto____0.call(this);
case 1:
return state_machine__6220__auto____1.call(this,state_11305);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__6220__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__6220__auto____0;
state_machine__6220__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__6220__auto____1;
return state_machine__6220__auto__;
})()
;})(switch__6219__auto__))
})();var state__6236__auto__ = (function (){var statearr_11346 = f__6235__auto__.call(null);(statearr_11346[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__6234__auto___11347);
return statearr_11346;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6236__auto__);
}));
return m;
});
/**
* Adds ch as an input to the mix
*/
cljs.core.async.admix = (function admix(mix,ch){return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
* Removes ch as an input to the mix
*/
cljs.core.async.unmix = (function unmix(mix,ch){return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
* removes all inputs from the mix
*/
cljs.core.async.unmix_all = (function unmix_all(mix){return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
* Atomically sets the state(s) of one or more channels in a mix. The
* state map is a map of channels -> channel-state-map. A
* channel-state-map is a map of attrs -> boolean, where attr is one or
* more of :mute, :pause or :solo. Any states supplied are merged with
* the current state.
* 
* Note that channels can be added to a mix via toggle, which can be
* used to add channels in a particular (e.g. paused) state.
*/
cljs.core.async.toggle = (function toggle(mix,state_map){return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
* Sets the solo mode of the mix. mode must be one of :mute or :pause
*/
cljs.core.async.solo_mode = (function solo_mode(mix,mode){return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});
cljs.core.async.Pub = (function (){var obj11377 = {};return obj11377;
})();
cljs.core.async.sub_STAR_ = (function sub_STAR_(p,v,ch,close_QMARK_){if((function (){var and__3397__auto__ = p;if(and__3397__auto__)
{return p.cljs$core$async$Pub$sub_STAR_$arity$4;
} else
{return and__3397__auto__;
}
})())
{return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else
{var x__4030__auto__ = (((p == null))?null:p);return (function (){var or__3409__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4030__auto__)]);if(or__3409__auto__)
{return or__3409__auto__;
} else
{var or__3409__auto____$1 = (cljs.core.async.sub_STAR_["_"]);if(or__3409__auto____$1)
{return or__3409__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
})().call(null,p,v,ch,close_QMARK_);
}
});
cljs.core.async.unsub_STAR_ = (function unsub_STAR_(p,v,ch){if((function (){var and__3397__auto__ = p;if(and__3397__auto__)
{return p.cljs$core$async$Pub$unsub_STAR_$arity$3;
} else
{return and__3397__auto__;
}
})())
{return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else
{var x__4030__auto__ = (((p == null))?null:p);return (function (){var or__3409__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4030__auto__)]);if(or__3409__auto__)
{return or__3409__auto__;
} else
{var or__3409__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);if(or__3409__auto____$1)
{return or__3409__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
})().call(null,p,v,ch);
}
});
cljs.core.async.unsub_all_STAR_ = (function() {
var unsub_all_STAR_ = null;
var unsub_all_STAR___1 = (function (p){if((function (){var and__3397__auto__ = p;if(and__3397__auto__)
{return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1;
} else
{return and__3397__auto__;
}
})())
{return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else
{var x__4030__auto__ = (((p == null))?null:p);return (function (){var or__3409__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4030__auto__)]);if(or__3409__auto__)
{return or__3409__auto__;
} else
{var or__3409__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);if(or__3409__auto____$1)
{return or__3409__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
})().call(null,p);
}
});
var unsub_all_STAR___2 = (function (p,v){if((function (){var and__3397__auto__ = p;if(and__3397__auto__)
{return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2;
} else
{return and__3397__auto__;
}
})())
{return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else
{var x__4030__auto__ = (((p == null))?null:p);return (function (){var or__3409__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4030__auto__)]);if(or__3409__auto__)
{return or__3409__auto__;
} else
{var or__3409__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);if(or__3409__auto____$1)
{return or__3409__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
})().call(null,p,v);
}
});
unsub_all_STAR_ = function(p,v){
switch(arguments.length){
case 1:
return unsub_all_STAR___1.call(this,p);
case 2:
return unsub_all_STAR___2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = unsub_all_STAR___1;
unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = unsub_all_STAR___2;
return unsub_all_STAR_;
})()
;
/**
* Creates and returns a pub(lication) of the supplied channel,
* partitioned into topics by the topic-fn. topic-fn will be applied to
* each value on the channel and the result will determine the 'topic'
* on which that value will be put. Channels can be subscribed to
* receive copies of topics using 'sub', and unsubscribed using
* 'unsub'. Each topic will be handled by an internal mult on a
* dedicated channel. By default these internal channels are
* unbuffered, but a buf-fn can be supplied which, given a topic,
* creates a buffer with desired properties.
* 
* Each item is distributed to all subs in parallel and synchronously,
* i.e. each sub must accept before the next item is distributed. Use
* buffering/windowing to prevent slow subs from holding up the pub.
* 
* Items received when there are no matching subs get dropped.
* 
* Note that if buf-fns are used then each topic is handled
* asynchronously, i.e. if a channel is subscribed to more than one
* topic it should not expect them to be interleaved identically with
* the source.
*/
cljs.core.async.pub = (function() {
var pub = null;
var pub__2 = (function (ch,topic_fn){return pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});
var pub__3 = (function (ch,topic_fn,buf_fn){var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);var ensure_mult = ((function (mults){
return (function (topic){var or__3409__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);if(cljs.core.truth_(or__3409__auto__))
{return or__3409__auto__;
} else
{return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__3409__auto__,mults){
return (function (p1__11378_SHARP_){if(cljs.core.truth_(p1__11378_SHARP_.call(null,topic)))
{return p1__11378_SHARP_;
} else
{return cljs.core.assoc.call(null,p1__11378_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__3409__auto__,mults))
),topic);
}
});})(mults))
;var p = (function (){if(typeof cljs.core.async.t11503 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t11503 = (function (ensure_mult,mults,buf_fn,topic_fn,ch,pub,meta11504){
this.ensure_mult = ensure_mult;
this.mults = mults;
this.buf_fn = buf_fn;
this.topic_fn = topic_fn;
this.ch = ch;
this.pub = pub;
this.meta11504 = meta11504;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t11503.cljs$lang$type = true;
cljs.core.async.t11503.cljs$lang$ctorStr = "cljs.core.async/t11503";
cljs.core.async.t11503.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__3971__auto__,writer__3972__auto__,opt__3973__auto__){return cljs.core._write.call(null,writer__3972__auto__,"cljs.core.async/t11503");
});})(mults,ensure_mult))
;
cljs.core.async.t11503.prototype.cljs$core$async$Pub$ = true;
cljs.core.async.t11503.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$2,close_QMARK_){var self__ = this;
var p__$1 = this;var m = self__.ensure_mult.call(null,topic);return cljs.core.async.tap.call(null,m,ch__$2,close_QMARK_);
});})(mults,ensure_mult))
;
cljs.core.async.t11503.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$2){var self__ = this;
var p__$1 = this;var temp__4092__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);if(cljs.core.truth_(temp__4092__auto__))
{var m = temp__4092__auto__;return cljs.core.async.untap.call(null,m,ch__$2);
} else
{return null;
}
});})(mults,ensure_mult))
;
cljs.core.async.t11503.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){var self__ = this;
var ___$1 = this;return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;
cljs.core.async.t11503.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){var self__ = this;
var ___$1 = this;return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;
cljs.core.async.t11503.prototype.cljs$core$async$Mux$ = true;
cljs.core.async.t11503.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){var self__ = this;
var ___$1 = this;return self__.ch;
});})(mults,ensure_mult))
;
cljs.core.async.t11503.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_11505){var self__ = this;
var _11505__$1 = this;return self__.meta11504;
});})(mults,ensure_mult))
;
cljs.core.async.t11503.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_11505,meta11504__$1){var self__ = this;
var _11505__$1 = this;return (new cljs.core.async.t11503(self__.ensure_mult,self__.mults,self__.buf_fn,self__.topic_fn,self__.ch,self__.pub,meta11504__$1));
});})(mults,ensure_mult))
;
cljs.core.async.__GT_t11503 = ((function (mults,ensure_mult){
return (function __GT_t11503(ensure_mult__$1,mults__$1,buf_fn__$1,topic_fn__$1,ch__$1,pub__$1,meta11504){return (new cljs.core.async.t11503(ensure_mult__$1,mults__$1,buf_fn__$1,topic_fn__$1,ch__$1,pub__$1,meta11504));
});})(mults,ensure_mult))
;
}
return (new cljs.core.async.t11503(ensure_mult,mults,buf_fn,topic_fn,ch,pub,null));
})();var c__6234__auto___11627 = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,(function (){var f__6235__auto__ = (function (){var switch__6219__auto__ = (function (state_11579){var state_val_11580 = (state_11579[1]);if((state_val_11580 === 1))
{var state_11579__$1 = state_11579;var statearr_11581_11628 = state_11579__$1;(statearr_11581_11628[2] = null);
(statearr_11581_11628[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11580 === 2))
{var state_11579__$1 = state_11579;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11579__$1,4,ch);
} else
{if((state_val_11580 === 3))
{var inst_11577 = (state_11579[2]);var state_11579__$1 = state_11579;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11579__$1,inst_11577);
} else
{if((state_val_11580 === 4))
{var inst_11508 = (state_11579[7]);var inst_11508__$1 = (state_11579[2]);var inst_11509 = (inst_11508__$1 == null);var state_11579__$1 = (function (){var statearr_11582 = state_11579;(statearr_11582[7] = inst_11508__$1);
return statearr_11582;
})();if(cljs.core.truth_(inst_11509))
{var statearr_11583_11629 = state_11579__$1;(statearr_11583_11629[1] = 5);
} else
{var statearr_11584_11630 = state_11579__$1;(statearr_11584_11630[1] = 6);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11580 === 5))
{var inst_11515 = cljs.core.deref.call(null,mults);var inst_11516 = cljs.core.vals.call(null,inst_11515);var inst_11517 = cljs.core.seq.call(null,inst_11516);var inst_11518 = inst_11517;var inst_11519 = null;var inst_11520 = 0;var inst_11521 = 0;var state_11579__$1 = (function (){var statearr_11585 = state_11579;(statearr_11585[8] = inst_11518);
(statearr_11585[9] = inst_11519);
(statearr_11585[10] = inst_11521);
(statearr_11585[11] = inst_11520);
return statearr_11585;
})();var statearr_11586_11631 = state_11579__$1;(statearr_11586_11631[2] = null);
(statearr_11586_11631[1] = 8);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11580 === 6))
{var inst_11508 = (state_11579[7]);var inst_11556 = (state_11579[12]);var inst_11558 = (state_11579[13]);var inst_11556__$1 = topic_fn.call(null,inst_11508);var inst_11557 = cljs.core.deref.call(null,mults);var inst_11558__$1 = cljs.core.get.call(null,inst_11557,inst_11556__$1);var state_11579__$1 = (function (){var statearr_11587 = state_11579;(statearr_11587[12] = inst_11556__$1);
(statearr_11587[13] = inst_11558__$1);
return statearr_11587;
})();if(cljs.core.truth_(inst_11558__$1))
{var statearr_11588_11632 = state_11579__$1;(statearr_11588_11632[1] = 19);
} else
{var statearr_11589_11633 = state_11579__$1;(statearr_11589_11633[1] = 20);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11580 === 7))
{var inst_11575 = (state_11579[2]);var state_11579__$1 = state_11579;var statearr_11590_11634 = state_11579__$1;(statearr_11590_11634[2] = inst_11575);
(statearr_11590_11634[1] = 3);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11580 === 8))
{var inst_11521 = (state_11579[10]);var inst_11520 = (state_11579[11]);var inst_11523 = (inst_11521 < inst_11520);var inst_11524 = inst_11523;var state_11579__$1 = state_11579;if(cljs.core.truth_(inst_11524))
{var statearr_11594_11635 = state_11579__$1;(statearr_11594_11635[1] = 10);
} else
{var statearr_11595_11636 = state_11579__$1;(statearr_11595_11636[1] = 11);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11580 === 9))
{var inst_11554 = (state_11579[2]);var state_11579__$1 = state_11579;var statearr_11596_11637 = state_11579__$1;(statearr_11596_11637[2] = inst_11554);
(statearr_11596_11637[1] = 7);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11580 === 10))
{var inst_11518 = (state_11579[8]);var inst_11519 = (state_11579[9]);var inst_11521 = (state_11579[10]);var inst_11520 = (state_11579[11]);var inst_11526 = cljs.core._nth.call(null,inst_11519,inst_11521);var inst_11527 = cljs.core.async.muxch_STAR_.call(null,inst_11526);var inst_11528 = cljs.core.async.close_BANG_.call(null,inst_11527);var inst_11529 = (inst_11521 + 1);var tmp11591 = inst_11518;var tmp11592 = inst_11519;var tmp11593 = inst_11520;var inst_11518__$1 = tmp11591;var inst_11519__$1 = tmp11592;var inst_11520__$1 = tmp11593;var inst_11521__$1 = inst_11529;var state_11579__$1 = (function (){var statearr_11597 = state_11579;(statearr_11597[8] = inst_11518__$1);
(statearr_11597[9] = inst_11519__$1);
(statearr_11597[14] = inst_11528);
(statearr_11597[10] = inst_11521__$1);
(statearr_11597[11] = inst_11520__$1);
return statearr_11597;
})();var statearr_11598_11638 = state_11579__$1;(statearr_11598_11638[2] = null);
(statearr_11598_11638[1] = 8);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11580 === 11))
{var inst_11518 = (state_11579[8]);var inst_11532 = (state_11579[15]);var inst_11532__$1 = cljs.core.seq.call(null,inst_11518);var state_11579__$1 = (function (){var statearr_11599 = state_11579;(statearr_11599[15] = inst_11532__$1);
return statearr_11599;
})();if(inst_11532__$1)
{var statearr_11600_11639 = state_11579__$1;(statearr_11600_11639[1] = 13);
} else
{var statearr_11601_11640 = state_11579__$1;(statearr_11601_11640[1] = 14);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11580 === 12))
{var inst_11552 = (state_11579[2]);var state_11579__$1 = state_11579;var statearr_11602_11641 = state_11579__$1;(statearr_11602_11641[2] = inst_11552);
(statearr_11602_11641[1] = 9);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11580 === 13))
{var inst_11532 = (state_11579[15]);var inst_11534 = cljs.core.chunked_seq_QMARK_.call(null,inst_11532);var state_11579__$1 = state_11579;if(inst_11534)
{var statearr_11603_11642 = state_11579__$1;(statearr_11603_11642[1] = 16);
} else
{var statearr_11604_11643 = state_11579__$1;(statearr_11604_11643[1] = 17);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11580 === 14))
{var state_11579__$1 = state_11579;var statearr_11605_11644 = state_11579__$1;(statearr_11605_11644[2] = null);
(statearr_11605_11644[1] = 15);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11580 === 15))
{var inst_11550 = (state_11579[2]);var state_11579__$1 = state_11579;var statearr_11606_11645 = state_11579__$1;(statearr_11606_11645[2] = inst_11550);
(statearr_11606_11645[1] = 12);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11580 === 16))
{var inst_11532 = (state_11579[15]);var inst_11536 = cljs.core.chunk_first.call(null,inst_11532);var inst_11537 = cljs.core.chunk_rest.call(null,inst_11532);var inst_11538 = cljs.core.count.call(null,inst_11536);var inst_11518 = inst_11537;var inst_11519 = inst_11536;var inst_11520 = inst_11538;var inst_11521 = 0;var state_11579__$1 = (function (){var statearr_11607 = state_11579;(statearr_11607[8] = inst_11518);
(statearr_11607[9] = inst_11519);
(statearr_11607[10] = inst_11521);
(statearr_11607[11] = inst_11520);
return statearr_11607;
})();var statearr_11608_11646 = state_11579__$1;(statearr_11608_11646[2] = null);
(statearr_11608_11646[1] = 8);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11580 === 17))
{var inst_11532 = (state_11579[15]);var inst_11541 = cljs.core.first.call(null,inst_11532);var inst_11542 = cljs.core.async.muxch_STAR_.call(null,inst_11541);var inst_11543 = cljs.core.async.close_BANG_.call(null,inst_11542);var inst_11544 = cljs.core.next.call(null,inst_11532);var inst_11518 = inst_11544;var inst_11519 = null;var inst_11520 = 0;var inst_11521 = 0;var state_11579__$1 = (function (){var statearr_11609 = state_11579;(statearr_11609[16] = inst_11543);
(statearr_11609[8] = inst_11518);
(statearr_11609[9] = inst_11519);
(statearr_11609[10] = inst_11521);
(statearr_11609[11] = inst_11520);
return statearr_11609;
})();var statearr_11610_11647 = state_11579__$1;(statearr_11610_11647[2] = null);
(statearr_11610_11647[1] = 8);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11580 === 18))
{var inst_11547 = (state_11579[2]);var state_11579__$1 = state_11579;var statearr_11611_11648 = state_11579__$1;(statearr_11611_11648[2] = inst_11547);
(statearr_11611_11648[1] = 15);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11580 === 19))
{var state_11579__$1 = state_11579;var statearr_11612_11649 = state_11579__$1;(statearr_11612_11649[2] = null);
(statearr_11612_11649[1] = 24);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11580 === 20))
{var state_11579__$1 = state_11579;var statearr_11613_11650 = state_11579__$1;(statearr_11613_11650[2] = null);
(statearr_11613_11650[1] = 21);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11580 === 21))
{var inst_11572 = (state_11579[2]);var state_11579__$1 = (function (){var statearr_11614 = state_11579;(statearr_11614[17] = inst_11572);
return statearr_11614;
})();var statearr_11615_11651 = state_11579__$1;(statearr_11615_11651[2] = null);
(statearr_11615_11651[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11580 === 22))
{var inst_11569 = (state_11579[2]);var state_11579__$1 = state_11579;var statearr_11616_11652 = state_11579__$1;(statearr_11616_11652[2] = inst_11569);
(statearr_11616_11652[1] = 21);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11580 === 23))
{var inst_11556 = (state_11579[12]);var inst_11560 = (state_11579[2]);var inst_11561 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_11556);var state_11579__$1 = (function (){var statearr_11617 = state_11579;(statearr_11617[18] = inst_11560);
return statearr_11617;
})();var statearr_11618_11653 = state_11579__$1;(statearr_11618_11653[2] = inst_11561);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11579__$1);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11580 === 24))
{var inst_11508 = (state_11579[7]);var inst_11558 = (state_11579[13]);var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_11579,23,Object,null,22);var inst_11565 = cljs.core.async.muxch_STAR_.call(null,inst_11558);var state_11579__$1 = state_11579;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11579__$1,25,inst_11565,inst_11508);
} else
{if((state_val_11580 === 25))
{var inst_11567 = (state_11579[2]);var state_11579__$1 = state_11579;var statearr_11619_11654 = state_11579__$1;(statearr_11619_11654[2] = inst_11567);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11579__$1);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});return ((function (switch__6219__auto__){
return (function() {
var state_machine__6220__auto__ = null;
var state_machine__6220__auto____0 = (function (){var statearr_11623 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_11623[0] = state_machine__6220__auto__);
(statearr_11623[1] = 1);
return statearr_11623;
});
var state_machine__6220__auto____1 = (function (state_11579){while(true){
var ret_value__6221__auto__ = (function (){try{while(true){
var result__6222__auto__ = switch__6219__auto__.call(null,state_11579);if(cljs.core.keyword_identical_QMARK_.call(null,result__6222__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__6222__auto__;
}
break;
}
}catch (e11624){if((e11624 instanceof Object))
{var ex__6223__auto__ = e11624;var statearr_11625_11655 = state_11579;(statearr_11625_11655[5] = ex__6223__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11579);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e11624;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6221__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__11656 = state_11579;
state_11579 = G__11656;
continue;
}
} else
{return ret_value__6221__auto__;
}
break;
}
});
state_machine__6220__auto__ = function(state_11579){
switch(arguments.length){
case 0:
return state_machine__6220__auto____0.call(this);
case 1:
return state_machine__6220__auto____1.call(this,state_11579);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__6220__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__6220__auto____0;
state_machine__6220__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__6220__auto____1;
return state_machine__6220__auto__;
})()
;})(switch__6219__auto__))
})();var state__6236__auto__ = (function (){var statearr_11626 = f__6235__auto__.call(null);(statearr_11626[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__6234__auto___11627);
return statearr_11626;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6236__auto__);
}));
return p;
});
pub = function(ch,topic_fn,buf_fn){
switch(arguments.length){
case 2:
return pub__2.call(this,ch,topic_fn);
case 3:
return pub__3.call(this,ch,topic_fn,buf_fn);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pub.cljs$core$IFn$_invoke$arity$2 = pub__2;
pub.cljs$core$IFn$_invoke$arity$3 = pub__3;
return pub;
})()
;
/**
* Subscribes a channel to a topic of a pub.
* 
* By default the channel will be closed when the source closes,
* but can be determined by the close? parameter.
*/
cljs.core.async.sub = (function() {
var sub = null;
var sub__3 = (function (p,topic,ch){return sub.call(null,p,topic,ch,true);
});
var sub__4 = (function (p,topic,ch,close_QMARK_){return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});
sub = function(p,topic,ch,close_QMARK_){
switch(arguments.length){
case 3:
return sub__3.call(this,p,topic,ch);
case 4:
return sub__4.call(this,p,topic,ch,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
sub.cljs$core$IFn$_invoke$arity$3 = sub__3;
sub.cljs$core$IFn$_invoke$arity$4 = sub__4;
return sub;
})()
;
/**
* Unsubscribes a channel from a topic of a pub
*/
cljs.core.async.unsub = (function unsub(p,topic,ch){return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
* Unsubscribes all channels from a pub, or a topic of a pub
*/
cljs.core.async.unsub_all = (function() {
var unsub_all = null;
var unsub_all__1 = (function (p){return cljs.core.async.unsub_all_STAR_.call(null,p);
});
var unsub_all__2 = (function (p,topic){return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});
unsub_all = function(p,topic){
switch(arguments.length){
case 1:
return unsub_all__1.call(this,p);
case 2:
return unsub_all__2.call(this,p,topic);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unsub_all.cljs$core$IFn$_invoke$arity$1 = unsub_all__1;
unsub_all.cljs$core$IFn$_invoke$arity$2 = unsub_all__2;
return unsub_all;
})()
;
/**
* Takes a function and a collection of source channels, and returns a
* channel which contains the values produced by applying f to the set
* of first items taken from each source channel, followed by applying
* f to the set of second items from each channel, until any one of the
* channels is closed, at which point the output channel will be
* closed. The returned channel will be unbuffered by default, or a
* buf-or-n can be supplied
*/
cljs.core.async.map = (function() {
var map = null;
var map__2 = (function (f,chs){return map.call(null,f,chs,null);
});
var map__3 = (function (f,chs,buf_or_n){var chs__$1 = cljs.core.vec.call(null,chs);var out = cljs.core.async.chan.call(null,buf_or_n);var cnt = cljs.core.count.call(null,chs__$1);var rets = cljs.core.object_array.call(null,cnt);var dchan = cljs.core.async.chan.call(null,1);var dctr = cljs.core.atom.call(null,null);var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){(rets[i] = ret);
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === 0))
{return cljs.core.async.put_BANG_.call(null,dchan,rets.slice(0));
} else
{return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));var c__6234__auto___11793 = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,(function (){var f__6235__auto__ = (function (){var switch__6219__auto__ = (function (state_11763){var state_val_11764 = (state_11763[1]);if((state_val_11764 === 1))
{var state_11763__$1 = state_11763;var statearr_11765_11794 = state_11763__$1;(statearr_11765_11794[2] = null);
(statearr_11765_11794[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11764 === 2))
{var inst_11726 = cljs.core.reset_BANG_.call(null,dctr,cnt);var inst_11727 = 0;var state_11763__$1 = (function (){var statearr_11766 = state_11763;(statearr_11766[7] = inst_11727);
(statearr_11766[8] = inst_11726);
return statearr_11766;
})();var statearr_11767_11795 = state_11763__$1;(statearr_11767_11795[2] = null);
(statearr_11767_11795[1] = 4);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11764 === 3))
{var inst_11761 = (state_11763[2]);var state_11763__$1 = state_11763;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11763__$1,inst_11761);
} else
{if((state_val_11764 === 4))
{var inst_11727 = (state_11763[7]);var inst_11729 = (inst_11727 < cnt);var state_11763__$1 = state_11763;if(cljs.core.truth_(inst_11729))
{var statearr_11768_11796 = state_11763__$1;(statearr_11768_11796[1] = 6);
} else
{var statearr_11769_11797 = state_11763__$1;(statearr_11769_11797[1] = 7);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11764 === 5))
{var inst_11747 = (state_11763[2]);var state_11763__$1 = (function (){var statearr_11770 = state_11763;(statearr_11770[9] = inst_11747);
return statearr_11770;
})();return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11763__$1,12,dchan);
} else
{if((state_val_11764 === 6))
{var state_11763__$1 = state_11763;var statearr_11771_11798 = state_11763__$1;(statearr_11771_11798[2] = null);
(statearr_11771_11798[1] = 11);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11764 === 7))
{var state_11763__$1 = state_11763;var statearr_11772_11799 = state_11763__$1;(statearr_11772_11799[2] = null);
(statearr_11772_11799[1] = 8);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11764 === 8))
{var inst_11745 = (state_11763[2]);var state_11763__$1 = state_11763;var statearr_11773_11800 = state_11763__$1;(statearr_11773_11800[2] = inst_11745);
(statearr_11773_11800[1] = 5);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11764 === 9))
{var inst_11727 = (state_11763[7]);var inst_11740 = (state_11763[2]);var inst_11741 = (inst_11727 + 1);var inst_11727__$1 = inst_11741;var state_11763__$1 = (function (){var statearr_11774 = state_11763;(statearr_11774[10] = inst_11740);
(statearr_11774[7] = inst_11727__$1);
return statearr_11774;
})();var statearr_11775_11801 = state_11763__$1;(statearr_11775_11801[2] = null);
(statearr_11775_11801[1] = 4);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11764 === 10))
{var inst_11731 = (state_11763[2]);var inst_11732 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);var state_11763__$1 = (function (){var statearr_11776 = state_11763;(statearr_11776[11] = inst_11731);
return statearr_11776;
})();var statearr_11777_11802 = state_11763__$1;(statearr_11777_11802[2] = inst_11732);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11763__$1);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11764 === 11))
{var inst_11727 = (state_11763[7]);var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_11763,10,Object,null,9);var inst_11736 = chs__$1.call(null,inst_11727);var inst_11737 = done.call(null,inst_11727);var inst_11738 = cljs.core.async.take_BANG_.call(null,inst_11736,inst_11737);var state_11763__$1 = state_11763;var statearr_11778_11803 = state_11763__$1;(statearr_11778_11803[2] = inst_11738);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11763__$1);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11764 === 12))
{var inst_11749 = (state_11763[12]);var inst_11749__$1 = (state_11763[2]);var inst_11750 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_11749__$1);var state_11763__$1 = (function (){var statearr_11779 = state_11763;(statearr_11779[12] = inst_11749__$1);
return statearr_11779;
})();if(cljs.core.truth_(inst_11750))
{var statearr_11780_11804 = state_11763__$1;(statearr_11780_11804[1] = 13);
} else
{var statearr_11781_11805 = state_11763__$1;(statearr_11781_11805[1] = 14);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11764 === 13))
{var inst_11752 = cljs.core.async.close_BANG_.call(null,out);var state_11763__$1 = state_11763;var statearr_11782_11806 = state_11763__$1;(statearr_11782_11806[2] = inst_11752);
(statearr_11782_11806[1] = 15);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11764 === 14))
{var inst_11749 = (state_11763[12]);var inst_11754 = cljs.core.apply.call(null,f,inst_11749);var state_11763__$1 = state_11763;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11763__$1,16,out,inst_11754);
} else
{if((state_val_11764 === 15))
{var inst_11759 = (state_11763[2]);var state_11763__$1 = state_11763;var statearr_11783_11807 = state_11763__$1;(statearr_11783_11807[2] = inst_11759);
(statearr_11783_11807[1] = 3);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11764 === 16))
{var inst_11756 = (state_11763[2]);var state_11763__$1 = (function (){var statearr_11784 = state_11763;(statearr_11784[13] = inst_11756);
return statearr_11784;
})();var statearr_11785_11808 = state_11763__$1;(statearr_11785_11808[2] = null);
(statearr_11785_11808[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});return ((function (switch__6219__auto__){
return (function() {
var state_machine__6220__auto__ = null;
var state_machine__6220__auto____0 = (function (){var statearr_11789 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_11789[0] = state_machine__6220__auto__);
(statearr_11789[1] = 1);
return statearr_11789;
});
var state_machine__6220__auto____1 = (function (state_11763){while(true){
var ret_value__6221__auto__ = (function (){try{while(true){
var result__6222__auto__ = switch__6219__auto__.call(null,state_11763);if(cljs.core.keyword_identical_QMARK_.call(null,result__6222__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__6222__auto__;
}
break;
}
}catch (e11790){if((e11790 instanceof Object))
{var ex__6223__auto__ = e11790;var statearr_11791_11809 = state_11763;(statearr_11791_11809[5] = ex__6223__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11763);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e11790;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6221__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__11810 = state_11763;
state_11763 = G__11810;
continue;
}
} else
{return ret_value__6221__auto__;
}
break;
}
});
state_machine__6220__auto__ = function(state_11763){
switch(arguments.length){
case 0:
return state_machine__6220__auto____0.call(this);
case 1:
return state_machine__6220__auto____1.call(this,state_11763);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__6220__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__6220__auto____0;
state_machine__6220__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__6220__auto____1;
return state_machine__6220__auto__;
})()
;})(switch__6219__auto__))
})();var state__6236__auto__ = (function (){var statearr_11792 = f__6235__auto__.call(null);(statearr_11792[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__6234__auto___11793);
return statearr_11792;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6236__auto__);
}));
return out;
});
map = function(f,chs,buf_or_n){
switch(arguments.length){
case 2:
return map__2.call(this,f,chs);
case 3:
return map__3.call(this,f,chs,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
map.cljs$core$IFn$_invoke$arity$2 = map__2;
map.cljs$core$IFn$_invoke$arity$3 = map__3;
return map;
})()
;
/**
* Takes a collection of source channels and returns a channel which
* contains all values taken from them. The returned channel will be
* unbuffered by default, or a buf-or-n can be supplied. The channel
* will close after all the source channels have closed.
*/
cljs.core.async.merge = (function() {
var merge = null;
var merge__1 = (function (chs){return merge.call(null,chs,null);
});
var merge__2 = (function (chs,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__6234__auto___11918 = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,(function (){var f__6235__auto__ = (function (){var switch__6219__auto__ = (function (state_11894){var state_val_11895 = (state_11894[1]);if((state_val_11895 === 1))
{var inst_11865 = cljs.core.vec.call(null,chs);var inst_11866 = inst_11865;var state_11894__$1 = (function (){var statearr_11896 = state_11894;(statearr_11896[7] = inst_11866);
return statearr_11896;
})();var statearr_11897_11919 = state_11894__$1;(statearr_11897_11919[2] = null);
(statearr_11897_11919[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11895 === 2))
{var inst_11866 = (state_11894[7]);var inst_11868 = cljs.core.count.call(null,inst_11866);var inst_11869 = (inst_11868 > 0);var state_11894__$1 = state_11894;if(cljs.core.truth_(inst_11869))
{var statearr_11898_11920 = state_11894__$1;(statearr_11898_11920[1] = 4);
} else
{var statearr_11899_11921 = state_11894__$1;(statearr_11899_11921[1] = 5);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11895 === 3))
{var inst_11892 = (state_11894[2]);var state_11894__$1 = state_11894;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11894__$1,inst_11892);
} else
{if((state_val_11895 === 4))
{var inst_11866 = (state_11894[7]);var state_11894__$1 = state_11894;return cljs.core.async.impl.ioc_helpers.ioc_alts_BANG_.call(null,state_11894__$1,7,inst_11866);
} else
{if((state_val_11895 === 5))
{var inst_11888 = cljs.core.async.close_BANG_.call(null,out);var state_11894__$1 = state_11894;var statearr_11900_11922 = state_11894__$1;(statearr_11900_11922[2] = inst_11888);
(statearr_11900_11922[1] = 6);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11895 === 6))
{var inst_11890 = (state_11894[2]);var state_11894__$1 = state_11894;var statearr_11901_11923 = state_11894__$1;(statearr_11901_11923[2] = inst_11890);
(statearr_11901_11923[1] = 3);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11895 === 7))
{var inst_11874 = (state_11894[8]);var inst_11873 = (state_11894[9]);var inst_11873__$1 = (state_11894[2]);var inst_11874__$1 = cljs.core.nth.call(null,inst_11873__$1,0,null);var inst_11875 = cljs.core.nth.call(null,inst_11873__$1,1,null);var inst_11876 = (inst_11874__$1 == null);var state_11894__$1 = (function (){var statearr_11902 = state_11894;(statearr_11902[8] = inst_11874__$1);
(statearr_11902[10] = inst_11875);
(statearr_11902[9] = inst_11873__$1);
return statearr_11902;
})();if(cljs.core.truth_(inst_11876))
{var statearr_11903_11924 = state_11894__$1;(statearr_11903_11924[1] = 8);
} else
{var statearr_11904_11925 = state_11894__$1;(statearr_11904_11925[1] = 9);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11895 === 8))
{var inst_11874 = (state_11894[8]);var inst_11875 = (state_11894[10]);var inst_11873 = (state_11894[9]);var inst_11866 = (state_11894[7]);var inst_11878 = (function (){var c = inst_11875;var v = inst_11874;var vec__11871 = inst_11873;var cs = inst_11866;return ((function (c,v,vec__11871,cs,inst_11874,inst_11875,inst_11873,inst_11866,state_val_11895){
return (function (p1__11811_SHARP_){return cljs.core.not_EQ_.call(null,c,p1__11811_SHARP_);
});
;})(c,v,vec__11871,cs,inst_11874,inst_11875,inst_11873,inst_11866,state_val_11895))
})();var inst_11879 = cljs.core.filterv.call(null,inst_11878,inst_11866);var inst_11866__$1 = inst_11879;var state_11894__$1 = (function (){var statearr_11905 = state_11894;(statearr_11905[7] = inst_11866__$1);
return statearr_11905;
})();var statearr_11906_11926 = state_11894__$1;(statearr_11906_11926[2] = null);
(statearr_11906_11926[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11895 === 9))
{var inst_11874 = (state_11894[8]);var state_11894__$1 = state_11894;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11894__$1,11,out,inst_11874);
} else
{if((state_val_11895 === 10))
{var inst_11886 = (state_11894[2]);var state_11894__$1 = state_11894;var statearr_11908_11927 = state_11894__$1;(statearr_11908_11927[2] = inst_11886);
(statearr_11908_11927[1] = 6);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_11895 === 11))
{var inst_11866 = (state_11894[7]);var inst_11883 = (state_11894[2]);var tmp11907 = inst_11866;var inst_11866__$1 = tmp11907;var state_11894__$1 = (function (){var statearr_11909 = state_11894;(statearr_11909[11] = inst_11883);
(statearr_11909[7] = inst_11866__$1);
return statearr_11909;
})();var statearr_11910_11928 = state_11894__$1;(statearr_11910_11928[2] = null);
(statearr_11910_11928[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
});return ((function (switch__6219__auto__){
return (function() {
var state_machine__6220__auto__ = null;
var state_machine__6220__auto____0 = (function (){var statearr_11914 = [null,null,null,null,null,null,null,null,null,null,null,null];(statearr_11914[0] = state_machine__6220__auto__);
(statearr_11914[1] = 1);
return statearr_11914;
});
var state_machine__6220__auto____1 = (function (state_11894){while(true){
var ret_value__6221__auto__ = (function (){try{while(true){
var result__6222__auto__ = switch__6219__auto__.call(null,state_11894);if(cljs.core.keyword_identical_QMARK_.call(null,result__6222__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__6222__auto__;
}
break;
}
}catch (e11915){if((e11915 instanceof Object))
{var ex__6223__auto__ = e11915;var statearr_11916_11929 = state_11894;(statearr_11916_11929[5] = ex__6223__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11894);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e11915;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6221__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__11930 = state_11894;
state_11894 = G__11930;
continue;
}
} else
{return ret_value__6221__auto__;
}
break;
}
});
state_machine__6220__auto__ = function(state_11894){
switch(arguments.length){
case 0:
return state_machine__6220__auto____0.call(this);
case 1:
return state_machine__6220__auto____1.call(this,state_11894);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__6220__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__6220__auto____0;
state_machine__6220__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__6220__auto____1;
return state_machine__6220__auto__;
})()
;})(switch__6219__auto__))
})();var state__6236__auto__ = (function (){var statearr_11917 = f__6235__auto__.call(null);(statearr_11917[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__6234__auto___11918);
return statearr_11917;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6236__auto__);
}));
return out;
});
merge = function(chs,buf_or_n){
switch(arguments.length){
case 1:
return merge__1.call(this,chs);
case 2:
return merge__2.call(this,chs,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
merge.cljs$core$IFn$_invoke$arity$1 = merge__1;
merge.cljs$core$IFn$_invoke$arity$2 = merge__2;
return merge;
})()
;
/**
* Returns a channel containing the single (collection) result of the
* items taken from the channel conjoined to the supplied
* collection. ch must close before into produces a result.
*/
cljs.core.async.into = (function into(coll,ch){return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
* Returns a channel that will return, at most, n items from ch. After n items
* have been returned, or ch has been closed, the return chanel will close.
* 
* The output channel is unbuffered by default, unless buf-or-n is given.
*/
cljs.core.async.take = (function() {
var take = null;
var take__2 = (function (n,ch){return take.call(null,n,ch,null);
});
var take__3 = (function (n,ch,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__6234__auto___12023 = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,(function (){var f__6235__auto__ = (function (){var switch__6219__auto__ = (function (state_12000){var state_val_12001 = (state_12000[1]);if((state_val_12001 === 1))
{var inst_11977 = 0;var state_12000__$1 = (function (){var statearr_12002 = state_12000;(statearr_12002[7] = inst_11977);
return statearr_12002;
})();var statearr_12003_12024 = state_12000__$1;(statearr_12003_12024[2] = null);
(statearr_12003_12024[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12001 === 2))
{var inst_11977 = (state_12000[7]);var inst_11979 = (inst_11977 < n);var state_12000__$1 = state_12000;if(cljs.core.truth_(inst_11979))
{var statearr_12004_12025 = state_12000__$1;(statearr_12004_12025[1] = 4);
} else
{var statearr_12005_12026 = state_12000__$1;(statearr_12005_12026[1] = 5);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12001 === 3))
{var inst_11997 = (state_12000[2]);var inst_11998 = cljs.core.async.close_BANG_.call(null,out);var state_12000__$1 = (function (){var statearr_12006 = state_12000;(statearr_12006[8] = inst_11997);
return statearr_12006;
})();return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12000__$1,inst_11998);
} else
{if((state_val_12001 === 4))
{var state_12000__$1 = state_12000;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12000__$1,7,ch);
} else
{if((state_val_12001 === 5))
{var state_12000__$1 = state_12000;var statearr_12007_12027 = state_12000__$1;(statearr_12007_12027[2] = null);
(statearr_12007_12027[1] = 6);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12001 === 6))
{var inst_11995 = (state_12000[2]);var state_12000__$1 = state_12000;var statearr_12008_12028 = state_12000__$1;(statearr_12008_12028[2] = inst_11995);
(statearr_12008_12028[1] = 3);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12001 === 7))
{var inst_11982 = (state_12000[9]);var inst_11982__$1 = (state_12000[2]);var inst_11983 = (inst_11982__$1 == null);var inst_11984 = cljs.core.not.call(null,inst_11983);var state_12000__$1 = (function (){var statearr_12009 = state_12000;(statearr_12009[9] = inst_11982__$1);
return statearr_12009;
})();if(inst_11984)
{var statearr_12010_12029 = state_12000__$1;(statearr_12010_12029[1] = 8);
} else
{var statearr_12011_12030 = state_12000__$1;(statearr_12011_12030[1] = 9);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12001 === 8))
{var inst_11982 = (state_12000[9]);var state_12000__$1 = state_12000;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12000__$1,11,out,inst_11982);
} else
{if((state_val_12001 === 9))
{var state_12000__$1 = state_12000;var statearr_12012_12031 = state_12000__$1;(statearr_12012_12031[2] = null);
(statearr_12012_12031[1] = 10);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12001 === 10))
{var inst_11992 = (state_12000[2]);var state_12000__$1 = state_12000;var statearr_12013_12032 = state_12000__$1;(statearr_12013_12032[2] = inst_11992);
(statearr_12013_12032[1] = 6);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12001 === 11))
{var inst_11977 = (state_12000[7]);var inst_11987 = (state_12000[2]);var inst_11988 = (inst_11977 + 1);var inst_11977__$1 = inst_11988;var state_12000__$1 = (function (){var statearr_12014 = state_12000;(statearr_12014[7] = inst_11977__$1);
(statearr_12014[10] = inst_11987);
return statearr_12014;
})();var statearr_12015_12033 = state_12000__$1;(statearr_12015_12033[2] = null);
(statearr_12015_12033[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
});return ((function (switch__6219__auto__){
return (function() {
var state_machine__6220__auto__ = null;
var state_machine__6220__auto____0 = (function (){var statearr_12019 = [null,null,null,null,null,null,null,null,null,null,null];(statearr_12019[0] = state_machine__6220__auto__);
(statearr_12019[1] = 1);
return statearr_12019;
});
var state_machine__6220__auto____1 = (function (state_12000){while(true){
var ret_value__6221__auto__ = (function (){try{while(true){
var result__6222__auto__ = switch__6219__auto__.call(null,state_12000);if(cljs.core.keyword_identical_QMARK_.call(null,result__6222__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__6222__auto__;
}
break;
}
}catch (e12020){if((e12020 instanceof Object))
{var ex__6223__auto__ = e12020;var statearr_12021_12034 = state_12000;(statearr_12021_12034[5] = ex__6223__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12000);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e12020;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6221__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__12035 = state_12000;
state_12000 = G__12035;
continue;
}
} else
{return ret_value__6221__auto__;
}
break;
}
});
state_machine__6220__auto__ = function(state_12000){
switch(arguments.length){
case 0:
return state_machine__6220__auto____0.call(this);
case 1:
return state_machine__6220__auto____1.call(this,state_12000);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__6220__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__6220__auto____0;
state_machine__6220__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__6220__auto____1;
return state_machine__6220__auto__;
})()
;})(switch__6219__auto__))
})();var state__6236__auto__ = (function (){var statearr_12022 = f__6235__auto__.call(null);(statearr_12022[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__6234__auto___12023);
return statearr_12022;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6236__auto__);
}));
return out;
});
take = function(n,ch,buf_or_n){
switch(arguments.length){
case 2:
return take__2.call(this,n,ch);
case 3:
return take__3.call(this,n,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
take.cljs$core$IFn$_invoke$arity$2 = take__2;
take.cljs$core$IFn$_invoke$arity$3 = take__3;
return take;
})()
;
/**
* Returns a channel that will contain values from ch. Consecutive duplicate
* values will be dropped.
* 
* The output channel is unbuffered by default, unless buf-or-n is given.
*/
cljs.core.async.unique = (function() {
var unique = null;
var unique__1 = (function (ch){return unique.call(null,ch,null);
});
var unique__2 = (function (ch,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__6234__auto___12132 = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,(function (){var f__6235__auto__ = (function (){var switch__6219__auto__ = (function (state_12107){var state_val_12108 = (state_12107[1]);if((state_val_12108 === 1))
{var inst_12084 = null;var state_12107__$1 = (function (){var statearr_12109 = state_12107;(statearr_12109[7] = inst_12084);
return statearr_12109;
})();var statearr_12110_12133 = state_12107__$1;(statearr_12110_12133[2] = null);
(statearr_12110_12133[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12108 === 2))
{var state_12107__$1 = state_12107;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12107__$1,4,ch);
} else
{if((state_val_12108 === 3))
{var inst_12104 = (state_12107[2]);var inst_12105 = cljs.core.async.close_BANG_.call(null,out);var state_12107__$1 = (function (){var statearr_12111 = state_12107;(statearr_12111[8] = inst_12104);
return statearr_12111;
})();return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12107__$1,inst_12105);
} else
{if((state_val_12108 === 4))
{var inst_12087 = (state_12107[9]);var inst_12087__$1 = (state_12107[2]);var inst_12088 = (inst_12087__$1 == null);var inst_12089 = cljs.core.not.call(null,inst_12088);var state_12107__$1 = (function (){var statearr_12112 = state_12107;(statearr_12112[9] = inst_12087__$1);
return statearr_12112;
})();if(inst_12089)
{var statearr_12113_12134 = state_12107__$1;(statearr_12113_12134[1] = 5);
} else
{var statearr_12114_12135 = state_12107__$1;(statearr_12114_12135[1] = 6);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12108 === 5))
{var inst_12087 = (state_12107[9]);var inst_12084 = (state_12107[7]);var inst_12091 = cljs.core._EQ_.call(null,inst_12087,inst_12084);var state_12107__$1 = state_12107;if(inst_12091)
{var statearr_12115_12136 = state_12107__$1;(statearr_12115_12136[1] = 8);
} else
{var statearr_12116_12137 = state_12107__$1;(statearr_12116_12137[1] = 9);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12108 === 6))
{var state_12107__$1 = state_12107;var statearr_12118_12138 = state_12107__$1;(statearr_12118_12138[2] = null);
(statearr_12118_12138[1] = 7);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12108 === 7))
{var inst_12102 = (state_12107[2]);var state_12107__$1 = state_12107;var statearr_12119_12139 = state_12107__$1;(statearr_12119_12139[2] = inst_12102);
(statearr_12119_12139[1] = 3);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12108 === 8))
{var inst_12084 = (state_12107[7]);var tmp12117 = inst_12084;var inst_12084__$1 = tmp12117;var state_12107__$1 = (function (){var statearr_12120 = state_12107;(statearr_12120[7] = inst_12084__$1);
return statearr_12120;
})();var statearr_12121_12140 = state_12107__$1;(statearr_12121_12140[2] = null);
(statearr_12121_12140[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12108 === 9))
{var inst_12087 = (state_12107[9]);var state_12107__$1 = state_12107;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12107__$1,11,out,inst_12087);
} else
{if((state_val_12108 === 10))
{var inst_12099 = (state_12107[2]);var state_12107__$1 = state_12107;var statearr_12122_12141 = state_12107__$1;(statearr_12122_12141[2] = inst_12099);
(statearr_12122_12141[1] = 7);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12108 === 11))
{var inst_12087 = (state_12107[9]);var inst_12096 = (state_12107[2]);var inst_12084 = inst_12087;var state_12107__$1 = (function (){var statearr_12123 = state_12107;(statearr_12123[7] = inst_12084);
(statearr_12123[10] = inst_12096);
return statearr_12123;
})();var statearr_12124_12142 = state_12107__$1;(statearr_12124_12142[2] = null);
(statearr_12124_12142[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
});return ((function (switch__6219__auto__){
return (function() {
var state_machine__6220__auto__ = null;
var state_machine__6220__auto____0 = (function (){var statearr_12128 = [null,null,null,null,null,null,null,null,null,null,null];(statearr_12128[0] = state_machine__6220__auto__);
(statearr_12128[1] = 1);
return statearr_12128;
});
var state_machine__6220__auto____1 = (function (state_12107){while(true){
var ret_value__6221__auto__ = (function (){try{while(true){
var result__6222__auto__ = switch__6219__auto__.call(null,state_12107);if(cljs.core.keyword_identical_QMARK_.call(null,result__6222__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__6222__auto__;
}
break;
}
}catch (e12129){if((e12129 instanceof Object))
{var ex__6223__auto__ = e12129;var statearr_12130_12143 = state_12107;(statearr_12130_12143[5] = ex__6223__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12107);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e12129;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6221__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__12144 = state_12107;
state_12107 = G__12144;
continue;
}
} else
{return ret_value__6221__auto__;
}
break;
}
});
state_machine__6220__auto__ = function(state_12107){
switch(arguments.length){
case 0:
return state_machine__6220__auto____0.call(this);
case 1:
return state_machine__6220__auto____1.call(this,state_12107);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__6220__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__6220__auto____0;
state_machine__6220__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__6220__auto____1;
return state_machine__6220__auto__;
})()
;})(switch__6219__auto__))
})();var state__6236__auto__ = (function (){var statearr_12131 = f__6235__auto__.call(null);(statearr_12131[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__6234__auto___12132);
return statearr_12131;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6236__auto__);
}));
return out;
});
unique = function(ch,buf_or_n){
switch(arguments.length){
case 1:
return unique__1.call(this,ch);
case 2:
return unique__2.call(this,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unique.cljs$core$IFn$_invoke$arity$1 = unique__1;
unique.cljs$core$IFn$_invoke$arity$2 = unique__2;
return unique;
})()
;
/**
* Returns a channel that will contain vectors of n items taken from ch. The
* final vector in the return channel may be smaller than n if ch closed before
* the vector could be completely filled.
* 
* The output channel is unbuffered by default, unless buf-or-n is given
*/
cljs.core.async.partition = (function() {
var partition = null;
var partition__2 = (function (n,ch){return partition.call(null,n,ch,null);
});
var partition__3 = (function (n,ch,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__6234__auto___12279 = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,(function (){var f__6235__auto__ = (function (){var switch__6219__auto__ = (function (state_12249){var state_val_12250 = (state_12249[1]);if((state_val_12250 === 1))
{var inst_12212 = (new Array(n));var inst_12213 = inst_12212;var inst_12214 = 0;var state_12249__$1 = (function (){var statearr_12251 = state_12249;(statearr_12251[7] = inst_12214);
(statearr_12251[8] = inst_12213);
return statearr_12251;
})();var statearr_12252_12280 = state_12249__$1;(statearr_12252_12280[2] = null);
(statearr_12252_12280[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12250 === 2))
{var state_12249__$1 = state_12249;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12249__$1,4,ch);
} else
{if((state_val_12250 === 3))
{var inst_12247 = (state_12249[2]);var state_12249__$1 = state_12249;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12249__$1,inst_12247);
} else
{if((state_val_12250 === 4))
{var inst_12217 = (state_12249[9]);var inst_12217__$1 = (state_12249[2]);var inst_12218 = (inst_12217__$1 == null);var inst_12219 = cljs.core.not.call(null,inst_12218);var state_12249__$1 = (function (){var statearr_12253 = state_12249;(statearr_12253[9] = inst_12217__$1);
return statearr_12253;
})();if(inst_12219)
{var statearr_12254_12281 = state_12249__$1;(statearr_12254_12281[1] = 5);
} else
{var statearr_12255_12282 = state_12249__$1;(statearr_12255_12282[1] = 6);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12250 === 5))
{var inst_12217 = (state_12249[9]);var inst_12222 = (state_12249[10]);var inst_12214 = (state_12249[7]);var inst_12213 = (state_12249[8]);var inst_12221 = (inst_12213[inst_12214] = inst_12217);var inst_12222__$1 = (inst_12214 + 1);var inst_12223 = (inst_12222__$1 < n);var state_12249__$1 = (function (){var statearr_12256 = state_12249;(statearr_12256[11] = inst_12221);
(statearr_12256[10] = inst_12222__$1);
return statearr_12256;
})();if(cljs.core.truth_(inst_12223))
{var statearr_12257_12283 = state_12249__$1;(statearr_12257_12283[1] = 8);
} else
{var statearr_12258_12284 = state_12249__$1;(statearr_12258_12284[1] = 9);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12250 === 6))
{var inst_12214 = (state_12249[7]);var inst_12235 = (inst_12214 > 0);var state_12249__$1 = state_12249;if(cljs.core.truth_(inst_12235))
{var statearr_12260_12285 = state_12249__$1;(statearr_12260_12285[1] = 12);
} else
{var statearr_12261_12286 = state_12249__$1;(statearr_12261_12286[1] = 13);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12250 === 7))
{var inst_12245 = (state_12249[2]);var state_12249__$1 = state_12249;var statearr_12262_12287 = state_12249__$1;(statearr_12262_12287[2] = inst_12245);
(statearr_12262_12287[1] = 3);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12250 === 8))
{var inst_12222 = (state_12249[10]);var inst_12213 = (state_12249[8]);var tmp12259 = inst_12213;var inst_12213__$1 = tmp12259;var inst_12214 = inst_12222;var state_12249__$1 = (function (){var statearr_12263 = state_12249;(statearr_12263[7] = inst_12214);
(statearr_12263[8] = inst_12213__$1);
return statearr_12263;
})();var statearr_12264_12288 = state_12249__$1;(statearr_12264_12288[2] = null);
(statearr_12264_12288[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12250 === 9))
{var inst_12213 = (state_12249[8]);var inst_12227 = cljs.core.vec.call(null,inst_12213);var state_12249__$1 = state_12249;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12249__$1,11,out,inst_12227);
} else
{if((state_val_12250 === 10))
{var inst_12233 = (state_12249[2]);var state_12249__$1 = state_12249;var statearr_12265_12289 = state_12249__$1;(statearr_12265_12289[2] = inst_12233);
(statearr_12265_12289[1] = 7);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12250 === 11))
{var inst_12229 = (state_12249[2]);var inst_12230 = (new Array(n));var inst_12213 = inst_12230;var inst_12214 = 0;var state_12249__$1 = (function (){var statearr_12266 = state_12249;(statearr_12266[12] = inst_12229);
(statearr_12266[7] = inst_12214);
(statearr_12266[8] = inst_12213);
return statearr_12266;
})();var statearr_12267_12290 = state_12249__$1;(statearr_12267_12290[2] = null);
(statearr_12267_12290[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12250 === 12))
{var inst_12213 = (state_12249[8]);var inst_12237 = cljs.core.vec.call(null,inst_12213);var state_12249__$1 = state_12249;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12249__$1,15,out,inst_12237);
} else
{if((state_val_12250 === 13))
{var state_12249__$1 = state_12249;var statearr_12268_12291 = state_12249__$1;(statearr_12268_12291[2] = null);
(statearr_12268_12291[1] = 14);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12250 === 14))
{var inst_12242 = (state_12249[2]);var inst_12243 = cljs.core.async.close_BANG_.call(null,out);var state_12249__$1 = (function (){var statearr_12269 = state_12249;(statearr_12269[13] = inst_12242);
return statearr_12269;
})();var statearr_12270_12292 = state_12249__$1;(statearr_12270_12292[2] = inst_12243);
(statearr_12270_12292[1] = 7);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12250 === 15))
{var inst_12239 = (state_12249[2]);var state_12249__$1 = state_12249;var statearr_12271_12293 = state_12249__$1;(statearr_12271_12293[2] = inst_12239);
(statearr_12271_12293[1] = 14);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});return ((function (switch__6219__auto__){
return (function() {
var state_machine__6220__auto__ = null;
var state_machine__6220__auto____0 = (function (){var statearr_12275 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_12275[0] = state_machine__6220__auto__);
(statearr_12275[1] = 1);
return statearr_12275;
});
var state_machine__6220__auto____1 = (function (state_12249){while(true){
var ret_value__6221__auto__ = (function (){try{while(true){
var result__6222__auto__ = switch__6219__auto__.call(null,state_12249);if(cljs.core.keyword_identical_QMARK_.call(null,result__6222__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__6222__auto__;
}
break;
}
}catch (e12276){if((e12276 instanceof Object))
{var ex__6223__auto__ = e12276;var statearr_12277_12294 = state_12249;(statearr_12277_12294[5] = ex__6223__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12249);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e12276;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6221__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__12295 = state_12249;
state_12249 = G__12295;
continue;
}
} else
{return ret_value__6221__auto__;
}
break;
}
});
state_machine__6220__auto__ = function(state_12249){
switch(arguments.length){
case 0:
return state_machine__6220__auto____0.call(this);
case 1:
return state_machine__6220__auto____1.call(this,state_12249);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__6220__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__6220__auto____0;
state_machine__6220__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__6220__auto____1;
return state_machine__6220__auto__;
})()
;})(switch__6219__auto__))
})();var state__6236__auto__ = (function (){var statearr_12278 = f__6235__auto__.call(null);(statearr_12278[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__6234__auto___12279);
return statearr_12278;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6236__auto__);
}));
return out;
});
partition = function(n,ch,buf_or_n){
switch(arguments.length){
case 2:
return partition__2.call(this,n,ch);
case 3:
return partition__3.call(this,n,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
partition.cljs$core$IFn$_invoke$arity$2 = partition__2;
partition.cljs$core$IFn$_invoke$arity$3 = partition__3;
return partition;
})()
;
/**
* Returns a channel that will contain vectors of items taken from ch. New
* vectors will be created whenever (f itm) returns a value that differs from
* the previous item's (f itm).
* 
* The output channel is unbuffered, unless buf-or-n is given
*/
cljs.core.async.partition_by = (function() {
var partition_by = null;
var partition_by__2 = (function (f,ch){return partition_by.call(null,f,ch,null);
});
var partition_by__3 = (function (f,ch,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__6234__auto___12438 = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,(function (){var f__6235__auto__ = (function (){var switch__6219__auto__ = (function (state_12408){var state_val_12409 = (state_12408[1]);if((state_val_12409 === 1))
{var inst_12367 = [];var inst_12368 = inst_12367;var inst_12369 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",4382193538);var state_12408__$1 = (function (){var statearr_12410 = state_12408;(statearr_12410[7] = inst_12369);
(statearr_12410[8] = inst_12368);
return statearr_12410;
})();var statearr_12411_12439 = state_12408__$1;(statearr_12411_12439[2] = null);
(statearr_12411_12439[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12409 === 2))
{var state_12408__$1 = state_12408;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12408__$1,4,ch);
} else
{if((state_val_12409 === 3))
{var inst_12406 = (state_12408[2]);var state_12408__$1 = state_12408;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12408__$1,inst_12406);
} else
{if((state_val_12409 === 4))
{var inst_12372 = (state_12408[9]);var inst_12372__$1 = (state_12408[2]);var inst_12373 = (inst_12372__$1 == null);var inst_12374 = cljs.core.not.call(null,inst_12373);var state_12408__$1 = (function (){var statearr_12412 = state_12408;(statearr_12412[9] = inst_12372__$1);
return statearr_12412;
})();if(inst_12374)
{var statearr_12413_12440 = state_12408__$1;(statearr_12413_12440[1] = 5);
} else
{var statearr_12414_12441 = state_12408__$1;(statearr_12414_12441[1] = 6);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12409 === 5))
{var inst_12369 = (state_12408[7]);var inst_12376 = (state_12408[10]);var inst_12372 = (state_12408[9]);var inst_12376__$1 = f.call(null,inst_12372);var inst_12377 = cljs.core._EQ_.call(null,inst_12376__$1,inst_12369);var inst_12378 = cljs.core.keyword_identical_QMARK_.call(null,inst_12369,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",4382193538));var inst_12379 = (inst_12377) || (inst_12378);var state_12408__$1 = (function (){var statearr_12415 = state_12408;(statearr_12415[10] = inst_12376__$1);
return statearr_12415;
})();if(cljs.core.truth_(inst_12379))
{var statearr_12416_12442 = state_12408__$1;(statearr_12416_12442[1] = 8);
} else
{var statearr_12417_12443 = state_12408__$1;(statearr_12417_12443[1] = 9);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12409 === 6))
{var inst_12368 = (state_12408[8]);var inst_12393 = inst_12368.length;var inst_12394 = (inst_12393 > 0);var state_12408__$1 = state_12408;if(cljs.core.truth_(inst_12394))
{var statearr_12419_12444 = state_12408__$1;(statearr_12419_12444[1] = 12);
} else
{var statearr_12420_12445 = state_12408__$1;(statearr_12420_12445[1] = 13);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12409 === 7))
{var inst_12404 = (state_12408[2]);var state_12408__$1 = state_12408;var statearr_12421_12446 = state_12408__$1;(statearr_12421_12446[2] = inst_12404);
(statearr_12421_12446[1] = 3);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12409 === 8))
{var inst_12376 = (state_12408[10]);var inst_12372 = (state_12408[9]);var inst_12368 = (state_12408[8]);var inst_12381 = inst_12368.push(inst_12372);var tmp12418 = inst_12368;var inst_12368__$1 = tmp12418;var inst_12369 = inst_12376;var state_12408__$1 = (function (){var statearr_12422 = state_12408;(statearr_12422[11] = inst_12381);
(statearr_12422[7] = inst_12369);
(statearr_12422[8] = inst_12368__$1);
return statearr_12422;
})();var statearr_12423_12447 = state_12408__$1;(statearr_12423_12447[2] = null);
(statearr_12423_12447[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12409 === 9))
{var inst_12368 = (state_12408[8]);var inst_12384 = cljs.core.vec.call(null,inst_12368);var state_12408__$1 = state_12408;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12408__$1,11,out,inst_12384);
} else
{if((state_val_12409 === 10))
{var inst_12391 = (state_12408[2]);var state_12408__$1 = state_12408;var statearr_12424_12448 = state_12408__$1;(statearr_12424_12448[2] = inst_12391);
(statearr_12424_12448[1] = 7);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12409 === 11))
{var inst_12376 = (state_12408[10]);var inst_12372 = (state_12408[9]);var inst_12386 = (state_12408[2]);var inst_12387 = [];var inst_12388 = inst_12387.push(inst_12372);var inst_12368 = inst_12387;var inst_12369 = inst_12376;var state_12408__$1 = (function (){var statearr_12425 = state_12408;(statearr_12425[12] = inst_12386);
(statearr_12425[13] = inst_12388);
(statearr_12425[7] = inst_12369);
(statearr_12425[8] = inst_12368);
return statearr_12425;
})();var statearr_12426_12449 = state_12408__$1;(statearr_12426_12449[2] = null);
(statearr_12426_12449[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12409 === 12))
{var inst_12368 = (state_12408[8]);var inst_12396 = cljs.core.vec.call(null,inst_12368);var state_12408__$1 = state_12408;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12408__$1,15,out,inst_12396);
} else
{if((state_val_12409 === 13))
{var state_12408__$1 = state_12408;var statearr_12427_12450 = state_12408__$1;(statearr_12427_12450[2] = null);
(statearr_12427_12450[1] = 14);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12409 === 14))
{var inst_12401 = (state_12408[2]);var inst_12402 = cljs.core.async.close_BANG_.call(null,out);var state_12408__$1 = (function (){var statearr_12428 = state_12408;(statearr_12428[14] = inst_12401);
return statearr_12428;
})();var statearr_12429_12451 = state_12408__$1;(statearr_12429_12451[2] = inst_12402);
(statearr_12429_12451[1] = 7);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12409 === 15))
{var inst_12398 = (state_12408[2]);var state_12408__$1 = state_12408;var statearr_12430_12452 = state_12408__$1;(statearr_12430_12452[2] = inst_12398);
(statearr_12430_12452[1] = 14);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});return ((function (switch__6219__auto__){
return (function() {
var state_machine__6220__auto__ = null;
var state_machine__6220__auto____0 = (function (){var statearr_12434 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_12434[0] = state_machine__6220__auto__);
(statearr_12434[1] = 1);
return statearr_12434;
});
var state_machine__6220__auto____1 = (function (state_12408){while(true){
var ret_value__6221__auto__ = (function (){try{while(true){
var result__6222__auto__ = switch__6219__auto__.call(null,state_12408);if(cljs.core.keyword_identical_QMARK_.call(null,result__6222__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__6222__auto__;
}
break;
}
}catch (e12435){if((e12435 instanceof Object))
{var ex__6223__auto__ = e12435;var statearr_12436_12453 = state_12408;(statearr_12436_12453[5] = ex__6223__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12408);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e12435;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6221__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__12454 = state_12408;
state_12408 = G__12454;
continue;
}
} else
{return ret_value__6221__auto__;
}
break;
}
});
state_machine__6220__auto__ = function(state_12408){
switch(arguments.length){
case 0:
return state_machine__6220__auto____0.call(this);
case 1:
return state_machine__6220__auto____1.call(this,state_12408);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__6220__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__6220__auto____0;
state_machine__6220__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__6220__auto____1;
return state_machine__6220__auto__;
})()
;})(switch__6219__auto__))
})();var state__6236__auto__ = (function (){var statearr_12437 = f__6235__auto__.call(null);(statearr_12437[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__6234__auto___12438);
return statearr_12437;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6236__auto__);
}));
return out;
});
partition_by = function(f,ch,buf_or_n){
switch(arguments.length){
case 2:
return partition_by__2.call(this,f,ch);
case 3:
return partition_by__3.call(this,f,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
partition_by.cljs$core$IFn$_invoke$arity$2 = partition_by__2;
partition_by.cljs$core$IFn$_invoke$arity$3 = partition_by__3;
return partition_by;
})()
;
