/*
 * $Id: SqlSession.java 1202 2013-10-17 05:40:20Z PSpeed42@gmail.com $
 *
 * Copyright (c) 2011-2013 jMonkeyEngine
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * * Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 *
 * * Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the distribution.
 *
 * * Neither the name of 'jMonkeyEngine' nor the names of its contributors
 *   may be used to endorse or promote products derived from this software
 *   without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.simsilica.es.sql;

import java.sql.*;
import java.util.*;


/**
 *
 *  @author    Paul Speed
 */
public class SqlSession {

    private Connection conn;

    private Map<String,PreparedStatement> statementCache = new HashMap<String,PreparedStatement>();
    
    public SqlSession( Connection conn ) {
        this.conn = conn;
    }

    public Connection getConnection() {
        return conn;
    }

    public PreparedStatement prepareStatement( String sql ) throws SQLException {
        return prepareStatement(sql, true);
    }

    public PreparedStatement prepareStatement( String sql, int autoGeneratedKeys ) throws SQLException {
        return prepareStatement(sql, autoGeneratedKeys, true);
    }
 
    public PreparedStatement prepareStatement( String sql, boolean cache ) throws SQLException {
        return prepareStatement(sql, Statement.NO_GENERATED_KEYS, cache);
    }
    
    public PreparedStatement prepareStatement( String sql, int autoGeneratedKeys, 
                                               boolean cache ) throws SQLException {
                                               
        PreparedStatement result = statementCache.get(sql);
        if( result != null ) {
            result.clearParameters(); 
            return result;
        } 

        result = conn.prepareStatement(sql, autoGeneratedKeys);
        if( cache ) {
            statementCache.put(sql, result);
        }
        
        return result;            
    }
    
    /**
     *  Releases any resources managed by this session.  This
     *  does not close any underlying connections.
     */
    public void release() throws SQLException {
        for( PreparedStatement st : statementCache.values() ) {
            st.close();
        }
        statementCache.clear();
    }

}
