(ns datum-rex.core
  (:require [reagent.core :as reagent]
            [datascript.core :as d]))


(def site-schema (atom {}))


(defn create-conn
  ([schema] (reagent/atom
              (d/empty-db schema)
              :meta {:listeners (atom [])}))
  ([] (create-conn nil)))


(defonce conn (create-conn @site-schema))


(defn transact! [datoms] (d/transact! conn datoms))


(defonce schemata (atom {}))


(defn transact-schema! [schema]
  (swap! schemata merge schema)
  (swap! conn
         (fn [c]
           (d/init-db
             (d/datoms c :eavt)
             @schemata))))


(defn q [query & args] (apply d/q query @conn args))


(defn q-rx [query & args]
  (reagent.ratom/make-reaction
    #(apply
       d/q query
       @conn args)))


(defn pull [pattern & args]
  (apply d/pull @conn pattern args))


(defn pull-rx [pattern  & args]
  (reagent.ratom/make-reaction
    #(apply d/pull @conn pattern args)))


(defn pull* [pattern & args] (apply d/pull-many @conn pattern args))


(defn pull*-rx [pattern & args]
  (reagent.ratom/make-reaction
    #(apply d/pull-many @conn pattern args)))
