(defproject com.jjtolton/datum.rex "0.1.4-SNAPSHOT"
  :description "Just reactive datascript."
  :url ""
  :license {:name "EPL-2.0 OR GPL-2.0-or-later WITH Classpath-exception-2.0"
            :url  "https://www.eclipse.org/legal/epl-2.0/"}
  :plugins [[lein-tools-deps "0.4.5"]
            [lein-cljsbuild "1.1.7"]]
  :middleware [lein-tools-deps.plugin/resolve-dependencies-with-deps-edn]
  :lein-tools-deps/config {:config-files [:install :user :project]}
  :target-path "target/%s"
  :cljsbuild {:builds [{:id           "advanced"
                        :source-paths ["src" "test"]
                        :compiler     {:output-to            "target/datum_rex.js"
                                       :optimizations        :advanced
                                       :source-map           "target/datum_rex.js.map"
                                       :pretty-print         true
                                       :recompile-dependents false
                                       :parallel-build       true
                                       :checked-arrays       :warn}}
                       {:id          "none"
                        :source-paths ["src" "test"]
                        :compiler     {:main                 datascript.test
                                       :output-to            "target/datascript.js"
                                       :output-dir           "target/none"
                                       :optimizations        :none
                                       :source-map           true
                                       :recompile-dependents false
                                       :parallel-build       true
                                       :checked-arrays       :warn}}]}
  :profiles {:uberjar {:aot :all}}
  :clean-targets ^{:protect false} ["target"])

