// Compiled by ClojureScript 0.0-2371
goog.provide('dommy.core');
goog.require('cljs.core');
goog.require('dommy.utils');
goog.require('dommy.utils');
goog.require('dommy.utils');
goog.require('clojure.string');
goog.require('clojure.string');
/**
* Returns a selector in string format.
* Accepts string, keyword, or collection.
*/
dommy.core.selector = (function selector(data){if(cljs.core.coll_QMARK_.call(null,data))
{return clojure.string.join.call(null," ",cljs.core.map.call(null,selector,data));
} else
{if((typeof data === 'string') || ((data instanceof cljs.core.Keyword)))
{return cljs.core.name.call(null,data);
} else
{return null;
}
}
});
dommy.core.text = (function text(elem){var or__3648__auto__ = elem.textContent;if(cljs.core.truth_(or__3648__auto__))
{return or__3648__auto__;
} else
{return elem.innerText;
}
});
dommy.core.html = (function html(elem){return elem.innerHTML;
});
dommy.core.value = (function value(elem){return elem.value;
});
dommy.core.class$ = (function class$(elem){return elem.className;
});
dommy.core.attr = (function attr(elem,k){if(cljs.core.truth_(k))
{return elem.getAttribute(dommy.utils.as_str.call(null,k));
} else
{return null;
}
});
/**
* The computed style of `elem`, optionally specifying the key of
* a particular style to return
*/
dommy.core.style = (function() {
var style = null;
var style__1 = (function (elem){return cljs.core.js__GT_clj.call(null,window.getComputedStyle(elem));
});
var style__2 = (function (elem,k){return (window.getComputedStyle(elem)[dommy.utils.as_str.call(null,k)]);
});
style = function(elem,k){
switch(arguments.length){
case 1:
return style__1.call(this,elem);
case 2:
return style__2.call(this,elem,k);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
style.cljs$core$IFn$_invoke$arity$1 = style__1;
style.cljs$core$IFn$_invoke$arity$2 = style__2;
return style;
})()
;
dommy.core.px = (function px(elem,k){var pixels = dommy.core.style.call(null,elem,k);if(cljs.core.seq.call(null,pixels))
{return parseInt(pixels);
} else
{return null;
}
});
/**
* Does `elem` contain `c` in its class list
*/
dommy.core.has_class_QMARK_ = (function has_class_QMARK_(elem,c){var c__$1 = dommy.utils.as_str.call(null,c);var temp__4124__auto__ = elem.classList;if(cljs.core.truth_(temp__4124__auto__))
{var class_list = temp__4124__auto__;return class_list.contains(c__$1);
} else
{var temp__4126__auto__ = dommy.core.class$.call(null,elem);if(cljs.core.truth_(temp__4126__auto__))
{var class_name = temp__4126__auto__;var temp__4126__auto____$1 = dommy.utils.class_index.call(null,class_name,c__$1);if(cljs.core.truth_(temp__4126__auto____$1))
{var i = temp__4126__auto____$1;return (i >= (0));
} else
{return null;
}
} else
{return null;
}
}
});
/**
* Is `elem` hidden (as associated with hide!/show!/toggle!, using display: none)
*/
dommy.core.hidden_QMARK_ = (function hidden_QMARK_(elem){return (dommy.core.style.call(null,elem,new cljs.core.Keyword(null,"display","display",242065432)) === "none");
});
/**
* Returns a map of the bounding client rect of `elem`
* as a map with [:top :left :right :bottom :width :height]
*/
dommy.core.bounding_client_rect = (function bounding_client_rect(elem){var r = elem.getBoundingClientRect();return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"top","top",-1856271961),r.top,new cljs.core.Keyword(null,"bottom","bottom",-1550509018),r.bottom,new cljs.core.Keyword(null,"left","left",-399115937),r.left,new cljs.core.Keyword(null,"right","right",-452581833),r.right,new cljs.core.Keyword(null,"width","width",-384071477),r.width,new cljs.core.Keyword(null,"height","height",1025178622),r.height], null);
});
dommy.core.parent = (function parent(elem){return elem.parentNode;
});
dommy.core.children = (function children(elem){return elem.children;
});
/**
* Lazy seq of the ancestors of `elem`
*/
dommy.core.ancestors = (function ancestors(elem){return cljs.core.take_while.call(null,cljs.core.identity,cljs.core.iterate.call(null,dommy.core.parent,elem));
});
dommy.core.ancestor_nodes = dommy.core.ancestors;
/**
* Returns a predicate on nodes that match `selector` at the
* time of this `matches-pred` call (may return outdated results
* if you fuck with the DOM)
*/
dommy.core.matches_pred = (function() {
var matches_pred = null;
var matches_pred__1 = (function (selector){return matches_pred.call(null,document,selector);
});
var matches_pred__2 = (function (base,selector){var matches = dommy.utils.__GT_Array.call(null,base.querySelectorAll(dommy.core.selector.call(null,selector)));return ((function (matches){
return (function (elem){return (matches.indexOf(elem) >= (0));
});
;})(matches))
});
matches_pred = function(base,selector){
switch(arguments.length){
case 1:
return matches_pred__1.call(this,base);
case 2:
return matches_pred__2.call(this,base,selector);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
matches_pred.cljs$core$IFn$_invoke$arity$1 = matches_pred__1;
matches_pred.cljs$core$IFn$_invoke$arity$2 = matches_pred__2;
return matches_pred;
})()
;
/**
* Closest ancestor of `elem` (up to `base`, if provided)
* that matches `selector`
*/
dommy.core.closest = (function() {
var closest = null;
var closest__2 = (function (elem,selector){return closest.call(null,document.body,elem,selector);
});
var closest__3 = (function (base,elem,selector){return cljs.core.first.call(null,cljs.core.filter.call(null,dommy.core.matches_pred.call(null,base,selector),cljs.core.take_while.call(null,(function (p1__13949_SHARP_){return !((p1__13949_SHARP_ === base));
}),dommy.core.ancestors.call(null,elem))));
});
closest = function(base,elem,selector){
switch(arguments.length){
case 2:
return closest__2.call(this,base,elem);
case 3:
return closest__3.call(this,base,elem,selector);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
closest.cljs$core$IFn$_invoke$arity$2 = closest__2;
closest.cljs$core$IFn$_invoke$arity$3 = closest__3;
return closest;
})()
;
/**
* Is `descendant` a descendant of `ancestor`?
* (http://goo.gl/T8pgCX)
*/
dommy.core.descendant_QMARK_ = (function descendant_QMARK_(descendant,ancestor){if(cljs.core.truth_(ancestor.contains))
{return ancestor.contains(descendant);
} else
{if(cljs.core.truth_(ancestor.compareDocumentPosition))
{return ((ancestor.compareDocumentPosition(descendant) & (1 << (4))) != 0);
} else
{return null;
}
}
});
/**
* Set the textContent of `elem` to `text`, fall back to innerText
*/
dommy.core.set_text_BANG_ = (function set_text_BANG_(elem,text){if(!((void 0 === elem.textContent)))
{elem.textContent = text;
} else
{elem.innerText = text;
}
return elem;
});
/**
* Set the innerHTML of `elem` to `html`
*/
dommy.core.set_html_BANG_ = (function set_html_BANG_(elem,html){elem.innerHTML = html;
return elem;
});
/**
* Set the value of `elem` to `value`
*/
dommy.core.set_value_BANG_ = (function set_value_BANG_(elem,value){elem.value = value;
return elem;
});
/**
* Set the css class of `elem` to `elem`
*/
dommy.core.set_class_BANG_ = (function set_class_BANG_(elem,c){return elem.className = c;
});
/**
* Set the style of `elem` using key-value pairs:
* 
* (set-style! elem :display "block" :color "red")
* @param {...*} var_args
*/
dommy.core.set_style_BANG_ = (function() { 
var set_style_BANG___delegate = function (elem,kvs){if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,kvs)))
{} else
{throw (new Error(("Assert failed: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"kvs","kvs",-1695980277,null))))))));
}
var style = elem.style;var seq__13956_13962 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),kvs));var chunk__13957_13963 = null;var count__13958_13964 = (0);var i__13959_13965 = (0);while(true){
if((i__13959_13965 < count__13958_13964))
{var vec__13960_13966 = cljs.core._nth.call(null,chunk__13957_13963,i__13959_13965);var k_13967 = cljs.core.nth.call(null,vec__13960_13966,(0),null);var v_13968 = cljs.core.nth.call(null,vec__13960_13966,(1),null);style.setProperty(dommy.utils.as_str.call(null,k_13967),v_13968);
{
var G__13969 = seq__13956_13962;
var G__13970 = chunk__13957_13963;
var G__13971 = count__13958_13964;
var G__13972 = (i__13959_13965 + (1));
seq__13956_13962 = G__13969;
chunk__13957_13963 = G__13970;
count__13958_13964 = G__13971;
i__13959_13965 = G__13972;
continue;
}
} else
{var temp__4126__auto___13973 = cljs.core.seq.call(null,seq__13956_13962);if(temp__4126__auto___13973)
{var seq__13956_13974__$1 = temp__4126__auto___13973;if(cljs.core.chunked_seq_QMARK_.call(null,seq__13956_13974__$1))
{var c__4418__auto___13975 = cljs.core.chunk_first.call(null,seq__13956_13974__$1);{
var G__13976 = cljs.core.chunk_rest.call(null,seq__13956_13974__$1);
var G__13977 = c__4418__auto___13975;
var G__13978 = cljs.core.count.call(null,c__4418__auto___13975);
var G__13979 = (0);
seq__13956_13962 = G__13976;
chunk__13957_13963 = G__13977;
count__13958_13964 = G__13978;
i__13959_13965 = G__13979;
continue;
}
} else
{var vec__13961_13980 = cljs.core.first.call(null,seq__13956_13974__$1);var k_13981 = cljs.core.nth.call(null,vec__13961_13980,(0),null);var v_13982 = cljs.core.nth.call(null,vec__13961_13980,(1),null);style.setProperty(dommy.utils.as_str.call(null,k_13981),v_13982);
{
var G__13983 = cljs.core.next.call(null,seq__13956_13974__$1);
var G__13984 = null;
var G__13985 = (0);
var G__13986 = (0);
seq__13956_13962 = G__13983;
chunk__13957_13963 = G__13984;
count__13958_13964 = G__13985;
i__13959_13965 = G__13986;
continue;
}
}
} else
{}
}
break;
}
return elem;
};
var set_style_BANG_ = function (elem,var_args){
var kvs = null;if (arguments.length > 1) {
  kvs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return set_style_BANG___delegate.call(this,elem,kvs);};
set_style_BANG_.cljs$lang$maxFixedArity = 1;
set_style_BANG_.cljs$lang$applyTo = (function (arglist__13987){
var elem = cljs.core.first(arglist__13987);
var kvs = cljs.core.rest(arglist__13987);
return set_style_BANG___delegate(elem,kvs);
});
set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic = set_style_BANG___delegate;
return set_style_BANG_;
})()
;
/**
* @param {...*} var_args
*/
dommy.core.set_px_BANG_ = (function() { 
var set_px_BANG___delegate = function (elem,kvs){if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,kvs)))
{} else
{throw (new Error(("Assert failed: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"kvs","kvs",-1695980277,null))))))));
}
var seq__13994_14000 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),kvs));var chunk__13995_14001 = null;var count__13996_14002 = (0);var i__13997_14003 = (0);while(true){
if((i__13997_14003 < count__13996_14002))
{var vec__13998_14004 = cljs.core._nth.call(null,chunk__13995_14001,i__13997_14003);var k_14005 = cljs.core.nth.call(null,vec__13998_14004,(0),null);var v_14006 = cljs.core.nth.call(null,vec__13998_14004,(1),null);dommy.core.set_style_BANG_.call(null,elem,k_14005,(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(v_14006)+"px"));
{
var G__14007 = seq__13994_14000;
var G__14008 = chunk__13995_14001;
var G__14009 = count__13996_14002;
var G__14010 = (i__13997_14003 + (1));
seq__13994_14000 = G__14007;
chunk__13995_14001 = G__14008;
count__13996_14002 = G__14009;
i__13997_14003 = G__14010;
continue;
}
} else
{var temp__4126__auto___14011 = cljs.core.seq.call(null,seq__13994_14000);if(temp__4126__auto___14011)
{var seq__13994_14012__$1 = temp__4126__auto___14011;if(cljs.core.chunked_seq_QMARK_.call(null,seq__13994_14012__$1))
{var c__4418__auto___14013 = cljs.core.chunk_first.call(null,seq__13994_14012__$1);{
var G__14014 = cljs.core.chunk_rest.call(null,seq__13994_14012__$1);
var G__14015 = c__4418__auto___14013;
var G__14016 = cljs.core.count.call(null,c__4418__auto___14013);
var G__14017 = (0);
seq__13994_14000 = G__14014;
chunk__13995_14001 = G__14015;
count__13996_14002 = G__14016;
i__13997_14003 = G__14017;
continue;
}
} else
{var vec__13999_14018 = cljs.core.first.call(null,seq__13994_14012__$1);var k_14019 = cljs.core.nth.call(null,vec__13999_14018,(0),null);var v_14020 = cljs.core.nth.call(null,vec__13999_14018,(1),null);dommy.core.set_style_BANG_.call(null,elem,k_14019,(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(v_14020)+"px"));
{
var G__14021 = cljs.core.next.call(null,seq__13994_14012__$1);
var G__14022 = null;
var G__14023 = (0);
var G__14024 = (0);
seq__13994_14000 = G__14021;
chunk__13995_14001 = G__14022;
count__13996_14002 = G__14023;
i__13997_14003 = G__14024;
continue;
}
}
} else
{}
}
break;
}
return elem;
};
var set_px_BANG_ = function (elem,var_args){
var kvs = null;if (arguments.length > 1) {
  kvs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return set_px_BANG___delegate.call(this,elem,kvs);};
set_px_BANG_.cljs$lang$maxFixedArity = 1;
set_px_BANG_.cljs$lang$applyTo = (function (arglist__14025){
var elem = cljs.core.first(arglist__14025);
var kvs = cljs.core.rest(arglist__14025);
return set_px_BANG___delegate(elem,kvs);
});
set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic = set_px_BANG___delegate;
return set_px_BANG_;
})()
;
/**
* Sets dom attributes on and returns `elem`.
* Attributes without values will be set to "true":
* 
* (set-attr! elem :disabled)
* 
* With values, the function takes variadic kv pairs:
* 
* (set-attr! elem :id "some-id"
* :name "some-name")
* @param {...*} var_args
*/
dommy.core.set_attr_BANG_ = (function() {
var set_attr_BANG_ = null;
var set_attr_BANG___2 = (function (elem,k){return set_attr_BANG_.call(null,elem,k,"true");
});
var set_attr_BANG___3 = (function (elem,k,v){var k__$1 = dommy.utils.as_str.call(null,k);if(cljs.core.truth_(v))
{if(cljs.core.fn_QMARK_.call(null,v))
{var G__14034 = elem;(G__14034[k__$1] = v);
return G__14034;
} else
{var G__14035 = elem;G__14035.setAttribute(k__$1,v);
return G__14035;
}
} else
{return null;
}
});
var set_attr_BANG___4 = (function() { 
var G__14042__delegate = function (elem,k,v,kvs){if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,kvs)))
{} else
{throw (new Error(("Assert failed: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"kvs","kvs",-1695980277,null))))))));
}
var seq__14036_14043 = cljs.core.seq.call(null,cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),cljs.core.partition.call(null,(2),kvs)));var chunk__14037_14044 = null;var count__14038_14045 = (0);var i__14039_14046 = (0);while(true){
if((i__14039_14046 < count__14038_14045))
{var vec__14040_14047 = cljs.core._nth.call(null,chunk__14037_14044,i__14039_14046);var k_14048__$1 = cljs.core.nth.call(null,vec__14040_14047,(0),null);var v_14049__$1 = cljs.core.nth.call(null,vec__14040_14047,(1),null);set_attr_BANG_.call(null,elem,k_14048__$1,v_14049__$1);
{
var G__14050 = seq__14036_14043;
var G__14051 = chunk__14037_14044;
var G__14052 = count__14038_14045;
var G__14053 = (i__14039_14046 + (1));
seq__14036_14043 = G__14050;
chunk__14037_14044 = G__14051;
count__14038_14045 = G__14052;
i__14039_14046 = G__14053;
continue;
}
} else
{var temp__4126__auto___14054 = cljs.core.seq.call(null,seq__14036_14043);if(temp__4126__auto___14054)
{var seq__14036_14055__$1 = temp__4126__auto___14054;if(cljs.core.chunked_seq_QMARK_.call(null,seq__14036_14055__$1))
{var c__4418__auto___14056 = cljs.core.chunk_first.call(null,seq__14036_14055__$1);{
var G__14057 = cljs.core.chunk_rest.call(null,seq__14036_14055__$1);
var G__14058 = c__4418__auto___14056;
var G__14059 = cljs.core.count.call(null,c__4418__auto___14056);
var G__14060 = (0);
seq__14036_14043 = G__14057;
chunk__14037_14044 = G__14058;
count__14038_14045 = G__14059;
i__14039_14046 = G__14060;
continue;
}
} else
{var vec__14041_14061 = cljs.core.first.call(null,seq__14036_14055__$1);var k_14062__$1 = cljs.core.nth.call(null,vec__14041_14061,(0),null);var v_14063__$1 = cljs.core.nth.call(null,vec__14041_14061,(1),null);set_attr_BANG_.call(null,elem,k_14062__$1,v_14063__$1);
{
var G__14064 = cljs.core.next.call(null,seq__14036_14055__$1);
var G__14065 = null;
var G__14066 = (0);
var G__14067 = (0);
seq__14036_14043 = G__14064;
chunk__14037_14044 = G__14065;
count__14038_14045 = G__14066;
i__14039_14046 = G__14067;
continue;
}
}
} else
{}
}
break;
}
return elem;
};
var G__14042 = function (elem,k,v,var_args){
var kvs = null;if (arguments.length > 3) {
  kvs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3),0);} 
return G__14042__delegate.call(this,elem,k,v,kvs);};
G__14042.cljs$lang$maxFixedArity = 3;
G__14042.cljs$lang$applyTo = (function (arglist__14068){
var elem = cljs.core.first(arglist__14068);
arglist__14068 = cljs.core.next(arglist__14068);
var k = cljs.core.first(arglist__14068);
arglist__14068 = cljs.core.next(arglist__14068);
var v = cljs.core.first(arglist__14068);
var kvs = cljs.core.rest(arglist__14068);
return G__14042__delegate(elem,k,v,kvs);
});
G__14042.cljs$core$IFn$_invoke$arity$variadic = G__14042__delegate;
return G__14042;
})()
;
set_attr_BANG_ = function(elem,k,v,var_args){
var kvs = var_args;
switch(arguments.length){
case 2:
return set_attr_BANG___2.call(this,elem,k);
case 3:
return set_attr_BANG___3.call(this,elem,k,v);
default:
return set_attr_BANG___4.cljs$core$IFn$_invoke$arity$variadic(elem,k,v, cljs.core.array_seq(arguments, 3));
}
throw(new Error('Invalid arity: ' + arguments.length));
};
set_attr_BANG_.cljs$lang$maxFixedArity = 3;
set_attr_BANG_.cljs$lang$applyTo = set_attr_BANG___4.cljs$lang$applyTo;
set_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = set_attr_BANG___2;
set_attr_BANG_.cljs$core$IFn$_invoke$arity$3 = set_attr_BANG___3;
set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic = set_attr_BANG___4.cljs$core$IFn$_invoke$arity$variadic;
return set_attr_BANG_;
})()
;
/**
* Removes dom attributes on and returns `elem`.
* `class` and `classes` are special cases which clear
* out the class name on removal.
* @param {...*} var_args
*/
dommy.core.remove_attr_BANG_ = (function() {
var remove_attr_BANG_ = null;
var remove_attr_BANG___2 = (function (elem,k){var k_14077__$1 = dommy.utils.as_str.call(null,k);if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["class",null,"classes",null], null), null).call(null,k_14077__$1)))
{dommy.core.set_class_BANG_.call(null,elem,"");
} else
{elem.removeAttribute(k_14077__$1);
}
return elem;
});
var remove_attr_BANG___3 = (function() { 
var G__14078__delegate = function (elem,k,ks){var seq__14073_14079 = cljs.core.seq.call(null,cljs.core.cons.call(null,k,ks));var chunk__14074_14080 = null;var count__14075_14081 = (0);var i__14076_14082 = (0);while(true){
if((i__14076_14082 < count__14075_14081))
{var k_14083__$1 = cljs.core._nth.call(null,chunk__14074_14080,i__14076_14082);remove_attr_BANG_.call(null,elem,k_14083__$1);
{
var G__14084 = seq__14073_14079;
var G__14085 = chunk__14074_14080;
var G__14086 = count__14075_14081;
var G__14087 = (i__14076_14082 + (1));
seq__14073_14079 = G__14084;
chunk__14074_14080 = G__14085;
count__14075_14081 = G__14086;
i__14076_14082 = G__14087;
continue;
}
} else
{var temp__4126__auto___14088 = cljs.core.seq.call(null,seq__14073_14079);if(temp__4126__auto___14088)
{var seq__14073_14089__$1 = temp__4126__auto___14088;if(cljs.core.chunked_seq_QMARK_.call(null,seq__14073_14089__$1))
{var c__4418__auto___14090 = cljs.core.chunk_first.call(null,seq__14073_14089__$1);{
var G__14091 = cljs.core.chunk_rest.call(null,seq__14073_14089__$1);
var G__14092 = c__4418__auto___14090;
var G__14093 = cljs.core.count.call(null,c__4418__auto___14090);
var G__14094 = (0);
seq__14073_14079 = G__14091;
chunk__14074_14080 = G__14092;
count__14075_14081 = G__14093;
i__14076_14082 = G__14094;
continue;
}
} else
{var k_14095__$1 = cljs.core.first.call(null,seq__14073_14089__$1);remove_attr_BANG_.call(null,elem,k_14095__$1);
{
var G__14096 = cljs.core.next.call(null,seq__14073_14089__$1);
var G__14097 = null;
var G__14098 = (0);
var G__14099 = (0);
seq__14073_14079 = G__14096;
chunk__14074_14080 = G__14097;
count__14075_14081 = G__14098;
i__14076_14082 = G__14099;
continue;
}
}
} else
{}
}
break;
}
return elem;
};
var G__14078 = function (elem,k,var_args){
var ks = null;if (arguments.length > 2) {
  ks = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);} 
return G__14078__delegate.call(this,elem,k,ks);};
G__14078.cljs$lang$maxFixedArity = 2;
G__14078.cljs$lang$applyTo = (function (arglist__14100){
var elem = cljs.core.first(arglist__14100);
arglist__14100 = cljs.core.next(arglist__14100);
var k = cljs.core.first(arglist__14100);
var ks = cljs.core.rest(arglist__14100);
return G__14078__delegate(elem,k,ks);
});
G__14078.cljs$core$IFn$_invoke$arity$variadic = G__14078__delegate;
return G__14078;
})()
;
remove_attr_BANG_ = function(elem,k,var_args){
var ks = var_args;
switch(arguments.length){
case 2:
return remove_attr_BANG___2.call(this,elem,k);
default:
return remove_attr_BANG___3.cljs$core$IFn$_invoke$arity$variadic(elem,k, cljs.core.array_seq(arguments, 2));
}
throw(new Error('Invalid arity: ' + arguments.length));
};
remove_attr_BANG_.cljs$lang$maxFixedArity = 2;
remove_attr_BANG_.cljs$lang$applyTo = remove_attr_BANG___3.cljs$lang$applyTo;
remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = remove_attr_BANG___2;
remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic = remove_attr_BANG___3.cljs$core$IFn$_invoke$arity$variadic;
return remove_attr_BANG_;
})()
;
/**
* Toggles a dom attribute `k` on `elem`, optionally specifying
* the boolean value with `add?`
*/
dommy.core.toggle_attr_BANG_ = (function() {
var toggle_attr_BANG_ = null;
var toggle_attr_BANG___2 = (function (elem,k){return toggle_attr_BANG_.call(null,elem,k,cljs.core.boolean$.call(null,dommy.core.attr.call(null,elem,k)));
});
var toggle_attr_BANG___3 = (function (elem,k,add_QMARK_){if(add_QMARK_)
{return dommy.core.set_attr_BANG_.call(null,elem,k);
} else
{return dommy.core.remove_attr_BANG_.call(null,elem,k);
}
});
toggle_attr_BANG_ = function(elem,k,add_QMARK_){
switch(arguments.length){
case 2:
return toggle_attr_BANG___2.call(this,elem,k);
case 3:
return toggle_attr_BANG___3.call(this,elem,k,add_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = toggle_attr_BANG___2;
toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3 = toggle_attr_BANG___3;
return toggle_attr_BANG_;
})()
;
/**
* Add `classes` to `elem`, trying to use Element::classList, and
* falling back to fast string parsing/manipulation
* @param {...*} var_args
*/
dommy.core.add_class_BANG_ = (function() {
var add_class_BANG_ = null;
var add_class_BANG___2 = (function (elem,classes){var classes__$1 = clojure.string.trim.call(null,dommy.utils.as_str.call(null,classes)).split(/\s+/);if(cljs.core.seq.call(null,classes__$1))
{var temp__4124__auto___14125 = elem.classList;if(cljs.core.truth_(temp__4124__auto___14125))
{var class_list_14126 = temp__4124__auto___14125;var seq__14113_14127 = cljs.core.seq.call(null,classes__$1);var chunk__14114_14128 = null;var count__14115_14129 = (0);var i__14116_14130 = (0);while(true){
if((i__14116_14130 < count__14115_14129))
{var c_14131 = cljs.core._nth.call(null,chunk__14114_14128,i__14116_14130);class_list_14126.add(c_14131);
{
var G__14132 = seq__14113_14127;
var G__14133 = chunk__14114_14128;
var G__14134 = count__14115_14129;
var G__14135 = (i__14116_14130 + (1));
seq__14113_14127 = G__14132;
chunk__14114_14128 = G__14133;
count__14115_14129 = G__14134;
i__14116_14130 = G__14135;
continue;
}
} else
{var temp__4126__auto___14136 = cljs.core.seq.call(null,seq__14113_14127);if(temp__4126__auto___14136)
{var seq__14113_14137__$1 = temp__4126__auto___14136;if(cljs.core.chunked_seq_QMARK_.call(null,seq__14113_14137__$1))
{var c__4418__auto___14138 = cljs.core.chunk_first.call(null,seq__14113_14137__$1);{
var G__14139 = cljs.core.chunk_rest.call(null,seq__14113_14137__$1);
var G__14140 = c__4418__auto___14138;
var G__14141 = cljs.core.count.call(null,c__4418__auto___14138);
var G__14142 = (0);
seq__14113_14127 = G__14139;
chunk__14114_14128 = G__14140;
count__14115_14129 = G__14141;
i__14116_14130 = G__14142;
continue;
}
} else
{var c_14143 = cljs.core.first.call(null,seq__14113_14137__$1);class_list_14126.add(c_14143);
{
var G__14144 = cljs.core.next.call(null,seq__14113_14137__$1);
var G__14145 = null;
var G__14146 = (0);
var G__14147 = (0);
seq__14113_14127 = G__14144;
chunk__14114_14128 = G__14145;
count__14115_14129 = G__14146;
i__14116_14130 = G__14147;
continue;
}
}
} else
{}
}
break;
}
} else
{var seq__14117_14148 = cljs.core.seq.call(null,classes__$1);var chunk__14118_14149 = null;var count__14119_14150 = (0);var i__14120_14151 = (0);while(true){
if((i__14120_14151 < count__14119_14150))
{var c_14152 = cljs.core._nth.call(null,chunk__14118_14149,i__14120_14151);var class_name_14153 = dommy.core.class$.call(null,elem);if(cljs.core.truth_(dommy.utils.class_index.call(null,class_name_14153,c_14152)))
{} else
{dommy.core.set_class_BANG_.call(null,elem,(((class_name_14153 === ""))?c_14152:(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(class_name_14153)+" "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(c_14152))));
}
{
var G__14154 = seq__14117_14148;
var G__14155 = chunk__14118_14149;
var G__14156 = count__14119_14150;
var G__14157 = (i__14120_14151 + (1));
seq__14117_14148 = G__14154;
chunk__14118_14149 = G__14155;
count__14119_14150 = G__14156;
i__14120_14151 = G__14157;
continue;
}
} else
{var temp__4126__auto___14158 = cljs.core.seq.call(null,seq__14117_14148);if(temp__4126__auto___14158)
{var seq__14117_14159__$1 = temp__4126__auto___14158;if(cljs.core.chunked_seq_QMARK_.call(null,seq__14117_14159__$1))
{var c__4418__auto___14160 = cljs.core.chunk_first.call(null,seq__14117_14159__$1);{
var G__14161 = cljs.core.chunk_rest.call(null,seq__14117_14159__$1);
var G__14162 = c__4418__auto___14160;
var G__14163 = cljs.core.count.call(null,c__4418__auto___14160);
var G__14164 = (0);
seq__14117_14148 = G__14161;
chunk__14118_14149 = G__14162;
count__14119_14150 = G__14163;
i__14120_14151 = G__14164;
continue;
}
} else
{var c_14165 = cljs.core.first.call(null,seq__14117_14159__$1);var class_name_14166 = dommy.core.class$.call(null,elem);if(cljs.core.truth_(dommy.utils.class_index.call(null,class_name_14166,c_14165)))
{} else
{dommy.core.set_class_BANG_.call(null,elem,(((class_name_14166 === ""))?c_14165:(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(class_name_14166)+" "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(c_14165))));
}
{
var G__14167 = cljs.core.next.call(null,seq__14117_14159__$1);
var G__14168 = null;
var G__14169 = (0);
var G__14170 = (0);
seq__14117_14148 = G__14167;
chunk__14118_14149 = G__14168;
count__14119_14150 = G__14169;
i__14120_14151 = G__14170;
continue;
}
}
} else
{}
}
break;
}
}
} else
{}
return elem;
});
var add_class_BANG___3 = (function() { 
var G__14171__delegate = function (elem,classes,more_classes){var seq__14121_14172 = cljs.core.seq.call(null,cljs.core.conj.call(null,more_classes,classes));var chunk__14122_14173 = null;var count__14123_14174 = (0);var i__14124_14175 = (0);while(true){
if((i__14124_14175 < count__14123_14174))
{var c_14176 = cljs.core._nth.call(null,chunk__14122_14173,i__14124_14175);add_class_BANG_.call(null,elem,c_14176);
{
var G__14177 = seq__14121_14172;
var G__14178 = chunk__14122_14173;
var G__14179 = count__14123_14174;
var G__14180 = (i__14124_14175 + (1));
seq__14121_14172 = G__14177;
chunk__14122_14173 = G__14178;
count__14123_14174 = G__14179;
i__14124_14175 = G__14180;
continue;
}
} else
{var temp__4126__auto___14181 = cljs.core.seq.call(null,seq__14121_14172);if(temp__4126__auto___14181)
{var seq__14121_14182__$1 = temp__4126__auto___14181;if(cljs.core.chunked_seq_QMARK_.call(null,seq__14121_14182__$1))
{var c__4418__auto___14183 = cljs.core.chunk_first.call(null,seq__14121_14182__$1);{
var G__14184 = cljs.core.chunk_rest.call(null,seq__14121_14182__$1);
var G__14185 = c__4418__auto___14183;
var G__14186 = cljs.core.count.call(null,c__4418__auto___14183);
var G__14187 = (0);
seq__14121_14172 = G__14184;
chunk__14122_14173 = G__14185;
count__14123_14174 = G__14186;
i__14124_14175 = G__14187;
continue;
}
} else
{var c_14188 = cljs.core.first.call(null,seq__14121_14182__$1);add_class_BANG_.call(null,elem,c_14188);
{
var G__14189 = cljs.core.next.call(null,seq__14121_14182__$1);
var G__14190 = null;
var G__14191 = (0);
var G__14192 = (0);
seq__14121_14172 = G__14189;
chunk__14122_14173 = G__14190;
count__14123_14174 = G__14191;
i__14124_14175 = G__14192;
continue;
}
}
} else
{}
}
break;
}
return elem;
};
var G__14171 = function (elem,classes,var_args){
var more_classes = null;if (arguments.length > 2) {
  more_classes = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);} 
return G__14171__delegate.call(this,elem,classes,more_classes);};
G__14171.cljs$lang$maxFixedArity = 2;
G__14171.cljs$lang$applyTo = (function (arglist__14193){
var elem = cljs.core.first(arglist__14193);
arglist__14193 = cljs.core.next(arglist__14193);
var classes = cljs.core.first(arglist__14193);
var more_classes = cljs.core.rest(arglist__14193);
return G__14171__delegate(elem,classes,more_classes);
});
G__14171.cljs$core$IFn$_invoke$arity$variadic = G__14171__delegate;
return G__14171;
})()
;
add_class_BANG_ = function(elem,classes,var_args){
var more_classes = var_args;
switch(arguments.length){
case 2:
return add_class_BANG___2.call(this,elem,classes);
default:
return add_class_BANG___3.cljs$core$IFn$_invoke$arity$variadic(elem,classes, cljs.core.array_seq(arguments, 2));
}
throw(new Error('Invalid arity: ' + arguments.length));
};
add_class_BANG_.cljs$lang$maxFixedArity = 2;
add_class_BANG_.cljs$lang$applyTo = add_class_BANG___3.cljs$lang$applyTo;
add_class_BANG_.cljs$core$IFn$_invoke$arity$2 = add_class_BANG___2;
add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic = add_class_BANG___3.cljs$core$IFn$_invoke$arity$variadic;
return add_class_BANG_;
})()
;
/**
* Remove `c` from `elem` class list
* @param {...*} var_args
*/
dommy.core.remove_class_BANG_ = (function() {
var remove_class_BANG_ = null;
var remove_class_BANG___2 = (function (elem,c){var c__$1 = dommy.utils.as_str.call(null,c);var temp__4124__auto___14202 = elem.classList;if(cljs.core.truth_(temp__4124__auto___14202))
{var class_list_14203 = temp__4124__auto___14202;class_list_14203.remove(c__$1);
} else
{var class_name_14204 = dommy.core.class$.call(null,elem);var new_class_name_14205 = dommy.utils.remove_class_str.call(null,class_name_14204,c__$1);if((class_name_14204 === new_class_name_14205))
{} else
{dommy.core.set_class_BANG_.call(null,elem,new_class_name_14205);
}
}
return elem;
});
var remove_class_BANG___3 = (function() { 
var G__14206__delegate = function (elem,class$,classes){var seq__14198 = cljs.core.seq.call(null,cljs.core.conj.call(null,classes,class$));var chunk__14199 = null;var count__14200 = (0);var i__14201 = (0);while(true){
if((i__14201 < count__14200))
{var c = cljs.core._nth.call(null,chunk__14199,i__14201);remove_class_BANG_.call(null,elem,c);
{
var G__14207 = seq__14198;
var G__14208 = chunk__14199;
var G__14209 = count__14200;
var G__14210 = (i__14201 + (1));
seq__14198 = G__14207;
chunk__14199 = G__14208;
count__14200 = G__14209;
i__14201 = G__14210;
continue;
}
} else
{var temp__4126__auto__ = cljs.core.seq.call(null,seq__14198);if(temp__4126__auto__)
{var seq__14198__$1 = temp__4126__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,seq__14198__$1))
{var c__4418__auto__ = cljs.core.chunk_first.call(null,seq__14198__$1);{
var G__14211 = cljs.core.chunk_rest.call(null,seq__14198__$1);
var G__14212 = c__4418__auto__;
var G__14213 = cljs.core.count.call(null,c__4418__auto__);
var G__14214 = (0);
seq__14198 = G__14211;
chunk__14199 = G__14212;
count__14200 = G__14213;
i__14201 = G__14214;
continue;
}
} else
{var c = cljs.core.first.call(null,seq__14198__$1);remove_class_BANG_.call(null,elem,c);
{
var G__14215 = cljs.core.next.call(null,seq__14198__$1);
var G__14216 = null;
var G__14217 = (0);
var G__14218 = (0);
seq__14198 = G__14215;
chunk__14199 = G__14216;
count__14200 = G__14217;
i__14201 = G__14218;
continue;
}
}
} else
{return null;
}
}
break;
}
};
var G__14206 = function (elem,class$,var_args){
var classes = null;if (arguments.length > 2) {
  classes = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);} 
return G__14206__delegate.call(this,elem,class$,classes);};
G__14206.cljs$lang$maxFixedArity = 2;
G__14206.cljs$lang$applyTo = (function (arglist__14219){
var elem = cljs.core.first(arglist__14219);
arglist__14219 = cljs.core.next(arglist__14219);
var class$ = cljs.core.first(arglist__14219);
var classes = cljs.core.rest(arglist__14219);
return G__14206__delegate(elem,class$,classes);
});
G__14206.cljs$core$IFn$_invoke$arity$variadic = G__14206__delegate;
return G__14206;
})()
;
remove_class_BANG_ = function(elem,class$,var_args){
var classes = var_args;
switch(arguments.length){
case 2:
return remove_class_BANG___2.call(this,elem,class$);
default:
return remove_class_BANG___3.cljs$core$IFn$_invoke$arity$variadic(elem,class$, cljs.core.array_seq(arguments, 2));
}
throw(new Error('Invalid arity: ' + arguments.length));
};
remove_class_BANG_.cljs$lang$maxFixedArity = 2;
remove_class_BANG_.cljs$lang$applyTo = remove_class_BANG___3.cljs$lang$applyTo;
remove_class_BANG_.cljs$core$IFn$_invoke$arity$2 = remove_class_BANG___2;
remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic = remove_class_BANG___3.cljs$core$IFn$_invoke$arity$variadic;
return remove_class_BANG_;
})()
;
/**
* (toggle-class! elem class) will add-class! if elem does not have class
* and remove-class! otherwise.
* (toggle-class! elem class add?) will add-class! if add? is truthy,
* otherwise it will remove-class!
*/
dommy.core.toggle_class_BANG_ = (function() {
var toggle_class_BANG_ = null;
var toggle_class_BANG___2 = (function (elem,c){var c__$1 = dommy.utils.as_str.call(null,c);var temp__4124__auto___14220 = elem.classList;if(cljs.core.truth_(temp__4124__auto___14220))
{var class_list_14221 = temp__4124__auto___14220;class_list_14221.toggle(c__$1);
} else
{toggle_class_BANG_.call(null,elem,c__$1,!(dommy.core.has_class_QMARK_.call(null,elem,c__$1)));
}
return elem;
});
var toggle_class_BANG___3 = (function (elem,class$,add_QMARK_){if(add_QMARK_)
{dommy.core.add_class_BANG_.call(null,elem,class$);
} else
{dommy.core.remove_class_BANG_.call(null,elem,class$);
}
return elem;
});
toggle_class_BANG_ = function(elem,class$,add_QMARK_){
switch(arguments.length){
case 2:
return toggle_class_BANG___2.call(this,elem,class$);
case 3:
return toggle_class_BANG___3.call(this,elem,class$,add_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
toggle_class_BANG_.cljs$core$IFn$_invoke$arity$2 = toggle_class_BANG___2;
toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3 = toggle_class_BANG___3;
return toggle_class_BANG_;
})()
;
/**
* Display or hide the given `elem` (using display: none).
* Takes an optional boolean `show?`
*/
dommy.core.toggle_BANG_ = (function() {
var toggle_BANG_ = null;
var toggle_BANG___1 = (function (elem){return toggle_BANG_.call(null,elem,dommy.core.hidden_QMARK_.call(null,elem));
});
var toggle_BANG___2 = (function (elem,show_QMARK_){return dommy.core.set_style_BANG_.call(null,elem,new cljs.core.Keyword(null,"display","display",242065432),((show_QMARK_)?"":"none"));
});
toggle_BANG_ = function(elem,show_QMARK_){
switch(arguments.length){
case 1:
return toggle_BANG___1.call(this,elem);
case 2:
return toggle_BANG___2.call(this,elem,show_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
toggle_BANG_.cljs$core$IFn$_invoke$arity$1 = toggle_BANG___1;
toggle_BANG_.cljs$core$IFn$_invoke$arity$2 = toggle_BANG___2;
return toggle_BANG_;
})()
;
dommy.core.hide_BANG_ = (function hide_BANG_(elem){return dommy.core.toggle_BANG_.call(null,elem,false);
});
dommy.core.show_BANG_ = (function show_BANG_(elem){return dommy.core.toggle_BANG_.call(null,elem,true);
});
dommy.core.scroll_into_view = (function scroll_into_view(elem,align_with_top_QMARK_){var top = new cljs.core.Keyword(null,"top","top",-1856271961).cljs$core$IFn$_invoke$arity$1(dommy.core.bounding_client_rect.call(null,elem));if((window.innerHeight < (top + elem.offsetHeight)))
{return elem.scrollIntoView(align_with_top_QMARK_);
} else
{return null;
}
});
dommy.core.create_element = (function() {
var create_element = null;
var create_element__1 = (function (tag){return document.createElement(dommy.utils.as_str.call(null,tag));
});
var create_element__2 = (function (tag_ns,tag){return document.createElementNS(dommy.utils.as_str.call(null,tag_ns),dommy.utils.as_str.call(null,tag));
});
create_element = function(tag_ns,tag){
switch(arguments.length){
case 1:
return create_element__1.call(this,tag_ns);
case 2:
return create_element__2.call(this,tag_ns,tag);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
create_element.cljs$core$IFn$_invoke$arity$1 = create_element__1;
create_element.cljs$core$IFn$_invoke$arity$2 = create_element__2;
return create_element;
})()
;
dommy.core.create_text_node = (function create_text_node(text){return document.createTextNode(text);
});
/**
* Clears all children from `elem`
*/
dommy.core.clear_BANG_ = (function clear_BANG_(elem){return dommy.core.set_html_BANG_.call(null,elem,"");
});
/**
* Append `child` to `parent`
* @param {...*} var_args
*/
dommy.core.append_BANG_ = (function() {
var append_BANG_ = null;
var append_BANG___2 = (function (parent,child){var G__14227 = parent;G__14227.appendChild(child);
return G__14227;
});
var append_BANG___3 = (function() { 
var G__14232__delegate = function (parent,child,more_children){var seq__14228_14233 = cljs.core.seq.call(null,cljs.core.cons.call(null,child,more_children));var chunk__14229_14234 = null;var count__14230_14235 = (0);var i__14231_14236 = (0);while(true){
if((i__14231_14236 < count__14230_14235))
{var c_14237 = cljs.core._nth.call(null,chunk__14229_14234,i__14231_14236);append_BANG_.call(null,parent,c_14237);
{
var G__14238 = seq__14228_14233;
var G__14239 = chunk__14229_14234;
var G__14240 = count__14230_14235;
var G__14241 = (i__14231_14236 + (1));
seq__14228_14233 = G__14238;
chunk__14229_14234 = G__14239;
count__14230_14235 = G__14240;
i__14231_14236 = G__14241;
continue;
}
} else
{var temp__4126__auto___14242 = cljs.core.seq.call(null,seq__14228_14233);if(temp__4126__auto___14242)
{var seq__14228_14243__$1 = temp__4126__auto___14242;if(cljs.core.chunked_seq_QMARK_.call(null,seq__14228_14243__$1))
{var c__4418__auto___14244 = cljs.core.chunk_first.call(null,seq__14228_14243__$1);{
var G__14245 = cljs.core.chunk_rest.call(null,seq__14228_14243__$1);
var G__14246 = c__4418__auto___14244;
var G__14247 = cljs.core.count.call(null,c__4418__auto___14244);
var G__14248 = (0);
seq__14228_14233 = G__14245;
chunk__14229_14234 = G__14246;
count__14230_14235 = G__14247;
i__14231_14236 = G__14248;
continue;
}
} else
{var c_14249 = cljs.core.first.call(null,seq__14228_14243__$1);append_BANG_.call(null,parent,c_14249);
{
var G__14250 = cljs.core.next.call(null,seq__14228_14243__$1);
var G__14251 = null;
var G__14252 = (0);
var G__14253 = (0);
seq__14228_14233 = G__14250;
chunk__14229_14234 = G__14251;
count__14230_14235 = G__14252;
i__14231_14236 = G__14253;
continue;
}
}
} else
{}
}
break;
}
return parent;
};
var G__14232 = function (parent,child,var_args){
var more_children = null;if (arguments.length > 2) {
  more_children = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);} 
return G__14232__delegate.call(this,parent,child,more_children);};
G__14232.cljs$lang$maxFixedArity = 2;
G__14232.cljs$lang$applyTo = (function (arglist__14254){
var parent = cljs.core.first(arglist__14254);
arglist__14254 = cljs.core.next(arglist__14254);
var child = cljs.core.first(arglist__14254);
var more_children = cljs.core.rest(arglist__14254);
return G__14232__delegate(parent,child,more_children);
});
G__14232.cljs$core$IFn$_invoke$arity$variadic = G__14232__delegate;
return G__14232;
})()
;
append_BANG_ = function(parent,child,var_args){
var more_children = var_args;
switch(arguments.length){
case 2:
return append_BANG___2.call(this,parent,child);
default:
return append_BANG___3.cljs$core$IFn$_invoke$arity$variadic(parent,child, cljs.core.array_seq(arguments, 2));
}
throw(new Error('Invalid arity: ' + arguments.length));
};
append_BANG_.cljs$lang$maxFixedArity = 2;
append_BANG_.cljs$lang$applyTo = append_BANG___3.cljs$lang$applyTo;
append_BANG_.cljs$core$IFn$_invoke$arity$2 = append_BANG___2;
append_BANG_.cljs$core$IFn$_invoke$arity$variadic = append_BANG___3.cljs$core$IFn$_invoke$arity$variadic;
return append_BANG_;
})()
;
/**
* Prepend `child` to `parent`
* @param {...*} var_args
*/
dommy.core.prepend_BANG_ = (function() {
var prepend_BANG_ = null;
var prepend_BANG___2 = (function (parent,child){var G__14260 = parent;G__14260.insertBefore(child,parent.firstChild);
return G__14260;
});
var prepend_BANG___3 = (function() { 
var G__14265__delegate = function (parent,child,more_children){var seq__14261_14266 = cljs.core.seq.call(null,cljs.core.cons.call(null,child,more_children));var chunk__14262_14267 = null;var count__14263_14268 = (0);var i__14264_14269 = (0);while(true){
if((i__14264_14269 < count__14263_14268))
{var c_14270 = cljs.core._nth.call(null,chunk__14262_14267,i__14264_14269);prepend_BANG_.call(null,parent,c_14270);
{
var G__14271 = seq__14261_14266;
var G__14272 = chunk__14262_14267;
var G__14273 = count__14263_14268;
var G__14274 = (i__14264_14269 + (1));
seq__14261_14266 = G__14271;
chunk__14262_14267 = G__14272;
count__14263_14268 = G__14273;
i__14264_14269 = G__14274;
continue;
}
} else
{var temp__4126__auto___14275 = cljs.core.seq.call(null,seq__14261_14266);if(temp__4126__auto___14275)
{var seq__14261_14276__$1 = temp__4126__auto___14275;if(cljs.core.chunked_seq_QMARK_.call(null,seq__14261_14276__$1))
{var c__4418__auto___14277 = cljs.core.chunk_first.call(null,seq__14261_14276__$1);{
var G__14278 = cljs.core.chunk_rest.call(null,seq__14261_14276__$1);
var G__14279 = c__4418__auto___14277;
var G__14280 = cljs.core.count.call(null,c__4418__auto___14277);
var G__14281 = (0);
seq__14261_14266 = G__14278;
chunk__14262_14267 = G__14279;
count__14263_14268 = G__14280;
i__14264_14269 = G__14281;
continue;
}
} else
{var c_14282 = cljs.core.first.call(null,seq__14261_14276__$1);prepend_BANG_.call(null,parent,c_14282);
{
var G__14283 = cljs.core.next.call(null,seq__14261_14276__$1);
var G__14284 = null;
var G__14285 = (0);
var G__14286 = (0);
seq__14261_14266 = G__14283;
chunk__14262_14267 = G__14284;
count__14263_14268 = G__14285;
i__14264_14269 = G__14286;
continue;
}
}
} else
{}
}
break;
}
return parent;
};
var G__14265 = function (parent,child,var_args){
var more_children = null;if (arguments.length > 2) {
  more_children = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);} 
return G__14265__delegate.call(this,parent,child,more_children);};
G__14265.cljs$lang$maxFixedArity = 2;
G__14265.cljs$lang$applyTo = (function (arglist__14287){
var parent = cljs.core.first(arglist__14287);
arglist__14287 = cljs.core.next(arglist__14287);
var child = cljs.core.first(arglist__14287);
var more_children = cljs.core.rest(arglist__14287);
return G__14265__delegate(parent,child,more_children);
});
G__14265.cljs$core$IFn$_invoke$arity$variadic = G__14265__delegate;
return G__14265;
})()
;
prepend_BANG_ = function(parent,child,var_args){
var more_children = var_args;
switch(arguments.length){
case 2:
return prepend_BANG___2.call(this,parent,child);
default:
return prepend_BANG___3.cljs$core$IFn$_invoke$arity$variadic(parent,child, cljs.core.array_seq(arguments, 2));
}
throw(new Error('Invalid arity: ' + arguments.length));
};
prepend_BANG_.cljs$lang$maxFixedArity = 2;
prepend_BANG_.cljs$lang$applyTo = prepend_BANG___3.cljs$lang$applyTo;
prepend_BANG_.cljs$core$IFn$_invoke$arity$2 = prepend_BANG___2;
prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic = prepend_BANG___3.cljs$core$IFn$_invoke$arity$variadic;
return prepend_BANG_;
})()
;
/**
* Insert `elem` before `other`, `other` must have a parent
*/
dommy.core.insert_before_BANG_ = (function insert_before_BANG_(elem,other){var p = dommy.core.parent.call(null,other);if(cljs.core.truth_(p))
{} else
{throw (new Error(("Assert failed: Target element must have a parent\n"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"p","p",1791580836,null))))));
}
p.insertBefore(elem,other);
return elem;
});
/**
* Insert `elem` after `other`, `other` must have a parent
*/
dommy.core.insert_after_BANG_ = (function insert_after_BANG_(elem,other){var temp__4124__auto___14288 = other.nextSibling;if(cljs.core.truth_(temp__4124__auto___14288))
{var next_14289 = temp__4124__auto___14288;dommy.core.insert_before_BANG_.call(null,elem,next_14289);
} else
{dommy.core.append_BANG_.call(null,dommy.core.parent.call(null,other),elem);
}
return elem;
});
/**
* Replace `elem` with `new`, return `new`
*/
dommy.core.replace_BANG_ = (function replace_BANG_(elem,new$){var p = dommy.core.parent.call(null,elem);if(cljs.core.truth_(p))
{} else
{throw (new Error(("Assert failed: Target element must have a parent\n"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"p","p",1791580836,null))))));
}
p.replaceChild(new$,elem);
return new$;
});
/**
* Replace children of `elem` with `child`
*/
dommy.core.replace_contents_BANG_ = (function replace_contents_BANG_(p,child){return dommy.core.append_BANG_.call(null,dommy.core.clear_BANG_.call(null,p),child);
});
/**
* Remove `elem` from `parent`, return `parent`
*/
dommy.core.remove_BANG_ = (function() {
var remove_BANG_ = null;
var remove_BANG___1 = (function (elem){var p = dommy.core.parent.call(null,elem);if(cljs.core.truth_(p))
{} else
{throw (new Error(("Assert failed: Target element must have a parent\n"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"p","p",1791580836,null))))));
}
return remove_BANG_.call(null,p,elem);
});
var remove_BANG___2 = (function (p,elem){var G__14291 = p;G__14291.removeChild(elem);
return G__14291;
});
remove_BANG_ = function(p,elem){
switch(arguments.length){
case 1:
return remove_BANG___1.call(this,p);
case 2:
return remove_BANG___2.call(this,p,elem);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
remove_BANG_.cljs$core$IFn$_invoke$arity$1 = remove_BANG___1;
remove_BANG_.cljs$core$IFn$_invoke$arity$2 = remove_BANG___2;
return remove_BANG_;
})()
;
dommy.core.special_listener_makers = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,(function (p__14292){var vec__14293 = p__14292;var special_mouse_event = cljs.core.nth.call(null,vec__14293,(0),null);var real_mouse_event = cljs.core.nth.call(null,vec__14293,(1),null);return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [special_mouse_event,new cljs.core.PersistentArrayMap.fromArray([real_mouse_event,((function (vec__14293,special_mouse_event,real_mouse_event){
return (function (f){return ((function (vec__14293,special_mouse_event,real_mouse_event){
return (function (event){var related_target = event.relatedTarget;var listener_target = (function (){var or__3648__auto__ = event.selectedTarget;if(cljs.core.truth_(or__3648__auto__))
{return or__3648__auto__;
} else
{return event.currentTarget;
}
})();if(cljs.core.truth_((function (){var and__3636__auto__ = related_target;if(cljs.core.truth_(and__3636__auto__))
{return dommy.core.descendant_QMARK_.call(null,related_target,listener_target);
} else
{return and__3636__auto__;
}
})()))
{return null;
} else
{return f.call(null,event);
}
});
;})(vec__14293,special_mouse_event,real_mouse_event))
});})(vec__14293,special_mouse_event,real_mouse_event))
], true, false)], null);
}),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"mouseenter","mouseenter",-1792413560),new cljs.core.Keyword(null,"mouseover","mouseover",-484272303),new cljs.core.Keyword(null,"mouseleave","mouseleave",531566580),new cljs.core.Keyword(null,"mouseout","mouseout",2049446890)], null)));
/**
* fires f if event.target is found with `selector`
*/
dommy.core.live_listener = (function live_listener(elem,selector,f){return (function (event){var selected_target = dommy.core.closest.call(null,elem,event.target,selector);if(cljs.core.truth_((function (){var and__3636__auto__ = selected_target;if(cljs.core.truth_(and__3636__auto__))
{return cljs.core.not.call(null,dommy.core.attr.call(null,selected_target,new cljs.core.Keyword(null,"disabled","disabled",-1529784218)));
} else
{return and__3636__auto__;
}
})()))
{event.selectedTarget = selected_target;
return f.call(null,event);
} else
{return null;
}
});
});
/**
* Returns a nested map of event listeners on `elem`
*/
dommy.core.event_listeners = (function event_listeners(elem){var or__3648__auto__ = elem.dommyEventListeners;if(cljs.core.truth_(or__3648__auto__))
{return or__3648__auto__;
} else
{return cljs.core.PersistentArrayMap.EMPTY;
}
});
/**
* @param {...*} var_args
*/
dommy.core.update_event_listeners_BANG_ = (function() { 
var update_event_listeners_BANG___delegate = function (elem,f,args){var elem__$1 = elem;return elem__$1.dommyEventListeners = cljs.core.apply.call(null,f,dommy.core.event_listeners.call(null,elem__$1),args);
};
var update_event_listeners_BANG_ = function (elem,f,var_args){
var args = null;if (arguments.length > 2) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);} 
return update_event_listeners_BANG___delegate.call(this,elem,f,args);};
update_event_listeners_BANG_.cljs$lang$maxFixedArity = 2;
update_event_listeners_BANG_.cljs$lang$applyTo = (function (arglist__14294){
var elem = cljs.core.first(arglist__14294);
arglist__14294 = cljs.core.next(arglist__14294);
var f = cljs.core.first(arglist__14294);
var args = cljs.core.rest(arglist__14294);
return update_event_listeners_BANG___delegate(elem,f,args);
});
update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic = update_event_listeners_BANG___delegate;
return update_event_listeners_BANG_;
})()
;
dommy.core.elem_and_selector = (function elem_and_selector(elem_sel){if(cljs.core.sequential_QMARK_.call(null,elem_sel))
{return cljs.core.juxt.call(null,cljs.core.first,cljs.core.rest).call(null,elem_sel);
} else
{return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [elem_sel,null], null);
}
});
/**
* Adds `f` as a listener for events of type `event-type` on
* `elem-sel`, which must either be a DOM node, or a sequence
* whose first item is a DOM node.
* 
* In other words, the call to `listen!` can take two forms:
* 
* If `elem-sel` is a DOM node, i.e., you're doing something like:
* 
* (listen! elem :click click-handler)
* 
* then `click-handler` will be set as a listener for `click` events
* on the `elem`.
* 
* If `elem-sel` is a sequence:
* 
* (listen! [elem :.selector.for :.some.descendants] :click click-handler)
* 
* then `click-handler` will be set as a listener for `click` events
* on descendants of `elem` that match the selector
* 
* Also accepts any number of event-type and handler pairs for setting
* multiple listeners at once:
* 
* (listen! some-elem :click click-handler :hover hover-handler)
* @param {...*} var_args
*/
dommy.core.listen_BANG_ = (function() { 
var listen_BANG___delegate = function (elem_sel,type_fs){if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,type_fs)))
{} else
{throw (new Error(("Assert failed: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"type-fs","type-fs",1567896074,null))))))));
}
var vec__14318_14341 = dommy.core.elem_and_selector.call(null,elem_sel);var elem_14342 = cljs.core.nth.call(null,vec__14318_14341,(0),null);var selector_14343 = cljs.core.nth.call(null,vec__14318_14341,(1),null);var seq__14319_14344 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),type_fs));var chunk__14326_14345 = null;var count__14327_14346 = (0);var i__14328_14347 = (0);while(true){
if((i__14328_14347 < count__14327_14346))
{var vec__14335_14348 = cljs.core._nth.call(null,chunk__14326_14345,i__14328_14347);var orig_type_14349 = cljs.core.nth.call(null,vec__14335_14348,(0),null);var f_14350 = cljs.core.nth.call(null,vec__14335_14348,(1),null);var seq__14329_14351 = cljs.core.seq.call(null,cljs.core.get.call(null,dommy.core.special_listener_makers,orig_type_14349,new cljs.core.PersistentArrayMap.fromArray([orig_type_14349,cljs.core.identity], true, false)));var chunk__14331_14352 = null;var count__14332_14353 = (0);var i__14333_14354 = (0);while(true){
if((i__14333_14354 < count__14332_14353))
{var vec__14336_14355 = cljs.core._nth.call(null,chunk__14331_14352,i__14333_14354);var actual_type_14356 = cljs.core.nth.call(null,vec__14336_14355,(0),null);var factory_14357 = cljs.core.nth.call(null,vec__14336_14355,(1),null);var canonical_f_14358 = (cljs.core.truth_(selector_14343)?cljs.core.partial.call(null,dommy.core.live_listener,elem_14342,selector_14343):cljs.core.identity).call(null,factory_14357.call(null,f_14350));dommy.core.update_event_listeners_BANG_.call(null,elem_14342,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_14343,actual_type_14356,f_14350], null),canonical_f_14358);
if(cljs.core.truth_(elem_14342.addEventListener))
{elem_14342.addEventListener(cljs.core.name.call(null,actual_type_14356),canonical_f_14358);
} else
{elem_14342.attachEvent(cljs.core.name.call(null,actual_type_14356),canonical_f_14358);
}
{
var G__14359 = seq__14329_14351;
var G__14360 = chunk__14331_14352;
var G__14361 = count__14332_14353;
var G__14362 = (i__14333_14354 + (1));
seq__14329_14351 = G__14359;
chunk__14331_14352 = G__14360;
count__14332_14353 = G__14361;
i__14333_14354 = G__14362;
continue;
}
} else
{var temp__4126__auto___14363 = cljs.core.seq.call(null,seq__14329_14351);if(temp__4126__auto___14363)
{var seq__14329_14364__$1 = temp__4126__auto___14363;if(cljs.core.chunked_seq_QMARK_.call(null,seq__14329_14364__$1))
{var c__4418__auto___14365 = cljs.core.chunk_first.call(null,seq__14329_14364__$1);{
var G__14366 = cljs.core.chunk_rest.call(null,seq__14329_14364__$1);
var G__14367 = c__4418__auto___14365;
var G__14368 = cljs.core.count.call(null,c__4418__auto___14365);
var G__14369 = (0);
seq__14329_14351 = G__14366;
chunk__14331_14352 = G__14367;
count__14332_14353 = G__14368;
i__14333_14354 = G__14369;
continue;
}
} else
{var vec__14337_14370 = cljs.core.first.call(null,seq__14329_14364__$1);var actual_type_14371 = cljs.core.nth.call(null,vec__14337_14370,(0),null);var factory_14372 = cljs.core.nth.call(null,vec__14337_14370,(1),null);var canonical_f_14373 = (cljs.core.truth_(selector_14343)?cljs.core.partial.call(null,dommy.core.live_listener,elem_14342,selector_14343):cljs.core.identity).call(null,factory_14372.call(null,f_14350));dommy.core.update_event_listeners_BANG_.call(null,elem_14342,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_14343,actual_type_14371,f_14350], null),canonical_f_14373);
if(cljs.core.truth_(elem_14342.addEventListener))
{elem_14342.addEventListener(cljs.core.name.call(null,actual_type_14371),canonical_f_14373);
} else
{elem_14342.attachEvent(cljs.core.name.call(null,actual_type_14371),canonical_f_14373);
}
{
var G__14374 = cljs.core.next.call(null,seq__14329_14364__$1);
var G__14375 = null;
var G__14376 = (0);
var G__14377 = (0);
seq__14329_14351 = G__14374;
chunk__14331_14352 = G__14375;
count__14332_14353 = G__14376;
i__14333_14354 = G__14377;
continue;
}
}
} else
{}
}
break;
}
{
var G__14378 = seq__14319_14344;
var G__14379 = chunk__14326_14345;
var G__14380 = count__14327_14346;
var G__14381 = (i__14328_14347 + (1));
seq__14319_14344 = G__14378;
chunk__14326_14345 = G__14379;
count__14327_14346 = G__14380;
i__14328_14347 = G__14381;
continue;
}
} else
{var temp__4126__auto___14382 = cljs.core.seq.call(null,seq__14319_14344);if(temp__4126__auto___14382)
{var seq__14319_14383__$1 = temp__4126__auto___14382;if(cljs.core.chunked_seq_QMARK_.call(null,seq__14319_14383__$1))
{var c__4418__auto___14384 = cljs.core.chunk_first.call(null,seq__14319_14383__$1);{
var G__14385 = cljs.core.chunk_rest.call(null,seq__14319_14383__$1);
var G__14386 = c__4418__auto___14384;
var G__14387 = cljs.core.count.call(null,c__4418__auto___14384);
var G__14388 = (0);
seq__14319_14344 = G__14385;
chunk__14326_14345 = G__14386;
count__14327_14346 = G__14387;
i__14328_14347 = G__14388;
continue;
}
} else
{var vec__14338_14389 = cljs.core.first.call(null,seq__14319_14383__$1);var orig_type_14390 = cljs.core.nth.call(null,vec__14338_14389,(0),null);var f_14391 = cljs.core.nth.call(null,vec__14338_14389,(1),null);var seq__14320_14392 = cljs.core.seq.call(null,cljs.core.get.call(null,dommy.core.special_listener_makers,orig_type_14390,new cljs.core.PersistentArrayMap.fromArray([orig_type_14390,cljs.core.identity], true, false)));var chunk__14322_14393 = null;var count__14323_14394 = (0);var i__14324_14395 = (0);while(true){
if((i__14324_14395 < count__14323_14394))
{var vec__14339_14396 = cljs.core._nth.call(null,chunk__14322_14393,i__14324_14395);var actual_type_14397 = cljs.core.nth.call(null,vec__14339_14396,(0),null);var factory_14398 = cljs.core.nth.call(null,vec__14339_14396,(1),null);var canonical_f_14399 = (cljs.core.truth_(selector_14343)?cljs.core.partial.call(null,dommy.core.live_listener,elem_14342,selector_14343):cljs.core.identity).call(null,factory_14398.call(null,f_14391));dommy.core.update_event_listeners_BANG_.call(null,elem_14342,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_14343,actual_type_14397,f_14391], null),canonical_f_14399);
if(cljs.core.truth_(elem_14342.addEventListener))
{elem_14342.addEventListener(cljs.core.name.call(null,actual_type_14397),canonical_f_14399);
} else
{elem_14342.attachEvent(cljs.core.name.call(null,actual_type_14397),canonical_f_14399);
}
{
var G__14400 = seq__14320_14392;
var G__14401 = chunk__14322_14393;
var G__14402 = count__14323_14394;
var G__14403 = (i__14324_14395 + (1));
seq__14320_14392 = G__14400;
chunk__14322_14393 = G__14401;
count__14323_14394 = G__14402;
i__14324_14395 = G__14403;
continue;
}
} else
{var temp__4126__auto___14404__$1 = cljs.core.seq.call(null,seq__14320_14392);if(temp__4126__auto___14404__$1)
{var seq__14320_14405__$1 = temp__4126__auto___14404__$1;if(cljs.core.chunked_seq_QMARK_.call(null,seq__14320_14405__$1))
{var c__4418__auto___14406 = cljs.core.chunk_first.call(null,seq__14320_14405__$1);{
var G__14407 = cljs.core.chunk_rest.call(null,seq__14320_14405__$1);
var G__14408 = c__4418__auto___14406;
var G__14409 = cljs.core.count.call(null,c__4418__auto___14406);
var G__14410 = (0);
seq__14320_14392 = G__14407;
chunk__14322_14393 = G__14408;
count__14323_14394 = G__14409;
i__14324_14395 = G__14410;
continue;
}
} else
{var vec__14340_14411 = cljs.core.first.call(null,seq__14320_14405__$1);var actual_type_14412 = cljs.core.nth.call(null,vec__14340_14411,(0),null);var factory_14413 = cljs.core.nth.call(null,vec__14340_14411,(1),null);var canonical_f_14414 = (cljs.core.truth_(selector_14343)?cljs.core.partial.call(null,dommy.core.live_listener,elem_14342,selector_14343):cljs.core.identity).call(null,factory_14413.call(null,f_14391));dommy.core.update_event_listeners_BANG_.call(null,elem_14342,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_14343,actual_type_14412,f_14391], null),canonical_f_14414);
if(cljs.core.truth_(elem_14342.addEventListener))
{elem_14342.addEventListener(cljs.core.name.call(null,actual_type_14412),canonical_f_14414);
} else
{elem_14342.attachEvent(cljs.core.name.call(null,actual_type_14412),canonical_f_14414);
}
{
var G__14415 = cljs.core.next.call(null,seq__14320_14405__$1);
var G__14416 = null;
var G__14417 = (0);
var G__14418 = (0);
seq__14320_14392 = G__14415;
chunk__14322_14393 = G__14416;
count__14323_14394 = G__14417;
i__14324_14395 = G__14418;
continue;
}
}
} else
{}
}
break;
}
{
var G__14419 = cljs.core.next.call(null,seq__14319_14383__$1);
var G__14420 = null;
var G__14421 = (0);
var G__14422 = (0);
seq__14319_14344 = G__14419;
chunk__14326_14345 = G__14420;
count__14327_14346 = G__14421;
i__14328_14347 = G__14422;
continue;
}
}
} else
{}
}
break;
}
return elem_sel;
};
var listen_BANG_ = function (elem_sel,var_args){
var type_fs = null;if (arguments.length > 1) {
  type_fs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return listen_BANG___delegate.call(this,elem_sel,type_fs);};
listen_BANG_.cljs$lang$maxFixedArity = 1;
listen_BANG_.cljs$lang$applyTo = (function (arglist__14423){
var elem_sel = cljs.core.first(arglist__14423);
var type_fs = cljs.core.rest(arglist__14423);
return listen_BANG___delegate(elem_sel,type_fs);
});
listen_BANG_.cljs$core$IFn$_invoke$arity$variadic = listen_BANG___delegate;
return listen_BANG_;
})()
;
/**
* Removes event listener for the element defined in `elem-sel`,
* which is the same format as listen!.
* 
* The following forms are allowed, and will remove all handlers
* that match the parameters passed in:
* 
* (unlisten! [elem :.selector] :click event-listener)
* 
* (unlisten! [elem :.selector]
* :click event-listener
* :mouseover other-event-listener)
* @param {...*} var_args
*/
dommy.core.unlisten_BANG_ = (function() { 
var unlisten_BANG___delegate = function (elem_sel,type_fs){if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,type_fs)))
{} else
{throw (new Error(("Assert failed: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"type-fs","type-fs",1567896074,null))))))));
}
var vec__14447_14470 = dommy.core.elem_and_selector.call(null,elem_sel);var elem_14471 = cljs.core.nth.call(null,vec__14447_14470,(0),null);var selector_14472 = cljs.core.nth.call(null,vec__14447_14470,(1),null);var seq__14448_14473 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),type_fs));var chunk__14455_14474 = null;var count__14456_14475 = (0);var i__14457_14476 = (0);while(true){
if((i__14457_14476 < count__14456_14475))
{var vec__14464_14477 = cljs.core._nth.call(null,chunk__14455_14474,i__14457_14476);var orig_type_14478 = cljs.core.nth.call(null,vec__14464_14477,(0),null);var f_14479 = cljs.core.nth.call(null,vec__14464_14477,(1),null);var seq__14458_14480 = cljs.core.seq.call(null,cljs.core.get.call(null,dommy.core.special_listener_makers,orig_type_14478,new cljs.core.PersistentArrayMap.fromArray([orig_type_14478,cljs.core.identity], true, false)));var chunk__14460_14481 = null;var count__14461_14482 = (0);var i__14462_14483 = (0);while(true){
if((i__14462_14483 < count__14461_14482))
{var vec__14465_14484 = cljs.core._nth.call(null,chunk__14460_14481,i__14462_14483);var actual_type_14485 = cljs.core.nth.call(null,vec__14465_14484,(0),null);var __14486 = cljs.core.nth.call(null,vec__14465_14484,(1),null);var keys_14487 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_14472,actual_type_14485,f_14479], null);var canonical_f_14488 = cljs.core.get_in.call(null,dommy.core.event_listeners.call(null,elem_14471),keys_14487);dommy.core.update_event_listeners_BANG_.call(null,elem_14471,dommy.utils.dissoc_in,keys_14487);
if(cljs.core.truth_(elem_14471.removeEventListener))
{elem_14471.removeEventListener(cljs.core.name.call(null,actual_type_14485),canonical_f_14488);
} else
{elem_14471.detachEvent(cljs.core.name.call(null,actual_type_14485),canonical_f_14488);
}
{
var G__14489 = seq__14458_14480;
var G__14490 = chunk__14460_14481;
var G__14491 = count__14461_14482;
var G__14492 = (i__14462_14483 + (1));
seq__14458_14480 = G__14489;
chunk__14460_14481 = G__14490;
count__14461_14482 = G__14491;
i__14462_14483 = G__14492;
continue;
}
} else
{var temp__4126__auto___14493 = cljs.core.seq.call(null,seq__14458_14480);if(temp__4126__auto___14493)
{var seq__14458_14494__$1 = temp__4126__auto___14493;if(cljs.core.chunked_seq_QMARK_.call(null,seq__14458_14494__$1))
{var c__4418__auto___14495 = cljs.core.chunk_first.call(null,seq__14458_14494__$1);{
var G__14496 = cljs.core.chunk_rest.call(null,seq__14458_14494__$1);
var G__14497 = c__4418__auto___14495;
var G__14498 = cljs.core.count.call(null,c__4418__auto___14495);
var G__14499 = (0);
seq__14458_14480 = G__14496;
chunk__14460_14481 = G__14497;
count__14461_14482 = G__14498;
i__14462_14483 = G__14499;
continue;
}
} else
{var vec__14466_14500 = cljs.core.first.call(null,seq__14458_14494__$1);var actual_type_14501 = cljs.core.nth.call(null,vec__14466_14500,(0),null);var __14502 = cljs.core.nth.call(null,vec__14466_14500,(1),null);var keys_14503 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_14472,actual_type_14501,f_14479], null);var canonical_f_14504 = cljs.core.get_in.call(null,dommy.core.event_listeners.call(null,elem_14471),keys_14503);dommy.core.update_event_listeners_BANG_.call(null,elem_14471,dommy.utils.dissoc_in,keys_14503);
if(cljs.core.truth_(elem_14471.removeEventListener))
{elem_14471.removeEventListener(cljs.core.name.call(null,actual_type_14501),canonical_f_14504);
} else
{elem_14471.detachEvent(cljs.core.name.call(null,actual_type_14501),canonical_f_14504);
}
{
var G__14505 = cljs.core.next.call(null,seq__14458_14494__$1);
var G__14506 = null;
var G__14507 = (0);
var G__14508 = (0);
seq__14458_14480 = G__14505;
chunk__14460_14481 = G__14506;
count__14461_14482 = G__14507;
i__14462_14483 = G__14508;
continue;
}
}
} else
{}
}
break;
}
{
var G__14509 = seq__14448_14473;
var G__14510 = chunk__14455_14474;
var G__14511 = count__14456_14475;
var G__14512 = (i__14457_14476 + (1));
seq__14448_14473 = G__14509;
chunk__14455_14474 = G__14510;
count__14456_14475 = G__14511;
i__14457_14476 = G__14512;
continue;
}
} else
{var temp__4126__auto___14513 = cljs.core.seq.call(null,seq__14448_14473);if(temp__4126__auto___14513)
{var seq__14448_14514__$1 = temp__4126__auto___14513;if(cljs.core.chunked_seq_QMARK_.call(null,seq__14448_14514__$1))
{var c__4418__auto___14515 = cljs.core.chunk_first.call(null,seq__14448_14514__$1);{
var G__14516 = cljs.core.chunk_rest.call(null,seq__14448_14514__$1);
var G__14517 = c__4418__auto___14515;
var G__14518 = cljs.core.count.call(null,c__4418__auto___14515);
var G__14519 = (0);
seq__14448_14473 = G__14516;
chunk__14455_14474 = G__14517;
count__14456_14475 = G__14518;
i__14457_14476 = G__14519;
continue;
}
} else
{var vec__14467_14520 = cljs.core.first.call(null,seq__14448_14514__$1);var orig_type_14521 = cljs.core.nth.call(null,vec__14467_14520,(0),null);var f_14522 = cljs.core.nth.call(null,vec__14467_14520,(1),null);var seq__14449_14523 = cljs.core.seq.call(null,cljs.core.get.call(null,dommy.core.special_listener_makers,orig_type_14521,new cljs.core.PersistentArrayMap.fromArray([orig_type_14521,cljs.core.identity], true, false)));var chunk__14451_14524 = null;var count__14452_14525 = (0);var i__14453_14526 = (0);while(true){
if((i__14453_14526 < count__14452_14525))
{var vec__14468_14527 = cljs.core._nth.call(null,chunk__14451_14524,i__14453_14526);var actual_type_14528 = cljs.core.nth.call(null,vec__14468_14527,(0),null);var __14529 = cljs.core.nth.call(null,vec__14468_14527,(1),null);var keys_14530 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_14472,actual_type_14528,f_14522], null);var canonical_f_14531 = cljs.core.get_in.call(null,dommy.core.event_listeners.call(null,elem_14471),keys_14530);dommy.core.update_event_listeners_BANG_.call(null,elem_14471,dommy.utils.dissoc_in,keys_14530);
if(cljs.core.truth_(elem_14471.removeEventListener))
{elem_14471.removeEventListener(cljs.core.name.call(null,actual_type_14528),canonical_f_14531);
} else
{elem_14471.detachEvent(cljs.core.name.call(null,actual_type_14528),canonical_f_14531);
}
{
var G__14532 = seq__14449_14523;
var G__14533 = chunk__14451_14524;
var G__14534 = count__14452_14525;
var G__14535 = (i__14453_14526 + (1));
seq__14449_14523 = G__14532;
chunk__14451_14524 = G__14533;
count__14452_14525 = G__14534;
i__14453_14526 = G__14535;
continue;
}
} else
{var temp__4126__auto___14536__$1 = cljs.core.seq.call(null,seq__14449_14523);if(temp__4126__auto___14536__$1)
{var seq__14449_14537__$1 = temp__4126__auto___14536__$1;if(cljs.core.chunked_seq_QMARK_.call(null,seq__14449_14537__$1))
{var c__4418__auto___14538 = cljs.core.chunk_first.call(null,seq__14449_14537__$1);{
var G__14539 = cljs.core.chunk_rest.call(null,seq__14449_14537__$1);
var G__14540 = c__4418__auto___14538;
var G__14541 = cljs.core.count.call(null,c__4418__auto___14538);
var G__14542 = (0);
seq__14449_14523 = G__14539;
chunk__14451_14524 = G__14540;
count__14452_14525 = G__14541;
i__14453_14526 = G__14542;
continue;
}
} else
{var vec__14469_14543 = cljs.core.first.call(null,seq__14449_14537__$1);var actual_type_14544 = cljs.core.nth.call(null,vec__14469_14543,(0),null);var __14545 = cljs.core.nth.call(null,vec__14469_14543,(1),null);var keys_14546 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_14472,actual_type_14544,f_14522], null);var canonical_f_14547 = cljs.core.get_in.call(null,dommy.core.event_listeners.call(null,elem_14471),keys_14546);dommy.core.update_event_listeners_BANG_.call(null,elem_14471,dommy.utils.dissoc_in,keys_14546);
if(cljs.core.truth_(elem_14471.removeEventListener))
{elem_14471.removeEventListener(cljs.core.name.call(null,actual_type_14544),canonical_f_14547);
} else
{elem_14471.detachEvent(cljs.core.name.call(null,actual_type_14544),canonical_f_14547);
}
{
var G__14548 = cljs.core.next.call(null,seq__14449_14537__$1);
var G__14549 = null;
var G__14550 = (0);
var G__14551 = (0);
seq__14449_14523 = G__14548;
chunk__14451_14524 = G__14549;
count__14452_14525 = G__14550;
i__14453_14526 = G__14551;
continue;
}
}
} else
{}
}
break;
}
{
var G__14552 = cljs.core.next.call(null,seq__14448_14514__$1);
var G__14553 = null;
var G__14554 = (0);
var G__14555 = (0);
seq__14448_14473 = G__14552;
chunk__14455_14474 = G__14553;
count__14456_14475 = G__14554;
i__14457_14476 = G__14555;
continue;
}
}
} else
{}
}
break;
}
return elem_sel;
};
var unlisten_BANG_ = function (elem_sel,var_args){
var type_fs = null;if (arguments.length > 1) {
  type_fs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return unlisten_BANG___delegate.call(this,elem_sel,type_fs);};
unlisten_BANG_.cljs$lang$maxFixedArity = 1;
unlisten_BANG_.cljs$lang$applyTo = (function (arglist__14556){
var elem_sel = cljs.core.first(arglist__14556);
var type_fs = cljs.core.rest(arglist__14556);
return unlisten_BANG___delegate(elem_sel,type_fs);
});
unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic = unlisten_BANG___delegate;
return unlisten_BANG_;
})()
;
/**
* Behaves like `listen!`, but removes the listener after the first event occurs.
* @param {...*} var_args
*/
dommy.core.listen_once_BANG_ = (function() { 
var listen_once_BANG___delegate = function (elem_sel,type_fs){if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,type_fs)))
{} else
{throw (new Error(("Assert failed: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"type-fs","type-fs",1567896074,null))))))));
}
var vec__14564_14571 = dommy.core.elem_and_selector.call(null,elem_sel);var elem_14572 = cljs.core.nth.call(null,vec__14564_14571,(0),null);var selector_14573 = cljs.core.nth.call(null,vec__14564_14571,(1),null);var seq__14565_14574 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),type_fs));var chunk__14566_14575 = null;var count__14567_14576 = (0);var i__14568_14577 = (0);while(true){
if((i__14568_14577 < count__14567_14576))
{var vec__14569_14578 = cljs.core._nth.call(null,chunk__14566_14575,i__14568_14577);var type_14579 = cljs.core.nth.call(null,vec__14569_14578,(0),null);var f_14580 = cljs.core.nth.call(null,vec__14569_14578,(1),null);dommy.core.listen_BANG_.call(null,elem_sel,type_14579,((function (seq__14565_14574,chunk__14566_14575,count__14567_14576,i__14568_14577,vec__14569_14578,type_14579,f_14580,vec__14564_14571,elem_14572,selector_14573){
return (function this_fn(e){dommy.core.unlisten_BANG_.call(null,elem_sel,type_14579,this_fn);
return f_14580.call(null,e);
});})(seq__14565_14574,chunk__14566_14575,count__14567_14576,i__14568_14577,vec__14569_14578,type_14579,f_14580,vec__14564_14571,elem_14572,selector_14573))
);
{
var G__14581 = seq__14565_14574;
var G__14582 = chunk__14566_14575;
var G__14583 = count__14567_14576;
var G__14584 = (i__14568_14577 + (1));
seq__14565_14574 = G__14581;
chunk__14566_14575 = G__14582;
count__14567_14576 = G__14583;
i__14568_14577 = G__14584;
continue;
}
} else
{var temp__4126__auto___14585 = cljs.core.seq.call(null,seq__14565_14574);if(temp__4126__auto___14585)
{var seq__14565_14586__$1 = temp__4126__auto___14585;if(cljs.core.chunked_seq_QMARK_.call(null,seq__14565_14586__$1))
{var c__4418__auto___14587 = cljs.core.chunk_first.call(null,seq__14565_14586__$1);{
var G__14588 = cljs.core.chunk_rest.call(null,seq__14565_14586__$1);
var G__14589 = c__4418__auto___14587;
var G__14590 = cljs.core.count.call(null,c__4418__auto___14587);
var G__14591 = (0);
seq__14565_14574 = G__14588;
chunk__14566_14575 = G__14589;
count__14567_14576 = G__14590;
i__14568_14577 = G__14591;
continue;
}
} else
{var vec__14570_14592 = cljs.core.first.call(null,seq__14565_14586__$1);var type_14593 = cljs.core.nth.call(null,vec__14570_14592,(0),null);var f_14594 = cljs.core.nth.call(null,vec__14570_14592,(1),null);dommy.core.listen_BANG_.call(null,elem_sel,type_14593,((function (seq__14565_14574,chunk__14566_14575,count__14567_14576,i__14568_14577,vec__14570_14592,type_14593,f_14594,seq__14565_14586__$1,temp__4126__auto___14585,vec__14564_14571,elem_14572,selector_14573){
return (function this_fn(e){dommy.core.unlisten_BANG_.call(null,elem_sel,type_14593,this_fn);
return f_14594.call(null,e);
});})(seq__14565_14574,chunk__14566_14575,count__14567_14576,i__14568_14577,vec__14570_14592,type_14593,f_14594,seq__14565_14586__$1,temp__4126__auto___14585,vec__14564_14571,elem_14572,selector_14573))
);
{
var G__14595 = cljs.core.next.call(null,seq__14565_14586__$1);
var G__14596 = null;
var G__14597 = (0);
var G__14598 = (0);
seq__14565_14574 = G__14595;
chunk__14566_14575 = G__14596;
count__14567_14576 = G__14597;
i__14568_14577 = G__14598;
continue;
}
}
} else
{}
}
break;
}
return elem_sel;
};
var listen_once_BANG_ = function (elem_sel,var_args){
var type_fs = null;if (arguments.length > 1) {
  type_fs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return listen_once_BANG___delegate.call(this,elem_sel,type_fs);};
listen_once_BANG_.cljs$lang$maxFixedArity = 1;
listen_once_BANG_.cljs$lang$applyTo = (function (arglist__14599){
var elem_sel = cljs.core.first(arglist__14599);
var type_fs = cljs.core.rest(arglist__14599);
return listen_once_BANG___delegate(elem_sel,type_fs);
});
listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic = listen_once_BANG___delegate;
return listen_once_BANG_;
})()
;
