// Compiled by ClojureScript 0.0-2371
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function fn_handler(f){if(typeof cljs.core.async.t10753 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t10753 = (function (f,fn_handler,meta10754){
this.f = f;
this.fn_handler = fn_handler;
this.meta10754 = meta10754;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t10753.cljs$lang$type = true;
cljs.core.async.t10753.cljs$lang$ctorStr = "cljs.core.async/t10753";
cljs.core.async.t10753.cljs$lang$ctorPrWriter = (function (this__4225__auto__,writer__4226__auto__,opt__4227__auto__){return cljs.core._write.call(null,writer__4226__auto__,"cljs.core.async/t10753");
});
cljs.core.async.t10753.prototype.cljs$core$async$impl$protocols$Handler$ = true;
cljs.core.async.t10753.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return true;
});
cljs.core.async.t10753.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return self__.f;
});
cljs.core.async.t10753.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_10755){var self__ = this;
var _10755__$1 = this;return self__.meta10754;
});
cljs.core.async.t10753.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_10755,meta10754__$1){var self__ = this;
var _10755__$1 = this;return (new cljs.core.async.t10753(self__.f,self__.fn_handler,meta10754__$1));
});
cljs.core.async.__GT_t10753 = (function __GT_t10753(f__$1,fn_handler__$1,meta10754){return (new cljs.core.async.t10753(f__$1,fn_handler__$1,meta10754));
});
}
return (new cljs.core.async.t10753(f,fn_handler,null));
});
/**
* Returns a fixed buffer of size n. When full, puts will block/park.
*/
cljs.core.async.buffer = (function buffer(n){return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
* Returns a buffer of size n. When full, puts will complete but
* val will be dropped (no transfer).
*/
cljs.core.async.dropping_buffer = (function dropping_buffer(n){return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
* Returns a buffer of size n. When full, puts will complete, and be
* buffered, but oldest elements in buffer will be dropped (not
* transferred).
*/
cljs.core.async.sliding_buffer = (function sliding_buffer(n){return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
* Returns true if a channel created with buff will never block. That is to say,
* puts into this buffer will never cause the buffer to be full.
*/
cljs.core.async.unblocking_buffer_QMARK_ = (function unblocking_buffer_QMARK_(buff){var G__10757 = buff;if(G__10757)
{var bit__4312__auto__ = null;if(cljs.core.truth_((function (){var or__3648__auto__ = bit__4312__auto__;if(cljs.core.truth_(or__3648__auto__))
{return or__3648__auto__;
} else
{return G__10757.cljs$core$async$impl$protocols$UnblockingBuffer$;
}
})()))
{return true;
} else
{if((!G__10757.cljs$lang$protocol_mask$partition$))
{return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,G__10757);
} else
{return false;
}
}
} else
{return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,G__10757);
}
});
/**
* Creates a channel with an optional buffer, an optional transducer (like (map f),
* (filter p) etc or a composition thereof), and an optional exception handler.
* If buf-or-n is a number, will create and use a fixed buffer of that size. If a
* transducer is supplied a buffer must be specified. ex-handler must be a
* fn of one argument - if an exception occurs during transformation it will be called
* with the thrown value as an argument, and any non-nil return value will be placed
* in the channel.
*/
cljs.core.async.chan = (function() {
var chan = null;
var chan__0 = (function (){return chan.call(null,null);
});
var chan__1 = (function (buf_or_n){return chan.call(null,buf_or_n,null,null);
});
var chan__2 = (function (buf_or_n,xform){return chan.call(null,buf_or_n,xform,null);
});
var chan__3 = (function (buf_or_n,xform,ex_handler){var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);if(cljs.core.truth_(xform))
{if(cljs.core.truth_(buf_or_n__$1))
{} else
{throw (new Error(("Assert failed: buffer must be supplied when transducer is\n"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null))))));
}
} else
{}
return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});
chan = function(buf_or_n,xform,ex_handler){
switch(arguments.length){
case 0:
return chan__0.call(this);
case 1:
return chan__1.call(this,buf_or_n);
case 2:
return chan__2.call(this,buf_or_n,xform);
case 3:
return chan__3.call(this,buf_or_n,xform,ex_handler);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
chan.cljs$core$IFn$_invoke$arity$0 = chan__0;
chan.cljs$core$IFn$_invoke$arity$1 = chan__1;
chan.cljs$core$IFn$_invoke$arity$2 = chan__2;
chan.cljs$core$IFn$_invoke$arity$3 = chan__3;
return chan;
})()
;
/**
* Returns a channel that will close after msecs
*/
cljs.core.async.timeout = (function timeout(msecs){return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
* takes a val from port. Must be called inside a (go ...) block. Will
* return nil if closed. Will park if nothing is available.
* Returns true unless port is already closed
*/
cljs.core.async._LT__BANG_ = (function _LT__BANG_(port){throw (new Error("<! used not in (go ...) block"));
});
/**
* Asynchronously takes a val from port, passing to fn1. Will pass nil
* if closed. If on-caller? (default true) is true, and value is
* immediately available, will call fn1 on calling thread.
* Returns nil.
*/
cljs.core.async.take_BANG_ = (function() {
var take_BANG_ = null;
var take_BANG___2 = (function (port,fn1){return take_BANG_.call(null,port,fn1,true);
});
var take_BANG___3 = (function (port,fn1,on_caller_QMARK_){var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));if(cljs.core.truth_(ret))
{var val_10758 = cljs.core.deref.call(null,ret);if(cljs.core.truth_(on_caller_QMARK_))
{fn1.call(null,val_10758);
} else
{cljs.core.async.impl.dispatch.run.call(null,((function (val_10758,ret){
return (function (){return fn1.call(null,val_10758);
});})(val_10758,ret))
);
}
} else
{}
return null;
});
take_BANG_ = function(port,fn1,on_caller_QMARK_){
switch(arguments.length){
case 2:
return take_BANG___2.call(this,port,fn1);
case 3:
return take_BANG___3.call(this,port,fn1,on_caller_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
take_BANG_.cljs$core$IFn$_invoke$arity$2 = take_BANG___2;
take_BANG_.cljs$core$IFn$_invoke$arity$3 = take_BANG___3;
return take_BANG_;
})()
;
cljs.core.async.nop = (function nop(_){return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
* puts a val into port. nil values are not allowed. Must be called
* inside a (go ...) block. Will park if no buffer space is available.
* Returns true unless port is already closed.
*/
cljs.core.async._GT__BANG_ = (function _GT__BANG_(port,val){throw (new Error(">! used not in (go ...) block"));
});
/**
* Asynchronously puts a val into port, calling fn0 (if supplied) when
* complete. nil values are not allowed. Will throw if closed. If
* on-caller? (default true) is true, and the put is immediately
* accepted, will call fn0 on calling thread.  Returns nil.
*/
cljs.core.async.put_BANG_ = (function() {
var put_BANG_ = null;
var put_BANG___2 = (function (port,val){var temp__4124__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);if(cljs.core.truth_(temp__4124__auto__))
{var ret = temp__4124__auto__;return cljs.core.deref.call(null,ret);
} else
{return true;
}
});
var put_BANG___3 = (function (port,val,fn1){return put_BANG_.call(null,port,val,fn1,true);
});
var put_BANG___4 = (function (port,val,fn1,on_caller_QMARK_){var temp__4124__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));if(cljs.core.truth_(temp__4124__auto__))
{var retb = temp__4124__auto__;var ret = cljs.core.deref.call(null,retb);if(cljs.core.truth_(on_caller_QMARK_))
{fn1.call(null,ret);
} else
{cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4124__auto__){
return (function (){return fn1.call(null,ret);
});})(ret,retb,temp__4124__auto__))
);
}
return ret;
} else
{return true;
}
});
put_BANG_ = function(port,val,fn1,on_caller_QMARK_){
switch(arguments.length){
case 2:
return put_BANG___2.call(this,port,val);
case 3:
return put_BANG___3.call(this,port,val,fn1);
case 4:
return put_BANG___4.call(this,port,val,fn1,on_caller_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
put_BANG_.cljs$core$IFn$_invoke$arity$2 = put_BANG___2;
put_BANG_.cljs$core$IFn$_invoke$arity$3 = put_BANG___3;
put_BANG_.cljs$core$IFn$_invoke$arity$4 = put_BANG___4;
return put_BANG_;
})()
;
cljs.core.async.close_BANG_ = (function close_BANG_(port){return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function random_array(n){var a = (new Array(n));var n__4518__auto___10759 = n;var x_10760 = (0);while(true){
if((x_10760 < n__4518__auto___10759))
{(a[x_10760] = (0));
{
var G__10761 = (x_10760 + (1));
x_10760 = G__10761;
continue;
}
} else
{}
break;
}
var i = (1);while(true){
if(cljs.core._EQ_.call(null,i,n))
{return a;
} else
{var j = cljs.core.rand_int.call(null,i);(a[i] = (a[j]));
(a[j] = i);
{
var G__10762 = (i + (1));
i = G__10762;
continue;
}
}
break;
}
});
cljs.core.async.alt_flag = (function alt_flag(){var flag = cljs.core.atom.call(null,true);if(typeof cljs.core.async.t10766 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t10766 = (function (flag,alt_flag,meta10767){
this.flag = flag;
this.alt_flag = alt_flag;
this.meta10767 = meta10767;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t10766.cljs$lang$type = true;
cljs.core.async.t10766.cljs$lang$ctorStr = "cljs.core.async/t10766";
cljs.core.async.t10766.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__4225__auto__,writer__4226__auto__,opt__4227__auto__){return cljs.core._write.call(null,writer__4226__auto__,"cljs.core.async/t10766");
});})(flag))
;
cljs.core.async.t10766.prototype.cljs$core$async$impl$protocols$Handler$ = true;
cljs.core.async.t10766.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){var self__ = this;
var ___$1 = this;return cljs.core.deref.call(null,self__.flag);
});})(flag))
;
cljs.core.async.t10766.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){var self__ = this;
var ___$1 = this;cljs.core.reset_BANG_.call(null,self__.flag,null);
return true;
});})(flag))
;
cljs.core.async.t10766.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_10768){var self__ = this;
var _10768__$1 = this;return self__.meta10767;
});})(flag))
;
cljs.core.async.t10766.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_10768,meta10767__$1){var self__ = this;
var _10768__$1 = this;return (new cljs.core.async.t10766(self__.flag,self__.alt_flag,meta10767__$1));
});})(flag))
;
cljs.core.async.__GT_t10766 = ((function (flag){
return (function __GT_t10766(flag__$1,alt_flag__$1,meta10767){return (new cljs.core.async.t10766(flag__$1,alt_flag__$1,meta10767));
});})(flag))
;
}
return (new cljs.core.async.t10766(flag,alt_flag,null));
});
cljs.core.async.alt_handler = (function alt_handler(flag,cb){if(typeof cljs.core.async.t10772 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t10772 = (function (cb,flag,alt_handler,meta10773){
this.cb = cb;
this.flag = flag;
this.alt_handler = alt_handler;
this.meta10773 = meta10773;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t10772.cljs$lang$type = true;
cljs.core.async.t10772.cljs$lang$ctorStr = "cljs.core.async/t10772";
cljs.core.async.t10772.cljs$lang$ctorPrWriter = (function (this__4225__auto__,writer__4226__auto__,opt__4227__auto__){return cljs.core._write.call(null,writer__4226__auto__,"cljs.core.async/t10772");
});
cljs.core.async.t10772.prototype.cljs$core$async$impl$protocols$Handler$ = true;
cljs.core.async.t10772.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});
cljs.core.async.t10772.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){var self__ = this;
var ___$1 = this;cljs.core.async.impl.protocols.commit.call(null,self__.flag);
return self__.cb;
});
cljs.core.async.t10772.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_10774){var self__ = this;
var _10774__$1 = this;return self__.meta10773;
});
cljs.core.async.t10772.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_10774,meta10773__$1){var self__ = this;
var _10774__$1 = this;return (new cljs.core.async.t10772(self__.cb,self__.flag,self__.alt_handler,meta10773__$1));
});
cljs.core.async.__GT_t10772 = (function __GT_t10772(cb__$1,flag__$1,alt_handler__$1,meta10773){return (new cljs.core.async.t10772(cb__$1,flag__$1,alt_handler__$1,meta10773));
});
}
return (new cljs.core.async.t10772(cb,flag,alt_handler,null));
});
/**
* returns derefable [val port] if immediate, nil if enqueued
*/
cljs.core.async.do_alts = (function do_alts(fret,ports,opts){var flag = cljs.core.async.alt_flag.call(null);var n = cljs.core.count.call(null,ports);var idxs = cljs.core.async.random_array.call(null,n);var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);var ret = (function (){var i = (0);while(true){
if((i < n))
{var idx = (cljs.core.truth_(priority)?i:(idxs[i]));var port = cljs.core.nth.call(null,ports,idx);var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__10775_SHARP_){return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__10775_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__10776_SHARP_){return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__10776_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));if(cljs.core.truth_(vbox))
{return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__3648__auto__ = wport;if(cljs.core.truth_(or__3648__auto__))
{return or__3648__auto__;
} else
{return port;
}
})()], null));
} else
{{
var G__10777 = (i + (1));
i = G__10777;
continue;
}
}
} else
{return null;
}
break;
}
})();var or__3648__auto__ = ret;if(cljs.core.truth_(or__3648__auto__))
{return or__3648__auto__;
} else
{if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328)))
{var temp__4126__auto__ = (function (){var and__3636__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);if(cljs.core.truth_(and__3636__auto__))
{return cljs.core.async.impl.protocols.commit.call(null,flag);
} else
{return and__3636__auto__;
}
})();if(cljs.core.truth_(temp__4126__auto__))
{var got = temp__4126__auto__;return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else
{return null;
}
} else
{return null;
}
}
});
/**
* Completes at most one of several channel operations. Must be called
* inside a (go ...) block. ports is a vector of channel endpoints,
* which can be either a channel to take from or a vector of
* [channel-to-put-to val-to-put], in any combination. Takes will be
* made as if by <!, and puts will be made as if by >!. Unless
* the :priority option is true, if more than one port operation is
* ready a non-deterministic choice will be made. If no operation is
* ready and a :default value is supplied, [default-val :default] will
* be returned, otherwise alts! will park until the first operation to
* become ready completes. Returns [val port] of the completed
* operation, where val is the value taken for takes, and a
* boolean (true unless already closed, as per put!) for puts.
* 
* opts are passed as :key val ... Supported options:
* 
* :default val - the value to use if none of the operations are immediately ready
* :priority true - (default nil) when true, the operations will be tried in order.
* 
* Note: there is no guarantee that the port exps or val exprs will be
* used, nor in what order should they be, so they should not be
* depended upon for side effects.
* @param {...*} var_args
*/
cljs.core.async.alts_BANG_ = (function() { 
var alts_BANG___delegate = function (ports,p__10778){var map__10780 = p__10778;var map__10780__$1 = ((cljs.core.seq_QMARK_.call(null,map__10780))?cljs.core.apply.call(null,cljs.core.hash_map,map__10780):map__10780);var opts = map__10780__$1;throw (new Error("alts! used not in (go ...) block"));
};
var alts_BANG_ = function (ports,var_args){
var p__10778 = null;if (arguments.length > 1) {
  p__10778 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return alts_BANG___delegate.call(this,ports,p__10778);};
alts_BANG_.cljs$lang$maxFixedArity = 1;
alts_BANG_.cljs$lang$applyTo = (function (arglist__10781){
var ports = cljs.core.first(arglist__10781);
var p__10778 = cljs.core.rest(arglist__10781);
return alts_BANG___delegate(ports,p__10778);
});
alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = alts_BANG___delegate;
return alts_BANG_;
})()
;
/**
* Takes elements from the from channel and supplies them to the to
* channel. By default, the to channel will be closed when the from
* channel closes, but can be determined by the close?  parameter. Will
* stop consuming the from channel if the to channel closes
*/
cljs.core.async.pipe = (function() {
var pipe = null;
var pipe__2 = (function (from,to){return pipe.call(null,from,to,true);
});
var pipe__3 = (function (from,to,close_QMARK_){var c__5915__auto___10876 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto___10876){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto___10876){
return (function (state_10852){var state_val_10853 = (state_10852[(1)]);if((state_val_10853 === (7)))
{var inst_10848 = (state_10852[(2)]);var state_10852__$1 = state_10852;var statearr_10854_10877 = state_10852__$1;(statearr_10854_10877[(2)] = inst_10848);
(statearr_10854_10877[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_10853 === (1)))
{var state_10852__$1 = state_10852;var statearr_10855_10878 = state_10852__$1;(statearr_10855_10878[(2)] = null);
(statearr_10855_10878[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_10853 === (4)))
{var inst_10831 = (state_10852[(7)]);var inst_10831__$1 = (state_10852[(2)]);var inst_10832 = (inst_10831__$1 == null);var state_10852__$1 = (function (){var statearr_10856 = state_10852;(statearr_10856[(7)] = inst_10831__$1);
return statearr_10856;
})();if(cljs.core.truth_(inst_10832))
{var statearr_10857_10879 = state_10852__$1;(statearr_10857_10879[(1)] = (5));
} else
{var statearr_10858_10880 = state_10852__$1;(statearr_10858_10880[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_10853 === (13)))
{var state_10852__$1 = state_10852;var statearr_10859_10881 = state_10852__$1;(statearr_10859_10881[(2)] = null);
(statearr_10859_10881[(1)] = (14));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_10853 === (6)))
{var inst_10831 = (state_10852[(7)]);var state_10852__$1 = state_10852;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10852__$1,(11),to,inst_10831);
} else
{if((state_val_10853 === (3)))
{var inst_10850 = (state_10852[(2)]);var state_10852__$1 = state_10852;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10852__$1,inst_10850);
} else
{if((state_val_10853 === (12)))
{var state_10852__$1 = state_10852;var statearr_10860_10882 = state_10852__$1;(statearr_10860_10882[(2)] = null);
(statearr_10860_10882[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_10853 === (2)))
{var state_10852__$1 = state_10852;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_10852__$1,(4),from);
} else
{if((state_val_10853 === (11)))
{var inst_10841 = (state_10852[(2)]);var state_10852__$1 = state_10852;if(cljs.core.truth_(inst_10841))
{var statearr_10861_10883 = state_10852__$1;(statearr_10861_10883[(1)] = (12));
} else
{var statearr_10862_10884 = state_10852__$1;(statearr_10862_10884[(1)] = (13));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_10853 === (9)))
{var state_10852__$1 = state_10852;var statearr_10863_10885 = state_10852__$1;(statearr_10863_10885[(2)] = null);
(statearr_10863_10885[(1)] = (10));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_10853 === (5)))
{var state_10852__$1 = state_10852;if(cljs.core.truth_(close_QMARK_))
{var statearr_10864_10886 = state_10852__$1;(statearr_10864_10886[(1)] = (8));
} else
{var statearr_10865_10887 = state_10852__$1;(statearr_10865_10887[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_10853 === (14)))
{var inst_10846 = (state_10852[(2)]);var state_10852__$1 = state_10852;var statearr_10866_10888 = state_10852__$1;(statearr_10866_10888[(2)] = inst_10846);
(statearr_10866_10888[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_10853 === (10)))
{var inst_10838 = (state_10852[(2)]);var state_10852__$1 = state_10852;var statearr_10867_10889 = state_10852__$1;(statearr_10867_10889[(2)] = inst_10838);
(statearr_10867_10889[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_10853 === (8)))
{var inst_10835 = cljs.core.async.close_BANG_.call(null,to);var state_10852__$1 = state_10852;var statearr_10868_10890 = state_10852__$1;(statearr_10868_10890[(2)] = inst_10835);
(statearr_10868_10890[(1)] = (10));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__5915__auto___10876))
;return ((function (switch__5900__auto__,c__5915__auto___10876){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_10872 = [null,null,null,null,null,null,null,null];(statearr_10872[(0)] = state_machine__5901__auto__);
(statearr_10872[(1)] = (1));
return statearr_10872;
});
var state_machine__5901__auto____1 = (function (state_10852){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_10852);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e10873){if((e10873 instanceof Object))
{var ex__5904__auto__ = e10873;var statearr_10874_10891 = state_10852;(statearr_10874_10891[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10852);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e10873;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__10892 = state_10852;
state_10852 = G__10892;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_10852){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_10852);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto___10876))
})();var state__5917__auto__ = (function (){var statearr_10875 = f__5916__auto__.call(null);(statearr_10875[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto___10876);
return statearr_10875;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto___10876))
);
return to;
});
pipe = function(from,to,close_QMARK_){
switch(arguments.length){
case 2:
return pipe__2.call(this,from,to);
case 3:
return pipe__3.call(this,from,to,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pipe.cljs$core$IFn$_invoke$arity$2 = pipe__2;
pipe.cljs$core$IFn$_invoke$arity$3 = pipe__3;
return pipe;
})()
;
cljs.core.async.pipeline_STAR_ = (function pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){if((n > (0)))
{} else
{throw (new Error(("Assert failed: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)))))));
}
var jobs = cljs.core.async.chan.call(null,n);var results = cljs.core.async.chan.call(null,n);var process = ((function (jobs,results){
return (function (p__11076){var vec__11077 = p__11076;var v = cljs.core.nth.call(null,vec__11077,(0),null);var p = cljs.core.nth.call(null,vec__11077,(1),null);var job = vec__11077;if((job == null))
{cljs.core.async.close_BANG_.call(null,results);
return null;
} else
{var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);var c__5915__auto___11259 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto___11259,res,vec__11077,v,p,job,jobs,results){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto___11259,res,vec__11077,v,p,job,jobs,results){
return (function (state_11082){var state_val_11083 = (state_11082[(1)]);if((state_val_11083 === (2)))
{var inst_11079 = (state_11082[(2)]);var inst_11080 = cljs.core.async.close_BANG_.call(null,res);var state_11082__$1 = (function (){var statearr_11084 = state_11082;(statearr_11084[(7)] = inst_11079);
return statearr_11084;
})();return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11082__$1,inst_11080);
} else
{if((state_val_11083 === (1)))
{var state_11082__$1 = state_11082;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11082__$1,(2),res,v);
} else
{return null;
}
}
});})(c__5915__auto___11259,res,vec__11077,v,p,job,jobs,results))
;return ((function (switch__5900__auto__,c__5915__auto___11259,res,vec__11077,v,p,job,jobs,results){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_11088 = [null,null,null,null,null,null,null,null];(statearr_11088[(0)] = state_machine__5901__auto__);
(statearr_11088[(1)] = (1));
return statearr_11088;
});
var state_machine__5901__auto____1 = (function (state_11082){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_11082);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e11089){if((e11089 instanceof Object))
{var ex__5904__auto__ = e11089;var statearr_11090_11260 = state_11082;(statearr_11090_11260[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11082);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e11089;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__11261 = state_11082;
state_11082 = G__11261;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_11082){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_11082);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto___11259,res,vec__11077,v,p,job,jobs,results))
})();var state__5917__auto__ = (function (){var statearr_11091 = f__5916__auto__.call(null);(statearr_11091[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto___11259);
return statearr_11091;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto___11259,res,vec__11077,v,p,job,jobs,results))
);
cljs.core.async.put_BANG_.call(null,p,res);
return true;
}
});})(jobs,results))
;var async = ((function (jobs,results,process){
return (function (p__11092){var vec__11093 = p__11092;var v = cljs.core.nth.call(null,vec__11093,(0),null);var p = cljs.core.nth.call(null,vec__11093,(1),null);var job = vec__11093;if((job == null))
{cljs.core.async.close_BANG_.call(null,results);
return null;
} else
{var res = cljs.core.async.chan.call(null,(1));xf.call(null,v,res);
cljs.core.async.put_BANG_.call(null,p,res);
return true;
}
});})(jobs,results,process))
;var n__4518__auto___11262 = n;var __11263 = (0);while(true){
if((__11263 < n__4518__auto___11262))
{var G__11094_11264 = (((type instanceof cljs.core.Keyword))?type.fqn:null);switch (G__11094_11264) {
case "async":
var c__5915__auto___11266 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (__11263,c__5915__auto___11266,G__11094_11264,n__4518__auto___11262,jobs,results,process,async){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (__11263,c__5915__auto___11266,G__11094_11264,n__4518__auto___11262,jobs,results,process,async){
return (function (state_11107){var state_val_11108 = (state_11107[(1)]);if((state_val_11108 === (7)))
{var inst_11103 = (state_11107[(2)]);var state_11107__$1 = state_11107;var statearr_11109_11267 = state_11107__$1;(statearr_11109_11267[(2)] = inst_11103);
(statearr_11109_11267[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11108 === (6)))
{var state_11107__$1 = state_11107;var statearr_11110_11268 = state_11107__$1;(statearr_11110_11268[(2)] = null);
(statearr_11110_11268[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11108 === (5)))
{var state_11107__$1 = state_11107;var statearr_11111_11269 = state_11107__$1;(statearr_11111_11269[(2)] = null);
(statearr_11111_11269[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11108 === (4)))
{var inst_11097 = (state_11107[(2)]);var inst_11098 = async.call(null,inst_11097);var state_11107__$1 = state_11107;if(cljs.core.truth_(inst_11098))
{var statearr_11112_11270 = state_11107__$1;(statearr_11112_11270[(1)] = (5));
} else
{var statearr_11113_11271 = state_11107__$1;(statearr_11113_11271[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11108 === (3)))
{var inst_11105 = (state_11107[(2)]);var state_11107__$1 = state_11107;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11107__$1,inst_11105);
} else
{if((state_val_11108 === (2)))
{var state_11107__$1 = state_11107;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11107__$1,(4),jobs);
} else
{if((state_val_11108 === (1)))
{var state_11107__$1 = state_11107;var statearr_11114_11272 = state_11107__$1;(statearr_11114_11272[(2)] = null);
(statearr_11114_11272[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
});})(__11263,c__5915__auto___11266,G__11094_11264,n__4518__auto___11262,jobs,results,process,async))
;return ((function (__11263,switch__5900__auto__,c__5915__auto___11266,G__11094_11264,n__4518__auto___11262,jobs,results,process,async){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_11118 = [null,null,null,null,null,null,null];(statearr_11118[(0)] = state_machine__5901__auto__);
(statearr_11118[(1)] = (1));
return statearr_11118;
});
var state_machine__5901__auto____1 = (function (state_11107){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_11107);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e11119){if((e11119 instanceof Object))
{var ex__5904__auto__ = e11119;var statearr_11120_11273 = state_11107;(statearr_11120_11273[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11107);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e11119;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__11274 = state_11107;
state_11107 = G__11274;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_11107){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_11107);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(__11263,switch__5900__auto__,c__5915__auto___11266,G__11094_11264,n__4518__auto___11262,jobs,results,process,async))
})();var state__5917__auto__ = (function (){var statearr_11121 = f__5916__auto__.call(null);(statearr_11121[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto___11266);
return statearr_11121;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(__11263,c__5915__auto___11266,G__11094_11264,n__4518__auto___11262,jobs,results,process,async))
);

break;
case "compute":
var c__5915__auto___11275 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (__11263,c__5915__auto___11275,G__11094_11264,n__4518__auto___11262,jobs,results,process,async){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (__11263,c__5915__auto___11275,G__11094_11264,n__4518__auto___11262,jobs,results,process,async){
return (function (state_11134){var state_val_11135 = (state_11134[(1)]);if((state_val_11135 === (7)))
{var inst_11130 = (state_11134[(2)]);var state_11134__$1 = state_11134;var statearr_11136_11276 = state_11134__$1;(statearr_11136_11276[(2)] = inst_11130);
(statearr_11136_11276[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11135 === (6)))
{var state_11134__$1 = state_11134;var statearr_11137_11277 = state_11134__$1;(statearr_11137_11277[(2)] = null);
(statearr_11137_11277[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11135 === (5)))
{var state_11134__$1 = state_11134;var statearr_11138_11278 = state_11134__$1;(statearr_11138_11278[(2)] = null);
(statearr_11138_11278[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11135 === (4)))
{var inst_11124 = (state_11134[(2)]);var inst_11125 = process.call(null,inst_11124);var state_11134__$1 = state_11134;if(cljs.core.truth_(inst_11125))
{var statearr_11139_11279 = state_11134__$1;(statearr_11139_11279[(1)] = (5));
} else
{var statearr_11140_11280 = state_11134__$1;(statearr_11140_11280[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11135 === (3)))
{var inst_11132 = (state_11134[(2)]);var state_11134__$1 = state_11134;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11134__$1,inst_11132);
} else
{if((state_val_11135 === (2)))
{var state_11134__$1 = state_11134;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11134__$1,(4),jobs);
} else
{if((state_val_11135 === (1)))
{var state_11134__$1 = state_11134;var statearr_11141_11281 = state_11134__$1;(statearr_11141_11281[(2)] = null);
(statearr_11141_11281[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
});})(__11263,c__5915__auto___11275,G__11094_11264,n__4518__auto___11262,jobs,results,process,async))
;return ((function (__11263,switch__5900__auto__,c__5915__auto___11275,G__11094_11264,n__4518__auto___11262,jobs,results,process,async){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_11145 = [null,null,null,null,null,null,null];(statearr_11145[(0)] = state_machine__5901__auto__);
(statearr_11145[(1)] = (1));
return statearr_11145;
});
var state_machine__5901__auto____1 = (function (state_11134){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_11134);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e11146){if((e11146 instanceof Object))
{var ex__5904__auto__ = e11146;var statearr_11147_11282 = state_11134;(statearr_11147_11282[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11134);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e11146;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__11283 = state_11134;
state_11134 = G__11283;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_11134){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_11134);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(__11263,switch__5900__auto__,c__5915__auto___11275,G__11094_11264,n__4518__auto___11262,jobs,results,process,async))
})();var state__5917__auto__ = (function (){var statearr_11148 = f__5916__auto__.call(null);(statearr_11148[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto___11275);
return statearr_11148;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(__11263,c__5915__auto___11275,G__11094_11264,n__4518__auto___11262,jobs,results,process,async))
);

break;
default:
throw (new Error(("No matching clause: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(type))));

}
{
var G__11284 = (__11263 + (1));
__11263 = G__11284;
continue;
}
} else
{}
break;
}
var c__5915__auto___11285 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto___11285,jobs,results,process,async){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto___11285,jobs,results,process,async){
return (function (state_11170){var state_val_11171 = (state_11170[(1)]);if((state_val_11171 === (9)))
{var inst_11163 = (state_11170[(2)]);var state_11170__$1 = (function (){var statearr_11172 = state_11170;(statearr_11172[(7)] = inst_11163);
return statearr_11172;
})();var statearr_11173_11286 = state_11170__$1;(statearr_11173_11286[(2)] = null);
(statearr_11173_11286[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11171 === (8)))
{var inst_11156 = (state_11170[(8)]);var inst_11161 = (state_11170[(2)]);var state_11170__$1 = (function (){var statearr_11174 = state_11170;(statearr_11174[(9)] = inst_11161);
return statearr_11174;
})();return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11170__$1,(9),results,inst_11156);
} else
{if((state_val_11171 === (7)))
{var inst_11166 = (state_11170[(2)]);var state_11170__$1 = state_11170;var statearr_11175_11287 = state_11170__$1;(statearr_11175_11287[(2)] = inst_11166);
(statearr_11175_11287[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11171 === (6)))
{var inst_11151 = (state_11170[(10)]);var inst_11156 = (state_11170[(8)]);var inst_11156__$1 = cljs.core.async.chan.call(null,(1));var inst_11157 = cljs.core.PersistentVector.EMPTY_NODE;var inst_11158 = [inst_11151,inst_11156__$1];var inst_11159 = (new cljs.core.PersistentVector(null,2,(5),inst_11157,inst_11158,null));var state_11170__$1 = (function (){var statearr_11176 = state_11170;(statearr_11176[(8)] = inst_11156__$1);
return statearr_11176;
})();return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11170__$1,(8),jobs,inst_11159);
} else
{if((state_val_11171 === (5)))
{var inst_11154 = cljs.core.async.close_BANG_.call(null,jobs);var state_11170__$1 = state_11170;var statearr_11177_11288 = state_11170__$1;(statearr_11177_11288[(2)] = inst_11154);
(statearr_11177_11288[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11171 === (4)))
{var inst_11151 = (state_11170[(10)]);var inst_11151__$1 = (state_11170[(2)]);var inst_11152 = (inst_11151__$1 == null);var state_11170__$1 = (function (){var statearr_11178 = state_11170;(statearr_11178[(10)] = inst_11151__$1);
return statearr_11178;
})();if(cljs.core.truth_(inst_11152))
{var statearr_11179_11289 = state_11170__$1;(statearr_11179_11289[(1)] = (5));
} else
{var statearr_11180_11290 = state_11170__$1;(statearr_11180_11290[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11171 === (3)))
{var inst_11168 = (state_11170[(2)]);var state_11170__$1 = state_11170;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11170__$1,inst_11168);
} else
{if((state_val_11171 === (2)))
{var state_11170__$1 = state_11170;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11170__$1,(4),from);
} else
{if((state_val_11171 === (1)))
{var state_11170__$1 = state_11170;var statearr_11181_11291 = state_11170__$1;(statearr_11181_11291[(2)] = null);
(statearr_11181_11291[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
});})(c__5915__auto___11285,jobs,results,process,async))
;return ((function (switch__5900__auto__,c__5915__auto___11285,jobs,results,process,async){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_11185 = [null,null,null,null,null,null,null,null,null,null,null];(statearr_11185[(0)] = state_machine__5901__auto__);
(statearr_11185[(1)] = (1));
return statearr_11185;
});
var state_machine__5901__auto____1 = (function (state_11170){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_11170);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e11186){if((e11186 instanceof Object))
{var ex__5904__auto__ = e11186;var statearr_11187_11292 = state_11170;(statearr_11187_11292[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11170);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e11186;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__11293 = state_11170;
state_11170 = G__11293;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_11170){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_11170);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto___11285,jobs,results,process,async))
})();var state__5917__auto__ = (function (){var statearr_11188 = f__5916__auto__.call(null);(statearr_11188[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto___11285);
return statearr_11188;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto___11285,jobs,results,process,async))
);
var c__5915__auto__ = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto__,jobs,results,process,async){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto__,jobs,results,process,async){
return (function (state_11226){var state_val_11227 = (state_11226[(1)]);if((state_val_11227 === (7)))
{var inst_11222 = (state_11226[(2)]);var state_11226__$1 = state_11226;var statearr_11228_11294 = state_11226__$1;(statearr_11228_11294[(2)] = inst_11222);
(statearr_11228_11294[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11227 === (20)))
{var state_11226__$1 = state_11226;var statearr_11229_11295 = state_11226__$1;(statearr_11229_11295[(2)] = null);
(statearr_11229_11295[(1)] = (21));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11227 === (1)))
{var state_11226__$1 = state_11226;var statearr_11230_11296 = state_11226__$1;(statearr_11230_11296[(2)] = null);
(statearr_11230_11296[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11227 === (4)))
{var inst_11191 = (state_11226[(7)]);var inst_11191__$1 = (state_11226[(2)]);var inst_11192 = (inst_11191__$1 == null);var state_11226__$1 = (function (){var statearr_11231 = state_11226;(statearr_11231[(7)] = inst_11191__$1);
return statearr_11231;
})();if(cljs.core.truth_(inst_11192))
{var statearr_11232_11297 = state_11226__$1;(statearr_11232_11297[(1)] = (5));
} else
{var statearr_11233_11298 = state_11226__$1;(statearr_11233_11298[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11227 === (15)))
{var inst_11204 = (state_11226[(8)]);var state_11226__$1 = state_11226;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11226__$1,(18),to,inst_11204);
} else
{if((state_val_11227 === (21)))
{var inst_11217 = (state_11226[(2)]);var state_11226__$1 = state_11226;var statearr_11234_11299 = state_11226__$1;(statearr_11234_11299[(2)] = inst_11217);
(statearr_11234_11299[(1)] = (13));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11227 === (13)))
{var inst_11219 = (state_11226[(2)]);var state_11226__$1 = (function (){var statearr_11235 = state_11226;(statearr_11235[(9)] = inst_11219);
return statearr_11235;
})();var statearr_11236_11300 = state_11226__$1;(statearr_11236_11300[(2)] = null);
(statearr_11236_11300[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11227 === (6)))
{var inst_11191 = (state_11226[(7)]);var state_11226__$1 = state_11226;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11226__$1,(11),inst_11191);
} else
{if((state_val_11227 === (17)))
{var inst_11212 = (state_11226[(2)]);var state_11226__$1 = state_11226;if(cljs.core.truth_(inst_11212))
{var statearr_11237_11301 = state_11226__$1;(statearr_11237_11301[(1)] = (19));
} else
{var statearr_11238_11302 = state_11226__$1;(statearr_11238_11302[(1)] = (20));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11227 === (3)))
{var inst_11224 = (state_11226[(2)]);var state_11226__$1 = state_11226;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11226__$1,inst_11224);
} else
{if((state_val_11227 === (12)))
{var inst_11201 = (state_11226[(10)]);var state_11226__$1 = state_11226;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11226__$1,(14),inst_11201);
} else
{if((state_val_11227 === (2)))
{var state_11226__$1 = state_11226;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11226__$1,(4),results);
} else
{if((state_val_11227 === (19)))
{var state_11226__$1 = state_11226;var statearr_11239_11303 = state_11226__$1;(statearr_11239_11303[(2)] = null);
(statearr_11239_11303[(1)] = (12));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11227 === (11)))
{var inst_11201 = (state_11226[(2)]);var state_11226__$1 = (function (){var statearr_11240 = state_11226;(statearr_11240[(10)] = inst_11201);
return statearr_11240;
})();var statearr_11241_11304 = state_11226__$1;(statearr_11241_11304[(2)] = null);
(statearr_11241_11304[(1)] = (12));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11227 === (9)))
{var state_11226__$1 = state_11226;var statearr_11242_11305 = state_11226__$1;(statearr_11242_11305[(2)] = null);
(statearr_11242_11305[(1)] = (10));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11227 === (5)))
{var state_11226__$1 = state_11226;if(cljs.core.truth_(close_QMARK_))
{var statearr_11243_11306 = state_11226__$1;(statearr_11243_11306[(1)] = (8));
} else
{var statearr_11244_11307 = state_11226__$1;(statearr_11244_11307[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11227 === (14)))
{var inst_11206 = (state_11226[(11)]);var inst_11204 = (state_11226[(8)]);var inst_11204__$1 = (state_11226[(2)]);var inst_11205 = (inst_11204__$1 == null);var inst_11206__$1 = cljs.core.not.call(null,inst_11205);var state_11226__$1 = (function (){var statearr_11245 = state_11226;(statearr_11245[(11)] = inst_11206__$1);
(statearr_11245[(8)] = inst_11204__$1);
return statearr_11245;
})();if(inst_11206__$1)
{var statearr_11246_11308 = state_11226__$1;(statearr_11246_11308[(1)] = (15));
} else
{var statearr_11247_11309 = state_11226__$1;(statearr_11247_11309[(1)] = (16));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11227 === (16)))
{var inst_11206 = (state_11226[(11)]);var state_11226__$1 = state_11226;var statearr_11248_11310 = state_11226__$1;(statearr_11248_11310[(2)] = inst_11206);
(statearr_11248_11310[(1)] = (17));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11227 === (10)))
{var inst_11198 = (state_11226[(2)]);var state_11226__$1 = state_11226;var statearr_11249_11311 = state_11226__$1;(statearr_11249_11311[(2)] = inst_11198);
(statearr_11249_11311[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11227 === (18)))
{var inst_11209 = (state_11226[(2)]);var state_11226__$1 = state_11226;var statearr_11250_11312 = state_11226__$1;(statearr_11250_11312[(2)] = inst_11209);
(statearr_11250_11312[(1)] = (17));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11227 === (8)))
{var inst_11195 = cljs.core.async.close_BANG_.call(null,to);var state_11226__$1 = state_11226;var statearr_11251_11313 = state_11226__$1;(statearr_11251_11313[(2)] = inst_11195);
(statearr_11251_11313[(1)] = (10));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__5915__auto__,jobs,results,process,async))
;return ((function (switch__5900__auto__,c__5915__auto__,jobs,results,process,async){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_11255 = [null,null,null,null,null,null,null,null,null,null,null,null];(statearr_11255[(0)] = state_machine__5901__auto__);
(statearr_11255[(1)] = (1));
return statearr_11255;
});
var state_machine__5901__auto____1 = (function (state_11226){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_11226);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e11256){if((e11256 instanceof Object))
{var ex__5904__auto__ = e11256;var statearr_11257_11314 = state_11226;(statearr_11257_11314[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11226);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e11256;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__11315 = state_11226;
state_11226 = G__11315;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_11226){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_11226);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto__,jobs,results,process,async))
})();var state__5917__auto__ = (function (){var statearr_11258 = f__5916__auto__.call(null);(statearr_11258[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto__);
return statearr_11258;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto__,jobs,results,process,async))
);
return c__5915__auto__;
});
/**
* Takes elements from the from channel and supplies them to the to
* channel, subject to the async function af, with parallelism n. af
* must be a function of two arguments, the first an input value and
* the second a channel on which to place the result(s). af must close!
* the channel before returning.  The presumption is that af will
* return immediately, having launched some asynchronous operation
* whose completion/callback will manipulate the result channel. Outputs
* will be returned in order relative to  the inputs. By default, the to
* channel will be closed when the from channel closes, but can be
* determined by the close?  parameter. Will stop consuming the from
* channel if the to channel closes.
*/
cljs.core.async.pipeline_async = (function() {
var pipeline_async = null;
var pipeline_async__4 = (function (n,to,af,from){return pipeline_async.call(null,n,to,af,from,true);
});
var pipeline_async__5 = (function (n,to,af,from,close_QMARK_){return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});
pipeline_async = function(n,to,af,from,close_QMARK_){
switch(arguments.length){
case 4:
return pipeline_async__4.call(this,n,to,af,from);
case 5:
return pipeline_async__5.call(this,n,to,af,from,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pipeline_async.cljs$core$IFn$_invoke$arity$4 = pipeline_async__4;
pipeline_async.cljs$core$IFn$_invoke$arity$5 = pipeline_async__5;
return pipeline_async;
})()
;
/**
* Takes elements from the from channel and supplies them to the to
* channel, subject to the transducer xf, with parallelism n. Because
* it is parallel, the transducer will be applied independently to each
* element, not across elements, and may produce zero or more outputs
* per input.  Outputs will be returned in order relative to the
* inputs. By default, the to channel will be closed when the from
* channel closes, but can be determined by the close?  parameter. Will
* stop consuming the from channel if the to channel closes.
* 
* Note this is supplied for API compatibility with the Clojure version.
* Values of N > 1 will not result in actual concurrency in a
* single-threaded runtime.
*/
cljs.core.async.pipeline = (function() {
var pipeline = null;
var pipeline__4 = (function (n,to,xf,from){return pipeline.call(null,n,to,xf,from,true);
});
var pipeline__5 = (function (n,to,xf,from,close_QMARK_){return pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});
var pipeline__6 = (function (n,to,xf,from,close_QMARK_,ex_handler){return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});
pipeline = function(n,to,xf,from,close_QMARK_,ex_handler){
switch(arguments.length){
case 4:
return pipeline__4.call(this,n,to,xf,from);
case 5:
return pipeline__5.call(this,n,to,xf,from,close_QMARK_);
case 6:
return pipeline__6.call(this,n,to,xf,from,close_QMARK_,ex_handler);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pipeline.cljs$core$IFn$_invoke$arity$4 = pipeline__4;
pipeline.cljs$core$IFn$_invoke$arity$5 = pipeline__5;
pipeline.cljs$core$IFn$_invoke$arity$6 = pipeline__6;
return pipeline;
})()
;
/**
* Takes a predicate and a source channel and returns a vector of two
* channels, the first of which will contain the values for which the
* predicate returned true, the second those for which it returned
* false.
* 
* The out channels will be unbuffered by default, or two buf-or-ns can
* be supplied. The channels will close after the source channel has
* closed.
*/
cljs.core.async.split = (function() {
var split = null;
var split__2 = (function (p,ch){return split.call(null,p,ch,null,null);
});
var split__4 = (function (p,ch,t_buf_or_n,f_buf_or_n){var tc = cljs.core.async.chan.call(null,t_buf_or_n);var fc = cljs.core.async.chan.call(null,f_buf_or_n);var c__5915__auto___11416 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto___11416,tc,fc){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto___11416,tc,fc){
return (function (state_11391){var state_val_11392 = (state_11391[(1)]);if((state_val_11392 === (7)))
{var inst_11387 = (state_11391[(2)]);var state_11391__$1 = state_11391;var statearr_11393_11417 = state_11391__$1;(statearr_11393_11417[(2)] = inst_11387);
(statearr_11393_11417[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11392 === (1)))
{var state_11391__$1 = state_11391;var statearr_11394_11418 = state_11391__$1;(statearr_11394_11418[(2)] = null);
(statearr_11394_11418[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11392 === (4)))
{var inst_11368 = (state_11391[(7)]);var inst_11368__$1 = (state_11391[(2)]);var inst_11369 = (inst_11368__$1 == null);var state_11391__$1 = (function (){var statearr_11395 = state_11391;(statearr_11395[(7)] = inst_11368__$1);
return statearr_11395;
})();if(cljs.core.truth_(inst_11369))
{var statearr_11396_11419 = state_11391__$1;(statearr_11396_11419[(1)] = (5));
} else
{var statearr_11397_11420 = state_11391__$1;(statearr_11397_11420[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11392 === (13)))
{var state_11391__$1 = state_11391;var statearr_11398_11421 = state_11391__$1;(statearr_11398_11421[(2)] = null);
(statearr_11398_11421[(1)] = (14));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11392 === (6)))
{var inst_11368 = (state_11391[(7)]);var inst_11374 = p.call(null,inst_11368);var state_11391__$1 = state_11391;if(cljs.core.truth_(inst_11374))
{var statearr_11399_11422 = state_11391__$1;(statearr_11399_11422[(1)] = (9));
} else
{var statearr_11400_11423 = state_11391__$1;(statearr_11400_11423[(1)] = (10));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11392 === (3)))
{var inst_11389 = (state_11391[(2)]);var state_11391__$1 = state_11391;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11391__$1,inst_11389);
} else
{if((state_val_11392 === (12)))
{var state_11391__$1 = state_11391;var statearr_11401_11424 = state_11391__$1;(statearr_11401_11424[(2)] = null);
(statearr_11401_11424[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11392 === (2)))
{var state_11391__$1 = state_11391;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11391__$1,(4),ch);
} else
{if((state_val_11392 === (11)))
{var inst_11368 = (state_11391[(7)]);var inst_11378 = (state_11391[(2)]);var state_11391__$1 = state_11391;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11391__$1,(8),inst_11378,inst_11368);
} else
{if((state_val_11392 === (9)))
{var state_11391__$1 = state_11391;var statearr_11402_11425 = state_11391__$1;(statearr_11402_11425[(2)] = tc);
(statearr_11402_11425[(1)] = (11));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11392 === (5)))
{var inst_11371 = cljs.core.async.close_BANG_.call(null,tc);var inst_11372 = cljs.core.async.close_BANG_.call(null,fc);var state_11391__$1 = (function (){var statearr_11403 = state_11391;(statearr_11403[(8)] = inst_11371);
return statearr_11403;
})();var statearr_11404_11426 = state_11391__$1;(statearr_11404_11426[(2)] = inst_11372);
(statearr_11404_11426[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11392 === (14)))
{var inst_11385 = (state_11391[(2)]);var state_11391__$1 = state_11391;var statearr_11405_11427 = state_11391__$1;(statearr_11405_11427[(2)] = inst_11385);
(statearr_11405_11427[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11392 === (10)))
{var state_11391__$1 = state_11391;var statearr_11406_11428 = state_11391__$1;(statearr_11406_11428[(2)] = fc);
(statearr_11406_11428[(1)] = (11));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11392 === (8)))
{var inst_11380 = (state_11391[(2)]);var state_11391__$1 = state_11391;if(cljs.core.truth_(inst_11380))
{var statearr_11407_11429 = state_11391__$1;(statearr_11407_11429[(1)] = (12));
} else
{var statearr_11408_11430 = state_11391__$1;(statearr_11408_11430[(1)] = (13));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__5915__auto___11416,tc,fc))
;return ((function (switch__5900__auto__,c__5915__auto___11416,tc,fc){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_11412 = [null,null,null,null,null,null,null,null,null];(statearr_11412[(0)] = state_machine__5901__auto__);
(statearr_11412[(1)] = (1));
return statearr_11412;
});
var state_machine__5901__auto____1 = (function (state_11391){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_11391);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e11413){if((e11413 instanceof Object))
{var ex__5904__auto__ = e11413;var statearr_11414_11431 = state_11391;(statearr_11414_11431[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11391);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e11413;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__11432 = state_11391;
state_11391 = G__11432;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_11391){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_11391);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto___11416,tc,fc))
})();var state__5917__auto__ = (function (){var statearr_11415 = f__5916__auto__.call(null);(statearr_11415[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto___11416);
return statearr_11415;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto___11416,tc,fc))
);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});
split = function(p,ch,t_buf_or_n,f_buf_or_n){
switch(arguments.length){
case 2:
return split__2.call(this,p,ch);
case 4:
return split__4.call(this,p,ch,t_buf_or_n,f_buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
split.cljs$core$IFn$_invoke$arity$2 = split__2;
split.cljs$core$IFn$_invoke$arity$4 = split__4;
return split;
})()
;
/**
* f should be a function of 2 arguments. Returns a channel containing
* the single result of applying f to init and the first item from the
* channel, then applying f to that result and the 2nd item, etc. If
* the channel closes without yielding items, returns init and f is not
* called. ch must close before reduce produces a result.
*/
cljs.core.async.reduce = (function reduce(f,init,ch){var c__5915__auto__ = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto__){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto__){
return (function (state_11479){var state_val_11480 = (state_11479[(1)]);if((state_val_11480 === (7)))
{var inst_11475 = (state_11479[(2)]);var state_11479__$1 = state_11479;var statearr_11481_11497 = state_11479__$1;(statearr_11481_11497[(2)] = inst_11475);
(statearr_11481_11497[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11480 === (6)))
{var inst_11465 = (state_11479[(7)]);var inst_11468 = (state_11479[(8)]);var inst_11472 = f.call(null,inst_11465,inst_11468);var inst_11465__$1 = inst_11472;var state_11479__$1 = (function (){var statearr_11482 = state_11479;(statearr_11482[(7)] = inst_11465__$1);
return statearr_11482;
})();var statearr_11483_11498 = state_11479__$1;(statearr_11483_11498[(2)] = null);
(statearr_11483_11498[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11480 === (5)))
{var inst_11465 = (state_11479[(7)]);var state_11479__$1 = state_11479;var statearr_11484_11499 = state_11479__$1;(statearr_11484_11499[(2)] = inst_11465);
(statearr_11484_11499[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11480 === (4)))
{var inst_11468 = (state_11479[(8)]);var inst_11468__$1 = (state_11479[(2)]);var inst_11469 = (inst_11468__$1 == null);var state_11479__$1 = (function (){var statearr_11485 = state_11479;(statearr_11485[(8)] = inst_11468__$1);
return statearr_11485;
})();if(cljs.core.truth_(inst_11469))
{var statearr_11486_11500 = state_11479__$1;(statearr_11486_11500[(1)] = (5));
} else
{var statearr_11487_11501 = state_11479__$1;(statearr_11487_11501[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11480 === (3)))
{var inst_11477 = (state_11479[(2)]);var state_11479__$1 = state_11479;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11479__$1,inst_11477);
} else
{if((state_val_11480 === (2)))
{var state_11479__$1 = state_11479;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11479__$1,(4),ch);
} else
{if((state_val_11480 === (1)))
{var inst_11465 = init;var state_11479__$1 = (function (){var statearr_11488 = state_11479;(statearr_11488[(7)] = inst_11465);
return statearr_11488;
})();var statearr_11489_11502 = state_11479__$1;(statearr_11489_11502[(2)] = null);
(statearr_11489_11502[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
});})(c__5915__auto__))
;return ((function (switch__5900__auto__,c__5915__auto__){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_11493 = [null,null,null,null,null,null,null,null,null];(statearr_11493[(0)] = state_machine__5901__auto__);
(statearr_11493[(1)] = (1));
return statearr_11493;
});
var state_machine__5901__auto____1 = (function (state_11479){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_11479);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e11494){if((e11494 instanceof Object))
{var ex__5904__auto__ = e11494;var statearr_11495_11503 = state_11479;(statearr_11495_11503[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11479);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e11494;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__11504 = state_11479;
state_11479 = G__11504;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_11479){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_11479);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto__))
})();var state__5917__auto__ = (function (){var statearr_11496 = f__5916__auto__.call(null);(statearr_11496[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto__);
return statearr_11496;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto__))
);
return c__5915__auto__;
});
/**
* Puts the contents of coll into the supplied channel.
* 
* By default the channel will be closed after the items are copied,
* but can be determined by the close? parameter.
* 
* Returns a channel which will close after the items are copied.
*/
cljs.core.async.onto_chan = (function() {
var onto_chan = null;
var onto_chan__2 = (function (ch,coll){return onto_chan.call(null,ch,coll,true);
});
var onto_chan__3 = (function (ch,coll,close_QMARK_){var c__5915__auto__ = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto__){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto__){
return (function (state_11578){var state_val_11579 = (state_11578[(1)]);if((state_val_11579 === (7)))
{var inst_11560 = (state_11578[(2)]);var state_11578__$1 = state_11578;var statearr_11580_11603 = state_11578__$1;(statearr_11580_11603[(2)] = inst_11560);
(statearr_11580_11603[(1)] = (6));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11579 === (1)))
{var inst_11554 = cljs.core.seq.call(null,coll);var inst_11555 = inst_11554;var state_11578__$1 = (function (){var statearr_11581 = state_11578;(statearr_11581[(7)] = inst_11555);
return statearr_11581;
})();var statearr_11582_11604 = state_11578__$1;(statearr_11582_11604[(2)] = null);
(statearr_11582_11604[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11579 === (4)))
{var inst_11555 = (state_11578[(7)]);var inst_11558 = cljs.core.first.call(null,inst_11555);var state_11578__$1 = state_11578;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11578__$1,(7),ch,inst_11558);
} else
{if((state_val_11579 === (13)))
{var inst_11572 = (state_11578[(2)]);var state_11578__$1 = state_11578;var statearr_11583_11605 = state_11578__$1;(statearr_11583_11605[(2)] = inst_11572);
(statearr_11583_11605[(1)] = (10));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11579 === (6)))
{var inst_11563 = (state_11578[(2)]);var state_11578__$1 = state_11578;if(cljs.core.truth_(inst_11563))
{var statearr_11584_11606 = state_11578__$1;(statearr_11584_11606[(1)] = (8));
} else
{var statearr_11585_11607 = state_11578__$1;(statearr_11585_11607[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11579 === (3)))
{var inst_11576 = (state_11578[(2)]);var state_11578__$1 = state_11578;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11578__$1,inst_11576);
} else
{if((state_val_11579 === (12)))
{var state_11578__$1 = state_11578;var statearr_11586_11608 = state_11578__$1;(statearr_11586_11608[(2)] = null);
(statearr_11586_11608[(1)] = (13));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11579 === (2)))
{var inst_11555 = (state_11578[(7)]);var state_11578__$1 = state_11578;if(cljs.core.truth_(inst_11555))
{var statearr_11587_11609 = state_11578__$1;(statearr_11587_11609[(1)] = (4));
} else
{var statearr_11588_11610 = state_11578__$1;(statearr_11588_11610[(1)] = (5));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11579 === (11)))
{var inst_11569 = cljs.core.async.close_BANG_.call(null,ch);var state_11578__$1 = state_11578;var statearr_11589_11611 = state_11578__$1;(statearr_11589_11611[(2)] = inst_11569);
(statearr_11589_11611[(1)] = (13));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11579 === (9)))
{var state_11578__$1 = state_11578;if(cljs.core.truth_(close_QMARK_))
{var statearr_11590_11612 = state_11578__$1;(statearr_11590_11612[(1)] = (11));
} else
{var statearr_11591_11613 = state_11578__$1;(statearr_11591_11613[(1)] = (12));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11579 === (5)))
{var inst_11555 = (state_11578[(7)]);var state_11578__$1 = state_11578;var statearr_11592_11614 = state_11578__$1;(statearr_11592_11614[(2)] = inst_11555);
(statearr_11592_11614[(1)] = (6));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11579 === (10)))
{var inst_11574 = (state_11578[(2)]);var state_11578__$1 = state_11578;var statearr_11593_11615 = state_11578__$1;(statearr_11593_11615[(2)] = inst_11574);
(statearr_11593_11615[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11579 === (8)))
{var inst_11555 = (state_11578[(7)]);var inst_11565 = cljs.core.next.call(null,inst_11555);var inst_11555__$1 = inst_11565;var state_11578__$1 = (function (){var statearr_11594 = state_11578;(statearr_11594[(7)] = inst_11555__$1);
return statearr_11594;
})();var statearr_11595_11616 = state_11578__$1;(statearr_11595_11616[(2)] = null);
(statearr_11595_11616[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__5915__auto__))
;return ((function (switch__5900__auto__,c__5915__auto__){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_11599 = [null,null,null,null,null,null,null,null];(statearr_11599[(0)] = state_machine__5901__auto__);
(statearr_11599[(1)] = (1));
return statearr_11599;
});
var state_machine__5901__auto____1 = (function (state_11578){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_11578);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e11600){if((e11600 instanceof Object))
{var ex__5904__auto__ = e11600;var statearr_11601_11617 = state_11578;(statearr_11601_11617[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11578);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e11600;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__11618 = state_11578;
state_11578 = G__11618;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_11578){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_11578);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto__))
})();var state__5917__auto__ = (function (){var statearr_11602 = f__5916__auto__.call(null);(statearr_11602[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto__);
return statearr_11602;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto__))
);
return c__5915__auto__;
});
onto_chan = function(ch,coll,close_QMARK_){
switch(arguments.length){
case 2:
return onto_chan__2.call(this,ch,coll);
case 3:
return onto_chan__3.call(this,ch,coll,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
onto_chan.cljs$core$IFn$_invoke$arity$2 = onto_chan__2;
onto_chan.cljs$core$IFn$_invoke$arity$3 = onto_chan__3;
return onto_chan;
})()
;
/**
* Creates and returns a channel which contains the contents of coll,
* closing when exhausted.
*/
cljs.core.async.to_chan = (function to_chan(coll){var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));cljs.core.async.onto_chan.call(null,ch,coll);
return ch;
});
cljs.core.async.Mux = (function (){var obj11620 = {};return obj11620;
})();
cljs.core.async.muxch_STAR_ = (function muxch_STAR_(_){if((function (){var and__3636__auto__ = _;if(and__3636__auto__)
{return _.cljs$core$async$Mux$muxch_STAR_$arity$1;
} else
{return and__3636__auto__;
}
})())
{return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else
{var x__4285__auto__ = (((_ == null))?null:_);return (function (){var or__3648__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4285__auto__)]);if(or__3648__auto__)
{return or__3648__auto__;
} else
{var or__3648__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);if(or__3648__auto____$1)
{return or__3648__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
})().call(null,_);
}
});
cljs.core.async.Mult = (function (){var obj11622 = {};return obj11622;
})();
cljs.core.async.tap_STAR_ = (function tap_STAR_(m,ch,close_QMARK_){if((function (){var and__3636__auto__ = m;if(and__3636__auto__)
{return m.cljs$core$async$Mult$tap_STAR_$arity$3;
} else
{return and__3636__auto__;
}
})())
{return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else
{var x__4285__auto__ = (((m == null))?null:m);return (function (){var or__3648__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4285__auto__)]);if(or__3648__auto__)
{return or__3648__auto__;
} else
{var or__3648__auto____$1 = (cljs.core.async.tap_STAR_["_"]);if(or__3648__auto____$1)
{return or__3648__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
})().call(null,m,ch,close_QMARK_);
}
});
cljs.core.async.untap_STAR_ = (function untap_STAR_(m,ch){if((function (){var and__3636__auto__ = m;if(and__3636__auto__)
{return m.cljs$core$async$Mult$untap_STAR_$arity$2;
} else
{return and__3636__auto__;
}
})())
{return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else
{var x__4285__auto__ = (((m == null))?null:m);return (function (){var or__3648__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4285__auto__)]);if(or__3648__auto__)
{return or__3648__auto__;
} else
{var or__3648__auto____$1 = (cljs.core.async.untap_STAR_["_"]);if(or__3648__auto____$1)
{return or__3648__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
})().call(null,m,ch);
}
});
cljs.core.async.untap_all_STAR_ = (function untap_all_STAR_(m){if((function (){var and__3636__auto__ = m;if(and__3636__auto__)
{return m.cljs$core$async$Mult$untap_all_STAR_$arity$1;
} else
{return and__3636__auto__;
}
})())
{return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else
{var x__4285__auto__ = (((m == null))?null:m);return (function (){var or__3648__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4285__auto__)]);if(or__3648__auto__)
{return or__3648__auto__;
} else
{var or__3648__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);if(or__3648__auto____$1)
{return or__3648__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
})().call(null,m);
}
});
/**
* Creates and returns a mult(iple) of the supplied channel. Channels
* containing copies of the channel can be created with 'tap', and
* detached with 'untap'.
* 
* Each item is distributed to all taps in parallel and synchronously,
* i.e. each tap must accept before the next item is distributed. Use
* buffering/windowing to prevent slow taps from holding up the mult.
* 
* Items received when there are no taps get dropped.
* 
* If a tap puts to a closed channel, it will be removed from the mult.
*/
cljs.core.async.mult = (function mult(ch){var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);var m = (function (){if(typeof cljs.core.async.t11844 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t11844 = (function (cs,ch,mult,meta11845){
this.cs = cs;
this.ch = ch;
this.mult = mult;
this.meta11845 = meta11845;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t11844.cljs$lang$type = true;
cljs.core.async.t11844.cljs$lang$ctorStr = "cljs.core.async/t11844";
cljs.core.async.t11844.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__4225__auto__,writer__4226__auto__,opt__4227__auto__){return cljs.core._write.call(null,writer__4226__auto__,"cljs.core.async/t11844");
});})(cs))
;
cljs.core.async.t11844.prototype.cljs$core$async$Mult$ = true;
cljs.core.async.t11844.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$2,close_QMARK_){var self__ = this;
var ___$1 = this;cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$2,close_QMARK_);
return null;
});})(cs))
;
cljs.core.async.t11844.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$2){var self__ = this;
var ___$1 = this;cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$2);
return null;
});})(cs))
;
cljs.core.async.t11844.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){var self__ = this;
var ___$1 = this;cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);
return null;
});})(cs))
;
cljs.core.async.t11844.prototype.cljs$core$async$Mux$ = true;
cljs.core.async.t11844.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){var self__ = this;
var ___$1 = this;return self__.ch;
});})(cs))
;
cljs.core.async.t11844.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_11846){var self__ = this;
var _11846__$1 = this;return self__.meta11845;
});})(cs))
;
cljs.core.async.t11844.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_11846,meta11845__$1){var self__ = this;
var _11846__$1 = this;return (new cljs.core.async.t11844(self__.cs,self__.ch,self__.mult,meta11845__$1));
});})(cs))
;
cljs.core.async.__GT_t11844 = ((function (cs){
return (function __GT_t11844(cs__$1,ch__$1,mult__$1,meta11845){return (new cljs.core.async.t11844(cs__$1,ch__$1,mult__$1,meta11845));
});})(cs))
;
}
return (new cljs.core.async.t11844(cs,ch,mult,null));
})();var dchan = cljs.core.async.chan.call(null,(1));var dctr = cljs.core.atom.call(null,null);var done = ((function (cs,m,dchan,dctr){
return (function (_){if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0)))
{return cljs.core.async.put_BANG_.call(null,dchan,true);
} else
{return null;
}
});})(cs,m,dchan,dctr))
;var c__5915__auto___12065 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto___12065,cs,m,dchan,dctr,done){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto___12065,cs,m,dchan,dctr,done){
return (function (state_11977){var state_val_11978 = (state_11977[(1)]);if((state_val_11978 === (7)))
{var inst_11973 = (state_11977[(2)]);var state_11977__$1 = state_11977;var statearr_11979_12066 = state_11977__$1;(statearr_11979_12066[(2)] = inst_11973);
(statearr_11979_12066[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11978 === (20)))
{var inst_11878 = (state_11977[(7)]);var inst_11888 = cljs.core.first.call(null,inst_11878);var inst_11889 = cljs.core.nth.call(null,inst_11888,(0),null);var inst_11890 = cljs.core.nth.call(null,inst_11888,(1),null);var state_11977__$1 = (function (){var statearr_11980 = state_11977;(statearr_11980[(8)] = inst_11889);
return statearr_11980;
})();if(cljs.core.truth_(inst_11890))
{var statearr_11981_12067 = state_11977__$1;(statearr_11981_12067[(1)] = (22));
} else
{var statearr_11982_12068 = state_11977__$1;(statearr_11982_12068[(1)] = (23));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11978 === (27)))
{var inst_11918 = (state_11977[(9)]);var inst_11849 = (state_11977[(10)]);var inst_11920 = (state_11977[(11)]);var inst_11925 = (state_11977[(12)]);var inst_11925__$1 = cljs.core._nth.call(null,inst_11918,inst_11920);var inst_11926 = cljs.core.async.put_BANG_.call(null,inst_11925__$1,inst_11849,done);var state_11977__$1 = (function (){var statearr_11983 = state_11977;(statearr_11983[(12)] = inst_11925__$1);
return statearr_11983;
})();if(cljs.core.truth_(inst_11926))
{var statearr_11984_12069 = state_11977__$1;(statearr_11984_12069[(1)] = (30));
} else
{var statearr_11985_12070 = state_11977__$1;(statearr_11985_12070[(1)] = (31));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11978 === (1)))
{var state_11977__$1 = state_11977;var statearr_11986_12071 = state_11977__$1;(statearr_11986_12071[(2)] = null);
(statearr_11986_12071[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11978 === (24)))
{var inst_11878 = (state_11977[(7)]);var inst_11895 = (state_11977[(2)]);var inst_11896 = cljs.core.next.call(null,inst_11878);var inst_11858 = inst_11896;var inst_11859 = null;var inst_11860 = (0);var inst_11861 = (0);var state_11977__$1 = (function (){var statearr_11987 = state_11977;(statearr_11987[(13)] = inst_11858);
(statearr_11987[(14)] = inst_11860);
(statearr_11987[(15)] = inst_11861);
(statearr_11987[(16)] = inst_11895);
(statearr_11987[(17)] = inst_11859);
return statearr_11987;
})();var statearr_11988_12072 = state_11977__$1;(statearr_11988_12072[(2)] = null);
(statearr_11988_12072[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11978 === (39)))
{var state_11977__$1 = state_11977;var statearr_11992_12073 = state_11977__$1;(statearr_11992_12073[(2)] = null);
(statearr_11992_12073[(1)] = (41));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11978 === (4)))
{var inst_11849 = (state_11977[(10)]);var inst_11849__$1 = (state_11977[(2)]);var inst_11850 = (inst_11849__$1 == null);var state_11977__$1 = (function (){var statearr_11993 = state_11977;(statearr_11993[(10)] = inst_11849__$1);
return statearr_11993;
})();if(cljs.core.truth_(inst_11850))
{var statearr_11994_12074 = state_11977__$1;(statearr_11994_12074[(1)] = (5));
} else
{var statearr_11995_12075 = state_11977__$1;(statearr_11995_12075[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11978 === (15)))
{var inst_11858 = (state_11977[(13)]);var inst_11860 = (state_11977[(14)]);var inst_11861 = (state_11977[(15)]);var inst_11859 = (state_11977[(17)]);var inst_11874 = (state_11977[(2)]);var inst_11875 = (inst_11861 + (1));var tmp11989 = inst_11858;var tmp11990 = inst_11860;var tmp11991 = inst_11859;var inst_11858__$1 = tmp11989;var inst_11859__$1 = tmp11991;var inst_11860__$1 = tmp11990;var inst_11861__$1 = inst_11875;var state_11977__$1 = (function (){var statearr_11996 = state_11977;(statearr_11996[(13)] = inst_11858__$1);
(statearr_11996[(14)] = inst_11860__$1);
(statearr_11996[(18)] = inst_11874);
(statearr_11996[(15)] = inst_11861__$1);
(statearr_11996[(17)] = inst_11859__$1);
return statearr_11996;
})();var statearr_11997_12076 = state_11977__$1;(statearr_11997_12076[(2)] = null);
(statearr_11997_12076[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11978 === (21)))
{var inst_11899 = (state_11977[(2)]);var state_11977__$1 = state_11977;var statearr_12001_12077 = state_11977__$1;(statearr_12001_12077[(2)] = inst_11899);
(statearr_12001_12077[(1)] = (18));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11978 === (31)))
{var inst_11925 = (state_11977[(12)]);var inst_11929 = done.call(null,null);var inst_11930 = cljs.core.async.untap_STAR_.call(null,m,inst_11925);var state_11977__$1 = (function (){var statearr_12002 = state_11977;(statearr_12002[(19)] = inst_11929);
return statearr_12002;
})();var statearr_12003_12078 = state_11977__$1;(statearr_12003_12078[(2)] = inst_11930);
(statearr_12003_12078[(1)] = (32));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11978 === (32)))
{var inst_11918 = (state_11977[(9)]);var inst_11917 = (state_11977[(20)]);var inst_11919 = (state_11977[(21)]);var inst_11920 = (state_11977[(11)]);var inst_11932 = (state_11977[(2)]);var inst_11933 = (inst_11920 + (1));var tmp11998 = inst_11918;var tmp11999 = inst_11917;var tmp12000 = inst_11919;var inst_11917__$1 = tmp11999;var inst_11918__$1 = tmp11998;var inst_11919__$1 = tmp12000;var inst_11920__$1 = inst_11933;var state_11977__$1 = (function (){var statearr_12004 = state_11977;(statearr_12004[(22)] = inst_11932);
(statearr_12004[(9)] = inst_11918__$1);
(statearr_12004[(20)] = inst_11917__$1);
(statearr_12004[(21)] = inst_11919__$1);
(statearr_12004[(11)] = inst_11920__$1);
return statearr_12004;
})();var statearr_12005_12079 = state_11977__$1;(statearr_12005_12079[(2)] = null);
(statearr_12005_12079[(1)] = (25));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11978 === (40)))
{var inst_11945 = (state_11977[(23)]);var inst_11949 = done.call(null,null);var inst_11950 = cljs.core.async.untap_STAR_.call(null,m,inst_11945);var state_11977__$1 = (function (){var statearr_12006 = state_11977;(statearr_12006[(24)] = inst_11949);
return statearr_12006;
})();var statearr_12007_12080 = state_11977__$1;(statearr_12007_12080[(2)] = inst_11950);
(statearr_12007_12080[(1)] = (41));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11978 === (33)))
{var inst_11936 = (state_11977[(25)]);var inst_11938 = cljs.core.chunked_seq_QMARK_.call(null,inst_11936);var state_11977__$1 = state_11977;if(inst_11938)
{var statearr_12008_12081 = state_11977__$1;(statearr_12008_12081[(1)] = (36));
} else
{var statearr_12009_12082 = state_11977__$1;(statearr_12009_12082[(1)] = (37));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11978 === (13)))
{var inst_11868 = (state_11977[(26)]);var inst_11871 = cljs.core.async.close_BANG_.call(null,inst_11868);var state_11977__$1 = state_11977;var statearr_12010_12083 = state_11977__$1;(statearr_12010_12083[(2)] = inst_11871);
(statearr_12010_12083[(1)] = (15));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11978 === (22)))
{var inst_11889 = (state_11977[(8)]);var inst_11892 = cljs.core.async.close_BANG_.call(null,inst_11889);var state_11977__$1 = state_11977;var statearr_12011_12084 = state_11977__$1;(statearr_12011_12084[(2)] = inst_11892);
(statearr_12011_12084[(1)] = (24));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11978 === (36)))
{var inst_11936 = (state_11977[(25)]);var inst_11940 = cljs.core.chunk_first.call(null,inst_11936);var inst_11941 = cljs.core.chunk_rest.call(null,inst_11936);var inst_11942 = cljs.core.count.call(null,inst_11940);var inst_11917 = inst_11941;var inst_11918 = inst_11940;var inst_11919 = inst_11942;var inst_11920 = (0);var state_11977__$1 = (function (){var statearr_12012 = state_11977;(statearr_12012[(9)] = inst_11918);
(statearr_12012[(20)] = inst_11917);
(statearr_12012[(21)] = inst_11919);
(statearr_12012[(11)] = inst_11920);
return statearr_12012;
})();var statearr_12013_12085 = state_11977__$1;(statearr_12013_12085[(2)] = null);
(statearr_12013_12085[(1)] = (25));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11978 === (41)))
{var inst_11936 = (state_11977[(25)]);var inst_11952 = (state_11977[(2)]);var inst_11953 = cljs.core.next.call(null,inst_11936);var inst_11917 = inst_11953;var inst_11918 = null;var inst_11919 = (0);var inst_11920 = (0);var state_11977__$1 = (function (){var statearr_12014 = state_11977;(statearr_12014[(9)] = inst_11918);
(statearr_12014[(27)] = inst_11952);
(statearr_12014[(20)] = inst_11917);
(statearr_12014[(21)] = inst_11919);
(statearr_12014[(11)] = inst_11920);
return statearr_12014;
})();var statearr_12015_12086 = state_11977__$1;(statearr_12015_12086[(2)] = null);
(statearr_12015_12086[(1)] = (25));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11978 === (43)))
{var state_11977__$1 = state_11977;var statearr_12016_12087 = state_11977__$1;(statearr_12016_12087[(2)] = null);
(statearr_12016_12087[(1)] = (44));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11978 === (29)))
{var inst_11961 = (state_11977[(2)]);var state_11977__$1 = state_11977;var statearr_12017_12088 = state_11977__$1;(statearr_12017_12088[(2)] = inst_11961);
(statearr_12017_12088[(1)] = (26));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11978 === (44)))
{var inst_11970 = (state_11977[(2)]);var state_11977__$1 = (function (){var statearr_12018 = state_11977;(statearr_12018[(28)] = inst_11970);
return statearr_12018;
})();var statearr_12019_12089 = state_11977__$1;(statearr_12019_12089[(2)] = null);
(statearr_12019_12089[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11978 === (6)))
{var inst_11909 = (state_11977[(29)]);var inst_11908 = cljs.core.deref.call(null,cs);var inst_11909__$1 = cljs.core.keys.call(null,inst_11908);var inst_11910 = cljs.core.count.call(null,inst_11909__$1);var inst_11911 = cljs.core.reset_BANG_.call(null,dctr,inst_11910);var inst_11916 = cljs.core.seq.call(null,inst_11909__$1);var inst_11917 = inst_11916;var inst_11918 = null;var inst_11919 = (0);var inst_11920 = (0);var state_11977__$1 = (function (){var statearr_12020 = state_11977;(statearr_12020[(9)] = inst_11918);
(statearr_12020[(29)] = inst_11909__$1);
(statearr_12020[(20)] = inst_11917);
(statearr_12020[(21)] = inst_11919);
(statearr_12020[(11)] = inst_11920);
(statearr_12020[(30)] = inst_11911);
return statearr_12020;
})();var statearr_12021_12090 = state_11977__$1;(statearr_12021_12090[(2)] = null);
(statearr_12021_12090[(1)] = (25));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11978 === (28)))
{var inst_11936 = (state_11977[(25)]);var inst_11917 = (state_11977[(20)]);var inst_11936__$1 = cljs.core.seq.call(null,inst_11917);var state_11977__$1 = (function (){var statearr_12022 = state_11977;(statearr_12022[(25)] = inst_11936__$1);
return statearr_12022;
})();if(inst_11936__$1)
{var statearr_12023_12091 = state_11977__$1;(statearr_12023_12091[(1)] = (33));
} else
{var statearr_12024_12092 = state_11977__$1;(statearr_12024_12092[(1)] = (34));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11978 === (25)))
{var inst_11919 = (state_11977[(21)]);var inst_11920 = (state_11977[(11)]);var inst_11922 = (inst_11920 < inst_11919);var inst_11923 = inst_11922;var state_11977__$1 = state_11977;if(cljs.core.truth_(inst_11923))
{var statearr_12025_12093 = state_11977__$1;(statearr_12025_12093[(1)] = (27));
} else
{var statearr_12026_12094 = state_11977__$1;(statearr_12026_12094[(1)] = (28));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11978 === (34)))
{var state_11977__$1 = state_11977;var statearr_12027_12095 = state_11977__$1;(statearr_12027_12095[(2)] = null);
(statearr_12027_12095[(1)] = (35));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11978 === (17)))
{var state_11977__$1 = state_11977;var statearr_12028_12096 = state_11977__$1;(statearr_12028_12096[(2)] = null);
(statearr_12028_12096[(1)] = (18));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11978 === (3)))
{var inst_11975 = (state_11977[(2)]);var state_11977__$1 = state_11977;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11977__$1,inst_11975);
} else
{if((state_val_11978 === (12)))
{var inst_11904 = (state_11977[(2)]);var state_11977__$1 = state_11977;var statearr_12029_12097 = state_11977__$1;(statearr_12029_12097[(2)] = inst_11904);
(statearr_12029_12097[(1)] = (9));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11978 === (2)))
{var state_11977__$1 = state_11977;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11977__$1,(4),ch);
} else
{if((state_val_11978 === (23)))
{var state_11977__$1 = state_11977;var statearr_12030_12098 = state_11977__$1;(statearr_12030_12098[(2)] = null);
(statearr_12030_12098[(1)] = (24));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11978 === (35)))
{var inst_11959 = (state_11977[(2)]);var state_11977__$1 = state_11977;var statearr_12031_12099 = state_11977__$1;(statearr_12031_12099[(2)] = inst_11959);
(statearr_12031_12099[(1)] = (29));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11978 === (19)))
{var inst_11878 = (state_11977[(7)]);var inst_11882 = cljs.core.chunk_first.call(null,inst_11878);var inst_11883 = cljs.core.chunk_rest.call(null,inst_11878);var inst_11884 = cljs.core.count.call(null,inst_11882);var inst_11858 = inst_11883;var inst_11859 = inst_11882;var inst_11860 = inst_11884;var inst_11861 = (0);var state_11977__$1 = (function (){var statearr_12032 = state_11977;(statearr_12032[(13)] = inst_11858);
(statearr_12032[(14)] = inst_11860);
(statearr_12032[(15)] = inst_11861);
(statearr_12032[(17)] = inst_11859);
return statearr_12032;
})();var statearr_12033_12100 = state_11977__$1;(statearr_12033_12100[(2)] = null);
(statearr_12033_12100[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11978 === (11)))
{var inst_11858 = (state_11977[(13)]);var inst_11878 = (state_11977[(7)]);var inst_11878__$1 = cljs.core.seq.call(null,inst_11858);var state_11977__$1 = (function (){var statearr_12034 = state_11977;(statearr_12034[(7)] = inst_11878__$1);
return statearr_12034;
})();if(inst_11878__$1)
{var statearr_12035_12101 = state_11977__$1;(statearr_12035_12101[(1)] = (16));
} else
{var statearr_12036_12102 = state_11977__$1;(statearr_12036_12102[(1)] = (17));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11978 === (9)))
{var inst_11906 = (state_11977[(2)]);var state_11977__$1 = state_11977;var statearr_12037_12103 = state_11977__$1;(statearr_12037_12103[(2)] = inst_11906);
(statearr_12037_12103[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11978 === (5)))
{var inst_11856 = cljs.core.deref.call(null,cs);var inst_11857 = cljs.core.seq.call(null,inst_11856);var inst_11858 = inst_11857;var inst_11859 = null;var inst_11860 = (0);var inst_11861 = (0);var state_11977__$1 = (function (){var statearr_12038 = state_11977;(statearr_12038[(13)] = inst_11858);
(statearr_12038[(14)] = inst_11860);
(statearr_12038[(15)] = inst_11861);
(statearr_12038[(17)] = inst_11859);
return statearr_12038;
})();var statearr_12039_12104 = state_11977__$1;(statearr_12039_12104[(2)] = null);
(statearr_12039_12104[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11978 === (14)))
{var state_11977__$1 = state_11977;var statearr_12040_12105 = state_11977__$1;(statearr_12040_12105[(2)] = null);
(statearr_12040_12105[(1)] = (15));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11978 === (45)))
{var inst_11967 = (state_11977[(2)]);var state_11977__$1 = state_11977;var statearr_12041_12106 = state_11977__$1;(statearr_12041_12106[(2)] = inst_11967);
(statearr_12041_12106[(1)] = (44));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11978 === (26)))
{var inst_11909 = (state_11977[(29)]);var inst_11963 = (state_11977[(2)]);var inst_11964 = cljs.core.seq.call(null,inst_11909);var state_11977__$1 = (function (){var statearr_12042 = state_11977;(statearr_12042[(31)] = inst_11963);
return statearr_12042;
})();if(inst_11964)
{var statearr_12043_12107 = state_11977__$1;(statearr_12043_12107[(1)] = (42));
} else
{var statearr_12044_12108 = state_11977__$1;(statearr_12044_12108[(1)] = (43));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11978 === (16)))
{var inst_11878 = (state_11977[(7)]);var inst_11880 = cljs.core.chunked_seq_QMARK_.call(null,inst_11878);var state_11977__$1 = state_11977;if(inst_11880)
{var statearr_12045_12109 = state_11977__$1;(statearr_12045_12109[(1)] = (19));
} else
{var statearr_12046_12110 = state_11977__$1;(statearr_12046_12110[(1)] = (20));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11978 === (38)))
{var inst_11956 = (state_11977[(2)]);var state_11977__$1 = state_11977;var statearr_12047_12111 = state_11977__$1;(statearr_12047_12111[(2)] = inst_11956);
(statearr_12047_12111[(1)] = (35));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11978 === (30)))
{var state_11977__$1 = state_11977;var statearr_12048_12112 = state_11977__$1;(statearr_12048_12112[(2)] = null);
(statearr_12048_12112[(1)] = (32));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11978 === (10)))
{var inst_11861 = (state_11977[(15)]);var inst_11859 = (state_11977[(17)]);var inst_11867 = cljs.core._nth.call(null,inst_11859,inst_11861);var inst_11868 = cljs.core.nth.call(null,inst_11867,(0),null);var inst_11869 = cljs.core.nth.call(null,inst_11867,(1),null);var state_11977__$1 = (function (){var statearr_12049 = state_11977;(statearr_12049[(26)] = inst_11868);
return statearr_12049;
})();if(cljs.core.truth_(inst_11869))
{var statearr_12050_12113 = state_11977__$1;(statearr_12050_12113[(1)] = (13));
} else
{var statearr_12051_12114 = state_11977__$1;(statearr_12051_12114[(1)] = (14));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11978 === (18)))
{var inst_11902 = (state_11977[(2)]);var state_11977__$1 = state_11977;var statearr_12052_12115 = state_11977__$1;(statearr_12052_12115[(2)] = inst_11902);
(statearr_12052_12115[(1)] = (12));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11978 === (42)))
{var state_11977__$1 = state_11977;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11977__$1,(45),dchan);
} else
{if((state_val_11978 === (37)))
{var inst_11936 = (state_11977[(25)]);var inst_11849 = (state_11977[(10)]);var inst_11945 = (state_11977[(23)]);var inst_11945__$1 = cljs.core.first.call(null,inst_11936);var inst_11946 = cljs.core.async.put_BANG_.call(null,inst_11945__$1,inst_11849,done);var state_11977__$1 = (function (){var statearr_12053 = state_11977;(statearr_12053[(23)] = inst_11945__$1);
return statearr_12053;
})();if(cljs.core.truth_(inst_11946))
{var statearr_12054_12116 = state_11977__$1;(statearr_12054_12116[(1)] = (39));
} else
{var statearr_12055_12117 = state_11977__$1;(statearr_12055_12117[(1)] = (40));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11978 === (8)))
{var inst_11860 = (state_11977[(14)]);var inst_11861 = (state_11977[(15)]);var inst_11863 = (inst_11861 < inst_11860);var inst_11864 = inst_11863;var state_11977__$1 = state_11977;if(cljs.core.truth_(inst_11864))
{var statearr_12056_12118 = state_11977__$1;(statearr_12056_12118[(1)] = (10));
} else
{var statearr_12057_12119 = state_11977__$1;(statearr_12057_12119[(1)] = (11));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__5915__auto___12065,cs,m,dchan,dctr,done))
;return ((function (switch__5900__auto__,c__5915__auto___12065,cs,m,dchan,dctr,done){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_12061 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_12061[(0)] = state_machine__5901__auto__);
(statearr_12061[(1)] = (1));
return statearr_12061;
});
var state_machine__5901__auto____1 = (function (state_11977){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_11977);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e12062){if((e12062 instanceof Object))
{var ex__5904__auto__ = e12062;var statearr_12063_12120 = state_11977;(statearr_12063_12120[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11977);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e12062;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__12121 = state_11977;
state_11977 = G__12121;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_11977){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_11977);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto___12065,cs,m,dchan,dctr,done))
})();var state__5917__auto__ = (function (){var statearr_12064 = f__5916__auto__.call(null);(statearr_12064[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto___12065);
return statearr_12064;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto___12065,cs,m,dchan,dctr,done))
);
return m;
});
/**
* Copies the mult source onto the supplied channel.
* 
* By default the channel will be closed when the source closes,
* but can be determined by the close? parameter.
*/
cljs.core.async.tap = (function() {
var tap = null;
var tap__2 = (function (mult,ch){return tap.call(null,mult,ch,true);
});
var tap__3 = (function (mult,ch,close_QMARK_){cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);
return ch;
});
tap = function(mult,ch,close_QMARK_){
switch(arguments.length){
case 2:
return tap__2.call(this,mult,ch);
case 3:
return tap__3.call(this,mult,ch,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
tap.cljs$core$IFn$_invoke$arity$2 = tap__2;
tap.cljs$core$IFn$_invoke$arity$3 = tap__3;
return tap;
})()
;
/**
* Disconnects a target channel from a mult
*/
cljs.core.async.untap = (function untap(mult,ch){return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
* Disconnects all target channels from a mult
*/
cljs.core.async.untap_all = (function untap_all(mult){return cljs.core.async.untap_all_STAR_.call(null,mult);
});
cljs.core.async.Mix = (function (){var obj12123 = {};return obj12123;
})();
cljs.core.async.admix_STAR_ = (function admix_STAR_(m,ch){if((function (){var and__3636__auto__ = m;if(and__3636__auto__)
{return m.cljs$core$async$Mix$admix_STAR_$arity$2;
} else
{return and__3636__auto__;
}
})())
{return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else
{var x__4285__auto__ = (((m == null))?null:m);return (function (){var or__3648__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4285__auto__)]);if(or__3648__auto__)
{return or__3648__auto__;
} else
{var or__3648__auto____$1 = (cljs.core.async.admix_STAR_["_"]);if(or__3648__auto____$1)
{return or__3648__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
})().call(null,m,ch);
}
});
cljs.core.async.unmix_STAR_ = (function unmix_STAR_(m,ch){if((function (){var and__3636__auto__ = m;if(and__3636__auto__)
{return m.cljs$core$async$Mix$unmix_STAR_$arity$2;
} else
{return and__3636__auto__;
}
})())
{return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else
{var x__4285__auto__ = (((m == null))?null:m);return (function (){var or__3648__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4285__auto__)]);if(or__3648__auto__)
{return or__3648__auto__;
} else
{var or__3648__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);if(or__3648__auto____$1)
{return or__3648__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
})().call(null,m,ch);
}
});
cljs.core.async.unmix_all_STAR_ = (function unmix_all_STAR_(m){if((function (){var and__3636__auto__ = m;if(and__3636__auto__)
{return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1;
} else
{return and__3636__auto__;
}
})())
{return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else
{var x__4285__auto__ = (((m == null))?null:m);return (function (){var or__3648__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4285__auto__)]);if(or__3648__auto__)
{return or__3648__auto__;
} else
{var or__3648__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);if(or__3648__auto____$1)
{return or__3648__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
})().call(null,m);
}
});
cljs.core.async.toggle_STAR_ = (function toggle_STAR_(m,state_map){if((function (){var and__3636__auto__ = m;if(and__3636__auto__)
{return m.cljs$core$async$Mix$toggle_STAR_$arity$2;
} else
{return and__3636__auto__;
}
})())
{return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else
{var x__4285__auto__ = (((m == null))?null:m);return (function (){var or__3648__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4285__auto__)]);if(or__3648__auto__)
{return or__3648__auto__;
} else
{var or__3648__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);if(or__3648__auto____$1)
{return or__3648__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
})().call(null,m,state_map);
}
});
cljs.core.async.solo_mode_STAR_ = (function solo_mode_STAR_(m,mode){if((function (){var and__3636__auto__ = m;if(and__3636__auto__)
{return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2;
} else
{return and__3636__auto__;
}
})())
{return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else
{var x__4285__auto__ = (((m == null))?null:m);return (function (){var or__3648__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4285__auto__)]);if(or__3648__auto__)
{return or__3648__auto__;
} else
{var or__3648__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);if(or__3648__auto____$1)
{return or__3648__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
})().call(null,m,mode);
}
});
/**
* @param {...*} var_args
*/
cljs.core.async.ioc_alts_BANG_ = (function() { 
var ioc_alts_BANG___delegate = function (state,cont_block,ports,p__12124){var map__12129 = p__12124;var map__12129__$1 = ((cljs.core.seq_QMARK_.call(null,map__12129))?cljs.core.apply.call(null,cljs.core.hash_map,map__12129):map__12129);var opts = map__12129__$1;var statearr_12130_12133 = state;(statearr_12130_12133[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);
var temp__4126__auto__ = cljs.core.async.do_alts.call(null,((function (map__12129,map__12129__$1,opts){
return (function (val){var statearr_12131_12134 = state;(statearr_12131_12134[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__12129,map__12129__$1,opts))
,ports,opts);if(cljs.core.truth_(temp__4126__auto__))
{var cb = temp__4126__auto__;var statearr_12132_12135 = state;(statearr_12132_12135[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
};
var ioc_alts_BANG_ = function (state,cont_block,ports,var_args){
var p__12124 = null;if (arguments.length > 3) {
  p__12124 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3),0);} 
return ioc_alts_BANG___delegate.call(this,state,cont_block,ports,p__12124);};
ioc_alts_BANG_.cljs$lang$maxFixedArity = 3;
ioc_alts_BANG_.cljs$lang$applyTo = (function (arglist__12136){
var state = cljs.core.first(arglist__12136);
arglist__12136 = cljs.core.next(arglist__12136);
var cont_block = cljs.core.first(arglist__12136);
arglist__12136 = cljs.core.next(arglist__12136);
var ports = cljs.core.first(arglist__12136);
var p__12124 = cljs.core.rest(arglist__12136);
return ioc_alts_BANG___delegate(state,cont_block,ports,p__12124);
});
ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = ioc_alts_BANG___delegate;
return ioc_alts_BANG_;
})()
;
/**
* Creates and returns a mix of one or more input channels which will
* be put on the supplied out channel. Input sources can be added to
* the mix with 'admix', and removed with 'unmix'. A mix supports
* soloing, muting and pausing multiple inputs atomically using
* 'toggle', and can solo using either muting or pausing as determined
* by 'solo-mode'.
* 
* Each channel can have zero or more boolean modes set via 'toggle':
* 
* :solo - when true, only this (ond other soloed) channel(s) will appear
* in the mix output channel. :mute and :pause states of soloed
* channels are ignored. If solo-mode is :mute, non-soloed
* channels are muted, if :pause, non-soloed channels are
* paused.
* 
* :mute - muted channels will have their contents consumed but not included in the mix
* :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
*/
cljs.core.async.mix = (function mix(out){var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));var change = cljs.core.async.chan.call(null);var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){if(cljs.core.truth_(attr.call(null,v)))
{return cljs.core.conj.call(null,ret,c);
} else
{return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){var chs = cljs.core.deref.call(null,cs);var mode = cljs.core.deref.call(null,solo_mode);var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;var m = (function (){if(typeof cljs.core.async.t12256 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t12256 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta12257){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta12257 = meta12257;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t12256.cljs$lang$type = true;
cljs.core.async.t12256.cljs$lang$ctorStr = "cljs.core.async/t12256";
cljs.core.async.t12256.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__4225__auto__,writer__4226__auto__,opt__4227__auto__){return cljs.core._write.call(null,writer__4226__auto__,"cljs.core.async/t12256");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t12256.prototype.cljs$core$async$Mix$ = true;
cljs.core.async.t12256.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){var self__ = this;
var ___$1 = this;cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);
return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t12256.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){var self__ = this;
var ___$1 = this;cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);
return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t12256.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){var self__ = this;
var ___$1 = this;cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);
return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t12256.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){var self__ = this;
var ___$1 = this;cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);
return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t12256.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){var self__ = this;
var ___$1 = this;if(cljs.core.truth_(self__.solo_modes.call(null,mode)))
{} else
{throw (new Error(("Assert failed: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(("mode must be one of: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)))+"\n"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null)))))));
}
cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);
return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t12256.prototype.cljs$core$async$Mux$ = true;
cljs.core.async.t12256.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){var self__ = this;
var ___$1 = this;return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t12256.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_12258){var self__ = this;
var _12258__$1 = this;return self__.meta12257;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t12256.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_12258,meta12257__$1){var self__ = this;
var _12258__$1 = this;return (new cljs.core.async.t12256(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta12257__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.__GT_t12256 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function __GT_t12256(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta12257){return (new cljs.core.async.t12256(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta12257));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
}
return (new cljs.core.async.t12256(change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,null));
})();var c__5915__auto___12375 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto___12375,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto___12375,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_12328){var state_val_12329 = (state_12328[(1)]);if((state_val_12329 === (7)))
{var inst_12272 = (state_12328[(7)]);var inst_12277 = cljs.core.apply.call(null,cljs.core.hash_map,inst_12272);var state_12328__$1 = state_12328;var statearr_12330_12376 = state_12328__$1;(statearr_12330_12376[(2)] = inst_12277);
(statearr_12330_12376[(1)] = (9));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12329 === (20)))
{var inst_12287 = (state_12328[(8)]);var state_12328__$1 = state_12328;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12328__$1,(23),out,inst_12287);
} else
{if((state_val_12329 === (1)))
{var inst_12262 = (state_12328[(9)]);var inst_12262__$1 = calc_state.call(null);var inst_12263 = cljs.core.seq_QMARK_.call(null,inst_12262__$1);var state_12328__$1 = (function (){var statearr_12331 = state_12328;(statearr_12331[(9)] = inst_12262__$1);
return statearr_12331;
})();if(inst_12263)
{var statearr_12332_12377 = state_12328__$1;(statearr_12332_12377[(1)] = (2));
} else
{var statearr_12333_12378 = state_12328__$1;(statearr_12333_12378[(1)] = (3));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12329 === (24)))
{var inst_12280 = (state_12328[(10)]);var inst_12272 = inst_12280;var state_12328__$1 = (function (){var statearr_12334 = state_12328;(statearr_12334[(7)] = inst_12272);
return statearr_12334;
})();var statearr_12335_12379 = state_12328__$1;(statearr_12335_12379[(2)] = null);
(statearr_12335_12379[(1)] = (5));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12329 === (4)))
{var inst_12262 = (state_12328[(9)]);var inst_12268 = (state_12328[(2)]);var inst_12269 = cljs.core.get.call(null,inst_12268,new cljs.core.Keyword(null,"reads","reads",-1215067361));var inst_12270 = cljs.core.get.call(null,inst_12268,new cljs.core.Keyword(null,"mutes","mutes",1068806309));var inst_12271 = cljs.core.get.call(null,inst_12268,new cljs.core.Keyword(null,"solos","solos",1441458643));var inst_12272 = inst_12262;var state_12328__$1 = (function (){var statearr_12336 = state_12328;(statearr_12336[(11)] = inst_12270);
(statearr_12336[(12)] = inst_12271);
(statearr_12336[(13)] = inst_12269);
(statearr_12336[(7)] = inst_12272);
return statearr_12336;
})();var statearr_12337_12380 = state_12328__$1;(statearr_12337_12380[(2)] = null);
(statearr_12337_12380[(1)] = (5));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12329 === (15)))
{var state_12328__$1 = state_12328;var statearr_12338_12381 = state_12328__$1;(statearr_12338_12381[(2)] = null);
(statearr_12338_12381[(1)] = (16));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12329 === (21)))
{var inst_12280 = (state_12328[(10)]);var inst_12272 = inst_12280;var state_12328__$1 = (function (){var statearr_12339 = state_12328;(statearr_12339[(7)] = inst_12272);
return statearr_12339;
})();var statearr_12340_12382 = state_12328__$1;(statearr_12340_12382[(2)] = null);
(statearr_12340_12382[(1)] = (5));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12329 === (13)))
{var inst_12324 = (state_12328[(2)]);var state_12328__$1 = state_12328;var statearr_12341_12383 = state_12328__$1;(statearr_12341_12383[(2)] = inst_12324);
(statearr_12341_12383[(1)] = (6));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12329 === (22)))
{var inst_12322 = (state_12328[(2)]);var state_12328__$1 = state_12328;var statearr_12342_12384 = state_12328__$1;(statearr_12342_12384[(2)] = inst_12322);
(statearr_12342_12384[(1)] = (13));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12329 === (6)))
{var inst_12326 = (state_12328[(2)]);var state_12328__$1 = state_12328;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12328__$1,inst_12326);
} else
{if((state_val_12329 === (25)))
{var state_12328__$1 = state_12328;var statearr_12343_12385 = state_12328__$1;(statearr_12343_12385[(2)] = null);
(statearr_12343_12385[(1)] = (26));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12329 === (17)))
{var inst_12302 = (state_12328[(14)]);var state_12328__$1 = state_12328;var statearr_12344_12386 = state_12328__$1;(statearr_12344_12386[(2)] = inst_12302);
(statearr_12344_12386[(1)] = (19));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12329 === (3)))
{var inst_12262 = (state_12328[(9)]);var state_12328__$1 = state_12328;var statearr_12345_12387 = state_12328__$1;(statearr_12345_12387[(2)] = inst_12262);
(statearr_12345_12387[(1)] = (4));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12329 === (12)))
{var inst_12288 = (state_12328[(15)]);var inst_12302 = (state_12328[(14)]);var inst_12283 = (state_12328[(16)]);var inst_12302__$1 = inst_12283.call(null,inst_12288);var state_12328__$1 = (function (){var statearr_12346 = state_12328;(statearr_12346[(14)] = inst_12302__$1);
return statearr_12346;
})();if(cljs.core.truth_(inst_12302__$1))
{var statearr_12347_12388 = state_12328__$1;(statearr_12347_12388[(1)] = (17));
} else
{var statearr_12348_12389 = state_12328__$1;(statearr_12348_12389[(1)] = (18));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12329 === (2)))
{var inst_12262 = (state_12328[(9)]);var inst_12265 = cljs.core.apply.call(null,cljs.core.hash_map,inst_12262);var state_12328__$1 = state_12328;var statearr_12349_12390 = state_12328__$1;(statearr_12349_12390[(2)] = inst_12265);
(statearr_12349_12390[(1)] = (4));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12329 === (23)))
{var inst_12313 = (state_12328[(2)]);var state_12328__$1 = state_12328;if(cljs.core.truth_(inst_12313))
{var statearr_12350_12391 = state_12328__$1;(statearr_12350_12391[(1)] = (24));
} else
{var statearr_12351_12392 = state_12328__$1;(statearr_12351_12392[(1)] = (25));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12329 === (19)))
{var inst_12310 = (state_12328[(2)]);var state_12328__$1 = state_12328;if(cljs.core.truth_(inst_12310))
{var statearr_12352_12393 = state_12328__$1;(statearr_12352_12393[(1)] = (20));
} else
{var statearr_12353_12394 = state_12328__$1;(statearr_12353_12394[(1)] = (21));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12329 === (11)))
{var inst_12287 = (state_12328[(8)]);var inst_12293 = (inst_12287 == null);var state_12328__$1 = state_12328;if(cljs.core.truth_(inst_12293))
{var statearr_12354_12395 = state_12328__$1;(statearr_12354_12395[(1)] = (14));
} else
{var statearr_12355_12396 = state_12328__$1;(statearr_12355_12396[(1)] = (15));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12329 === (9)))
{var inst_12280 = (state_12328[(10)]);var inst_12280__$1 = (state_12328[(2)]);var inst_12281 = cljs.core.get.call(null,inst_12280__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));var inst_12282 = cljs.core.get.call(null,inst_12280__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));var inst_12283 = cljs.core.get.call(null,inst_12280__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));var state_12328__$1 = (function (){var statearr_12356 = state_12328;(statearr_12356[(17)] = inst_12282);
(statearr_12356[(16)] = inst_12283);
(statearr_12356[(10)] = inst_12280__$1);
return statearr_12356;
})();return cljs.core.async.ioc_alts_BANG_.call(null,state_12328__$1,(10),inst_12281);
} else
{if((state_val_12329 === (5)))
{var inst_12272 = (state_12328[(7)]);var inst_12275 = cljs.core.seq_QMARK_.call(null,inst_12272);var state_12328__$1 = state_12328;if(inst_12275)
{var statearr_12357_12397 = state_12328__$1;(statearr_12357_12397[(1)] = (7));
} else
{var statearr_12358_12398 = state_12328__$1;(statearr_12358_12398[(1)] = (8));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12329 === (14)))
{var inst_12288 = (state_12328[(15)]);var inst_12295 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_12288);var state_12328__$1 = state_12328;var statearr_12359_12399 = state_12328__$1;(statearr_12359_12399[(2)] = inst_12295);
(statearr_12359_12399[(1)] = (16));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12329 === (26)))
{var inst_12318 = (state_12328[(2)]);var state_12328__$1 = state_12328;var statearr_12360_12400 = state_12328__$1;(statearr_12360_12400[(2)] = inst_12318);
(statearr_12360_12400[(1)] = (22));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12329 === (16)))
{var inst_12298 = (state_12328[(2)]);var inst_12299 = calc_state.call(null);var inst_12272 = inst_12299;var state_12328__$1 = (function (){var statearr_12361 = state_12328;(statearr_12361[(18)] = inst_12298);
(statearr_12361[(7)] = inst_12272);
return statearr_12361;
})();var statearr_12362_12401 = state_12328__$1;(statearr_12362_12401[(2)] = null);
(statearr_12362_12401[(1)] = (5));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12329 === (10)))
{var inst_12288 = (state_12328[(15)]);var inst_12287 = (state_12328[(8)]);var inst_12286 = (state_12328[(2)]);var inst_12287__$1 = cljs.core.nth.call(null,inst_12286,(0),null);var inst_12288__$1 = cljs.core.nth.call(null,inst_12286,(1),null);var inst_12289 = (inst_12287__$1 == null);var inst_12290 = cljs.core._EQ_.call(null,inst_12288__$1,change);var inst_12291 = (inst_12289) || (inst_12290);var state_12328__$1 = (function (){var statearr_12363 = state_12328;(statearr_12363[(15)] = inst_12288__$1);
(statearr_12363[(8)] = inst_12287__$1);
return statearr_12363;
})();if(cljs.core.truth_(inst_12291))
{var statearr_12364_12402 = state_12328__$1;(statearr_12364_12402[(1)] = (11));
} else
{var statearr_12365_12403 = state_12328__$1;(statearr_12365_12403[(1)] = (12));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12329 === (18)))
{var inst_12288 = (state_12328[(15)]);var inst_12282 = (state_12328[(17)]);var inst_12283 = (state_12328[(16)]);var inst_12305 = cljs.core.empty_QMARK_.call(null,inst_12283);var inst_12306 = inst_12282.call(null,inst_12288);var inst_12307 = cljs.core.not.call(null,inst_12306);var inst_12308 = (inst_12305) && (inst_12307);var state_12328__$1 = state_12328;var statearr_12366_12404 = state_12328__$1;(statearr_12366_12404[(2)] = inst_12308);
(statearr_12366_12404[(1)] = (19));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12329 === (8)))
{var inst_12272 = (state_12328[(7)]);var state_12328__$1 = state_12328;var statearr_12367_12405 = state_12328__$1;(statearr_12367_12405[(2)] = inst_12272);
(statearr_12367_12405[(1)] = (9));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__5915__auto___12375,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;return ((function (switch__5900__auto__,c__5915__auto___12375,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_12371 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_12371[(0)] = state_machine__5901__auto__);
(statearr_12371[(1)] = (1));
return statearr_12371;
});
var state_machine__5901__auto____1 = (function (state_12328){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_12328);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e12372){if((e12372 instanceof Object))
{var ex__5904__auto__ = e12372;var statearr_12373_12406 = state_12328;(statearr_12373_12406[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12328);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e12372;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__12407 = state_12328;
state_12328 = G__12407;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_12328){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_12328);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto___12375,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();var state__5917__auto__ = (function (){var statearr_12374 = f__5916__auto__.call(null);(statearr_12374[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto___12375);
return statearr_12374;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto___12375,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);
return m;
});
/**
* Adds ch as an input to the mix
*/
cljs.core.async.admix = (function admix(mix,ch){return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
* Removes ch as an input to the mix
*/
cljs.core.async.unmix = (function unmix(mix,ch){return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
* removes all inputs from the mix
*/
cljs.core.async.unmix_all = (function unmix_all(mix){return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
* Atomically sets the state(s) of one or more channels in a mix. The
* state map is a map of channels -> channel-state-map. A
* channel-state-map is a map of attrs -> boolean, where attr is one or
* more of :mute, :pause or :solo. Any states supplied are merged with
* the current state.
* 
* Note that channels can be added to a mix via toggle, which can be
* used to add channels in a particular (e.g. paused) state.
*/
cljs.core.async.toggle = (function toggle(mix,state_map){return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
* Sets the solo mode of the mix. mode must be one of :mute or :pause
*/
cljs.core.async.solo_mode = (function solo_mode(mix,mode){return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});
cljs.core.async.Pub = (function (){var obj12409 = {};return obj12409;
})();
cljs.core.async.sub_STAR_ = (function sub_STAR_(p,v,ch,close_QMARK_){if((function (){var and__3636__auto__ = p;if(and__3636__auto__)
{return p.cljs$core$async$Pub$sub_STAR_$arity$4;
} else
{return and__3636__auto__;
}
})())
{return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else
{var x__4285__auto__ = (((p == null))?null:p);return (function (){var or__3648__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4285__auto__)]);if(or__3648__auto__)
{return or__3648__auto__;
} else
{var or__3648__auto____$1 = (cljs.core.async.sub_STAR_["_"]);if(or__3648__auto____$1)
{return or__3648__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
})().call(null,p,v,ch,close_QMARK_);
}
});
cljs.core.async.unsub_STAR_ = (function unsub_STAR_(p,v,ch){if((function (){var and__3636__auto__ = p;if(and__3636__auto__)
{return p.cljs$core$async$Pub$unsub_STAR_$arity$3;
} else
{return and__3636__auto__;
}
})())
{return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else
{var x__4285__auto__ = (((p == null))?null:p);return (function (){var or__3648__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4285__auto__)]);if(or__3648__auto__)
{return or__3648__auto__;
} else
{var or__3648__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);if(or__3648__auto____$1)
{return or__3648__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
})().call(null,p,v,ch);
}
});
cljs.core.async.unsub_all_STAR_ = (function() {
var unsub_all_STAR_ = null;
var unsub_all_STAR___1 = (function (p){if((function (){var and__3636__auto__ = p;if(and__3636__auto__)
{return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1;
} else
{return and__3636__auto__;
}
})())
{return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else
{var x__4285__auto__ = (((p == null))?null:p);return (function (){var or__3648__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4285__auto__)]);if(or__3648__auto__)
{return or__3648__auto__;
} else
{var or__3648__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);if(or__3648__auto____$1)
{return or__3648__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
})().call(null,p);
}
});
var unsub_all_STAR___2 = (function (p,v){if((function (){var and__3636__auto__ = p;if(and__3636__auto__)
{return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2;
} else
{return and__3636__auto__;
}
})())
{return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else
{var x__4285__auto__ = (((p == null))?null:p);return (function (){var or__3648__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4285__auto__)]);if(or__3648__auto__)
{return or__3648__auto__;
} else
{var or__3648__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);if(or__3648__auto____$1)
{return or__3648__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
})().call(null,p,v);
}
});
unsub_all_STAR_ = function(p,v){
switch(arguments.length){
case 1:
return unsub_all_STAR___1.call(this,p);
case 2:
return unsub_all_STAR___2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = unsub_all_STAR___1;
unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = unsub_all_STAR___2;
return unsub_all_STAR_;
})()
;
/**
* Creates and returns a pub(lication) of the supplied channel,
* partitioned into topics by the topic-fn. topic-fn will be applied to
* each value on the channel and the result will determine the 'topic'
* on which that value will be put. Channels can be subscribed to
* receive copies of topics using 'sub', and unsubscribed using
* 'unsub'. Each topic will be handled by an internal mult on a
* dedicated channel. By default these internal channels are
* unbuffered, but a buf-fn can be supplied which, given a topic,
* creates a buffer with desired properties.
* 
* Each item is distributed to all subs in parallel and synchronously,
* i.e. each sub must accept before the next item is distributed. Use
* buffering/windowing to prevent slow subs from holding up the pub.
* 
* Items received when there are no matching subs get dropped.
* 
* Note that if buf-fns are used then each topic is handled
* asynchronously, i.e. if a channel is subscribed to more than one
* topic it should not expect them to be interleaved identically with
* the source.
*/
cljs.core.async.pub = (function() {
var pub = null;
var pub__2 = (function (ch,topic_fn){return pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});
var pub__3 = (function (ch,topic_fn,buf_fn){var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);var ensure_mult = ((function (mults){
return (function (topic){var or__3648__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);if(cljs.core.truth_(or__3648__auto__))
{return or__3648__auto__;
} else
{return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__3648__auto__,mults){
return (function (p1__12410_SHARP_){if(cljs.core.truth_(p1__12410_SHARP_.call(null,topic)))
{return p1__12410_SHARP_;
} else
{return cljs.core.assoc.call(null,p1__12410_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__3648__auto__,mults))
),topic);
}
});})(mults))
;var p = (function (){if(typeof cljs.core.async.t12533 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t12533 = (function (ensure_mult,mults,buf_fn,topic_fn,ch,pub,meta12534){
this.ensure_mult = ensure_mult;
this.mults = mults;
this.buf_fn = buf_fn;
this.topic_fn = topic_fn;
this.ch = ch;
this.pub = pub;
this.meta12534 = meta12534;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t12533.cljs$lang$type = true;
cljs.core.async.t12533.cljs$lang$ctorStr = "cljs.core.async/t12533";
cljs.core.async.t12533.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__4225__auto__,writer__4226__auto__,opt__4227__auto__){return cljs.core._write.call(null,writer__4226__auto__,"cljs.core.async/t12533");
});})(mults,ensure_mult))
;
cljs.core.async.t12533.prototype.cljs$core$async$Pub$ = true;
cljs.core.async.t12533.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$2,close_QMARK_){var self__ = this;
var p__$1 = this;var m = self__.ensure_mult.call(null,topic);return cljs.core.async.tap.call(null,m,ch__$2,close_QMARK_);
});})(mults,ensure_mult))
;
cljs.core.async.t12533.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$2){var self__ = this;
var p__$1 = this;var temp__4126__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);if(cljs.core.truth_(temp__4126__auto__))
{var m = temp__4126__auto__;return cljs.core.async.untap.call(null,m,ch__$2);
} else
{return null;
}
});})(mults,ensure_mult))
;
cljs.core.async.t12533.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){var self__ = this;
var ___$1 = this;return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;
cljs.core.async.t12533.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){var self__ = this;
var ___$1 = this;return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;
cljs.core.async.t12533.prototype.cljs$core$async$Mux$ = true;
cljs.core.async.t12533.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){var self__ = this;
var ___$1 = this;return self__.ch;
});})(mults,ensure_mult))
;
cljs.core.async.t12533.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_12535){var self__ = this;
var _12535__$1 = this;return self__.meta12534;
});})(mults,ensure_mult))
;
cljs.core.async.t12533.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_12535,meta12534__$1){var self__ = this;
var _12535__$1 = this;return (new cljs.core.async.t12533(self__.ensure_mult,self__.mults,self__.buf_fn,self__.topic_fn,self__.ch,self__.pub,meta12534__$1));
});})(mults,ensure_mult))
;
cljs.core.async.__GT_t12533 = ((function (mults,ensure_mult){
return (function __GT_t12533(ensure_mult__$1,mults__$1,buf_fn__$1,topic_fn__$1,ch__$1,pub__$1,meta12534){return (new cljs.core.async.t12533(ensure_mult__$1,mults__$1,buf_fn__$1,topic_fn__$1,ch__$1,pub__$1,meta12534));
});})(mults,ensure_mult))
;
}
return (new cljs.core.async.t12533(ensure_mult,mults,buf_fn,topic_fn,ch,pub,null));
})();var c__5915__auto___12655 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto___12655,mults,ensure_mult,p){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto___12655,mults,ensure_mult,p){
return (function (state_12607){var state_val_12608 = (state_12607[(1)]);if((state_val_12608 === (7)))
{var inst_12603 = (state_12607[(2)]);var state_12607__$1 = state_12607;var statearr_12609_12656 = state_12607__$1;(statearr_12609_12656[(2)] = inst_12603);
(statearr_12609_12656[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12608 === (20)))
{var state_12607__$1 = state_12607;var statearr_12610_12657 = state_12607__$1;(statearr_12610_12657[(2)] = null);
(statearr_12610_12657[(1)] = (21));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12608 === (1)))
{var state_12607__$1 = state_12607;var statearr_12611_12658 = state_12607__$1;(statearr_12611_12658[(2)] = null);
(statearr_12611_12658[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12608 === (24)))
{var inst_12586 = (state_12607[(7)]);var inst_12595 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_12586);var state_12607__$1 = state_12607;var statearr_12612_12659 = state_12607__$1;(statearr_12612_12659[(2)] = inst_12595);
(statearr_12612_12659[(1)] = (25));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12608 === (4)))
{var inst_12538 = (state_12607[(8)]);var inst_12538__$1 = (state_12607[(2)]);var inst_12539 = (inst_12538__$1 == null);var state_12607__$1 = (function (){var statearr_12613 = state_12607;(statearr_12613[(8)] = inst_12538__$1);
return statearr_12613;
})();if(cljs.core.truth_(inst_12539))
{var statearr_12614_12660 = state_12607__$1;(statearr_12614_12660[(1)] = (5));
} else
{var statearr_12615_12661 = state_12607__$1;(statearr_12615_12661[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12608 === (15)))
{var inst_12580 = (state_12607[(2)]);var state_12607__$1 = state_12607;var statearr_12616_12662 = state_12607__$1;(statearr_12616_12662[(2)] = inst_12580);
(statearr_12616_12662[(1)] = (12));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12608 === (21)))
{var inst_12600 = (state_12607[(2)]);var state_12607__$1 = (function (){var statearr_12617 = state_12607;(statearr_12617[(9)] = inst_12600);
return statearr_12617;
})();var statearr_12618_12663 = state_12607__$1;(statearr_12618_12663[(2)] = null);
(statearr_12618_12663[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12608 === (13)))
{var inst_12562 = (state_12607[(10)]);var inst_12564 = cljs.core.chunked_seq_QMARK_.call(null,inst_12562);var state_12607__$1 = state_12607;if(inst_12564)
{var statearr_12619_12664 = state_12607__$1;(statearr_12619_12664[(1)] = (16));
} else
{var statearr_12620_12665 = state_12607__$1;(statearr_12620_12665[(1)] = (17));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12608 === (22)))
{var inst_12592 = (state_12607[(2)]);var state_12607__$1 = state_12607;if(cljs.core.truth_(inst_12592))
{var statearr_12621_12666 = state_12607__$1;(statearr_12621_12666[(1)] = (23));
} else
{var statearr_12622_12667 = state_12607__$1;(statearr_12622_12667[(1)] = (24));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12608 === (6)))
{var inst_12538 = (state_12607[(8)]);var inst_12588 = (state_12607[(11)]);var inst_12586 = (state_12607[(7)]);var inst_12586__$1 = topic_fn.call(null,inst_12538);var inst_12587 = cljs.core.deref.call(null,mults);var inst_12588__$1 = cljs.core.get.call(null,inst_12587,inst_12586__$1);var state_12607__$1 = (function (){var statearr_12623 = state_12607;(statearr_12623[(11)] = inst_12588__$1);
(statearr_12623[(7)] = inst_12586__$1);
return statearr_12623;
})();if(cljs.core.truth_(inst_12588__$1))
{var statearr_12624_12668 = state_12607__$1;(statearr_12624_12668[(1)] = (19));
} else
{var statearr_12625_12669 = state_12607__$1;(statearr_12625_12669[(1)] = (20));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12608 === (25)))
{var inst_12597 = (state_12607[(2)]);var state_12607__$1 = state_12607;var statearr_12626_12670 = state_12607__$1;(statearr_12626_12670[(2)] = inst_12597);
(statearr_12626_12670[(1)] = (21));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12608 === (17)))
{var inst_12562 = (state_12607[(10)]);var inst_12571 = cljs.core.first.call(null,inst_12562);var inst_12572 = cljs.core.async.muxch_STAR_.call(null,inst_12571);var inst_12573 = cljs.core.async.close_BANG_.call(null,inst_12572);var inst_12574 = cljs.core.next.call(null,inst_12562);var inst_12548 = inst_12574;var inst_12549 = null;var inst_12550 = (0);var inst_12551 = (0);var state_12607__$1 = (function (){var statearr_12627 = state_12607;(statearr_12627[(12)] = inst_12551);
(statearr_12627[(13)] = inst_12550);
(statearr_12627[(14)] = inst_12548);
(statearr_12627[(15)] = inst_12549);
(statearr_12627[(16)] = inst_12573);
return statearr_12627;
})();var statearr_12628_12671 = state_12607__$1;(statearr_12628_12671[(2)] = null);
(statearr_12628_12671[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12608 === (3)))
{var inst_12605 = (state_12607[(2)]);var state_12607__$1 = state_12607;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12607__$1,inst_12605);
} else
{if((state_val_12608 === (12)))
{var inst_12582 = (state_12607[(2)]);var state_12607__$1 = state_12607;var statearr_12629_12672 = state_12607__$1;(statearr_12629_12672[(2)] = inst_12582);
(statearr_12629_12672[(1)] = (9));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12608 === (2)))
{var state_12607__$1 = state_12607;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12607__$1,(4),ch);
} else
{if((state_val_12608 === (23)))
{var state_12607__$1 = state_12607;var statearr_12630_12673 = state_12607__$1;(statearr_12630_12673[(2)] = null);
(statearr_12630_12673[(1)] = (25));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12608 === (19)))
{var inst_12538 = (state_12607[(8)]);var inst_12588 = (state_12607[(11)]);var inst_12590 = cljs.core.async.muxch_STAR_.call(null,inst_12588);var state_12607__$1 = state_12607;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12607__$1,(22),inst_12590,inst_12538);
} else
{if((state_val_12608 === (11)))
{var inst_12548 = (state_12607[(14)]);var inst_12562 = (state_12607[(10)]);var inst_12562__$1 = cljs.core.seq.call(null,inst_12548);var state_12607__$1 = (function (){var statearr_12631 = state_12607;(statearr_12631[(10)] = inst_12562__$1);
return statearr_12631;
})();if(inst_12562__$1)
{var statearr_12632_12674 = state_12607__$1;(statearr_12632_12674[(1)] = (13));
} else
{var statearr_12633_12675 = state_12607__$1;(statearr_12633_12675[(1)] = (14));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12608 === (9)))
{var inst_12584 = (state_12607[(2)]);var state_12607__$1 = state_12607;var statearr_12634_12676 = state_12607__$1;(statearr_12634_12676[(2)] = inst_12584);
(statearr_12634_12676[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12608 === (5)))
{var inst_12545 = cljs.core.deref.call(null,mults);var inst_12546 = cljs.core.vals.call(null,inst_12545);var inst_12547 = cljs.core.seq.call(null,inst_12546);var inst_12548 = inst_12547;var inst_12549 = null;var inst_12550 = (0);var inst_12551 = (0);var state_12607__$1 = (function (){var statearr_12635 = state_12607;(statearr_12635[(12)] = inst_12551);
(statearr_12635[(13)] = inst_12550);
(statearr_12635[(14)] = inst_12548);
(statearr_12635[(15)] = inst_12549);
return statearr_12635;
})();var statearr_12636_12677 = state_12607__$1;(statearr_12636_12677[(2)] = null);
(statearr_12636_12677[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12608 === (14)))
{var state_12607__$1 = state_12607;var statearr_12640_12678 = state_12607__$1;(statearr_12640_12678[(2)] = null);
(statearr_12640_12678[(1)] = (15));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12608 === (16)))
{var inst_12562 = (state_12607[(10)]);var inst_12566 = cljs.core.chunk_first.call(null,inst_12562);var inst_12567 = cljs.core.chunk_rest.call(null,inst_12562);var inst_12568 = cljs.core.count.call(null,inst_12566);var inst_12548 = inst_12567;var inst_12549 = inst_12566;var inst_12550 = inst_12568;var inst_12551 = (0);var state_12607__$1 = (function (){var statearr_12641 = state_12607;(statearr_12641[(12)] = inst_12551);
(statearr_12641[(13)] = inst_12550);
(statearr_12641[(14)] = inst_12548);
(statearr_12641[(15)] = inst_12549);
return statearr_12641;
})();var statearr_12642_12679 = state_12607__$1;(statearr_12642_12679[(2)] = null);
(statearr_12642_12679[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12608 === (10)))
{var inst_12551 = (state_12607[(12)]);var inst_12550 = (state_12607[(13)]);var inst_12548 = (state_12607[(14)]);var inst_12549 = (state_12607[(15)]);var inst_12556 = cljs.core._nth.call(null,inst_12549,inst_12551);var inst_12557 = cljs.core.async.muxch_STAR_.call(null,inst_12556);var inst_12558 = cljs.core.async.close_BANG_.call(null,inst_12557);var inst_12559 = (inst_12551 + (1));var tmp12637 = inst_12550;var tmp12638 = inst_12548;var tmp12639 = inst_12549;var inst_12548__$1 = tmp12638;var inst_12549__$1 = tmp12639;var inst_12550__$1 = tmp12637;var inst_12551__$1 = inst_12559;var state_12607__$1 = (function (){var statearr_12643 = state_12607;(statearr_12643[(12)] = inst_12551__$1);
(statearr_12643[(13)] = inst_12550__$1);
(statearr_12643[(14)] = inst_12548__$1);
(statearr_12643[(17)] = inst_12558);
(statearr_12643[(15)] = inst_12549__$1);
return statearr_12643;
})();var statearr_12644_12680 = state_12607__$1;(statearr_12644_12680[(2)] = null);
(statearr_12644_12680[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12608 === (18)))
{var inst_12577 = (state_12607[(2)]);var state_12607__$1 = state_12607;var statearr_12645_12681 = state_12607__$1;(statearr_12645_12681[(2)] = inst_12577);
(statearr_12645_12681[(1)] = (15));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12608 === (8)))
{var inst_12551 = (state_12607[(12)]);var inst_12550 = (state_12607[(13)]);var inst_12553 = (inst_12551 < inst_12550);var inst_12554 = inst_12553;var state_12607__$1 = state_12607;if(cljs.core.truth_(inst_12554))
{var statearr_12646_12682 = state_12607__$1;(statearr_12646_12682[(1)] = (10));
} else
{var statearr_12647_12683 = state_12607__$1;(statearr_12647_12683[(1)] = (11));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__5915__auto___12655,mults,ensure_mult,p))
;return ((function (switch__5900__auto__,c__5915__auto___12655,mults,ensure_mult,p){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_12651 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_12651[(0)] = state_machine__5901__auto__);
(statearr_12651[(1)] = (1));
return statearr_12651;
});
var state_machine__5901__auto____1 = (function (state_12607){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_12607);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e12652){if((e12652 instanceof Object))
{var ex__5904__auto__ = e12652;var statearr_12653_12684 = state_12607;(statearr_12653_12684[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12607);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e12652;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__12685 = state_12607;
state_12607 = G__12685;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_12607){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_12607);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto___12655,mults,ensure_mult,p))
})();var state__5917__auto__ = (function (){var statearr_12654 = f__5916__auto__.call(null);(statearr_12654[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto___12655);
return statearr_12654;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto___12655,mults,ensure_mult,p))
);
return p;
});
pub = function(ch,topic_fn,buf_fn){
switch(arguments.length){
case 2:
return pub__2.call(this,ch,topic_fn);
case 3:
return pub__3.call(this,ch,topic_fn,buf_fn);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pub.cljs$core$IFn$_invoke$arity$2 = pub__2;
pub.cljs$core$IFn$_invoke$arity$3 = pub__3;
return pub;
})()
;
/**
* Subscribes a channel to a topic of a pub.
* 
* By default the channel will be closed when the source closes,
* but can be determined by the close? parameter.
*/
cljs.core.async.sub = (function() {
var sub = null;
var sub__3 = (function (p,topic,ch){return sub.call(null,p,topic,ch,true);
});
var sub__4 = (function (p,topic,ch,close_QMARK_){return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});
sub = function(p,topic,ch,close_QMARK_){
switch(arguments.length){
case 3:
return sub__3.call(this,p,topic,ch);
case 4:
return sub__4.call(this,p,topic,ch,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
sub.cljs$core$IFn$_invoke$arity$3 = sub__3;
sub.cljs$core$IFn$_invoke$arity$4 = sub__4;
return sub;
})()
;
/**
* Unsubscribes a channel from a topic of a pub
*/
cljs.core.async.unsub = (function unsub(p,topic,ch){return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
* Unsubscribes all channels from a pub, or a topic of a pub
*/
cljs.core.async.unsub_all = (function() {
var unsub_all = null;
var unsub_all__1 = (function (p){return cljs.core.async.unsub_all_STAR_.call(null,p);
});
var unsub_all__2 = (function (p,topic){return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});
unsub_all = function(p,topic){
switch(arguments.length){
case 1:
return unsub_all__1.call(this,p);
case 2:
return unsub_all__2.call(this,p,topic);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unsub_all.cljs$core$IFn$_invoke$arity$1 = unsub_all__1;
unsub_all.cljs$core$IFn$_invoke$arity$2 = unsub_all__2;
return unsub_all;
})()
;
/**
* Takes a function and a collection of source channels, and returns a
* channel which contains the values produced by applying f to the set
* of first items taken from each source channel, followed by applying
* f to the set of second items from each channel, until any one of the
* channels is closed, at which point the output channel will be
* closed. The returned channel will be unbuffered by default, or a
* buf-or-n can be supplied
*/
cljs.core.async.map = (function() {
var map = null;
var map__2 = (function (f,chs){return map.call(null,f,chs,null);
});
var map__3 = (function (f,chs,buf_or_n){var chs__$1 = cljs.core.vec.call(null,chs);var out = cljs.core.async.chan.call(null,buf_or_n);var cnt = cljs.core.count.call(null,chs__$1);var rets = cljs.core.object_array.call(null,cnt);var dchan = cljs.core.async.chan.call(null,(1));var dctr = cljs.core.atom.call(null,null);var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){(rets[i] = ret);
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0)))
{return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else
{return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));var c__5915__auto___12822 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto___12822,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto___12822,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_12792){var state_val_12793 = (state_12792[(1)]);if((state_val_12793 === (7)))
{var state_12792__$1 = state_12792;var statearr_12794_12823 = state_12792__$1;(statearr_12794_12823[(2)] = null);
(statearr_12794_12823[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12793 === (1)))
{var state_12792__$1 = state_12792;var statearr_12795_12824 = state_12792__$1;(statearr_12795_12824[(2)] = null);
(statearr_12795_12824[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12793 === (4)))
{var inst_12756 = (state_12792[(7)]);var inst_12758 = (inst_12756 < cnt);var state_12792__$1 = state_12792;if(cljs.core.truth_(inst_12758))
{var statearr_12796_12825 = state_12792__$1;(statearr_12796_12825[(1)] = (6));
} else
{var statearr_12797_12826 = state_12792__$1;(statearr_12797_12826[(1)] = (7));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12793 === (15)))
{var inst_12788 = (state_12792[(2)]);var state_12792__$1 = state_12792;var statearr_12798_12827 = state_12792__$1;(statearr_12798_12827[(2)] = inst_12788);
(statearr_12798_12827[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12793 === (13)))
{var inst_12781 = cljs.core.async.close_BANG_.call(null,out);var state_12792__$1 = state_12792;var statearr_12799_12828 = state_12792__$1;(statearr_12799_12828[(2)] = inst_12781);
(statearr_12799_12828[(1)] = (15));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12793 === (6)))
{var state_12792__$1 = state_12792;var statearr_12800_12829 = state_12792__$1;(statearr_12800_12829[(2)] = null);
(statearr_12800_12829[(1)] = (11));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12793 === (3)))
{var inst_12790 = (state_12792[(2)]);var state_12792__$1 = state_12792;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12792__$1,inst_12790);
} else
{if((state_val_12793 === (12)))
{var inst_12778 = (state_12792[(8)]);var inst_12778__$1 = (state_12792[(2)]);var inst_12779 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_12778__$1);var state_12792__$1 = (function (){var statearr_12801 = state_12792;(statearr_12801[(8)] = inst_12778__$1);
return statearr_12801;
})();if(cljs.core.truth_(inst_12779))
{var statearr_12802_12830 = state_12792__$1;(statearr_12802_12830[(1)] = (13));
} else
{var statearr_12803_12831 = state_12792__$1;(statearr_12803_12831[(1)] = (14));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12793 === (2)))
{var inst_12755 = cljs.core.reset_BANG_.call(null,dctr,cnt);var inst_12756 = (0);var state_12792__$1 = (function (){var statearr_12804 = state_12792;(statearr_12804[(9)] = inst_12755);
(statearr_12804[(7)] = inst_12756);
return statearr_12804;
})();var statearr_12805_12832 = state_12792__$1;(statearr_12805_12832[(2)] = null);
(statearr_12805_12832[(1)] = (4));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12793 === (11)))
{var inst_12756 = (state_12792[(7)]);var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_12792,(10),Object,null,(9));var inst_12765 = chs__$1.call(null,inst_12756);var inst_12766 = done.call(null,inst_12756);var inst_12767 = cljs.core.async.take_BANG_.call(null,inst_12765,inst_12766);var state_12792__$1 = state_12792;var statearr_12806_12833 = state_12792__$1;(statearr_12806_12833[(2)] = inst_12767);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12792__$1);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12793 === (9)))
{var inst_12756 = (state_12792[(7)]);var inst_12769 = (state_12792[(2)]);var inst_12770 = (inst_12756 + (1));var inst_12756__$1 = inst_12770;var state_12792__$1 = (function (){var statearr_12807 = state_12792;(statearr_12807[(10)] = inst_12769);
(statearr_12807[(7)] = inst_12756__$1);
return statearr_12807;
})();var statearr_12808_12834 = state_12792__$1;(statearr_12808_12834[(2)] = null);
(statearr_12808_12834[(1)] = (4));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12793 === (5)))
{var inst_12776 = (state_12792[(2)]);var state_12792__$1 = (function (){var statearr_12809 = state_12792;(statearr_12809[(11)] = inst_12776);
return statearr_12809;
})();return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12792__$1,(12),dchan);
} else
{if((state_val_12793 === (14)))
{var inst_12778 = (state_12792[(8)]);var inst_12783 = cljs.core.apply.call(null,f,inst_12778);var state_12792__$1 = state_12792;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12792__$1,(16),out,inst_12783);
} else
{if((state_val_12793 === (16)))
{var inst_12785 = (state_12792[(2)]);var state_12792__$1 = (function (){var statearr_12810 = state_12792;(statearr_12810[(12)] = inst_12785);
return statearr_12810;
})();var statearr_12811_12835 = state_12792__$1;(statearr_12811_12835[(2)] = null);
(statearr_12811_12835[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12793 === (10)))
{var inst_12760 = (state_12792[(2)]);var inst_12761 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);var state_12792__$1 = (function (){var statearr_12812 = state_12792;(statearr_12812[(13)] = inst_12760);
return statearr_12812;
})();var statearr_12813_12836 = state_12792__$1;(statearr_12813_12836[(2)] = inst_12761);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12792__$1);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12793 === (8)))
{var inst_12774 = (state_12792[(2)]);var state_12792__$1 = state_12792;var statearr_12814_12837 = state_12792__$1;(statearr_12814_12837[(2)] = inst_12774);
(statearr_12814_12837[(1)] = (5));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__5915__auto___12822,chs__$1,out,cnt,rets,dchan,dctr,done))
;return ((function (switch__5900__auto__,c__5915__auto___12822,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_12818 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_12818[(0)] = state_machine__5901__auto__);
(statearr_12818[(1)] = (1));
return statearr_12818;
});
var state_machine__5901__auto____1 = (function (state_12792){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_12792);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e12819){if((e12819 instanceof Object))
{var ex__5904__auto__ = e12819;var statearr_12820_12838 = state_12792;(statearr_12820_12838[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12792);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e12819;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__12839 = state_12792;
state_12792 = G__12839;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_12792){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_12792);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto___12822,chs__$1,out,cnt,rets,dchan,dctr,done))
})();var state__5917__auto__ = (function (){var statearr_12821 = f__5916__auto__.call(null);(statearr_12821[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto___12822);
return statearr_12821;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto___12822,chs__$1,out,cnt,rets,dchan,dctr,done))
);
return out;
});
map = function(f,chs,buf_or_n){
switch(arguments.length){
case 2:
return map__2.call(this,f,chs);
case 3:
return map__3.call(this,f,chs,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
map.cljs$core$IFn$_invoke$arity$2 = map__2;
map.cljs$core$IFn$_invoke$arity$3 = map__3;
return map;
})()
;
/**
* Takes a collection of source channels and returns a channel which
* contains all values taken from them. The returned channel will be
* unbuffered by default, or a buf-or-n can be supplied. The channel
* will close after all the source channels have closed.
*/
cljs.core.async.merge = (function() {
var merge = null;
var merge__1 = (function (chs){return merge.call(null,chs,null);
});
var merge__2 = (function (chs,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__5915__auto___12947 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto___12947,out){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto___12947,out){
return (function (state_12923){var state_val_12924 = (state_12923[(1)]);if((state_val_12924 === (7)))
{var inst_12903 = (state_12923[(7)]);var inst_12902 = (state_12923[(8)]);var inst_12902__$1 = (state_12923[(2)]);var inst_12903__$1 = cljs.core.nth.call(null,inst_12902__$1,(0),null);var inst_12904 = cljs.core.nth.call(null,inst_12902__$1,(1),null);var inst_12905 = (inst_12903__$1 == null);var state_12923__$1 = (function (){var statearr_12925 = state_12923;(statearr_12925[(7)] = inst_12903__$1);
(statearr_12925[(9)] = inst_12904);
(statearr_12925[(8)] = inst_12902__$1);
return statearr_12925;
})();if(cljs.core.truth_(inst_12905))
{var statearr_12926_12948 = state_12923__$1;(statearr_12926_12948[(1)] = (8));
} else
{var statearr_12927_12949 = state_12923__$1;(statearr_12927_12949[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12924 === (1)))
{var inst_12894 = cljs.core.vec.call(null,chs);var inst_12895 = inst_12894;var state_12923__$1 = (function (){var statearr_12928 = state_12923;(statearr_12928[(10)] = inst_12895);
return statearr_12928;
})();var statearr_12929_12950 = state_12923__$1;(statearr_12929_12950[(2)] = null);
(statearr_12929_12950[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12924 === (4)))
{var inst_12895 = (state_12923[(10)]);var state_12923__$1 = state_12923;return cljs.core.async.ioc_alts_BANG_.call(null,state_12923__$1,(7),inst_12895);
} else
{if((state_val_12924 === (6)))
{var inst_12919 = (state_12923[(2)]);var state_12923__$1 = state_12923;var statearr_12930_12951 = state_12923__$1;(statearr_12930_12951[(2)] = inst_12919);
(statearr_12930_12951[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12924 === (3)))
{var inst_12921 = (state_12923[(2)]);var state_12923__$1 = state_12923;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12923__$1,inst_12921);
} else
{if((state_val_12924 === (2)))
{var inst_12895 = (state_12923[(10)]);var inst_12897 = cljs.core.count.call(null,inst_12895);var inst_12898 = (inst_12897 > (0));var state_12923__$1 = state_12923;if(cljs.core.truth_(inst_12898))
{var statearr_12932_12952 = state_12923__$1;(statearr_12932_12952[(1)] = (4));
} else
{var statearr_12933_12953 = state_12923__$1;(statearr_12933_12953[(1)] = (5));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12924 === (11)))
{var inst_12895 = (state_12923[(10)]);var inst_12912 = (state_12923[(2)]);var tmp12931 = inst_12895;var inst_12895__$1 = tmp12931;var state_12923__$1 = (function (){var statearr_12934 = state_12923;(statearr_12934[(10)] = inst_12895__$1);
(statearr_12934[(11)] = inst_12912);
return statearr_12934;
})();var statearr_12935_12954 = state_12923__$1;(statearr_12935_12954[(2)] = null);
(statearr_12935_12954[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12924 === (9)))
{var inst_12903 = (state_12923[(7)]);var state_12923__$1 = state_12923;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12923__$1,(11),out,inst_12903);
} else
{if((state_val_12924 === (5)))
{var inst_12917 = cljs.core.async.close_BANG_.call(null,out);var state_12923__$1 = state_12923;var statearr_12936_12955 = state_12923__$1;(statearr_12936_12955[(2)] = inst_12917);
(statearr_12936_12955[(1)] = (6));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12924 === (10)))
{var inst_12915 = (state_12923[(2)]);var state_12923__$1 = state_12923;var statearr_12937_12956 = state_12923__$1;(statearr_12937_12956[(2)] = inst_12915);
(statearr_12937_12956[(1)] = (6));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12924 === (8)))
{var inst_12895 = (state_12923[(10)]);var inst_12903 = (state_12923[(7)]);var inst_12904 = (state_12923[(9)]);var inst_12902 = (state_12923[(8)]);var inst_12907 = (function (){var c = inst_12904;var v = inst_12903;var vec__12900 = inst_12902;var cs = inst_12895;return ((function (c,v,vec__12900,cs,inst_12895,inst_12903,inst_12904,inst_12902,state_val_12924,c__5915__auto___12947,out){
return (function (p1__12840_SHARP_){return cljs.core.not_EQ_.call(null,c,p1__12840_SHARP_);
});
;})(c,v,vec__12900,cs,inst_12895,inst_12903,inst_12904,inst_12902,state_val_12924,c__5915__auto___12947,out))
})();var inst_12908 = cljs.core.filterv.call(null,inst_12907,inst_12895);var inst_12895__$1 = inst_12908;var state_12923__$1 = (function (){var statearr_12938 = state_12923;(statearr_12938[(10)] = inst_12895__$1);
return statearr_12938;
})();var statearr_12939_12957 = state_12923__$1;(statearr_12939_12957[(2)] = null);
(statearr_12939_12957[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__5915__auto___12947,out))
;return ((function (switch__5900__auto__,c__5915__auto___12947,out){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_12943 = [null,null,null,null,null,null,null,null,null,null,null,null];(statearr_12943[(0)] = state_machine__5901__auto__);
(statearr_12943[(1)] = (1));
return statearr_12943;
});
var state_machine__5901__auto____1 = (function (state_12923){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_12923);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e12944){if((e12944 instanceof Object))
{var ex__5904__auto__ = e12944;var statearr_12945_12958 = state_12923;(statearr_12945_12958[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12923);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e12944;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__12959 = state_12923;
state_12923 = G__12959;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_12923){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_12923);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto___12947,out))
})();var state__5917__auto__ = (function (){var statearr_12946 = f__5916__auto__.call(null);(statearr_12946[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto___12947);
return statearr_12946;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto___12947,out))
);
return out;
});
merge = function(chs,buf_or_n){
switch(arguments.length){
case 1:
return merge__1.call(this,chs);
case 2:
return merge__2.call(this,chs,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
merge.cljs$core$IFn$_invoke$arity$1 = merge__1;
merge.cljs$core$IFn$_invoke$arity$2 = merge__2;
return merge;
})()
;
/**
* Returns a channel containing the single (collection) result of the
* items taken from the channel conjoined to the supplied
* collection. ch must close before into produces a result.
*/
cljs.core.async.into = (function into(coll,ch){return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
* Returns a channel that will return, at most, n items from ch. After n items
* have been returned, or ch has been closed, the return chanel will close.
* 
* The output channel is unbuffered by default, unless buf-or-n is given.
*/
cljs.core.async.take = (function() {
var take = null;
var take__2 = (function (n,ch){return take.call(null,n,ch,null);
});
var take__3 = (function (n,ch,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__5915__auto___13052 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto___13052,out){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto___13052,out){
return (function (state_13029){var state_val_13030 = (state_13029[(1)]);if((state_val_13030 === (7)))
{var inst_13011 = (state_13029[(7)]);var inst_13011__$1 = (state_13029[(2)]);var inst_13012 = (inst_13011__$1 == null);var inst_13013 = cljs.core.not.call(null,inst_13012);var state_13029__$1 = (function (){var statearr_13031 = state_13029;(statearr_13031[(7)] = inst_13011__$1);
return statearr_13031;
})();if(inst_13013)
{var statearr_13032_13053 = state_13029__$1;(statearr_13032_13053[(1)] = (8));
} else
{var statearr_13033_13054 = state_13029__$1;(statearr_13033_13054[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13030 === (1)))
{var inst_13006 = (0);var state_13029__$1 = (function (){var statearr_13034 = state_13029;(statearr_13034[(8)] = inst_13006);
return statearr_13034;
})();var statearr_13035_13055 = state_13029__$1;(statearr_13035_13055[(2)] = null);
(statearr_13035_13055[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13030 === (4)))
{var state_13029__$1 = state_13029;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13029__$1,(7),ch);
} else
{if((state_val_13030 === (6)))
{var inst_13024 = (state_13029[(2)]);var state_13029__$1 = state_13029;var statearr_13036_13056 = state_13029__$1;(statearr_13036_13056[(2)] = inst_13024);
(statearr_13036_13056[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13030 === (3)))
{var inst_13026 = (state_13029[(2)]);var inst_13027 = cljs.core.async.close_BANG_.call(null,out);var state_13029__$1 = (function (){var statearr_13037 = state_13029;(statearr_13037[(9)] = inst_13026);
return statearr_13037;
})();return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13029__$1,inst_13027);
} else
{if((state_val_13030 === (2)))
{var inst_13006 = (state_13029[(8)]);var inst_13008 = (inst_13006 < n);var state_13029__$1 = state_13029;if(cljs.core.truth_(inst_13008))
{var statearr_13038_13057 = state_13029__$1;(statearr_13038_13057[(1)] = (4));
} else
{var statearr_13039_13058 = state_13029__$1;(statearr_13039_13058[(1)] = (5));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13030 === (11)))
{var inst_13006 = (state_13029[(8)]);var inst_13016 = (state_13029[(2)]);var inst_13017 = (inst_13006 + (1));var inst_13006__$1 = inst_13017;var state_13029__$1 = (function (){var statearr_13040 = state_13029;(statearr_13040[(10)] = inst_13016);
(statearr_13040[(8)] = inst_13006__$1);
return statearr_13040;
})();var statearr_13041_13059 = state_13029__$1;(statearr_13041_13059[(2)] = null);
(statearr_13041_13059[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13030 === (9)))
{var state_13029__$1 = state_13029;var statearr_13042_13060 = state_13029__$1;(statearr_13042_13060[(2)] = null);
(statearr_13042_13060[(1)] = (10));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13030 === (5)))
{var state_13029__$1 = state_13029;var statearr_13043_13061 = state_13029__$1;(statearr_13043_13061[(2)] = null);
(statearr_13043_13061[(1)] = (6));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13030 === (10)))
{var inst_13021 = (state_13029[(2)]);var state_13029__$1 = state_13029;var statearr_13044_13062 = state_13029__$1;(statearr_13044_13062[(2)] = inst_13021);
(statearr_13044_13062[(1)] = (6));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13030 === (8)))
{var inst_13011 = (state_13029[(7)]);var state_13029__$1 = state_13029;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13029__$1,(11),out,inst_13011);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__5915__auto___13052,out))
;return ((function (switch__5900__auto__,c__5915__auto___13052,out){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_13048 = [null,null,null,null,null,null,null,null,null,null,null];(statearr_13048[(0)] = state_machine__5901__auto__);
(statearr_13048[(1)] = (1));
return statearr_13048;
});
var state_machine__5901__auto____1 = (function (state_13029){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_13029);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e13049){if((e13049 instanceof Object))
{var ex__5904__auto__ = e13049;var statearr_13050_13063 = state_13029;(statearr_13050_13063[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13029);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e13049;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__13064 = state_13029;
state_13029 = G__13064;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_13029){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_13029);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto___13052,out))
})();var state__5917__auto__ = (function (){var statearr_13051 = f__5916__auto__.call(null);(statearr_13051[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto___13052);
return statearr_13051;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto___13052,out))
);
return out;
});
take = function(n,ch,buf_or_n){
switch(arguments.length){
case 2:
return take__2.call(this,n,ch);
case 3:
return take__3.call(this,n,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
take.cljs$core$IFn$_invoke$arity$2 = take__2;
take.cljs$core$IFn$_invoke$arity$3 = take__3;
return take;
})()
;
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.map_LT_ = (function map_LT_(f,ch){if(typeof cljs.core.async.t13072 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t13072 = (function (ch,f,map_LT_,meta13073){
this.ch = ch;
this.f = f;
this.map_LT_ = map_LT_;
this.meta13073 = meta13073;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t13072.cljs$lang$type = true;
cljs.core.async.t13072.cljs$lang$ctorStr = "cljs.core.async/t13072";
cljs.core.async.t13072.cljs$lang$ctorPrWriter = (function (this__4225__auto__,writer__4226__auto__,opt__4227__auto__){return cljs.core._write.call(null,writer__4226__auto__,"cljs.core.async/t13072");
});
cljs.core.async.t13072.prototype.cljs$core$async$impl$protocols$WritePort$ = true;
cljs.core.async.t13072.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});
cljs.core.async.t13072.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;
cljs.core.async.t13072.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){var self__ = this;
var ___$1 = this;var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){if(typeof cljs.core.async.t13075 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t13075 = (function (fn1,_,meta13073,ch,f,map_LT_,meta13076){
this.fn1 = fn1;
this._ = _;
this.meta13073 = meta13073;
this.ch = ch;
this.f = f;
this.map_LT_ = map_LT_;
this.meta13076 = meta13076;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t13075.cljs$lang$type = true;
cljs.core.async.t13075.cljs$lang$ctorStr = "cljs.core.async/t13075";
cljs.core.async.t13075.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__4225__auto__,writer__4226__auto__,opt__4227__auto__){return cljs.core._write.call(null,writer__4226__auto__,"cljs.core.async/t13075");
});})(___$1))
;
cljs.core.async.t13075.prototype.cljs$core$async$impl$protocols$Handler$ = true;
cljs.core.async.t13075.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$3){var self__ = this;
var ___$4 = this;return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;
cljs.core.async.t13075.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$3){var self__ = this;
var ___$4 = this;var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);return ((function (f1,___$4,___$1){
return (function (p1__13065_SHARP_){return f1.call(null,(((p1__13065_SHARP_ == null))?null:self__.f.call(null,p1__13065_SHARP_)));
});
;})(f1,___$4,___$1))
});})(___$1))
;
cljs.core.async.t13075.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_13077){var self__ = this;
var _13077__$1 = this;return self__.meta13076;
});})(___$1))
;
cljs.core.async.t13075.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_13077,meta13076__$1){var self__ = this;
var _13077__$1 = this;return (new cljs.core.async.t13075(self__.fn1,self__._,self__.meta13073,self__.ch,self__.f,self__.map_LT_,meta13076__$1));
});})(___$1))
;
cljs.core.async.__GT_t13075 = ((function (___$1){
return (function __GT_t13075(fn1__$1,___$2,meta13073__$1,ch__$2,f__$2,map_LT___$2,meta13076){return (new cljs.core.async.t13075(fn1__$1,___$2,meta13073__$1,ch__$2,f__$2,map_LT___$2,meta13076));
});})(___$1))
;
}
return (new cljs.core.async.t13075(fn1,___$1,self__.meta13073,self__.ch,self__.f,self__.map_LT_,null));
})());if(cljs.core.truth_((function (){var and__3636__auto__ = ret;if(cljs.core.truth_(and__3636__auto__))
{return !((cljs.core.deref.call(null,ret) == null));
} else
{return and__3636__auto__;
}
})()))
{return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else
{return ret;
}
});
cljs.core.async.t13072.prototype.cljs$core$async$impl$protocols$Channel$ = true;
cljs.core.async.t13072.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});
cljs.core.async.t13072.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});
cljs.core.async.t13072.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13074){var self__ = this;
var _13074__$1 = this;return self__.meta13073;
});
cljs.core.async.t13072.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13074,meta13073__$1){var self__ = this;
var _13074__$1 = this;return (new cljs.core.async.t13072(self__.ch,self__.f,self__.map_LT_,meta13073__$1));
});
cljs.core.async.__GT_t13072 = (function __GT_t13072(ch__$1,f__$1,map_LT___$1,meta13073){return (new cljs.core.async.t13072(ch__$1,f__$1,map_LT___$1,meta13073));
});
}
return (new cljs.core.async.t13072(ch,f,map_LT_,null));
});
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.map_GT_ = (function map_GT_(f,ch){if(typeof cljs.core.async.t13081 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t13081 = (function (ch,f,map_GT_,meta13082){
this.ch = ch;
this.f = f;
this.map_GT_ = map_GT_;
this.meta13082 = meta13082;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t13081.cljs$lang$type = true;
cljs.core.async.t13081.cljs$lang$ctorStr = "cljs.core.async/t13081";
cljs.core.async.t13081.cljs$lang$ctorPrWriter = (function (this__4225__auto__,writer__4226__auto__,opt__4227__auto__){return cljs.core._write.call(null,writer__4226__auto__,"cljs.core.async/t13081");
});
cljs.core.async.t13081.prototype.cljs$core$async$impl$protocols$WritePort$ = true;
cljs.core.async.t13081.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});
cljs.core.async.t13081.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;
cljs.core.async.t13081.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});
cljs.core.async.t13081.prototype.cljs$core$async$impl$protocols$Channel$ = true;
cljs.core.async.t13081.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});
cljs.core.async.t13081.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13083){var self__ = this;
var _13083__$1 = this;return self__.meta13082;
});
cljs.core.async.t13081.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13083,meta13082__$1){var self__ = this;
var _13083__$1 = this;return (new cljs.core.async.t13081(self__.ch,self__.f,self__.map_GT_,meta13082__$1));
});
cljs.core.async.__GT_t13081 = (function __GT_t13081(ch__$1,f__$1,map_GT___$1,meta13082){return (new cljs.core.async.t13081(ch__$1,f__$1,map_GT___$1,meta13082));
});
}
return (new cljs.core.async.t13081(ch,f,map_GT_,null));
});
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.filter_GT_ = (function filter_GT_(p,ch){if(typeof cljs.core.async.t13087 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t13087 = (function (ch,p,filter_GT_,meta13088){
this.ch = ch;
this.p = p;
this.filter_GT_ = filter_GT_;
this.meta13088 = meta13088;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t13087.cljs$lang$type = true;
cljs.core.async.t13087.cljs$lang$ctorStr = "cljs.core.async/t13087";
cljs.core.async.t13087.cljs$lang$ctorPrWriter = (function (this__4225__auto__,writer__4226__auto__,opt__4227__auto__){return cljs.core._write.call(null,writer__4226__auto__,"cljs.core.async/t13087");
});
cljs.core.async.t13087.prototype.cljs$core$async$impl$protocols$WritePort$ = true;
cljs.core.async.t13087.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){var self__ = this;
var ___$1 = this;if(cljs.core.truth_(self__.p.call(null,val)))
{return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else
{return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});
cljs.core.async.t13087.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;
cljs.core.async.t13087.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});
cljs.core.async.t13087.prototype.cljs$core$async$impl$protocols$Channel$ = true;
cljs.core.async.t13087.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});
cljs.core.async.t13087.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});
cljs.core.async.t13087.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13089){var self__ = this;
var _13089__$1 = this;return self__.meta13088;
});
cljs.core.async.t13087.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13089,meta13088__$1){var self__ = this;
var _13089__$1 = this;return (new cljs.core.async.t13087(self__.ch,self__.p,self__.filter_GT_,meta13088__$1));
});
cljs.core.async.__GT_t13087 = (function __GT_t13087(ch__$1,p__$1,filter_GT___$1,meta13088){return (new cljs.core.async.t13087(ch__$1,p__$1,filter_GT___$1,meta13088));
});
}
return (new cljs.core.async.t13087(ch,p,filter_GT_,null));
});
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.remove_GT_ = (function remove_GT_(p,ch){return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.filter_LT_ = (function() {
var filter_LT_ = null;
var filter_LT___2 = (function (p,ch){return filter_LT_.call(null,p,ch,null);
});
var filter_LT___3 = (function (p,ch,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__5915__auto___13172 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto___13172,out){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto___13172,out){
return (function (state_13151){var state_val_13152 = (state_13151[(1)]);if((state_val_13152 === (7)))
{var inst_13147 = (state_13151[(2)]);var state_13151__$1 = state_13151;var statearr_13153_13173 = state_13151__$1;(statearr_13153_13173[(2)] = inst_13147);
(statearr_13153_13173[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13152 === (1)))
{var state_13151__$1 = state_13151;var statearr_13154_13174 = state_13151__$1;(statearr_13154_13174[(2)] = null);
(statearr_13154_13174[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13152 === (4)))
{var inst_13133 = (state_13151[(7)]);var inst_13133__$1 = (state_13151[(2)]);var inst_13134 = (inst_13133__$1 == null);var state_13151__$1 = (function (){var statearr_13155 = state_13151;(statearr_13155[(7)] = inst_13133__$1);
return statearr_13155;
})();if(cljs.core.truth_(inst_13134))
{var statearr_13156_13175 = state_13151__$1;(statearr_13156_13175[(1)] = (5));
} else
{var statearr_13157_13176 = state_13151__$1;(statearr_13157_13176[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13152 === (6)))
{var inst_13133 = (state_13151[(7)]);var inst_13138 = p.call(null,inst_13133);var state_13151__$1 = state_13151;if(cljs.core.truth_(inst_13138))
{var statearr_13158_13177 = state_13151__$1;(statearr_13158_13177[(1)] = (8));
} else
{var statearr_13159_13178 = state_13151__$1;(statearr_13159_13178[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13152 === (3)))
{var inst_13149 = (state_13151[(2)]);var state_13151__$1 = state_13151;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13151__$1,inst_13149);
} else
{if((state_val_13152 === (2)))
{var state_13151__$1 = state_13151;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13151__$1,(4),ch);
} else
{if((state_val_13152 === (11)))
{var inst_13141 = (state_13151[(2)]);var state_13151__$1 = state_13151;var statearr_13160_13179 = state_13151__$1;(statearr_13160_13179[(2)] = inst_13141);
(statearr_13160_13179[(1)] = (10));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13152 === (9)))
{var state_13151__$1 = state_13151;var statearr_13161_13180 = state_13151__$1;(statearr_13161_13180[(2)] = null);
(statearr_13161_13180[(1)] = (10));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13152 === (5)))
{var inst_13136 = cljs.core.async.close_BANG_.call(null,out);var state_13151__$1 = state_13151;var statearr_13162_13181 = state_13151__$1;(statearr_13162_13181[(2)] = inst_13136);
(statearr_13162_13181[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13152 === (10)))
{var inst_13144 = (state_13151[(2)]);var state_13151__$1 = (function (){var statearr_13163 = state_13151;(statearr_13163[(8)] = inst_13144);
return statearr_13163;
})();var statearr_13164_13182 = state_13151__$1;(statearr_13164_13182[(2)] = null);
(statearr_13164_13182[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13152 === (8)))
{var inst_13133 = (state_13151[(7)]);var state_13151__$1 = state_13151;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13151__$1,(11),out,inst_13133);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__5915__auto___13172,out))
;return ((function (switch__5900__auto__,c__5915__auto___13172,out){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_13168 = [null,null,null,null,null,null,null,null,null];(statearr_13168[(0)] = state_machine__5901__auto__);
(statearr_13168[(1)] = (1));
return statearr_13168;
});
var state_machine__5901__auto____1 = (function (state_13151){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_13151);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e13169){if((e13169 instanceof Object))
{var ex__5904__auto__ = e13169;var statearr_13170_13183 = state_13151;(statearr_13170_13183[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13151);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e13169;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__13184 = state_13151;
state_13151 = G__13184;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_13151){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_13151);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto___13172,out))
})();var state__5917__auto__ = (function (){var statearr_13171 = f__5916__auto__.call(null);(statearr_13171[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto___13172);
return statearr_13171;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto___13172,out))
);
return out;
});
filter_LT_ = function(p,ch,buf_or_n){
switch(arguments.length){
case 2:
return filter_LT___2.call(this,p,ch);
case 3:
return filter_LT___3.call(this,p,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
filter_LT_.cljs$core$IFn$_invoke$arity$2 = filter_LT___2;
filter_LT_.cljs$core$IFn$_invoke$arity$3 = filter_LT___3;
return filter_LT_;
})()
;
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.remove_LT_ = (function() {
var remove_LT_ = null;
var remove_LT___2 = (function (p,ch){return remove_LT_.call(null,p,ch,null);
});
var remove_LT___3 = (function (p,ch,buf_or_n){return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});
remove_LT_ = function(p,ch,buf_or_n){
switch(arguments.length){
case 2:
return remove_LT___2.call(this,p,ch);
case 3:
return remove_LT___3.call(this,p,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
remove_LT_.cljs$core$IFn$_invoke$arity$2 = remove_LT___2;
remove_LT_.cljs$core$IFn$_invoke$arity$3 = remove_LT___3;
return remove_LT_;
})()
;
cljs.core.async.mapcat_STAR_ = (function mapcat_STAR_(f,in$,out){var c__5915__auto__ = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto__){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto__){
return (function (state_13350){var state_val_13351 = (state_13350[(1)]);if((state_val_13351 === (7)))
{var inst_13346 = (state_13350[(2)]);var state_13350__$1 = state_13350;var statearr_13352_13393 = state_13350__$1;(statearr_13352_13393[(2)] = inst_13346);
(statearr_13352_13393[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13351 === (20)))
{var inst_13316 = (state_13350[(7)]);var inst_13327 = (state_13350[(2)]);var inst_13328 = cljs.core.next.call(null,inst_13316);var inst_13302 = inst_13328;var inst_13303 = null;var inst_13304 = (0);var inst_13305 = (0);var state_13350__$1 = (function (){var statearr_13353 = state_13350;(statearr_13353[(8)] = inst_13305);
(statearr_13353[(9)] = inst_13302);
(statearr_13353[(10)] = inst_13304);
(statearr_13353[(11)] = inst_13327);
(statearr_13353[(12)] = inst_13303);
return statearr_13353;
})();var statearr_13354_13394 = state_13350__$1;(statearr_13354_13394[(2)] = null);
(statearr_13354_13394[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13351 === (1)))
{var state_13350__$1 = state_13350;var statearr_13355_13395 = state_13350__$1;(statearr_13355_13395[(2)] = null);
(statearr_13355_13395[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13351 === (4)))
{var inst_13291 = (state_13350[(13)]);var inst_13291__$1 = (state_13350[(2)]);var inst_13292 = (inst_13291__$1 == null);var state_13350__$1 = (function (){var statearr_13356 = state_13350;(statearr_13356[(13)] = inst_13291__$1);
return statearr_13356;
})();if(cljs.core.truth_(inst_13292))
{var statearr_13357_13396 = state_13350__$1;(statearr_13357_13396[(1)] = (5));
} else
{var statearr_13358_13397 = state_13350__$1;(statearr_13358_13397[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13351 === (15)))
{var state_13350__$1 = state_13350;var statearr_13362_13398 = state_13350__$1;(statearr_13362_13398[(2)] = null);
(statearr_13362_13398[(1)] = (16));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13351 === (21)))
{var state_13350__$1 = state_13350;var statearr_13363_13399 = state_13350__$1;(statearr_13363_13399[(2)] = null);
(statearr_13363_13399[(1)] = (23));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13351 === (13)))
{var inst_13305 = (state_13350[(8)]);var inst_13302 = (state_13350[(9)]);var inst_13304 = (state_13350[(10)]);var inst_13303 = (state_13350[(12)]);var inst_13312 = (state_13350[(2)]);var inst_13313 = (inst_13305 + (1));var tmp13359 = inst_13302;var tmp13360 = inst_13304;var tmp13361 = inst_13303;var inst_13302__$1 = tmp13359;var inst_13303__$1 = tmp13361;var inst_13304__$1 = tmp13360;var inst_13305__$1 = inst_13313;var state_13350__$1 = (function (){var statearr_13364 = state_13350;(statearr_13364[(14)] = inst_13312);
(statearr_13364[(8)] = inst_13305__$1);
(statearr_13364[(9)] = inst_13302__$1);
(statearr_13364[(10)] = inst_13304__$1);
(statearr_13364[(12)] = inst_13303__$1);
return statearr_13364;
})();var statearr_13365_13400 = state_13350__$1;(statearr_13365_13400[(2)] = null);
(statearr_13365_13400[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13351 === (22)))
{var state_13350__$1 = state_13350;var statearr_13366_13401 = state_13350__$1;(statearr_13366_13401[(2)] = null);
(statearr_13366_13401[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13351 === (6)))
{var inst_13291 = (state_13350[(13)]);var inst_13300 = f.call(null,inst_13291);var inst_13301 = cljs.core.seq.call(null,inst_13300);var inst_13302 = inst_13301;var inst_13303 = null;var inst_13304 = (0);var inst_13305 = (0);var state_13350__$1 = (function (){var statearr_13367 = state_13350;(statearr_13367[(8)] = inst_13305);
(statearr_13367[(9)] = inst_13302);
(statearr_13367[(10)] = inst_13304);
(statearr_13367[(12)] = inst_13303);
return statearr_13367;
})();var statearr_13368_13402 = state_13350__$1;(statearr_13368_13402[(2)] = null);
(statearr_13368_13402[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13351 === (17)))
{var inst_13316 = (state_13350[(7)]);var inst_13320 = cljs.core.chunk_first.call(null,inst_13316);var inst_13321 = cljs.core.chunk_rest.call(null,inst_13316);var inst_13322 = cljs.core.count.call(null,inst_13320);var inst_13302 = inst_13321;var inst_13303 = inst_13320;var inst_13304 = inst_13322;var inst_13305 = (0);var state_13350__$1 = (function (){var statearr_13369 = state_13350;(statearr_13369[(8)] = inst_13305);
(statearr_13369[(9)] = inst_13302);
(statearr_13369[(10)] = inst_13304);
(statearr_13369[(12)] = inst_13303);
return statearr_13369;
})();var statearr_13370_13403 = state_13350__$1;(statearr_13370_13403[(2)] = null);
(statearr_13370_13403[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13351 === (3)))
{var inst_13348 = (state_13350[(2)]);var state_13350__$1 = state_13350;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13350__$1,inst_13348);
} else
{if((state_val_13351 === (12)))
{var inst_13336 = (state_13350[(2)]);var state_13350__$1 = state_13350;var statearr_13371_13404 = state_13350__$1;(statearr_13371_13404[(2)] = inst_13336);
(statearr_13371_13404[(1)] = (9));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13351 === (2)))
{var state_13350__$1 = state_13350;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13350__$1,(4),in$);
} else
{if((state_val_13351 === (23)))
{var inst_13344 = (state_13350[(2)]);var state_13350__$1 = state_13350;var statearr_13372_13405 = state_13350__$1;(statearr_13372_13405[(2)] = inst_13344);
(statearr_13372_13405[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13351 === (19)))
{var inst_13331 = (state_13350[(2)]);var state_13350__$1 = state_13350;var statearr_13373_13406 = state_13350__$1;(statearr_13373_13406[(2)] = inst_13331);
(statearr_13373_13406[(1)] = (16));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13351 === (11)))
{var inst_13302 = (state_13350[(9)]);var inst_13316 = (state_13350[(7)]);var inst_13316__$1 = cljs.core.seq.call(null,inst_13302);var state_13350__$1 = (function (){var statearr_13374 = state_13350;(statearr_13374[(7)] = inst_13316__$1);
return statearr_13374;
})();if(inst_13316__$1)
{var statearr_13375_13407 = state_13350__$1;(statearr_13375_13407[(1)] = (14));
} else
{var statearr_13376_13408 = state_13350__$1;(statearr_13376_13408[(1)] = (15));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13351 === (9)))
{var inst_13338 = (state_13350[(2)]);var inst_13339 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);var state_13350__$1 = (function (){var statearr_13377 = state_13350;(statearr_13377[(15)] = inst_13338);
return statearr_13377;
})();if(cljs.core.truth_(inst_13339))
{var statearr_13378_13409 = state_13350__$1;(statearr_13378_13409[(1)] = (21));
} else
{var statearr_13379_13410 = state_13350__$1;(statearr_13379_13410[(1)] = (22));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13351 === (5)))
{var inst_13294 = cljs.core.async.close_BANG_.call(null,out);var state_13350__$1 = state_13350;var statearr_13380_13411 = state_13350__$1;(statearr_13380_13411[(2)] = inst_13294);
(statearr_13380_13411[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13351 === (14)))
{var inst_13316 = (state_13350[(7)]);var inst_13318 = cljs.core.chunked_seq_QMARK_.call(null,inst_13316);var state_13350__$1 = state_13350;if(inst_13318)
{var statearr_13381_13412 = state_13350__$1;(statearr_13381_13412[(1)] = (17));
} else
{var statearr_13382_13413 = state_13350__$1;(statearr_13382_13413[(1)] = (18));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13351 === (16)))
{var inst_13334 = (state_13350[(2)]);var state_13350__$1 = state_13350;var statearr_13383_13414 = state_13350__$1;(statearr_13383_13414[(2)] = inst_13334);
(statearr_13383_13414[(1)] = (12));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13351 === (10)))
{var inst_13305 = (state_13350[(8)]);var inst_13303 = (state_13350[(12)]);var inst_13310 = cljs.core._nth.call(null,inst_13303,inst_13305);var state_13350__$1 = state_13350;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13350__$1,(13),out,inst_13310);
} else
{if((state_val_13351 === (18)))
{var inst_13316 = (state_13350[(7)]);var inst_13325 = cljs.core.first.call(null,inst_13316);var state_13350__$1 = state_13350;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13350__$1,(20),out,inst_13325);
} else
{if((state_val_13351 === (8)))
{var inst_13305 = (state_13350[(8)]);var inst_13304 = (state_13350[(10)]);var inst_13307 = (inst_13305 < inst_13304);var inst_13308 = inst_13307;var state_13350__$1 = state_13350;if(cljs.core.truth_(inst_13308))
{var statearr_13384_13415 = state_13350__$1;(statearr_13384_13415[(1)] = (10));
} else
{var statearr_13385_13416 = state_13350__$1;(statearr_13385_13416[(1)] = (11));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__5915__auto__))
;return ((function (switch__5900__auto__,c__5915__auto__){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_13389 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_13389[(0)] = state_machine__5901__auto__);
(statearr_13389[(1)] = (1));
return statearr_13389;
});
var state_machine__5901__auto____1 = (function (state_13350){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_13350);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e13390){if((e13390 instanceof Object))
{var ex__5904__auto__ = e13390;var statearr_13391_13417 = state_13350;(statearr_13391_13417[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13350);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e13390;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__13418 = state_13350;
state_13350 = G__13418;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_13350){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_13350);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto__))
})();var state__5917__auto__ = (function (){var statearr_13392 = f__5916__auto__.call(null);(statearr_13392[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto__);
return statearr_13392;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto__))
);
return c__5915__auto__;
});
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.mapcat_LT_ = (function() {
var mapcat_LT_ = null;
var mapcat_LT___2 = (function (f,in$){return mapcat_LT_.call(null,f,in$,null);
});
var mapcat_LT___3 = (function (f,in$,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);cljs.core.async.mapcat_STAR_.call(null,f,in$,out);
return out;
});
mapcat_LT_ = function(f,in$,buf_or_n){
switch(arguments.length){
case 2:
return mapcat_LT___2.call(this,f,in$);
case 3:
return mapcat_LT___3.call(this,f,in$,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = mapcat_LT___2;
mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = mapcat_LT___3;
return mapcat_LT_;
})()
;
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.mapcat_GT_ = (function() {
var mapcat_GT_ = null;
var mapcat_GT___2 = (function (f,out){return mapcat_GT_.call(null,f,out,null);
});
var mapcat_GT___3 = (function (f,out,buf_or_n){var in$ = cljs.core.async.chan.call(null,buf_or_n);cljs.core.async.mapcat_STAR_.call(null,f,in$,out);
return in$;
});
mapcat_GT_ = function(f,out,buf_or_n){
switch(arguments.length){
case 2:
return mapcat_GT___2.call(this,f,out);
case 3:
return mapcat_GT___3.call(this,f,out,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = mapcat_GT___2;
mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = mapcat_GT___3;
return mapcat_GT_;
})()
;
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.unique = (function() {
var unique = null;
var unique__1 = (function (ch){return unique.call(null,ch,null);
});
var unique__2 = (function (ch,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__5915__auto___13515 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto___13515,out){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto___13515,out){
return (function (state_13490){var state_val_13491 = (state_13490[(1)]);if((state_val_13491 === (7)))
{var inst_13485 = (state_13490[(2)]);var state_13490__$1 = state_13490;var statearr_13492_13516 = state_13490__$1;(statearr_13492_13516[(2)] = inst_13485);
(statearr_13492_13516[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13491 === (1)))
{var inst_13467 = null;var state_13490__$1 = (function (){var statearr_13493 = state_13490;(statearr_13493[(7)] = inst_13467);
return statearr_13493;
})();var statearr_13494_13517 = state_13490__$1;(statearr_13494_13517[(2)] = null);
(statearr_13494_13517[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13491 === (4)))
{var inst_13470 = (state_13490[(8)]);var inst_13470__$1 = (state_13490[(2)]);var inst_13471 = (inst_13470__$1 == null);var inst_13472 = cljs.core.not.call(null,inst_13471);var state_13490__$1 = (function (){var statearr_13495 = state_13490;(statearr_13495[(8)] = inst_13470__$1);
return statearr_13495;
})();if(inst_13472)
{var statearr_13496_13518 = state_13490__$1;(statearr_13496_13518[(1)] = (5));
} else
{var statearr_13497_13519 = state_13490__$1;(statearr_13497_13519[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13491 === (6)))
{var state_13490__$1 = state_13490;var statearr_13498_13520 = state_13490__$1;(statearr_13498_13520[(2)] = null);
(statearr_13498_13520[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13491 === (3)))
{var inst_13487 = (state_13490[(2)]);var inst_13488 = cljs.core.async.close_BANG_.call(null,out);var state_13490__$1 = (function (){var statearr_13499 = state_13490;(statearr_13499[(9)] = inst_13487);
return statearr_13499;
})();return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13490__$1,inst_13488);
} else
{if((state_val_13491 === (2)))
{var state_13490__$1 = state_13490;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13490__$1,(4),ch);
} else
{if((state_val_13491 === (11)))
{var inst_13470 = (state_13490[(8)]);var inst_13479 = (state_13490[(2)]);var inst_13467 = inst_13470;var state_13490__$1 = (function (){var statearr_13500 = state_13490;(statearr_13500[(10)] = inst_13479);
(statearr_13500[(7)] = inst_13467);
return statearr_13500;
})();var statearr_13501_13521 = state_13490__$1;(statearr_13501_13521[(2)] = null);
(statearr_13501_13521[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13491 === (9)))
{var inst_13470 = (state_13490[(8)]);var state_13490__$1 = state_13490;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13490__$1,(11),out,inst_13470);
} else
{if((state_val_13491 === (5)))
{var inst_13467 = (state_13490[(7)]);var inst_13470 = (state_13490[(8)]);var inst_13474 = cljs.core._EQ_.call(null,inst_13470,inst_13467);var state_13490__$1 = state_13490;if(inst_13474)
{var statearr_13503_13522 = state_13490__$1;(statearr_13503_13522[(1)] = (8));
} else
{var statearr_13504_13523 = state_13490__$1;(statearr_13504_13523[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13491 === (10)))
{var inst_13482 = (state_13490[(2)]);var state_13490__$1 = state_13490;var statearr_13505_13524 = state_13490__$1;(statearr_13505_13524[(2)] = inst_13482);
(statearr_13505_13524[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13491 === (8)))
{var inst_13467 = (state_13490[(7)]);var tmp13502 = inst_13467;var inst_13467__$1 = tmp13502;var state_13490__$1 = (function (){var statearr_13506 = state_13490;(statearr_13506[(7)] = inst_13467__$1);
return statearr_13506;
})();var statearr_13507_13525 = state_13490__$1;(statearr_13507_13525[(2)] = null);
(statearr_13507_13525[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__5915__auto___13515,out))
;return ((function (switch__5900__auto__,c__5915__auto___13515,out){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_13511 = [null,null,null,null,null,null,null,null,null,null,null];(statearr_13511[(0)] = state_machine__5901__auto__);
(statearr_13511[(1)] = (1));
return statearr_13511;
});
var state_machine__5901__auto____1 = (function (state_13490){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_13490);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e13512){if((e13512 instanceof Object))
{var ex__5904__auto__ = e13512;var statearr_13513_13526 = state_13490;(statearr_13513_13526[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13490);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e13512;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__13527 = state_13490;
state_13490 = G__13527;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_13490){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_13490);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto___13515,out))
})();var state__5917__auto__ = (function (){var statearr_13514 = f__5916__auto__.call(null);(statearr_13514[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto___13515);
return statearr_13514;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto___13515,out))
);
return out;
});
unique = function(ch,buf_or_n){
switch(arguments.length){
case 1:
return unique__1.call(this,ch);
case 2:
return unique__2.call(this,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unique.cljs$core$IFn$_invoke$arity$1 = unique__1;
unique.cljs$core$IFn$_invoke$arity$2 = unique__2;
return unique;
})()
;
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.partition = (function() {
var partition = null;
var partition__2 = (function (n,ch){return partition.call(null,n,ch,null);
});
var partition__3 = (function (n,ch,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__5915__auto___13662 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto___13662,out){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto___13662,out){
return (function (state_13632){var state_val_13633 = (state_13632[(1)]);if((state_val_13633 === (7)))
{var inst_13628 = (state_13632[(2)]);var state_13632__$1 = state_13632;var statearr_13634_13663 = state_13632__$1;(statearr_13634_13663[(2)] = inst_13628);
(statearr_13634_13663[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13633 === (1)))
{var inst_13595 = (new Array(n));var inst_13596 = inst_13595;var inst_13597 = (0);var state_13632__$1 = (function (){var statearr_13635 = state_13632;(statearr_13635[(7)] = inst_13597);
(statearr_13635[(8)] = inst_13596);
return statearr_13635;
})();var statearr_13636_13664 = state_13632__$1;(statearr_13636_13664[(2)] = null);
(statearr_13636_13664[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13633 === (4)))
{var inst_13600 = (state_13632[(9)]);var inst_13600__$1 = (state_13632[(2)]);var inst_13601 = (inst_13600__$1 == null);var inst_13602 = cljs.core.not.call(null,inst_13601);var state_13632__$1 = (function (){var statearr_13637 = state_13632;(statearr_13637[(9)] = inst_13600__$1);
return statearr_13637;
})();if(inst_13602)
{var statearr_13638_13665 = state_13632__$1;(statearr_13638_13665[(1)] = (5));
} else
{var statearr_13639_13666 = state_13632__$1;(statearr_13639_13666[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13633 === (15)))
{var inst_13622 = (state_13632[(2)]);var state_13632__$1 = state_13632;var statearr_13640_13667 = state_13632__$1;(statearr_13640_13667[(2)] = inst_13622);
(statearr_13640_13667[(1)] = (14));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13633 === (13)))
{var state_13632__$1 = state_13632;var statearr_13641_13668 = state_13632__$1;(statearr_13641_13668[(2)] = null);
(statearr_13641_13668[(1)] = (14));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13633 === (6)))
{var inst_13597 = (state_13632[(7)]);var inst_13618 = (inst_13597 > (0));var state_13632__$1 = state_13632;if(cljs.core.truth_(inst_13618))
{var statearr_13642_13669 = state_13632__$1;(statearr_13642_13669[(1)] = (12));
} else
{var statearr_13643_13670 = state_13632__$1;(statearr_13643_13670[(1)] = (13));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13633 === (3)))
{var inst_13630 = (state_13632[(2)]);var state_13632__$1 = state_13632;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13632__$1,inst_13630);
} else
{if((state_val_13633 === (12)))
{var inst_13596 = (state_13632[(8)]);var inst_13620 = cljs.core.vec.call(null,inst_13596);var state_13632__$1 = state_13632;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13632__$1,(15),out,inst_13620);
} else
{if((state_val_13633 === (2)))
{var state_13632__$1 = state_13632;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13632__$1,(4),ch);
} else
{if((state_val_13633 === (11)))
{var inst_13612 = (state_13632[(2)]);var inst_13613 = (new Array(n));var inst_13596 = inst_13613;var inst_13597 = (0);var state_13632__$1 = (function (){var statearr_13644 = state_13632;(statearr_13644[(7)] = inst_13597);
(statearr_13644[(8)] = inst_13596);
(statearr_13644[(10)] = inst_13612);
return statearr_13644;
})();var statearr_13645_13671 = state_13632__$1;(statearr_13645_13671[(2)] = null);
(statearr_13645_13671[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13633 === (9)))
{var inst_13596 = (state_13632[(8)]);var inst_13610 = cljs.core.vec.call(null,inst_13596);var state_13632__$1 = state_13632;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13632__$1,(11),out,inst_13610);
} else
{if((state_val_13633 === (5)))
{var inst_13597 = (state_13632[(7)]);var inst_13605 = (state_13632[(11)]);var inst_13596 = (state_13632[(8)]);var inst_13600 = (state_13632[(9)]);var inst_13604 = (inst_13596[inst_13597] = inst_13600);var inst_13605__$1 = (inst_13597 + (1));var inst_13606 = (inst_13605__$1 < n);var state_13632__$1 = (function (){var statearr_13646 = state_13632;(statearr_13646[(11)] = inst_13605__$1);
(statearr_13646[(12)] = inst_13604);
return statearr_13646;
})();if(cljs.core.truth_(inst_13606))
{var statearr_13647_13672 = state_13632__$1;(statearr_13647_13672[(1)] = (8));
} else
{var statearr_13648_13673 = state_13632__$1;(statearr_13648_13673[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13633 === (14)))
{var inst_13625 = (state_13632[(2)]);var inst_13626 = cljs.core.async.close_BANG_.call(null,out);var state_13632__$1 = (function (){var statearr_13650 = state_13632;(statearr_13650[(13)] = inst_13625);
return statearr_13650;
})();var statearr_13651_13674 = state_13632__$1;(statearr_13651_13674[(2)] = inst_13626);
(statearr_13651_13674[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13633 === (10)))
{var inst_13616 = (state_13632[(2)]);var state_13632__$1 = state_13632;var statearr_13652_13675 = state_13632__$1;(statearr_13652_13675[(2)] = inst_13616);
(statearr_13652_13675[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13633 === (8)))
{var inst_13605 = (state_13632[(11)]);var inst_13596 = (state_13632[(8)]);var tmp13649 = inst_13596;var inst_13596__$1 = tmp13649;var inst_13597 = inst_13605;var state_13632__$1 = (function (){var statearr_13653 = state_13632;(statearr_13653[(7)] = inst_13597);
(statearr_13653[(8)] = inst_13596__$1);
return statearr_13653;
})();var statearr_13654_13676 = state_13632__$1;(statearr_13654_13676[(2)] = null);
(statearr_13654_13676[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__5915__auto___13662,out))
;return ((function (switch__5900__auto__,c__5915__auto___13662,out){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_13658 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_13658[(0)] = state_machine__5901__auto__);
(statearr_13658[(1)] = (1));
return statearr_13658;
});
var state_machine__5901__auto____1 = (function (state_13632){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_13632);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e13659){if((e13659 instanceof Object))
{var ex__5904__auto__ = e13659;var statearr_13660_13677 = state_13632;(statearr_13660_13677[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13632);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e13659;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__13678 = state_13632;
state_13632 = G__13678;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_13632){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_13632);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto___13662,out))
})();var state__5917__auto__ = (function (){var statearr_13661 = f__5916__auto__.call(null);(statearr_13661[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto___13662);
return statearr_13661;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto___13662,out))
);
return out;
});
partition = function(n,ch,buf_or_n){
switch(arguments.length){
case 2:
return partition__2.call(this,n,ch);
case 3:
return partition__3.call(this,n,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
partition.cljs$core$IFn$_invoke$arity$2 = partition__2;
partition.cljs$core$IFn$_invoke$arity$3 = partition__3;
return partition;
})()
;
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.partition_by = (function() {
var partition_by = null;
var partition_by__2 = (function (f,ch){return partition_by.call(null,f,ch,null);
});
var partition_by__3 = (function (f,ch,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__5915__auto___13821 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto___13821,out){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto___13821,out){
return (function (state_13791){var state_val_13792 = (state_13791[(1)]);if((state_val_13792 === (7)))
{var inst_13787 = (state_13791[(2)]);var state_13791__$1 = state_13791;var statearr_13793_13822 = state_13791__$1;(statearr_13793_13822[(2)] = inst_13787);
(statearr_13793_13822[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13792 === (1)))
{var inst_13750 = [];var inst_13751 = inst_13750;var inst_13752 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);var state_13791__$1 = (function (){var statearr_13794 = state_13791;(statearr_13794[(7)] = inst_13751);
(statearr_13794[(8)] = inst_13752);
return statearr_13794;
})();var statearr_13795_13823 = state_13791__$1;(statearr_13795_13823[(2)] = null);
(statearr_13795_13823[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13792 === (4)))
{var inst_13755 = (state_13791[(9)]);var inst_13755__$1 = (state_13791[(2)]);var inst_13756 = (inst_13755__$1 == null);var inst_13757 = cljs.core.not.call(null,inst_13756);var state_13791__$1 = (function (){var statearr_13796 = state_13791;(statearr_13796[(9)] = inst_13755__$1);
return statearr_13796;
})();if(inst_13757)
{var statearr_13797_13824 = state_13791__$1;(statearr_13797_13824[(1)] = (5));
} else
{var statearr_13798_13825 = state_13791__$1;(statearr_13798_13825[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13792 === (15)))
{var inst_13781 = (state_13791[(2)]);var state_13791__$1 = state_13791;var statearr_13799_13826 = state_13791__$1;(statearr_13799_13826[(2)] = inst_13781);
(statearr_13799_13826[(1)] = (14));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13792 === (13)))
{var state_13791__$1 = state_13791;var statearr_13800_13827 = state_13791__$1;(statearr_13800_13827[(2)] = null);
(statearr_13800_13827[(1)] = (14));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13792 === (6)))
{var inst_13751 = (state_13791[(7)]);var inst_13776 = inst_13751.length;var inst_13777 = (inst_13776 > (0));var state_13791__$1 = state_13791;if(cljs.core.truth_(inst_13777))
{var statearr_13801_13828 = state_13791__$1;(statearr_13801_13828[(1)] = (12));
} else
{var statearr_13802_13829 = state_13791__$1;(statearr_13802_13829[(1)] = (13));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13792 === (3)))
{var inst_13789 = (state_13791[(2)]);var state_13791__$1 = state_13791;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13791__$1,inst_13789);
} else
{if((state_val_13792 === (12)))
{var inst_13751 = (state_13791[(7)]);var inst_13779 = cljs.core.vec.call(null,inst_13751);var state_13791__$1 = state_13791;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13791__$1,(15),out,inst_13779);
} else
{if((state_val_13792 === (2)))
{var state_13791__$1 = state_13791;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13791__$1,(4),ch);
} else
{if((state_val_13792 === (11)))
{var inst_13755 = (state_13791[(9)]);var inst_13759 = (state_13791[(10)]);var inst_13769 = (state_13791[(2)]);var inst_13770 = [];var inst_13771 = inst_13770.push(inst_13755);var inst_13751 = inst_13770;var inst_13752 = inst_13759;var state_13791__$1 = (function (){var statearr_13803 = state_13791;(statearr_13803[(11)] = inst_13769);
(statearr_13803[(7)] = inst_13751);
(statearr_13803[(8)] = inst_13752);
(statearr_13803[(12)] = inst_13771);
return statearr_13803;
})();var statearr_13804_13830 = state_13791__$1;(statearr_13804_13830[(2)] = null);
(statearr_13804_13830[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13792 === (9)))
{var inst_13751 = (state_13791[(7)]);var inst_13767 = cljs.core.vec.call(null,inst_13751);var state_13791__$1 = state_13791;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13791__$1,(11),out,inst_13767);
} else
{if((state_val_13792 === (5)))
{var inst_13752 = (state_13791[(8)]);var inst_13755 = (state_13791[(9)]);var inst_13759 = (state_13791[(10)]);var inst_13759__$1 = f.call(null,inst_13755);var inst_13760 = cljs.core._EQ_.call(null,inst_13759__$1,inst_13752);var inst_13761 = cljs.core.keyword_identical_QMARK_.call(null,inst_13752,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));var inst_13762 = (inst_13760) || (inst_13761);var state_13791__$1 = (function (){var statearr_13805 = state_13791;(statearr_13805[(10)] = inst_13759__$1);
return statearr_13805;
})();if(cljs.core.truth_(inst_13762))
{var statearr_13806_13831 = state_13791__$1;(statearr_13806_13831[(1)] = (8));
} else
{var statearr_13807_13832 = state_13791__$1;(statearr_13807_13832[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13792 === (14)))
{var inst_13784 = (state_13791[(2)]);var inst_13785 = cljs.core.async.close_BANG_.call(null,out);var state_13791__$1 = (function (){var statearr_13809 = state_13791;(statearr_13809[(13)] = inst_13784);
return statearr_13809;
})();var statearr_13810_13833 = state_13791__$1;(statearr_13810_13833[(2)] = inst_13785);
(statearr_13810_13833[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13792 === (10)))
{var inst_13774 = (state_13791[(2)]);var state_13791__$1 = state_13791;var statearr_13811_13834 = state_13791__$1;(statearr_13811_13834[(2)] = inst_13774);
(statearr_13811_13834[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13792 === (8)))
{var inst_13751 = (state_13791[(7)]);var inst_13755 = (state_13791[(9)]);var inst_13759 = (state_13791[(10)]);var inst_13764 = inst_13751.push(inst_13755);var tmp13808 = inst_13751;var inst_13751__$1 = tmp13808;var inst_13752 = inst_13759;var state_13791__$1 = (function (){var statearr_13812 = state_13791;(statearr_13812[(14)] = inst_13764);
(statearr_13812[(7)] = inst_13751__$1);
(statearr_13812[(8)] = inst_13752);
return statearr_13812;
})();var statearr_13813_13835 = state_13791__$1;(statearr_13813_13835[(2)] = null);
(statearr_13813_13835[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__5915__auto___13821,out))
;return ((function (switch__5900__auto__,c__5915__auto___13821,out){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_13817 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_13817[(0)] = state_machine__5901__auto__);
(statearr_13817[(1)] = (1));
return statearr_13817;
});
var state_machine__5901__auto____1 = (function (state_13791){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_13791);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e13818){if((e13818 instanceof Object))
{var ex__5904__auto__ = e13818;var statearr_13819_13836 = state_13791;(statearr_13819_13836[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13791);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e13818;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__13837 = state_13791;
state_13791 = G__13837;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_13791){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_13791);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto___13821,out))
})();var state__5917__auto__ = (function (){var statearr_13820 = f__5916__auto__.call(null);(statearr_13820[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto___13821);
return statearr_13820;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto___13821,out))
);
return out;
});
partition_by = function(f,ch,buf_or_n){
switch(arguments.length){
case 2:
return partition_by__2.call(this,f,ch);
case 3:
return partition_by__3.call(this,f,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
partition_by.cljs$core$IFn$_invoke$arity$2 = partition_by__2;
partition_by.cljs$core$IFn$_invoke$arity$3 = partition_by__3;
return partition_by;
})()
;
