// Compiled by ClojureScript 0.0-2371
goog.provide('dommy.core');
goog.require('cljs.core');
goog.require('dommy.utils');
goog.require('dommy.utils');
goog.require('dommy.utils');
goog.require('clojure.string');
goog.require('clojure.string');
/**
* Returns a selector in string format.
* Accepts string, keyword, or collection.
*/
dommy.core.selector = (function selector(data){if(cljs.core.coll_QMARK_.call(null,data))
{return clojure.string.join.call(null," ",cljs.core.map.call(null,selector,data));
} else
{if((typeof data === 'string') || ((data instanceof cljs.core.Keyword)))
{return cljs.core.name.call(null,data);
} else
{return null;
}
}
});
dommy.core.text = (function text(elem){var or__3648__auto__ = elem.textContent;if(cljs.core.truth_(or__3648__auto__))
{return or__3648__auto__;
} else
{return elem.innerText;
}
});
dommy.core.html = (function html(elem){return elem.innerHTML;
});
dommy.core.value = (function value(elem){return elem.value;
});
dommy.core.class$ = (function class$(elem){return elem.className;
});
dommy.core.attr = (function attr(elem,k){if(cljs.core.truth_(k))
{return elem.getAttribute(dommy.utils.as_str.call(null,k));
} else
{return null;
}
});
/**
* The computed style of `elem`, optionally specifying the key of
* a particular style to return
*/
dommy.core.style = (function() {
var style = null;
var style__1 = (function (elem){return cljs.core.js__GT_clj.call(null,window.getComputedStyle(elem));
});
var style__2 = (function (elem,k){return (window.getComputedStyle(elem)[dommy.utils.as_str.call(null,k)]);
});
style = function(elem,k){
switch(arguments.length){
case 1:
return style__1.call(this,elem);
case 2:
return style__2.call(this,elem,k);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
style.cljs$core$IFn$_invoke$arity$1 = style__1;
style.cljs$core$IFn$_invoke$arity$2 = style__2;
return style;
})()
;
dommy.core.px = (function px(elem,k){var pixels = dommy.core.style.call(null,elem,k);if(cljs.core.seq.call(null,pixels))
{return parseInt(pixels);
} else
{return null;
}
});
/**
* Does `elem` contain `c` in its class list
*/
dommy.core.has_class_QMARK_ = (function has_class_QMARK_(elem,c){var c__$1 = dommy.utils.as_str.call(null,c);var temp__4124__auto__ = elem.classList;if(cljs.core.truth_(temp__4124__auto__))
{var class_list = temp__4124__auto__;return class_list.contains(c__$1);
} else
{var temp__4126__auto__ = dommy.core.class$.call(null,elem);if(cljs.core.truth_(temp__4126__auto__))
{var class_name = temp__4126__auto__;var temp__4126__auto____$1 = dommy.utils.class_index.call(null,class_name,c__$1);if(cljs.core.truth_(temp__4126__auto____$1))
{var i = temp__4126__auto____$1;return (i >= (0));
} else
{return null;
}
} else
{return null;
}
}
});
/**
* Is `elem` hidden (as associated with hide!/show!/toggle!, using display: none)
*/
dommy.core.hidden_QMARK_ = (function hidden_QMARK_(elem){return (dommy.core.style.call(null,elem,new cljs.core.Keyword(null,"display","display",242065432)) === "none");
});
/**
* Returns a map of the bounding client rect of `elem`
* as a map with [:top :left :right :bottom :width :height]
*/
dommy.core.bounding_client_rect = (function bounding_client_rect(elem){var r = elem.getBoundingClientRect();return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"top","top",-1856271961),r.top,new cljs.core.Keyword(null,"bottom","bottom",-1550509018),r.bottom,new cljs.core.Keyword(null,"left","left",-399115937),r.left,new cljs.core.Keyword(null,"right","right",-452581833),r.right,new cljs.core.Keyword(null,"width","width",-384071477),r.width,new cljs.core.Keyword(null,"height","height",1025178622),r.height], null);
});
dommy.core.parent = (function parent(elem){return elem.parentNode;
});
dommy.core.children = (function children(elem){return elem.children;
});
/**
* Lazy seq of the ancestors of `elem`
*/
dommy.core.ancestors = (function ancestors(elem){return cljs.core.take_while.call(null,cljs.core.identity,cljs.core.iterate.call(null,dommy.core.parent,elem));
});
dommy.core.ancestor_nodes = dommy.core.ancestors;
/**
* Returns a predicate on nodes that match `selector` at the
* time of this `matches-pred` call (may return outdated results
* if you fuck with the DOM)
*/
dommy.core.matches_pred = (function() {
var matches_pred = null;
var matches_pred__1 = (function (selector){return matches_pred.call(null,document,selector);
});
var matches_pred__2 = (function (base,selector){var matches = dommy.utils.__GT_Array.call(null,base.querySelectorAll(dommy.core.selector.call(null,selector)));return ((function (matches){
return (function (elem){return (matches.indexOf(elem) >= (0));
});
;})(matches))
});
matches_pred = function(base,selector){
switch(arguments.length){
case 1:
return matches_pred__1.call(this,base);
case 2:
return matches_pred__2.call(this,base,selector);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
matches_pred.cljs$core$IFn$_invoke$arity$1 = matches_pred__1;
matches_pred.cljs$core$IFn$_invoke$arity$2 = matches_pred__2;
return matches_pred;
})()
;
/**
* Closest ancestor of `elem` (up to `base`, if provided)
* that matches `selector`
*/
dommy.core.closest = (function() {
var closest = null;
var closest__2 = (function (elem,selector){return closest.call(null,document.body,elem,selector);
});
var closest__3 = (function (base,elem,selector){return cljs.core.first.call(null,cljs.core.filter.call(null,dommy.core.matches_pred.call(null,base,selector),cljs.core.take_while.call(null,(function (p1__13915_SHARP_){return !((p1__13915_SHARP_ === base));
}),dommy.core.ancestors.call(null,elem))));
});
closest = function(base,elem,selector){
switch(arguments.length){
case 2:
return closest__2.call(this,base,elem);
case 3:
return closest__3.call(this,base,elem,selector);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
closest.cljs$core$IFn$_invoke$arity$2 = closest__2;
closest.cljs$core$IFn$_invoke$arity$3 = closest__3;
return closest;
})()
;
/**
* Is `descendant` a descendant of `ancestor`?
* (http://goo.gl/T8pgCX)
*/
dommy.core.descendant_QMARK_ = (function descendant_QMARK_(descendant,ancestor){if(cljs.core.truth_(ancestor.contains))
{return ancestor.contains(descendant);
} else
{if(cljs.core.truth_(ancestor.compareDocumentPosition))
{return ((ancestor.compareDocumentPosition(descendant) & (1 << (4))) != 0);
} else
{return null;
}
}
});
/**
* Set the textContent of `elem` to `text`, fall back to innerText
*/
dommy.core.set_text_BANG_ = (function set_text_BANG_(elem,text){if(!((void 0 === elem.textContent)))
{elem.textContent = text;
} else
{elem.innerText = text;
}
return elem;
});
/**
* Set the innerHTML of `elem` to `html`
*/
dommy.core.set_html_BANG_ = (function set_html_BANG_(elem,html){elem.innerHTML = html;
return elem;
});
/**
* Set the value of `elem` to `value`
*/
dommy.core.set_value_BANG_ = (function set_value_BANG_(elem,value){elem.value = value;
return elem;
});
/**
* Set the css class of `elem` to `elem`
*/
dommy.core.set_class_BANG_ = (function set_class_BANG_(elem,c){return elem.className = c;
});
/**
* Set the style of `elem` using key-value pairs:
* 
* (set-style! elem :display "block" :color "red")
* @param {...*} var_args
*/
dommy.core.set_style_BANG_ = (function() { 
var set_style_BANG___delegate = function (elem,kvs){if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,kvs)))
{} else
{throw (new Error(("Assert failed: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"kvs","kvs",-1695980277,null))))))));
}
var style = elem.style;var seq__13922_13928 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),kvs));var chunk__13923_13929 = null;var count__13924_13930 = (0);var i__13925_13931 = (0);while(true){
if((i__13925_13931 < count__13924_13930))
{var vec__13926_13932 = cljs.core._nth.call(null,chunk__13923_13929,i__13925_13931);var k_13933 = cljs.core.nth.call(null,vec__13926_13932,(0),null);var v_13934 = cljs.core.nth.call(null,vec__13926_13932,(1),null);style.setProperty(dommy.utils.as_str.call(null,k_13933),v_13934);
{
var G__13935 = seq__13922_13928;
var G__13936 = chunk__13923_13929;
var G__13937 = count__13924_13930;
var G__13938 = (i__13925_13931 + (1));
seq__13922_13928 = G__13935;
chunk__13923_13929 = G__13936;
count__13924_13930 = G__13937;
i__13925_13931 = G__13938;
continue;
}
} else
{var temp__4126__auto___13939 = cljs.core.seq.call(null,seq__13922_13928);if(temp__4126__auto___13939)
{var seq__13922_13940__$1 = temp__4126__auto___13939;if(cljs.core.chunked_seq_QMARK_.call(null,seq__13922_13940__$1))
{var c__4418__auto___13941 = cljs.core.chunk_first.call(null,seq__13922_13940__$1);{
var G__13942 = cljs.core.chunk_rest.call(null,seq__13922_13940__$1);
var G__13943 = c__4418__auto___13941;
var G__13944 = cljs.core.count.call(null,c__4418__auto___13941);
var G__13945 = (0);
seq__13922_13928 = G__13942;
chunk__13923_13929 = G__13943;
count__13924_13930 = G__13944;
i__13925_13931 = G__13945;
continue;
}
} else
{var vec__13927_13946 = cljs.core.first.call(null,seq__13922_13940__$1);var k_13947 = cljs.core.nth.call(null,vec__13927_13946,(0),null);var v_13948 = cljs.core.nth.call(null,vec__13927_13946,(1),null);style.setProperty(dommy.utils.as_str.call(null,k_13947),v_13948);
{
var G__13949 = cljs.core.next.call(null,seq__13922_13940__$1);
var G__13950 = null;
var G__13951 = (0);
var G__13952 = (0);
seq__13922_13928 = G__13949;
chunk__13923_13929 = G__13950;
count__13924_13930 = G__13951;
i__13925_13931 = G__13952;
continue;
}
}
} else
{}
}
break;
}
return elem;
};
var set_style_BANG_ = function (elem,var_args){
var kvs = null;if (arguments.length > 1) {
  kvs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return set_style_BANG___delegate.call(this,elem,kvs);};
set_style_BANG_.cljs$lang$maxFixedArity = 1;
set_style_BANG_.cljs$lang$applyTo = (function (arglist__13953){
var elem = cljs.core.first(arglist__13953);
var kvs = cljs.core.rest(arglist__13953);
return set_style_BANG___delegate(elem,kvs);
});
set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic = set_style_BANG___delegate;
return set_style_BANG_;
})()
;
/**
* @param {...*} var_args
*/
dommy.core.set_px_BANG_ = (function() { 
var set_px_BANG___delegate = function (elem,kvs){if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,kvs)))
{} else
{throw (new Error(("Assert failed: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"kvs","kvs",-1695980277,null))))))));
}
var seq__13960_13966 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),kvs));var chunk__13961_13967 = null;var count__13962_13968 = (0);var i__13963_13969 = (0);while(true){
if((i__13963_13969 < count__13962_13968))
{var vec__13964_13970 = cljs.core._nth.call(null,chunk__13961_13967,i__13963_13969);var k_13971 = cljs.core.nth.call(null,vec__13964_13970,(0),null);var v_13972 = cljs.core.nth.call(null,vec__13964_13970,(1),null);dommy.core.set_style_BANG_.call(null,elem,k_13971,(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(v_13972)+"px"));
{
var G__13973 = seq__13960_13966;
var G__13974 = chunk__13961_13967;
var G__13975 = count__13962_13968;
var G__13976 = (i__13963_13969 + (1));
seq__13960_13966 = G__13973;
chunk__13961_13967 = G__13974;
count__13962_13968 = G__13975;
i__13963_13969 = G__13976;
continue;
}
} else
{var temp__4126__auto___13977 = cljs.core.seq.call(null,seq__13960_13966);if(temp__4126__auto___13977)
{var seq__13960_13978__$1 = temp__4126__auto___13977;if(cljs.core.chunked_seq_QMARK_.call(null,seq__13960_13978__$1))
{var c__4418__auto___13979 = cljs.core.chunk_first.call(null,seq__13960_13978__$1);{
var G__13980 = cljs.core.chunk_rest.call(null,seq__13960_13978__$1);
var G__13981 = c__4418__auto___13979;
var G__13982 = cljs.core.count.call(null,c__4418__auto___13979);
var G__13983 = (0);
seq__13960_13966 = G__13980;
chunk__13961_13967 = G__13981;
count__13962_13968 = G__13982;
i__13963_13969 = G__13983;
continue;
}
} else
{var vec__13965_13984 = cljs.core.first.call(null,seq__13960_13978__$1);var k_13985 = cljs.core.nth.call(null,vec__13965_13984,(0),null);var v_13986 = cljs.core.nth.call(null,vec__13965_13984,(1),null);dommy.core.set_style_BANG_.call(null,elem,k_13985,(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(v_13986)+"px"));
{
var G__13987 = cljs.core.next.call(null,seq__13960_13978__$1);
var G__13988 = null;
var G__13989 = (0);
var G__13990 = (0);
seq__13960_13966 = G__13987;
chunk__13961_13967 = G__13988;
count__13962_13968 = G__13989;
i__13963_13969 = G__13990;
continue;
}
}
} else
{}
}
break;
}
return elem;
};
var set_px_BANG_ = function (elem,var_args){
var kvs = null;if (arguments.length > 1) {
  kvs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return set_px_BANG___delegate.call(this,elem,kvs);};
set_px_BANG_.cljs$lang$maxFixedArity = 1;
set_px_BANG_.cljs$lang$applyTo = (function (arglist__13991){
var elem = cljs.core.first(arglist__13991);
var kvs = cljs.core.rest(arglist__13991);
return set_px_BANG___delegate(elem,kvs);
});
set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic = set_px_BANG___delegate;
return set_px_BANG_;
})()
;
/**
* Sets dom attributes on and returns `elem`.
* Attributes without values will be set to "true":
* 
* (set-attr! elem :disabled)
* 
* With values, the function takes variadic kv pairs:
* 
* (set-attr! elem :id "some-id"
* :name "some-name")
* @param {...*} var_args
*/
dommy.core.set_attr_BANG_ = (function() {
var set_attr_BANG_ = null;
var set_attr_BANG___2 = (function (elem,k){return set_attr_BANG_.call(null,elem,k,"true");
});
var set_attr_BANG___3 = (function (elem,k,v){var k__$1 = dommy.utils.as_str.call(null,k);if(cljs.core.truth_(v))
{if(cljs.core.fn_QMARK_.call(null,v))
{var G__14000 = elem;(G__14000[k__$1] = v);
return G__14000;
} else
{var G__14001 = elem;G__14001.setAttribute(k__$1,v);
return G__14001;
}
} else
{return null;
}
});
var set_attr_BANG___4 = (function() { 
var G__14008__delegate = function (elem,k,v,kvs){if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,kvs)))
{} else
{throw (new Error(("Assert failed: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"kvs","kvs",-1695980277,null))))))));
}
var seq__14002_14009 = cljs.core.seq.call(null,cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),cljs.core.partition.call(null,(2),kvs)));var chunk__14003_14010 = null;var count__14004_14011 = (0);var i__14005_14012 = (0);while(true){
if((i__14005_14012 < count__14004_14011))
{var vec__14006_14013 = cljs.core._nth.call(null,chunk__14003_14010,i__14005_14012);var k_14014__$1 = cljs.core.nth.call(null,vec__14006_14013,(0),null);var v_14015__$1 = cljs.core.nth.call(null,vec__14006_14013,(1),null);set_attr_BANG_.call(null,elem,k_14014__$1,v_14015__$1);
{
var G__14016 = seq__14002_14009;
var G__14017 = chunk__14003_14010;
var G__14018 = count__14004_14011;
var G__14019 = (i__14005_14012 + (1));
seq__14002_14009 = G__14016;
chunk__14003_14010 = G__14017;
count__14004_14011 = G__14018;
i__14005_14012 = G__14019;
continue;
}
} else
{var temp__4126__auto___14020 = cljs.core.seq.call(null,seq__14002_14009);if(temp__4126__auto___14020)
{var seq__14002_14021__$1 = temp__4126__auto___14020;if(cljs.core.chunked_seq_QMARK_.call(null,seq__14002_14021__$1))
{var c__4418__auto___14022 = cljs.core.chunk_first.call(null,seq__14002_14021__$1);{
var G__14023 = cljs.core.chunk_rest.call(null,seq__14002_14021__$1);
var G__14024 = c__4418__auto___14022;
var G__14025 = cljs.core.count.call(null,c__4418__auto___14022);
var G__14026 = (0);
seq__14002_14009 = G__14023;
chunk__14003_14010 = G__14024;
count__14004_14011 = G__14025;
i__14005_14012 = G__14026;
continue;
}
} else
{var vec__14007_14027 = cljs.core.first.call(null,seq__14002_14021__$1);var k_14028__$1 = cljs.core.nth.call(null,vec__14007_14027,(0),null);var v_14029__$1 = cljs.core.nth.call(null,vec__14007_14027,(1),null);set_attr_BANG_.call(null,elem,k_14028__$1,v_14029__$1);
{
var G__14030 = cljs.core.next.call(null,seq__14002_14021__$1);
var G__14031 = null;
var G__14032 = (0);
var G__14033 = (0);
seq__14002_14009 = G__14030;
chunk__14003_14010 = G__14031;
count__14004_14011 = G__14032;
i__14005_14012 = G__14033;
continue;
}
}
} else
{}
}
break;
}
return elem;
};
var G__14008 = function (elem,k,v,var_args){
var kvs = null;if (arguments.length > 3) {
  kvs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3),0);} 
return G__14008__delegate.call(this,elem,k,v,kvs);};
G__14008.cljs$lang$maxFixedArity = 3;
G__14008.cljs$lang$applyTo = (function (arglist__14034){
var elem = cljs.core.first(arglist__14034);
arglist__14034 = cljs.core.next(arglist__14034);
var k = cljs.core.first(arglist__14034);
arglist__14034 = cljs.core.next(arglist__14034);
var v = cljs.core.first(arglist__14034);
var kvs = cljs.core.rest(arglist__14034);
return G__14008__delegate(elem,k,v,kvs);
});
G__14008.cljs$core$IFn$_invoke$arity$variadic = G__14008__delegate;
return G__14008;
})()
;
set_attr_BANG_ = function(elem,k,v,var_args){
var kvs = var_args;
switch(arguments.length){
case 2:
return set_attr_BANG___2.call(this,elem,k);
case 3:
return set_attr_BANG___3.call(this,elem,k,v);
default:
return set_attr_BANG___4.cljs$core$IFn$_invoke$arity$variadic(elem,k,v, cljs.core.array_seq(arguments, 3));
}
throw(new Error('Invalid arity: ' + arguments.length));
};
set_attr_BANG_.cljs$lang$maxFixedArity = 3;
set_attr_BANG_.cljs$lang$applyTo = set_attr_BANG___4.cljs$lang$applyTo;
set_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = set_attr_BANG___2;
set_attr_BANG_.cljs$core$IFn$_invoke$arity$3 = set_attr_BANG___3;
set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic = set_attr_BANG___4.cljs$core$IFn$_invoke$arity$variadic;
return set_attr_BANG_;
})()
;
/**
* Removes dom attributes on and returns `elem`.
* `class` and `classes` are special cases which clear
* out the class name on removal.
* @param {...*} var_args
*/
dommy.core.remove_attr_BANG_ = (function() {
var remove_attr_BANG_ = null;
var remove_attr_BANG___2 = (function (elem,k){var k_14043__$1 = dommy.utils.as_str.call(null,k);if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["class",null,"classes",null], null), null).call(null,k_14043__$1)))
{dommy.core.set_class_BANG_.call(null,elem,"");
} else
{elem.removeAttribute(k_14043__$1);
}
return elem;
});
var remove_attr_BANG___3 = (function() { 
var G__14044__delegate = function (elem,k,ks){var seq__14039_14045 = cljs.core.seq.call(null,cljs.core.cons.call(null,k,ks));var chunk__14040_14046 = null;var count__14041_14047 = (0);var i__14042_14048 = (0);while(true){
if((i__14042_14048 < count__14041_14047))
{var k_14049__$1 = cljs.core._nth.call(null,chunk__14040_14046,i__14042_14048);remove_attr_BANG_.call(null,elem,k_14049__$1);
{
var G__14050 = seq__14039_14045;
var G__14051 = chunk__14040_14046;
var G__14052 = count__14041_14047;
var G__14053 = (i__14042_14048 + (1));
seq__14039_14045 = G__14050;
chunk__14040_14046 = G__14051;
count__14041_14047 = G__14052;
i__14042_14048 = G__14053;
continue;
}
} else
{var temp__4126__auto___14054 = cljs.core.seq.call(null,seq__14039_14045);if(temp__4126__auto___14054)
{var seq__14039_14055__$1 = temp__4126__auto___14054;if(cljs.core.chunked_seq_QMARK_.call(null,seq__14039_14055__$1))
{var c__4418__auto___14056 = cljs.core.chunk_first.call(null,seq__14039_14055__$1);{
var G__14057 = cljs.core.chunk_rest.call(null,seq__14039_14055__$1);
var G__14058 = c__4418__auto___14056;
var G__14059 = cljs.core.count.call(null,c__4418__auto___14056);
var G__14060 = (0);
seq__14039_14045 = G__14057;
chunk__14040_14046 = G__14058;
count__14041_14047 = G__14059;
i__14042_14048 = G__14060;
continue;
}
} else
{var k_14061__$1 = cljs.core.first.call(null,seq__14039_14055__$1);remove_attr_BANG_.call(null,elem,k_14061__$1);
{
var G__14062 = cljs.core.next.call(null,seq__14039_14055__$1);
var G__14063 = null;
var G__14064 = (0);
var G__14065 = (0);
seq__14039_14045 = G__14062;
chunk__14040_14046 = G__14063;
count__14041_14047 = G__14064;
i__14042_14048 = G__14065;
continue;
}
}
} else
{}
}
break;
}
return elem;
};
var G__14044 = function (elem,k,var_args){
var ks = null;if (arguments.length > 2) {
  ks = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);} 
return G__14044__delegate.call(this,elem,k,ks);};
G__14044.cljs$lang$maxFixedArity = 2;
G__14044.cljs$lang$applyTo = (function (arglist__14066){
var elem = cljs.core.first(arglist__14066);
arglist__14066 = cljs.core.next(arglist__14066);
var k = cljs.core.first(arglist__14066);
var ks = cljs.core.rest(arglist__14066);
return G__14044__delegate(elem,k,ks);
});
G__14044.cljs$core$IFn$_invoke$arity$variadic = G__14044__delegate;
return G__14044;
})()
;
remove_attr_BANG_ = function(elem,k,var_args){
var ks = var_args;
switch(arguments.length){
case 2:
return remove_attr_BANG___2.call(this,elem,k);
default:
return remove_attr_BANG___3.cljs$core$IFn$_invoke$arity$variadic(elem,k, cljs.core.array_seq(arguments, 2));
}
throw(new Error('Invalid arity: ' + arguments.length));
};
remove_attr_BANG_.cljs$lang$maxFixedArity = 2;
remove_attr_BANG_.cljs$lang$applyTo = remove_attr_BANG___3.cljs$lang$applyTo;
remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = remove_attr_BANG___2;
remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic = remove_attr_BANG___3.cljs$core$IFn$_invoke$arity$variadic;
return remove_attr_BANG_;
})()
;
/**
* Toggles a dom attribute `k` on `elem`, optionally specifying
* the boolean value with `add?`
*/
dommy.core.toggle_attr_BANG_ = (function() {
var toggle_attr_BANG_ = null;
var toggle_attr_BANG___2 = (function (elem,k){return toggle_attr_BANG_.call(null,elem,k,cljs.core.boolean$.call(null,dommy.core.attr.call(null,elem,k)));
});
var toggle_attr_BANG___3 = (function (elem,k,add_QMARK_){if(add_QMARK_)
{return dommy.core.set_attr_BANG_.call(null,elem,k);
} else
{return dommy.core.remove_attr_BANG_.call(null,elem,k);
}
});
toggle_attr_BANG_ = function(elem,k,add_QMARK_){
switch(arguments.length){
case 2:
return toggle_attr_BANG___2.call(this,elem,k);
case 3:
return toggle_attr_BANG___3.call(this,elem,k,add_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = toggle_attr_BANG___2;
toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3 = toggle_attr_BANG___3;
return toggle_attr_BANG_;
})()
;
/**
* Add `classes` to `elem`, trying to use Element::classList, and
* falling back to fast string parsing/manipulation
* @param {...*} var_args
*/
dommy.core.add_class_BANG_ = (function() {
var add_class_BANG_ = null;
var add_class_BANG___2 = (function (elem,classes){var classes__$1 = clojure.string.trim.call(null,dommy.utils.as_str.call(null,classes)).split(/\s+/);if(cljs.core.seq.call(null,classes__$1))
{var temp__4124__auto___14091 = elem.classList;if(cljs.core.truth_(temp__4124__auto___14091))
{var class_list_14092 = temp__4124__auto___14091;var seq__14079_14093 = cljs.core.seq.call(null,classes__$1);var chunk__14080_14094 = null;var count__14081_14095 = (0);var i__14082_14096 = (0);while(true){
if((i__14082_14096 < count__14081_14095))
{var c_14097 = cljs.core._nth.call(null,chunk__14080_14094,i__14082_14096);class_list_14092.add(c_14097);
{
var G__14098 = seq__14079_14093;
var G__14099 = chunk__14080_14094;
var G__14100 = count__14081_14095;
var G__14101 = (i__14082_14096 + (1));
seq__14079_14093 = G__14098;
chunk__14080_14094 = G__14099;
count__14081_14095 = G__14100;
i__14082_14096 = G__14101;
continue;
}
} else
{var temp__4126__auto___14102 = cljs.core.seq.call(null,seq__14079_14093);if(temp__4126__auto___14102)
{var seq__14079_14103__$1 = temp__4126__auto___14102;if(cljs.core.chunked_seq_QMARK_.call(null,seq__14079_14103__$1))
{var c__4418__auto___14104 = cljs.core.chunk_first.call(null,seq__14079_14103__$1);{
var G__14105 = cljs.core.chunk_rest.call(null,seq__14079_14103__$1);
var G__14106 = c__4418__auto___14104;
var G__14107 = cljs.core.count.call(null,c__4418__auto___14104);
var G__14108 = (0);
seq__14079_14093 = G__14105;
chunk__14080_14094 = G__14106;
count__14081_14095 = G__14107;
i__14082_14096 = G__14108;
continue;
}
} else
{var c_14109 = cljs.core.first.call(null,seq__14079_14103__$1);class_list_14092.add(c_14109);
{
var G__14110 = cljs.core.next.call(null,seq__14079_14103__$1);
var G__14111 = null;
var G__14112 = (0);
var G__14113 = (0);
seq__14079_14093 = G__14110;
chunk__14080_14094 = G__14111;
count__14081_14095 = G__14112;
i__14082_14096 = G__14113;
continue;
}
}
} else
{}
}
break;
}
} else
{var seq__14083_14114 = cljs.core.seq.call(null,classes__$1);var chunk__14084_14115 = null;var count__14085_14116 = (0);var i__14086_14117 = (0);while(true){
if((i__14086_14117 < count__14085_14116))
{var c_14118 = cljs.core._nth.call(null,chunk__14084_14115,i__14086_14117);var class_name_14119 = dommy.core.class$.call(null,elem);if(cljs.core.truth_(dommy.utils.class_index.call(null,class_name_14119,c_14118)))
{} else
{dommy.core.set_class_BANG_.call(null,elem,(((class_name_14119 === ""))?c_14118:(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(class_name_14119)+" "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(c_14118))));
}
{
var G__14120 = seq__14083_14114;
var G__14121 = chunk__14084_14115;
var G__14122 = count__14085_14116;
var G__14123 = (i__14086_14117 + (1));
seq__14083_14114 = G__14120;
chunk__14084_14115 = G__14121;
count__14085_14116 = G__14122;
i__14086_14117 = G__14123;
continue;
}
} else
{var temp__4126__auto___14124 = cljs.core.seq.call(null,seq__14083_14114);if(temp__4126__auto___14124)
{var seq__14083_14125__$1 = temp__4126__auto___14124;if(cljs.core.chunked_seq_QMARK_.call(null,seq__14083_14125__$1))
{var c__4418__auto___14126 = cljs.core.chunk_first.call(null,seq__14083_14125__$1);{
var G__14127 = cljs.core.chunk_rest.call(null,seq__14083_14125__$1);
var G__14128 = c__4418__auto___14126;
var G__14129 = cljs.core.count.call(null,c__4418__auto___14126);
var G__14130 = (0);
seq__14083_14114 = G__14127;
chunk__14084_14115 = G__14128;
count__14085_14116 = G__14129;
i__14086_14117 = G__14130;
continue;
}
} else
{var c_14131 = cljs.core.first.call(null,seq__14083_14125__$1);var class_name_14132 = dommy.core.class$.call(null,elem);if(cljs.core.truth_(dommy.utils.class_index.call(null,class_name_14132,c_14131)))
{} else
{dommy.core.set_class_BANG_.call(null,elem,(((class_name_14132 === ""))?c_14131:(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(class_name_14132)+" "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(c_14131))));
}
{
var G__14133 = cljs.core.next.call(null,seq__14083_14125__$1);
var G__14134 = null;
var G__14135 = (0);
var G__14136 = (0);
seq__14083_14114 = G__14133;
chunk__14084_14115 = G__14134;
count__14085_14116 = G__14135;
i__14086_14117 = G__14136;
continue;
}
}
} else
{}
}
break;
}
}
} else
{}
return elem;
});
var add_class_BANG___3 = (function() { 
var G__14137__delegate = function (elem,classes,more_classes){var seq__14087_14138 = cljs.core.seq.call(null,cljs.core.conj.call(null,more_classes,classes));var chunk__14088_14139 = null;var count__14089_14140 = (0);var i__14090_14141 = (0);while(true){
if((i__14090_14141 < count__14089_14140))
{var c_14142 = cljs.core._nth.call(null,chunk__14088_14139,i__14090_14141);add_class_BANG_.call(null,elem,c_14142);
{
var G__14143 = seq__14087_14138;
var G__14144 = chunk__14088_14139;
var G__14145 = count__14089_14140;
var G__14146 = (i__14090_14141 + (1));
seq__14087_14138 = G__14143;
chunk__14088_14139 = G__14144;
count__14089_14140 = G__14145;
i__14090_14141 = G__14146;
continue;
}
} else
{var temp__4126__auto___14147 = cljs.core.seq.call(null,seq__14087_14138);if(temp__4126__auto___14147)
{var seq__14087_14148__$1 = temp__4126__auto___14147;if(cljs.core.chunked_seq_QMARK_.call(null,seq__14087_14148__$1))
{var c__4418__auto___14149 = cljs.core.chunk_first.call(null,seq__14087_14148__$1);{
var G__14150 = cljs.core.chunk_rest.call(null,seq__14087_14148__$1);
var G__14151 = c__4418__auto___14149;
var G__14152 = cljs.core.count.call(null,c__4418__auto___14149);
var G__14153 = (0);
seq__14087_14138 = G__14150;
chunk__14088_14139 = G__14151;
count__14089_14140 = G__14152;
i__14090_14141 = G__14153;
continue;
}
} else
{var c_14154 = cljs.core.first.call(null,seq__14087_14148__$1);add_class_BANG_.call(null,elem,c_14154);
{
var G__14155 = cljs.core.next.call(null,seq__14087_14148__$1);
var G__14156 = null;
var G__14157 = (0);
var G__14158 = (0);
seq__14087_14138 = G__14155;
chunk__14088_14139 = G__14156;
count__14089_14140 = G__14157;
i__14090_14141 = G__14158;
continue;
}
}
} else
{}
}
break;
}
return elem;
};
var G__14137 = function (elem,classes,var_args){
var more_classes = null;if (arguments.length > 2) {
  more_classes = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);} 
return G__14137__delegate.call(this,elem,classes,more_classes);};
G__14137.cljs$lang$maxFixedArity = 2;
G__14137.cljs$lang$applyTo = (function (arglist__14159){
var elem = cljs.core.first(arglist__14159);
arglist__14159 = cljs.core.next(arglist__14159);
var classes = cljs.core.first(arglist__14159);
var more_classes = cljs.core.rest(arglist__14159);
return G__14137__delegate(elem,classes,more_classes);
});
G__14137.cljs$core$IFn$_invoke$arity$variadic = G__14137__delegate;
return G__14137;
})()
;
add_class_BANG_ = function(elem,classes,var_args){
var more_classes = var_args;
switch(arguments.length){
case 2:
return add_class_BANG___2.call(this,elem,classes);
default:
return add_class_BANG___3.cljs$core$IFn$_invoke$arity$variadic(elem,classes, cljs.core.array_seq(arguments, 2));
}
throw(new Error('Invalid arity: ' + arguments.length));
};
add_class_BANG_.cljs$lang$maxFixedArity = 2;
add_class_BANG_.cljs$lang$applyTo = add_class_BANG___3.cljs$lang$applyTo;
add_class_BANG_.cljs$core$IFn$_invoke$arity$2 = add_class_BANG___2;
add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic = add_class_BANG___3.cljs$core$IFn$_invoke$arity$variadic;
return add_class_BANG_;
})()
;
/**
* Remove `c` from `elem` class list
* @param {...*} var_args
*/
dommy.core.remove_class_BANG_ = (function() {
var remove_class_BANG_ = null;
var remove_class_BANG___2 = (function (elem,c){var c__$1 = dommy.utils.as_str.call(null,c);var temp__4124__auto___14168 = elem.classList;if(cljs.core.truth_(temp__4124__auto___14168))
{var class_list_14169 = temp__4124__auto___14168;class_list_14169.remove(c__$1);
} else
{var class_name_14170 = dommy.core.class$.call(null,elem);var new_class_name_14171 = dommy.utils.remove_class_str.call(null,class_name_14170,c__$1);if((class_name_14170 === new_class_name_14171))
{} else
{dommy.core.set_class_BANG_.call(null,elem,new_class_name_14171);
}
}
return elem;
});
var remove_class_BANG___3 = (function() { 
var G__14172__delegate = function (elem,class$,classes){var seq__14164 = cljs.core.seq.call(null,cljs.core.conj.call(null,classes,class$));var chunk__14165 = null;var count__14166 = (0);var i__14167 = (0);while(true){
if((i__14167 < count__14166))
{var c = cljs.core._nth.call(null,chunk__14165,i__14167);remove_class_BANG_.call(null,elem,c);
{
var G__14173 = seq__14164;
var G__14174 = chunk__14165;
var G__14175 = count__14166;
var G__14176 = (i__14167 + (1));
seq__14164 = G__14173;
chunk__14165 = G__14174;
count__14166 = G__14175;
i__14167 = G__14176;
continue;
}
} else
{var temp__4126__auto__ = cljs.core.seq.call(null,seq__14164);if(temp__4126__auto__)
{var seq__14164__$1 = temp__4126__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,seq__14164__$1))
{var c__4418__auto__ = cljs.core.chunk_first.call(null,seq__14164__$1);{
var G__14177 = cljs.core.chunk_rest.call(null,seq__14164__$1);
var G__14178 = c__4418__auto__;
var G__14179 = cljs.core.count.call(null,c__4418__auto__);
var G__14180 = (0);
seq__14164 = G__14177;
chunk__14165 = G__14178;
count__14166 = G__14179;
i__14167 = G__14180;
continue;
}
} else
{var c = cljs.core.first.call(null,seq__14164__$1);remove_class_BANG_.call(null,elem,c);
{
var G__14181 = cljs.core.next.call(null,seq__14164__$1);
var G__14182 = null;
var G__14183 = (0);
var G__14184 = (0);
seq__14164 = G__14181;
chunk__14165 = G__14182;
count__14166 = G__14183;
i__14167 = G__14184;
continue;
}
}
} else
{return null;
}
}
break;
}
};
var G__14172 = function (elem,class$,var_args){
var classes = null;if (arguments.length > 2) {
  classes = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);} 
return G__14172__delegate.call(this,elem,class$,classes);};
G__14172.cljs$lang$maxFixedArity = 2;
G__14172.cljs$lang$applyTo = (function (arglist__14185){
var elem = cljs.core.first(arglist__14185);
arglist__14185 = cljs.core.next(arglist__14185);
var class$ = cljs.core.first(arglist__14185);
var classes = cljs.core.rest(arglist__14185);
return G__14172__delegate(elem,class$,classes);
});
G__14172.cljs$core$IFn$_invoke$arity$variadic = G__14172__delegate;
return G__14172;
})()
;
remove_class_BANG_ = function(elem,class$,var_args){
var classes = var_args;
switch(arguments.length){
case 2:
return remove_class_BANG___2.call(this,elem,class$);
default:
return remove_class_BANG___3.cljs$core$IFn$_invoke$arity$variadic(elem,class$, cljs.core.array_seq(arguments, 2));
}
throw(new Error('Invalid arity: ' + arguments.length));
};
remove_class_BANG_.cljs$lang$maxFixedArity = 2;
remove_class_BANG_.cljs$lang$applyTo = remove_class_BANG___3.cljs$lang$applyTo;
remove_class_BANG_.cljs$core$IFn$_invoke$arity$2 = remove_class_BANG___2;
remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic = remove_class_BANG___3.cljs$core$IFn$_invoke$arity$variadic;
return remove_class_BANG_;
})()
;
/**
* (toggle-class! elem class) will add-class! if elem does not have class
* and remove-class! otherwise.
* (toggle-class! elem class add?) will add-class! if add? is truthy,
* otherwise it will remove-class!
*/
dommy.core.toggle_class_BANG_ = (function() {
var toggle_class_BANG_ = null;
var toggle_class_BANG___2 = (function (elem,c){var c__$1 = dommy.utils.as_str.call(null,c);var temp__4124__auto___14186 = elem.classList;if(cljs.core.truth_(temp__4124__auto___14186))
{var class_list_14187 = temp__4124__auto___14186;class_list_14187.toggle(c__$1);
} else
{toggle_class_BANG_.call(null,elem,c__$1,!(dommy.core.has_class_QMARK_.call(null,elem,c__$1)));
}
return elem;
});
var toggle_class_BANG___3 = (function (elem,class$,add_QMARK_){if(add_QMARK_)
{dommy.core.add_class_BANG_.call(null,elem,class$);
} else
{dommy.core.remove_class_BANG_.call(null,elem,class$);
}
return elem;
});
toggle_class_BANG_ = function(elem,class$,add_QMARK_){
switch(arguments.length){
case 2:
return toggle_class_BANG___2.call(this,elem,class$);
case 3:
return toggle_class_BANG___3.call(this,elem,class$,add_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
toggle_class_BANG_.cljs$core$IFn$_invoke$arity$2 = toggle_class_BANG___2;
toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3 = toggle_class_BANG___3;
return toggle_class_BANG_;
})()
;
/**
* Display or hide the given `elem` (using display: none).
* Takes an optional boolean `show?`
*/
dommy.core.toggle_BANG_ = (function() {
var toggle_BANG_ = null;
var toggle_BANG___1 = (function (elem){return toggle_BANG_.call(null,elem,dommy.core.hidden_QMARK_.call(null,elem));
});
var toggle_BANG___2 = (function (elem,show_QMARK_){return dommy.core.set_style_BANG_.call(null,elem,new cljs.core.Keyword(null,"display","display",242065432),((show_QMARK_)?"":"none"));
});
toggle_BANG_ = function(elem,show_QMARK_){
switch(arguments.length){
case 1:
return toggle_BANG___1.call(this,elem);
case 2:
return toggle_BANG___2.call(this,elem,show_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
toggle_BANG_.cljs$core$IFn$_invoke$arity$1 = toggle_BANG___1;
toggle_BANG_.cljs$core$IFn$_invoke$arity$2 = toggle_BANG___2;
return toggle_BANG_;
})()
;
dommy.core.hide_BANG_ = (function hide_BANG_(elem){return dommy.core.toggle_BANG_.call(null,elem,false);
});
dommy.core.show_BANG_ = (function show_BANG_(elem){return dommy.core.toggle_BANG_.call(null,elem,true);
});
dommy.core.scroll_into_view = (function scroll_into_view(elem,align_with_top_QMARK_){var top = new cljs.core.Keyword(null,"top","top",-1856271961).cljs$core$IFn$_invoke$arity$1(dommy.core.bounding_client_rect.call(null,elem));if((window.innerHeight < (top + elem.offsetHeight)))
{return elem.scrollIntoView(align_with_top_QMARK_);
} else
{return null;
}
});
dommy.core.create_element = (function() {
var create_element = null;
var create_element__1 = (function (tag){return document.createElement(dommy.utils.as_str.call(null,tag));
});
var create_element__2 = (function (tag_ns,tag){return document.createElementNS(dommy.utils.as_str.call(null,tag_ns),dommy.utils.as_str.call(null,tag));
});
create_element = function(tag_ns,tag){
switch(arguments.length){
case 1:
return create_element__1.call(this,tag_ns);
case 2:
return create_element__2.call(this,tag_ns,tag);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
create_element.cljs$core$IFn$_invoke$arity$1 = create_element__1;
create_element.cljs$core$IFn$_invoke$arity$2 = create_element__2;
return create_element;
})()
;
dommy.core.create_text_node = (function create_text_node(text){return document.createTextNode(text);
});
/**
* Clears all children from `elem`
*/
dommy.core.clear_BANG_ = (function clear_BANG_(elem){return dommy.core.set_html_BANG_.call(null,elem,"");
});
/**
* Append `child` to `parent`
* @param {...*} var_args
*/
dommy.core.append_BANG_ = (function() {
var append_BANG_ = null;
var append_BANG___2 = (function (parent,child){var G__14193 = parent;G__14193.appendChild(child);
return G__14193;
});
var append_BANG___3 = (function() { 
var G__14198__delegate = function (parent,child,more_children){var seq__14194_14199 = cljs.core.seq.call(null,cljs.core.cons.call(null,child,more_children));var chunk__14195_14200 = null;var count__14196_14201 = (0);var i__14197_14202 = (0);while(true){
if((i__14197_14202 < count__14196_14201))
{var c_14203 = cljs.core._nth.call(null,chunk__14195_14200,i__14197_14202);append_BANG_.call(null,parent,c_14203);
{
var G__14204 = seq__14194_14199;
var G__14205 = chunk__14195_14200;
var G__14206 = count__14196_14201;
var G__14207 = (i__14197_14202 + (1));
seq__14194_14199 = G__14204;
chunk__14195_14200 = G__14205;
count__14196_14201 = G__14206;
i__14197_14202 = G__14207;
continue;
}
} else
{var temp__4126__auto___14208 = cljs.core.seq.call(null,seq__14194_14199);if(temp__4126__auto___14208)
{var seq__14194_14209__$1 = temp__4126__auto___14208;if(cljs.core.chunked_seq_QMARK_.call(null,seq__14194_14209__$1))
{var c__4418__auto___14210 = cljs.core.chunk_first.call(null,seq__14194_14209__$1);{
var G__14211 = cljs.core.chunk_rest.call(null,seq__14194_14209__$1);
var G__14212 = c__4418__auto___14210;
var G__14213 = cljs.core.count.call(null,c__4418__auto___14210);
var G__14214 = (0);
seq__14194_14199 = G__14211;
chunk__14195_14200 = G__14212;
count__14196_14201 = G__14213;
i__14197_14202 = G__14214;
continue;
}
} else
{var c_14215 = cljs.core.first.call(null,seq__14194_14209__$1);append_BANG_.call(null,parent,c_14215);
{
var G__14216 = cljs.core.next.call(null,seq__14194_14209__$1);
var G__14217 = null;
var G__14218 = (0);
var G__14219 = (0);
seq__14194_14199 = G__14216;
chunk__14195_14200 = G__14217;
count__14196_14201 = G__14218;
i__14197_14202 = G__14219;
continue;
}
}
} else
{}
}
break;
}
return parent;
};
var G__14198 = function (parent,child,var_args){
var more_children = null;if (arguments.length > 2) {
  more_children = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);} 
return G__14198__delegate.call(this,parent,child,more_children);};
G__14198.cljs$lang$maxFixedArity = 2;
G__14198.cljs$lang$applyTo = (function (arglist__14220){
var parent = cljs.core.first(arglist__14220);
arglist__14220 = cljs.core.next(arglist__14220);
var child = cljs.core.first(arglist__14220);
var more_children = cljs.core.rest(arglist__14220);
return G__14198__delegate(parent,child,more_children);
});
G__14198.cljs$core$IFn$_invoke$arity$variadic = G__14198__delegate;
return G__14198;
})()
;
append_BANG_ = function(parent,child,var_args){
var more_children = var_args;
switch(arguments.length){
case 2:
return append_BANG___2.call(this,parent,child);
default:
return append_BANG___3.cljs$core$IFn$_invoke$arity$variadic(parent,child, cljs.core.array_seq(arguments, 2));
}
throw(new Error('Invalid arity: ' + arguments.length));
};
append_BANG_.cljs$lang$maxFixedArity = 2;
append_BANG_.cljs$lang$applyTo = append_BANG___3.cljs$lang$applyTo;
append_BANG_.cljs$core$IFn$_invoke$arity$2 = append_BANG___2;
append_BANG_.cljs$core$IFn$_invoke$arity$variadic = append_BANG___3.cljs$core$IFn$_invoke$arity$variadic;
return append_BANG_;
})()
;
/**
* Prepend `child` to `parent`
* @param {...*} var_args
*/
dommy.core.prepend_BANG_ = (function() {
var prepend_BANG_ = null;
var prepend_BANG___2 = (function (parent,child){var G__14226 = parent;G__14226.insertBefore(child,parent.firstChild);
return G__14226;
});
var prepend_BANG___3 = (function() { 
var G__14231__delegate = function (parent,child,more_children){var seq__14227_14232 = cljs.core.seq.call(null,cljs.core.cons.call(null,child,more_children));var chunk__14228_14233 = null;var count__14229_14234 = (0);var i__14230_14235 = (0);while(true){
if((i__14230_14235 < count__14229_14234))
{var c_14236 = cljs.core._nth.call(null,chunk__14228_14233,i__14230_14235);prepend_BANG_.call(null,parent,c_14236);
{
var G__14237 = seq__14227_14232;
var G__14238 = chunk__14228_14233;
var G__14239 = count__14229_14234;
var G__14240 = (i__14230_14235 + (1));
seq__14227_14232 = G__14237;
chunk__14228_14233 = G__14238;
count__14229_14234 = G__14239;
i__14230_14235 = G__14240;
continue;
}
} else
{var temp__4126__auto___14241 = cljs.core.seq.call(null,seq__14227_14232);if(temp__4126__auto___14241)
{var seq__14227_14242__$1 = temp__4126__auto___14241;if(cljs.core.chunked_seq_QMARK_.call(null,seq__14227_14242__$1))
{var c__4418__auto___14243 = cljs.core.chunk_first.call(null,seq__14227_14242__$1);{
var G__14244 = cljs.core.chunk_rest.call(null,seq__14227_14242__$1);
var G__14245 = c__4418__auto___14243;
var G__14246 = cljs.core.count.call(null,c__4418__auto___14243);
var G__14247 = (0);
seq__14227_14232 = G__14244;
chunk__14228_14233 = G__14245;
count__14229_14234 = G__14246;
i__14230_14235 = G__14247;
continue;
}
} else
{var c_14248 = cljs.core.first.call(null,seq__14227_14242__$1);prepend_BANG_.call(null,parent,c_14248);
{
var G__14249 = cljs.core.next.call(null,seq__14227_14242__$1);
var G__14250 = null;
var G__14251 = (0);
var G__14252 = (0);
seq__14227_14232 = G__14249;
chunk__14228_14233 = G__14250;
count__14229_14234 = G__14251;
i__14230_14235 = G__14252;
continue;
}
}
} else
{}
}
break;
}
return parent;
};
var G__14231 = function (parent,child,var_args){
var more_children = null;if (arguments.length > 2) {
  more_children = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);} 
return G__14231__delegate.call(this,parent,child,more_children);};
G__14231.cljs$lang$maxFixedArity = 2;
G__14231.cljs$lang$applyTo = (function (arglist__14253){
var parent = cljs.core.first(arglist__14253);
arglist__14253 = cljs.core.next(arglist__14253);
var child = cljs.core.first(arglist__14253);
var more_children = cljs.core.rest(arglist__14253);
return G__14231__delegate(parent,child,more_children);
});
G__14231.cljs$core$IFn$_invoke$arity$variadic = G__14231__delegate;
return G__14231;
})()
;
prepend_BANG_ = function(parent,child,var_args){
var more_children = var_args;
switch(arguments.length){
case 2:
return prepend_BANG___2.call(this,parent,child);
default:
return prepend_BANG___3.cljs$core$IFn$_invoke$arity$variadic(parent,child, cljs.core.array_seq(arguments, 2));
}
throw(new Error('Invalid arity: ' + arguments.length));
};
prepend_BANG_.cljs$lang$maxFixedArity = 2;
prepend_BANG_.cljs$lang$applyTo = prepend_BANG___3.cljs$lang$applyTo;
prepend_BANG_.cljs$core$IFn$_invoke$arity$2 = prepend_BANG___2;
prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic = prepend_BANG___3.cljs$core$IFn$_invoke$arity$variadic;
return prepend_BANG_;
})()
;
/**
* Insert `elem` before `other`, `other` must have a parent
*/
dommy.core.insert_before_BANG_ = (function insert_before_BANG_(elem,other){var p = dommy.core.parent.call(null,other);if(cljs.core.truth_(p))
{} else
{throw (new Error(("Assert failed: Target element must have a parent\n"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"p","p",1791580836,null))))));
}
p.insertBefore(elem,other);
return elem;
});
/**
* Insert `elem` after `other`, `other` must have a parent
*/
dommy.core.insert_after_BANG_ = (function insert_after_BANG_(elem,other){var temp__4124__auto___14254 = other.nextSibling;if(cljs.core.truth_(temp__4124__auto___14254))
{var next_14255 = temp__4124__auto___14254;dommy.core.insert_before_BANG_.call(null,elem,next_14255);
} else
{dommy.core.append_BANG_.call(null,dommy.core.parent.call(null,other),elem);
}
return elem;
});
/**
* Replace `elem` with `new`, return `new`
*/
dommy.core.replace_BANG_ = (function replace_BANG_(elem,new$){var p = dommy.core.parent.call(null,elem);if(cljs.core.truth_(p))
{} else
{throw (new Error(("Assert failed: Target element must have a parent\n"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"p","p",1791580836,null))))));
}
p.replaceChild(new$,elem);
return new$;
});
/**
* Replace children of `elem` with `child`
*/
dommy.core.replace_contents_BANG_ = (function replace_contents_BANG_(p,child){return dommy.core.append_BANG_.call(null,dommy.core.clear_BANG_.call(null,p),child);
});
/**
* Remove `elem` from `parent`, return `parent`
*/
dommy.core.remove_BANG_ = (function() {
var remove_BANG_ = null;
var remove_BANG___1 = (function (elem){var p = dommy.core.parent.call(null,elem);if(cljs.core.truth_(p))
{} else
{throw (new Error(("Assert failed: Target element must have a parent\n"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"p","p",1791580836,null))))));
}
return remove_BANG_.call(null,p,elem);
});
var remove_BANG___2 = (function (p,elem){var G__14257 = p;G__14257.removeChild(elem);
return G__14257;
});
remove_BANG_ = function(p,elem){
switch(arguments.length){
case 1:
return remove_BANG___1.call(this,p);
case 2:
return remove_BANG___2.call(this,p,elem);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
remove_BANG_.cljs$core$IFn$_invoke$arity$1 = remove_BANG___1;
remove_BANG_.cljs$core$IFn$_invoke$arity$2 = remove_BANG___2;
return remove_BANG_;
})()
;
dommy.core.special_listener_makers = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,(function (p__14258){var vec__14259 = p__14258;var special_mouse_event = cljs.core.nth.call(null,vec__14259,(0),null);var real_mouse_event = cljs.core.nth.call(null,vec__14259,(1),null);return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [special_mouse_event,new cljs.core.PersistentArrayMap.fromArray([real_mouse_event,((function (vec__14259,special_mouse_event,real_mouse_event){
return (function (f){return ((function (vec__14259,special_mouse_event,real_mouse_event){
return (function (event){var related_target = event.relatedTarget;var listener_target = (function (){var or__3648__auto__ = event.selectedTarget;if(cljs.core.truth_(or__3648__auto__))
{return or__3648__auto__;
} else
{return event.currentTarget;
}
})();if(cljs.core.truth_((function (){var and__3636__auto__ = related_target;if(cljs.core.truth_(and__3636__auto__))
{return dommy.core.descendant_QMARK_.call(null,related_target,listener_target);
} else
{return and__3636__auto__;
}
})()))
{return null;
} else
{return f.call(null,event);
}
});
;})(vec__14259,special_mouse_event,real_mouse_event))
});})(vec__14259,special_mouse_event,real_mouse_event))
], true, false)], null);
}),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"mouseenter","mouseenter",-1792413560),new cljs.core.Keyword(null,"mouseover","mouseover",-484272303),new cljs.core.Keyword(null,"mouseleave","mouseleave",531566580),new cljs.core.Keyword(null,"mouseout","mouseout",2049446890)], null)));
/**
* fires f if event.target is found with `selector`
*/
dommy.core.live_listener = (function live_listener(elem,selector,f){return (function (event){var selected_target = dommy.core.closest.call(null,elem,event.target,selector);if(cljs.core.truth_((function (){var and__3636__auto__ = selected_target;if(cljs.core.truth_(and__3636__auto__))
{return cljs.core.not.call(null,dommy.core.attr.call(null,selected_target,new cljs.core.Keyword(null,"disabled","disabled",-1529784218)));
} else
{return and__3636__auto__;
}
})()))
{event.selectedTarget = selected_target;
return f.call(null,event);
} else
{return null;
}
});
});
/**
* Returns a nested map of event listeners on `elem`
*/
dommy.core.event_listeners = (function event_listeners(elem){var or__3648__auto__ = elem.dommyEventListeners;if(cljs.core.truth_(or__3648__auto__))
{return or__3648__auto__;
} else
{return cljs.core.PersistentArrayMap.EMPTY;
}
});
/**
* @param {...*} var_args
*/
dommy.core.update_event_listeners_BANG_ = (function() { 
var update_event_listeners_BANG___delegate = function (elem,f,args){var elem__$1 = elem;return elem__$1.dommyEventListeners = cljs.core.apply.call(null,f,dommy.core.event_listeners.call(null,elem__$1),args);
};
var update_event_listeners_BANG_ = function (elem,f,var_args){
var args = null;if (arguments.length > 2) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);} 
return update_event_listeners_BANG___delegate.call(this,elem,f,args);};
update_event_listeners_BANG_.cljs$lang$maxFixedArity = 2;
update_event_listeners_BANG_.cljs$lang$applyTo = (function (arglist__14260){
var elem = cljs.core.first(arglist__14260);
arglist__14260 = cljs.core.next(arglist__14260);
var f = cljs.core.first(arglist__14260);
var args = cljs.core.rest(arglist__14260);
return update_event_listeners_BANG___delegate(elem,f,args);
});
update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic = update_event_listeners_BANG___delegate;
return update_event_listeners_BANG_;
})()
;
dommy.core.elem_and_selector = (function elem_and_selector(elem_sel){if(cljs.core.sequential_QMARK_.call(null,elem_sel))
{return cljs.core.juxt.call(null,cljs.core.first,cljs.core.rest).call(null,elem_sel);
} else
{return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [elem_sel,null], null);
}
});
/**
* Adds `f` as a listener for events of type `event-type` on
* `elem-sel`, which must either be a DOM node, or a sequence
* whose first item is a DOM node.
* 
* In other words, the call to `listen!` can take two forms:
* 
* If `elem-sel` is a DOM node, i.e., you're doing something like:
* 
* (listen! elem :click click-handler)
* 
* then `click-handler` will be set as a listener for `click` events
* on the `elem`.
* 
* If `elem-sel` is a sequence:
* 
* (listen! [elem :.selector.for :.some.descendants] :click click-handler)
* 
* then `click-handler` will be set as a listener for `click` events
* on descendants of `elem` that match the selector
* 
* Also accepts any number of event-type and handler pairs for setting
* multiple listeners at once:
* 
* (listen! some-elem :click click-handler :hover hover-handler)
* @param {...*} var_args
*/
dommy.core.listen_BANG_ = (function() { 
var listen_BANG___delegate = function (elem_sel,type_fs){if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,type_fs)))
{} else
{throw (new Error(("Assert failed: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"type-fs","type-fs",1567896074,null))))))));
}
var vec__14284_14307 = dommy.core.elem_and_selector.call(null,elem_sel);var elem_14308 = cljs.core.nth.call(null,vec__14284_14307,(0),null);var selector_14309 = cljs.core.nth.call(null,vec__14284_14307,(1),null);var seq__14285_14310 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),type_fs));var chunk__14292_14311 = null;var count__14293_14312 = (0);var i__14294_14313 = (0);while(true){
if((i__14294_14313 < count__14293_14312))
{var vec__14301_14314 = cljs.core._nth.call(null,chunk__14292_14311,i__14294_14313);var orig_type_14315 = cljs.core.nth.call(null,vec__14301_14314,(0),null);var f_14316 = cljs.core.nth.call(null,vec__14301_14314,(1),null);var seq__14295_14317 = cljs.core.seq.call(null,cljs.core.get.call(null,dommy.core.special_listener_makers,orig_type_14315,new cljs.core.PersistentArrayMap.fromArray([orig_type_14315,cljs.core.identity], true, false)));var chunk__14297_14318 = null;var count__14298_14319 = (0);var i__14299_14320 = (0);while(true){
if((i__14299_14320 < count__14298_14319))
{var vec__14302_14321 = cljs.core._nth.call(null,chunk__14297_14318,i__14299_14320);var actual_type_14322 = cljs.core.nth.call(null,vec__14302_14321,(0),null);var factory_14323 = cljs.core.nth.call(null,vec__14302_14321,(1),null);var canonical_f_14324 = (cljs.core.truth_(selector_14309)?cljs.core.partial.call(null,dommy.core.live_listener,elem_14308,selector_14309):cljs.core.identity).call(null,factory_14323.call(null,f_14316));dommy.core.update_event_listeners_BANG_.call(null,elem_14308,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_14309,actual_type_14322,f_14316], null),canonical_f_14324);
if(cljs.core.truth_(elem_14308.addEventListener))
{elem_14308.addEventListener(cljs.core.name.call(null,actual_type_14322),canonical_f_14324);
} else
{elem_14308.attachEvent(cljs.core.name.call(null,actual_type_14322),canonical_f_14324);
}
{
var G__14325 = seq__14295_14317;
var G__14326 = chunk__14297_14318;
var G__14327 = count__14298_14319;
var G__14328 = (i__14299_14320 + (1));
seq__14295_14317 = G__14325;
chunk__14297_14318 = G__14326;
count__14298_14319 = G__14327;
i__14299_14320 = G__14328;
continue;
}
} else
{var temp__4126__auto___14329 = cljs.core.seq.call(null,seq__14295_14317);if(temp__4126__auto___14329)
{var seq__14295_14330__$1 = temp__4126__auto___14329;if(cljs.core.chunked_seq_QMARK_.call(null,seq__14295_14330__$1))
{var c__4418__auto___14331 = cljs.core.chunk_first.call(null,seq__14295_14330__$1);{
var G__14332 = cljs.core.chunk_rest.call(null,seq__14295_14330__$1);
var G__14333 = c__4418__auto___14331;
var G__14334 = cljs.core.count.call(null,c__4418__auto___14331);
var G__14335 = (0);
seq__14295_14317 = G__14332;
chunk__14297_14318 = G__14333;
count__14298_14319 = G__14334;
i__14299_14320 = G__14335;
continue;
}
} else
{var vec__14303_14336 = cljs.core.first.call(null,seq__14295_14330__$1);var actual_type_14337 = cljs.core.nth.call(null,vec__14303_14336,(0),null);var factory_14338 = cljs.core.nth.call(null,vec__14303_14336,(1),null);var canonical_f_14339 = (cljs.core.truth_(selector_14309)?cljs.core.partial.call(null,dommy.core.live_listener,elem_14308,selector_14309):cljs.core.identity).call(null,factory_14338.call(null,f_14316));dommy.core.update_event_listeners_BANG_.call(null,elem_14308,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_14309,actual_type_14337,f_14316], null),canonical_f_14339);
if(cljs.core.truth_(elem_14308.addEventListener))
{elem_14308.addEventListener(cljs.core.name.call(null,actual_type_14337),canonical_f_14339);
} else
{elem_14308.attachEvent(cljs.core.name.call(null,actual_type_14337),canonical_f_14339);
}
{
var G__14340 = cljs.core.next.call(null,seq__14295_14330__$1);
var G__14341 = null;
var G__14342 = (0);
var G__14343 = (0);
seq__14295_14317 = G__14340;
chunk__14297_14318 = G__14341;
count__14298_14319 = G__14342;
i__14299_14320 = G__14343;
continue;
}
}
} else
{}
}
break;
}
{
var G__14344 = seq__14285_14310;
var G__14345 = chunk__14292_14311;
var G__14346 = count__14293_14312;
var G__14347 = (i__14294_14313 + (1));
seq__14285_14310 = G__14344;
chunk__14292_14311 = G__14345;
count__14293_14312 = G__14346;
i__14294_14313 = G__14347;
continue;
}
} else
{var temp__4126__auto___14348 = cljs.core.seq.call(null,seq__14285_14310);if(temp__4126__auto___14348)
{var seq__14285_14349__$1 = temp__4126__auto___14348;if(cljs.core.chunked_seq_QMARK_.call(null,seq__14285_14349__$1))
{var c__4418__auto___14350 = cljs.core.chunk_first.call(null,seq__14285_14349__$1);{
var G__14351 = cljs.core.chunk_rest.call(null,seq__14285_14349__$1);
var G__14352 = c__4418__auto___14350;
var G__14353 = cljs.core.count.call(null,c__4418__auto___14350);
var G__14354 = (0);
seq__14285_14310 = G__14351;
chunk__14292_14311 = G__14352;
count__14293_14312 = G__14353;
i__14294_14313 = G__14354;
continue;
}
} else
{var vec__14304_14355 = cljs.core.first.call(null,seq__14285_14349__$1);var orig_type_14356 = cljs.core.nth.call(null,vec__14304_14355,(0),null);var f_14357 = cljs.core.nth.call(null,vec__14304_14355,(1),null);var seq__14286_14358 = cljs.core.seq.call(null,cljs.core.get.call(null,dommy.core.special_listener_makers,orig_type_14356,new cljs.core.PersistentArrayMap.fromArray([orig_type_14356,cljs.core.identity], true, false)));var chunk__14288_14359 = null;var count__14289_14360 = (0);var i__14290_14361 = (0);while(true){
if((i__14290_14361 < count__14289_14360))
{var vec__14305_14362 = cljs.core._nth.call(null,chunk__14288_14359,i__14290_14361);var actual_type_14363 = cljs.core.nth.call(null,vec__14305_14362,(0),null);var factory_14364 = cljs.core.nth.call(null,vec__14305_14362,(1),null);var canonical_f_14365 = (cljs.core.truth_(selector_14309)?cljs.core.partial.call(null,dommy.core.live_listener,elem_14308,selector_14309):cljs.core.identity).call(null,factory_14364.call(null,f_14357));dommy.core.update_event_listeners_BANG_.call(null,elem_14308,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_14309,actual_type_14363,f_14357], null),canonical_f_14365);
if(cljs.core.truth_(elem_14308.addEventListener))
{elem_14308.addEventListener(cljs.core.name.call(null,actual_type_14363),canonical_f_14365);
} else
{elem_14308.attachEvent(cljs.core.name.call(null,actual_type_14363),canonical_f_14365);
}
{
var G__14366 = seq__14286_14358;
var G__14367 = chunk__14288_14359;
var G__14368 = count__14289_14360;
var G__14369 = (i__14290_14361 + (1));
seq__14286_14358 = G__14366;
chunk__14288_14359 = G__14367;
count__14289_14360 = G__14368;
i__14290_14361 = G__14369;
continue;
}
} else
{var temp__4126__auto___14370__$1 = cljs.core.seq.call(null,seq__14286_14358);if(temp__4126__auto___14370__$1)
{var seq__14286_14371__$1 = temp__4126__auto___14370__$1;if(cljs.core.chunked_seq_QMARK_.call(null,seq__14286_14371__$1))
{var c__4418__auto___14372 = cljs.core.chunk_first.call(null,seq__14286_14371__$1);{
var G__14373 = cljs.core.chunk_rest.call(null,seq__14286_14371__$1);
var G__14374 = c__4418__auto___14372;
var G__14375 = cljs.core.count.call(null,c__4418__auto___14372);
var G__14376 = (0);
seq__14286_14358 = G__14373;
chunk__14288_14359 = G__14374;
count__14289_14360 = G__14375;
i__14290_14361 = G__14376;
continue;
}
} else
{var vec__14306_14377 = cljs.core.first.call(null,seq__14286_14371__$1);var actual_type_14378 = cljs.core.nth.call(null,vec__14306_14377,(0),null);var factory_14379 = cljs.core.nth.call(null,vec__14306_14377,(1),null);var canonical_f_14380 = (cljs.core.truth_(selector_14309)?cljs.core.partial.call(null,dommy.core.live_listener,elem_14308,selector_14309):cljs.core.identity).call(null,factory_14379.call(null,f_14357));dommy.core.update_event_listeners_BANG_.call(null,elem_14308,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_14309,actual_type_14378,f_14357], null),canonical_f_14380);
if(cljs.core.truth_(elem_14308.addEventListener))
{elem_14308.addEventListener(cljs.core.name.call(null,actual_type_14378),canonical_f_14380);
} else
{elem_14308.attachEvent(cljs.core.name.call(null,actual_type_14378),canonical_f_14380);
}
{
var G__14381 = cljs.core.next.call(null,seq__14286_14371__$1);
var G__14382 = null;
var G__14383 = (0);
var G__14384 = (0);
seq__14286_14358 = G__14381;
chunk__14288_14359 = G__14382;
count__14289_14360 = G__14383;
i__14290_14361 = G__14384;
continue;
}
}
} else
{}
}
break;
}
{
var G__14385 = cljs.core.next.call(null,seq__14285_14349__$1);
var G__14386 = null;
var G__14387 = (0);
var G__14388 = (0);
seq__14285_14310 = G__14385;
chunk__14292_14311 = G__14386;
count__14293_14312 = G__14387;
i__14294_14313 = G__14388;
continue;
}
}
} else
{}
}
break;
}
return elem_sel;
};
var listen_BANG_ = function (elem_sel,var_args){
var type_fs = null;if (arguments.length > 1) {
  type_fs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return listen_BANG___delegate.call(this,elem_sel,type_fs);};
listen_BANG_.cljs$lang$maxFixedArity = 1;
listen_BANG_.cljs$lang$applyTo = (function (arglist__14389){
var elem_sel = cljs.core.first(arglist__14389);
var type_fs = cljs.core.rest(arglist__14389);
return listen_BANG___delegate(elem_sel,type_fs);
});
listen_BANG_.cljs$core$IFn$_invoke$arity$variadic = listen_BANG___delegate;
return listen_BANG_;
})()
;
/**
* Removes event listener for the element defined in `elem-sel`,
* which is the same format as listen!.
* 
* The following forms are allowed, and will remove all handlers
* that match the parameters passed in:
* 
* (unlisten! [elem :.selector] :click event-listener)
* 
* (unlisten! [elem :.selector]
* :click event-listener
* :mouseover other-event-listener)
* @param {...*} var_args
*/
dommy.core.unlisten_BANG_ = (function() { 
var unlisten_BANG___delegate = function (elem_sel,type_fs){if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,type_fs)))
{} else
{throw (new Error(("Assert failed: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"type-fs","type-fs",1567896074,null))))))));
}
var vec__14413_14436 = dommy.core.elem_and_selector.call(null,elem_sel);var elem_14437 = cljs.core.nth.call(null,vec__14413_14436,(0),null);var selector_14438 = cljs.core.nth.call(null,vec__14413_14436,(1),null);var seq__14414_14439 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),type_fs));var chunk__14421_14440 = null;var count__14422_14441 = (0);var i__14423_14442 = (0);while(true){
if((i__14423_14442 < count__14422_14441))
{var vec__14430_14443 = cljs.core._nth.call(null,chunk__14421_14440,i__14423_14442);var orig_type_14444 = cljs.core.nth.call(null,vec__14430_14443,(0),null);var f_14445 = cljs.core.nth.call(null,vec__14430_14443,(1),null);var seq__14424_14446 = cljs.core.seq.call(null,cljs.core.get.call(null,dommy.core.special_listener_makers,orig_type_14444,new cljs.core.PersistentArrayMap.fromArray([orig_type_14444,cljs.core.identity], true, false)));var chunk__14426_14447 = null;var count__14427_14448 = (0);var i__14428_14449 = (0);while(true){
if((i__14428_14449 < count__14427_14448))
{var vec__14431_14450 = cljs.core._nth.call(null,chunk__14426_14447,i__14428_14449);var actual_type_14451 = cljs.core.nth.call(null,vec__14431_14450,(0),null);var __14452 = cljs.core.nth.call(null,vec__14431_14450,(1),null);var keys_14453 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_14438,actual_type_14451,f_14445], null);var canonical_f_14454 = cljs.core.get_in.call(null,dommy.core.event_listeners.call(null,elem_14437),keys_14453);dommy.core.update_event_listeners_BANG_.call(null,elem_14437,dommy.utils.dissoc_in,keys_14453);
if(cljs.core.truth_(elem_14437.removeEventListener))
{elem_14437.removeEventListener(cljs.core.name.call(null,actual_type_14451),canonical_f_14454);
} else
{elem_14437.detachEvent(cljs.core.name.call(null,actual_type_14451),canonical_f_14454);
}
{
var G__14455 = seq__14424_14446;
var G__14456 = chunk__14426_14447;
var G__14457 = count__14427_14448;
var G__14458 = (i__14428_14449 + (1));
seq__14424_14446 = G__14455;
chunk__14426_14447 = G__14456;
count__14427_14448 = G__14457;
i__14428_14449 = G__14458;
continue;
}
} else
{var temp__4126__auto___14459 = cljs.core.seq.call(null,seq__14424_14446);if(temp__4126__auto___14459)
{var seq__14424_14460__$1 = temp__4126__auto___14459;if(cljs.core.chunked_seq_QMARK_.call(null,seq__14424_14460__$1))
{var c__4418__auto___14461 = cljs.core.chunk_first.call(null,seq__14424_14460__$1);{
var G__14462 = cljs.core.chunk_rest.call(null,seq__14424_14460__$1);
var G__14463 = c__4418__auto___14461;
var G__14464 = cljs.core.count.call(null,c__4418__auto___14461);
var G__14465 = (0);
seq__14424_14446 = G__14462;
chunk__14426_14447 = G__14463;
count__14427_14448 = G__14464;
i__14428_14449 = G__14465;
continue;
}
} else
{var vec__14432_14466 = cljs.core.first.call(null,seq__14424_14460__$1);var actual_type_14467 = cljs.core.nth.call(null,vec__14432_14466,(0),null);var __14468 = cljs.core.nth.call(null,vec__14432_14466,(1),null);var keys_14469 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_14438,actual_type_14467,f_14445], null);var canonical_f_14470 = cljs.core.get_in.call(null,dommy.core.event_listeners.call(null,elem_14437),keys_14469);dommy.core.update_event_listeners_BANG_.call(null,elem_14437,dommy.utils.dissoc_in,keys_14469);
if(cljs.core.truth_(elem_14437.removeEventListener))
{elem_14437.removeEventListener(cljs.core.name.call(null,actual_type_14467),canonical_f_14470);
} else
{elem_14437.detachEvent(cljs.core.name.call(null,actual_type_14467),canonical_f_14470);
}
{
var G__14471 = cljs.core.next.call(null,seq__14424_14460__$1);
var G__14472 = null;
var G__14473 = (0);
var G__14474 = (0);
seq__14424_14446 = G__14471;
chunk__14426_14447 = G__14472;
count__14427_14448 = G__14473;
i__14428_14449 = G__14474;
continue;
}
}
} else
{}
}
break;
}
{
var G__14475 = seq__14414_14439;
var G__14476 = chunk__14421_14440;
var G__14477 = count__14422_14441;
var G__14478 = (i__14423_14442 + (1));
seq__14414_14439 = G__14475;
chunk__14421_14440 = G__14476;
count__14422_14441 = G__14477;
i__14423_14442 = G__14478;
continue;
}
} else
{var temp__4126__auto___14479 = cljs.core.seq.call(null,seq__14414_14439);if(temp__4126__auto___14479)
{var seq__14414_14480__$1 = temp__4126__auto___14479;if(cljs.core.chunked_seq_QMARK_.call(null,seq__14414_14480__$1))
{var c__4418__auto___14481 = cljs.core.chunk_first.call(null,seq__14414_14480__$1);{
var G__14482 = cljs.core.chunk_rest.call(null,seq__14414_14480__$1);
var G__14483 = c__4418__auto___14481;
var G__14484 = cljs.core.count.call(null,c__4418__auto___14481);
var G__14485 = (0);
seq__14414_14439 = G__14482;
chunk__14421_14440 = G__14483;
count__14422_14441 = G__14484;
i__14423_14442 = G__14485;
continue;
}
} else
{var vec__14433_14486 = cljs.core.first.call(null,seq__14414_14480__$1);var orig_type_14487 = cljs.core.nth.call(null,vec__14433_14486,(0),null);var f_14488 = cljs.core.nth.call(null,vec__14433_14486,(1),null);var seq__14415_14489 = cljs.core.seq.call(null,cljs.core.get.call(null,dommy.core.special_listener_makers,orig_type_14487,new cljs.core.PersistentArrayMap.fromArray([orig_type_14487,cljs.core.identity], true, false)));var chunk__14417_14490 = null;var count__14418_14491 = (0);var i__14419_14492 = (0);while(true){
if((i__14419_14492 < count__14418_14491))
{var vec__14434_14493 = cljs.core._nth.call(null,chunk__14417_14490,i__14419_14492);var actual_type_14494 = cljs.core.nth.call(null,vec__14434_14493,(0),null);var __14495 = cljs.core.nth.call(null,vec__14434_14493,(1),null);var keys_14496 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_14438,actual_type_14494,f_14488], null);var canonical_f_14497 = cljs.core.get_in.call(null,dommy.core.event_listeners.call(null,elem_14437),keys_14496);dommy.core.update_event_listeners_BANG_.call(null,elem_14437,dommy.utils.dissoc_in,keys_14496);
if(cljs.core.truth_(elem_14437.removeEventListener))
{elem_14437.removeEventListener(cljs.core.name.call(null,actual_type_14494),canonical_f_14497);
} else
{elem_14437.detachEvent(cljs.core.name.call(null,actual_type_14494),canonical_f_14497);
}
{
var G__14498 = seq__14415_14489;
var G__14499 = chunk__14417_14490;
var G__14500 = count__14418_14491;
var G__14501 = (i__14419_14492 + (1));
seq__14415_14489 = G__14498;
chunk__14417_14490 = G__14499;
count__14418_14491 = G__14500;
i__14419_14492 = G__14501;
continue;
}
} else
{var temp__4126__auto___14502__$1 = cljs.core.seq.call(null,seq__14415_14489);if(temp__4126__auto___14502__$1)
{var seq__14415_14503__$1 = temp__4126__auto___14502__$1;if(cljs.core.chunked_seq_QMARK_.call(null,seq__14415_14503__$1))
{var c__4418__auto___14504 = cljs.core.chunk_first.call(null,seq__14415_14503__$1);{
var G__14505 = cljs.core.chunk_rest.call(null,seq__14415_14503__$1);
var G__14506 = c__4418__auto___14504;
var G__14507 = cljs.core.count.call(null,c__4418__auto___14504);
var G__14508 = (0);
seq__14415_14489 = G__14505;
chunk__14417_14490 = G__14506;
count__14418_14491 = G__14507;
i__14419_14492 = G__14508;
continue;
}
} else
{var vec__14435_14509 = cljs.core.first.call(null,seq__14415_14503__$1);var actual_type_14510 = cljs.core.nth.call(null,vec__14435_14509,(0),null);var __14511 = cljs.core.nth.call(null,vec__14435_14509,(1),null);var keys_14512 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_14438,actual_type_14510,f_14488], null);var canonical_f_14513 = cljs.core.get_in.call(null,dommy.core.event_listeners.call(null,elem_14437),keys_14512);dommy.core.update_event_listeners_BANG_.call(null,elem_14437,dommy.utils.dissoc_in,keys_14512);
if(cljs.core.truth_(elem_14437.removeEventListener))
{elem_14437.removeEventListener(cljs.core.name.call(null,actual_type_14510),canonical_f_14513);
} else
{elem_14437.detachEvent(cljs.core.name.call(null,actual_type_14510),canonical_f_14513);
}
{
var G__14514 = cljs.core.next.call(null,seq__14415_14503__$1);
var G__14515 = null;
var G__14516 = (0);
var G__14517 = (0);
seq__14415_14489 = G__14514;
chunk__14417_14490 = G__14515;
count__14418_14491 = G__14516;
i__14419_14492 = G__14517;
continue;
}
}
} else
{}
}
break;
}
{
var G__14518 = cljs.core.next.call(null,seq__14414_14480__$1);
var G__14519 = null;
var G__14520 = (0);
var G__14521 = (0);
seq__14414_14439 = G__14518;
chunk__14421_14440 = G__14519;
count__14422_14441 = G__14520;
i__14423_14442 = G__14521;
continue;
}
}
} else
{}
}
break;
}
return elem_sel;
};
var unlisten_BANG_ = function (elem_sel,var_args){
var type_fs = null;if (arguments.length > 1) {
  type_fs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return unlisten_BANG___delegate.call(this,elem_sel,type_fs);};
unlisten_BANG_.cljs$lang$maxFixedArity = 1;
unlisten_BANG_.cljs$lang$applyTo = (function (arglist__14522){
var elem_sel = cljs.core.first(arglist__14522);
var type_fs = cljs.core.rest(arglist__14522);
return unlisten_BANG___delegate(elem_sel,type_fs);
});
unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic = unlisten_BANG___delegate;
return unlisten_BANG_;
})()
;
/**
* Behaves like `listen!`, but removes the listener after the first event occurs.
* @param {...*} var_args
*/
dommy.core.listen_once_BANG_ = (function() { 
var listen_once_BANG___delegate = function (elem_sel,type_fs){if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,type_fs)))
{} else
{throw (new Error(("Assert failed: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"type-fs","type-fs",1567896074,null))))))));
}
var vec__14530_14537 = dommy.core.elem_and_selector.call(null,elem_sel);var elem_14538 = cljs.core.nth.call(null,vec__14530_14537,(0),null);var selector_14539 = cljs.core.nth.call(null,vec__14530_14537,(1),null);var seq__14531_14540 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),type_fs));var chunk__14532_14541 = null;var count__14533_14542 = (0);var i__14534_14543 = (0);while(true){
if((i__14534_14543 < count__14533_14542))
{var vec__14535_14544 = cljs.core._nth.call(null,chunk__14532_14541,i__14534_14543);var type_14545 = cljs.core.nth.call(null,vec__14535_14544,(0),null);var f_14546 = cljs.core.nth.call(null,vec__14535_14544,(1),null);dommy.core.listen_BANG_.call(null,elem_sel,type_14545,((function (seq__14531_14540,chunk__14532_14541,count__14533_14542,i__14534_14543,vec__14535_14544,type_14545,f_14546,vec__14530_14537,elem_14538,selector_14539){
return (function this_fn(e){dommy.core.unlisten_BANG_.call(null,elem_sel,type_14545,this_fn);
return f_14546.call(null,e);
});})(seq__14531_14540,chunk__14532_14541,count__14533_14542,i__14534_14543,vec__14535_14544,type_14545,f_14546,vec__14530_14537,elem_14538,selector_14539))
);
{
var G__14547 = seq__14531_14540;
var G__14548 = chunk__14532_14541;
var G__14549 = count__14533_14542;
var G__14550 = (i__14534_14543 + (1));
seq__14531_14540 = G__14547;
chunk__14532_14541 = G__14548;
count__14533_14542 = G__14549;
i__14534_14543 = G__14550;
continue;
}
} else
{var temp__4126__auto___14551 = cljs.core.seq.call(null,seq__14531_14540);if(temp__4126__auto___14551)
{var seq__14531_14552__$1 = temp__4126__auto___14551;if(cljs.core.chunked_seq_QMARK_.call(null,seq__14531_14552__$1))
{var c__4418__auto___14553 = cljs.core.chunk_first.call(null,seq__14531_14552__$1);{
var G__14554 = cljs.core.chunk_rest.call(null,seq__14531_14552__$1);
var G__14555 = c__4418__auto___14553;
var G__14556 = cljs.core.count.call(null,c__4418__auto___14553);
var G__14557 = (0);
seq__14531_14540 = G__14554;
chunk__14532_14541 = G__14555;
count__14533_14542 = G__14556;
i__14534_14543 = G__14557;
continue;
}
} else
{var vec__14536_14558 = cljs.core.first.call(null,seq__14531_14552__$1);var type_14559 = cljs.core.nth.call(null,vec__14536_14558,(0),null);var f_14560 = cljs.core.nth.call(null,vec__14536_14558,(1),null);dommy.core.listen_BANG_.call(null,elem_sel,type_14559,((function (seq__14531_14540,chunk__14532_14541,count__14533_14542,i__14534_14543,vec__14536_14558,type_14559,f_14560,seq__14531_14552__$1,temp__4126__auto___14551,vec__14530_14537,elem_14538,selector_14539){
return (function this_fn(e){dommy.core.unlisten_BANG_.call(null,elem_sel,type_14559,this_fn);
return f_14560.call(null,e);
});})(seq__14531_14540,chunk__14532_14541,count__14533_14542,i__14534_14543,vec__14536_14558,type_14559,f_14560,seq__14531_14552__$1,temp__4126__auto___14551,vec__14530_14537,elem_14538,selector_14539))
);
{
var G__14561 = cljs.core.next.call(null,seq__14531_14552__$1);
var G__14562 = null;
var G__14563 = (0);
var G__14564 = (0);
seq__14531_14540 = G__14561;
chunk__14532_14541 = G__14562;
count__14533_14542 = G__14563;
i__14534_14543 = G__14564;
continue;
}
}
} else
{}
}
break;
}
return elem_sel;
};
var listen_once_BANG_ = function (elem_sel,var_args){
var type_fs = null;if (arguments.length > 1) {
  type_fs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return listen_once_BANG___delegate.call(this,elem_sel,type_fs);};
listen_once_BANG_.cljs$lang$maxFixedArity = 1;
listen_once_BANG_.cljs$lang$applyTo = (function (arglist__14565){
var elem_sel = cljs.core.first(arglist__14565);
var type_fs = cljs.core.rest(arglist__14565);
return listen_once_BANG___delegate(elem_sel,type_fs);
});
listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic = listen_once_BANG___delegate;
return listen_once_BANG_;
})()
;
