// Compiled by ClojureScript 0.0-2371
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function fn_handler(f){if(typeof cljs.core.async.t10719 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t10719 = (function (f,fn_handler,meta10720){
this.f = f;
this.fn_handler = fn_handler;
this.meta10720 = meta10720;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t10719.cljs$lang$type = true;
cljs.core.async.t10719.cljs$lang$ctorStr = "cljs.core.async/t10719";
cljs.core.async.t10719.cljs$lang$ctorPrWriter = (function (this__4225__auto__,writer__4226__auto__,opt__4227__auto__){return cljs.core._write.call(null,writer__4226__auto__,"cljs.core.async/t10719");
});
cljs.core.async.t10719.prototype.cljs$core$async$impl$protocols$Handler$ = true;
cljs.core.async.t10719.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return true;
});
cljs.core.async.t10719.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return self__.f;
});
cljs.core.async.t10719.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_10721){var self__ = this;
var _10721__$1 = this;return self__.meta10720;
});
cljs.core.async.t10719.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_10721,meta10720__$1){var self__ = this;
var _10721__$1 = this;return (new cljs.core.async.t10719(self__.f,self__.fn_handler,meta10720__$1));
});
cljs.core.async.__GT_t10719 = (function __GT_t10719(f__$1,fn_handler__$1,meta10720){return (new cljs.core.async.t10719(f__$1,fn_handler__$1,meta10720));
});
}
return (new cljs.core.async.t10719(f,fn_handler,null));
});
/**
* Returns a fixed buffer of size n. When full, puts will block/park.
*/
cljs.core.async.buffer = (function buffer(n){return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
* Returns a buffer of size n. When full, puts will complete but
* val will be dropped (no transfer).
*/
cljs.core.async.dropping_buffer = (function dropping_buffer(n){return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
* Returns a buffer of size n. When full, puts will complete, and be
* buffered, but oldest elements in buffer will be dropped (not
* transferred).
*/
cljs.core.async.sliding_buffer = (function sliding_buffer(n){return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
* Returns true if a channel created with buff will never block. That is to say,
* puts into this buffer will never cause the buffer to be full.
*/
cljs.core.async.unblocking_buffer_QMARK_ = (function unblocking_buffer_QMARK_(buff){var G__10723 = buff;if(G__10723)
{var bit__4312__auto__ = null;if(cljs.core.truth_((function (){var or__3648__auto__ = bit__4312__auto__;if(cljs.core.truth_(or__3648__auto__))
{return or__3648__auto__;
} else
{return G__10723.cljs$core$async$impl$protocols$UnblockingBuffer$;
}
})()))
{return true;
} else
{if((!G__10723.cljs$lang$protocol_mask$partition$))
{return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,G__10723);
} else
{return false;
}
}
} else
{return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,G__10723);
}
});
/**
* Creates a channel with an optional buffer, an optional transducer (like (map f),
* (filter p) etc or a composition thereof), and an optional exception handler.
* If buf-or-n is a number, will create and use a fixed buffer of that size. If a
* transducer is supplied a buffer must be specified. ex-handler must be a
* fn of one argument - if an exception occurs during transformation it will be called
* with the thrown value as an argument, and any non-nil return value will be placed
* in the channel.
*/
cljs.core.async.chan = (function() {
var chan = null;
var chan__0 = (function (){return chan.call(null,null);
});
var chan__1 = (function (buf_or_n){return chan.call(null,buf_or_n,null,null);
});
var chan__2 = (function (buf_or_n,xform){return chan.call(null,buf_or_n,xform,null);
});
var chan__3 = (function (buf_or_n,xform,ex_handler){var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);if(cljs.core.truth_(xform))
{if(cljs.core.truth_(buf_or_n__$1))
{} else
{throw (new Error(("Assert failed: buffer must be supplied when transducer is\n"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null))))));
}
} else
{}
return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});
chan = function(buf_or_n,xform,ex_handler){
switch(arguments.length){
case 0:
return chan__0.call(this);
case 1:
return chan__1.call(this,buf_or_n);
case 2:
return chan__2.call(this,buf_or_n,xform);
case 3:
return chan__3.call(this,buf_or_n,xform,ex_handler);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
chan.cljs$core$IFn$_invoke$arity$0 = chan__0;
chan.cljs$core$IFn$_invoke$arity$1 = chan__1;
chan.cljs$core$IFn$_invoke$arity$2 = chan__2;
chan.cljs$core$IFn$_invoke$arity$3 = chan__3;
return chan;
})()
;
/**
* Returns a channel that will close after msecs
*/
cljs.core.async.timeout = (function timeout(msecs){return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
* takes a val from port. Must be called inside a (go ...) block. Will
* return nil if closed. Will park if nothing is available.
* Returns true unless port is already closed
*/
cljs.core.async._LT__BANG_ = (function _LT__BANG_(port){throw (new Error("<! used not in (go ...) block"));
});
/**
* Asynchronously takes a val from port, passing to fn1. Will pass nil
* if closed. If on-caller? (default true) is true, and value is
* immediately available, will call fn1 on calling thread.
* Returns nil.
*/
cljs.core.async.take_BANG_ = (function() {
var take_BANG_ = null;
var take_BANG___2 = (function (port,fn1){return take_BANG_.call(null,port,fn1,true);
});
var take_BANG___3 = (function (port,fn1,on_caller_QMARK_){var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));if(cljs.core.truth_(ret))
{var val_10724 = cljs.core.deref.call(null,ret);if(cljs.core.truth_(on_caller_QMARK_))
{fn1.call(null,val_10724);
} else
{cljs.core.async.impl.dispatch.run.call(null,((function (val_10724,ret){
return (function (){return fn1.call(null,val_10724);
});})(val_10724,ret))
);
}
} else
{}
return null;
});
take_BANG_ = function(port,fn1,on_caller_QMARK_){
switch(arguments.length){
case 2:
return take_BANG___2.call(this,port,fn1);
case 3:
return take_BANG___3.call(this,port,fn1,on_caller_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
take_BANG_.cljs$core$IFn$_invoke$arity$2 = take_BANG___2;
take_BANG_.cljs$core$IFn$_invoke$arity$3 = take_BANG___3;
return take_BANG_;
})()
;
cljs.core.async.nop = (function nop(_){return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
* puts a val into port. nil values are not allowed. Must be called
* inside a (go ...) block. Will park if no buffer space is available.
* Returns true unless port is already closed.
*/
cljs.core.async._GT__BANG_ = (function _GT__BANG_(port,val){throw (new Error(">! used not in (go ...) block"));
});
/**
* Asynchronously puts a val into port, calling fn0 (if supplied) when
* complete. nil values are not allowed. Will throw if closed. If
* on-caller? (default true) is true, and the put is immediately
* accepted, will call fn0 on calling thread.  Returns nil.
*/
cljs.core.async.put_BANG_ = (function() {
var put_BANG_ = null;
var put_BANG___2 = (function (port,val){var temp__4124__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);if(cljs.core.truth_(temp__4124__auto__))
{var ret = temp__4124__auto__;return cljs.core.deref.call(null,ret);
} else
{return true;
}
});
var put_BANG___3 = (function (port,val,fn1){return put_BANG_.call(null,port,val,fn1,true);
});
var put_BANG___4 = (function (port,val,fn1,on_caller_QMARK_){var temp__4124__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));if(cljs.core.truth_(temp__4124__auto__))
{var retb = temp__4124__auto__;var ret = cljs.core.deref.call(null,retb);if(cljs.core.truth_(on_caller_QMARK_))
{fn1.call(null,ret);
} else
{cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4124__auto__){
return (function (){return fn1.call(null,ret);
});})(ret,retb,temp__4124__auto__))
);
}
return ret;
} else
{return true;
}
});
put_BANG_ = function(port,val,fn1,on_caller_QMARK_){
switch(arguments.length){
case 2:
return put_BANG___2.call(this,port,val);
case 3:
return put_BANG___3.call(this,port,val,fn1);
case 4:
return put_BANG___4.call(this,port,val,fn1,on_caller_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
put_BANG_.cljs$core$IFn$_invoke$arity$2 = put_BANG___2;
put_BANG_.cljs$core$IFn$_invoke$arity$3 = put_BANG___3;
put_BANG_.cljs$core$IFn$_invoke$arity$4 = put_BANG___4;
return put_BANG_;
})()
;
cljs.core.async.close_BANG_ = (function close_BANG_(port){return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function random_array(n){var a = (new Array(n));var n__4518__auto___10725 = n;var x_10726 = (0);while(true){
if((x_10726 < n__4518__auto___10725))
{(a[x_10726] = (0));
{
var G__10727 = (x_10726 + (1));
x_10726 = G__10727;
continue;
}
} else
{}
break;
}
var i = (1);while(true){
if(cljs.core._EQ_.call(null,i,n))
{return a;
} else
{var j = cljs.core.rand_int.call(null,i);(a[i] = (a[j]));
(a[j] = i);
{
var G__10728 = (i + (1));
i = G__10728;
continue;
}
}
break;
}
});
cljs.core.async.alt_flag = (function alt_flag(){var flag = cljs.core.atom.call(null,true);if(typeof cljs.core.async.t10732 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t10732 = (function (flag,alt_flag,meta10733){
this.flag = flag;
this.alt_flag = alt_flag;
this.meta10733 = meta10733;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t10732.cljs$lang$type = true;
cljs.core.async.t10732.cljs$lang$ctorStr = "cljs.core.async/t10732";
cljs.core.async.t10732.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__4225__auto__,writer__4226__auto__,opt__4227__auto__){return cljs.core._write.call(null,writer__4226__auto__,"cljs.core.async/t10732");
});})(flag))
;
cljs.core.async.t10732.prototype.cljs$core$async$impl$protocols$Handler$ = true;
cljs.core.async.t10732.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){var self__ = this;
var ___$1 = this;return cljs.core.deref.call(null,self__.flag);
});})(flag))
;
cljs.core.async.t10732.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){var self__ = this;
var ___$1 = this;cljs.core.reset_BANG_.call(null,self__.flag,null);
return true;
});})(flag))
;
cljs.core.async.t10732.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_10734){var self__ = this;
var _10734__$1 = this;return self__.meta10733;
});})(flag))
;
cljs.core.async.t10732.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_10734,meta10733__$1){var self__ = this;
var _10734__$1 = this;return (new cljs.core.async.t10732(self__.flag,self__.alt_flag,meta10733__$1));
});})(flag))
;
cljs.core.async.__GT_t10732 = ((function (flag){
return (function __GT_t10732(flag__$1,alt_flag__$1,meta10733){return (new cljs.core.async.t10732(flag__$1,alt_flag__$1,meta10733));
});})(flag))
;
}
return (new cljs.core.async.t10732(flag,alt_flag,null));
});
cljs.core.async.alt_handler = (function alt_handler(flag,cb){if(typeof cljs.core.async.t10738 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t10738 = (function (cb,flag,alt_handler,meta10739){
this.cb = cb;
this.flag = flag;
this.alt_handler = alt_handler;
this.meta10739 = meta10739;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t10738.cljs$lang$type = true;
cljs.core.async.t10738.cljs$lang$ctorStr = "cljs.core.async/t10738";
cljs.core.async.t10738.cljs$lang$ctorPrWriter = (function (this__4225__auto__,writer__4226__auto__,opt__4227__auto__){return cljs.core._write.call(null,writer__4226__auto__,"cljs.core.async/t10738");
});
cljs.core.async.t10738.prototype.cljs$core$async$impl$protocols$Handler$ = true;
cljs.core.async.t10738.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});
cljs.core.async.t10738.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){var self__ = this;
var ___$1 = this;cljs.core.async.impl.protocols.commit.call(null,self__.flag);
return self__.cb;
});
cljs.core.async.t10738.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_10740){var self__ = this;
var _10740__$1 = this;return self__.meta10739;
});
cljs.core.async.t10738.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_10740,meta10739__$1){var self__ = this;
var _10740__$1 = this;return (new cljs.core.async.t10738(self__.cb,self__.flag,self__.alt_handler,meta10739__$1));
});
cljs.core.async.__GT_t10738 = (function __GT_t10738(cb__$1,flag__$1,alt_handler__$1,meta10739){return (new cljs.core.async.t10738(cb__$1,flag__$1,alt_handler__$1,meta10739));
});
}
return (new cljs.core.async.t10738(cb,flag,alt_handler,null));
});
/**
* returns derefable [val port] if immediate, nil if enqueued
*/
cljs.core.async.do_alts = (function do_alts(fret,ports,opts){var flag = cljs.core.async.alt_flag.call(null);var n = cljs.core.count.call(null,ports);var idxs = cljs.core.async.random_array.call(null,n);var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);var ret = (function (){var i = (0);while(true){
if((i < n))
{var idx = (cljs.core.truth_(priority)?i:(idxs[i]));var port = cljs.core.nth.call(null,ports,idx);var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__10741_SHARP_){return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__10741_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__10742_SHARP_){return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__10742_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));if(cljs.core.truth_(vbox))
{return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__3648__auto__ = wport;if(cljs.core.truth_(or__3648__auto__))
{return or__3648__auto__;
} else
{return port;
}
})()], null));
} else
{{
var G__10743 = (i + (1));
i = G__10743;
continue;
}
}
} else
{return null;
}
break;
}
})();var or__3648__auto__ = ret;if(cljs.core.truth_(or__3648__auto__))
{return or__3648__auto__;
} else
{if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328)))
{var temp__4126__auto__ = (function (){var and__3636__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);if(cljs.core.truth_(and__3636__auto__))
{return cljs.core.async.impl.protocols.commit.call(null,flag);
} else
{return and__3636__auto__;
}
})();if(cljs.core.truth_(temp__4126__auto__))
{var got = temp__4126__auto__;return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else
{return null;
}
} else
{return null;
}
}
});
/**
* Completes at most one of several channel operations. Must be called
* inside a (go ...) block. ports is a vector of channel endpoints,
* which can be either a channel to take from or a vector of
* [channel-to-put-to val-to-put], in any combination. Takes will be
* made as if by <!, and puts will be made as if by >!. Unless
* the :priority option is true, if more than one port operation is
* ready a non-deterministic choice will be made. If no operation is
* ready and a :default value is supplied, [default-val :default] will
* be returned, otherwise alts! will park until the first operation to
* become ready completes. Returns [val port] of the completed
* operation, where val is the value taken for takes, and a
* boolean (true unless already closed, as per put!) for puts.
* 
* opts are passed as :key val ... Supported options:
* 
* :default val - the value to use if none of the operations are immediately ready
* :priority true - (default nil) when true, the operations will be tried in order.
* 
* Note: there is no guarantee that the port exps or val exprs will be
* used, nor in what order should they be, so they should not be
* depended upon for side effects.
* @param {...*} var_args
*/
cljs.core.async.alts_BANG_ = (function() { 
var alts_BANG___delegate = function (ports,p__10744){var map__10746 = p__10744;var map__10746__$1 = ((cljs.core.seq_QMARK_.call(null,map__10746))?cljs.core.apply.call(null,cljs.core.hash_map,map__10746):map__10746);var opts = map__10746__$1;throw (new Error("alts! used not in (go ...) block"));
};
var alts_BANG_ = function (ports,var_args){
var p__10744 = null;if (arguments.length > 1) {
  p__10744 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return alts_BANG___delegate.call(this,ports,p__10744);};
alts_BANG_.cljs$lang$maxFixedArity = 1;
alts_BANG_.cljs$lang$applyTo = (function (arglist__10747){
var ports = cljs.core.first(arglist__10747);
var p__10744 = cljs.core.rest(arglist__10747);
return alts_BANG___delegate(ports,p__10744);
});
alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = alts_BANG___delegate;
return alts_BANG_;
})()
;
/**
* Takes elements from the from channel and supplies them to the to
* channel. By default, the to channel will be closed when the from
* channel closes, but can be determined by the close?  parameter. Will
* stop consuming the from channel if the to channel closes
*/
cljs.core.async.pipe = (function() {
var pipe = null;
var pipe__2 = (function (from,to){return pipe.call(null,from,to,true);
});
var pipe__3 = (function (from,to,close_QMARK_){var c__5915__auto___10842 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto___10842){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto___10842){
return (function (state_10818){var state_val_10819 = (state_10818[(1)]);if((state_val_10819 === (7)))
{var inst_10814 = (state_10818[(2)]);var state_10818__$1 = state_10818;var statearr_10820_10843 = state_10818__$1;(statearr_10820_10843[(2)] = inst_10814);
(statearr_10820_10843[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_10819 === (1)))
{var state_10818__$1 = state_10818;var statearr_10821_10844 = state_10818__$1;(statearr_10821_10844[(2)] = null);
(statearr_10821_10844[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_10819 === (4)))
{var inst_10797 = (state_10818[(7)]);var inst_10797__$1 = (state_10818[(2)]);var inst_10798 = (inst_10797__$1 == null);var state_10818__$1 = (function (){var statearr_10822 = state_10818;(statearr_10822[(7)] = inst_10797__$1);
return statearr_10822;
})();if(cljs.core.truth_(inst_10798))
{var statearr_10823_10845 = state_10818__$1;(statearr_10823_10845[(1)] = (5));
} else
{var statearr_10824_10846 = state_10818__$1;(statearr_10824_10846[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_10819 === (13)))
{var state_10818__$1 = state_10818;var statearr_10825_10847 = state_10818__$1;(statearr_10825_10847[(2)] = null);
(statearr_10825_10847[(1)] = (14));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_10819 === (6)))
{var inst_10797 = (state_10818[(7)]);var state_10818__$1 = state_10818;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10818__$1,(11),to,inst_10797);
} else
{if((state_val_10819 === (3)))
{var inst_10816 = (state_10818[(2)]);var state_10818__$1 = state_10818;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10818__$1,inst_10816);
} else
{if((state_val_10819 === (12)))
{var state_10818__$1 = state_10818;var statearr_10826_10848 = state_10818__$1;(statearr_10826_10848[(2)] = null);
(statearr_10826_10848[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_10819 === (2)))
{var state_10818__$1 = state_10818;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_10818__$1,(4),from);
} else
{if((state_val_10819 === (11)))
{var inst_10807 = (state_10818[(2)]);var state_10818__$1 = state_10818;if(cljs.core.truth_(inst_10807))
{var statearr_10827_10849 = state_10818__$1;(statearr_10827_10849[(1)] = (12));
} else
{var statearr_10828_10850 = state_10818__$1;(statearr_10828_10850[(1)] = (13));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_10819 === (9)))
{var state_10818__$1 = state_10818;var statearr_10829_10851 = state_10818__$1;(statearr_10829_10851[(2)] = null);
(statearr_10829_10851[(1)] = (10));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_10819 === (5)))
{var state_10818__$1 = state_10818;if(cljs.core.truth_(close_QMARK_))
{var statearr_10830_10852 = state_10818__$1;(statearr_10830_10852[(1)] = (8));
} else
{var statearr_10831_10853 = state_10818__$1;(statearr_10831_10853[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_10819 === (14)))
{var inst_10812 = (state_10818[(2)]);var state_10818__$1 = state_10818;var statearr_10832_10854 = state_10818__$1;(statearr_10832_10854[(2)] = inst_10812);
(statearr_10832_10854[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_10819 === (10)))
{var inst_10804 = (state_10818[(2)]);var state_10818__$1 = state_10818;var statearr_10833_10855 = state_10818__$1;(statearr_10833_10855[(2)] = inst_10804);
(statearr_10833_10855[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_10819 === (8)))
{var inst_10801 = cljs.core.async.close_BANG_.call(null,to);var state_10818__$1 = state_10818;var statearr_10834_10856 = state_10818__$1;(statearr_10834_10856[(2)] = inst_10801);
(statearr_10834_10856[(1)] = (10));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__5915__auto___10842))
;return ((function (switch__5900__auto__,c__5915__auto___10842){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_10838 = [null,null,null,null,null,null,null,null];(statearr_10838[(0)] = state_machine__5901__auto__);
(statearr_10838[(1)] = (1));
return statearr_10838;
});
var state_machine__5901__auto____1 = (function (state_10818){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_10818);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e10839){if((e10839 instanceof Object))
{var ex__5904__auto__ = e10839;var statearr_10840_10857 = state_10818;(statearr_10840_10857[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10818);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e10839;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__10858 = state_10818;
state_10818 = G__10858;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_10818){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_10818);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto___10842))
})();var state__5917__auto__ = (function (){var statearr_10841 = f__5916__auto__.call(null);(statearr_10841[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto___10842);
return statearr_10841;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto___10842))
);
return to;
});
pipe = function(from,to,close_QMARK_){
switch(arguments.length){
case 2:
return pipe__2.call(this,from,to);
case 3:
return pipe__3.call(this,from,to,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pipe.cljs$core$IFn$_invoke$arity$2 = pipe__2;
pipe.cljs$core$IFn$_invoke$arity$3 = pipe__3;
return pipe;
})()
;
cljs.core.async.pipeline_STAR_ = (function pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){if((n > (0)))
{} else
{throw (new Error(("Assert failed: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)))))));
}
var jobs = cljs.core.async.chan.call(null,n);var results = cljs.core.async.chan.call(null,n);var process = ((function (jobs,results){
return (function (p__11042){var vec__11043 = p__11042;var v = cljs.core.nth.call(null,vec__11043,(0),null);var p = cljs.core.nth.call(null,vec__11043,(1),null);var job = vec__11043;if((job == null))
{cljs.core.async.close_BANG_.call(null,results);
return null;
} else
{var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);var c__5915__auto___11225 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto___11225,res,vec__11043,v,p,job,jobs,results){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto___11225,res,vec__11043,v,p,job,jobs,results){
return (function (state_11048){var state_val_11049 = (state_11048[(1)]);if((state_val_11049 === (2)))
{var inst_11045 = (state_11048[(2)]);var inst_11046 = cljs.core.async.close_BANG_.call(null,res);var state_11048__$1 = (function (){var statearr_11050 = state_11048;(statearr_11050[(7)] = inst_11045);
return statearr_11050;
})();return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11048__$1,inst_11046);
} else
{if((state_val_11049 === (1)))
{var state_11048__$1 = state_11048;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11048__$1,(2),res,v);
} else
{return null;
}
}
});})(c__5915__auto___11225,res,vec__11043,v,p,job,jobs,results))
;return ((function (switch__5900__auto__,c__5915__auto___11225,res,vec__11043,v,p,job,jobs,results){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_11054 = [null,null,null,null,null,null,null,null];(statearr_11054[(0)] = state_machine__5901__auto__);
(statearr_11054[(1)] = (1));
return statearr_11054;
});
var state_machine__5901__auto____1 = (function (state_11048){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_11048);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e11055){if((e11055 instanceof Object))
{var ex__5904__auto__ = e11055;var statearr_11056_11226 = state_11048;(statearr_11056_11226[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11048);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e11055;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__11227 = state_11048;
state_11048 = G__11227;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_11048){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_11048);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto___11225,res,vec__11043,v,p,job,jobs,results))
})();var state__5917__auto__ = (function (){var statearr_11057 = f__5916__auto__.call(null);(statearr_11057[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto___11225);
return statearr_11057;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto___11225,res,vec__11043,v,p,job,jobs,results))
);
cljs.core.async.put_BANG_.call(null,p,res);
return true;
}
});})(jobs,results))
;var async = ((function (jobs,results,process){
return (function (p__11058){var vec__11059 = p__11058;var v = cljs.core.nth.call(null,vec__11059,(0),null);var p = cljs.core.nth.call(null,vec__11059,(1),null);var job = vec__11059;if((job == null))
{cljs.core.async.close_BANG_.call(null,results);
return null;
} else
{var res = cljs.core.async.chan.call(null,(1));xf.call(null,v,res);
cljs.core.async.put_BANG_.call(null,p,res);
return true;
}
});})(jobs,results,process))
;var n__4518__auto___11228 = n;var __11229 = (0);while(true){
if((__11229 < n__4518__auto___11228))
{var G__11060_11230 = (((type instanceof cljs.core.Keyword))?type.fqn:null);switch (G__11060_11230) {
case "async":
var c__5915__auto___11232 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (__11229,c__5915__auto___11232,G__11060_11230,n__4518__auto___11228,jobs,results,process,async){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (__11229,c__5915__auto___11232,G__11060_11230,n__4518__auto___11228,jobs,results,process,async){
return (function (state_11073){var state_val_11074 = (state_11073[(1)]);if((state_val_11074 === (7)))
{var inst_11069 = (state_11073[(2)]);var state_11073__$1 = state_11073;var statearr_11075_11233 = state_11073__$1;(statearr_11075_11233[(2)] = inst_11069);
(statearr_11075_11233[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11074 === (6)))
{var state_11073__$1 = state_11073;var statearr_11076_11234 = state_11073__$1;(statearr_11076_11234[(2)] = null);
(statearr_11076_11234[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11074 === (5)))
{var state_11073__$1 = state_11073;var statearr_11077_11235 = state_11073__$1;(statearr_11077_11235[(2)] = null);
(statearr_11077_11235[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11074 === (4)))
{var inst_11063 = (state_11073[(2)]);var inst_11064 = async.call(null,inst_11063);var state_11073__$1 = state_11073;if(cljs.core.truth_(inst_11064))
{var statearr_11078_11236 = state_11073__$1;(statearr_11078_11236[(1)] = (5));
} else
{var statearr_11079_11237 = state_11073__$1;(statearr_11079_11237[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11074 === (3)))
{var inst_11071 = (state_11073[(2)]);var state_11073__$1 = state_11073;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11073__$1,inst_11071);
} else
{if((state_val_11074 === (2)))
{var state_11073__$1 = state_11073;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11073__$1,(4),jobs);
} else
{if((state_val_11074 === (1)))
{var state_11073__$1 = state_11073;var statearr_11080_11238 = state_11073__$1;(statearr_11080_11238[(2)] = null);
(statearr_11080_11238[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
});})(__11229,c__5915__auto___11232,G__11060_11230,n__4518__auto___11228,jobs,results,process,async))
;return ((function (__11229,switch__5900__auto__,c__5915__auto___11232,G__11060_11230,n__4518__auto___11228,jobs,results,process,async){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_11084 = [null,null,null,null,null,null,null];(statearr_11084[(0)] = state_machine__5901__auto__);
(statearr_11084[(1)] = (1));
return statearr_11084;
});
var state_machine__5901__auto____1 = (function (state_11073){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_11073);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e11085){if((e11085 instanceof Object))
{var ex__5904__auto__ = e11085;var statearr_11086_11239 = state_11073;(statearr_11086_11239[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11073);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e11085;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__11240 = state_11073;
state_11073 = G__11240;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_11073){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_11073);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(__11229,switch__5900__auto__,c__5915__auto___11232,G__11060_11230,n__4518__auto___11228,jobs,results,process,async))
})();var state__5917__auto__ = (function (){var statearr_11087 = f__5916__auto__.call(null);(statearr_11087[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto___11232);
return statearr_11087;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(__11229,c__5915__auto___11232,G__11060_11230,n__4518__auto___11228,jobs,results,process,async))
);

break;
case "compute":
var c__5915__auto___11241 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (__11229,c__5915__auto___11241,G__11060_11230,n__4518__auto___11228,jobs,results,process,async){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (__11229,c__5915__auto___11241,G__11060_11230,n__4518__auto___11228,jobs,results,process,async){
return (function (state_11100){var state_val_11101 = (state_11100[(1)]);if((state_val_11101 === (7)))
{var inst_11096 = (state_11100[(2)]);var state_11100__$1 = state_11100;var statearr_11102_11242 = state_11100__$1;(statearr_11102_11242[(2)] = inst_11096);
(statearr_11102_11242[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11101 === (6)))
{var state_11100__$1 = state_11100;var statearr_11103_11243 = state_11100__$1;(statearr_11103_11243[(2)] = null);
(statearr_11103_11243[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11101 === (5)))
{var state_11100__$1 = state_11100;var statearr_11104_11244 = state_11100__$1;(statearr_11104_11244[(2)] = null);
(statearr_11104_11244[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11101 === (4)))
{var inst_11090 = (state_11100[(2)]);var inst_11091 = process.call(null,inst_11090);var state_11100__$1 = state_11100;if(cljs.core.truth_(inst_11091))
{var statearr_11105_11245 = state_11100__$1;(statearr_11105_11245[(1)] = (5));
} else
{var statearr_11106_11246 = state_11100__$1;(statearr_11106_11246[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11101 === (3)))
{var inst_11098 = (state_11100[(2)]);var state_11100__$1 = state_11100;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11100__$1,inst_11098);
} else
{if((state_val_11101 === (2)))
{var state_11100__$1 = state_11100;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11100__$1,(4),jobs);
} else
{if((state_val_11101 === (1)))
{var state_11100__$1 = state_11100;var statearr_11107_11247 = state_11100__$1;(statearr_11107_11247[(2)] = null);
(statearr_11107_11247[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
});})(__11229,c__5915__auto___11241,G__11060_11230,n__4518__auto___11228,jobs,results,process,async))
;return ((function (__11229,switch__5900__auto__,c__5915__auto___11241,G__11060_11230,n__4518__auto___11228,jobs,results,process,async){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_11111 = [null,null,null,null,null,null,null];(statearr_11111[(0)] = state_machine__5901__auto__);
(statearr_11111[(1)] = (1));
return statearr_11111;
});
var state_machine__5901__auto____1 = (function (state_11100){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_11100);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e11112){if((e11112 instanceof Object))
{var ex__5904__auto__ = e11112;var statearr_11113_11248 = state_11100;(statearr_11113_11248[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11100);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e11112;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__11249 = state_11100;
state_11100 = G__11249;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_11100){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_11100);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(__11229,switch__5900__auto__,c__5915__auto___11241,G__11060_11230,n__4518__auto___11228,jobs,results,process,async))
})();var state__5917__auto__ = (function (){var statearr_11114 = f__5916__auto__.call(null);(statearr_11114[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto___11241);
return statearr_11114;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(__11229,c__5915__auto___11241,G__11060_11230,n__4518__auto___11228,jobs,results,process,async))
);

break;
default:
throw (new Error(("No matching clause: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(type))));

}
{
var G__11250 = (__11229 + (1));
__11229 = G__11250;
continue;
}
} else
{}
break;
}
var c__5915__auto___11251 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto___11251,jobs,results,process,async){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto___11251,jobs,results,process,async){
return (function (state_11136){var state_val_11137 = (state_11136[(1)]);if((state_val_11137 === (9)))
{var inst_11129 = (state_11136[(2)]);var state_11136__$1 = (function (){var statearr_11138 = state_11136;(statearr_11138[(7)] = inst_11129);
return statearr_11138;
})();var statearr_11139_11252 = state_11136__$1;(statearr_11139_11252[(2)] = null);
(statearr_11139_11252[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11137 === (8)))
{var inst_11122 = (state_11136[(8)]);var inst_11127 = (state_11136[(2)]);var state_11136__$1 = (function (){var statearr_11140 = state_11136;(statearr_11140[(9)] = inst_11127);
return statearr_11140;
})();return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11136__$1,(9),results,inst_11122);
} else
{if((state_val_11137 === (7)))
{var inst_11132 = (state_11136[(2)]);var state_11136__$1 = state_11136;var statearr_11141_11253 = state_11136__$1;(statearr_11141_11253[(2)] = inst_11132);
(statearr_11141_11253[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11137 === (6)))
{var inst_11122 = (state_11136[(8)]);var inst_11117 = (state_11136[(10)]);var inst_11122__$1 = cljs.core.async.chan.call(null,(1));var inst_11123 = cljs.core.PersistentVector.EMPTY_NODE;var inst_11124 = [inst_11117,inst_11122__$1];var inst_11125 = (new cljs.core.PersistentVector(null,2,(5),inst_11123,inst_11124,null));var state_11136__$1 = (function (){var statearr_11142 = state_11136;(statearr_11142[(8)] = inst_11122__$1);
return statearr_11142;
})();return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11136__$1,(8),jobs,inst_11125);
} else
{if((state_val_11137 === (5)))
{var inst_11120 = cljs.core.async.close_BANG_.call(null,jobs);var state_11136__$1 = state_11136;var statearr_11143_11254 = state_11136__$1;(statearr_11143_11254[(2)] = inst_11120);
(statearr_11143_11254[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11137 === (4)))
{var inst_11117 = (state_11136[(10)]);var inst_11117__$1 = (state_11136[(2)]);var inst_11118 = (inst_11117__$1 == null);var state_11136__$1 = (function (){var statearr_11144 = state_11136;(statearr_11144[(10)] = inst_11117__$1);
return statearr_11144;
})();if(cljs.core.truth_(inst_11118))
{var statearr_11145_11255 = state_11136__$1;(statearr_11145_11255[(1)] = (5));
} else
{var statearr_11146_11256 = state_11136__$1;(statearr_11146_11256[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11137 === (3)))
{var inst_11134 = (state_11136[(2)]);var state_11136__$1 = state_11136;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11136__$1,inst_11134);
} else
{if((state_val_11137 === (2)))
{var state_11136__$1 = state_11136;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11136__$1,(4),from);
} else
{if((state_val_11137 === (1)))
{var state_11136__$1 = state_11136;var statearr_11147_11257 = state_11136__$1;(statearr_11147_11257[(2)] = null);
(statearr_11147_11257[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
});})(c__5915__auto___11251,jobs,results,process,async))
;return ((function (switch__5900__auto__,c__5915__auto___11251,jobs,results,process,async){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_11151 = [null,null,null,null,null,null,null,null,null,null,null];(statearr_11151[(0)] = state_machine__5901__auto__);
(statearr_11151[(1)] = (1));
return statearr_11151;
});
var state_machine__5901__auto____1 = (function (state_11136){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_11136);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e11152){if((e11152 instanceof Object))
{var ex__5904__auto__ = e11152;var statearr_11153_11258 = state_11136;(statearr_11153_11258[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11136);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e11152;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__11259 = state_11136;
state_11136 = G__11259;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_11136){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_11136);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto___11251,jobs,results,process,async))
})();var state__5917__auto__ = (function (){var statearr_11154 = f__5916__auto__.call(null);(statearr_11154[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto___11251);
return statearr_11154;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto___11251,jobs,results,process,async))
);
var c__5915__auto__ = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto__,jobs,results,process,async){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto__,jobs,results,process,async){
return (function (state_11192){var state_val_11193 = (state_11192[(1)]);if((state_val_11193 === (7)))
{var inst_11188 = (state_11192[(2)]);var state_11192__$1 = state_11192;var statearr_11194_11260 = state_11192__$1;(statearr_11194_11260[(2)] = inst_11188);
(statearr_11194_11260[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11193 === (20)))
{var state_11192__$1 = state_11192;var statearr_11195_11261 = state_11192__$1;(statearr_11195_11261[(2)] = null);
(statearr_11195_11261[(1)] = (21));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11193 === (1)))
{var state_11192__$1 = state_11192;var statearr_11196_11262 = state_11192__$1;(statearr_11196_11262[(2)] = null);
(statearr_11196_11262[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11193 === (4)))
{var inst_11157 = (state_11192[(7)]);var inst_11157__$1 = (state_11192[(2)]);var inst_11158 = (inst_11157__$1 == null);var state_11192__$1 = (function (){var statearr_11197 = state_11192;(statearr_11197[(7)] = inst_11157__$1);
return statearr_11197;
})();if(cljs.core.truth_(inst_11158))
{var statearr_11198_11263 = state_11192__$1;(statearr_11198_11263[(1)] = (5));
} else
{var statearr_11199_11264 = state_11192__$1;(statearr_11199_11264[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11193 === (15)))
{var inst_11170 = (state_11192[(8)]);var state_11192__$1 = state_11192;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11192__$1,(18),to,inst_11170);
} else
{if((state_val_11193 === (21)))
{var inst_11183 = (state_11192[(2)]);var state_11192__$1 = state_11192;var statearr_11200_11265 = state_11192__$1;(statearr_11200_11265[(2)] = inst_11183);
(statearr_11200_11265[(1)] = (13));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11193 === (13)))
{var inst_11185 = (state_11192[(2)]);var state_11192__$1 = (function (){var statearr_11201 = state_11192;(statearr_11201[(9)] = inst_11185);
return statearr_11201;
})();var statearr_11202_11266 = state_11192__$1;(statearr_11202_11266[(2)] = null);
(statearr_11202_11266[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11193 === (6)))
{var inst_11157 = (state_11192[(7)]);var state_11192__$1 = state_11192;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11192__$1,(11),inst_11157);
} else
{if((state_val_11193 === (17)))
{var inst_11178 = (state_11192[(2)]);var state_11192__$1 = state_11192;if(cljs.core.truth_(inst_11178))
{var statearr_11203_11267 = state_11192__$1;(statearr_11203_11267[(1)] = (19));
} else
{var statearr_11204_11268 = state_11192__$1;(statearr_11204_11268[(1)] = (20));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11193 === (3)))
{var inst_11190 = (state_11192[(2)]);var state_11192__$1 = state_11192;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11192__$1,inst_11190);
} else
{if((state_val_11193 === (12)))
{var inst_11167 = (state_11192[(10)]);var state_11192__$1 = state_11192;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11192__$1,(14),inst_11167);
} else
{if((state_val_11193 === (2)))
{var state_11192__$1 = state_11192;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11192__$1,(4),results);
} else
{if((state_val_11193 === (19)))
{var state_11192__$1 = state_11192;var statearr_11205_11269 = state_11192__$1;(statearr_11205_11269[(2)] = null);
(statearr_11205_11269[(1)] = (12));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11193 === (11)))
{var inst_11167 = (state_11192[(2)]);var state_11192__$1 = (function (){var statearr_11206 = state_11192;(statearr_11206[(10)] = inst_11167);
return statearr_11206;
})();var statearr_11207_11270 = state_11192__$1;(statearr_11207_11270[(2)] = null);
(statearr_11207_11270[(1)] = (12));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11193 === (9)))
{var state_11192__$1 = state_11192;var statearr_11208_11271 = state_11192__$1;(statearr_11208_11271[(2)] = null);
(statearr_11208_11271[(1)] = (10));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11193 === (5)))
{var state_11192__$1 = state_11192;if(cljs.core.truth_(close_QMARK_))
{var statearr_11209_11272 = state_11192__$1;(statearr_11209_11272[(1)] = (8));
} else
{var statearr_11210_11273 = state_11192__$1;(statearr_11210_11273[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11193 === (14)))
{var inst_11172 = (state_11192[(11)]);var inst_11170 = (state_11192[(8)]);var inst_11170__$1 = (state_11192[(2)]);var inst_11171 = (inst_11170__$1 == null);var inst_11172__$1 = cljs.core.not.call(null,inst_11171);var state_11192__$1 = (function (){var statearr_11211 = state_11192;(statearr_11211[(11)] = inst_11172__$1);
(statearr_11211[(8)] = inst_11170__$1);
return statearr_11211;
})();if(inst_11172__$1)
{var statearr_11212_11274 = state_11192__$1;(statearr_11212_11274[(1)] = (15));
} else
{var statearr_11213_11275 = state_11192__$1;(statearr_11213_11275[(1)] = (16));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11193 === (16)))
{var inst_11172 = (state_11192[(11)]);var state_11192__$1 = state_11192;var statearr_11214_11276 = state_11192__$1;(statearr_11214_11276[(2)] = inst_11172);
(statearr_11214_11276[(1)] = (17));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11193 === (10)))
{var inst_11164 = (state_11192[(2)]);var state_11192__$1 = state_11192;var statearr_11215_11277 = state_11192__$1;(statearr_11215_11277[(2)] = inst_11164);
(statearr_11215_11277[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11193 === (18)))
{var inst_11175 = (state_11192[(2)]);var state_11192__$1 = state_11192;var statearr_11216_11278 = state_11192__$1;(statearr_11216_11278[(2)] = inst_11175);
(statearr_11216_11278[(1)] = (17));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11193 === (8)))
{var inst_11161 = cljs.core.async.close_BANG_.call(null,to);var state_11192__$1 = state_11192;var statearr_11217_11279 = state_11192__$1;(statearr_11217_11279[(2)] = inst_11161);
(statearr_11217_11279[(1)] = (10));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__5915__auto__,jobs,results,process,async))
;return ((function (switch__5900__auto__,c__5915__auto__,jobs,results,process,async){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_11221 = [null,null,null,null,null,null,null,null,null,null,null,null];(statearr_11221[(0)] = state_machine__5901__auto__);
(statearr_11221[(1)] = (1));
return statearr_11221;
});
var state_machine__5901__auto____1 = (function (state_11192){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_11192);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e11222){if((e11222 instanceof Object))
{var ex__5904__auto__ = e11222;var statearr_11223_11280 = state_11192;(statearr_11223_11280[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11192);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e11222;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__11281 = state_11192;
state_11192 = G__11281;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_11192){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_11192);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto__,jobs,results,process,async))
})();var state__5917__auto__ = (function (){var statearr_11224 = f__5916__auto__.call(null);(statearr_11224[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto__);
return statearr_11224;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto__,jobs,results,process,async))
);
return c__5915__auto__;
});
/**
* Takes elements from the from channel and supplies them to the to
* channel, subject to the async function af, with parallelism n. af
* must be a function of two arguments, the first an input value and
* the second a channel on which to place the result(s). af must close!
* the channel before returning.  The presumption is that af will
* return immediately, having launched some asynchronous operation
* whose completion/callback will manipulate the result channel. Outputs
* will be returned in order relative to  the inputs. By default, the to
* channel will be closed when the from channel closes, but can be
* determined by the close?  parameter. Will stop consuming the from
* channel if the to channel closes.
*/
cljs.core.async.pipeline_async = (function() {
var pipeline_async = null;
var pipeline_async__4 = (function (n,to,af,from){return pipeline_async.call(null,n,to,af,from,true);
});
var pipeline_async__5 = (function (n,to,af,from,close_QMARK_){return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});
pipeline_async = function(n,to,af,from,close_QMARK_){
switch(arguments.length){
case 4:
return pipeline_async__4.call(this,n,to,af,from);
case 5:
return pipeline_async__5.call(this,n,to,af,from,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pipeline_async.cljs$core$IFn$_invoke$arity$4 = pipeline_async__4;
pipeline_async.cljs$core$IFn$_invoke$arity$5 = pipeline_async__5;
return pipeline_async;
})()
;
/**
* Takes elements from the from channel and supplies them to the to
* channel, subject to the transducer xf, with parallelism n. Because
* it is parallel, the transducer will be applied independently to each
* element, not across elements, and may produce zero or more outputs
* per input.  Outputs will be returned in order relative to the
* inputs. By default, the to channel will be closed when the from
* channel closes, but can be determined by the close?  parameter. Will
* stop consuming the from channel if the to channel closes.
* 
* Note this is supplied for API compatibility with the Clojure version.
* Values of N > 1 will not result in actual concurrency in a
* single-threaded runtime.
*/
cljs.core.async.pipeline = (function() {
var pipeline = null;
var pipeline__4 = (function (n,to,xf,from){return pipeline.call(null,n,to,xf,from,true);
});
var pipeline__5 = (function (n,to,xf,from,close_QMARK_){return pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});
var pipeline__6 = (function (n,to,xf,from,close_QMARK_,ex_handler){return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});
pipeline = function(n,to,xf,from,close_QMARK_,ex_handler){
switch(arguments.length){
case 4:
return pipeline__4.call(this,n,to,xf,from);
case 5:
return pipeline__5.call(this,n,to,xf,from,close_QMARK_);
case 6:
return pipeline__6.call(this,n,to,xf,from,close_QMARK_,ex_handler);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pipeline.cljs$core$IFn$_invoke$arity$4 = pipeline__4;
pipeline.cljs$core$IFn$_invoke$arity$5 = pipeline__5;
pipeline.cljs$core$IFn$_invoke$arity$6 = pipeline__6;
return pipeline;
})()
;
/**
* Takes a predicate and a source channel and returns a vector of two
* channels, the first of which will contain the values for which the
* predicate returned true, the second those for which it returned
* false.
* 
* The out channels will be unbuffered by default, or two buf-or-ns can
* be supplied. The channels will close after the source channel has
* closed.
*/
cljs.core.async.split = (function() {
var split = null;
var split__2 = (function (p,ch){return split.call(null,p,ch,null,null);
});
var split__4 = (function (p,ch,t_buf_or_n,f_buf_or_n){var tc = cljs.core.async.chan.call(null,t_buf_or_n);var fc = cljs.core.async.chan.call(null,f_buf_or_n);var c__5915__auto___11382 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto___11382,tc,fc){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto___11382,tc,fc){
return (function (state_11357){var state_val_11358 = (state_11357[(1)]);if((state_val_11358 === (7)))
{var inst_11353 = (state_11357[(2)]);var state_11357__$1 = state_11357;var statearr_11359_11383 = state_11357__$1;(statearr_11359_11383[(2)] = inst_11353);
(statearr_11359_11383[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11358 === (1)))
{var state_11357__$1 = state_11357;var statearr_11360_11384 = state_11357__$1;(statearr_11360_11384[(2)] = null);
(statearr_11360_11384[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11358 === (4)))
{var inst_11334 = (state_11357[(7)]);var inst_11334__$1 = (state_11357[(2)]);var inst_11335 = (inst_11334__$1 == null);var state_11357__$1 = (function (){var statearr_11361 = state_11357;(statearr_11361[(7)] = inst_11334__$1);
return statearr_11361;
})();if(cljs.core.truth_(inst_11335))
{var statearr_11362_11385 = state_11357__$1;(statearr_11362_11385[(1)] = (5));
} else
{var statearr_11363_11386 = state_11357__$1;(statearr_11363_11386[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11358 === (13)))
{var state_11357__$1 = state_11357;var statearr_11364_11387 = state_11357__$1;(statearr_11364_11387[(2)] = null);
(statearr_11364_11387[(1)] = (14));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11358 === (6)))
{var inst_11334 = (state_11357[(7)]);var inst_11340 = p.call(null,inst_11334);var state_11357__$1 = state_11357;if(cljs.core.truth_(inst_11340))
{var statearr_11365_11388 = state_11357__$1;(statearr_11365_11388[(1)] = (9));
} else
{var statearr_11366_11389 = state_11357__$1;(statearr_11366_11389[(1)] = (10));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11358 === (3)))
{var inst_11355 = (state_11357[(2)]);var state_11357__$1 = state_11357;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11357__$1,inst_11355);
} else
{if((state_val_11358 === (12)))
{var state_11357__$1 = state_11357;var statearr_11367_11390 = state_11357__$1;(statearr_11367_11390[(2)] = null);
(statearr_11367_11390[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11358 === (2)))
{var state_11357__$1 = state_11357;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11357__$1,(4),ch);
} else
{if((state_val_11358 === (11)))
{var inst_11334 = (state_11357[(7)]);var inst_11344 = (state_11357[(2)]);var state_11357__$1 = state_11357;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11357__$1,(8),inst_11344,inst_11334);
} else
{if((state_val_11358 === (9)))
{var state_11357__$1 = state_11357;var statearr_11368_11391 = state_11357__$1;(statearr_11368_11391[(2)] = tc);
(statearr_11368_11391[(1)] = (11));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11358 === (5)))
{var inst_11337 = cljs.core.async.close_BANG_.call(null,tc);var inst_11338 = cljs.core.async.close_BANG_.call(null,fc);var state_11357__$1 = (function (){var statearr_11369 = state_11357;(statearr_11369[(8)] = inst_11337);
return statearr_11369;
})();var statearr_11370_11392 = state_11357__$1;(statearr_11370_11392[(2)] = inst_11338);
(statearr_11370_11392[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11358 === (14)))
{var inst_11351 = (state_11357[(2)]);var state_11357__$1 = state_11357;var statearr_11371_11393 = state_11357__$1;(statearr_11371_11393[(2)] = inst_11351);
(statearr_11371_11393[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11358 === (10)))
{var state_11357__$1 = state_11357;var statearr_11372_11394 = state_11357__$1;(statearr_11372_11394[(2)] = fc);
(statearr_11372_11394[(1)] = (11));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11358 === (8)))
{var inst_11346 = (state_11357[(2)]);var state_11357__$1 = state_11357;if(cljs.core.truth_(inst_11346))
{var statearr_11373_11395 = state_11357__$1;(statearr_11373_11395[(1)] = (12));
} else
{var statearr_11374_11396 = state_11357__$1;(statearr_11374_11396[(1)] = (13));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__5915__auto___11382,tc,fc))
;return ((function (switch__5900__auto__,c__5915__auto___11382,tc,fc){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_11378 = [null,null,null,null,null,null,null,null,null];(statearr_11378[(0)] = state_machine__5901__auto__);
(statearr_11378[(1)] = (1));
return statearr_11378;
});
var state_machine__5901__auto____1 = (function (state_11357){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_11357);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e11379){if((e11379 instanceof Object))
{var ex__5904__auto__ = e11379;var statearr_11380_11397 = state_11357;(statearr_11380_11397[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11357);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e11379;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__11398 = state_11357;
state_11357 = G__11398;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_11357){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_11357);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto___11382,tc,fc))
})();var state__5917__auto__ = (function (){var statearr_11381 = f__5916__auto__.call(null);(statearr_11381[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto___11382);
return statearr_11381;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto___11382,tc,fc))
);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});
split = function(p,ch,t_buf_or_n,f_buf_or_n){
switch(arguments.length){
case 2:
return split__2.call(this,p,ch);
case 4:
return split__4.call(this,p,ch,t_buf_or_n,f_buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
split.cljs$core$IFn$_invoke$arity$2 = split__2;
split.cljs$core$IFn$_invoke$arity$4 = split__4;
return split;
})()
;
/**
* f should be a function of 2 arguments. Returns a channel containing
* the single result of applying f to init and the first item from the
* channel, then applying f to that result and the 2nd item, etc. If
* the channel closes without yielding items, returns init and f is not
* called. ch must close before reduce produces a result.
*/
cljs.core.async.reduce = (function reduce(f,init,ch){var c__5915__auto__ = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto__){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto__){
return (function (state_11445){var state_val_11446 = (state_11445[(1)]);if((state_val_11446 === (7)))
{var inst_11441 = (state_11445[(2)]);var state_11445__$1 = state_11445;var statearr_11447_11463 = state_11445__$1;(statearr_11447_11463[(2)] = inst_11441);
(statearr_11447_11463[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11446 === (6)))
{var inst_11431 = (state_11445[(7)]);var inst_11434 = (state_11445[(8)]);var inst_11438 = f.call(null,inst_11431,inst_11434);var inst_11431__$1 = inst_11438;var state_11445__$1 = (function (){var statearr_11448 = state_11445;(statearr_11448[(7)] = inst_11431__$1);
return statearr_11448;
})();var statearr_11449_11464 = state_11445__$1;(statearr_11449_11464[(2)] = null);
(statearr_11449_11464[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11446 === (5)))
{var inst_11431 = (state_11445[(7)]);var state_11445__$1 = state_11445;var statearr_11450_11465 = state_11445__$1;(statearr_11450_11465[(2)] = inst_11431);
(statearr_11450_11465[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11446 === (4)))
{var inst_11434 = (state_11445[(8)]);var inst_11434__$1 = (state_11445[(2)]);var inst_11435 = (inst_11434__$1 == null);var state_11445__$1 = (function (){var statearr_11451 = state_11445;(statearr_11451[(8)] = inst_11434__$1);
return statearr_11451;
})();if(cljs.core.truth_(inst_11435))
{var statearr_11452_11466 = state_11445__$1;(statearr_11452_11466[(1)] = (5));
} else
{var statearr_11453_11467 = state_11445__$1;(statearr_11453_11467[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11446 === (3)))
{var inst_11443 = (state_11445[(2)]);var state_11445__$1 = state_11445;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11445__$1,inst_11443);
} else
{if((state_val_11446 === (2)))
{var state_11445__$1 = state_11445;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11445__$1,(4),ch);
} else
{if((state_val_11446 === (1)))
{var inst_11431 = init;var state_11445__$1 = (function (){var statearr_11454 = state_11445;(statearr_11454[(7)] = inst_11431);
return statearr_11454;
})();var statearr_11455_11468 = state_11445__$1;(statearr_11455_11468[(2)] = null);
(statearr_11455_11468[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
});})(c__5915__auto__))
;return ((function (switch__5900__auto__,c__5915__auto__){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_11459 = [null,null,null,null,null,null,null,null,null];(statearr_11459[(0)] = state_machine__5901__auto__);
(statearr_11459[(1)] = (1));
return statearr_11459;
});
var state_machine__5901__auto____1 = (function (state_11445){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_11445);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e11460){if((e11460 instanceof Object))
{var ex__5904__auto__ = e11460;var statearr_11461_11469 = state_11445;(statearr_11461_11469[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11445);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e11460;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__11470 = state_11445;
state_11445 = G__11470;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_11445){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_11445);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto__))
})();var state__5917__auto__ = (function (){var statearr_11462 = f__5916__auto__.call(null);(statearr_11462[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto__);
return statearr_11462;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto__))
);
return c__5915__auto__;
});
/**
* Puts the contents of coll into the supplied channel.
* 
* By default the channel will be closed after the items are copied,
* but can be determined by the close? parameter.
* 
* Returns a channel which will close after the items are copied.
*/
cljs.core.async.onto_chan = (function() {
var onto_chan = null;
var onto_chan__2 = (function (ch,coll){return onto_chan.call(null,ch,coll,true);
});
var onto_chan__3 = (function (ch,coll,close_QMARK_){var c__5915__auto__ = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto__){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto__){
return (function (state_11544){var state_val_11545 = (state_11544[(1)]);if((state_val_11545 === (7)))
{var inst_11526 = (state_11544[(2)]);var state_11544__$1 = state_11544;var statearr_11546_11569 = state_11544__$1;(statearr_11546_11569[(2)] = inst_11526);
(statearr_11546_11569[(1)] = (6));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11545 === (1)))
{var inst_11520 = cljs.core.seq.call(null,coll);var inst_11521 = inst_11520;var state_11544__$1 = (function (){var statearr_11547 = state_11544;(statearr_11547[(7)] = inst_11521);
return statearr_11547;
})();var statearr_11548_11570 = state_11544__$1;(statearr_11548_11570[(2)] = null);
(statearr_11548_11570[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11545 === (4)))
{var inst_11521 = (state_11544[(7)]);var inst_11524 = cljs.core.first.call(null,inst_11521);var state_11544__$1 = state_11544;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11544__$1,(7),ch,inst_11524);
} else
{if((state_val_11545 === (13)))
{var inst_11538 = (state_11544[(2)]);var state_11544__$1 = state_11544;var statearr_11549_11571 = state_11544__$1;(statearr_11549_11571[(2)] = inst_11538);
(statearr_11549_11571[(1)] = (10));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11545 === (6)))
{var inst_11529 = (state_11544[(2)]);var state_11544__$1 = state_11544;if(cljs.core.truth_(inst_11529))
{var statearr_11550_11572 = state_11544__$1;(statearr_11550_11572[(1)] = (8));
} else
{var statearr_11551_11573 = state_11544__$1;(statearr_11551_11573[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11545 === (3)))
{var inst_11542 = (state_11544[(2)]);var state_11544__$1 = state_11544;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11544__$1,inst_11542);
} else
{if((state_val_11545 === (12)))
{var state_11544__$1 = state_11544;var statearr_11552_11574 = state_11544__$1;(statearr_11552_11574[(2)] = null);
(statearr_11552_11574[(1)] = (13));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11545 === (2)))
{var inst_11521 = (state_11544[(7)]);var state_11544__$1 = state_11544;if(cljs.core.truth_(inst_11521))
{var statearr_11553_11575 = state_11544__$1;(statearr_11553_11575[(1)] = (4));
} else
{var statearr_11554_11576 = state_11544__$1;(statearr_11554_11576[(1)] = (5));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11545 === (11)))
{var inst_11535 = cljs.core.async.close_BANG_.call(null,ch);var state_11544__$1 = state_11544;var statearr_11555_11577 = state_11544__$1;(statearr_11555_11577[(2)] = inst_11535);
(statearr_11555_11577[(1)] = (13));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11545 === (9)))
{var state_11544__$1 = state_11544;if(cljs.core.truth_(close_QMARK_))
{var statearr_11556_11578 = state_11544__$1;(statearr_11556_11578[(1)] = (11));
} else
{var statearr_11557_11579 = state_11544__$1;(statearr_11557_11579[(1)] = (12));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11545 === (5)))
{var inst_11521 = (state_11544[(7)]);var state_11544__$1 = state_11544;var statearr_11558_11580 = state_11544__$1;(statearr_11558_11580[(2)] = inst_11521);
(statearr_11558_11580[(1)] = (6));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11545 === (10)))
{var inst_11540 = (state_11544[(2)]);var state_11544__$1 = state_11544;var statearr_11559_11581 = state_11544__$1;(statearr_11559_11581[(2)] = inst_11540);
(statearr_11559_11581[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11545 === (8)))
{var inst_11521 = (state_11544[(7)]);var inst_11531 = cljs.core.next.call(null,inst_11521);var inst_11521__$1 = inst_11531;var state_11544__$1 = (function (){var statearr_11560 = state_11544;(statearr_11560[(7)] = inst_11521__$1);
return statearr_11560;
})();var statearr_11561_11582 = state_11544__$1;(statearr_11561_11582[(2)] = null);
(statearr_11561_11582[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__5915__auto__))
;return ((function (switch__5900__auto__,c__5915__auto__){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_11565 = [null,null,null,null,null,null,null,null];(statearr_11565[(0)] = state_machine__5901__auto__);
(statearr_11565[(1)] = (1));
return statearr_11565;
});
var state_machine__5901__auto____1 = (function (state_11544){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_11544);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e11566){if((e11566 instanceof Object))
{var ex__5904__auto__ = e11566;var statearr_11567_11583 = state_11544;(statearr_11567_11583[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11544);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e11566;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__11584 = state_11544;
state_11544 = G__11584;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_11544){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_11544);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto__))
})();var state__5917__auto__ = (function (){var statearr_11568 = f__5916__auto__.call(null);(statearr_11568[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto__);
return statearr_11568;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto__))
);
return c__5915__auto__;
});
onto_chan = function(ch,coll,close_QMARK_){
switch(arguments.length){
case 2:
return onto_chan__2.call(this,ch,coll);
case 3:
return onto_chan__3.call(this,ch,coll,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
onto_chan.cljs$core$IFn$_invoke$arity$2 = onto_chan__2;
onto_chan.cljs$core$IFn$_invoke$arity$3 = onto_chan__3;
return onto_chan;
})()
;
/**
* Creates and returns a channel which contains the contents of coll,
* closing when exhausted.
*/
cljs.core.async.to_chan = (function to_chan(coll){var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));cljs.core.async.onto_chan.call(null,ch,coll);
return ch;
});
cljs.core.async.Mux = (function (){var obj11586 = {};return obj11586;
})();
cljs.core.async.muxch_STAR_ = (function muxch_STAR_(_){if((function (){var and__3636__auto__ = _;if(and__3636__auto__)
{return _.cljs$core$async$Mux$muxch_STAR_$arity$1;
} else
{return and__3636__auto__;
}
})())
{return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else
{var x__4285__auto__ = (((_ == null))?null:_);return (function (){var or__3648__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4285__auto__)]);if(or__3648__auto__)
{return or__3648__auto__;
} else
{var or__3648__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);if(or__3648__auto____$1)
{return or__3648__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
})().call(null,_);
}
});
cljs.core.async.Mult = (function (){var obj11588 = {};return obj11588;
})();
cljs.core.async.tap_STAR_ = (function tap_STAR_(m,ch,close_QMARK_){if((function (){var and__3636__auto__ = m;if(and__3636__auto__)
{return m.cljs$core$async$Mult$tap_STAR_$arity$3;
} else
{return and__3636__auto__;
}
})())
{return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else
{var x__4285__auto__ = (((m == null))?null:m);return (function (){var or__3648__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4285__auto__)]);if(or__3648__auto__)
{return or__3648__auto__;
} else
{var or__3648__auto____$1 = (cljs.core.async.tap_STAR_["_"]);if(or__3648__auto____$1)
{return or__3648__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
})().call(null,m,ch,close_QMARK_);
}
});
cljs.core.async.untap_STAR_ = (function untap_STAR_(m,ch){if((function (){var and__3636__auto__ = m;if(and__3636__auto__)
{return m.cljs$core$async$Mult$untap_STAR_$arity$2;
} else
{return and__3636__auto__;
}
})())
{return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else
{var x__4285__auto__ = (((m == null))?null:m);return (function (){var or__3648__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4285__auto__)]);if(or__3648__auto__)
{return or__3648__auto__;
} else
{var or__3648__auto____$1 = (cljs.core.async.untap_STAR_["_"]);if(or__3648__auto____$1)
{return or__3648__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
})().call(null,m,ch);
}
});
cljs.core.async.untap_all_STAR_ = (function untap_all_STAR_(m){if((function (){var and__3636__auto__ = m;if(and__3636__auto__)
{return m.cljs$core$async$Mult$untap_all_STAR_$arity$1;
} else
{return and__3636__auto__;
}
})())
{return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else
{var x__4285__auto__ = (((m == null))?null:m);return (function (){var or__3648__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4285__auto__)]);if(or__3648__auto__)
{return or__3648__auto__;
} else
{var or__3648__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);if(or__3648__auto____$1)
{return or__3648__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
})().call(null,m);
}
});
/**
* Creates and returns a mult(iple) of the supplied channel. Channels
* containing copies of the channel can be created with 'tap', and
* detached with 'untap'.
* 
* Each item is distributed to all taps in parallel and synchronously,
* i.e. each tap must accept before the next item is distributed. Use
* buffering/windowing to prevent slow taps from holding up the mult.
* 
* Items received when there are no taps get dropped.
* 
* If a tap puts to a closed channel, it will be removed from the mult.
*/
cljs.core.async.mult = (function mult(ch){var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);var m = (function (){if(typeof cljs.core.async.t11810 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t11810 = (function (cs,ch,mult,meta11811){
this.cs = cs;
this.ch = ch;
this.mult = mult;
this.meta11811 = meta11811;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t11810.cljs$lang$type = true;
cljs.core.async.t11810.cljs$lang$ctorStr = "cljs.core.async/t11810";
cljs.core.async.t11810.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__4225__auto__,writer__4226__auto__,opt__4227__auto__){return cljs.core._write.call(null,writer__4226__auto__,"cljs.core.async/t11810");
});})(cs))
;
cljs.core.async.t11810.prototype.cljs$core$async$Mult$ = true;
cljs.core.async.t11810.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$2,close_QMARK_){var self__ = this;
var ___$1 = this;cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$2,close_QMARK_);
return null;
});})(cs))
;
cljs.core.async.t11810.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$2){var self__ = this;
var ___$1 = this;cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$2);
return null;
});})(cs))
;
cljs.core.async.t11810.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){var self__ = this;
var ___$1 = this;cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);
return null;
});})(cs))
;
cljs.core.async.t11810.prototype.cljs$core$async$Mux$ = true;
cljs.core.async.t11810.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){var self__ = this;
var ___$1 = this;return self__.ch;
});})(cs))
;
cljs.core.async.t11810.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_11812){var self__ = this;
var _11812__$1 = this;return self__.meta11811;
});})(cs))
;
cljs.core.async.t11810.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_11812,meta11811__$1){var self__ = this;
var _11812__$1 = this;return (new cljs.core.async.t11810(self__.cs,self__.ch,self__.mult,meta11811__$1));
});})(cs))
;
cljs.core.async.__GT_t11810 = ((function (cs){
return (function __GT_t11810(cs__$1,ch__$1,mult__$1,meta11811){return (new cljs.core.async.t11810(cs__$1,ch__$1,mult__$1,meta11811));
});})(cs))
;
}
return (new cljs.core.async.t11810(cs,ch,mult,null));
})();var dchan = cljs.core.async.chan.call(null,(1));var dctr = cljs.core.atom.call(null,null);var done = ((function (cs,m,dchan,dctr){
return (function (_){if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0)))
{return cljs.core.async.put_BANG_.call(null,dchan,true);
} else
{return null;
}
});})(cs,m,dchan,dctr))
;var c__5915__auto___12031 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto___12031,cs,m,dchan,dctr,done){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto___12031,cs,m,dchan,dctr,done){
return (function (state_11943){var state_val_11944 = (state_11943[(1)]);if((state_val_11944 === (7)))
{var inst_11939 = (state_11943[(2)]);var state_11943__$1 = state_11943;var statearr_11945_12032 = state_11943__$1;(statearr_11945_12032[(2)] = inst_11939);
(statearr_11945_12032[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11944 === (20)))
{var inst_11844 = (state_11943[(7)]);var inst_11854 = cljs.core.first.call(null,inst_11844);var inst_11855 = cljs.core.nth.call(null,inst_11854,(0),null);var inst_11856 = cljs.core.nth.call(null,inst_11854,(1),null);var state_11943__$1 = (function (){var statearr_11946 = state_11943;(statearr_11946[(8)] = inst_11855);
return statearr_11946;
})();if(cljs.core.truth_(inst_11856))
{var statearr_11947_12033 = state_11943__$1;(statearr_11947_12033[(1)] = (22));
} else
{var statearr_11948_12034 = state_11943__$1;(statearr_11948_12034[(1)] = (23));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11944 === (27)))
{var inst_11884 = (state_11943[(9)]);var inst_11891 = (state_11943[(10)]);var inst_11815 = (state_11943[(11)]);var inst_11886 = (state_11943[(12)]);var inst_11891__$1 = cljs.core._nth.call(null,inst_11884,inst_11886);var inst_11892 = cljs.core.async.put_BANG_.call(null,inst_11891__$1,inst_11815,done);var state_11943__$1 = (function (){var statearr_11949 = state_11943;(statearr_11949[(10)] = inst_11891__$1);
return statearr_11949;
})();if(cljs.core.truth_(inst_11892))
{var statearr_11950_12035 = state_11943__$1;(statearr_11950_12035[(1)] = (30));
} else
{var statearr_11951_12036 = state_11943__$1;(statearr_11951_12036[(1)] = (31));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11944 === (1)))
{var state_11943__$1 = state_11943;var statearr_11952_12037 = state_11943__$1;(statearr_11952_12037[(2)] = null);
(statearr_11952_12037[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11944 === (24)))
{var inst_11844 = (state_11943[(7)]);var inst_11861 = (state_11943[(2)]);var inst_11862 = cljs.core.next.call(null,inst_11844);var inst_11824 = inst_11862;var inst_11825 = null;var inst_11826 = (0);var inst_11827 = (0);var state_11943__$1 = (function (){var statearr_11953 = state_11943;(statearr_11953[(13)] = inst_11826);
(statearr_11953[(14)] = inst_11825);
(statearr_11953[(15)] = inst_11861);
(statearr_11953[(16)] = inst_11824);
(statearr_11953[(17)] = inst_11827);
return statearr_11953;
})();var statearr_11954_12038 = state_11943__$1;(statearr_11954_12038[(2)] = null);
(statearr_11954_12038[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11944 === (39)))
{var state_11943__$1 = state_11943;var statearr_11958_12039 = state_11943__$1;(statearr_11958_12039[(2)] = null);
(statearr_11958_12039[(1)] = (41));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11944 === (4)))
{var inst_11815 = (state_11943[(11)]);var inst_11815__$1 = (state_11943[(2)]);var inst_11816 = (inst_11815__$1 == null);var state_11943__$1 = (function (){var statearr_11959 = state_11943;(statearr_11959[(11)] = inst_11815__$1);
return statearr_11959;
})();if(cljs.core.truth_(inst_11816))
{var statearr_11960_12040 = state_11943__$1;(statearr_11960_12040[(1)] = (5));
} else
{var statearr_11961_12041 = state_11943__$1;(statearr_11961_12041[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11944 === (15)))
{var inst_11826 = (state_11943[(13)]);var inst_11825 = (state_11943[(14)]);var inst_11824 = (state_11943[(16)]);var inst_11827 = (state_11943[(17)]);var inst_11840 = (state_11943[(2)]);var inst_11841 = (inst_11827 + (1));var tmp11955 = inst_11826;var tmp11956 = inst_11825;var tmp11957 = inst_11824;var inst_11824__$1 = tmp11957;var inst_11825__$1 = tmp11956;var inst_11826__$1 = tmp11955;var inst_11827__$1 = inst_11841;var state_11943__$1 = (function (){var statearr_11962 = state_11943;(statearr_11962[(13)] = inst_11826__$1);
(statearr_11962[(14)] = inst_11825__$1);
(statearr_11962[(16)] = inst_11824__$1);
(statearr_11962[(17)] = inst_11827__$1);
(statearr_11962[(18)] = inst_11840);
return statearr_11962;
})();var statearr_11963_12042 = state_11943__$1;(statearr_11963_12042[(2)] = null);
(statearr_11963_12042[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11944 === (21)))
{var inst_11865 = (state_11943[(2)]);var state_11943__$1 = state_11943;var statearr_11967_12043 = state_11943__$1;(statearr_11967_12043[(2)] = inst_11865);
(statearr_11967_12043[(1)] = (18));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11944 === (31)))
{var inst_11891 = (state_11943[(10)]);var inst_11895 = done.call(null,null);var inst_11896 = cljs.core.async.untap_STAR_.call(null,m,inst_11891);var state_11943__$1 = (function (){var statearr_11968 = state_11943;(statearr_11968[(19)] = inst_11895);
return statearr_11968;
})();var statearr_11969_12044 = state_11943__$1;(statearr_11969_12044[(2)] = inst_11896);
(statearr_11969_12044[(1)] = (32));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11944 === (32)))
{var inst_11884 = (state_11943[(9)]);var inst_11885 = (state_11943[(20)]);var inst_11886 = (state_11943[(12)]);var inst_11883 = (state_11943[(21)]);var inst_11898 = (state_11943[(2)]);var inst_11899 = (inst_11886 + (1));var tmp11964 = inst_11884;var tmp11965 = inst_11885;var tmp11966 = inst_11883;var inst_11883__$1 = tmp11966;var inst_11884__$1 = tmp11964;var inst_11885__$1 = tmp11965;var inst_11886__$1 = inst_11899;var state_11943__$1 = (function (){var statearr_11970 = state_11943;(statearr_11970[(9)] = inst_11884__$1);
(statearr_11970[(22)] = inst_11898);
(statearr_11970[(20)] = inst_11885__$1);
(statearr_11970[(12)] = inst_11886__$1);
(statearr_11970[(21)] = inst_11883__$1);
return statearr_11970;
})();var statearr_11971_12045 = state_11943__$1;(statearr_11971_12045[(2)] = null);
(statearr_11971_12045[(1)] = (25));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11944 === (40)))
{var inst_11911 = (state_11943[(23)]);var inst_11915 = done.call(null,null);var inst_11916 = cljs.core.async.untap_STAR_.call(null,m,inst_11911);var state_11943__$1 = (function (){var statearr_11972 = state_11943;(statearr_11972[(24)] = inst_11915);
return statearr_11972;
})();var statearr_11973_12046 = state_11943__$1;(statearr_11973_12046[(2)] = inst_11916);
(statearr_11973_12046[(1)] = (41));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11944 === (33)))
{var inst_11902 = (state_11943[(25)]);var inst_11904 = cljs.core.chunked_seq_QMARK_.call(null,inst_11902);var state_11943__$1 = state_11943;if(inst_11904)
{var statearr_11974_12047 = state_11943__$1;(statearr_11974_12047[(1)] = (36));
} else
{var statearr_11975_12048 = state_11943__$1;(statearr_11975_12048[(1)] = (37));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11944 === (13)))
{var inst_11834 = (state_11943[(26)]);var inst_11837 = cljs.core.async.close_BANG_.call(null,inst_11834);var state_11943__$1 = state_11943;var statearr_11976_12049 = state_11943__$1;(statearr_11976_12049[(2)] = inst_11837);
(statearr_11976_12049[(1)] = (15));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11944 === (22)))
{var inst_11855 = (state_11943[(8)]);var inst_11858 = cljs.core.async.close_BANG_.call(null,inst_11855);var state_11943__$1 = state_11943;var statearr_11977_12050 = state_11943__$1;(statearr_11977_12050[(2)] = inst_11858);
(statearr_11977_12050[(1)] = (24));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11944 === (36)))
{var inst_11902 = (state_11943[(25)]);var inst_11906 = cljs.core.chunk_first.call(null,inst_11902);var inst_11907 = cljs.core.chunk_rest.call(null,inst_11902);var inst_11908 = cljs.core.count.call(null,inst_11906);var inst_11883 = inst_11907;var inst_11884 = inst_11906;var inst_11885 = inst_11908;var inst_11886 = (0);var state_11943__$1 = (function (){var statearr_11978 = state_11943;(statearr_11978[(9)] = inst_11884);
(statearr_11978[(20)] = inst_11885);
(statearr_11978[(12)] = inst_11886);
(statearr_11978[(21)] = inst_11883);
return statearr_11978;
})();var statearr_11979_12051 = state_11943__$1;(statearr_11979_12051[(2)] = null);
(statearr_11979_12051[(1)] = (25));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11944 === (41)))
{var inst_11902 = (state_11943[(25)]);var inst_11918 = (state_11943[(2)]);var inst_11919 = cljs.core.next.call(null,inst_11902);var inst_11883 = inst_11919;var inst_11884 = null;var inst_11885 = (0);var inst_11886 = (0);var state_11943__$1 = (function (){var statearr_11980 = state_11943;(statearr_11980[(9)] = inst_11884);
(statearr_11980[(27)] = inst_11918);
(statearr_11980[(20)] = inst_11885);
(statearr_11980[(12)] = inst_11886);
(statearr_11980[(21)] = inst_11883);
return statearr_11980;
})();var statearr_11981_12052 = state_11943__$1;(statearr_11981_12052[(2)] = null);
(statearr_11981_12052[(1)] = (25));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11944 === (43)))
{var state_11943__$1 = state_11943;var statearr_11982_12053 = state_11943__$1;(statearr_11982_12053[(2)] = null);
(statearr_11982_12053[(1)] = (44));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11944 === (29)))
{var inst_11927 = (state_11943[(2)]);var state_11943__$1 = state_11943;var statearr_11983_12054 = state_11943__$1;(statearr_11983_12054[(2)] = inst_11927);
(statearr_11983_12054[(1)] = (26));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11944 === (44)))
{var inst_11936 = (state_11943[(2)]);var state_11943__$1 = (function (){var statearr_11984 = state_11943;(statearr_11984[(28)] = inst_11936);
return statearr_11984;
})();var statearr_11985_12055 = state_11943__$1;(statearr_11985_12055[(2)] = null);
(statearr_11985_12055[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11944 === (6)))
{var inst_11875 = (state_11943[(29)]);var inst_11874 = cljs.core.deref.call(null,cs);var inst_11875__$1 = cljs.core.keys.call(null,inst_11874);var inst_11876 = cljs.core.count.call(null,inst_11875__$1);var inst_11877 = cljs.core.reset_BANG_.call(null,dctr,inst_11876);var inst_11882 = cljs.core.seq.call(null,inst_11875__$1);var inst_11883 = inst_11882;var inst_11884 = null;var inst_11885 = (0);var inst_11886 = (0);var state_11943__$1 = (function (){var statearr_11986 = state_11943;(statearr_11986[(9)] = inst_11884);
(statearr_11986[(20)] = inst_11885);
(statearr_11986[(29)] = inst_11875__$1);
(statearr_11986[(12)] = inst_11886);
(statearr_11986[(30)] = inst_11877);
(statearr_11986[(21)] = inst_11883);
return statearr_11986;
})();var statearr_11987_12056 = state_11943__$1;(statearr_11987_12056[(2)] = null);
(statearr_11987_12056[(1)] = (25));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11944 === (28)))
{var inst_11902 = (state_11943[(25)]);var inst_11883 = (state_11943[(21)]);var inst_11902__$1 = cljs.core.seq.call(null,inst_11883);var state_11943__$1 = (function (){var statearr_11988 = state_11943;(statearr_11988[(25)] = inst_11902__$1);
return statearr_11988;
})();if(inst_11902__$1)
{var statearr_11989_12057 = state_11943__$1;(statearr_11989_12057[(1)] = (33));
} else
{var statearr_11990_12058 = state_11943__$1;(statearr_11990_12058[(1)] = (34));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11944 === (25)))
{var inst_11885 = (state_11943[(20)]);var inst_11886 = (state_11943[(12)]);var inst_11888 = (inst_11886 < inst_11885);var inst_11889 = inst_11888;var state_11943__$1 = state_11943;if(cljs.core.truth_(inst_11889))
{var statearr_11991_12059 = state_11943__$1;(statearr_11991_12059[(1)] = (27));
} else
{var statearr_11992_12060 = state_11943__$1;(statearr_11992_12060[(1)] = (28));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11944 === (34)))
{var state_11943__$1 = state_11943;var statearr_11993_12061 = state_11943__$1;(statearr_11993_12061[(2)] = null);
(statearr_11993_12061[(1)] = (35));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11944 === (17)))
{var state_11943__$1 = state_11943;var statearr_11994_12062 = state_11943__$1;(statearr_11994_12062[(2)] = null);
(statearr_11994_12062[(1)] = (18));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11944 === (3)))
{var inst_11941 = (state_11943[(2)]);var state_11943__$1 = state_11943;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11943__$1,inst_11941);
} else
{if((state_val_11944 === (12)))
{var inst_11870 = (state_11943[(2)]);var state_11943__$1 = state_11943;var statearr_11995_12063 = state_11943__$1;(statearr_11995_12063[(2)] = inst_11870);
(statearr_11995_12063[(1)] = (9));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11944 === (2)))
{var state_11943__$1 = state_11943;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11943__$1,(4),ch);
} else
{if((state_val_11944 === (23)))
{var state_11943__$1 = state_11943;var statearr_11996_12064 = state_11943__$1;(statearr_11996_12064[(2)] = null);
(statearr_11996_12064[(1)] = (24));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11944 === (35)))
{var inst_11925 = (state_11943[(2)]);var state_11943__$1 = state_11943;var statearr_11997_12065 = state_11943__$1;(statearr_11997_12065[(2)] = inst_11925);
(statearr_11997_12065[(1)] = (29));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11944 === (19)))
{var inst_11844 = (state_11943[(7)]);var inst_11848 = cljs.core.chunk_first.call(null,inst_11844);var inst_11849 = cljs.core.chunk_rest.call(null,inst_11844);var inst_11850 = cljs.core.count.call(null,inst_11848);var inst_11824 = inst_11849;var inst_11825 = inst_11848;var inst_11826 = inst_11850;var inst_11827 = (0);var state_11943__$1 = (function (){var statearr_11998 = state_11943;(statearr_11998[(13)] = inst_11826);
(statearr_11998[(14)] = inst_11825);
(statearr_11998[(16)] = inst_11824);
(statearr_11998[(17)] = inst_11827);
return statearr_11998;
})();var statearr_11999_12066 = state_11943__$1;(statearr_11999_12066[(2)] = null);
(statearr_11999_12066[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11944 === (11)))
{var inst_11844 = (state_11943[(7)]);var inst_11824 = (state_11943[(16)]);var inst_11844__$1 = cljs.core.seq.call(null,inst_11824);var state_11943__$1 = (function (){var statearr_12000 = state_11943;(statearr_12000[(7)] = inst_11844__$1);
return statearr_12000;
})();if(inst_11844__$1)
{var statearr_12001_12067 = state_11943__$1;(statearr_12001_12067[(1)] = (16));
} else
{var statearr_12002_12068 = state_11943__$1;(statearr_12002_12068[(1)] = (17));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11944 === (9)))
{var inst_11872 = (state_11943[(2)]);var state_11943__$1 = state_11943;var statearr_12003_12069 = state_11943__$1;(statearr_12003_12069[(2)] = inst_11872);
(statearr_12003_12069[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11944 === (5)))
{var inst_11822 = cljs.core.deref.call(null,cs);var inst_11823 = cljs.core.seq.call(null,inst_11822);var inst_11824 = inst_11823;var inst_11825 = null;var inst_11826 = (0);var inst_11827 = (0);var state_11943__$1 = (function (){var statearr_12004 = state_11943;(statearr_12004[(13)] = inst_11826);
(statearr_12004[(14)] = inst_11825);
(statearr_12004[(16)] = inst_11824);
(statearr_12004[(17)] = inst_11827);
return statearr_12004;
})();var statearr_12005_12070 = state_11943__$1;(statearr_12005_12070[(2)] = null);
(statearr_12005_12070[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11944 === (14)))
{var state_11943__$1 = state_11943;var statearr_12006_12071 = state_11943__$1;(statearr_12006_12071[(2)] = null);
(statearr_12006_12071[(1)] = (15));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11944 === (45)))
{var inst_11933 = (state_11943[(2)]);var state_11943__$1 = state_11943;var statearr_12007_12072 = state_11943__$1;(statearr_12007_12072[(2)] = inst_11933);
(statearr_12007_12072[(1)] = (44));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11944 === (26)))
{var inst_11875 = (state_11943[(29)]);var inst_11929 = (state_11943[(2)]);var inst_11930 = cljs.core.seq.call(null,inst_11875);var state_11943__$1 = (function (){var statearr_12008 = state_11943;(statearr_12008[(31)] = inst_11929);
return statearr_12008;
})();if(inst_11930)
{var statearr_12009_12073 = state_11943__$1;(statearr_12009_12073[(1)] = (42));
} else
{var statearr_12010_12074 = state_11943__$1;(statearr_12010_12074[(1)] = (43));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11944 === (16)))
{var inst_11844 = (state_11943[(7)]);var inst_11846 = cljs.core.chunked_seq_QMARK_.call(null,inst_11844);var state_11943__$1 = state_11943;if(inst_11846)
{var statearr_12011_12075 = state_11943__$1;(statearr_12011_12075[(1)] = (19));
} else
{var statearr_12012_12076 = state_11943__$1;(statearr_12012_12076[(1)] = (20));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11944 === (38)))
{var inst_11922 = (state_11943[(2)]);var state_11943__$1 = state_11943;var statearr_12013_12077 = state_11943__$1;(statearr_12013_12077[(2)] = inst_11922);
(statearr_12013_12077[(1)] = (35));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11944 === (30)))
{var state_11943__$1 = state_11943;var statearr_12014_12078 = state_11943__$1;(statearr_12014_12078[(2)] = null);
(statearr_12014_12078[(1)] = (32));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11944 === (10)))
{var inst_11825 = (state_11943[(14)]);var inst_11827 = (state_11943[(17)]);var inst_11833 = cljs.core._nth.call(null,inst_11825,inst_11827);var inst_11834 = cljs.core.nth.call(null,inst_11833,(0),null);var inst_11835 = cljs.core.nth.call(null,inst_11833,(1),null);var state_11943__$1 = (function (){var statearr_12015 = state_11943;(statearr_12015[(26)] = inst_11834);
return statearr_12015;
})();if(cljs.core.truth_(inst_11835))
{var statearr_12016_12079 = state_11943__$1;(statearr_12016_12079[(1)] = (13));
} else
{var statearr_12017_12080 = state_11943__$1;(statearr_12017_12080[(1)] = (14));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11944 === (18)))
{var inst_11868 = (state_11943[(2)]);var state_11943__$1 = state_11943;var statearr_12018_12081 = state_11943__$1;(statearr_12018_12081[(2)] = inst_11868);
(statearr_12018_12081[(1)] = (12));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11944 === (42)))
{var state_11943__$1 = state_11943;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11943__$1,(45),dchan);
} else
{if((state_val_11944 === (37)))
{var inst_11902 = (state_11943[(25)]);var inst_11815 = (state_11943[(11)]);var inst_11911 = (state_11943[(23)]);var inst_11911__$1 = cljs.core.first.call(null,inst_11902);var inst_11912 = cljs.core.async.put_BANG_.call(null,inst_11911__$1,inst_11815,done);var state_11943__$1 = (function (){var statearr_12019 = state_11943;(statearr_12019[(23)] = inst_11911__$1);
return statearr_12019;
})();if(cljs.core.truth_(inst_11912))
{var statearr_12020_12082 = state_11943__$1;(statearr_12020_12082[(1)] = (39));
} else
{var statearr_12021_12083 = state_11943__$1;(statearr_12021_12083[(1)] = (40));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11944 === (8)))
{var inst_11826 = (state_11943[(13)]);var inst_11827 = (state_11943[(17)]);var inst_11829 = (inst_11827 < inst_11826);var inst_11830 = inst_11829;var state_11943__$1 = state_11943;if(cljs.core.truth_(inst_11830))
{var statearr_12022_12084 = state_11943__$1;(statearr_12022_12084[(1)] = (10));
} else
{var statearr_12023_12085 = state_11943__$1;(statearr_12023_12085[(1)] = (11));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__5915__auto___12031,cs,m,dchan,dctr,done))
;return ((function (switch__5900__auto__,c__5915__auto___12031,cs,m,dchan,dctr,done){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_12027 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_12027[(0)] = state_machine__5901__auto__);
(statearr_12027[(1)] = (1));
return statearr_12027;
});
var state_machine__5901__auto____1 = (function (state_11943){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_11943);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e12028){if((e12028 instanceof Object))
{var ex__5904__auto__ = e12028;var statearr_12029_12086 = state_11943;(statearr_12029_12086[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11943);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e12028;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__12087 = state_11943;
state_11943 = G__12087;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_11943){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_11943);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto___12031,cs,m,dchan,dctr,done))
})();var state__5917__auto__ = (function (){var statearr_12030 = f__5916__auto__.call(null);(statearr_12030[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto___12031);
return statearr_12030;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto___12031,cs,m,dchan,dctr,done))
);
return m;
});
/**
* Copies the mult source onto the supplied channel.
* 
* By default the channel will be closed when the source closes,
* but can be determined by the close? parameter.
*/
cljs.core.async.tap = (function() {
var tap = null;
var tap__2 = (function (mult,ch){return tap.call(null,mult,ch,true);
});
var tap__3 = (function (mult,ch,close_QMARK_){cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);
return ch;
});
tap = function(mult,ch,close_QMARK_){
switch(arguments.length){
case 2:
return tap__2.call(this,mult,ch);
case 3:
return tap__3.call(this,mult,ch,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
tap.cljs$core$IFn$_invoke$arity$2 = tap__2;
tap.cljs$core$IFn$_invoke$arity$3 = tap__3;
return tap;
})()
;
/**
* Disconnects a target channel from a mult
*/
cljs.core.async.untap = (function untap(mult,ch){return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
* Disconnects all target channels from a mult
*/
cljs.core.async.untap_all = (function untap_all(mult){return cljs.core.async.untap_all_STAR_.call(null,mult);
});
cljs.core.async.Mix = (function (){var obj12089 = {};return obj12089;
})();
cljs.core.async.admix_STAR_ = (function admix_STAR_(m,ch){if((function (){var and__3636__auto__ = m;if(and__3636__auto__)
{return m.cljs$core$async$Mix$admix_STAR_$arity$2;
} else
{return and__3636__auto__;
}
})())
{return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else
{var x__4285__auto__ = (((m == null))?null:m);return (function (){var or__3648__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4285__auto__)]);if(or__3648__auto__)
{return or__3648__auto__;
} else
{var or__3648__auto____$1 = (cljs.core.async.admix_STAR_["_"]);if(or__3648__auto____$1)
{return or__3648__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
})().call(null,m,ch);
}
});
cljs.core.async.unmix_STAR_ = (function unmix_STAR_(m,ch){if((function (){var and__3636__auto__ = m;if(and__3636__auto__)
{return m.cljs$core$async$Mix$unmix_STAR_$arity$2;
} else
{return and__3636__auto__;
}
})())
{return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else
{var x__4285__auto__ = (((m == null))?null:m);return (function (){var or__3648__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4285__auto__)]);if(or__3648__auto__)
{return or__3648__auto__;
} else
{var or__3648__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);if(or__3648__auto____$1)
{return or__3648__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
})().call(null,m,ch);
}
});
cljs.core.async.unmix_all_STAR_ = (function unmix_all_STAR_(m){if((function (){var and__3636__auto__ = m;if(and__3636__auto__)
{return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1;
} else
{return and__3636__auto__;
}
})())
{return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else
{var x__4285__auto__ = (((m == null))?null:m);return (function (){var or__3648__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4285__auto__)]);if(or__3648__auto__)
{return or__3648__auto__;
} else
{var or__3648__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);if(or__3648__auto____$1)
{return or__3648__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
})().call(null,m);
}
});
cljs.core.async.toggle_STAR_ = (function toggle_STAR_(m,state_map){if((function (){var and__3636__auto__ = m;if(and__3636__auto__)
{return m.cljs$core$async$Mix$toggle_STAR_$arity$2;
} else
{return and__3636__auto__;
}
})())
{return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else
{var x__4285__auto__ = (((m == null))?null:m);return (function (){var or__3648__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4285__auto__)]);if(or__3648__auto__)
{return or__3648__auto__;
} else
{var or__3648__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);if(or__3648__auto____$1)
{return or__3648__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
})().call(null,m,state_map);
}
});
cljs.core.async.solo_mode_STAR_ = (function solo_mode_STAR_(m,mode){if((function (){var and__3636__auto__ = m;if(and__3636__auto__)
{return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2;
} else
{return and__3636__auto__;
}
})())
{return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else
{var x__4285__auto__ = (((m == null))?null:m);return (function (){var or__3648__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4285__auto__)]);if(or__3648__auto__)
{return or__3648__auto__;
} else
{var or__3648__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);if(or__3648__auto____$1)
{return or__3648__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
})().call(null,m,mode);
}
});
/**
* @param {...*} var_args
*/
cljs.core.async.ioc_alts_BANG_ = (function() { 
var ioc_alts_BANG___delegate = function (state,cont_block,ports,p__12090){var map__12095 = p__12090;var map__12095__$1 = ((cljs.core.seq_QMARK_.call(null,map__12095))?cljs.core.apply.call(null,cljs.core.hash_map,map__12095):map__12095);var opts = map__12095__$1;var statearr_12096_12099 = state;(statearr_12096_12099[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);
var temp__4126__auto__ = cljs.core.async.do_alts.call(null,((function (map__12095,map__12095__$1,opts){
return (function (val){var statearr_12097_12100 = state;(statearr_12097_12100[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__12095,map__12095__$1,opts))
,ports,opts);if(cljs.core.truth_(temp__4126__auto__))
{var cb = temp__4126__auto__;var statearr_12098_12101 = state;(statearr_12098_12101[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
};
var ioc_alts_BANG_ = function (state,cont_block,ports,var_args){
var p__12090 = null;if (arguments.length > 3) {
  p__12090 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3),0);} 
return ioc_alts_BANG___delegate.call(this,state,cont_block,ports,p__12090);};
ioc_alts_BANG_.cljs$lang$maxFixedArity = 3;
ioc_alts_BANG_.cljs$lang$applyTo = (function (arglist__12102){
var state = cljs.core.first(arglist__12102);
arglist__12102 = cljs.core.next(arglist__12102);
var cont_block = cljs.core.first(arglist__12102);
arglist__12102 = cljs.core.next(arglist__12102);
var ports = cljs.core.first(arglist__12102);
var p__12090 = cljs.core.rest(arglist__12102);
return ioc_alts_BANG___delegate(state,cont_block,ports,p__12090);
});
ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = ioc_alts_BANG___delegate;
return ioc_alts_BANG_;
})()
;
/**
* Creates and returns a mix of one or more input channels which will
* be put on the supplied out channel. Input sources can be added to
* the mix with 'admix', and removed with 'unmix'. A mix supports
* soloing, muting and pausing multiple inputs atomically using
* 'toggle', and can solo using either muting or pausing as determined
* by 'solo-mode'.
* 
* Each channel can have zero or more boolean modes set via 'toggle':
* 
* :solo - when true, only this (ond other soloed) channel(s) will appear
* in the mix output channel. :mute and :pause states of soloed
* channels are ignored. If solo-mode is :mute, non-soloed
* channels are muted, if :pause, non-soloed channels are
* paused.
* 
* :mute - muted channels will have their contents consumed but not included in the mix
* :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
*/
cljs.core.async.mix = (function mix(out){var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));var change = cljs.core.async.chan.call(null);var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){if(cljs.core.truth_(attr.call(null,v)))
{return cljs.core.conj.call(null,ret,c);
} else
{return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){var chs = cljs.core.deref.call(null,cs);var mode = cljs.core.deref.call(null,solo_mode);var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;var m = (function (){if(typeof cljs.core.async.t12222 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t12222 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta12223){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta12223 = meta12223;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t12222.cljs$lang$type = true;
cljs.core.async.t12222.cljs$lang$ctorStr = "cljs.core.async/t12222";
cljs.core.async.t12222.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__4225__auto__,writer__4226__auto__,opt__4227__auto__){return cljs.core._write.call(null,writer__4226__auto__,"cljs.core.async/t12222");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t12222.prototype.cljs$core$async$Mix$ = true;
cljs.core.async.t12222.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){var self__ = this;
var ___$1 = this;cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);
return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t12222.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){var self__ = this;
var ___$1 = this;cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);
return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t12222.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){var self__ = this;
var ___$1 = this;cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);
return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t12222.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){var self__ = this;
var ___$1 = this;cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);
return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t12222.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){var self__ = this;
var ___$1 = this;if(cljs.core.truth_(self__.solo_modes.call(null,mode)))
{} else
{throw (new Error(("Assert failed: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(("mode must be one of: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)))+"\n"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null)))))));
}
cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);
return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t12222.prototype.cljs$core$async$Mux$ = true;
cljs.core.async.t12222.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){var self__ = this;
var ___$1 = this;return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t12222.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_12224){var self__ = this;
var _12224__$1 = this;return self__.meta12223;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t12222.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_12224,meta12223__$1){var self__ = this;
var _12224__$1 = this;return (new cljs.core.async.t12222(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta12223__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.__GT_t12222 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function __GT_t12222(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta12223){return (new cljs.core.async.t12222(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta12223));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
}
return (new cljs.core.async.t12222(change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,null));
})();var c__5915__auto___12341 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto___12341,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto___12341,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_12294){var state_val_12295 = (state_12294[(1)]);if((state_val_12295 === (7)))
{var inst_12238 = (state_12294[(7)]);var inst_12243 = cljs.core.apply.call(null,cljs.core.hash_map,inst_12238);var state_12294__$1 = state_12294;var statearr_12296_12342 = state_12294__$1;(statearr_12296_12342[(2)] = inst_12243);
(statearr_12296_12342[(1)] = (9));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12295 === (20)))
{var inst_12253 = (state_12294[(8)]);var state_12294__$1 = state_12294;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12294__$1,(23),out,inst_12253);
} else
{if((state_val_12295 === (1)))
{var inst_12228 = (state_12294[(9)]);var inst_12228__$1 = calc_state.call(null);var inst_12229 = cljs.core.seq_QMARK_.call(null,inst_12228__$1);var state_12294__$1 = (function (){var statearr_12297 = state_12294;(statearr_12297[(9)] = inst_12228__$1);
return statearr_12297;
})();if(inst_12229)
{var statearr_12298_12343 = state_12294__$1;(statearr_12298_12343[(1)] = (2));
} else
{var statearr_12299_12344 = state_12294__$1;(statearr_12299_12344[(1)] = (3));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12295 === (24)))
{var inst_12246 = (state_12294[(10)]);var inst_12238 = inst_12246;var state_12294__$1 = (function (){var statearr_12300 = state_12294;(statearr_12300[(7)] = inst_12238);
return statearr_12300;
})();var statearr_12301_12345 = state_12294__$1;(statearr_12301_12345[(2)] = null);
(statearr_12301_12345[(1)] = (5));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12295 === (4)))
{var inst_12228 = (state_12294[(9)]);var inst_12234 = (state_12294[(2)]);var inst_12235 = cljs.core.get.call(null,inst_12234,new cljs.core.Keyword(null,"reads","reads",-1215067361));var inst_12236 = cljs.core.get.call(null,inst_12234,new cljs.core.Keyword(null,"mutes","mutes",1068806309));var inst_12237 = cljs.core.get.call(null,inst_12234,new cljs.core.Keyword(null,"solos","solos",1441458643));var inst_12238 = inst_12228;var state_12294__$1 = (function (){var statearr_12302 = state_12294;(statearr_12302[(11)] = inst_12236);
(statearr_12302[(12)] = inst_12235);
(statearr_12302[(7)] = inst_12238);
(statearr_12302[(13)] = inst_12237);
return statearr_12302;
})();var statearr_12303_12346 = state_12294__$1;(statearr_12303_12346[(2)] = null);
(statearr_12303_12346[(1)] = (5));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12295 === (15)))
{var state_12294__$1 = state_12294;var statearr_12304_12347 = state_12294__$1;(statearr_12304_12347[(2)] = null);
(statearr_12304_12347[(1)] = (16));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12295 === (21)))
{var inst_12246 = (state_12294[(10)]);var inst_12238 = inst_12246;var state_12294__$1 = (function (){var statearr_12305 = state_12294;(statearr_12305[(7)] = inst_12238);
return statearr_12305;
})();var statearr_12306_12348 = state_12294__$1;(statearr_12306_12348[(2)] = null);
(statearr_12306_12348[(1)] = (5));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12295 === (13)))
{var inst_12290 = (state_12294[(2)]);var state_12294__$1 = state_12294;var statearr_12307_12349 = state_12294__$1;(statearr_12307_12349[(2)] = inst_12290);
(statearr_12307_12349[(1)] = (6));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12295 === (22)))
{var inst_12288 = (state_12294[(2)]);var state_12294__$1 = state_12294;var statearr_12308_12350 = state_12294__$1;(statearr_12308_12350[(2)] = inst_12288);
(statearr_12308_12350[(1)] = (13));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12295 === (6)))
{var inst_12292 = (state_12294[(2)]);var state_12294__$1 = state_12294;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12294__$1,inst_12292);
} else
{if((state_val_12295 === (25)))
{var state_12294__$1 = state_12294;var statearr_12309_12351 = state_12294__$1;(statearr_12309_12351[(2)] = null);
(statearr_12309_12351[(1)] = (26));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12295 === (17)))
{var inst_12268 = (state_12294[(14)]);var state_12294__$1 = state_12294;var statearr_12310_12352 = state_12294__$1;(statearr_12310_12352[(2)] = inst_12268);
(statearr_12310_12352[(1)] = (19));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12295 === (3)))
{var inst_12228 = (state_12294[(9)]);var state_12294__$1 = state_12294;var statearr_12311_12353 = state_12294__$1;(statearr_12311_12353[(2)] = inst_12228);
(statearr_12311_12353[(1)] = (4));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12295 === (12)))
{var inst_12268 = (state_12294[(14)]);var inst_12254 = (state_12294[(15)]);var inst_12249 = (state_12294[(16)]);var inst_12268__$1 = inst_12249.call(null,inst_12254);var state_12294__$1 = (function (){var statearr_12312 = state_12294;(statearr_12312[(14)] = inst_12268__$1);
return statearr_12312;
})();if(cljs.core.truth_(inst_12268__$1))
{var statearr_12313_12354 = state_12294__$1;(statearr_12313_12354[(1)] = (17));
} else
{var statearr_12314_12355 = state_12294__$1;(statearr_12314_12355[(1)] = (18));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12295 === (2)))
{var inst_12228 = (state_12294[(9)]);var inst_12231 = cljs.core.apply.call(null,cljs.core.hash_map,inst_12228);var state_12294__$1 = state_12294;var statearr_12315_12356 = state_12294__$1;(statearr_12315_12356[(2)] = inst_12231);
(statearr_12315_12356[(1)] = (4));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12295 === (23)))
{var inst_12279 = (state_12294[(2)]);var state_12294__$1 = state_12294;if(cljs.core.truth_(inst_12279))
{var statearr_12316_12357 = state_12294__$1;(statearr_12316_12357[(1)] = (24));
} else
{var statearr_12317_12358 = state_12294__$1;(statearr_12317_12358[(1)] = (25));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12295 === (19)))
{var inst_12276 = (state_12294[(2)]);var state_12294__$1 = state_12294;if(cljs.core.truth_(inst_12276))
{var statearr_12318_12359 = state_12294__$1;(statearr_12318_12359[(1)] = (20));
} else
{var statearr_12319_12360 = state_12294__$1;(statearr_12319_12360[(1)] = (21));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12295 === (11)))
{var inst_12253 = (state_12294[(8)]);var inst_12259 = (inst_12253 == null);var state_12294__$1 = state_12294;if(cljs.core.truth_(inst_12259))
{var statearr_12320_12361 = state_12294__$1;(statearr_12320_12361[(1)] = (14));
} else
{var statearr_12321_12362 = state_12294__$1;(statearr_12321_12362[(1)] = (15));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12295 === (9)))
{var inst_12246 = (state_12294[(10)]);var inst_12246__$1 = (state_12294[(2)]);var inst_12247 = cljs.core.get.call(null,inst_12246__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));var inst_12248 = cljs.core.get.call(null,inst_12246__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));var inst_12249 = cljs.core.get.call(null,inst_12246__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));var state_12294__$1 = (function (){var statearr_12322 = state_12294;(statearr_12322[(10)] = inst_12246__$1);
(statearr_12322[(17)] = inst_12248);
(statearr_12322[(16)] = inst_12249);
return statearr_12322;
})();return cljs.core.async.ioc_alts_BANG_.call(null,state_12294__$1,(10),inst_12247);
} else
{if((state_val_12295 === (5)))
{var inst_12238 = (state_12294[(7)]);var inst_12241 = cljs.core.seq_QMARK_.call(null,inst_12238);var state_12294__$1 = state_12294;if(inst_12241)
{var statearr_12323_12363 = state_12294__$1;(statearr_12323_12363[(1)] = (7));
} else
{var statearr_12324_12364 = state_12294__$1;(statearr_12324_12364[(1)] = (8));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12295 === (14)))
{var inst_12254 = (state_12294[(15)]);var inst_12261 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_12254);var state_12294__$1 = state_12294;var statearr_12325_12365 = state_12294__$1;(statearr_12325_12365[(2)] = inst_12261);
(statearr_12325_12365[(1)] = (16));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12295 === (26)))
{var inst_12284 = (state_12294[(2)]);var state_12294__$1 = state_12294;var statearr_12326_12366 = state_12294__$1;(statearr_12326_12366[(2)] = inst_12284);
(statearr_12326_12366[(1)] = (22));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12295 === (16)))
{var inst_12264 = (state_12294[(2)]);var inst_12265 = calc_state.call(null);var inst_12238 = inst_12265;var state_12294__$1 = (function (){var statearr_12327 = state_12294;(statearr_12327[(18)] = inst_12264);
(statearr_12327[(7)] = inst_12238);
return statearr_12327;
})();var statearr_12328_12367 = state_12294__$1;(statearr_12328_12367[(2)] = null);
(statearr_12328_12367[(1)] = (5));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12295 === (10)))
{var inst_12253 = (state_12294[(8)]);var inst_12254 = (state_12294[(15)]);var inst_12252 = (state_12294[(2)]);var inst_12253__$1 = cljs.core.nth.call(null,inst_12252,(0),null);var inst_12254__$1 = cljs.core.nth.call(null,inst_12252,(1),null);var inst_12255 = (inst_12253__$1 == null);var inst_12256 = cljs.core._EQ_.call(null,inst_12254__$1,change);var inst_12257 = (inst_12255) || (inst_12256);var state_12294__$1 = (function (){var statearr_12329 = state_12294;(statearr_12329[(8)] = inst_12253__$1);
(statearr_12329[(15)] = inst_12254__$1);
return statearr_12329;
})();if(cljs.core.truth_(inst_12257))
{var statearr_12330_12368 = state_12294__$1;(statearr_12330_12368[(1)] = (11));
} else
{var statearr_12331_12369 = state_12294__$1;(statearr_12331_12369[(1)] = (12));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12295 === (18)))
{var inst_12248 = (state_12294[(17)]);var inst_12254 = (state_12294[(15)]);var inst_12249 = (state_12294[(16)]);var inst_12271 = cljs.core.empty_QMARK_.call(null,inst_12249);var inst_12272 = inst_12248.call(null,inst_12254);var inst_12273 = cljs.core.not.call(null,inst_12272);var inst_12274 = (inst_12271) && (inst_12273);var state_12294__$1 = state_12294;var statearr_12332_12370 = state_12294__$1;(statearr_12332_12370[(2)] = inst_12274);
(statearr_12332_12370[(1)] = (19));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12295 === (8)))
{var inst_12238 = (state_12294[(7)]);var state_12294__$1 = state_12294;var statearr_12333_12371 = state_12294__$1;(statearr_12333_12371[(2)] = inst_12238);
(statearr_12333_12371[(1)] = (9));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__5915__auto___12341,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;return ((function (switch__5900__auto__,c__5915__auto___12341,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_12337 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_12337[(0)] = state_machine__5901__auto__);
(statearr_12337[(1)] = (1));
return statearr_12337;
});
var state_machine__5901__auto____1 = (function (state_12294){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_12294);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e12338){if((e12338 instanceof Object))
{var ex__5904__auto__ = e12338;var statearr_12339_12372 = state_12294;(statearr_12339_12372[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12294);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e12338;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__12373 = state_12294;
state_12294 = G__12373;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_12294){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_12294);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto___12341,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();var state__5917__auto__ = (function (){var statearr_12340 = f__5916__auto__.call(null);(statearr_12340[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto___12341);
return statearr_12340;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto___12341,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);
return m;
});
/**
* Adds ch as an input to the mix
*/
cljs.core.async.admix = (function admix(mix,ch){return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
* Removes ch as an input to the mix
*/
cljs.core.async.unmix = (function unmix(mix,ch){return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
* removes all inputs from the mix
*/
cljs.core.async.unmix_all = (function unmix_all(mix){return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
* Atomically sets the state(s) of one or more channels in a mix. The
* state map is a map of channels -> channel-state-map. A
* channel-state-map is a map of attrs -> boolean, where attr is one or
* more of :mute, :pause or :solo. Any states supplied are merged with
* the current state.
* 
* Note that channels can be added to a mix via toggle, which can be
* used to add channels in a particular (e.g. paused) state.
*/
cljs.core.async.toggle = (function toggle(mix,state_map){return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
* Sets the solo mode of the mix. mode must be one of :mute or :pause
*/
cljs.core.async.solo_mode = (function solo_mode(mix,mode){return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});
cljs.core.async.Pub = (function (){var obj12375 = {};return obj12375;
})();
cljs.core.async.sub_STAR_ = (function sub_STAR_(p,v,ch,close_QMARK_){if((function (){var and__3636__auto__ = p;if(and__3636__auto__)
{return p.cljs$core$async$Pub$sub_STAR_$arity$4;
} else
{return and__3636__auto__;
}
})())
{return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else
{var x__4285__auto__ = (((p == null))?null:p);return (function (){var or__3648__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4285__auto__)]);if(or__3648__auto__)
{return or__3648__auto__;
} else
{var or__3648__auto____$1 = (cljs.core.async.sub_STAR_["_"]);if(or__3648__auto____$1)
{return or__3648__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
})().call(null,p,v,ch,close_QMARK_);
}
});
cljs.core.async.unsub_STAR_ = (function unsub_STAR_(p,v,ch){if((function (){var and__3636__auto__ = p;if(and__3636__auto__)
{return p.cljs$core$async$Pub$unsub_STAR_$arity$3;
} else
{return and__3636__auto__;
}
})())
{return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else
{var x__4285__auto__ = (((p == null))?null:p);return (function (){var or__3648__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4285__auto__)]);if(or__3648__auto__)
{return or__3648__auto__;
} else
{var or__3648__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);if(or__3648__auto____$1)
{return or__3648__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
})().call(null,p,v,ch);
}
});
cljs.core.async.unsub_all_STAR_ = (function() {
var unsub_all_STAR_ = null;
var unsub_all_STAR___1 = (function (p){if((function (){var and__3636__auto__ = p;if(and__3636__auto__)
{return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1;
} else
{return and__3636__auto__;
}
})())
{return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else
{var x__4285__auto__ = (((p == null))?null:p);return (function (){var or__3648__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4285__auto__)]);if(or__3648__auto__)
{return or__3648__auto__;
} else
{var or__3648__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);if(or__3648__auto____$1)
{return or__3648__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
})().call(null,p);
}
});
var unsub_all_STAR___2 = (function (p,v){if((function (){var and__3636__auto__ = p;if(and__3636__auto__)
{return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2;
} else
{return and__3636__auto__;
}
})())
{return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else
{var x__4285__auto__ = (((p == null))?null:p);return (function (){var or__3648__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4285__auto__)]);if(or__3648__auto__)
{return or__3648__auto__;
} else
{var or__3648__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);if(or__3648__auto____$1)
{return or__3648__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
})().call(null,p,v);
}
});
unsub_all_STAR_ = function(p,v){
switch(arguments.length){
case 1:
return unsub_all_STAR___1.call(this,p);
case 2:
return unsub_all_STAR___2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = unsub_all_STAR___1;
unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = unsub_all_STAR___2;
return unsub_all_STAR_;
})()
;
/**
* Creates and returns a pub(lication) of the supplied channel,
* partitioned into topics by the topic-fn. topic-fn will be applied to
* each value on the channel and the result will determine the 'topic'
* on which that value will be put. Channels can be subscribed to
* receive copies of topics using 'sub', and unsubscribed using
* 'unsub'. Each topic will be handled by an internal mult on a
* dedicated channel. By default these internal channels are
* unbuffered, but a buf-fn can be supplied which, given a topic,
* creates a buffer with desired properties.
* 
* Each item is distributed to all subs in parallel and synchronously,
* i.e. each sub must accept before the next item is distributed. Use
* buffering/windowing to prevent slow subs from holding up the pub.
* 
* Items received when there are no matching subs get dropped.
* 
* Note that if buf-fns are used then each topic is handled
* asynchronously, i.e. if a channel is subscribed to more than one
* topic it should not expect them to be interleaved identically with
* the source.
*/
cljs.core.async.pub = (function() {
var pub = null;
var pub__2 = (function (ch,topic_fn){return pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});
var pub__3 = (function (ch,topic_fn,buf_fn){var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);var ensure_mult = ((function (mults){
return (function (topic){var or__3648__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);if(cljs.core.truth_(or__3648__auto__))
{return or__3648__auto__;
} else
{return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__3648__auto__,mults){
return (function (p1__12376_SHARP_){if(cljs.core.truth_(p1__12376_SHARP_.call(null,topic)))
{return p1__12376_SHARP_;
} else
{return cljs.core.assoc.call(null,p1__12376_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__3648__auto__,mults))
),topic);
}
});})(mults))
;var p = (function (){if(typeof cljs.core.async.t12499 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t12499 = (function (ensure_mult,mults,buf_fn,topic_fn,ch,pub,meta12500){
this.ensure_mult = ensure_mult;
this.mults = mults;
this.buf_fn = buf_fn;
this.topic_fn = topic_fn;
this.ch = ch;
this.pub = pub;
this.meta12500 = meta12500;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t12499.cljs$lang$type = true;
cljs.core.async.t12499.cljs$lang$ctorStr = "cljs.core.async/t12499";
cljs.core.async.t12499.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__4225__auto__,writer__4226__auto__,opt__4227__auto__){return cljs.core._write.call(null,writer__4226__auto__,"cljs.core.async/t12499");
});})(mults,ensure_mult))
;
cljs.core.async.t12499.prototype.cljs$core$async$Pub$ = true;
cljs.core.async.t12499.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$2,close_QMARK_){var self__ = this;
var p__$1 = this;var m = self__.ensure_mult.call(null,topic);return cljs.core.async.tap.call(null,m,ch__$2,close_QMARK_);
});})(mults,ensure_mult))
;
cljs.core.async.t12499.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$2){var self__ = this;
var p__$1 = this;var temp__4126__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);if(cljs.core.truth_(temp__4126__auto__))
{var m = temp__4126__auto__;return cljs.core.async.untap.call(null,m,ch__$2);
} else
{return null;
}
});})(mults,ensure_mult))
;
cljs.core.async.t12499.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){var self__ = this;
var ___$1 = this;return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;
cljs.core.async.t12499.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){var self__ = this;
var ___$1 = this;return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;
cljs.core.async.t12499.prototype.cljs$core$async$Mux$ = true;
cljs.core.async.t12499.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){var self__ = this;
var ___$1 = this;return self__.ch;
});})(mults,ensure_mult))
;
cljs.core.async.t12499.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_12501){var self__ = this;
var _12501__$1 = this;return self__.meta12500;
});})(mults,ensure_mult))
;
cljs.core.async.t12499.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_12501,meta12500__$1){var self__ = this;
var _12501__$1 = this;return (new cljs.core.async.t12499(self__.ensure_mult,self__.mults,self__.buf_fn,self__.topic_fn,self__.ch,self__.pub,meta12500__$1));
});})(mults,ensure_mult))
;
cljs.core.async.__GT_t12499 = ((function (mults,ensure_mult){
return (function __GT_t12499(ensure_mult__$1,mults__$1,buf_fn__$1,topic_fn__$1,ch__$1,pub__$1,meta12500){return (new cljs.core.async.t12499(ensure_mult__$1,mults__$1,buf_fn__$1,topic_fn__$1,ch__$1,pub__$1,meta12500));
});})(mults,ensure_mult))
;
}
return (new cljs.core.async.t12499(ensure_mult,mults,buf_fn,topic_fn,ch,pub,null));
})();var c__5915__auto___12621 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto___12621,mults,ensure_mult,p){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto___12621,mults,ensure_mult,p){
return (function (state_12573){var state_val_12574 = (state_12573[(1)]);if((state_val_12574 === (7)))
{var inst_12569 = (state_12573[(2)]);var state_12573__$1 = state_12573;var statearr_12575_12622 = state_12573__$1;(statearr_12575_12622[(2)] = inst_12569);
(statearr_12575_12622[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12574 === (20)))
{var state_12573__$1 = state_12573;var statearr_12576_12623 = state_12573__$1;(statearr_12576_12623[(2)] = null);
(statearr_12576_12623[(1)] = (21));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12574 === (1)))
{var state_12573__$1 = state_12573;var statearr_12577_12624 = state_12573__$1;(statearr_12577_12624[(2)] = null);
(statearr_12577_12624[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12574 === (24)))
{var inst_12552 = (state_12573[(7)]);var inst_12561 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_12552);var state_12573__$1 = state_12573;var statearr_12578_12625 = state_12573__$1;(statearr_12578_12625[(2)] = inst_12561);
(statearr_12578_12625[(1)] = (25));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12574 === (4)))
{var inst_12504 = (state_12573[(8)]);var inst_12504__$1 = (state_12573[(2)]);var inst_12505 = (inst_12504__$1 == null);var state_12573__$1 = (function (){var statearr_12579 = state_12573;(statearr_12579[(8)] = inst_12504__$1);
return statearr_12579;
})();if(cljs.core.truth_(inst_12505))
{var statearr_12580_12626 = state_12573__$1;(statearr_12580_12626[(1)] = (5));
} else
{var statearr_12581_12627 = state_12573__$1;(statearr_12581_12627[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12574 === (15)))
{var inst_12546 = (state_12573[(2)]);var state_12573__$1 = state_12573;var statearr_12582_12628 = state_12573__$1;(statearr_12582_12628[(2)] = inst_12546);
(statearr_12582_12628[(1)] = (12));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12574 === (21)))
{var inst_12566 = (state_12573[(2)]);var state_12573__$1 = (function (){var statearr_12583 = state_12573;(statearr_12583[(9)] = inst_12566);
return statearr_12583;
})();var statearr_12584_12629 = state_12573__$1;(statearr_12584_12629[(2)] = null);
(statearr_12584_12629[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12574 === (13)))
{var inst_12528 = (state_12573[(10)]);var inst_12530 = cljs.core.chunked_seq_QMARK_.call(null,inst_12528);var state_12573__$1 = state_12573;if(inst_12530)
{var statearr_12585_12630 = state_12573__$1;(statearr_12585_12630[(1)] = (16));
} else
{var statearr_12586_12631 = state_12573__$1;(statearr_12586_12631[(1)] = (17));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12574 === (22)))
{var inst_12558 = (state_12573[(2)]);var state_12573__$1 = state_12573;if(cljs.core.truth_(inst_12558))
{var statearr_12587_12632 = state_12573__$1;(statearr_12587_12632[(1)] = (23));
} else
{var statearr_12588_12633 = state_12573__$1;(statearr_12588_12633[(1)] = (24));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12574 === (6)))
{var inst_12552 = (state_12573[(7)]);var inst_12554 = (state_12573[(11)]);var inst_12504 = (state_12573[(8)]);var inst_12552__$1 = topic_fn.call(null,inst_12504);var inst_12553 = cljs.core.deref.call(null,mults);var inst_12554__$1 = cljs.core.get.call(null,inst_12553,inst_12552__$1);var state_12573__$1 = (function (){var statearr_12589 = state_12573;(statearr_12589[(7)] = inst_12552__$1);
(statearr_12589[(11)] = inst_12554__$1);
return statearr_12589;
})();if(cljs.core.truth_(inst_12554__$1))
{var statearr_12590_12634 = state_12573__$1;(statearr_12590_12634[(1)] = (19));
} else
{var statearr_12591_12635 = state_12573__$1;(statearr_12591_12635[(1)] = (20));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12574 === (25)))
{var inst_12563 = (state_12573[(2)]);var state_12573__$1 = state_12573;var statearr_12592_12636 = state_12573__$1;(statearr_12592_12636[(2)] = inst_12563);
(statearr_12592_12636[(1)] = (21));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12574 === (17)))
{var inst_12528 = (state_12573[(10)]);var inst_12537 = cljs.core.first.call(null,inst_12528);var inst_12538 = cljs.core.async.muxch_STAR_.call(null,inst_12537);var inst_12539 = cljs.core.async.close_BANG_.call(null,inst_12538);var inst_12540 = cljs.core.next.call(null,inst_12528);var inst_12514 = inst_12540;var inst_12515 = null;var inst_12516 = (0);var inst_12517 = (0);var state_12573__$1 = (function (){var statearr_12593 = state_12573;(statearr_12593[(12)] = inst_12514);
(statearr_12593[(13)] = inst_12539);
(statearr_12593[(14)] = inst_12516);
(statearr_12593[(15)] = inst_12515);
(statearr_12593[(16)] = inst_12517);
return statearr_12593;
})();var statearr_12594_12637 = state_12573__$1;(statearr_12594_12637[(2)] = null);
(statearr_12594_12637[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12574 === (3)))
{var inst_12571 = (state_12573[(2)]);var state_12573__$1 = state_12573;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12573__$1,inst_12571);
} else
{if((state_val_12574 === (12)))
{var inst_12548 = (state_12573[(2)]);var state_12573__$1 = state_12573;var statearr_12595_12638 = state_12573__$1;(statearr_12595_12638[(2)] = inst_12548);
(statearr_12595_12638[(1)] = (9));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12574 === (2)))
{var state_12573__$1 = state_12573;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12573__$1,(4),ch);
} else
{if((state_val_12574 === (23)))
{var state_12573__$1 = state_12573;var statearr_12596_12639 = state_12573__$1;(statearr_12596_12639[(2)] = null);
(statearr_12596_12639[(1)] = (25));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12574 === (19)))
{var inst_12554 = (state_12573[(11)]);var inst_12504 = (state_12573[(8)]);var inst_12556 = cljs.core.async.muxch_STAR_.call(null,inst_12554);var state_12573__$1 = state_12573;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12573__$1,(22),inst_12556,inst_12504);
} else
{if((state_val_12574 === (11)))
{var inst_12514 = (state_12573[(12)]);var inst_12528 = (state_12573[(10)]);var inst_12528__$1 = cljs.core.seq.call(null,inst_12514);var state_12573__$1 = (function (){var statearr_12597 = state_12573;(statearr_12597[(10)] = inst_12528__$1);
return statearr_12597;
})();if(inst_12528__$1)
{var statearr_12598_12640 = state_12573__$1;(statearr_12598_12640[(1)] = (13));
} else
{var statearr_12599_12641 = state_12573__$1;(statearr_12599_12641[(1)] = (14));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12574 === (9)))
{var inst_12550 = (state_12573[(2)]);var state_12573__$1 = state_12573;var statearr_12600_12642 = state_12573__$1;(statearr_12600_12642[(2)] = inst_12550);
(statearr_12600_12642[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12574 === (5)))
{var inst_12511 = cljs.core.deref.call(null,mults);var inst_12512 = cljs.core.vals.call(null,inst_12511);var inst_12513 = cljs.core.seq.call(null,inst_12512);var inst_12514 = inst_12513;var inst_12515 = null;var inst_12516 = (0);var inst_12517 = (0);var state_12573__$1 = (function (){var statearr_12601 = state_12573;(statearr_12601[(12)] = inst_12514);
(statearr_12601[(14)] = inst_12516);
(statearr_12601[(15)] = inst_12515);
(statearr_12601[(16)] = inst_12517);
return statearr_12601;
})();var statearr_12602_12643 = state_12573__$1;(statearr_12602_12643[(2)] = null);
(statearr_12602_12643[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12574 === (14)))
{var state_12573__$1 = state_12573;var statearr_12606_12644 = state_12573__$1;(statearr_12606_12644[(2)] = null);
(statearr_12606_12644[(1)] = (15));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12574 === (16)))
{var inst_12528 = (state_12573[(10)]);var inst_12532 = cljs.core.chunk_first.call(null,inst_12528);var inst_12533 = cljs.core.chunk_rest.call(null,inst_12528);var inst_12534 = cljs.core.count.call(null,inst_12532);var inst_12514 = inst_12533;var inst_12515 = inst_12532;var inst_12516 = inst_12534;var inst_12517 = (0);var state_12573__$1 = (function (){var statearr_12607 = state_12573;(statearr_12607[(12)] = inst_12514);
(statearr_12607[(14)] = inst_12516);
(statearr_12607[(15)] = inst_12515);
(statearr_12607[(16)] = inst_12517);
return statearr_12607;
})();var statearr_12608_12645 = state_12573__$1;(statearr_12608_12645[(2)] = null);
(statearr_12608_12645[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12574 === (10)))
{var inst_12514 = (state_12573[(12)]);var inst_12516 = (state_12573[(14)]);var inst_12515 = (state_12573[(15)]);var inst_12517 = (state_12573[(16)]);var inst_12522 = cljs.core._nth.call(null,inst_12515,inst_12517);var inst_12523 = cljs.core.async.muxch_STAR_.call(null,inst_12522);var inst_12524 = cljs.core.async.close_BANG_.call(null,inst_12523);var inst_12525 = (inst_12517 + (1));var tmp12603 = inst_12514;var tmp12604 = inst_12516;var tmp12605 = inst_12515;var inst_12514__$1 = tmp12603;var inst_12515__$1 = tmp12605;var inst_12516__$1 = tmp12604;var inst_12517__$1 = inst_12525;var state_12573__$1 = (function (){var statearr_12609 = state_12573;(statearr_12609[(12)] = inst_12514__$1);
(statearr_12609[(14)] = inst_12516__$1);
(statearr_12609[(15)] = inst_12515__$1);
(statearr_12609[(17)] = inst_12524);
(statearr_12609[(16)] = inst_12517__$1);
return statearr_12609;
})();var statearr_12610_12646 = state_12573__$1;(statearr_12610_12646[(2)] = null);
(statearr_12610_12646[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12574 === (18)))
{var inst_12543 = (state_12573[(2)]);var state_12573__$1 = state_12573;var statearr_12611_12647 = state_12573__$1;(statearr_12611_12647[(2)] = inst_12543);
(statearr_12611_12647[(1)] = (15));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12574 === (8)))
{var inst_12516 = (state_12573[(14)]);var inst_12517 = (state_12573[(16)]);var inst_12519 = (inst_12517 < inst_12516);var inst_12520 = inst_12519;var state_12573__$1 = state_12573;if(cljs.core.truth_(inst_12520))
{var statearr_12612_12648 = state_12573__$1;(statearr_12612_12648[(1)] = (10));
} else
{var statearr_12613_12649 = state_12573__$1;(statearr_12613_12649[(1)] = (11));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__5915__auto___12621,mults,ensure_mult,p))
;return ((function (switch__5900__auto__,c__5915__auto___12621,mults,ensure_mult,p){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_12617 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_12617[(0)] = state_machine__5901__auto__);
(statearr_12617[(1)] = (1));
return statearr_12617;
});
var state_machine__5901__auto____1 = (function (state_12573){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_12573);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e12618){if((e12618 instanceof Object))
{var ex__5904__auto__ = e12618;var statearr_12619_12650 = state_12573;(statearr_12619_12650[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12573);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e12618;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__12651 = state_12573;
state_12573 = G__12651;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_12573){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_12573);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto___12621,mults,ensure_mult,p))
})();var state__5917__auto__ = (function (){var statearr_12620 = f__5916__auto__.call(null);(statearr_12620[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto___12621);
return statearr_12620;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto___12621,mults,ensure_mult,p))
);
return p;
});
pub = function(ch,topic_fn,buf_fn){
switch(arguments.length){
case 2:
return pub__2.call(this,ch,topic_fn);
case 3:
return pub__3.call(this,ch,topic_fn,buf_fn);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pub.cljs$core$IFn$_invoke$arity$2 = pub__2;
pub.cljs$core$IFn$_invoke$arity$3 = pub__3;
return pub;
})()
;
/**
* Subscribes a channel to a topic of a pub.
* 
* By default the channel will be closed when the source closes,
* but can be determined by the close? parameter.
*/
cljs.core.async.sub = (function() {
var sub = null;
var sub__3 = (function (p,topic,ch){return sub.call(null,p,topic,ch,true);
});
var sub__4 = (function (p,topic,ch,close_QMARK_){return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});
sub = function(p,topic,ch,close_QMARK_){
switch(arguments.length){
case 3:
return sub__3.call(this,p,topic,ch);
case 4:
return sub__4.call(this,p,topic,ch,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
sub.cljs$core$IFn$_invoke$arity$3 = sub__3;
sub.cljs$core$IFn$_invoke$arity$4 = sub__4;
return sub;
})()
;
/**
* Unsubscribes a channel from a topic of a pub
*/
cljs.core.async.unsub = (function unsub(p,topic,ch){return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
* Unsubscribes all channels from a pub, or a topic of a pub
*/
cljs.core.async.unsub_all = (function() {
var unsub_all = null;
var unsub_all__1 = (function (p){return cljs.core.async.unsub_all_STAR_.call(null,p);
});
var unsub_all__2 = (function (p,topic){return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});
unsub_all = function(p,topic){
switch(arguments.length){
case 1:
return unsub_all__1.call(this,p);
case 2:
return unsub_all__2.call(this,p,topic);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unsub_all.cljs$core$IFn$_invoke$arity$1 = unsub_all__1;
unsub_all.cljs$core$IFn$_invoke$arity$2 = unsub_all__2;
return unsub_all;
})()
;
/**
* Takes a function and a collection of source channels, and returns a
* channel which contains the values produced by applying f to the set
* of first items taken from each source channel, followed by applying
* f to the set of second items from each channel, until any one of the
* channels is closed, at which point the output channel will be
* closed. The returned channel will be unbuffered by default, or a
* buf-or-n can be supplied
*/
cljs.core.async.map = (function() {
var map = null;
var map__2 = (function (f,chs){return map.call(null,f,chs,null);
});
var map__3 = (function (f,chs,buf_or_n){var chs__$1 = cljs.core.vec.call(null,chs);var out = cljs.core.async.chan.call(null,buf_or_n);var cnt = cljs.core.count.call(null,chs__$1);var rets = cljs.core.object_array.call(null,cnt);var dchan = cljs.core.async.chan.call(null,(1));var dctr = cljs.core.atom.call(null,null);var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){(rets[i] = ret);
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0)))
{return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else
{return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));var c__5915__auto___12788 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto___12788,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto___12788,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_12758){var state_val_12759 = (state_12758[(1)]);if((state_val_12759 === (7)))
{var state_12758__$1 = state_12758;var statearr_12760_12789 = state_12758__$1;(statearr_12760_12789[(2)] = null);
(statearr_12760_12789[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12759 === (1)))
{var state_12758__$1 = state_12758;var statearr_12761_12790 = state_12758__$1;(statearr_12761_12790[(2)] = null);
(statearr_12761_12790[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12759 === (4)))
{var inst_12722 = (state_12758[(7)]);var inst_12724 = (inst_12722 < cnt);var state_12758__$1 = state_12758;if(cljs.core.truth_(inst_12724))
{var statearr_12762_12791 = state_12758__$1;(statearr_12762_12791[(1)] = (6));
} else
{var statearr_12763_12792 = state_12758__$1;(statearr_12763_12792[(1)] = (7));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12759 === (15)))
{var inst_12754 = (state_12758[(2)]);var state_12758__$1 = state_12758;var statearr_12764_12793 = state_12758__$1;(statearr_12764_12793[(2)] = inst_12754);
(statearr_12764_12793[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12759 === (13)))
{var inst_12747 = cljs.core.async.close_BANG_.call(null,out);var state_12758__$1 = state_12758;var statearr_12765_12794 = state_12758__$1;(statearr_12765_12794[(2)] = inst_12747);
(statearr_12765_12794[(1)] = (15));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12759 === (6)))
{var state_12758__$1 = state_12758;var statearr_12766_12795 = state_12758__$1;(statearr_12766_12795[(2)] = null);
(statearr_12766_12795[(1)] = (11));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12759 === (3)))
{var inst_12756 = (state_12758[(2)]);var state_12758__$1 = state_12758;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12758__$1,inst_12756);
} else
{if((state_val_12759 === (12)))
{var inst_12744 = (state_12758[(8)]);var inst_12744__$1 = (state_12758[(2)]);var inst_12745 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_12744__$1);var state_12758__$1 = (function (){var statearr_12767 = state_12758;(statearr_12767[(8)] = inst_12744__$1);
return statearr_12767;
})();if(cljs.core.truth_(inst_12745))
{var statearr_12768_12796 = state_12758__$1;(statearr_12768_12796[(1)] = (13));
} else
{var statearr_12769_12797 = state_12758__$1;(statearr_12769_12797[(1)] = (14));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12759 === (2)))
{var inst_12721 = cljs.core.reset_BANG_.call(null,dctr,cnt);var inst_12722 = (0);var state_12758__$1 = (function (){var statearr_12770 = state_12758;(statearr_12770[(7)] = inst_12722);
(statearr_12770[(9)] = inst_12721);
return statearr_12770;
})();var statearr_12771_12798 = state_12758__$1;(statearr_12771_12798[(2)] = null);
(statearr_12771_12798[(1)] = (4));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12759 === (11)))
{var inst_12722 = (state_12758[(7)]);var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_12758,(10),Object,null,(9));var inst_12731 = chs__$1.call(null,inst_12722);var inst_12732 = done.call(null,inst_12722);var inst_12733 = cljs.core.async.take_BANG_.call(null,inst_12731,inst_12732);var state_12758__$1 = state_12758;var statearr_12772_12799 = state_12758__$1;(statearr_12772_12799[(2)] = inst_12733);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12758__$1);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12759 === (9)))
{var inst_12722 = (state_12758[(7)]);var inst_12735 = (state_12758[(2)]);var inst_12736 = (inst_12722 + (1));var inst_12722__$1 = inst_12736;var state_12758__$1 = (function (){var statearr_12773 = state_12758;(statearr_12773[(7)] = inst_12722__$1);
(statearr_12773[(10)] = inst_12735);
return statearr_12773;
})();var statearr_12774_12800 = state_12758__$1;(statearr_12774_12800[(2)] = null);
(statearr_12774_12800[(1)] = (4));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12759 === (5)))
{var inst_12742 = (state_12758[(2)]);var state_12758__$1 = (function (){var statearr_12775 = state_12758;(statearr_12775[(11)] = inst_12742);
return statearr_12775;
})();return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12758__$1,(12),dchan);
} else
{if((state_val_12759 === (14)))
{var inst_12744 = (state_12758[(8)]);var inst_12749 = cljs.core.apply.call(null,f,inst_12744);var state_12758__$1 = state_12758;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12758__$1,(16),out,inst_12749);
} else
{if((state_val_12759 === (16)))
{var inst_12751 = (state_12758[(2)]);var state_12758__$1 = (function (){var statearr_12776 = state_12758;(statearr_12776[(12)] = inst_12751);
return statearr_12776;
})();var statearr_12777_12801 = state_12758__$1;(statearr_12777_12801[(2)] = null);
(statearr_12777_12801[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12759 === (10)))
{var inst_12726 = (state_12758[(2)]);var inst_12727 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);var state_12758__$1 = (function (){var statearr_12778 = state_12758;(statearr_12778[(13)] = inst_12726);
return statearr_12778;
})();var statearr_12779_12802 = state_12758__$1;(statearr_12779_12802[(2)] = inst_12727);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12758__$1);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12759 === (8)))
{var inst_12740 = (state_12758[(2)]);var state_12758__$1 = state_12758;var statearr_12780_12803 = state_12758__$1;(statearr_12780_12803[(2)] = inst_12740);
(statearr_12780_12803[(1)] = (5));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__5915__auto___12788,chs__$1,out,cnt,rets,dchan,dctr,done))
;return ((function (switch__5900__auto__,c__5915__auto___12788,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_12784 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_12784[(0)] = state_machine__5901__auto__);
(statearr_12784[(1)] = (1));
return statearr_12784;
});
var state_machine__5901__auto____1 = (function (state_12758){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_12758);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e12785){if((e12785 instanceof Object))
{var ex__5904__auto__ = e12785;var statearr_12786_12804 = state_12758;(statearr_12786_12804[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12758);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e12785;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__12805 = state_12758;
state_12758 = G__12805;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_12758){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_12758);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto___12788,chs__$1,out,cnt,rets,dchan,dctr,done))
})();var state__5917__auto__ = (function (){var statearr_12787 = f__5916__auto__.call(null);(statearr_12787[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto___12788);
return statearr_12787;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto___12788,chs__$1,out,cnt,rets,dchan,dctr,done))
);
return out;
});
map = function(f,chs,buf_or_n){
switch(arguments.length){
case 2:
return map__2.call(this,f,chs);
case 3:
return map__3.call(this,f,chs,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
map.cljs$core$IFn$_invoke$arity$2 = map__2;
map.cljs$core$IFn$_invoke$arity$3 = map__3;
return map;
})()
;
/**
* Takes a collection of source channels and returns a channel which
* contains all values taken from them. The returned channel will be
* unbuffered by default, or a buf-or-n can be supplied. The channel
* will close after all the source channels have closed.
*/
cljs.core.async.merge = (function() {
var merge = null;
var merge__1 = (function (chs){return merge.call(null,chs,null);
});
var merge__2 = (function (chs,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__5915__auto___12913 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto___12913,out){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto___12913,out){
return (function (state_12889){var state_val_12890 = (state_12889[(1)]);if((state_val_12890 === (7)))
{var inst_12868 = (state_12889[(7)]);var inst_12869 = (state_12889[(8)]);var inst_12868__$1 = (state_12889[(2)]);var inst_12869__$1 = cljs.core.nth.call(null,inst_12868__$1,(0),null);var inst_12870 = cljs.core.nth.call(null,inst_12868__$1,(1),null);var inst_12871 = (inst_12869__$1 == null);var state_12889__$1 = (function (){var statearr_12891 = state_12889;(statearr_12891[(9)] = inst_12870);
(statearr_12891[(7)] = inst_12868__$1);
(statearr_12891[(8)] = inst_12869__$1);
return statearr_12891;
})();if(cljs.core.truth_(inst_12871))
{var statearr_12892_12914 = state_12889__$1;(statearr_12892_12914[(1)] = (8));
} else
{var statearr_12893_12915 = state_12889__$1;(statearr_12893_12915[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12890 === (1)))
{var inst_12860 = cljs.core.vec.call(null,chs);var inst_12861 = inst_12860;var state_12889__$1 = (function (){var statearr_12894 = state_12889;(statearr_12894[(10)] = inst_12861);
return statearr_12894;
})();var statearr_12895_12916 = state_12889__$1;(statearr_12895_12916[(2)] = null);
(statearr_12895_12916[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12890 === (4)))
{var inst_12861 = (state_12889[(10)]);var state_12889__$1 = state_12889;return cljs.core.async.ioc_alts_BANG_.call(null,state_12889__$1,(7),inst_12861);
} else
{if((state_val_12890 === (6)))
{var inst_12885 = (state_12889[(2)]);var state_12889__$1 = state_12889;var statearr_12896_12917 = state_12889__$1;(statearr_12896_12917[(2)] = inst_12885);
(statearr_12896_12917[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12890 === (3)))
{var inst_12887 = (state_12889[(2)]);var state_12889__$1 = state_12889;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12889__$1,inst_12887);
} else
{if((state_val_12890 === (2)))
{var inst_12861 = (state_12889[(10)]);var inst_12863 = cljs.core.count.call(null,inst_12861);var inst_12864 = (inst_12863 > (0));var state_12889__$1 = state_12889;if(cljs.core.truth_(inst_12864))
{var statearr_12898_12918 = state_12889__$1;(statearr_12898_12918[(1)] = (4));
} else
{var statearr_12899_12919 = state_12889__$1;(statearr_12899_12919[(1)] = (5));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12890 === (11)))
{var inst_12861 = (state_12889[(10)]);var inst_12878 = (state_12889[(2)]);var tmp12897 = inst_12861;var inst_12861__$1 = tmp12897;var state_12889__$1 = (function (){var statearr_12900 = state_12889;(statearr_12900[(10)] = inst_12861__$1);
(statearr_12900[(11)] = inst_12878);
return statearr_12900;
})();var statearr_12901_12920 = state_12889__$1;(statearr_12901_12920[(2)] = null);
(statearr_12901_12920[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12890 === (9)))
{var inst_12869 = (state_12889[(8)]);var state_12889__$1 = state_12889;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12889__$1,(11),out,inst_12869);
} else
{if((state_val_12890 === (5)))
{var inst_12883 = cljs.core.async.close_BANG_.call(null,out);var state_12889__$1 = state_12889;var statearr_12902_12921 = state_12889__$1;(statearr_12902_12921[(2)] = inst_12883);
(statearr_12902_12921[(1)] = (6));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12890 === (10)))
{var inst_12881 = (state_12889[(2)]);var state_12889__$1 = state_12889;var statearr_12903_12922 = state_12889__$1;(statearr_12903_12922[(2)] = inst_12881);
(statearr_12903_12922[(1)] = (6));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12890 === (8)))
{var inst_12861 = (state_12889[(10)]);var inst_12870 = (state_12889[(9)]);var inst_12868 = (state_12889[(7)]);var inst_12869 = (state_12889[(8)]);var inst_12873 = (function (){var c = inst_12870;var v = inst_12869;var vec__12866 = inst_12868;var cs = inst_12861;return ((function (c,v,vec__12866,cs,inst_12861,inst_12870,inst_12868,inst_12869,state_val_12890,c__5915__auto___12913,out){
return (function (p1__12806_SHARP_){return cljs.core.not_EQ_.call(null,c,p1__12806_SHARP_);
});
;})(c,v,vec__12866,cs,inst_12861,inst_12870,inst_12868,inst_12869,state_val_12890,c__5915__auto___12913,out))
})();var inst_12874 = cljs.core.filterv.call(null,inst_12873,inst_12861);var inst_12861__$1 = inst_12874;var state_12889__$1 = (function (){var statearr_12904 = state_12889;(statearr_12904[(10)] = inst_12861__$1);
return statearr_12904;
})();var statearr_12905_12923 = state_12889__$1;(statearr_12905_12923[(2)] = null);
(statearr_12905_12923[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__5915__auto___12913,out))
;return ((function (switch__5900__auto__,c__5915__auto___12913,out){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_12909 = [null,null,null,null,null,null,null,null,null,null,null,null];(statearr_12909[(0)] = state_machine__5901__auto__);
(statearr_12909[(1)] = (1));
return statearr_12909;
});
var state_machine__5901__auto____1 = (function (state_12889){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_12889);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e12910){if((e12910 instanceof Object))
{var ex__5904__auto__ = e12910;var statearr_12911_12924 = state_12889;(statearr_12911_12924[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12889);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e12910;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__12925 = state_12889;
state_12889 = G__12925;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_12889){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_12889);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto___12913,out))
})();var state__5917__auto__ = (function (){var statearr_12912 = f__5916__auto__.call(null);(statearr_12912[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto___12913);
return statearr_12912;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto___12913,out))
);
return out;
});
merge = function(chs,buf_or_n){
switch(arguments.length){
case 1:
return merge__1.call(this,chs);
case 2:
return merge__2.call(this,chs,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
merge.cljs$core$IFn$_invoke$arity$1 = merge__1;
merge.cljs$core$IFn$_invoke$arity$2 = merge__2;
return merge;
})()
;
/**
* Returns a channel containing the single (collection) result of the
* items taken from the channel conjoined to the supplied
* collection. ch must close before into produces a result.
*/
cljs.core.async.into = (function into(coll,ch){return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
* Returns a channel that will return, at most, n items from ch. After n items
* have been returned, or ch has been closed, the return chanel will close.
* 
* The output channel is unbuffered by default, unless buf-or-n is given.
*/
cljs.core.async.take = (function() {
var take = null;
var take__2 = (function (n,ch){return take.call(null,n,ch,null);
});
var take__3 = (function (n,ch,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__5915__auto___13018 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto___13018,out){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto___13018,out){
return (function (state_12995){var state_val_12996 = (state_12995[(1)]);if((state_val_12996 === (7)))
{var inst_12977 = (state_12995[(7)]);var inst_12977__$1 = (state_12995[(2)]);var inst_12978 = (inst_12977__$1 == null);var inst_12979 = cljs.core.not.call(null,inst_12978);var state_12995__$1 = (function (){var statearr_12997 = state_12995;(statearr_12997[(7)] = inst_12977__$1);
return statearr_12997;
})();if(inst_12979)
{var statearr_12998_13019 = state_12995__$1;(statearr_12998_13019[(1)] = (8));
} else
{var statearr_12999_13020 = state_12995__$1;(statearr_12999_13020[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12996 === (1)))
{var inst_12972 = (0);var state_12995__$1 = (function (){var statearr_13000 = state_12995;(statearr_13000[(8)] = inst_12972);
return statearr_13000;
})();var statearr_13001_13021 = state_12995__$1;(statearr_13001_13021[(2)] = null);
(statearr_13001_13021[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12996 === (4)))
{var state_12995__$1 = state_12995;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12995__$1,(7),ch);
} else
{if((state_val_12996 === (6)))
{var inst_12990 = (state_12995[(2)]);var state_12995__$1 = state_12995;var statearr_13002_13022 = state_12995__$1;(statearr_13002_13022[(2)] = inst_12990);
(statearr_13002_13022[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12996 === (3)))
{var inst_12992 = (state_12995[(2)]);var inst_12993 = cljs.core.async.close_BANG_.call(null,out);var state_12995__$1 = (function (){var statearr_13003 = state_12995;(statearr_13003[(9)] = inst_12992);
return statearr_13003;
})();return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12995__$1,inst_12993);
} else
{if((state_val_12996 === (2)))
{var inst_12972 = (state_12995[(8)]);var inst_12974 = (inst_12972 < n);var state_12995__$1 = state_12995;if(cljs.core.truth_(inst_12974))
{var statearr_13004_13023 = state_12995__$1;(statearr_13004_13023[(1)] = (4));
} else
{var statearr_13005_13024 = state_12995__$1;(statearr_13005_13024[(1)] = (5));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12996 === (11)))
{var inst_12972 = (state_12995[(8)]);var inst_12982 = (state_12995[(2)]);var inst_12983 = (inst_12972 + (1));var inst_12972__$1 = inst_12983;var state_12995__$1 = (function (){var statearr_13006 = state_12995;(statearr_13006[(8)] = inst_12972__$1);
(statearr_13006[(10)] = inst_12982);
return statearr_13006;
})();var statearr_13007_13025 = state_12995__$1;(statearr_13007_13025[(2)] = null);
(statearr_13007_13025[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12996 === (9)))
{var state_12995__$1 = state_12995;var statearr_13008_13026 = state_12995__$1;(statearr_13008_13026[(2)] = null);
(statearr_13008_13026[(1)] = (10));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12996 === (5)))
{var state_12995__$1 = state_12995;var statearr_13009_13027 = state_12995__$1;(statearr_13009_13027[(2)] = null);
(statearr_13009_13027[(1)] = (6));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12996 === (10)))
{var inst_12987 = (state_12995[(2)]);var state_12995__$1 = state_12995;var statearr_13010_13028 = state_12995__$1;(statearr_13010_13028[(2)] = inst_12987);
(statearr_13010_13028[(1)] = (6));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12996 === (8)))
{var inst_12977 = (state_12995[(7)]);var state_12995__$1 = state_12995;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12995__$1,(11),out,inst_12977);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__5915__auto___13018,out))
;return ((function (switch__5900__auto__,c__5915__auto___13018,out){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_13014 = [null,null,null,null,null,null,null,null,null,null,null];(statearr_13014[(0)] = state_machine__5901__auto__);
(statearr_13014[(1)] = (1));
return statearr_13014;
});
var state_machine__5901__auto____1 = (function (state_12995){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_12995);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e13015){if((e13015 instanceof Object))
{var ex__5904__auto__ = e13015;var statearr_13016_13029 = state_12995;(statearr_13016_13029[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12995);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e13015;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__13030 = state_12995;
state_12995 = G__13030;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_12995){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_12995);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto___13018,out))
})();var state__5917__auto__ = (function (){var statearr_13017 = f__5916__auto__.call(null);(statearr_13017[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto___13018);
return statearr_13017;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto___13018,out))
);
return out;
});
take = function(n,ch,buf_or_n){
switch(arguments.length){
case 2:
return take__2.call(this,n,ch);
case 3:
return take__3.call(this,n,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
take.cljs$core$IFn$_invoke$arity$2 = take__2;
take.cljs$core$IFn$_invoke$arity$3 = take__3;
return take;
})()
;
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.map_LT_ = (function map_LT_(f,ch){if(typeof cljs.core.async.t13038 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t13038 = (function (ch,f,map_LT_,meta13039){
this.ch = ch;
this.f = f;
this.map_LT_ = map_LT_;
this.meta13039 = meta13039;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t13038.cljs$lang$type = true;
cljs.core.async.t13038.cljs$lang$ctorStr = "cljs.core.async/t13038";
cljs.core.async.t13038.cljs$lang$ctorPrWriter = (function (this__4225__auto__,writer__4226__auto__,opt__4227__auto__){return cljs.core._write.call(null,writer__4226__auto__,"cljs.core.async/t13038");
});
cljs.core.async.t13038.prototype.cljs$core$async$impl$protocols$WritePort$ = true;
cljs.core.async.t13038.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});
cljs.core.async.t13038.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;
cljs.core.async.t13038.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){var self__ = this;
var ___$1 = this;var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){if(typeof cljs.core.async.t13041 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t13041 = (function (fn1,_,meta13039,ch,f,map_LT_,meta13042){
this.fn1 = fn1;
this._ = _;
this.meta13039 = meta13039;
this.ch = ch;
this.f = f;
this.map_LT_ = map_LT_;
this.meta13042 = meta13042;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t13041.cljs$lang$type = true;
cljs.core.async.t13041.cljs$lang$ctorStr = "cljs.core.async/t13041";
cljs.core.async.t13041.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__4225__auto__,writer__4226__auto__,opt__4227__auto__){return cljs.core._write.call(null,writer__4226__auto__,"cljs.core.async/t13041");
});})(___$1))
;
cljs.core.async.t13041.prototype.cljs$core$async$impl$protocols$Handler$ = true;
cljs.core.async.t13041.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$3){var self__ = this;
var ___$4 = this;return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;
cljs.core.async.t13041.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$3){var self__ = this;
var ___$4 = this;var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);return ((function (f1,___$4,___$1){
return (function (p1__13031_SHARP_){return f1.call(null,(((p1__13031_SHARP_ == null))?null:self__.f.call(null,p1__13031_SHARP_)));
});
;})(f1,___$4,___$1))
});})(___$1))
;
cljs.core.async.t13041.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_13043){var self__ = this;
var _13043__$1 = this;return self__.meta13042;
});})(___$1))
;
cljs.core.async.t13041.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_13043,meta13042__$1){var self__ = this;
var _13043__$1 = this;return (new cljs.core.async.t13041(self__.fn1,self__._,self__.meta13039,self__.ch,self__.f,self__.map_LT_,meta13042__$1));
});})(___$1))
;
cljs.core.async.__GT_t13041 = ((function (___$1){
return (function __GT_t13041(fn1__$1,___$2,meta13039__$1,ch__$2,f__$2,map_LT___$2,meta13042){return (new cljs.core.async.t13041(fn1__$1,___$2,meta13039__$1,ch__$2,f__$2,map_LT___$2,meta13042));
});})(___$1))
;
}
return (new cljs.core.async.t13041(fn1,___$1,self__.meta13039,self__.ch,self__.f,self__.map_LT_,null));
})());if(cljs.core.truth_((function (){var and__3636__auto__ = ret;if(cljs.core.truth_(and__3636__auto__))
{return !((cljs.core.deref.call(null,ret) == null));
} else
{return and__3636__auto__;
}
})()))
{return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else
{return ret;
}
});
cljs.core.async.t13038.prototype.cljs$core$async$impl$protocols$Channel$ = true;
cljs.core.async.t13038.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});
cljs.core.async.t13038.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});
cljs.core.async.t13038.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13040){var self__ = this;
var _13040__$1 = this;return self__.meta13039;
});
cljs.core.async.t13038.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13040,meta13039__$1){var self__ = this;
var _13040__$1 = this;return (new cljs.core.async.t13038(self__.ch,self__.f,self__.map_LT_,meta13039__$1));
});
cljs.core.async.__GT_t13038 = (function __GT_t13038(ch__$1,f__$1,map_LT___$1,meta13039){return (new cljs.core.async.t13038(ch__$1,f__$1,map_LT___$1,meta13039));
});
}
return (new cljs.core.async.t13038(ch,f,map_LT_,null));
});
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.map_GT_ = (function map_GT_(f,ch){if(typeof cljs.core.async.t13047 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t13047 = (function (ch,f,map_GT_,meta13048){
this.ch = ch;
this.f = f;
this.map_GT_ = map_GT_;
this.meta13048 = meta13048;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t13047.cljs$lang$type = true;
cljs.core.async.t13047.cljs$lang$ctorStr = "cljs.core.async/t13047";
cljs.core.async.t13047.cljs$lang$ctorPrWriter = (function (this__4225__auto__,writer__4226__auto__,opt__4227__auto__){return cljs.core._write.call(null,writer__4226__auto__,"cljs.core.async/t13047");
});
cljs.core.async.t13047.prototype.cljs$core$async$impl$protocols$WritePort$ = true;
cljs.core.async.t13047.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});
cljs.core.async.t13047.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;
cljs.core.async.t13047.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});
cljs.core.async.t13047.prototype.cljs$core$async$impl$protocols$Channel$ = true;
cljs.core.async.t13047.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});
cljs.core.async.t13047.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13049){var self__ = this;
var _13049__$1 = this;return self__.meta13048;
});
cljs.core.async.t13047.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13049,meta13048__$1){var self__ = this;
var _13049__$1 = this;return (new cljs.core.async.t13047(self__.ch,self__.f,self__.map_GT_,meta13048__$1));
});
cljs.core.async.__GT_t13047 = (function __GT_t13047(ch__$1,f__$1,map_GT___$1,meta13048){return (new cljs.core.async.t13047(ch__$1,f__$1,map_GT___$1,meta13048));
});
}
return (new cljs.core.async.t13047(ch,f,map_GT_,null));
});
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.filter_GT_ = (function filter_GT_(p,ch){if(typeof cljs.core.async.t13053 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t13053 = (function (ch,p,filter_GT_,meta13054){
this.ch = ch;
this.p = p;
this.filter_GT_ = filter_GT_;
this.meta13054 = meta13054;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t13053.cljs$lang$type = true;
cljs.core.async.t13053.cljs$lang$ctorStr = "cljs.core.async/t13053";
cljs.core.async.t13053.cljs$lang$ctorPrWriter = (function (this__4225__auto__,writer__4226__auto__,opt__4227__auto__){return cljs.core._write.call(null,writer__4226__auto__,"cljs.core.async/t13053");
});
cljs.core.async.t13053.prototype.cljs$core$async$impl$protocols$WritePort$ = true;
cljs.core.async.t13053.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){var self__ = this;
var ___$1 = this;if(cljs.core.truth_(self__.p.call(null,val)))
{return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else
{return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});
cljs.core.async.t13053.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;
cljs.core.async.t13053.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});
cljs.core.async.t13053.prototype.cljs$core$async$impl$protocols$Channel$ = true;
cljs.core.async.t13053.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});
cljs.core.async.t13053.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});
cljs.core.async.t13053.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13055){var self__ = this;
var _13055__$1 = this;return self__.meta13054;
});
cljs.core.async.t13053.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13055,meta13054__$1){var self__ = this;
var _13055__$1 = this;return (new cljs.core.async.t13053(self__.ch,self__.p,self__.filter_GT_,meta13054__$1));
});
cljs.core.async.__GT_t13053 = (function __GT_t13053(ch__$1,p__$1,filter_GT___$1,meta13054){return (new cljs.core.async.t13053(ch__$1,p__$1,filter_GT___$1,meta13054));
});
}
return (new cljs.core.async.t13053(ch,p,filter_GT_,null));
});
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.remove_GT_ = (function remove_GT_(p,ch){return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.filter_LT_ = (function() {
var filter_LT_ = null;
var filter_LT___2 = (function (p,ch){return filter_LT_.call(null,p,ch,null);
});
var filter_LT___3 = (function (p,ch,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__5915__auto___13138 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto___13138,out){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto___13138,out){
return (function (state_13117){var state_val_13118 = (state_13117[(1)]);if((state_val_13118 === (7)))
{var inst_13113 = (state_13117[(2)]);var state_13117__$1 = state_13117;var statearr_13119_13139 = state_13117__$1;(statearr_13119_13139[(2)] = inst_13113);
(statearr_13119_13139[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13118 === (1)))
{var state_13117__$1 = state_13117;var statearr_13120_13140 = state_13117__$1;(statearr_13120_13140[(2)] = null);
(statearr_13120_13140[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13118 === (4)))
{var inst_13099 = (state_13117[(7)]);var inst_13099__$1 = (state_13117[(2)]);var inst_13100 = (inst_13099__$1 == null);var state_13117__$1 = (function (){var statearr_13121 = state_13117;(statearr_13121[(7)] = inst_13099__$1);
return statearr_13121;
})();if(cljs.core.truth_(inst_13100))
{var statearr_13122_13141 = state_13117__$1;(statearr_13122_13141[(1)] = (5));
} else
{var statearr_13123_13142 = state_13117__$1;(statearr_13123_13142[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13118 === (6)))
{var inst_13099 = (state_13117[(7)]);var inst_13104 = p.call(null,inst_13099);var state_13117__$1 = state_13117;if(cljs.core.truth_(inst_13104))
{var statearr_13124_13143 = state_13117__$1;(statearr_13124_13143[(1)] = (8));
} else
{var statearr_13125_13144 = state_13117__$1;(statearr_13125_13144[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13118 === (3)))
{var inst_13115 = (state_13117[(2)]);var state_13117__$1 = state_13117;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13117__$1,inst_13115);
} else
{if((state_val_13118 === (2)))
{var state_13117__$1 = state_13117;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13117__$1,(4),ch);
} else
{if((state_val_13118 === (11)))
{var inst_13107 = (state_13117[(2)]);var state_13117__$1 = state_13117;var statearr_13126_13145 = state_13117__$1;(statearr_13126_13145[(2)] = inst_13107);
(statearr_13126_13145[(1)] = (10));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13118 === (9)))
{var state_13117__$1 = state_13117;var statearr_13127_13146 = state_13117__$1;(statearr_13127_13146[(2)] = null);
(statearr_13127_13146[(1)] = (10));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13118 === (5)))
{var inst_13102 = cljs.core.async.close_BANG_.call(null,out);var state_13117__$1 = state_13117;var statearr_13128_13147 = state_13117__$1;(statearr_13128_13147[(2)] = inst_13102);
(statearr_13128_13147[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13118 === (10)))
{var inst_13110 = (state_13117[(2)]);var state_13117__$1 = (function (){var statearr_13129 = state_13117;(statearr_13129[(8)] = inst_13110);
return statearr_13129;
})();var statearr_13130_13148 = state_13117__$1;(statearr_13130_13148[(2)] = null);
(statearr_13130_13148[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13118 === (8)))
{var inst_13099 = (state_13117[(7)]);var state_13117__$1 = state_13117;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13117__$1,(11),out,inst_13099);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__5915__auto___13138,out))
;return ((function (switch__5900__auto__,c__5915__auto___13138,out){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_13134 = [null,null,null,null,null,null,null,null,null];(statearr_13134[(0)] = state_machine__5901__auto__);
(statearr_13134[(1)] = (1));
return statearr_13134;
});
var state_machine__5901__auto____1 = (function (state_13117){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_13117);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e13135){if((e13135 instanceof Object))
{var ex__5904__auto__ = e13135;var statearr_13136_13149 = state_13117;(statearr_13136_13149[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13117);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e13135;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__13150 = state_13117;
state_13117 = G__13150;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_13117){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_13117);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto___13138,out))
})();var state__5917__auto__ = (function (){var statearr_13137 = f__5916__auto__.call(null);(statearr_13137[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto___13138);
return statearr_13137;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto___13138,out))
);
return out;
});
filter_LT_ = function(p,ch,buf_or_n){
switch(arguments.length){
case 2:
return filter_LT___2.call(this,p,ch);
case 3:
return filter_LT___3.call(this,p,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
filter_LT_.cljs$core$IFn$_invoke$arity$2 = filter_LT___2;
filter_LT_.cljs$core$IFn$_invoke$arity$3 = filter_LT___3;
return filter_LT_;
})()
;
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.remove_LT_ = (function() {
var remove_LT_ = null;
var remove_LT___2 = (function (p,ch){return remove_LT_.call(null,p,ch,null);
});
var remove_LT___3 = (function (p,ch,buf_or_n){return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});
remove_LT_ = function(p,ch,buf_or_n){
switch(arguments.length){
case 2:
return remove_LT___2.call(this,p,ch);
case 3:
return remove_LT___3.call(this,p,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
remove_LT_.cljs$core$IFn$_invoke$arity$2 = remove_LT___2;
remove_LT_.cljs$core$IFn$_invoke$arity$3 = remove_LT___3;
return remove_LT_;
})()
;
cljs.core.async.mapcat_STAR_ = (function mapcat_STAR_(f,in$,out){var c__5915__auto__ = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto__){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto__){
return (function (state_13316){var state_val_13317 = (state_13316[(1)]);if((state_val_13317 === (7)))
{var inst_13312 = (state_13316[(2)]);var state_13316__$1 = state_13316;var statearr_13318_13359 = state_13316__$1;(statearr_13318_13359[(2)] = inst_13312);
(statearr_13318_13359[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13317 === (20)))
{var inst_13282 = (state_13316[(7)]);var inst_13293 = (state_13316[(2)]);var inst_13294 = cljs.core.next.call(null,inst_13282);var inst_13268 = inst_13294;var inst_13269 = null;var inst_13270 = (0);var inst_13271 = (0);var state_13316__$1 = (function (){var statearr_13319 = state_13316;(statearr_13319[(8)] = inst_13293);
(statearr_13319[(9)] = inst_13270);
(statearr_13319[(10)] = inst_13271);
(statearr_13319[(11)] = inst_13269);
(statearr_13319[(12)] = inst_13268);
return statearr_13319;
})();var statearr_13320_13360 = state_13316__$1;(statearr_13320_13360[(2)] = null);
(statearr_13320_13360[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13317 === (1)))
{var state_13316__$1 = state_13316;var statearr_13321_13361 = state_13316__$1;(statearr_13321_13361[(2)] = null);
(statearr_13321_13361[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13317 === (4)))
{var inst_13257 = (state_13316[(13)]);var inst_13257__$1 = (state_13316[(2)]);var inst_13258 = (inst_13257__$1 == null);var state_13316__$1 = (function (){var statearr_13322 = state_13316;(statearr_13322[(13)] = inst_13257__$1);
return statearr_13322;
})();if(cljs.core.truth_(inst_13258))
{var statearr_13323_13362 = state_13316__$1;(statearr_13323_13362[(1)] = (5));
} else
{var statearr_13324_13363 = state_13316__$1;(statearr_13324_13363[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13317 === (15)))
{var state_13316__$1 = state_13316;var statearr_13328_13364 = state_13316__$1;(statearr_13328_13364[(2)] = null);
(statearr_13328_13364[(1)] = (16));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13317 === (21)))
{var state_13316__$1 = state_13316;var statearr_13329_13365 = state_13316__$1;(statearr_13329_13365[(2)] = null);
(statearr_13329_13365[(1)] = (23));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13317 === (13)))
{var inst_13270 = (state_13316[(9)]);var inst_13271 = (state_13316[(10)]);var inst_13269 = (state_13316[(11)]);var inst_13268 = (state_13316[(12)]);var inst_13278 = (state_13316[(2)]);var inst_13279 = (inst_13271 + (1));var tmp13325 = inst_13270;var tmp13326 = inst_13269;var tmp13327 = inst_13268;var inst_13268__$1 = tmp13327;var inst_13269__$1 = tmp13326;var inst_13270__$1 = tmp13325;var inst_13271__$1 = inst_13279;var state_13316__$1 = (function (){var statearr_13330 = state_13316;(statearr_13330[(9)] = inst_13270__$1);
(statearr_13330[(10)] = inst_13271__$1);
(statearr_13330[(14)] = inst_13278);
(statearr_13330[(11)] = inst_13269__$1);
(statearr_13330[(12)] = inst_13268__$1);
return statearr_13330;
})();var statearr_13331_13366 = state_13316__$1;(statearr_13331_13366[(2)] = null);
(statearr_13331_13366[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13317 === (22)))
{var state_13316__$1 = state_13316;var statearr_13332_13367 = state_13316__$1;(statearr_13332_13367[(2)] = null);
(statearr_13332_13367[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13317 === (6)))
{var inst_13257 = (state_13316[(13)]);var inst_13266 = f.call(null,inst_13257);var inst_13267 = cljs.core.seq.call(null,inst_13266);var inst_13268 = inst_13267;var inst_13269 = null;var inst_13270 = (0);var inst_13271 = (0);var state_13316__$1 = (function (){var statearr_13333 = state_13316;(statearr_13333[(9)] = inst_13270);
(statearr_13333[(10)] = inst_13271);
(statearr_13333[(11)] = inst_13269);
(statearr_13333[(12)] = inst_13268);
return statearr_13333;
})();var statearr_13334_13368 = state_13316__$1;(statearr_13334_13368[(2)] = null);
(statearr_13334_13368[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13317 === (17)))
{var inst_13282 = (state_13316[(7)]);var inst_13286 = cljs.core.chunk_first.call(null,inst_13282);var inst_13287 = cljs.core.chunk_rest.call(null,inst_13282);var inst_13288 = cljs.core.count.call(null,inst_13286);var inst_13268 = inst_13287;var inst_13269 = inst_13286;var inst_13270 = inst_13288;var inst_13271 = (0);var state_13316__$1 = (function (){var statearr_13335 = state_13316;(statearr_13335[(9)] = inst_13270);
(statearr_13335[(10)] = inst_13271);
(statearr_13335[(11)] = inst_13269);
(statearr_13335[(12)] = inst_13268);
return statearr_13335;
})();var statearr_13336_13369 = state_13316__$1;(statearr_13336_13369[(2)] = null);
(statearr_13336_13369[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13317 === (3)))
{var inst_13314 = (state_13316[(2)]);var state_13316__$1 = state_13316;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13316__$1,inst_13314);
} else
{if((state_val_13317 === (12)))
{var inst_13302 = (state_13316[(2)]);var state_13316__$1 = state_13316;var statearr_13337_13370 = state_13316__$1;(statearr_13337_13370[(2)] = inst_13302);
(statearr_13337_13370[(1)] = (9));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13317 === (2)))
{var state_13316__$1 = state_13316;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13316__$1,(4),in$);
} else
{if((state_val_13317 === (23)))
{var inst_13310 = (state_13316[(2)]);var state_13316__$1 = state_13316;var statearr_13338_13371 = state_13316__$1;(statearr_13338_13371[(2)] = inst_13310);
(statearr_13338_13371[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13317 === (19)))
{var inst_13297 = (state_13316[(2)]);var state_13316__$1 = state_13316;var statearr_13339_13372 = state_13316__$1;(statearr_13339_13372[(2)] = inst_13297);
(statearr_13339_13372[(1)] = (16));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13317 === (11)))
{var inst_13282 = (state_13316[(7)]);var inst_13268 = (state_13316[(12)]);var inst_13282__$1 = cljs.core.seq.call(null,inst_13268);var state_13316__$1 = (function (){var statearr_13340 = state_13316;(statearr_13340[(7)] = inst_13282__$1);
return statearr_13340;
})();if(inst_13282__$1)
{var statearr_13341_13373 = state_13316__$1;(statearr_13341_13373[(1)] = (14));
} else
{var statearr_13342_13374 = state_13316__$1;(statearr_13342_13374[(1)] = (15));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13317 === (9)))
{var inst_13304 = (state_13316[(2)]);var inst_13305 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);var state_13316__$1 = (function (){var statearr_13343 = state_13316;(statearr_13343[(15)] = inst_13304);
return statearr_13343;
})();if(cljs.core.truth_(inst_13305))
{var statearr_13344_13375 = state_13316__$1;(statearr_13344_13375[(1)] = (21));
} else
{var statearr_13345_13376 = state_13316__$1;(statearr_13345_13376[(1)] = (22));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13317 === (5)))
{var inst_13260 = cljs.core.async.close_BANG_.call(null,out);var state_13316__$1 = state_13316;var statearr_13346_13377 = state_13316__$1;(statearr_13346_13377[(2)] = inst_13260);
(statearr_13346_13377[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13317 === (14)))
{var inst_13282 = (state_13316[(7)]);var inst_13284 = cljs.core.chunked_seq_QMARK_.call(null,inst_13282);var state_13316__$1 = state_13316;if(inst_13284)
{var statearr_13347_13378 = state_13316__$1;(statearr_13347_13378[(1)] = (17));
} else
{var statearr_13348_13379 = state_13316__$1;(statearr_13348_13379[(1)] = (18));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13317 === (16)))
{var inst_13300 = (state_13316[(2)]);var state_13316__$1 = state_13316;var statearr_13349_13380 = state_13316__$1;(statearr_13349_13380[(2)] = inst_13300);
(statearr_13349_13380[(1)] = (12));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13317 === (10)))
{var inst_13271 = (state_13316[(10)]);var inst_13269 = (state_13316[(11)]);var inst_13276 = cljs.core._nth.call(null,inst_13269,inst_13271);var state_13316__$1 = state_13316;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13316__$1,(13),out,inst_13276);
} else
{if((state_val_13317 === (18)))
{var inst_13282 = (state_13316[(7)]);var inst_13291 = cljs.core.first.call(null,inst_13282);var state_13316__$1 = state_13316;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13316__$1,(20),out,inst_13291);
} else
{if((state_val_13317 === (8)))
{var inst_13270 = (state_13316[(9)]);var inst_13271 = (state_13316[(10)]);var inst_13273 = (inst_13271 < inst_13270);var inst_13274 = inst_13273;var state_13316__$1 = state_13316;if(cljs.core.truth_(inst_13274))
{var statearr_13350_13381 = state_13316__$1;(statearr_13350_13381[(1)] = (10));
} else
{var statearr_13351_13382 = state_13316__$1;(statearr_13351_13382[(1)] = (11));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__5915__auto__))
;return ((function (switch__5900__auto__,c__5915__auto__){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_13355 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_13355[(0)] = state_machine__5901__auto__);
(statearr_13355[(1)] = (1));
return statearr_13355;
});
var state_machine__5901__auto____1 = (function (state_13316){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_13316);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e13356){if((e13356 instanceof Object))
{var ex__5904__auto__ = e13356;var statearr_13357_13383 = state_13316;(statearr_13357_13383[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13316);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e13356;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__13384 = state_13316;
state_13316 = G__13384;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_13316){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_13316);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto__))
})();var state__5917__auto__ = (function (){var statearr_13358 = f__5916__auto__.call(null);(statearr_13358[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto__);
return statearr_13358;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto__))
);
return c__5915__auto__;
});
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.mapcat_LT_ = (function() {
var mapcat_LT_ = null;
var mapcat_LT___2 = (function (f,in$){return mapcat_LT_.call(null,f,in$,null);
});
var mapcat_LT___3 = (function (f,in$,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);cljs.core.async.mapcat_STAR_.call(null,f,in$,out);
return out;
});
mapcat_LT_ = function(f,in$,buf_or_n){
switch(arguments.length){
case 2:
return mapcat_LT___2.call(this,f,in$);
case 3:
return mapcat_LT___3.call(this,f,in$,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = mapcat_LT___2;
mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = mapcat_LT___3;
return mapcat_LT_;
})()
;
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.mapcat_GT_ = (function() {
var mapcat_GT_ = null;
var mapcat_GT___2 = (function (f,out){return mapcat_GT_.call(null,f,out,null);
});
var mapcat_GT___3 = (function (f,out,buf_or_n){var in$ = cljs.core.async.chan.call(null,buf_or_n);cljs.core.async.mapcat_STAR_.call(null,f,in$,out);
return in$;
});
mapcat_GT_ = function(f,out,buf_or_n){
switch(arguments.length){
case 2:
return mapcat_GT___2.call(this,f,out);
case 3:
return mapcat_GT___3.call(this,f,out,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = mapcat_GT___2;
mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = mapcat_GT___3;
return mapcat_GT_;
})()
;
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.unique = (function() {
var unique = null;
var unique__1 = (function (ch){return unique.call(null,ch,null);
});
var unique__2 = (function (ch,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__5915__auto___13481 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto___13481,out){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto___13481,out){
return (function (state_13456){var state_val_13457 = (state_13456[(1)]);if((state_val_13457 === (7)))
{var inst_13451 = (state_13456[(2)]);var state_13456__$1 = state_13456;var statearr_13458_13482 = state_13456__$1;(statearr_13458_13482[(2)] = inst_13451);
(statearr_13458_13482[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13457 === (1)))
{var inst_13433 = null;var state_13456__$1 = (function (){var statearr_13459 = state_13456;(statearr_13459[(7)] = inst_13433);
return statearr_13459;
})();var statearr_13460_13483 = state_13456__$1;(statearr_13460_13483[(2)] = null);
(statearr_13460_13483[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13457 === (4)))
{var inst_13436 = (state_13456[(8)]);var inst_13436__$1 = (state_13456[(2)]);var inst_13437 = (inst_13436__$1 == null);var inst_13438 = cljs.core.not.call(null,inst_13437);var state_13456__$1 = (function (){var statearr_13461 = state_13456;(statearr_13461[(8)] = inst_13436__$1);
return statearr_13461;
})();if(inst_13438)
{var statearr_13462_13484 = state_13456__$1;(statearr_13462_13484[(1)] = (5));
} else
{var statearr_13463_13485 = state_13456__$1;(statearr_13463_13485[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13457 === (6)))
{var state_13456__$1 = state_13456;var statearr_13464_13486 = state_13456__$1;(statearr_13464_13486[(2)] = null);
(statearr_13464_13486[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13457 === (3)))
{var inst_13453 = (state_13456[(2)]);var inst_13454 = cljs.core.async.close_BANG_.call(null,out);var state_13456__$1 = (function (){var statearr_13465 = state_13456;(statearr_13465[(9)] = inst_13453);
return statearr_13465;
})();return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13456__$1,inst_13454);
} else
{if((state_val_13457 === (2)))
{var state_13456__$1 = state_13456;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13456__$1,(4),ch);
} else
{if((state_val_13457 === (11)))
{var inst_13436 = (state_13456[(8)]);var inst_13445 = (state_13456[(2)]);var inst_13433 = inst_13436;var state_13456__$1 = (function (){var statearr_13466 = state_13456;(statearr_13466[(10)] = inst_13445);
(statearr_13466[(7)] = inst_13433);
return statearr_13466;
})();var statearr_13467_13487 = state_13456__$1;(statearr_13467_13487[(2)] = null);
(statearr_13467_13487[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13457 === (9)))
{var inst_13436 = (state_13456[(8)]);var state_13456__$1 = state_13456;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13456__$1,(11),out,inst_13436);
} else
{if((state_val_13457 === (5)))
{var inst_13436 = (state_13456[(8)]);var inst_13433 = (state_13456[(7)]);var inst_13440 = cljs.core._EQ_.call(null,inst_13436,inst_13433);var state_13456__$1 = state_13456;if(inst_13440)
{var statearr_13469_13488 = state_13456__$1;(statearr_13469_13488[(1)] = (8));
} else
{var statearr_13470_13489 = state_13456__$1;(statearr_13470_13489[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13457 === (10)))
{var inst_13448 = (state_13456[(2)]);var state_13456__$1 = state_13456;var statearr_13471_13490 = state_13456__$1;(statearr_13471_13490[(2)] = inst_13448);
(statearr_13471_13490[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13457 === (8)))
{var inst_13433 = (state_13456[(7)]);var tmp13468 = inst_13433;var inst_13433__$1 = tmp13468;var state_13456__$1 = (function (){var statearr_13472 = state_13456;(statearr_13472[(7)] = inst_13433__$1);
return statearr_13472;
})();var statearr_13473_13491 = state_13456__$1;(statearr_13473_13491[(2)] = null);
(statearr_13473_13491[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__5915__auto___13481,out))
;return ((function (switch__5900__auto__,c__5915__auto___13481,out){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_13477 = [null,null,null,null,null,null,null,null,null,null,null];(statearr_13477[(0)] = state_machine__5901__auto__);
(statearr_13477[(1)] = (1));
return statearr_13477;
});
var state_machine__5901__auto____1 = (function (state_13456){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_13456);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e13478){if((e13478 instanceof Object))
{var ex__5904__auto__ = e13478;var statearr_13479_13492 = state_13456;(statearr_13479_13492[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13456);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e13478;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__13493 = state_13456;
state_13456 = G__13493;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_13456){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_13456);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto___13481,out))
})();var state__5917__auto__ = (function (){var statearr_13480 = f__5916__auto__.call(null);(statearr_13480[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto___13481);
return statearr_13480;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto___13481,out))
);
return out;
});
unique = function(ch,buf_or_n){
switch(arguments.length){
case 1:
return unique__1.call(this,ch);
case 2:
return unique__2.call(this,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unique.cljs$core$IFn$_invoke$arity$1 = unique__1;
unique.cljs$core$IFn$_invoke$arity$2 = unique__2;
return unique;
})()
;
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.partition = (function() {
var partition = null;
var partition__2 = (function (n,ch){return partition.call(null,n,ch,null);
});
var partition__3 = (function (n,ch,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__5915__auto___13628 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto___13628,out){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto___13628,out){
return (function (state_13598){var state_val_13599 = (state_13598[(1)]);if((state_val_13599 === (7)))
{var inst_13594 = (state_13598[(2)]);var state_13598__$1 = state_13598;var statearr_13600_13629 = state_13598__$1;(statearr_13600_13629[(2)] = inst_13594);
(statearr_13600_13629[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13599 === (1)))
{var inst_13561 = (new Array(n));var inst_13562 = inst_13561;var inst_13563 = (0);var state_13598__$1 = (function (){var statearr_13601 = state_13598;(statearr_13601[(7)] = inst_13562);
(statearr_13601[(8)] = inst_13563);
return statearr_13601;
})();var statearr_13602_13630 = state_13598__$1;(statearr_13602_13630[(2)] = null);
(statearr_13602_13630[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13599 === (4)))
{var inst_13566 = (state_13598[(9)]);var inst_13566__$1 = (state_13598[(2)]);var inst_13567 = (inst_13566__$1 == null);var inst_13568 = cljs.core.not.call(null,inst_13567);var state_13598__$1 = (function (){var statearr_13603 = state_13598;(statearr_13603[(9)] = inst_13566__$1);
return statearr_13603;
})();if(inst_13568)
{var statearr_13604_13631 = state_13598__$1;(statearr_13604_13631[(1)] = (5));
} else
{var statearr_13605_13632 = state_13598__$1;(statearr_13605_13632[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13599 === (15)))
{var inst_13588 = (state_13598[(2)]);var state_13598__$1 = state_13598;var statearr_13606_13633 = state_13598__$1;(statearr_13606_13633[(2)] = inst_13588);
(statearr_13606_13633[(1)] = (14));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13599 === (13)))
{var state_13598__$1 = state_13598;var statearr_13607_13634 = state_13598__$1;(statearr_13607_13634[(2)] = null);
(statearr_13607_13634[(1)] = (14));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13599 === (6)))
{var inst_13563 = (state_13598[(8)]);var inst_13584 = (inst_13563 > (0));var state_13598__$1 = state_13598;if(cljs.core.truth_(inst_13584))
{var statearr_13608_13635 = state_13598__$1;(statearr_13608_13635[(1)] = (12));
} else
{var statearr_13609_13636 = state_13598__$1;(statearr_13609_13636[(1)] = (13));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13599 === (3)))
{var inst_13596 = (state_13598[(2)]);var state_13598__$1 = state_13598;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13598__$1,inst_13596);
} else
{if((state_val_13599 === (12)))
{var inst_13562 = (state_13598[(7)]);var inst_13586 = cljs.core.vec.call(null,inst_13562);var state_13598__$1 = state_13598;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13598__$1,(15),out,inst_13586);
} else
{if((state_val_13599 === (2)))
{var state_13598__$1 = state_13598;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13598__$1,(4),ch);
} else
{if((state_val_13599 === (11)))
{var inst_13578 = (state_13598[(2)]);var inst_13579 = (new Array(n));var inst_13562 = inst_13579;var inst_13563 = (0);var state_13598__$1 = (function (){var statearr_13610 = state_13598;(statearr_13610[(7)] = inst_13562);
(statearr_13610[(8)] = inst_13563);
(statearr_13610[(10)] = inst_13578);
return statearr_13610;
})();var statearr_13611_13637 = state_13598__$1;(statearr_13611_13637[(2)] = null);
(statearr_13611_13637[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13599 === (9)))
{var inst_13562 = (state_13598[(7)]);var inst_13576 = cljs.core.vec.call(null,inst_13562);var state_13598__$1 = state_13598;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13598__$1,(11),out,inst_13576);
} else
{if((state_val_13599 === (5)))
{var inst_13571 = (state_13598[(11)]);var inst_13566 = (state_13598[(9)]);var inst_13562 = (state_13598[(7)]);var inst_13563 = (state_13598[(8)]);var inst_13570 = (inst_13562[inst_13563] = inst_13566);var inst_13571__$1 = (inst_13563 + (1));var inst_13572 = (inst_13571__$1 < n);var state_13598__$1 = (function (){var statearr_13612 = state_13598;(statearr_13612[(11)] = inst_13571__$1);
(statearr_13612[(12)] = inst_13570);
return statearr_13612;
})();if(cljs.core.truth_(inst_13572))
{var statearr_13613_13638 = state_13598__$1;(statearr_13613_13638[(1)] = (8));
} else
{var statearr_13614_13639 = state_13598__$1;(statearr_13614_13639[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13599 === (14)))
{var inst_13591 = (state_13598[(2)]);var inst_13592 = cljs.core.async.close_BANG_.call(null,out);var state_13598__$1 = (function (){var statearr_13616 = state_13598;(statearr_13616[(13)] = inst_13591);
return statearr_13616;
})();var statearr_13617_13640 = state_13598__$1;(statearr_13617_13640[(2)] = inst_13592);
(statearr_13617_13640[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13599 === (10)))
{var inst_13582 = (state_13598[(2)]);var state_13598__$1 = state_13598;var statearr_13618_13641 = state_13598__$1;(statearr_13618_13641[(2)] = inst_13582);
(statearr_13618_13641[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13599 === (8)))
{var inst_13571 = (state_13598[(11)]);var inst_13562 = (state_13598[(7)]);var tmp13615 = inst_13562;var inst_13562__$1 = tmp13615;var inst_13563 = inst_13571;var state_13598__$1 = (function (){var statearr_13619 = state_13598;(statearr_13619[(7)] = inst_13562__$1);
(statearr_13619[(8)] = inst_13563);
return statearr_13619;
})();var statearr_13620_13642 = state_13598__$1;(statearr_13620_13642[(2)] = null);
(statearr_13620_13642[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__5915__auto___13628,out))
;return ((function (switch__5900__auto__,c__5915__auto___13628,out){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_13624 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_13624[(0)] = state_machine__5901__auto__);
(statearr_13624[(1)] = (1));
return statearr_13624;
});
var state_machine__5901__auto____1 = (function (state_13598){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_13598);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e13625){if((e13625 instanceof Object))
{var ex__5904__auto__ = e13625;var statearr_13626_13643 = state_13598;(statearr_13626_13643[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13598);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e13625;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__13644 = state_13598;
state_13598 = G__13644;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_13598){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_13598);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto___13628,out))
})();var state__5917__auto__ = (function (){var statearr_13627 = f__5916__auto__.call(null);(statearr_13627[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto___13628);
return statearr_13627;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto___13628,out))
);
return out;
});
partition = function(n,ch,buf_or_n){
switch(arguments.length){
case 2:
return partition__2.call(this,n,ch);
case 3:
return partition__3.call(this,n,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
partition.cljs$core$IFn$_invoke$arity$2 = partition__2;
partition.cljs$core$IFn$_invoke$arity$3 = partition__3;
return partition;
})()
;
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.partition_by = (function() {
var partition_by = null;
var partition_by__2 = (function (f,ch){return partition_by.call(null,f,ch,null);
});
var partition_by__3 = (function (f,ch,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__5915__auto___13787 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto___13787,out){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto___13787,out){
return (function (state_13757){var state_val_13758 = (state_13757[(1)]);if((state_val_13758 === (7)))
{var inst_13753 = (state_13757[(2)]);var state_13757__$1 = state_13757;var statearr_13759_13788 = state_13757__$1;(statearr_13759_13788[(2)] = inst_13753);
(statearr_13759_13788[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13758 === (1)))
{var inst_13716 = [];var inst_13717 = inst_13716;var inst_13718 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);var state_13757__$1 = (function (){var statearr_13760 = state_13757;(statearr_13760[(7)] = inst_13717);
(statearr_13760[(8)] = inst_13718);
return statearr_13760;
})();var statearr_13761_13789 = state_13757__$1;(statearr_13761_13789[(2)] = null);
(statearr_13761_13789[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13758 === (4)))
{var inst_13721 = (state_13757[(9)]);var inst_13721__$1 = (state_13757[(2)]);var inst_13722 = (inst_13721__$1 == null);var inst_13723 = cljs.core.not.call(null,inst_13722);var state_13757__$1 = (function (){var statearr_13762 = state_13757;(statearr_13762[(9)] = inst_13721__$1);
return statearr_13762;
})();if(inst_13723)
{var statearr_13763_13790 = state_13757__$1;(statearr_13763_13790[(1)] = (5));
} else
{var statearr_13764_13791 = state_13757__$1;(statearr_13764_13791[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13758 === (15)))
{var inst_13747 = (state_13757[(2)]);var state_13757__$1 = state_13757;var statearr_13765_13792 = state_13757__$1;(statearr_13765_13792[(2)] = inst_13747);
(statearr_13765_13792[(1)] = (14));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13758 === (13)))
{var state_13757__$1 = state_13757;var statearr_13766_13793 = state_13757__$1;(statearr_13766_13793[(2)] = null);
(statearr_13766_13793[(1)] = (14));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13758 === (6)))
{var inst_13717 = (state_13757[(7)]);var inst_13742 = inst_13717.length;var inst_13743 = (inst_13742 > (0));var state_13757__$1 = state_13757;if(cljs.core.truth_(inst_13743))
{var statearr_13767_13794 = state_13757__$1;(statearr_13767_13794[(1)] = (12));
} else
{var statearr_13768_13795 = state_13757__$1;(statearr_13768_13795[(1)] = (13));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13758 === (3)))
{var inst_13755 = (state_13757[(2)]);var state_13757__$1 = state_13757;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13757__$1,inst_13755);
} else
{if((state_val_13758 === (12)))
{var inst_13717 = (state_13757[(7)]);var inst_13745 = cljs.core.vec.call(null,inst_13717);var state_13757__$1 = state_13757;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13757__$1,(15),out,inst_13745);
} else
{if((state_val_13758 === (2)))
{var state_13757__$1 = state_13757;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13757__$1,(4),ch);
} else
{if((state_val_13758 === (11)))
{var inst_13721 = (state_13757[(9)]);var inst_13725 = (state_13757[(10)]);var inst_13735 = (state_13757[(2)]);var inst_13736 = [];var inst_13737 = inst_13736.push(inst_13721);var inst_13717 = inst_13736;var inst_13718 = inst_13725;var state_13757__$1 = (function (){var statearr_13769 = state_13757;(statearr_13769[(7)] = inst_13717);
(statearr_13769[(11)] = inst_13737);
(statearr_13769[(8)] = inst_13718);
(statearr_13769[(12)] = inst_13735);
return statearr_13769;
})();var statearr_13770_13796 = state_13757__$1;(statearr_13770_13796[(2)] = null);
(statearr_13770_13796[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13758 === (9)))
{var inst_13717 = (state_13757[(7)]);var inst_13733 = cljs.core.vec.call(null,inst_13717);var state_13757__$1 = state_13757;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13757__$1,(11),out,inst_13733);
} else
{if((state_val_13758 === (5)))
{var inst_13718 = (state_13757[(8)]);var inst_13721 = (state_13757[(9)]);var inst_13725 = (state_13757[(10)]);var inst_13725__$1 = f.call(null,inst_13721);var inst_13726 = cljs.core._EQ_.call(null,inst_13725__$1,inst_13718);var inst_13727 = cljs.core.keyword_identical_QMARK_.call(null,inst_13718,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));var inst_13728 = (inst_13726) || (inst_13727);var state_13757__$1 = (function (){var statearr_13771 = state_13757;(statearr_13771[(10)] = inst_13725__$1);
return statearr_13771;
})();if(cljs.core.truth_(inst_13728))
{var statearr_13772_13797 = state_13757__$1;(statearr_13772_13797[(1)] = (8));
} else
{var statearr_13773_13798 = state_13757__$1;(statearr_13773_13798[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13758 === (14)))
{var inst_13750 = (state_13757[(2)]);var inst_13751 = cljs.core.async.close_BANG_.call(null,out);var state_13757__$1 = (function (){var statearr_13775 = state_13757;(statearr_13775[(13)] = inst_13750);
return statearr_13775;
})();var statearr_13776_13799 = state_13757__$1;(statearr_13776_13799[(2)] = inst_13751);
(statearr_13776_13799[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13758 === (10)))
{var inst_13740 = (state_13757[(2)]);var state_13757__$1 = state_13757;var statearr_13777_13800 = state_13757__$1;(statearr_13777_13800[(2)] = inst_13740);
(statearr_13777_13800[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13758 === (8)))
{var inst_13717 = (state_13757[(7)]);var inst_13721 = (state_13757[(9)]);var inst_13725 = (state_13757[(10)]);var inst_13730 = inst_13717.push(inst_13721);var tmp13774 = inst_13717;var inst_13717__$1 = tmp13774;var inst_13718 = inst_13725;var state_13757__$1 = (function (){var statearr_13778 = state_13757;(statearr_13778[(7)] = inst_13717__$1);
(statearr_13778[(8)] = inst_13718);
(statearr_13778[(14)] = inst_13730);
return statearr_13778;
})();var statearr_13779_13801 = state_13757__$1;(statearr_13779_13801[(2)] = null);
(statearr_13779_13801[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__5915__auto___13787,out))
;return ((function (switch__5900__auto__,c__5915__auto___13787,out){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_13783 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_13783[(0)] = state_machine__5901__auto__);
(statearr_13783[(1)] = (1));
return statearr_13783;
});
var state_machine__5901__auto____1 = (function (state_13757){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_13757);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e13784){if((e13784 instanceof Object))
{var ex__5904__auto__ = e13784;var statearr_13785_13802 = state_13757;(statearr_13785_13802[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13757);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e13784;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__13803 = state_13757;
state_13757 = G__13803;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_13757){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_13757);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto___13787,out))
})();var state__5917__auto__ = (function (){var statearr_13786 = f__5916__auto__.call(null);(statearr_13786[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto___13787);
return statearr_13786;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto___13787,out))
);
return out;
});
partition_by = function(f,ch,buf_or_n){
switch(arguments.length){
case 2:
return partition_by__2.call(this,f,ch);
case 3:
return partition_by__3.call(this,f,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
partition_by.cljs$core$IFn$_invoke$arity$2 = partition_by__2;
partition_by.cljs$core$IFn$_invoke$arity$3 = partition_by__3;
return partition_by;
})()
;
