// Compiled by ClojureScript 0.0-2371
goog.provide('dommy.core');
goog.require('cljs.core');
goog.require('dommy.utils');
goog.require('dommy.utils');
goog.require('dommy.utils');
goog.require('clojure.string');
goog.require('clojure.string');
/**
* Returns a selector in string format.
* Accepts string, keyword, or collection.
*/
dommy.core.selector = (function selector(data){if(cljs.core.coll_QMARK_.call(null,data))
{return clojure.string.join.call(null," ",cljs.core.map.call(null,selector,data));
} else
{if((typeof data === 'string') || ((data instanceof cljs.core.Keyword)))
{return cljs.core.name.call(null,data);
} else
{return null;
}
}
});
dommy.core.text = (function text(elem){var or__3648__auto__ = elem.textContent;if(cljs.core.truth_(or__3648__auto__))
{return or__3648__auto__;
} else
{return elem.innerText;
}
});
dommy.core.html = (function html(elem){return elem.innerHTML;
});
dommy.core.value = (function value(elem){return elem.value;
});
dommy.core.class$ = (function class$(elem){return elem.className;
});
dommy.core.attr = (function attr(elem,k){if(cljs.core.truth_(k))
{return elem.getAttribute(dommy.utils.as_str.call(null,k));
} else
{return null;
}
});
/**
* The computed style of `elem`, optionally specifying the key of
* a particular style to return
*/
dommy.core.style = (function() {
var style = null;
var style__1 = (function (elem){return cljs.core.js__GT_clj.call(null,window.getComputedStyle(elem));
});
var style__2 = (function (elem,k){return (window.getComputedStyle(elem)[dommy.utils.as_str.call(null,k)]);
});
style = function(elem,k){
switch(arguments.length){
case 1:
return style__1.call(this,elem);
case 2:
return style__2.call(this,elem,k);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
style.cljs$core$IFn$_invoke$arity$1 = style__1;
style.cljs$core$IFn$_invoke$arity$2 = style__2;
return style;
})()
;
dommy.core.px = (function px(elem,k){var pixels = dommy.core.style.call(null,elem,k);if(cljs.core.seq.call(null,pixels))
{return parseInt(pixels);
} else
{return null;
}
});
/**
* Does `elem` contain `c` in its class list
*/
dommy.core.has_class_QMARK_ = (function has_class_QMARK_(elem,c){var c__$1 = dommy.utils.as_str.call(null,c);var temp__4124__auto__ = elem.classList;if(cljs.core.truth_(temp__4124__auto__))
{var class_list = temp__4124__auto__;return class_list.contains(c__$1);
} else
{var temp__4126__auto__ = dommy.core.class$.call(null,elem);if(cljs.core.truth_(temp__4126__auto__))
{var class_name = temp__4126__auto__;var temp__4126__auto____$1 = dommy.utils.class_index.call(null,class_name,c__$1);if(cljs.core.truth_(temp__4126__auto____$1))
{var i = temp__4126__auto____$1;return (i >= (0));
} else
{return null;
}
} else
{return null;
}
}
});
/**
* Is `elem` hidden (as associated with hide!/show!/toggle!, using display: none)
*/
dommy.core.hidden_QMARK_ = (function hidden_QMARK_(elem){return (dommy.core.style.call(null,elem,new cljs.core.Keyword(null,"display","display",242065432)) === "none");
});
/**
* Returns a map of the bounding client rect of `elem`
* as a map with [:top :left :right :bottom :width :height]
*/
dommy.core.bounding_client_rect = (function bounding_client_rect(elem){var r = elem.getBoundingClientRect();return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"top","top",-1856271961),r.top,new cljs.core.Keyword(null,"bottom","bottom",-1550509018),r.bottom,new cljs.core.Keyword(null,"left","left",-399115937),r.left,new cljs.core.Keyword(null,"right","right",-452581833),r.right,new cljs.core.Keyword(null,"width","width",-384071477),r.width,new cljs.core.Keyword(null,"height","height",1025178622),r.height], null);
});
dommy.core.parent = (function parent(elem){return elem.parentNode;
});
dommy.core.children = (function children(elem){return elem.children;
});
/**
* Lazy seq of the ancestors of `elem`
*/
dommy.core.ancestors = (function ancestors(elem){return cljs.core.take_while.call(null,cljs.core.identity,cljs.core.iterate.call(null,dommy.core.parent,elem));
});
dommy.core.ancestor_nodes = dommy.core.ancestors;
/**
* Returns a predicate on nodes that match `selector` at the
* time of this `matches-pred` call (may return outdated results
* if you fuck with the DOM)
*/
dommy.core.matches_pred = (function() {
var matches_pred = null;
var matches_pred__1 = (function (selector){return matches_pred.call(null,document,selector);
});
var matches_pred__2 = (function (base,selector){var matches = dommy.utils.__GT_Array.call(null,base.querySelectorAll(dommy.core.selector.call(null,selector)));return ((function (matches){
return (function (elem){return (matches.indexOf(elem) >= (0));
});
;})(matches))
});
matches_pred = function(base,selector){
switch(arguments.length){
case 1:
return matches_pred__1.call(this,base);
case 2:
return matches_pred__2.call(this,base,selector);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
matches_pred.cljs$core$IFn$_invoke$arity$1 = matches_pred__1;
matches_pred.cljs$core$IFn$_invoke$arity$2 = matches_pred__2;
return matches_pred;
})()
;
/**
* Closest ancestor of `elem` (up to `base`, if provided)
* that matches `selector`
*/
dommy.core.closest = (function() {
var closest = null;
var closest__2 = (function (elem,selector){return closest.call(null,document.body,elem,selector);
});
var closest__3 = (function (base,elem,selector){return cljs.core.first.call(null,cljs.core.filter.call(null,dommy.core.matches_pred.call(null,base,selector),cljs.core.take_while.call(null,(function (p1__13888_SHARP_){return !((p1__13888_SHARP_ === base));
}),dommy.core.ancestors.call(null,elem))));
});
closest = function(base,elem,selector){
switch(arguments.length){
case 2:
return closest__2.call(this,base,elem);
case 3:
return closest__3.call(this,base,elem,selector);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
closest.cljs$core$IFn$_invoke$arity$2 = closest__2;
closest.cljs$core$IFn$_invoke$arity$3 = closest__3;
return closest;
})()
;
/**
* Is `descendant` a descendant of `ancestor`?
* (http://goo.gl/T8pgCX)
*/
dommy.core.descendant_QMARK_ = (function descendant_QMARK_(descendant,ancestor){if(cljs.core.truth_(ancestor.contains))
{return ancestor.contains(descendant);
} else
{if(cljs.core.truth_(ancestor.compareDocumentPosition))
{return ((ancestor.compareDocumentPosition(descendant) & (1 << (4))) != 0);
} else
{return null;
}
}
});
/**
* Set the textContent of `elem` to `text`, fall back to innerText
*/
dommy.core.set_text_BANG_ = (function set_text_BANG_(elem,text){if(!((void 0 === elem.textContent)))
{elem.textContent = text;
} else
{elem.innerText = text;
}
return elem;
});
/**
* Set the innerHTML of `elem` to `html`
*/
dommy.core.set_html_BANG_ = (function set_html_BANG_(elem,html){elem.innerHTML = html;
return elem;
});
/**
* Set the value of `elem` to `value`
*/
dommy.core.set_value_BANG_ = (function set_value_BANG_(elem,value){elem.value = value;
return elem;
});
/**
* Set the css class of `elem` to `elem`
*/
dommy.core.set_class_BANG_ = (function set_class_BANG_(elem,c){return elem.className = c;
});
/**
* Set the style of `elem` using key-value pairs:
* 
* (set-style! elem :display "block" :color "red")
* @param {...*} var_args
*/
dommy.core.set_style_BANG_ = (function() { 
var set_style_BANG___delegate = function (elem,kvs){if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,kvs)))
{} else
{throw (new Error(("Assert failed: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"kvs","kvs",-1695980277,null))))))));
}
var style = elem.style;var seq__13895_13901 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),kvs));var chunk__13896_13902 = null;var count__13897_13903 = (0);var i__13898_13904 = (0);while(true){
if((i__13898_13904 < count__13897_13903))
{var vec__13899_13905 = cljs.core._nth.call(null,chunk__13896_13902,i__13898_13904);var k_13906 = cljs.core.nth.call(null,vec__13899_13905,(0),null);var v_13907 = cljs.core.nth.call(null,vec__13899_13905,(1),null);style.setProperty(dommy.utils.as_str.call(null,k_13906),v_13907);
{
var G__13908 = seq__13895_13901;
var G__13909 = chunk__13896_13902;
var G__13910 = count__13897_13903;
var G__13911 = (i__13898_13904 + (1));
seq__13895_13901 = G__13908;
chunk__13896_13902 = G__13909;
count__13897_13903 = G__13910;
i__13898_13904 = G__13911;
continue;
}
} else
{var temp__4126__auto___13912 = cljs.core.seq.call(null,seq__13895_13901);if(temp__4126__auto___13912)
{var seq__13895_13913__$1 = temp__4126__auto___13912;if(cljs.core.chunked_seq_QMARK_.call(null,seq__13895_13913__$1))
{var c__4418__auto___13914 = cljs.core.chunk_first.call(null,seq__13895_13913__$1);{
var G__13915 = cljs.core.chunk_rest.call(null,seq__13895_13913__$1);
var G__13916 = c__4418__auto___13914;
var G__13917 = cljs.core.count.call(null,c__4418__auto___13914);
var G__13918 = (0);
seq__13895_13901 = G__13915;
chunk__13896_13902 = G__13916;
count__13897_13903 = G__13917;
i__13898_13904 = G__13918;
continue;
}
} else
{var vec__13900_13919 = cljs.core.first.call(null,seq__13895_13913__$1);var k_13920 = cljs.core.nth.call(null,vec__13900_13919,(0),null);var v_13921 = cljs.core.nth.call(null,vec__13900_13919,(1),null);style.setProperty(dommy.utils.as_str.call(null,k_13920),v_13921);
{
var G__13922 = cljs.core.next.call(null,seq__13895_13913__$1);
var G__13923 = null;
var G__13924 = (0);
var G__13925 = (0);
seq__13895_13901 = G__13922;
chunk__13896_13902 = G__13923;
count__13897_13903 = G__13924;
i__13898_13904 = G__13925;
continue;
}
}
} else
{}
}
break;
}
return elem;
};
var set_style_BANG_ = function (elem,var_args){
var kvs = null;if (arguments.length > 1) {
  kvs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return set_style_BANG___delegate.call(this,elem,kvs);};
set_style_BANG_.cljs$lang$maxFixedArity = 1;
set_style_BANG_.cljs$lang$applyTo = (function (arglist__13926){
var elem = cljs.core.first(arglist__13926);
var kvs = cljs.core.rest(arglist__13926);
return set_style_BANG___delegate(elem,kvs);
});
set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic = set_style_BANG___delegate;
return set_style_BANG_;
})()
;
/**
* @param {...*} var_args
*/
dommy.core.set_px_BANG_ = (function() { 
var set_px_BANG___delegate = function (elem,kvs){if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,kvs)))
{} else
{throw (new Error(("Assert failed: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"kvs","kvs",-1695980277,null))))))));
}
var seq__13933_13939 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),kvs));var chunk__13934_13940 = null;var count__13935_13941 = (0);var i__13936_13942 = (0);while(true){
if((i__13936_13942 < count__13935_13941))
{var vec__13937_13943 = cljs.core._nth.call(null,chunk__13934_13940,i__13936_13942);var k_13944 = cljs.core.nth.call(null,vec__13937_13943,(0),null);var v_13945 = cljs.core.nth.call(null,vec__13937_13943,(1),null);dommy.core.set_style_BANG_.call(null,elem,k_13944,(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(v_13945)+"px"));
{
var G__13946 = seq__13933_13939;
var G__13947 = chunk__13934_13940;
var G__13948 = count__13935_13941;
var G__13949 = (i__13936_13942 + (1));
seq__13933_13939 = G__13946;
chunk__13934_13940 = G__13947;
count__13935_13941 = G__13948;
i__13936_13942 = G__13949;
continue;
}
} else
{var temp__4126__auto___13950 = cljs.core.seq.call(null,seq__13933_13939);if(temp__4126__auto___13950)
{var seq__13933_13951__$1 = temp__4126__auto___13950;if(cljs.core.chunked_seq_QMARK_.call(null,seq__13933_13951__$1))
{var c__4418__auto___13952 = cljs.core.chunk_first.call(null,seq__13933_13951__$1);{
var G__13953 = cljs.core.chunk_rest.call(null,seq__13933_13951__$1);
var G__13954 = c__4418__auto___13952;
var G__13955 = cljs.core.count.call(null,c__4418__auto___13952);
var G__13956 = (0);
seq__13933_13939 = G__13953;
chunk__13934_13940 = G__13954;
count__13935_13941 = G__13955;
i__13936_13942 = G__13956;
continue;
}
} else
{var vec__13938_13957 = cljs.core.first.call(null,seq__13933_13951__$1);var k_13958 = cljs.core.nth.call(null,vec__13938_13957,(0),null);var v_13959 = cljs.core.nth.call(null,vec__13938_13957,(1),null);dommy.core.set_style_BANG_.call(null,elem,k_13958,(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(v_13959)+"px"));
{
var G__13960 = cljs.core.next.call(null,seq__13933_13951__$1);
var G__13961 = null;
var G__13962 = (0);
var G__13963 = (0);
seq__13933_13939 = G__13960;
chunk__13934_13940 = G__13961;
count__13935_13941 = G__13962;
i__13936_13942 = G__13963;
continue;
}
}
} else
{}
}
break;
}
return elem;
};
var set_px_BANG_ = function (elem,var_args){
var kvs = null;if (arguments.length > 1) {
  kvs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return set_px_BANG___delegate.call(this,elem,kvs);};
set_px_BANG_.cljs$lang$maxFixedArity = 1;
set_px_BANG_.cljs$lang$applyTo = (function (arglist__13964){
var elem = cljs.core.first(arglist__13964);
var kvs = cljs.core.rest(arglist__13964);
return set_px_BANG___delegate(elem,kvs);
});
set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic = set_px_BANG___delegate;
return set_px_BANG_;
})()
;
/**
* Sets dom attributes on and returns `elem`.
* Attributes without values will be set to "true":
* 
* (set-attr! elem :disabled)
* 
* With values, the function takes variadic kv pairs:
* 
* (set-attr! elem :id "some-id"
* :name "some-name")
* @param {...*} var_args
*/
dommy.core.set_attr_BANG_ = (function() {
var set_attr_BANG_ = null;
var set_attr_BANG___2 = (function (elem,k){return set_attr_BANG_.call(null,elem,k,"true");
});
var set_attr_BANG___3 = (function (elem,k,v){var k__$1 = dommy.utils.as_str.call(null,k);if(cljs.core.truth_(v))
{if(cljs.core.fn_QMARK_.call(null,v))
{var G__13973 = elem;(G__13973[k__$1] = v);
return G__13973;
} else
{var G__13974 = elem;G__13974.setAttribute(k__$1,v);
return G__13974;
}
} else
{return null;
}
});
var set_attr_BANG___4 = (function() { 
var G__13981__delegate = function (elem,k,v,kvs){if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,kvs)))
{} else
{throw (new Error(("Assert failed: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"kvs","kvs",-1695980277,null))))))));
}
var seq__13975_13982 = cljs.core.seq.call(null,cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),cljs.core.partition.call(null,(2),kvs)));var chunk__13976_13983 = null;var count__13977_13984 = (0);var i__13978_13985 = (0);while(true){
if((i__13978_13985 < count__13977_13984))
{var vec__13979_13986 = cljs.core._nth.call(null,chunk__13976_13983,i__13978_13985);var k_13987__$1 = cljs.core.nth.call(null,vec__13979_13986,(0),null);var v_13988__$1 = cljs.core.nth.call(null,vec__13979_13986,(1),null);set_attr_BANG_.call(null,elem,k_13987__$1,v_13988__$1);
{
var G__13989 = seq__13975_13982;
var G__13990 = chunk__13976_13983;
var G__13991 = count__13977_13984;
var G__13992 = (i__13978_13985 + (1));
seq__13975_13982 = G__13989;
chunk__13976_13983 = G__13990;
count__13977_13984 = G__13991;
i__13978_13985 = G__13992;
continue;
}
} else
{var temp__4126__auto___13993 = cljs.core.seq.call(null,seq__13975_13982);if(temp__4126__auto___13993)
{var seq__13975_13994__$1 = temp__4126__auto___13993;if(cljs.core.chunked_seq_QMARK_.call(null,seq__13975_13994__$1))
{var c__4418__auto___13995 = cljs.core.chunk_first.call(null,seq__13975_13994__$1);{
var G__13996 = cljs.core.chunk_rest.call(null,seq__13975_13994__$1);
var G__13997 = c__4418__auto___13995;
var G__13998 = cljs.core.count.call(null,c__4418__auto___13995);
var G__13999 = (0);
seq__13975_13982 = G__13996;
chunk__13976_13983 = G__13997;
count__13977_13984 = G__13998;
i__13978_13985 = G__13999;
continue;
}
} else
{var vec__13980_14000 = cljs.core.first.call(null,seq__13975_13994__$1);var k_14001__$1 = cljs.core.nth.call(null,vec__13980_14000,(0),null);var v_14002__$1 = cljs.core.nth.call(null,vec__13980_14000,(1),null);set_attr_BANG_.call(null,elem,k_14001__$1,v_14002__$1);
{
var G__14003 = cljs.core.next.call(null,seq__13975_13994__$1);
var G__14004 = null;
var G__14005 = (0);
var G__14006 = (0);
seq__13975_13982 = G__14003;
chunk__13976_13983 = G__14004;
count__13977_13984 = G__14005;
i__13978_13985 = G__14006;
continue;
}
}
} else
{}
}
break;
}
return elem;
};
var G__13981 = function (elem,k,v,var_args){
var kvs = null;if (arguments.length > 3) {
  kvs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3),0);} 
return G__13981__delegate.call(this,elem,k,v,kvs);};
G__13981.cljs$lang$maxFixedArity = 3;
G__13981.cljs$lang$applyTo = (function (arglist__14007){
var elem = cljs.core.first(arglist__14007);
arglist__14007 = cljs.core.next(arglist__14007);
var k = cljs.core.first(arglist__14007);
arglist__14007 = cljs.core.next(arglist__14007);
var v = cljs.core.first(arglist__14007);
var kvs = cljs.core.rest(arglist__14007);
return G__13981__delegate(elem,k,v,kvs);
});
G__13981.cljs$core$IFn$_invoke$arity$variadic = G__13981__delegate;
return G__13981;
})()
;
set_attr_BANG_ = function(elem,k,v,var_args){
var kvs = var_args;
switch(arguments.length){
case 2:
return set_attr_BANG___2.call(this,elem,k);
case 3:
return set_attr_BANG___3.call(this,elem,k,v);
default:
return set_attr_BANG___4.cljs$core$IFn$_invoke$arity$variadic(elem,k,v, cljs.core.array_seq(arguments, 3));
}
throw(new Error('Invalid arity: ' + arguments.length));
};
set_attr_BANG_.cljs$lang$maxFixedArity = 3;
set_attr_BANG_.cljs$lang$applyTo = set_attr_BANG___4.cljs$lang$applyTo;
set_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = set_attr_BANG___2;
set_attr_BANG_.cljs$core$IFn$_invoke$arity$3 = set_attr_BANG___3;
set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic = set_attr_BANG___4.cljs$core$IFn$_invoke$arity$variadic;
return set_attr_BANG_;
})()
;
/**
* Removes dom attributes on and returns `elem`.
* `class` and `classes` are special cases which clear
* out the class name on removal.
* @param {...*} var_args
*/
dommy.core.remove_attr_BANG_ = (function() {
var remove_attr_BANG_ = null;
var remove_attr_BANG___2 = (function (elem,k){var k_14016__$1 = dommy.utils.as_str.call(null,k);if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["class",null,"classes",null], null), null).call(null,k_14016__$1)))
{dommy.core.set_class_BANG_.call(null,elem,"");
} else
{elem.removeAttribute(k_14016__$1);
}
return elem;
});
var remove_attr_BANG___3 = (function() { 
var G__14017__delegate = function (elem,k,ks){var seq__14012_14018 = cljs.core.seq.call(null,cljs.core.cons.call(null,k,ks));var chunk__14013_14019 = null;var count__14014_14020 = (0);var i__14015_14021 = (0);while(true){
if((i__14015_14021 < count__14014_14020))
{var k_14022__$1 = cljs.core._nth.call(null,chunk__14013_14019,i__14015_14021);remove_attr_BANG_.call(null,elem,k_14022__$1);
{
var G__14023 = seq__14012_14018;
var G__14024 = chunk__14013_14019;
var G__14025 = count__14014_14020;
var G__14026 = (i__14015_14021 + (1));
seq__14012_14018 = G__14023;
chunk__14013_14019 = G__14024;
count__14014_14020 = G__14025;
i__14015_14021 = G__14026;
continue;
}
} else
{var temp__4126__auto___14027 = cljs.core.seq.call(null,seq__14012_14018);if(temp__4126__auto___14027)
{var seq__14012_14028__$1 = temp__4126__auto___14027;if(cljs.core.chunked_seq_QMARK_.call(null,seq__14012_14028__$1))
{var c__4418__auto___14029 = cljs.core.chunk_first.call(null,seq__14012_14028__$1);{
var G__14030 = cljs.core.chunk_rest.call(null,seq__14012_14028__$1);
var G__14031 = c__4418__auto___14029;
var G__14032 = cljs.core.count.call(null,c__4418__auto___14029);
var G__14033 = (0);
seq__14012_14018 = G__14030;
chunk__14013_14019 = G__14031;
count__14014_14020 = G__14032;
i__14015_14021 = G__14033;
continue;
}
} else
{var k_14034__$1 = cljs.core.first.call(null,seq__14012_14028__$1);remove_attr_BANG_.call(null,elem,k_14034__$1);
{
var G__14035 = cljs.core.next.call(null,seq__14012_14028__$1);
var G__14036 = null;
var G__14037 = (0);
var G__14038 = (0);
seq__14012_14018 = G__14035;
chunk__14013_14019 = G__14036;
count__14014_14020 = G__14037;
i__14015_14021 = G__14038;
continue;
}
}
} else
{}
}
break;
}
return elem;
};
var G__14017 = function (elem,k,var_args){
var ks = null;if (arguments.length > 2) {
  ks = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);} 
return G__14017__delegate.call(this,elem,k,ks);};
G__14017.cljs$lang$maxFixedArity = 2;
G__14017.cljs$lang$applyTo = (function (arglist__14039){
var elem = cljs.core.first(arglist__14039);
arglist__14039 = cljs.core.next(arglist__14039);
var k = cljs.core.first(arglist__14039);
var ks = cljs.core.rest(arglist__14039);
return G__14017__delegate(elem,k,ks);
});
G__14017.cljs$core$IFn$_invoke$arity$variadic = G__14017__delegate;
return G__14017;
})()
;
remove_attr_BANG_ = function(elem,k,var_args){
var ks = var_args;
switch(arguments.length){
case 2:
return remove_attr_BANG___2.call(this,elem,k);
default:
return remove_attr_BANG___3.cljs$core$IFn$_invoke$arity$variadic(elem,k, cljs.core.array_seq(arguments, 2));
}
throw(new Error('Invalid arity: ' + arguments.length));
};
remove_attr_BANG_.cljs$lang$maxFixedArity = 2;
remove_attr_BANG_.cljs$lang$applyTo = remove_attr_BANG___3.cljs$lang$applyTo;
remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = remove_attr_BANG___2;
remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic = remove_attr_BANG___3.cljs$core$IFn$_invoke$arity$variadic;
return remove_attr_BANG_;
})()
;
/**
* Toggles a dom attribute `k` on `elem`, optionally specifying
* the boolean value with `add?`
*/
dommy.core.toggle_attr_BANG_ = (function() {
var toggle_attr_BANG_ = null;
var toggle_attr_BANG___2 = (function (elem,k){return toggle_attr_BANG_.call(null,elem,k,cljs.core.boolean$.call(null,dommy.core.attr.call(null,elem,k)));
});
var toggle_attr_BANG___3 = (function (elem,k,add_QMARK_){if(add_QMARK_)
{return dommy.core.set_attr_BANG_.call(null,elem,k);
} else
{return dommy.core.remove_attr_BANG_.call(null,elem,k);
}
});
toggle_attr_BANG_ = function(elem,k,add_QMARK_){
switch(arguments.length){
case 2:
return toggle_attr_BANG___2.call(this,elem,k);
case 3:
return toggle_attr_BANG___3.call(this,elem,k,add_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = toggle_attr_BANG___2;
toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3 = toggle_attr_BANG___3;
return toggle_attr_BANG_;
})()
;
/**
* Add `classes` to `elem`, trying to use Element::classList, and
* falling back to fast string parsing/manipulation
* @param {...*} var_args
*/
dommy.core.add_class_BANG_ = (function() {
var add_class_BANG_ = null;
var add_class_BANG___2 = (function (elem,classes){var classes__$1 = clojure.string.trim.call(null,dommy.utils.as_str.call(null,classes)).split(/\s+/);if(cljs.core.seq.call(null,classes__$1))
{var temp__4124__auto___14064 = elem.classList;if(cljs.core.truth_(temp__4124__auto___14064))
{var class_list_14065 = temp__4124__auto___14064;var seq__14052_14066 = cljs.core.seq.call(null,classes__$1);var chunk__14053_14067 = null;var count__14054_14068 = (0);var i__14055_14069 = (0);while(true){
if((i__14055_14069 < count__14054_14068))
{var c_14070 = cljs.core._nth.call(null,chunk__14053_14067,i__14055_14069);class_list_14065.add(c_14070);
{
var G__14071 = seq__14052_14066;
var G__14072 = chunk__14053_14067;
var G__14073 = count__14054_14068;
var G__14074 = (i__14055_14069 + (1));
seq__14052_14066 = G__14071;
chunk__14053_14067 = G__14072;
count__14054_14068 = G__14073;
i__14055_14069 = G__14074;
continue;
}
} else
{var temp__4126__auto___14075 = cljs.core.seq.call(null,seq__14052_14066);if(temp__4126__auto___14075)
{var seq__14052_14076__$1 = temp__4126__auto___14075;if(cljs.core.chunked_seq_QMARK_.call(null,seq__14052_14076__$1))
{var c__4418__auto___14077 = cljs.core.chunk_first.call(null,seq__14052_14076__$1);{
var G__14078 = cljs.core.chunk_rest.call(null,seq__14052_14076__$1);
var G__14079 = c__4418__auto___14077;
var G__14080 = cljs.core.count.call(null,c__4418__auto___14077);
var G__14081 = (0);
seq__14052_14066 = G__14078;
chunk__14053_14067 = G__14079;
count__14054_14068 = G__14080;
i__14055_14069 = G__14081;
continue;
}
} else
{var c_14082 = cljs.core.first.call(null,seq__14052_14076__$1);class_list_14065.add(c_14082);
{
var G__14083 = cljs.core.next.call(null,seq__14052_14076__$1);
var G__14084 = null;
var G__14085 = (0);
var G__14086 = (0);
seq__14052_14066 = G__14083;
chunk__14053_14067 = G__14084;
count__14054_14068 = G__14085;
i__14055_14069 = G__14086;
continue;
}
}
} else
{}
}
break;
}
} else
{var seq__14056_14087 = cljs.core.seq.call(null,classes__$1);var chunk__14057_14088 = null;var count__14058_14089 = (0);var i__14059_14090 = (0);while(true){
if((i__14059_14090 < count__14058_14089))
{var c_14091 = cljs.core._nth.call(null,chunk__14057_14088,i__14059_14090);var class_name_14092 = dommy.core.class$.call(null,elem);if(cljs.core.truth_(dommy.utils.class_index.call(null,class_name_14092,c_14091)))
{} else
{dommy.core.set_class_BANG_.call(null,elem,(((class_name_14092 === ""))?c_14091:(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(class_name_14092)+" "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(c_14091))));
}
{
var G__14093 = seq__14056_14087;
var G__14094 = chunk__14057_14088;
var G__14095 = count__14058_14089;
var G__14096 = (i__14059_14090 + (1));
seq__14056_14087 = G__14093;
chunk__14057_14088 = G__14094;
count__14058_14089 = G__14095;
i__14059_14090 = G__14096;
continue;
}
} else
{var temp__4126__auto___14097 = cljs.core.seq.call(null,seq__14056_14087);if(temp__4126__auto___14097)
{var seq__14056_14098__$1 = temp__4126__auto___14097;if(cljs.core.chunked_seq_QMARK_.call(null,seq__14056_14098__$1))
{var c__4418__auto___14099 = cljs.core.chunk_first.call(null,seq__14056_14098__$1);{
var G__14100 = cljs.core.chunk_rest.call(null,seq__14056_14098__$1);
var G__14101 = c__4418__auto___14099;
var G__14102 = cljs.core.count.call(null,c__4418__auto___14099);
var G__14103 = (0);
seq__14056_14087 = G__14100;
chunk__14057_14088 = G__14101;
count__14058_14089 = G__14102;
i__14059_14090 = G__14103;
continue;
}
} else
{var c_14104 = cljs.core.first.call(null,seq__14056_14098__$1);var class_name_14105 = dommy.core.class$.call(null,elem);if(cljs.core.truth_(dommy.utils.class_index.call(null,class_name_14105,c_14104)))
{} else
{dommy.core.set_class_BANG_.call(null,elem,(((class_name_14105 === ""))?c_14104:(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(class_name_14105)+" "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(c_14104))));
}
{
var G__14106 = cljs.core.next.call(null,seq__14056_14098__$1);
var G__14107 = null;
var G__14108 = (0);
var G__14109 = (0);
seq__14056_14087 = G__14106;
chunk__14057_14088 = G__14107;
count__14058_14089 = G__14108;
i__14059_14090 = G__14109;
continue;
}
}
} else
{}
}
break;
}
}
} else
{}
return elem;
});
var add_class_BANG___3 = (function() { 
var G__14110__delegate = function (elem,classes,more_classes){var seq__14060_14111 = cljs.core.seq.call(null,cljs.core.conj.call(null,more_classes,classes));var chunk__14061_14112 = null;var count__14062_14113 = (0);var i__14063_14114 = (0);while(true){
if((i__14063_14114 < count__14062_14113))
{var c_14115 = cljs.core._nth.call(null,chunk__14061_14112,i__14063_14114);add_class_BANG_.call(null,elem,c_14115);
{
var G__14116 = seq__14060_14111;
var G__14117 = chunk__14061_14112;
var G__14118 = count__14062_14113;
var G__14119 = (i__14063_14114 + (1));
seq__14060_14111 = G__14116;
chunk__14061_14112 = G__14117;
count__14062_14113 = G__14118;
i__14063_14114 = G__14119;
continue;
}
} else
{var temp__4126__auto___14120 = cljs.core.seq.call(null,seq__14060_14111);if(temp__4126__auto___14120)
{var seq__14060_14121__$1 = temp__4126__auto___14120;if(cljs.core.chunked_seq_QMARK_.call(null,seq__14060_14121__$1))
{var c__4418__auto___14122 = cljs.core.chunk_first.call(null,seq__14060_14121__$1);{
var G__14123 = cljs.core.chunk_rest.call(null,seq__14060_14121__$1);
var G__14124 = c__4418__auto___14122;
var G__14125 = cljs.core.count.call(null,c__4418__auto___14122);
var G__14126 = (0);
seq__14060_14111 = G__14123;
chunk__14061_14112 = G__14124;
count__14062_14113 = G__14125;
i__14063_14114 = G__14126;
continue;
}
} else
{var c_14127 = cljs.core.first.call(null,seq__14060_14121__$1);add_class_BANG_.call(null,elem,c_14127);
{
var G__14128 = cljs.core.next.call(null,seq__14060_14121__$1);
var G__14129 = null;
var G__14130 = (0);
var G__14131 = (0);
seq__14060_14111 = G__14128;
chunk__14061_14112 = G__14129;
count__14062_14113 = G__14130;
i__14063_14114 = G__14131;
continue;
}
}
} else
{}
}
break;
}
return elem;
};
var G__14110 = function (elem,classes,var_args){
var more_classes = null;if (arguments.length > 2) {
  more_classes = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);} 
return G__14110__delegate.call(this,elem,classes,more_classes);};
G__14110.cljs$lang$maxFixedArity = 2;
G__14110.cljs$lang$applyTo = (function (arglist__14132){
var elem = cljs.core.first(arglist__14132);
arglist__14132 = cljs.core.next(arglist__14132);
var classes = cljs.core.first(arglist__14132);
var more_classes = cljs.core.rest(arglist__14132);
return G__14110__delegate(elem,classes,more_classes);
});
G__14110.cljs$core$IFn$_invoke$arity$variadic = G__14110__delegate;
return G__14110;
})()
;
add_class_BANG_ = function(elem,classes,var_args){
var more_classes = var_args;
switch(arguments.length){
case 2:
return add_class_BANG___2.call(this,elem,classes);
default:
return add_class_BANG___3.cljs$core$IFn$_invoke$arity$variadic(elem,classes, cljs.core.array_seq(arguments, 2));
}
throw(new Error('Invalid arity: ' + arguments.length));
};
add_class_BANG_.cljs$lang$maxFixedArity = 2;
add_class_BANG_.cljs$lang$applyTo = add_class_BANG___3.cljs$lang$applyTo;
add_class_BANG_.cljs$core$IFn$_invoke$arity$2 = add_class_BANG___2;
add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic = add_class_BANG___3.cljs$core$IFn$_invoke$arity$variadic;
return add_class_BANG_;
})()
;
/**
* Remove `c` from `elem` class list
* @param {...*} var_args
*/
dommy.core.remove_class_BANG_ = (function() {
var remove_class_BANG_ = null;
var remove_class_BANG___2 = (function (elem,c){var c__$1 = dommy.utils.as_str.call(null,c);var temp__4124__auto___14141 = elem.classList;if(cljs.core.truth_(temp__4124__auto___14141))
{var class_list_14142 = temp__4124__auto___14141;class_list_14142.remove(c__$1);
} else
{var class_name_14143 = dommy.core.class$.call(null,elem);var new_class_name_14144 = dommy.utils.remove_class_str.call(null,class_name_14143,c__$1);if((class_name_14143 === new_class_name_14144))
{} else
{dommy.core.set_class_BANG_.call(null,elem,new_class_name_14144);
}
}
return elem;
});
var remove_class_BANG___3 = (function() { 
var G__14145__delegate = function (elem,class$,classes){var seq__14137 = cljs.core.seq.call(null,cljs.core.conj.call(null,classes,class$));var chunk__14138 = null;var count__14139 = (0);var i__14140 = (0);while(true){
if((i__14140 < count__14139))
{var c = cljs.core._nth.call(null,chunk__14138,i__14140);remove_class_BANG_.call(null,elem,c);
{
var G__14146 = seq__14137;
var G__14147 = chunk__14138;
var G__14148 = count__14139;
var G__14149 = (i__14140 + (1));
seq__14137 = G__14146;
chunk__14138 = G__14147;
count__14139 = G__14148;
i__14140 = G__14149;
continue;
}
} else
{var temp__4126__auto__ = cljs.core.seq.call(null,seq__14137);if(temp__4126__auto__)
{var seq__14137__$1 = temp__4126__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,seq__14137__$1))
{var c__4418__auto__ = cljs.core.chunk_first.call(null,seq__14137__$1);{
var G__14150 = cljs.core.chunk_rest.call(null,seq__14137__$1);
var G__14151 = c__4418__auto__;
var G__14152 = cljs.core.count.call(null,c__4418__auto__);
var G__14153 = (0);
seq__14137 = G__14150;
chunk__14138 = G__14151;
count__14139 = G__14152;
i__14140 = G__14153;
continue;
}
} else
{var c = cljs.core.first.call(null,seq__14137__$1);remove_class_BANG_.call(null,elem,c);
{
var G__14154 = cljs.core.next.call(null,seq__14137__$1);
var G__14155 = null;
var G__14156 = (0);
var G__14157 = (0);
seq__14137 = G__14154;
chunk__14138 = G__14155;
count__14139 = G__14156;
i__14140 = G__14157;
continue;
}
}
} else
{return null;
}
}
break;
}
};
var G__14145 = function (elem,class$,var_args){
var classes = null;if (arguments.length > 2) {
  classes = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);} 
return G__14145__delegate.call(this,elem,class$,classes);};
G__14145.cljs$lang$maxFixedArity = 2;
G__14145.cljs$lang$applyTo = (function (arglist__14158){
var elem = cljs.core.first(arglist__14158);
arglist__14158 = cljs.core.next(arglist__14158);
var class$ = cljs.core.first(arglist__14158);
var classes = cljs.core.rest(arglist__14158);
return G__14145__delegate(elem,class$,classes);
});
G__14145.cljs$core$IFn$_invoke$arity$variadic = G__14145__delegate;
return G__14145;
})()
;
remove_class_BANG_ = function(elem,class$,var_args){
var classes = var_args;
switch(arguments.length){
case 2:
return remove_class_BANG___2.call(this,elem,class$);
default:
return remove_class_BANG___3.cljs$core$IFn$_invoke$arity$variadic(elem,class$, cljs.core.array_seq(arguments, 2));
}
throw(new Error('Invalid arity: ' + arguments.length));
};
remove_class_BANG_.cljs$lang$maxFixedArity = 2;
remove_class_BANG_.cljs$lang$applyTo = remove_class_BANG___3.cljs$lang$applyTo;
remove_class_BANG_.cljs$core$IFn$_invoke$arity$2 = remove_class_BANG___2;
remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic = remove_class_BANG___3.cljs$core$IFn$_invoke$arity$variadic;
return remove_class_BANG_;
})()
;
/**
* (toggle-class! elem class) will add-class! if elem does not have class
* and remove-class! otherwise.
* (toggle-class! elem class add?) will add-class! if add? is truthy,
* otherwise it will remove-class!
*/
dommy.core.toggle_class_BANG_ = (function() {
var toggle_class_BANG_ = null;
var toggle_class_BANG___2 = (function (elem,c){var c__$1 = dommy.utils.as_str.call(null,c);var temp__4124__auto___14159 = elem.classList;if(cljs.core.truth_(temp__4124__auto___14159))
{var class_list_14160 = temp__4124__auto___14159;class_list_14160.toggle(c__$1);
} else
{toggle_class_BANG_.call(null,elem,c__$1,!(dommy.core.has_class_QMARK_.call(null,elem,c__$1)));
}
return elem;
});
var toggle_class_BANG___3 = (function (elem,class$,add_QMARK_){if(add_QMARK_)
{dommy.core.add_class_BANG_.call(null,elem,class$);
} else
{dommy.core.remove_class_BANG_.call(null,elem,class$);
}
return elem;
});
toggle_class_BANG_ = function(elem,class$,add_QMARK_){
switch(arguments.length){
case 2:
return toggle_class_BANG___2.call(this,elem,class$);
case 3:
return toggle_class_BANG___3.call(this,elem,class$,add_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
toggle_class_BANG_.cljs$core$IFn$_invoke$arity$2 = toggle_class_BANG___2;
toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3 = toggle_class_BANG___3;
return toggle_class_BANG_;
})()
;
/**
* Display or hide the given `elem` (using display: none).
* Takes an optional boolean `show?`
*/
dommy.core.toggle_BANG_ = (function() {
var toggle_BANG_ = null;
var toggle_BANG___1 = (function (elem){return toggle_BANG_.call(null,elem,dommy.core.hidden_QMARK_.call(null,elem));
});
var toggle_BANG___2 = (function (elem,show_QMARK_){return dommy.core.set_style_BANG_.call(null,elem,new cljs.core.Keyword(null,"display","display",242065432),((show_QMARK_)?"":"none"));
});
toggle_BANG_ = function(elem,show_QMARK_){
switch(arguments.length){
case 1:
return toggle_BANG___1.call(this,elem);
case 2:
return toggle_BANG___2.call(this,elem,show_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
toggle_BANG_.cljs$core$IFn$_invoke$arity$1 = toggle_BANG___1;
toggle_BANG_.cljs$core$IFn$_invoke$arity$2 = toggle_BANG___2;
return toggle_BANG_;
})()
;
dommy.core.hide_BANG_ = (function hide_BANG_(elem){return dommy.core.toggle_BANG_.call(null,elem,false);
});
dommy.core.show_BANG_ = (function show_BANG_(elem){return dommy.core.toggle_BANG_.call(null,elem,true);
});
dommy.core.scroll_into_view = (function scroll_into_view(elem,align_with_top_QMARK_){var top = new cljs.core.Keyword(null,"top","top",-1856271961).cljs$core$IFn$_invoke$arity$1(dommy.core.bounding_client_rect.call(null,elem));if((window.innerHeight < (top + elem.offsetHeight)))
{return elem.scrollIntoView(align_with_top_QMARK_);
} else
{return null;
}
});
dommy.core.create_element = (function() {
var create_element = null;
var create_element__1 = (function (tag){return document.createElement(dommy.utils.as_str.call(null,tag));
});
var create_element__2 = (function (tag_ns,tag){return document.createElementNS(dommy.utils.as_str.call(null,tag_ns),dommy.utils.as_str.call(null,tag));
});
create_element = function(tag_ns,tag){
switch(arguments.length){
case 1:
return create_element__1.call(this,tag_ns);
case 2:
return create_element__2.call(this,tag_ns,tag);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
create_element.cljs$core$IFn$_invoke$arity$1 = create_element__1;
create_element.cljs$core$IFn$_invoke$arity$2 = create_element__2;
return create_element;
})()
;
dommy.core.create_text_node = (function create_text_node(text){return document.createTextNode(text);
});
/**
* Clears all children from `elem`
*/
dommy.core.clear_BANG_ = (function clear_BANG_(elem){return dommy.core.set_html_BANG_.call(null,elem,"");
});
/**
* Append `child` to `parent`
* @param {...*} var_args
*/
dommy.core.append_BANG_ = (function() {
var append_BANG_ = null;
var append_BANG___2 = (function (parent,child){var G__14166 = parent;G__14166.appendChild(child);
return G__14166;
});
var append_BANG___3 = (function() { 
var G__14171__delegate = function (parent,child,more_children){var seq__14167_14172 = cljs.core.seq.call(null,cljs.core.cons.call(null,child,more_children));var chunk__14168_14173 = null;var count__14169_14174 = (0);var i__14170_14175 = (0);while(true){
if((i__14170_14175 < count__14169_14174))
{var c_14176 = cljs.core._nth.call(null,chunk__14168_14173,i__14170_14175);append_BANG_.call(null,parent,c_14176);
{
var G__14177 = seq__14167_14172;
var G__14178 = chunk__14168_14173;
var G__14179 = count__14169_14174;
var G__14180 = (i__14170_14175 + (1));
seq__14167_14172 = G__14177;
chunk__14168_14173 = G__14178;
count__14169_14174 = G__14179;
i__14170_14175 = G__14180;
continue;
}
} else
{var temp__4126__auto___14181 = cljs.core.seq.call(null,seq__14167_14172);if(temp__4126__auto___14181)
{var seq__14167_14182__$1 = temp__4126__auto___14181;if(cljs.core.chunked_seq_QMARK_.call(null,seq__14167_14182__$1))
{var c__4418__auto___14183 = cljs.core.chunk_first.call(null,seq__14167_14182__$1);{
var G__14184 = cljs.core.chunk_rest.call(null,seq__14167_14182__$1);
var G__14185 = c__4418__auto___14183;
var G__14186 = cljs.core.count.call(null,c__4418__auto___14183);
var G__14187 = (0);
seq__14167_14172 = G__14184;
chunk__14168_14173 = G__14185;
count__14169_14174 = G__14186;
i__14170_14175 = G__14187;
continue;
}
} else
{var c_14188 = cljs.core.first.call(null,seq__14167_14182__$1);append_BANG_.call(null,parent,c_14188);
{
var G__14189 = cljs.core.next.call(null,seq__14167_14182__$1);
var G__14190 = null;
var G__14191 = (0);
var G__14192 = (0);
seq__14167_14172 = G__14189;
chunk__14168_14173 = G__14190;
count__14169_14174 = G__14191;
i__14170_14175 = G__14192;
continue;
}
}
} else
{}
}
break;
}
return parent;
};
var G__14171 = function (parent,child,var_args){
var more_children = null;if (arguments.length > 2) {
  more_children = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);} 
return G__14171__delegate.call(this,parent,child,more_children);};
G__14171.cljs$lang$maxFixedArity = 2;
G__14171.cljs$lang$applyTo = (function (arglist__14193){
var parent = cljs.core.first(arglist__14193);
arglist__14193 = cljs.core.next(arglist__14193);
var child = cljs.core.first(arglist__14193);
var more_children = cljs.core.rest(arglist__14193);
return G__14171__delegate(parent,child,more_children);
});
G__14171.cljs$core$IFn$_invoke$arity$variadic = G__14171__delegate;
return G__14171;
})()
;
append_BANG_ = function(parent,child,var_args){
var more_children = var_args;
switch(arguments.length){
case 2:
return append_BANG___2.call(this,parent,child);
default:
return append_BANG___3.cljs$core$IFn$_invoke$arity$variadic(parent,child, cljs.core.array_seq(arguments, 2));
}
throw(new Error('Invalid arity: ' + arguments.length));
};
append_BANG_.cljs$lang$maxFixedArity = 2;
append_BANG_.cljs$lang$applyTo = append_BANG___3.cljs$lang$applyTo;
append_BANG_.cljs$core$IFn$_invoke$arity$2 = append_BANG___2;
append_BANG_.cljs$core$IFn$_invoke$arity$variadic = append_BANG___3.cljs$core$IFn$_invoke$arity$variadic;
return append_BANG_;
})()
;
/**
* Prepend `child` to `parent`
* @param {...*} var_args
*/
dommy.core.prepend_BANG_ = (function() {
var prepend_BANG_ = null;
var prepend_BANG___2 = (function (parent,child){var G__14199 = parent;G__14199.insertBefore(child,parent.firstChild);
return G__14199;
});
var prepend_BANG___3 = (function() { 
var G__14204__delegate = function (parent,child,more_children){var seq__14200_14205 = cljs.core.seq.call(null,cljs.core.cons.call(null,child,more_children));var chunk__14201_14206 = null;var count__14202_14207 = (0);var i__14203_14208 = (0);while(true){
if((i__14203_14208 < count__14202_14207))
{var c_14209 = cljs.core._nth.call(null,chunk__14201_14206,i__14203_14208);prepend_BANG_.call(null,parent,c_14209);
{
var G__14210 = seq__14200_14205;
var G__14211 = chunk__14201_14206;
var G__14212 = count__14202_14207;
var G__14213 = (i__14203_14208 + (1));
seq__14200_14205 = G__14210;
chunk__14201_14206 = G__14211;
count__14202_14207 = G__14212;
i__14203_14208 = G__14213;
continue;
}
} else
{var temp__4126__auto___14214 = cljs.core.seq.call(null,seq__14200_14205);if(temp__4126__auto___14214)
{var seq__14200_14215__$1 = temp__4126__auto___14214;if(cljs.core.chunked_seq_QMARK_.call(null,seq__14200_14215__$1))
{var c__4418__auto___14216 = cljs.core.chunk_first.call(null,seq__14200_14215__$1);{
var G__14217 = cljs.core.chunk_rest.call(null,seq__14200_14215__$1);
var G__14218 = c__4418__auto___14216;
var G__14219 = cljs.core.count.call(null,c__4418__auto___14216);
var G__14220 = (0);
seq__14200_14205 = G__14217;
chunk__14201_14206 = G__14218;
count__14202_14207 = G__14219;
i__14203_14208 = G__14220;
continue;
}
} else
{var c_14221 = cljs.core.first.call(null,seq__14200_14215__$1);prepend_BANG_.call(null,parent,c_14221);
{
var G__14222 = cljs.core.next.call(null,seq__14200_14215__$1);
var G__14223 = null;
var G__14224 = (0);
var G__14225 = (0);
seq__14200_14205 = G__14222;
chunk__14201_14206 = G__14223;
count__14202_14207 = G__14224;
i__14203_14208 = G__14225;
continue;
}
}
} else
{}
}
break;
}
return parent;
};
var G__14204 = function (parent,child,var_args){
var more_children = null;if (arguments.length > 2) {
  more_children = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);} 
return G__14204__delegate.call(this,parent,child,more_children);};
G__14204.cljs$lang$maxFixedArity = 2;
G__14204.cljs$lang$applyTo = (function (arglist__14226){
var parent = cljs.core.first(arglist__14226);
arglist__14226 = cljs.core.next(arglist__14226);
var child = cljs.core.first(arglist__14226);
var more_children = cljs.core.rest(arglist__14226);
return G__14204__delegate(parent,child,more_children);
});
G__14204.cljs$core$IFn$_invoke$arity$variadic = G__14204__delegate;
return G__14204;
})()
;
prepend_BANG_ = function(parent,child,var_args){
var more_children = var_args;
switch(arguments.length){
case 2:
return prepend_BANG___2.call(this,parent,child);
default:
return prepend_BANG___3.cljs$core$IFn$_invoke$arity$variadic(parent,child, cljs.core.array_seq(arguments, 2));
}
throw(new Error('Invalid arity: ' + arguments.length));
};
prepend_BANG_.cljs$lang$maxFixedArity = 2;
prepend_BANG_.cljs$lang$applyTo = prepend_BANG___3.cljs$lang$applyTo;
prepend_BANG_.cljs$core$IFn$_invoke$arity$2 = prepend_BANG___2;
prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic = prepend_BANG___3.cljs$core$IFn$_invoke$arity$variadic;
return prepend_BANG_;
})()
;
/**
* Insert `elem` before `other`, `other` must have a parent
*/
dommy.core.insert_before_BANG_ = (function insert_before_BANG_(elem,other){var p = dommy.core.parent.call(null,other);if(cljs.core.truth_(p))
{} else
{throw (new Error(("Assert failed: Target element must have a parent\n"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"p","p",1791580836,null))))));
}
p.insertBefore(elem,other);
return elem;
});
/**
* Insert `elem` after `other`, `other` must have a parent
*/
dommy.core.insert_after_BANG_ = (function insert_after_BANG_(elem,other){var temp__4124__auto___14227 = other.nextSibling;if(cljs.core.truth_(temp__4124__auto___14227))
{var next_14228 = temp__4124__auto___14227;dommy.core.insert_before_BANG_.call(null,elem,next_14228);
} else
{dommy.core.append_BANG_.call(null,dommy.core.parent.call(null,other),elem);
}
return elem;
});
/**
* Replace `elem` with `new`, return `new`
*/
dommy.core.replace_BANG_ = (function replace_BANG_(elem,new$){var p = dommy.core.parent.call(null,elem);if(cljs.core.truth_(p))
{} else
{throw (new Error(("Assert failed: Target element must have a parent\n"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"p","p",1791580836,null))))));
}
p.replaceChild(new$,elem);
return new$;
});
/**
* Replace children of `elem` with `child`
*/
dommy.core.replace_contents_BANG_ = (function replace_contents_BANG_(p,child){return dommy.core.append_BANG_.call(null,dommy.core.clear_BANG_.call(null,p),child);
});
/**
* Remove `elem` from `parent`, return `parent`
*/
dommy.core.remove_BANG_ = (function() {
var remove_BANG_ = null;
var remove_BANG___1 = (function (elem){var p = dommy.core.parent.call(null,elem);if(cljs.core.truth_(p))
{} else
{throw (new Error(("Assert failed: Target element must have a parent\n"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"p","p",1791580836,null))))));
}
return remove_BANG_.call(null,p,elem);
});
var remove_BANG___2 = (function (p,elem){var G__14230 = p;G__14230.removeChild(elem);
return G__14230;
});
remove_BANG_ = function(p,elem){
switch(arguments.length){
case 1:
return remove_BANG___1.call(this,p);
case 2:
return remove_BANG___2.call(this,p,elem);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
remove_BANG_.cljs$core$IFn$_invoke$arity$1 = remove_BANG___1;
remove_BANG_.cljs$core$IFn$_invoke$arity$2 = remove_BANG___2;
return remove_BANG_;
})()
;
dommy.core.special_listener_makers = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,(function (p__14231){var vec__14232 = p__14231;var special_mouse_event = cljs.core.nth.call(null,vec__14232,(0),null);var real_mouse_event = cljs.core.nth.call(null,vec__14232,(1),null);return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [special_mouse_event,new cljs.core.PersistentArrayMap.fromArray([real_mouse_event,((function (vec__14232,special_mouse_event,real_mouse_event){
return (function (f){return ((function (vec__14232,special_mouse_event,real_mouse_event){
return (function (event){var related_target = event.relatedTarget;var listener_target = (function (){var or__3648__auto__ = event.selectedTarget;if(cljs.core.truth_(or__3648__auto__))
{return or__3648__auto__;
} else
{return event.currentTarget;
}
})();if(cljs.core.truth_((function (){var and__3636__auto__ = related_target;if(cljs.core.truth_(and__3636__auto__))
{return dommy.core.descendant_QMARK_.call(null,related_target,listener_target);
} else
{return and__3636__auto__;
}
})()))
{return null;
} else
{return f.call(null,event);
}
});
;})(vec__14232,special_mouse_event,real_mouse_event))
});})(vec__14232,special_mouse_event,real_mouse_event))
], true, false)], null);
}),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"mouseenter","mouseenter",-1792413560),new cljs.core.Keyword(null,"mouseover","mouseover",-484272303),new cljs.core.Keyword(null,"mouseleave","mouseleave",531566580),new cljs.core.Keyword(null,"mouseout","mouseout",2049446890)], null)));
/**
* fires f if event.target is found with `selector`
*/
dommy.core.live_listener = (function live_listener(elem,selector,f){return (function (event){var selected_target = dommy.core.closest.call(null,elem,event.target,selector);if(cljs.core.truth_((function (){var and__3636__auto__ = selected_target;if(cljs.core.truth_(and__3636__auto__))
{return cljs.core.not.call(null,dommy.core.attr.call(null,selected_target,new cljs.core.Keyword(null,"disabled","disabled",-1529784218)));
} else
{return and__3636__auto__;
}
})()))
{event.selectedTarget = selected_target;
return f.call(null,event);
} else
{return null;
}
});
});
/**
* Returns a nested map of event listeners on `elem`
*/
dommy.core.event_listeners = (function event_listeners(elem){var or__3648__auto__ = elem.dommyEventListeners;if(cljs.core.truth_(or__3648__auto__))
{return or__3648__auto__;
} else
{return cljs.core.PersistentArrayMap.EMPTY;
}
});
/**
* @param {...*} var_args
*/
dommy.core.update_event_listeners_BANG_ = (function() { 
var update_event_listeners_BANG___delegate = function (elem,f,args){var elem__$1 = elem;return elem__$1.dommyEventListeners = cljs.core.apply.call(null,f,dommy.core.event_listeners.call(null,elem__$1),args);
};
var update_event_listeners_BANG_ = function (elem,f,var_args){
var args = null;if (arguments.length > 2) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);} 
return update_event_listeners_BANG___delegate.call(this,elem,f,args);};
update_event_listeners_BANG_.cljs$lang$maxFixedArity = 2;
update_event_listeners_BANG_.cljs$lang$applyTo = (function (arglist__14233){
var elem = cljs.core.first(arglist__14233);
arglist__14233 = cljs.core.next(arglist__14233);
var f = cljs.core.first(arglist__14233);
var args = cljs.core.rest(arglist__14233);
return update_event_listeners_BANG___delegate(elem,f,args);
});
update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic = update_event_listeners_BANG___delegate;
return update_event_listeners_BANG_;
})()
;
dommy.core.elem_and_selector = (function elem_and_selector(elem_sel){if(cljs.core.sequential_QMARK_.call(null,elem_sel))
{return cljs.core.juxt.call(null,cljs.core.first,cljs.core.rest).call(null,elem_sel);
} else
{return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [elem_sel,null], null);
}
});
/**
* Adds `f` as a listener for events of type `event-type` on
* `elem-sel`, which must either be a DOM node, or a sequence
* whose first item is a DOM node.
* 
* In other words, the call to `listen!` can take two forms:
* 
* If `elem-sel` is a DOM node, i.e., you're doing something like:
* 
* (listen! elem :click click-handler)
* 
* then `click-handler` will be set as a listener for `click` events
* on the `elem`.
* 
* If `elem-sel` is a sequence:
* 
* (listen! [elem :.selector.for :.some.descendants] :click click-handler)
* 
* then `click-handler` will be set as a listener for `click` events
* on descendants of `elem` that match the selector
* 
* Also accepts any number of event-type and handler pairs for setting
* multiple listeners at once:
* 
* (listen! some-elem :click click-handler :hover hover-handler)
* @param {...*} var_args
*/
dommy.core.listen_BANG_ = (function() { 
var listen_BANG___delegate = function (elem_sel,type_fs){if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,type_fs)))
{} else
{throw (new Error(("Assert failed: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"type-fs","type-fs",1567896074,null))))))));
}
var vec__14257_14280 = dommy.core.elem_and_selector.call(null,elem_sel);var elem_14281 = cljs.core.nth.call(null,vec__14257_14280,(0),null);var selector_14282 = cljs.core.nth.call(null,vec__14257_14280,(1),null);var seq__14258_14283 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),type_fs));var chunk__14265_14284 = null;var count__14266_14285 = (0);var i__14267_14286 = (0);while(true){
if((i__14267_14286 < count__14266_14285))
{var vec__14274_14287 = cljs.core._nth.call(null,chunk__14265_14284,i__14267_14286);var orig_type_14288 = cljs.core.nth.call(null,vec__14274_14287,(0),null);var f_14289 = cljs.core.nth.call(null,vec__14274_14287,(1),null);var seq__14268_14290 = cljs.core.seq.call(null,cljs.core.get.call(null,dommy.core.special_listener_makers,orig_type_14288,new cljs.core.PersistentArrayMap.fromArray([orig_type_14288,cljs.core.identity], true, false)));var chunk__14270_14291 = null;var count__14271_14292 = (0);var i__14272_14293 = (0);while(true){
if((i__14272_14293 < count__14271_14292))
{var vec__14275_14294 = cljs.core._nth.call(null,chunk__14270_14291,i__14272_14293);var actual_type_14295 = cljs.core.nth.call(null,vec__14275_14294,(0),null);var factory_14296 = cljs.core.nth.call(null,vec__14275_14294,(1),null);var canonical_f_14297 = (cljs.core.truth_(selector_14282)?cljs.core.partial.call(null,dommy.core.live_listener,elem_14281,selector_14282):cljs.core.identity).call(null,factory_14296.call(null,f_14289));dommy.core.update_event_listeners_BANG_.call(null,elem_14281,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_14282,actual_type_14295,f_14289], null),canonical_f_14297);
if(cljs.core.truth_(elem_14281.addEventListener))
{elem_14281.addEventListener(cljs.core.name.call(null,actual_type_14295),canonical_f_14297);
} else
{elem_14281.attachEvent(cljs.core.name.call(null,actual_type_14295),canonical_f_14297);
}
{
var G__14298 = seq__14268_14290;
var G__14299 = chunk__14270_14291;
var G__14300 = count__14271_14292;
var G__14301 = (i__14272_14293 + (1));
seq__14268_14290 = G__14298;
chunk__14270_14291 = G__14299;
count__14271_14292 = G__14300;
i__14272_14293 = G__14301;
continue;
}
} else
{var temp__4126__auto___14302 = cljs.core.seq.call(null,seq__14268_14290);if(temp__4126__auto___14302)
{var seq__14268_14303__$1 = temp__4126__auto___14302;if(cljs.core.chunked_seq_QMARK_.call(null,seq__14268_14303__$1))
{var c__4418__auto___14304 = cljs.core.chunk_first.call(null,seq__14268_14303__$1);{
var G__14305 = cljs.core.chunk_rest.call(null,seq__14268_14303__$1);
var G__14306 = c__4418__auto___14304;
var G__14307 = cljs.core.count.call(null,c__4418__auto___14304);
var G__14308 = (0);
seq__14268_14290 = G__14305;
chunk__14270_14291 = G__14306;
count__14271_14292 = G__14307;
i__14272_14293 = G__14308;
continue;
}
} else
{var vec__14276_14309 = cljs.core.first.call(null,seq__14268_14303__$1);var actual_type_14310 = cljs.core.nth.call(null,vec__14276_14309,(0),null);var factory_14311 = cljs.core.nth.call(null,vec__14276_14309,(1),null);var canonical_f_14312 = (cljs.core.truth_(selector_14282)?cljs.core.partial.call(null,dommy.core.live_listener,elem_14281,selector_14282):cljs.core.identity).call(null,factory_14311.call(null,f_14289));dommy.core.update_event_listeners_BANG_.call(null,elem_14281,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_14282,actual_type_14310,f_14289], null),canonical_f_14312);
if(cljs.core.truth_(elem_14281.addEventListener))
{elem_14281.addEventListener(cljs.core.name.call(null,actual_type_14310),canonical_f_14312);
} else
{elem_14281.attachEvent(cljs.core.name.call(null,actual_type_14310),canonical_f_14312);
}
{
var G__14313 = cljs.core.next.call(null,seq__14268_14303__$1);
var G__14314 = null;
var G__14315 = (0);
var G__14316 = (0);
seq__14268_14290 = G__14313;
chunk__14270_14291 = G__14314;
count__14271_14292 = G__14315;
i__14272_14293 = G__14316;
continue;
}
}
} else
{}
}
break;
}
{
var G__14317 = seq__14258_14283;
var G__14318 = chunk__14265_14284;
var G__14319 = count__14266_14285;
var G__14320 = (i__14267_14286 + (1));
seq__14258_14283 = G__14317;
chunk__14265_14284 = G__14318;
count__14266_14285 = G__14319;
i__14267_14286 = G__14320;
continue;
}
} else
{var temp__4126__auto___14321 = cljs.core.seq.call(null,seq__14258_14283);if(temp__4126__auto___14321)
{var seq__14258_14322__$1 = temp__4126__auto___14321;if(cljs.core.chunked_seq_QMARK_.call(null,seq__14258_14322__$1))
{var c__4418__auto___14323 = cljs.core.chunk_first.call(null,seq__14258_14322__$1);{
var G__14324 = cljs.core.chunk_rest.call(null,seq__14258_14322__$1);
var G__14325 = c__4418__auto___14323;
var G__14326 = cljs.core.count.call(null,c__4418__auto___14323);
var G__14327 = (0);
seq__14258_14283 = G__14324;
chunk__14265_14284 = G__14325;
count__14266_14285 = G__14326;
i__14267_14286 = G__14327;
continue;
}
} else
{var vec__14277_14328 = cljs.core.first.call(null,seq__14258_14322__$1);var orig_type_14329 = cljs.core.nth.call(null,vec__14277_14328,(0),null);var f_14330 = cljs.core.nth.call(null,vec__14277_14328,(1),null);var seq__14259_14331 = cljs.core.seq.call(null,cljs.core.get.call(null,dommy.core.special_listener_makers,orig_type_14329,new cljs.core.PersistentArrayMap.fromArray([orig_type_14329,cljs.core.identity], true, false)));var chunk__14261_14332 = null;var count__14262_14333 = (0);var i__14263_14334 = (0);while(true){
if((i__14263_14334 < count__14262_14333))
{var vec__14278_14335 = cljs.core._nth.call(null,chunk__14261_14332,i__14263_14334);var actual_type_14336 = cljs.core.nth.call(null,vec__14278_14335,(0),null);var factory_14337 = cljs.core.nth.call(null,vec__14278_14335,(1),null);var canonical_f_14338 = (cljs.core.truth_(selector_14282)?cljs.core.partial.call(null,dommy.core.live_listener,elem_14281,selector_14282):cljs.core.identity).call(null,factory_14337.call(null,f_14330));dommy.core.update_event_listeners_BANG_.call(null,elem_14281,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_14282,actual_type_14336,f_14330], null),canonical_f_14338);
if(cljs.core.truth_(elem_14281.addEventListener))
{elem_14281.addEventListener(cljs.core.name.call(null,actual_type_14336),canonical_f_14338);
} else
{elem_14281.attachEvent(cljs.core.name.call(null,actual_type_14336),canonical_f_14338);
}
{
var G__14339 = seq__14259_14331;
var G__14340 = chunk__14261_14332;
var G__14341 = count__14262_14333;
var G__14342 = (i__14263_14334 + (1));
seq__14259_14331 = G__14339;
chunk__14261_14332 = G__14340;
count__14262_14333 = G__14341;
i__14263_14334 = G__14342;
continue;
}
} else
{var temp__4126__auto___14343__$1 = cljs.core.seq.call(null,seq__14259_14331);if(temp__4126__auto___14343__$1)
{var seq__14259_14344__$1 = temp__4126__auto___14343__$1;if(cljs.core.chunked_seq_QMARK_.call(null,seq__14259_14344__$1))
{var c__4418__auto___14345 = cljs.core.chunk_first.call(null,seq__14259_14344__$1);{
var G__14346 = cljs.core.chunk_rest.call(null,seq__14259_14344__$1);
var G__14347 = c__4418__auto___14345;
var G__14348 = cljs.core.count.call(null,c__4418__auto___14345);
var G__14349 = (0);
seq__14259_14331 = G__14346;
chunk__14261_14332 = G__14347;
count__14262_14333 = G__14348;
i__14263_14334 = G__14349;
continue;
}
} else
{var vec__14279_14350 = cljs.core.first.call(null,seq__14259_14344__$1);var actual_type_14351 = cljs.core.nth.call(null,vec__14279_14350,(0),null);var factory_14352 = cljs.core.nth.call(null,vec__14279_14350,(1),null);var canonical_f_14353 = (cljs.core.truth_(selector_14282)?cljs.core.partial.call(null,dommy.core.live_listener,elem_14281,selector_14282):cljs.core.identity).call(null,factory_14352.call(null,f_14330));dommy.core.update_event_listeners_BANG_.call(null,elem_14281,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_14282,actual_type_14351,f_14330], null),canonical_f_14353);
if(cljs.core.truth_(elem_14281.addEventListener))
{elem_14281.addEventListener(cljs.core.name.call(null,actual_type_14351),canonical_f_14353);
} else
{elem_14281.attachEvent(cljs.core.name.call(null,actual_type_14351),canonical_f_14353);
}
{
var G__14354 = cljs.core.next.call(null,seq__14259_14344__$1);
var G__14355 = null;
var G__14356 = (0);
var G__14357 = (0);
seq__14259_14331 = G__14354;
chunk__14261_14332 = G__14355;
count__14262_14333 = G__14356;
i__14263_14334 = G__14357;
continue;
}
}
} else
{}
}
break;
}
{
var G__14358 = cljs.core.next.call(null,seq__14258_14322__$1);
var G__14359 = null;
var G__14360 = (0);
var G__14361 = (0);
seq__14258_14283 = G__14358;
chunk__14265_14284 = G__14359;
count__14266_14285 = G__14360;
i__14267_14286 = G__14361;
continue;
}
}
} else
{}
}
break;
}
return elem_sel;
};
var listen_BANG_ = function (elem_sel,var_args){
var type_fs = null;if (arguments.length > 1) {
  type_fs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return listen_BANG___delegate.call(this,elem_sel,type_fs);};
listen_BANG_.cljs$lang$maxFixedArity = 1;
listen_BANG_.cljs$lang$applyTo = (function (arglist__14362){
var elem_sel = cljs.core.first(arglist__14362);
var type_fs = cljs.core.rest(arglist__14362);
return listen_BANG___delegate(elem_sel,type_fs);
});
listen_BANG_.cljs$core$IFn$_invoke$arity$variadic = listen_BANG___delegate;
return listen_BANG_;
})()
;
/**
* Removes event listener for the element defined in `elem-sel`,
* which is the same format as listen!.
* 
* The following forms are allowed, and will remove all handlers
* that match the parameters passed in:
* 
* (unlisten! [elem :.selector] :click event-listener)
* 
* (unlisten! [elem :.selector]
* :click event-listener
* :mouseover other-event-listener)
* @param {...*} var_args
*/
dommy.core.unlisten_BANG_ = (function() { 
var unlisten_BANG___delegate = function (elem_sel,type_fs){if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,type_fs)))
{} else
{throw (new Error(("Assert failed: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"type-fs","type-fs",1567896074,null))))))));
}
var vec__14386_14409 = dommy.core.elem_and_selector.call(null,elem_sel);var elem_14410 = cljs.core.nth.call(null,vec__14386_14409,(0),null);var selector_14411 = cljs.core.nth.call(null,vec__14386_14409,(1),null);var seq__14387_14412 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),type_fs));var chunk__14394_14413 = null;var count__14395_14414 = (0);var i__14396_14415 = (0);while(true){
if((i__14396_14415 < count__14395_14414))
{var vec__14403_14416 = cljs.core._nth.call(null,chunk__14394_14413,i__14396_14415);var orig_type_14417 = cljs.core.nth.call(null,vec__14403_14416,(0),null);var f_14418 = cljs.core.nth.call(null,vec__14403_14416,(1),null);var seq__14397_14419 = cljs.core.seq.call(null,cljs.core.get.call(null,dommy.core.special_listener_makers,orig_type_14417,new cljs.core.PersistentArrayMap.fromArray([orig_type_14417,cljs.core.identity], true, false)));var chunk__14399_14420 = null;var count__14400_14421 = (0);var i__14401_14422 = (0);while(true){
if((i__14401_14422 < count__14400_14421))
{var vec__14404_14423 = cljs.core._nth.call(null,chunk__14399_14420,i__14401_14422);var actual_type_14424 = cljs.core.nth.call(null,vec__14404_14423,(0),null);var __14425 = cljs.core.nth.call(null,vec__14404_14423,(1),null);var keys_14426 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_14411,actual_type_14424,f_14418], null);var canonical_f_14427 = cljs.core.get_in.call(null,dommy.core.event_listeners.call(null,elem_14410),keys_14426);dommy.core.update_event_listeners_BANG_.call(null,elem_14410,dommy.utils.dissoc_in,keys_14426);
if(cljs.core.truth_(elem_14410.removeEventListener))
{elem_14410.removeEventListener(cljs.core.name.call(null,actual_type_14424),canonical_f_14427);
} else
{elem_14410.detachEvent(cljs.core.name.call(null,actual_type_14424),canonical_f_14427);
}
{
var G__14428 = seq__14397_14419;
var G__14429 = chunk__14399_14420;
var G__14430 = count__14400_14421;
var G__14431 = (i__14401_14422 + (1));
seq__14397_14419 = G__14428;
chunk__14399_14420 = G__14429;
count__14400_14421 = G__14430;
i__14401_14422 = G__14431;
continue;
}
} else
{var temp__4126__auto___14432 = cljs.core.seq.call(null,seq__14397_14419);if(temp__4126__auto___14432)
{var seq__14397_14433__$1 = temp__4126__auto___14432;if(cljs.core.chunked_seq_QMARK_.call(null,seq__14397_14433__$1))
{var c__4418__auto___14434 = cljs.core.chunk_first.call(null,seq__14397_14433__$1);{
var G__14435 = cljs.core.chunk_rest.call(null,seq__14397_14433__$1);
var G__14436 = c__4418__auto___14434;
var G__14437 = cljs.core.count.call(null,c__4418__auto___14434);
var G__14438 = (0);
seq__14397_14419 = G__14435;
chunk__14399_14420 = G__14436;
count__14400_14421 = G__14437;
i__14401_14422 = G__14438;
continue;
}
} else
{var vec__14405_14439 = cljs.core.first.call(null,seq__14397_14433__$1);var actual_type_14440 = cljs.core.nth.call(null,vec__14405_14439,(0),null);var __14441 = cljs.core.nth.call(null,vec__14405_14439,(1),null);var keys_14442 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_14411,actual_type_14440,f_14418], null);var canonical_f_14443 = cljs.core.get_in.call(null,dommy.core.event_listeners.call(null,elem_14410),keys_14442);dommy.core.update_event_listeners_BANG_.call(null,elem_14410,dommy.utils.dissoc_in,keys_14442);
if(cljs.core.truth_(elem_14410.removeEventListener))
{elem_14410.removeEventListener(cljs.core.name.call(null,actual_type_14440),canonical_f_14443);
} else
{elem_14410.detachEvent(cljs.core.name.call(null,actual_type_14440),canonical_f_14443);
}
{
var G__14444 = cljs.core.next.call(null,seq__14397_14433__$1);
var G__14445 = null;
var G__14446 = (0);
var G__14447 = (0);
seq__14397_14419 = G__14444;
chunk__14399_14420 = G__14445;
count__14400_14421 = G__14446;
i__14401_14422 = G__14447;
continue;
}
}
} else
{}
}
break;
}
{
var G__14448 = seq__14387_14412;
var G__14449 = chunk__14394_14413;
var G__14450 = count__14395_14414;
var G__14451 = (i__14396_14415 + (1));
seq__14387_14412 = G__14448;
chunk__14394_14413 = G__14449;
count__14395_14414 = G__14450;
i__14396_14415 = G__14451;
continue;
}
} else
{var temp__4126__auto___14452 = cljs.core.seq.call(null,seq__14387_14412);if(temp__4126__auto___14452)
{var seq__14387_14453__$1 = temp__4126__auto___14452;if(cljs.core.chunked_seq_QMARK_.call(null,seq__14387_14453__$1))
{var c__4418__auto___14454 = cljs.core.chunk_first.call(null,seq__14387_14453__$1);{
var G__14455 = cljs.core.chunk_rest.call(null,seq__14387_14453__$1);
var G__14456 = c__4418__auto___14454;
var G__14457 = cljs.core.count.call(null,c__4418__auto___14454);
var G__14458 = (0);
seq__14387_14412 = G__14455;
chunk__14394_14413 = G__14456;
count__14395_14414 = G__14457;
i__14396_14415 = G__14458;
continue;
}
} else
{var vec__14406_14459 = cljs.core.first.call(null,seq__14387_14453__$1);var orig_type_14460 = cljs.core.nth.call(null,vec__14406_14459,(0),null);var f_14461 = cljs.core.nth.call(null,vec__14406_14459,(1),null);var seq__14388_14462 = cljs.core.seq.call(null,cljs.core.get.call(null,dommy.core.special_listener_makers,orig_type_14460,new cljs.core.PersistentArrayMap.fromArray([orig_type_14460,cljs.core.identity], true, false)));var chunk__14390_14463 = null;var count__14391_14464 = (0);var i__14392_14465 = (0);while(true){
if((i__14392_14465 < count__14391_14464))
{var vec__14407_14466 = cljs.core._nth.call(null,chunk__14390_14463,i__14392_14465);var actual_type_14467 = cljs.core.nth.call(null,vec__14407_14466,(0),null);var __14468 = cljs.core.nth.call(null,vec__14407_14466,(1),null);var keys_14469 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_14411,actual_type_14467,f_14461], null);var canonical_f_14470 = cljs.core.get_in.call(null,dommy.core.event_listeners.call(null,elem_14410),keys_14469);dommy.core.update_event_listeners_BANG_.call(null,elem_14410,dommy.utils.dissoc_in,keys_14469);
if(cljs.core.truth_(elem_14410.removeEventListener))
{elem_14410.removeEventListener(cljs.core.name.call(null,actual_type_14467),canonical_f_14470);
} else
{elem_14410.detachEvent(cljs.core.name.call(null,actual_type_14467),canonical_f_14470);
}
{
var G__14471 = seq__14388_14462;
var G__14472 = chunk__14390_14463;
var G__14473 = count__14391_14464;
var G__14474 = (i__14392_14465 + (1));
seq__14388_14462 = G__14471;
chunk__14390_14463 = G__14472;
count__14391_14464 = G__14473;
i__14392_14465 = G__14474;
continue;
}
} else
{var temp__4126__auto___14475__$1 = cljs.core.seq.call(null,seq__14388_14462);if(temp__4126__auto___14475__$1)
{var seq__14388_14476__$1 = temp__4126__auto___14475__$1;if(cljs.core.chunked_seq_QMARK_.call(null,seq__14388_14476__$1))
{var c__4418__auto___14477 = cljs.core.chunk_first.call(null,seq__14388_14476__$1);{
var G__14478 = cljs.core.chunk_rest.call(null,seq__14388_14476__$1);
var G__14479 = c__4418__auto___14477;
var G__14480 = cljs.core.count.call(null,c__4418__auto___14477);
var G__14481 = (0);
seq__14388_14462 = G__14478;
chunk__14390_14463 = G__14479;
count__14391_14464 = G__14480;
i__14392_14465 = G__14481;
continue;
}
} else
{var vec__14408_14482 = cljs.core.first.call(null,seq__14388_14476__$1);var actual_type_14483 = cljs.core.nth.call(null,vec__14408_14482,(0),null);var __14484 = cljs.core.nth.call(null,vec__14408_14482,(1),null);var keys_14485 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_14411,actual_type_14483,f_14461], null);var canonical_f_14486 = cljs.core.get_in.call(null,dommy.core.event_listeners.call(null,elem_14410),keys_14485);dommy.core.update_event_listeners_BANG_.call(null,elem_14410,dommy.utils.dissoc_in,keys_14485);
if(cljs.core.truth_(elem_14410.removeEventListener))
{elem_14410.removeEventListener(cljs.core.name.call(null,actual_type_14483),canonical_f_14486);
} else
{elem_14410.detachEvent(cljs.core.name.call(null,actual_type_14483),canonical_f_14486);
}
{
var G__14487 = cljs.core.next.call(null,seq__14388_14476__$1);
var G__14488 = null;
var G__14489 = (0);
var G__14490 = (0);
seq__14388_14462 = G__14487;
chunk__14390_14463 = G__14488;
count__14391_14464 = G__14489;
i__14392_14465 = G__14490;
continue;
}
}
} else
{}
}
break;
}
{
var G__14491 = cljs.core.next.call(null,seq__14387_14453__$1);
var G__14492 = null;
var G__14493 = (0);
var G__14494 = (0);
seq__14387_14412 = G__14491;
chunk__14394_14413 = G__14492;
count__14395_14414 = G__14493;
i__14396_14415 = G__14494;
continue;
}
}
} else
{}
}
break;
}
return elem_sel;
};
var unlisten_BANG_ = function (elem_sel,var_args){
var type_fs = null;if (arguments.length > 1) {
  type_fs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return unlisten_BANG___delegate.call(this,elem_sel,type_fs);};
unlisten_BANG_.cljs$lang$maxFixedArity = 1;
unlisten_BANG_.cljs$lang$applyTo = (function (arglist__14495){
var elem_sel = cljs.core.first(arglist__14495);
var type_fs = cljs.core.rest(arglist__14495);
return unlisten_BANG___delegate(elem_sel,type_fs);
});
unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic = unlisten_BANG___delegate;
return unlisten_BANG_;
})()
;
/**
* Behaves like `listen!`, but removes the listener after the first event occurs.
* @param {...*} var_args
*/
dommy.core.listen_once_BANG_ = (function() { 
var listen_once_BANG___delegate = function (elem_sel,type_fs){if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,type_fs)))
{} else
{throw (new Error(("Assert failed: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"type-fs","type-fs",1567896074,null))))))));
}
var vec__14503_14510 = dommy.core.elem_and_selector.call(null,elem_sel);var elem_14511 = cljs.core.nth.call(null,vec__14503_14510,(0),null);var selector_14512 = cljs.core.nth.call(null,vec__14503_14510,(1),null);var seq__14504_14513 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),type_fs));var chunk__14505_14514 = null;var count__14506_14515 = (0);var i__14507_14516 = (0);while(true){
if((i__14507_14516 < count__14506_14515))
{var vec__14508_14517 = cljs.core._nth.call(null,chunk__14505_14514,i__14507_14516);var type_14518 = cljs.core.nth.call(null,vec__14508_14517,(0),null);var f_14519 = cljs.core.nth.call(null,vec__14508_14517,(1),null);dommy.core.listen_BANG_.call(null,elem_sel,type_14518,((function (seq__14504_14513,chunk__14505_14514,count__14506_14515,i__14507_14516,vec__14508_14517,type_14518,f_14519,vec__14503_14510,elem_14511,selector_14512){
return (function this_fn(e){dommy.core.unlisten_BANG_.call(null,elem_sel,type_14518,this_fn);
return f_14519.call(null,e);
});})(seq__14504_14513,chunk__14505_14514,count__14506_14515,i__14507_14516,vec__14508_14517,type_14518,f_14519,vec__14503_14510,elem_14511,selector_14512))
);
{
var G__14520 = seq__14504_14513;
var G__14521 = chunk__14505_14514;
var G__14522 = count__14506_14515;
var G__14523 = (i__14507_14516 + (1));
seq__14504_14513 = G__14520;
chunk__14505_14514 = G__14521;
count__14506_14515 = G__14522;
i__14507_14516 = G__14523;
continue;
}
} else
{var temp__4126__auto___14524 = cljs.core.seq.call(null,seq__14504_14513);if(temp__4126__auto___14524)
{var seq__14504_14525__$1 = temp__4126__auto___14524;if(cljs.core.chunked_seq_QMARK_.call(null,seq__14504_14525__$1))
{var c__4418__auto___14526 = cljs.core.chunk_first.call(null,seq__14504_14525__$1);{
var G__14527 = cljs.core.chunk_rest.call(null,seq__14504_14525__$1);
var G__14528 = c__4418__auto___14526;
var G__14529 = cljs.core.count.call(null,c__4418__auto___14526);
var G__14530 = (0);
seq__14504_14513 = G__14527;
chunk__14505_14514 = G__14528;
count__14506_14515 = G__14529;
i__14507_14516 = G__14530;
continue;
}
} else
{var vec__14509_14531 = cljs.core.first.call(null,seq__14504_14525__$1);var type_14532 = cljs.core.nth.call(null,vec__14509_14531,(0),null);var f_14533 = cljs.core.nth.call(null,vec__14509_14531,(1),null);dommy.core.listen_BANG_.call(null,elem_sel,type_14532,((function (seq__14504_14513,chunk__14505_14514,count__14506_14515,i__14507_14516,vec__14509_14531,type_14532,f_14533,seq__14504_14525__$1,temp__4126__auto___14524,vec__14503_14510,elem_14511,selector_14512){
return (function this_fn(e){dommy.core.unlisten_BANG_.call(null,elem_sel,type_14532,this_fn);
return f_14533.call(null,e);
});})(seq__14504_14513,chunk__14505_14514,count__14506_14515,i__14507_14516,vec__14509_14531,type_14532,f_14533,seq__14504_14525__$1,temp__4126__auto___14524,vec__14503_14510,elem_14511,selector_14512))
);
{
var G__14534 = cljs.core.next.call(null,seq__14504_14525__$1);
var G__14535 = null;
var G__14536 = (0);
var G__14537 = (0);
seq__14504_14513 = G__14534;
chunk__14505_14514 = G__14535;
count__14506_14515 = G__14536;
i__14507_14516 = G__14537;
continue;
}
}
} else
{}
}
break;
}
return elem_sel;
};
var listen_once_BANG_ = function (elem_sel,var_args){
var type_fs = null;if (arguments.length > 1) {
  type_fs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return listen_once_BANG___delegate.call(this,elem_sel,type_fs);};
listen_once_BANG_.cljs$lang$maxFixedArity = 1;
listen_once_BANG_.cljs$lang$applyTo = (function (arglist__14538){
var elem_sel = cljs.core.first(arglist__14538);
var type_fs = cljs.core.rest(arglist__14538);
return listen_once_BANG___delegate(elem_sel,type_fs);
});
listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic = listen_once_BANG___delegate;
return listen_once_BANG_;
})()
;
