// Compiled by ClojureScript 0.0-2371
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function fn_handler(f){if(typeof cljs.core.async.t10692 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t10692 = (function (f,fn_handler,meta10693){
this.f = f;
this.fn_handler = fn_handler;
this.meta10693 = meta10693;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t10692.cljs$lang$type = true;
cljs.core.async.t10692.cljs$lang$ctorStr = "cljs.core.async/t10692";
cljs.core.async.t10692.cljs$lang$ctorPrWriter = (function (this__4225__auto__,writer__4226__auto__,opt__4227__auto__){return cljs.core._write.call(null,writer__4226__auto__,"cljs.core.async/t10692");
});
cljs.core.async.t10692.prototype.cljs$core$async$impl$protocols$Handler$ = true;
cljs.core.async.t10692.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return true;
});
cljs.core.async.t10692.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return self__.f;
});
cljs.core.async.t10692.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_10694){var self__ = this;
var _10694__$1 = this;return self__.meta10693;
});
cljs.core.async.t10692.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_10694,meta10693__$1){var self__ = this;
var _10694__$1 = this;return (new cljs.core.async.t10692(self__.f,self__.fn_handler,meta10693__$1));
});
cljs.core.async.__GT_t10692 = (function __GT_t10692(f__$1,fn_handler__$1,meta10693){return (new cljs.core.async.t10692(f__$1,fn_handler__$1,meta10693));
});
}
return (new cljs.core.async.t10692(f,fn_handler,null));
});
/**
* Returns a fixed buffer of size n. When full, puts will block/park.
*/
cljs.core.async.buffer = (function buffer(n){return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
* Returns a buffer of size n. When full, puts will complete but
* val will be dropped (no transfer).
*/
cljs.core.async.dropping_buffer = (function dropping_buffer(n){return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
* Returns a buffer of size n. When full, puts will complete, and be
* buffered, but oldest elements in buffer will be dropped (not
* transferred).
*/
cljs.core.async.sliding_buffer = (function sliding_buffer(n){return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
* Returns true if a channel created with buff will never block. That is to say,
* puts into this buffer will never cause the buffer to be full.
*/
cljs.core.async.unblocking_buffer_QMARK_ = (function unblocking_buffer_QMARK_(buff){var G__10696 = buff;if(G__10696)
{var bit__4312__auto__ = null;if(cljs.core.truth_((function (){var or__3648__auto__ = bit__4312__auto__;if(cljs.core.truth_(or__3648__auto__))
{return or__3648__auto__;
} else
{return G__10696.cljs$core$async$impl$protocols$UnblockingBuffer$;
}
})()))
{return true;
} else
{if((!G__10696.cljs$lang$protocol_mask$partition$))
{return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,G__10696);
} else
{return false;
}
}
} else
{return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,G__10696);
}
});
/**
* Creates a channel with an optional buffer, an optional transducer (like (map f),
* (filter p) etc or a composition thereof), and an optional exception handler.
* If buf-or-n is a number, will create and use a fixed buffer of that size. If a
* transducer is supplied a buffer must be specified. ex-handler must be a
* fn of one argument - if an exception occurs during transformation it will be called
* with the thrown value as an argument, and any non-nil return value will be placed
* in the channel.
*/
cljs.core.async.chan = (function() {
var chan = null;
var chan__0 = (function (){return chan.call(null,null);
});
var chan__1 = (function (buf_or_n){return chan.call(null,buf_or_n,null,null);
});
var chan__2 = (function (buf_or_n,xform){return chan.call(null,buf_or_n,xform,null);
});
var chan__3 = (function (buf_or_n,xform,ex_handler){var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);if(cljs.core.truth_(xform))
{if(cljs.core.truth_(buf_or_n__$1))
{} else
{throw (new Error(("Assert failed: buffer must be supplied when transducer is\n"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null))))));
}
} else
{}
return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});
chan = function(buf_or_n,xform,ex_handler){
switch(arguments.length){
case 0:
return chan__0.call(this);
case 1:
return chan__1.call(this,buf_or_n);
case 2:
return chan__2.call(this,buf_or_n,xform);
case 3:
return chan__3.call(this,buf_or_n,xform,ex_handler);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
chan.cljs$core$IFn$_invoke$arity$0 = chan__0;
chan.cljs$core$IFn$_invoke$arity$1 = chan__1;
chan.cljs$core$IFn$_invoke$arity$2 = chan__2;
chan.cljs$core$IFn$_invoke$arity$3 = chan__3;
return chan;
})()
;
/**
* Returns a channel that will close after msecs
*/
cljs.core.async.timeout = (function timeout(msecs){return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
* takes a val from port. Must be called inside a (go ...) block. Will
* return nil if closed. Will park if nothing is available.
* Returns true unless port is already closed
*/
cljs.core.async._LT__BANG_ = (function _LT__BANG_(port){throw (new Error("<! used not in (go ...) block"));
});
/**
* Asynchronously takes a val from port, passing to fn1. Will pass nil
* if closed. If on-caller? (default true) is true, and value is
* immediately available, will call fn1 on calling thread.
* Returns nil.
*/
cljs.core.async.take_BANG_ = (function() {
var take_BANG_ = null;
var take_BANG___2 = (function (port,fn1){return take_BANG_.call(null,port,fn1,true);
});
var take_BANG___3 = (function (port,fn1,on_caller_QMARK_){var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));if(cljs.core.truth_(ret))
{var val_10697 = cljs.core.deref.call(null,ret);if(cljs.core.truth_(on_caller_QMARK_))
{fn1.call(null,val_10697);
} else
{cljs.core.async.impl.dispatch.run.call(null,((function (val_10697,ret){
return (function (){return fn1.call(null,val_10697);
});})(val_10697,ret))
);
}
} else
{}
return null;
});
take_BANG_ = function(port,fn1,on_caller_QMARK_){
switch(arguments.length){
case 2:
return take_BANG___2.call(this,port,fn1);
case 3:
return take_BANG___3.call(this,port,fn1,on_caller_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
take_BANG_.cljs$core$IFn$_invoke$arity$2 = take_BANG___2;
take_BANG_.cljs$core$IFn$_invoke$arity$3 = take_BANG___3;
return take_BANG_;
})()
;
cljs.core.async.nop = (function nop(_){return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
* puts a val into port. nil values are not allowed. Must be called
* inside a (go ...) block. Will park if no buffer space is available.
* Returns true unless port is already closed.
*/
cljs.core.async._GT__BANG_ = (function _GT__BANG_(port,val){throw (new Error(">! used not in (go ...) block"));
});
/**
* Asynchronously puts a val into port, calling fn0 (if supplied) when
* complete. nil values are not allowed. Will throw if closed. If
* on-caller? (default true) is true, and the put is immediately
* accepted, will call fn0 on calling thread.  Returns nil.
*/
cljs.core.async.put_BANG_ = (function() {
var put_BANG_ = null;
var put_BANG___2 = (function (port,val){var temp__4124__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);if(cljs.core.truth_(temp__4124__auto__))
{var ret = temp__4124__auto__;return cljs.core.deref.call(null,ret);
} else
{return true;
}
});
var put_BANG___3 = (function (port,val,fn1){return put_BANG_.call(null,port,val,fn1,true);
});
var put_BANG___4 = (function (port,val,fn1,on_caller_QMARK_){var temp__4124__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));if(cljs.core.truth_(temp__4124__auto__))
{var retb = temp__4124__auto__;var ret = cljs.core.deref.call(null,retb);if(cljs.core.truth_(on_caller_QMARK_))
{fn1.call(null,ret);
} else
{cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4124__auto__){
return (function (){return fn1.call(null,ret);
});})(ret,retb,temp__4124__auto__))
);
}
return ret;
} else
{return true;
}
});
put_BANG_ = function(port,val,fn1,on_caller_QMARK_){
switch(arguments.length){
case 2:
return put_BANG___2.call(this,port,val);
case 3:
return put_BANG___3.call(this,port,val,fn1);
case 4:
return put_BANG___4.call(this,port,val,fn1,on_caller_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
put_BANG_.cljs$core$IFn$_invoke$arity$2 = put_BANG___2;
put_BANG_.cljs$core$IFn$_invoke$arity$3 = put_BANG___3;
put_BANG_.cljs$core$IFn$_invoke$arity$4 = put_BANG___4;
return put_BANG_;
})()
;
cljs.core.async.close_BANG_ = (function close_BANG_(port){return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function random_array(n){var a = (new Array(n));var n__4518__auto___10698 = n;var x_10699 = (0);while(true){
if((x_10699 < n__4518__auto___10698))
{(a[x_10699] = (0));
{
var G__10700 = (x_10699 + (1));
x_10699 = G__10700;
continue;
}
} else
{}
break;
}
var i = (1);while(true){
if(cljs.core._EQ_.call(null,i,n))
{return a;
} else
{var j = cljs.core.rand_int.call(null,i);(a[i] = (a[j]));
(a[j] = i);
{
var G__10701 = (i + (1));
i = G__10701;
continue;
}
}
break;
}
});
cljs.core.async.alt_flag = (function alt_flag(){var flag = cljs.core.atom.call(null,true);if(typeof cljs.core.async.t10705 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t10705 = (function (flag,alt_flag,meta10706){
this.flag = flag;
this.alt_flag = alt_flag;
this.meta10706 = meta10706;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t10705.cljs$lang$type = true;
cljs.core.async.t10705.cljs$lang$ctorStr = "cljs.core.async/t10705";
cljs.core.async.t10705.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__4225__auto__,writer__4226__auto__,opt__4227__auto__){return cljs.core._write.call(null,writer__4226__auto__,"cljs.core.async/t10705");
});})(flag))
;
cljs.core.async.t10705.prototype.cljs$core$async$impl$protocols$Handler$ = true;
cljs.core.async.t10705.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){var self__ = this;
var ___$1 = this;return cljs.core.deref.call(null,self__.flag);
});})(flag))
;
cljs.core.async.t10705.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){var self__ = this;
var ___$1 = this;cljs.core.reset_BANG_.call(null,self__.flag,null);
return true;
});})(flag))
;
cljs.core.async.t10705.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_10707){var self__ = this;
var _10707__$1 = this;return self__.meta10706;
});})(flag))
;
cljs.core.async.t10705.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_10707,meta10706__$1){var self__ = this;
var _10707__$1 = this;return (new cljs.core.async.t10705(self__.flag,self__.alt_flag,meta10706__$1));
});})(flag))
;
cljs.core.async.__GT_t10705 = ((function (flag){
return (function __GT_t10705(flag__$1,alt_flag__$1,meta10706){return (new cljs.core.async.t10705(flag__$1,alt_flag__$1,meta10706));
});})(flag))
;
}
return (new cljs.core.async.t10705(flag,alt_flag,null));
});
cljs.core.async.alt_handler = (function alt_handler(flag,cb){if(typeof cljs.core.async.t10711 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t10711 = (function (cb,flag,alt_handler,meta10712){
this.cb = cb;
this.flag = flag;
this.alt_handler = alt_handler;
this.meta10712 = meta10712;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t10711.cljs$lang$type = true;
cljs.core.async.t10711.cljs$lang$ctorStr = "cljs.core.async/t10711";
cljs.core.async.t10711.cljs$lang$ctorPrWriter = (function (this__4225__auto__,writer__4226__auto__,opt__4227__auto__){return cljs.core._write.call(null,writer__4226__auto__,"cljs.core.async/t10711");
});
cljs.core.async.t10711.prototype.cljs$core$async$impl$protocols$Handler$ = true;
cljs.core.async.t10711.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});
cljs.core.async.t10711.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){var self__ = this;
var ___$1 = this;cljs.core.async.impl.protocols.commit.call(null,self__.flag);
return self__.cb;
});
cljs.core.async.t10711.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_10713){var self__ = this;
var _10713__$1 = this;return self__.meta10712;
});
cljs.core.async.t10711.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_10713,meta10712__$1){var self__ = this;
var _10713__$1 = this;return (new cljs.core.async.t10711(self__.cb,self__.flag,self__.alt_handler,meta10712__$1));
});
cljs.core.async.__GT_t10711 = (function __GT_t10711(cb__$1,flag__$1,alt_handler__$1,meta10712){return (new cljs.core.async.t10711(cb__$1,flag__$1,alt_handler__$1,meta10712));
});
}
return (new cljs.core.async.t10711(cb,flag,alt_handler,null));
});
/**
* returns derefable [val port] if immediate, nil if enqueued
*/
cljs.core.async.do_alts = (function do_alts(fret,ports,opts){var flag = cljs.core.async.alt_flag.call(null);var n = cljs.core.count.call(null,ports);var idxs = cljs.core.async.random_array.call(null,n);var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);var ret = (function (){var i = (0);while(true){
if((i < n))
{var idx = (cljs.core.truth_(priority)?i:(idxs[i]));var port = cljs.core.nth.call(null,ports,idx);var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__10714_SHARP_){return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__10714_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__10715_SHARP_){return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__10715_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));if(cljs.core.truth_(vbox))
{return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__3648__auto__ = wport;if(cljs.core.truth_(or__3648__auto__))
{return or__3648__auto__;
} else
{return port;
}
})()], null));
} else
{{
var G__10716 = (i + (1));
i = G__10716;
continue;
}
}
} else
{return null;
}
break;
}
})();var or__3648__auto__ = ret;if(cljs.core.truth_(or__3648__auto__))
{return or__3648__auto__;
} else
{if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328)))
{var temp__4126__auto__ = (function (){var and__3636__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);if(cljs.core.truth_(and__3636__auto__))
{return cljs.core.async.impl.protocols.commit.call(null,flag);
} else
{return and__3636__auto__;
}
})();if(cljs.core.truth_(temp__4126__auto__))
{var got = temp__4126__auto__;return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else
{return null;
}
} else
{return null;
}
}
});
/**
* Completes at most one of several channel operations. Must be called
* inside a (go ...) block. ports is a vector of channel endpoints,
* which can be either a channel to take from or a vector of
* [channel-to-put-to val-to-put], in any combination. Takes will be
* made as if by <!, and puts will be made as if by >!. Unless
* the :priority option is true, if more than one port operation is
* ready a non-deterministic choice will be made. If no operation is
* ready and a :default value is supplied, [default-val :default] will
* be returned, otherwise alts! will park until the first operation to
* become ready completes. Returns [val port] of the completed
* operation, where val is the value taken for takes, and a
* boolean (true unless already closed, as per put!) for puts.
* 
* opts are passed as :key val ... Supported options:
* 
* :default val - the value to use if none of the operations are immediately ready
* :priority true - (default nil) when true, the operations will be tried in order.
* 
* Note: there is no guarantee that the port exps or val exprs will be
* used, nor in what order should they be, so they should not be
* depended upon for side effects.
* @param {...*} var_args
*/
cljs.core.async.alts_BANG_ = (function() { 
var alts_BANG___delegate = function (ports,p__10717){var map__10719 = p__10717;var map__10719__$1 = ((cljs.core.seq_QMARK_.call(null,map__10719))?cljs.core.apply.call(null,cljs.core.hash_map,map__10719):map__10719);var opts = map__10719__$1;throw (new Error("alts! used not in (go ...) block"));
};
var alts_BANG_ = function (ports,var_args){
var p__10717 = null;if (arguments.length > 1) {
  p__10717 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return alts_BANG___delegate.call(this,ports,p__10717);};
alts_BANG_.cljs$lang$maxFixedArity = 1;
alts_BANG_.cljs$lang$applyTo = (function (arglist__10720){
var ports = cljs.core.first(arglist__10720);
var p__10717 = cljs.core.rest(arglist__10720);
return alts_BANG___delegate(ports,p__10717);
});
alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = alts_BANG___delegate;
return alts_BANG_;
})()
;
/**
* Takes elements from the from channel and supplies them to the to
* channel. By default, the to channel will be closed when the from
* channel closes, but can be determined by the close?  parameter. Will
* stop consuming the from channel if the to channel closes
*/
cljs.core.async.pipe = (function() {
var pipe = null;
var pipe__2 = (function (from,to){return pipe.call(null,from,to,true);
});
var pipe__3 = (function (from,to,close_QMARK_){var c__5915__auto___10815 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto___10815){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto___10815){
return (function (state_10791){var state_val_10792 = (state_10791[(1)]);if((state_val_10792 === (7)))
{var inst_10787 = (state_10791[(2)]);var state_10791__$1 = state_10791;var statearr_10793_10816 = state_10791__$1;(statearr_10793_10816[(2)] = inst_10787);
(statearr_10793_10816[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_10792 === (1)))
{var state_10791__$1 = state_10791;var statearr_10794_10817 = state_10791__$1;(statearr_10794_10817[(2)] = null);
(statearr_10794_10817[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_10792 === (4)))
{var inst_10770 = (state_10791[(7)]);var inst_10770__$1 = (state_10791[(2)]);var inst_10771 = (inst_10770__$1 == null);var state_10791__$1 = (function (){var statearr_10795 = state_10791;(statearr_10795[(7)] = inst_10770__$1);
return statearr_10795;
})();if(cljs.core.truth_(inst_10771))
{var statearr_10796_10818 = state_10791__$1;(statearr_10796_10818[(1)] = (5));
} else
{var statearr_10797_10819 = state_10791__$1;(statearr_10797_10819[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_10792 === (13)))
{var state_10791__$1 = state_10791;var statearr_10798_10820 = state_10791__$1;(statearr_10798_10820[(2)] = null);
(statearr_10798_10820[(1)] = (14));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_10792 === (6)))
{var inst_10770 = (state_10791[(7)]);var state_10791__$1 = state_10791;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10791__$1,(11),to,inst_10770);
} else
{if((state_val_10792 === (3)))
{var inst_10789 = (state_10791[(2)]);var state_10791__$1 = state_10791;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10791__$1,inst_10789);
} else
{if((state_val_10792 === (12)))
{var state_10791__$1 = state_10791;var statearr_10799_10821 = state_10791__$1;(statearr_10799_10821[(2)] = null);
(statearr_10799_10821[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_10792 === (2)))
{var state_10791__$1 = state_10791;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_10791__$1,(4),from);
} else
{if((state_val_10792 === (11)))
{var inst_10780 = (state_10791[(2)]);var state_10791__$1 = state_10791;if(cljs.core.truth_(inst_10780))
{var statearr_10800_10822 = state_10791__$1;(statearr_10800_10822[(1)] = (12));
} else
{var statearr_10801_10823 = state_10791__$1;(statearr_10801_10823[(1)] = (13));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_10792 === (9)))
{var state_10791__$1 = state_10791;var statearr_10802_10824 = state_10791__$1;(statearr_10802_10824[(2)] = null);
(statearr_10802_10824[(1)] = (10));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_10792 === (5)))
{var state_10791__$1 = state_10791;if(cljs.core.truth_(close_QMARK_))
{var statearr_10803_10825 = state_10791__$1;(statearr_10803_10825[(1)] = (8));
} else
{var statearr_10804_10826 = state_10791__$1;(statearr_10804_10826[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_10792 === (14)))
{var inst_10785 = (state_10791[(2)]);var state_10791__$1 = state_10791;var statearr_10805_10827 = state_10791__$1;(statearr_10805_10827[(2)] = inst_10785);
(statearr_10805_10827[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_10792 === (10)))
{var inst_10777 = (state_10791[(2)]);var state_10791__$1 = state_10791;var statearr_10806_10828 = state_10791__$1;(statearr_10806_10828[(2)] = inst_10777);
(statearr_10806_10828[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_10792 === (8)))
{var inst_10774 = cljs.core.async.close_BANG_.call(null,to);var state_10791__$1 = state_10791;var statearr_10807_10829 = state_10791__$1;(statearr_10807_10829[(2)] = inst_10774);
(statearr_10807_10829[(1)] = (10));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__5915__auto___10815))
;return ((function (switch__5900__auto__,c__5915__auto___10815){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_10811 = [null,null,null,null,null,null,null,null];(statearr_10811[(0)] = state_machine__5901__auto__);
(statearr_10811[(1)] = (1));
return statearr_10811;
});
var state_machine__5901__auto____1 = (function (state_10791){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_10791);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e10812){if((e10812 instanceof Object))
{var ex__5904__auto__ = e10812;var statearr_10813_10830 = state_10791;(statearr_10813_10830[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10791);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e10812;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__10831 = state_10791;
state_10791 = G__10831;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_10791){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_10791);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto___10815))
})();var state__5917__auto__ = (function (){var statearr_10814 = f__5916__auto__.call(null);(statearr_10814[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto___10815);
return statearr_10814;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto___10815))
);
return to;
});
pipe = function(from,to,close_QMARK_){
switch(arguments.length){
case 2:
return pipe__2.call(this,from,to);
case 3:
return pipe__3.call(this,from,to,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pipe.cljs$core$IFn$_invoke$arity$2 = pipe__2;
pipe.cljs$core$IFn$_invoke$arity$3 = pipe__3;
return pipe;
})()
;
cljs.core.async.pipeline_STAR_ = (function pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){if((n > (0)))
{} else
{throw (new Error(("Assert failed: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)))))));
}
var jobs = cljs.core.async.chan.call(null,n);var results = cljs.core.async.chan.call(null,n);var process = ((function (jobs,results){
return (function (p__11015){var vec__11016 = p__11015;var v = cljs.core.nth.call(null,vec__11016,(0),null);var p = cljs.core.nth.call(null,vec__11016,(1),null);var job = vec__11016;if((job == null))
{cljs.core.async.close_BANG_.call(null,results);
return null;
} else
{var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);var c__5915__auto___11198 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto___11198,res,vec__11016,v,p,job,jobs,results){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto___11198,res,vec__11016,v,p,job,jobs,results){
return (function (state_11021){var state_val_11022 = (state_11021[(1)]);if((state_val_11022 === (2)))
{var inst_11018 = (state_11021[(2)]);var inst_11019 = cljs.core.async.close_BANG_.call(null,res);var state_11021__$1 = (function (){var statearr_11023 = state_11021;(statearr_11023[(7)] = inst_11018);
return statearr_11023;
})();return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11021__$1,inst_11019);
} else
{if((state_val_11022 === (1)))
{var state_11021__$1 = state_11021;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11021__$1,(2),res,v);
} else
{return null;
}
}
});})(c__5915__auto___11198,res,vec__11016,v,p,job,jobs,results))
;return ((function (switch__5900__auto__,c__5915__auto___11198,res,vec__11016,v,p,job,jobs,results){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_11027 = [null,null,null,null,null,null,null,null];(statearr_11027[(0)] = state_machine__5901__auto__);
(statearr_11027[(1)] = (1));
return statearr_11027;
});
var state_machine__5901__auto____1 = (function (state_11021){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_11021);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e11028){if((e11028 instanceof Object))
{var ex__5904__auto__ = e11028;var statearr_11029_11199 = state_11021;(statearr_11029_11199[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11021);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e11028;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__11200 = state_11021;
state_11021 = G__11200;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_11021){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_11021);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto___11198,res,vec__11016,v,p,job,jobs,results))
})();var state__5917__auto__ = (function (){var statearr_11030 = f__5916__auto__.call(null);(statearr_11030[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto___11198);
return statearr_11030;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto___11198,res,vec__11016,v,p,job,jobs,results))
);
cljs.core.async.put_BANG_.call(null,p,res);
return true;
}
});})(jobs,results))
;var async = ((function (jobs,results,process){
return (function (p__11031){var vec__11032 = p__11031;var v = cljs.core.nth.call(null,vec__11032,(0),null);var p = cljs.core.nth.call(null,vec__11032,(1),null);var job = vec__11032;if((job == null))
{cljs.core.async.close_BANG_.call(null,results);
return null;
} else
{var res = cljs.core.async.chan.call(null,(1));xf.call(null,v,res);
cljs.core.async.put_BANG_.call(null,p,res);
return true;
}
});})(jobs,results,process))
;var n__4518__auto___11201 = n;var __11202 = (0);while(true){
if((__11202 < n__4518__auto___11201))
{var G__11033_11203 = (((type instanceof cljs.core.Keyword))?type.fqn:null);switch (G__11033_11203) {
case "async":
var c__5915__auto___11205 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (__11202,c__5915__auto___11205,G__11033_11203,n__4518__auto___11201,jobs,results,process,async){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (__11202,c__5915__auto___11205,G__11033_11203,n__4518__auto___11201,jobs,results,process,async){
return (function (state_11046){var state_val_11047 = (state_11046[(1)]);if((state_val_11047 === (7)))
{var inst_11042 = (state_11046[(2)]);var state_11046__$1 = state_11046;var statearr_11048_11206 = state_11046__$1;(statearr_11048_11206[(2)] = inst_11042);
(statearr_11048_11206[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11047 === (6)))
{var state_11046__$1 = state_11046;var statearr_11049_11207 = state_11046__$1;(statearr_11049_11207[(2)] = null);
(statearr_11049_11207[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11047 === (5)))
{var state_11046__$1 = state_11046;var statearr_11050_11208 = state_11046__$1;(statearr_11050_11208[(2)] = null);
(statearr_11050_11208[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11047 === (4)))
{var inst_11036 = (state_11046[(2)]);var inst_11037 = async.call(null,inst_11036);var state_11046__$1 = state_11046;if(cljs.core.truth_(inst_11037))
{var statearr_11051_11209 = state_11046__$1;(statearr_11051_11209[(1)] = (5));
} else
{var statearr_11052_11210 = state_11046__$1;(statearr_11052_11210[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11047 === (3)))
{var inst_11044 = (state_11046[(2)]);var state_11046__$1 = state_11046;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11046__$1,inst_11044);
} else
{if((state_val_11047 === (2)))
{var state_11046__$1 = state_11046;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11046__$1,(4),jobs);
} else
{if((state_val_11047 === (1)))
{var state_11046__$1 = state_11046;var statearr_11053_11211 = state_11046__$1;(statearr_11053_11211[(2)] = null);
(statearr_11053_11211[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
});})(__11202,c__5915__auto___11205,G__11033_11203,n__4518__auto___11201,jobs,results,process,async))
;return ((function (__11202,switch__5900__auto__,c__5915__auto___11205,G__11033_11203,n__4518__auto___11201,jobs,results,process,async){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_11057 = [null,null,null,null,null,null,null];(statearr_11057[(0)] = state_machine__5901__auto__);
(statearr_11057[(1)] = (1));
return statearr_11057;
});
var state_machine__5901__auto____1 = (function (state_11046){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_11046);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e11058){if((e11058 instanceof Object))
{var ex__5904__auto__ = e11058;var statearr_11059_11212 = state_11046;(statearr_11059_11212[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11046);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e11058;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__11213 = state_11046;
state_11046 = G__11213;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_11046){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_11046);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(__11202,switch__5900__auto__,c__5915__auto___11205,G__11033_11203,n__4518__auto___11201,jobs,results,process,async))
})();var state__5917__auto__ = (function (){var statearr_11060 = f__5916__auto__.call(null);(statearr_11060[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto___11205);
return statearr_11060;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(__11202,c__5915__auto___11205,G__11033_11203,n__4518__auto___11201,jobs,results,process,async))
);

break;
case "compute":
var c__5915__auto___11214 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (__11202,c__5915__auto___11214,G__11033_11203,n__4518__auto___11201,jobs,results,process,async){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (__11202,c__5915__auto___11214,G__11033_11203,n__4518__auto___11201,jobs,results,process,async){
return (function (state_11073){var state_val_11074 = (state_11073[(1)]);if((state_val_11074 === (7)))
{var inst_11069 = (state_11073[(2)]);var state_11073__$1 = state_11073;var statearr_11075_11215 = state_11073__$1;(statearr_11075_11215[(2)] = inst_11069);
(statearr_11075_11215[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11074 === (6)))
{var state_11073__$1 = state_11073;var statearr_11076_11216 = state_11073__$1;(statearr_11076_11216[(2)] = null);
(statearr_11076_11216[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11074 === (5)))
{var state_11073__$1 = state_11073;var statearr_11077_11217 = state_11073__$1;(statearr_11077_11217[(2)] = null);
(statearr_11077_11217[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11074 === (4)))
{var inst_11063 = (state_11073[(2)]);var inst_11064 = process.call(null,inst_11063);var state_11073__$1 = state_11073;if(cljs.core.truth_(inst_11064))
{var statearr_11078_11218 = state_11073__$1;(statearr_11078_11218[(1)] = (5));
} else
{var statearr_11079_11219 = state_11073__$1;(statearr_11079_11219[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11074 === (3)))
{var inst_11071 = (state_11073[(2)]);var state_11073__$1 = state_11073;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11073__$1,inst_11071);
} else
{if((state_val_11074 === (2)))
{var state_11073__$1 = state_11073;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11073__$1,(4),jobs);
} else
{if((state_val_11074 === (1)))
{var state_11073__$1 = state_11073;var statearr_11080_11220 = state_11073__$1;(statearr_11080_11220[(2)] = null);
(statearr_11080_11220[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
});})(__11202,c__5915__auto___11214,G__11033_11203,n__4518__auto___11201,jobs,results,process,async))
;return ((function (__11202,switch__5900__auto__,c__5915__auto___11214,G__11033_11203,n__4518__auto___11201,jobs,results,process,async){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_11084 = [null,null,null,null,null,null,null];(statearr_11084[(0)] = state_machine__5901__auto__);
(statearr_11084[(1)] = (1));
return statearr_11084;
});
var state_machine__5901__auto____1 = (function (state_11073){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_11073);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e11085){if((e11085 instanceof Object))
{var ex__5904__auto__ = e11085;var statearr_11086_11221 = state_11073;(statearr_11086_11221[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11073);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e11085;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__11222 = state_11073;
state_11073 = G__11222;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_11073){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_11073);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(__11202,switch__5900__auto__,c__5915__auto___11214,G__11033_11203,n__4518__auto___11201,jobs,results,process,async))
})();var state__5917__auto__ = (function (){var statearr_11087 = f__5916__auto__.call(null);(statearr_11087[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto___11214);
return statearr_11087;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(__11202,c__5915__auto___11214,G__11033_11203,n__4518__auto___11201,jobs,results,process,async))
);

break;
default:
throw (new Error(("No matching clause: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(type))));

}
{
var G__11223 = (__11202 + (1));
__11202 = G__11223;
continue;
}
} else
{}
break;
}
var c__5915__auto___11224 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto___11224,jobs,results,process,async){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto___11224,jobs,results,process,async){
return (function (state_11109){var state_val_11110 = (state_11109[(1)]);if((state_val_11110 === (9)))
{var inst_11102 = (state_11109[(2)]);var state_11109__$1 = (function (){var statearr_11111 = state_11109;(statearr_11111[(7)] = inst_11102);
return statearr_11111;
})();var statearr_11112_11225 = state_11109__$1;(statearr_11112_11225[(2)] = null);
(statearr_11112_11225[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11110 === (8)))
{var inst_11095 = (state_11109[(8)]);var inst_11100 = (state_11109[(2)]);var state_11109__$1 = (function (){var statearr_11113 = state_11109;(statearr_11113[(9)] = inst_11100);
return statearr_11113;
})();return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11109__$1,(9),results,inst_11095);
} else
{if((state_val_11110 === (7)))
{var inst_11105 = (state_11109[(2)]);var state_11109__$1 = state_11109;var statearr_11114_11226 = state_11109__$1;(statearr_11114_11226[(2)] = inst_11105);
(statearr_11114_11226[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11110 === (6)))
{var inst_11090 = (state_11109[(10)]);var inst_11095 = (state_11109[(8)]);var inst_11095__$1 = cljs.core.async.chan.call(null,(1));var inst_11096 = cljs.core.PersistentVector.EMPTY_NODE;var inst_11097 = [inst_11090,inst_11095__$1];var inst_11098 = (new cljs.core.PersistentVector(null,2,(5),inst_11096,inst_11097,null));var state_11109__$1 = (function (){var statearr_11115 = state_11109;(statearr_11115[(8)] = inst_11095__$1);
return statearr_11115;
})();return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11109__$1,(8),jobs,inst_11098);
} else
{if((state_val_11110 === (5)))
{var inst_11093 = cljs.core.async.close_BANG_.call(null,jobs);var state_11109__$1 = state_11109;var statearr_11116_11227 = state_11109__$1;(statearr_11116_11227[(2)] = inst_11093);
(statearr_11116_11227[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11110 === (4)))
{var inst_11090 = (state_11109[(10)]);var inst_11090__$1 = (state_11109[(2)]);var inst_11091 = (inst_11090__$1 == null);var state_11109__$1 = (function (){var statearr_11117 = state_11109;(statearr_11117[(10)] = inst_11090__$1);
return statearr_11117;
})();if(cljs.core.truth_(inst_11091))
{var statearr_11118_11228 = state_11109__$1;(statearr_11118_11228[(1)] = (5));
} else
{var statearr_11119_11229 = state_11109__$1;(statearr_11119_11229[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11110 === (3)))
{var inst_11107 = (state_11109[(2)]);var state_11109__$1 = state_11109;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11109__$1,inst_11107);
} else
{if((state_val_11110 === (2)))
{var state_11109__$1 = state_11109;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11109__$1,(4),from);
} else
{if((state_val_11110 === (1)))
{var state_11109__$1 = state_11109;var statearr_11120_11230 = state_11109__$1;(statearr_11120_11230[(2)] = null);
(statearr_11120_11230[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
});})(c__5915__auto___11224,jobs,results,process,async))
;return ((function (switch__5900__auto__,c__5915__auto___11224,jobs,results,process,async){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_11124 = [null,null,null,null,null,null,null,null,null,null,null];(statearr_11124[(0)] = state_machine__5901__auto__);
(statearr_11124[(1)] = (1));
return statearr_11124;
});
var state_machine__5901__auto____1 = (function (state_11109){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_11109);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e11125){if((e11125 instanceof Object))
{var ex__5904__auto__ = e11125;var statearr_11126_11231 = state_11109;(statearr_11126_11231[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11109);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e11125;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__11232 = state_11109;
state_11109 = G__11232;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_11109){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_11109);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto___11224,jobs,results,process,async))
})();var state__5917__auto__ = (function (){var statearr_11127 = f__5916__auto__.call(null);(statearr_11127[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto___11224);
return statearr_11127;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto___11224,jobs,results,process,async))
);
var c__5915__auto__ = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto__,jobs,results,process,async){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto__,jobs,results,process,async){
return (function (state_11165){var state_val_11166 = (state_11165[(1)]);if((state_val_11166 === (7)))
{var inst_11161 = (state_11165[(2)]);var state_11165__$1 = state_11165;var statearr_11167_11233 = state_11165__$1;(statearr_11167_11233[(2)] = inst_11161);
(statearr_11167_11233[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11166 === (20)))
{var state_11165__$1 = state_11165;var statearr_11168_11234 = state_11165__$1;(statearr_11168_11234[(2)] = null);
(statearr_11168_11234[(1)] = (21));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11166 === (1)))
{var state_11165__$1 = state_11165;var statearr_11169_11235 = state_11165__$1;(statearr_11169_11235[(2)] = null);
(statearr_11169_11235[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11166 === (4)))
{var inst_11130 = (state_11165[(7)]);var inst_11130__$1 = (state_11165[(2)]);var inst_11131 = (inst_11130__$1 == null);var state_11165__$1 = (function (){var statearr_11170 = state_11165;(statearr_11170[(7)] = inst_11130__$1);
return statearr_11170;
})();if(cljs.core.truth_(inst_11131))
{var statearr_11171_11236 = state_11165__$1;(statearr_11171_11236[(1)] = (5));
} else
{var statearr_11172_11237 = state_11165__$1;(statearr_11172_11237[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11166 === (15)))
{var inst_11143 = (state_11165[(8)]);var state_11165__$1 = state_11165;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11165__$1,(18),to,inst_11143);
} else
{if((state_val_11166 === (21)))
{var inst_11156 = (state_11165[(2)]);var state_11165__$1 = state_11165;var statearr_11173_11238 = state_11165__$1;(statearr_11173_11238[(2)] = inst_11156);
(statearr_11173_11238[(1)] = (13));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11166 === (13)))
{var inst_11158 = (state_11165[(2)]);var state_11165__$1 = (function (){var statearr_11174 = state_11165;(statearr_11174[(9)] = inst_11158);
return statearr_11174;
})();var statearr_11175_11239 = state_11165__$1;(statearr_11175_11239[(2)] = null);
(statearr_11175_11239[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11166 === (6)))
{var inst_11130 = (state_11165[(7)]);var state_11165__$1 = state_11165;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11165__$1,(11),inst_11130);
} else
{if((state_val_11166 === (17)))
{var inst_11151 = (state_11165[(2)]);var state_11165__$1 = state_11165;if(cljs.core.truth_(inst_11151))
{var statearr_11176_11240 = state_11165__$1;(statearr_11176_11240[(1)] = (19));
} else
{var statearr_11177_11241 = state_11165__$1;(statearr_11177_11241[(1)] = (20));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11166 === (3)))
{var inst_11163 = (state_11165[(2)]);var state_11165__$1 = state_11165;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11165__$1,inst_11163);
} else
{if((state_val_11166 === (12)))
{var inst_11140 = (state_11165[(10)]);var state_11165__$1 = state_11165;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11165__$1,(14),inst_11140);
} else
{if((state_val_11166 === (2)))
{var state_11165__$1 = state_11165;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11165__$1,(4),results);
} else
{if((state_val_11166 === (19)))
{var state_11165__$1 = state_11165;var statearr_11178_11242 = state_11165__$1;(statearr_11178_11242[(2)] = null);
(statearr_11178_11242[(1)] = (12));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11166 === (11)))
{var inst_11140 = (state_11165[(2)]);var state_11165__$1 = (function (){var statearr_11179 = state_11165;(statearr_11179[(10)] = inst_11140);
return statearr_11179;
})();var statearr_11180_11243 = state_11165__$1;(statearr_11180_11243[(2)] = null);
(statearr_11180_11243[(1)] = (12));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11166 === (9)))
{var state_11165__$1 = state_11165;var statearr_11181_11244 = state_11165__$1;(statearr_11181_11244[(2)] = null);
(statearr_11181_11244[(1)] = (10));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11166 === (5)))
{var state_11165__$1 = state_11165;if(cljs.core.truth_(close_QMARK_))
{var statearr_11182_11245 = state_11165__$1;(statearr_11182_11245[(1)] = (8));
} else
{var statearr_11183_11246 = state_11165__$1;(statearr_11183_11246[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11166 === (14)))
{var inst_11145 = (state_11165[(11)]);var inst_11143 = (state_11165[(8)]);var inst_11143__$1 = (state_11165[(2)]);var inst_11144 = (inst_11143__$1 == null);var inst_11145__$1 = cljs.core.not.call(null,inst_11144);var state_11165__$1 = (function (){var statearr_11184 = state_11165;(statearr_11184[(11)] = inst_11145__$1);
(statearr_11184[(8)] = inst_11143__$1);
return statearr_11184;
})();if(inst_11145__$1)
{var statearr_11185_11247 = state_11165__$1;(statearr_11185_11247[(1)] = (15));
} else
{var statearr_11186_11248 = state_11165__$1;(statearr_11186_11248[(1)] = (16));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11166 === (16)))
{var inst_11145 = (state_11165[(11)]);var state_11165__$1 = state_11165;var statearr_11187_11249 = state_11165__$1;(statearr_11187_11249[(2)] = inst_11145);
(statearr_11187_11249[(1)] = (17));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11166 === (10)))
{var inst_11137 = (state_11165[(2)]);var state_11165__$1 = state_11165;var statearr_11188_11250 = state_11165__$1;(statearr_11188_11250[(2)] = inst_11137);
(statearr_11188_11250[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11166 === (18)))
{var inst_11148 = (state_11165[(2)]);var state_11165__$1 = state_11165;var statearr_11189_11251 = state_11165__$1;(statearr_11189_11251[(2)] = inst_11148);
(statearr_11189_11251[(1)] = (17));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11166 === (8)))
{var inst_11134 = cljs.core.async.close_BANG_.call(null,to);var state_11165__$1 = state_11165;var statearr_11190_11252 = state_11165__$1;(statearr_11190_11252[(2)] = inst_11134);
(statearr_11190_11252[(1)] = (10));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__5915__auto__,jobs,results,process,async))
;return ((function (switch__5900__auto__,c__5915__auto__,jobs,results,process,async){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_11194 = [null,null,null,null,null,null,null,null,null,null,null,null];(statearr_11194[(0)] = state_machine__5901__auto__);
(statearr_11194[(1)] = (1));
return statearr_11194;
});
var state_machine__5901__auto____1 = (function (state_11165){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_11165);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e11195){if((e11195 instanceof Object))
{var ex__5904__auto__ = e11195;var statearr_11196_11253 = state_11165;(statearr_11196_11253[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11165);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e11195;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__11254 = state_11165;
state_11165 = G__11254;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_11165){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_11165);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto__,jobs,results,process,async))
})();var state__5917__auto__ = (function (){var statearr_11197 = f__5916__auto__.call(null);(statearr_11197[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto__);
return statearr_11197;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto__,jobs,results,process,async))
);
return c__5915__auto__;
});
/**
* Takes elements from the from channel and supplies them to the to
* channel, subject to the async function af, with parallelism n. af
* must be a function of two arguments, the first an input value and
* the second a channel on which to place the result(s). af must close!
* the channel before returning.  The presumption is that af will
* return immediately, having launched some asynchronous operation
* whose completion/callback will manipulate the result channel. Outputs
* will be returned in order relative to  the inputs. By default, the to
* channel will be closed when the from channel closes, but can be
* determined by the close?  parameter. Will stop consuming the from
* channel if the to channel closes.
*/
cljs.core.async.pipeline_async = (function() {
var pipeline_async = null;
var pipeline_async__4 = (function (n,to,af,from){return pipeline_async.call(null,n,to,af,from,true);
});
var pipeline_async__5 = (function (n,to,af,from,close_QMARK_){return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});
pipeline_async = function(n,to,af,from,close_QMARK_){
switch(arguments.length){
case 4:
return pipeline_async__4.call(this,n,to,af,from);
case 5:
return pipeline_async__5.call(this,n,to,af,from,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pipeline_async.cljs$core$IFn$_invoke$arity$4 = pipeline_async__4;
pipeline_async.cljs$core$IFn$_invoke$arity$5 = pipeline_async__5;
return pipeline_async;
})()
;
/**
* Takes elements from the from channel and supplies them to the to
* channel, subject to the transducer xf, with parallelism n. Because
* it is parallel, the transducer will be applied independently to each
* element, not across elements, and may produce zero or more outputs
* per input.  Outputs will be returned in order relative to the
* inputs. By default, the to channel will be closed when the from
* channel closes, but can be determined by the close?  parameter. Will
* stop consuming the from channel if the to channel closes.
* 
* Note this is supplied for API compatibility with the Clojure version.
* Values of N > 1 will not result in actual concurrency in a
* single-threaded runtime.
*/
cljs.core.async.pipeline = (function() {
var pipeline = null;
var pipeline__4 = (function (n,to,xf,from){return pipeline.call(null,n,to,xf,from,true);
});
var pipeline__5 = (function (n,to,xf,from,close_QMARK_){return pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});
var pipeline__6 = (function (n,to,xf,from,close_QMARK_,ex_handler){return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});
pipeline = function(n,to,xf,from,close_QMARK_,ex_handler){
switch(arguments.length){
case 4:
return pipeline__4.call(this,n,to,xf,from);
case 5:
return pipeline__5.call(this,n,to,xf,from,close_QMARK_);
case 6:
return pipeline__6.call(this,n,to,xf,from,close_QMARK_,ex_handler);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pipeline.cljs$core$IFn$_invoke$arity$4 = pipeline__4;
pipeline.cljs$core$IFn$_invoke$arity$5 = pipeline__5;
pipeline.cljs$core$IFn$_invoke$arity$6 = pipeline__6;
return pipeline;
})()
;
/**
* Takes a predicate and a source channel and returns a vector of two
* channels, the first of which will contain the values for which the
* predicate returned true, the second those for which it returned
* false.
* 
* The out channels will be unbuffered by default, or two buf-or-ns can
* be supplied. The channels will close after the source channel has
* closed.
*/
cljs.core.async.split = (function() {
var split = null;
var split__2 = (function (p,ch){return split.call(null,p,ch,null,null);
});
var split__4 = (function (p,ch,t_buf_or_n,f_buf_or_n){var tc = cljs.core.async.chan.call(null,t_buf_or_n);var fc = cljs.core.async.chan.call(null,f_buf_or_n);var c__5915__auto___11355 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto___11355,tc,fc){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto___11355,tc,fc){
return (function (state_11330){var state_val_11331 = (state_11330[(1)]);if((state_val_11331 === (7)))
{var inst_11326 = (state_11330[(2)]);var state_11330__$1 = state_11330;var statearr_11332_11356 = state_11330__$1;(statearr_11332_11356[(2)] = inst_11326);
(statearr_11332_11356[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11331 === (1)))
{var state_11330__$1 = state_11330;var statearr_11333_11357 = state_11330__$1;(statearr_11333_11357[(2)] = null);
(statearr_11333_11357[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11331 === (4)))
{var inst_11307 = (state_11330[(7)]);var inst_11307__$1 = (state_11330[(2)]);var inst_11308 = (inst_11307__$1 == null);var state_11330__$1 = (function (){var statearr_11334 = state_11330;(statearr_11334[(7)] = inst_11307__$1);
return statearr_11334;
})();if(cljs.core.truth_(inst_11308))
{var statearr_11335_11358 = state_11330__$1;(statearr_11335_11358[(1)] = (5));
} else
{var statearr_11336_11359 = state_11330__$1;(statearr_11336_11359[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11331 === (13)))
{var state_11330__$1 = state_11330;var statearr_11337_11360 = state_11330__$1;(statearr_11337_11360[(2)] = null);
(statearr_11337_11360[(1)] = (14));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11331 === (6)))
{var inst_11307 = (state_11330[(7)]);var inst_11313 = p.call(null,inst_11307);var state_11330__$1 = state_11330;if(cljs.core.truth_(inst_11313))
{var statearr_11338_11361 = state_11330__$1;(statearr_11338_11361[(1)] = (9));
} else
{var statearr_11339_11362 = state_11330__$1;(statearr_11339_11362[(1)] = (10));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11331 === (3)))
{var inst_11328 = (state_11330[(2)]);var state_11330__$1 = state_11330;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11330__$1,inst_11328);
} else
{if((state_val_11331 === (12)))
{var state_11330__$1 = state_11330;var statearr_11340_11363 = state_11330__$1;(statearr_11340_11363[(2)] = null);
(statearr_11340_11363[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11331 === (2)))
{var state_11330__$1 = state_11330;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11330__$1,(4),ch);
} else
{if((state_val_11331 === (11)))
{var inst_11307 = (state_11330[(7)]);var inst_11317 = (state_11330[(2)]);var state_11330__$1 = state_11330;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11330__$1,(8),inst_11317,inst_11307);
} else
{if((state_val_11331 === (9)))
{var state_11330__$1 = state_11330;var statearr_11341_11364 = state_11330__$1;(statearr_11341_11364[(2)] = tc);
(statearr_11341_11364[(1)] = (11));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11331 === (5)))
{var inst_11310 = cljs.core.async.close_BANG_.call(null,tc);var inst_11311 = cljs.core.async.close_BANG_.call(null,fc);var state_11330__$1 = (function (){var statearr_11342 = state_11330;(statearr_11342[(8)] = inst_11310);
return statearr_11342;
})();var statearr_11343_11365 = state_11330__$1;(statearr_11343_11365[(2)] = inst_11311);
(statearr_11343_11365[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11331 === (14)))
{var inst_11324 = (state_11330[(2)]);var state_11330__$1 = state_11330;var statearr_11344_11366 = state_11330__$1;(statearr_11344_11366[(2)] = inst_11324);
(statearr_11344_11366[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11331 === (10)))
{var state_11330__$1 = state_11330;var statearr_11345_11367 = state_11330__$1;(statearr_11345_11367[(2)] = fc);
(statearr_11345_11367[(1)] = (11));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11331 === (8)))
{var inst_11319 = (state_11330[(2)]);var state_11330__$1 = state_11330;if(cljs.core.truth_(inst_11319))
{var statearr_11346_11368 = state_11330__$1;(statearr_11346_11368[(1)] = (12));
} else
{var statearr_11347_11369 = state_11330__$1;(statearr_11347_11369[(1)] = (13));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__5915__auto___11355,tc,fc))
;return ((function (switch__5900__auto__,c__5915__auto___11355,tc,fc){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_11351 = [null,null,null,null,null,null,null,null,null];(statearr_11351[(0)] = state_machine__5901__auto__);
(statearr_11351[(1)] = (1));
return statearr_11351;
});
var state_machine__5901__auto____1 = (function (state_11330){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_11330);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e11352){if((e11352 instanceof Object))
{var ex__5904__auto__ = e11352;var statearr_11353_11370 = state_11330;(statearr_11353_11370[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11330);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e11352;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__11371 = state_11330;
state_11330 = G__11371;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_11330){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_11330);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto___11355,tc,fc))
})();var state__5917__auto__ = (function (){var statearr_11354 = f__5916__auto__.call(null);(statearr_11354[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto___11355);
return statearr_11354;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto___11355,tc,fc))
);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});
split = function(p,ch,t_buf_or_n,f_buf_or_n){
switch(arguments.length){
case 2:
return split__2.call(this,p,ch);
case 4:
return split__4.call(this,p,ch,t_buf_or_n,f_buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
split.cljs$core$IFn$_invoke$arity$2 = split__2;
split.cljs$core$IFn$_invoke$arity$4 = split__4;
return split;
})()
;
/**
* f should be a function of 2 arguments. Returns a channel containing
* the single result of applying f to init and the first item from the
* channel, then applying f to that result and the 2nd item, etc. If
* the channel closes without yielding items, returns init and f is not
* called. ch must close before reduce produces a result.
*/
cljs.core.async.reduce = (function reduce(f,init,ch){var c__5915__auto__ = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto__){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto__){
return (function (state_11418){var state_val_11419 = (state_11418[(1)]);if((state_val_11419 === (7)))
{var inst_11414 = (state_11418[(2)]);var state_11418__$1 = state_11418;var statearr_11420_11436 = state_11418__$1;(statearr_11420_11436[(2)] = inst_11414);
(statearr_11420_11436[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11419 === (6)))
{var inst_11407 = (state_11418[(7)]);var inst_11404 = (state_11418[(8)]);var inst_11411 = f.call(null,inst_11404,inst_11407);var inst_11404__$1 = inst_11411;var state_11418__$1 = (function (){var statearr_11421 = state_11418;(statearr_11421[(8)] = inst_11404__$1);
return statearr_11421;
})();var statearr_11422_11437 = state_11418__$1;(statearr_11422_11437[(2)] = null);
(statearr_11422_11437[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11419 === (5)))
{var inst_11404 = (state_11418[(8)]);var state_11418__$1 = state_11418;var statearr_11423_11438 = state_11418__$1;(statearr_11423_11438[(2)] = inst_11404);
(statearr_11423_11438[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11419 === (4)))
{var inst_11407 = (state_11418[(7)]);var inst_11407__$1 = (state_11418[(2)]);var inst_11408 = (inst_11407__$1 == null);var state_11418__$1 = (function (){var statearr_11424 = state_11418;(statearr_11424[(7)] = inst_11407__$1);
return statearr_11424;
})();if(cljs.core.truth_(inst_11408))
{var statearr_11425_11439 = state_11418__$1;(statearr_11425_11439[(1)] = (5));
} else
{var statearr_11426_11440 = state_11418__$1;(statearr_11426_11440[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11419 === (3)))
{var inst_11416 = (state_11418[(2)]);var state_11418__$1 = state_11418;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11418__$1,inst_11416);
} else
{if((state_val_11419 === (2)))
{var state_11418__$1 = state_11418;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11418__$1,(4),ch);
} else
{if((state_val_11419 === (1)))
{var inst_11404 = init;var state_11418__$1 = (function (){var statearr_11427 = state_11418;(statearr_11427[(8)] = inst_11404);
return statearr_11427;
})();var statearr_11428_11441 = state_11418__$1;(statearr_11428_11441[(2)] = null);
(statearr_11428_11441[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
});})(c__5915__auto__))
;return ((function (switch__5900__auto__,c__5915__auto__){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_11432 = [null,null,null,null,null,null,null,null,null];(statearr_11432[(0)] = state_machine__5901__auto__);
(statearr_11432[(1)] = (1));
return statearr_11432;
});
var state_machine__5901__auto____1 = (function (state_11418){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_11418);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e11433){if((e11433 instanceof Object))
{var ex__5904__auto__ = e11433;var statearr_11434_11442 = state_11418;(statearr_11434_11442[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11418);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e11433;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__11443 = state_11418;
state_11418 = G__11443;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_11418){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_11418);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto__))
})();var state__5917__auto__ = (function (){var statearr_11435 = f__5916__auto__.call(null);(statearr_11435[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto__);
return statearr_11435;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto__))
);
return c__5915__auto__;
});
/**
* Puts the contents of coll into the supplied channel.
* 
* By default the channel will be closed after the items are copied,
* but can be determined by the close? parameter.
* 
* Returns a channel which will close after the items are copied.
*/
cljs.core.async.onto_chan = (function() {
var onto_chan = null;
var onto_chan__2 = (function (ch,coll){return onto_chan.call(null,ch,coll,true);
});
var onto_chan__3 = (function (ch,coll,close_QMARK_){var c__5915__auto__ = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto__){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto__){
return (function (state_11517){var state_val_11518 = (state_11517[(1)]);if((state_val_11518 === (7)))
{var inst_11499 = (state_11517[(2)]);var state_11517__$1 = state_11517;var statearr_11519_11542 = state_11517__$1;(statearr_11519_11542[(2)] = inst_11499);
(statearr_11519_11542[(1)] = (6));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11518 === (1)))
{var inst_11493 = cljs.core.seq.call(null,coll);var inst_11494 = inst_11493;var state_11517__$1 = (function (){var statearr_11520 = state_11517;(statearr_11520[(7)] = inst_11494);
return statearr_11520;
})();var statearr_11521_11543 = state_11517__$1;(statearr_11521_11543[(2)] = null);
(statearr_11521_11543[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11518 === (4)))
{var inst_11494 = (state_11517[(7)]);var inst_11497 = cljs.core.first.call(null,inst_11494);var state_11517__$1 = state_11517;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11517__$1,(7),ch,inst_11497);
} else
{if((state_val_11518 === (13)))
{var inst_11511 = (state_11517[(2)]);var state_11517__$1 = state_11517;var statearr_11522_11544 = state_11517__$1;(statearr_11522_11544[(2)] = inst_11511);
(statearr_11522_11544[(1)] = (10));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11518 === (6)))
{var inst_11502 = (state_11517[(2)]);var state_11517__$1 = state_11517;if(cljs.core.truth_(inst_11502))
{var statearr_11523_11545 = state_11517__$1;(statearr_11523_11545[(1)] = (8));
} else
{var statearr_11524_11546 = state_11517__$1;(statearr_11524_11546[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11518 === (3)))
{var inst_11515 = (state_11517[(2)]);var state_11517__$1 = state_11517;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11517__$1,inst_11515);
} else
{if((state_val_11518 === (12)))
{var state_11517__$1 = state_11517;var statearr_11525_11547 = state_11517__$1;(statearr_11525_11547[(2)] = null);
(statearr_11525_11547[(1)] = (13));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11518 === (2)))
{var inst_11494 = (state_11517[(7)]);var state_11517__$1 = state_11517;if(cljs.core.truth_(inst_11494))
{var statearr_11526_11548 = state_11517__$1;(statearr_11526_11548[(1)] = (4));
} else
{var statearr_11527_11549 = state_11517__$1;(statearr_11527_11549[(1)] = (5));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11518 === (11)))
{var inst_11508 = cljs.core.async.close_BANG_.call(null,ch);var state_11517__$1 = state_11517;var statearr_11528_11550 = state_11517__$1;(statearr_11528_11550[(2)] = inst_11508);
(statearr_11528_11550[(1)] = (13));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11518 === (9)))
{var state_11517__$1 = state_11517;if(cljs.core.truth_(close_QMARK_))
{var statearr_11529_11551 = state_11517__$1;(statearr_11529_11551[(1)] = (11));
} else
{var statearr_11530_11552 = state_11517__$1;(statearr_11530_11552[(1)] = (12));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11518 === (5)))
{var inst_11494 = (state_11517[(7)]);var state_11517__$1 = state_11517;var statearr_11531_11553 = state_11517__$1;(statearr_11531_11553[(2)] = inst_11494);
(statearr_11531_11553[(1)] = (6));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11518 === (10)))
{var inst_11513 = (state_11517[(2)]);var state_11517__$1 = state_11517;var statearr_11532_11554 = state_11517__$1;(statearr_11532_11554[(2)] = inst_11513);
(statearr_11532_11554[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11518 === (8)))
{var inst_11494 = (state_11517[(7)]);var inst_11504 = cljs.core.next.call(null,inst_11494);var inst_11494__$1 = inst_11504;var state_11517__$1 = (function (){var statearr_11533 = state_11517;(statearr_11533[(7)] = inst_11494__$1);
return statearr_11533;
})();var statearr_11534_11555 = state_11517__$1;(statearr_11534_11555[(2)] = null);
(statearr_11534_11555[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__5915__auto__))
;return ((function (switch__5900__auto__,c__5915__auto__){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_11538 = [null,null,null,null,null,null,null,null];(statearr_11538[(0)] = state_machine__5901__auto__);
(statearr_11538[(1)] = (1));
return statearr_11538;
});
var state_machine__5901__auto____1 = (function (state_11517){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_11517);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e11539){if((e11539 instanceof Object))
{var ex__5904__auto__ = e11539;var statearr_11540_11556 = state_11517;(statearr_11540_11556[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11517);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e11539;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__11557 = state_11517;
state_11517 = G__11557;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_11517){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_11517);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto__))
})();var state__5917__auto__ = (function (){var statearr_11541 = f__5916__auto__.call(null);(statearr_11541[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto__);
return statearr_11541;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto__))
);
return c__5915__auto__;
});
onto_chan = function(ch,coll,close_QMARK_){
switch(arguments.length){
case 2:
return onto_chan__2.call(this,ch,coll);
case 3:
return onto_chan__3.call(this,ch,coll,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
onto_chan.cljs$core$IFn$_invoke$arity$2 = onto_chan__2;
onto_chan.cljs$core$IFn$_invoke$arity$3 = onto_chan__3;
return onto_chan;
})()
;
/**
* Creates and returns a channel which contains the contents of coll,
* closing when exhausted.
*/
cljs.core.async.to_chan = (function to_chan(coll){var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));cljs.core.async.onto_chan.call(null,ch,coll);
return ch;
});
cljs.core.async.Mux = (function (){var obj11559 = {};return obj11559;
})();
cljs.core.async.muxch_STAR_ = (function muxch_STAR_(_){if((function (){var and__3636__auto__ = _;if(and__3636__auto__)
{return _.cljs$core$async$Mux$muxch_STAR_$arity$1;
} else
{return and__3636__auto__;
}
})())
{return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else
{var x__4285__auto__ = (((_ == null))?null:_);return (function (){var or__3648__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4285__auto__)]);if(or__3648__auto__)
{return or__3648__auto__;
} else
{var or__3648__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);if(or__3648__auto____$1)
{return or__3648__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
})().call(null,_);
}
});
cljs.core.async.Mult = (function (){var obj11561 = {};return obj11561;
})();
cljs.core.async.tap_STAR_ = (function tap_STAR_(m,ch,close_QMARK_){if((function (){var and__3636__auto__ = m;if(and__3636__auto__)
{return m.cljs$core$async$Mult$tap_STAR_$arity$3;
} else
{return and__3636__auto__;
}
})())
{return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else
{var x__4285__auto__ = (((m == null))?null:m);return (function (){var or__3648__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4285__auto__)]);if(or__3648__auto__)
{return or__3648__auto__;
} else
{var or__3648__auto____$1 = (cljs.core.async.tap_STAR_["_"]);if(or__3648__auto____$1)
{return or__3648__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
})().call(null,m,ch,close_QMARK_);
}
});
cljs.core.async.untap_STAR_ = (function untap_STAR_(m,ch){if((function (){var and__3636__auto__ = m;if(and__3636__auto__)
{return m.cljs$core$async$Mult$untap_STAR_$arity$2;
} else
{return and__3636__auto__;
}
})())
{return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else
{var x__4285__auto__ = (((m == null))?null:m);return (function (){var or__3648__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4285__auto__)]);if(or__3648__auto__)
{return or__3648__auto__;
} else
{var or__3648__auto____$1 = (cljs.core.async.untap_STAR_["_"]);if(or__3648__auto____$1)
{return or__3648__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
})().call(null,m,ch);
}
});
cljs.core.async.untap_all_STAR_ = (function untap_all_STAR_(m){if((function (){var and__3636__auto__ = m;if(and__3636__auto__)
{return m.cljs$core$async$Mult$untap_all_STAR_$arity$1;
} else
{return and__3636__auto__;
}
})())
{return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else
{var x__4285__auto__ = (((m == null))?null:m);return (function (){var or__3648__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4285__auto__)]);if(or__3648__auto__)
{return or__3648__auto__;
} else
{var or__3648__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);if(or__3648__auto____$1)
{return or__3648__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
})().call(null,m);
}
});
/**
* Creates and returns a mult(iple) of the supplied channel. Channels
* containing copies of the channel can be created with 'tap', and
* detached with 'untap'.
* 
* Each item is distributed to all taps in parallel and synchronously,
* i.e. each tap must accept before the next item is distributed. Use
* buffering/windowing to prevent slow taps from holding up the mult.
* 
* Items received when there are no taps get dropped.
* 
* If a tap puts to a closed channel, it will be removed from the mult.
*/
cljs.core.async.mult = (function mult(ch){var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);var m = (function (){if(typeof cljs.core.async.t11783 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t11783 = (function (cs,ch,mult,meta11784){
this.cs = cs;
this.ch = ch;
this.mult = mult;
this.meta11784 = meta11784;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t11783.cljs$lang$type = true;
cljs.core.async.t11783.cljs$lang$ctorStr = "cljs.core.async/t11783";
cljs.core.async.t11783.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__4225__auto__,writer__4226__auto__,opt__4227__auto__){return cljs.core._write.call(null,writer__4226__auto__,"cljs.core.async/t11783");
});})(cs))
;
cljs.core.async.t11783.prototype.cljs$core$async$Mult$ = true;
cljs.core.async.t11783.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$2,close_QMARK_){var self__ = this;
var ___$1 = this;cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$2,close_QMARK_);
return null;
});})(cs))
;
cljs.core.async.t11783.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$2){var self__ = this;
var ___$1 = this;cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$2);
return null;
});})(cs))
;
cljs.core.async.t11783.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){var self__ = this;
var ___$1 = this;cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);
return null;
});})(cs))
;
cljs.core.async.t11783.prototype.cljs$core$async$Mux$ = true;
cljs.core.async.t11783.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){var self__ = this;
var ___$1 = this;return self__.ch;
});})(cs))
;
cljs.core.async.t11783.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_11785){var self__ = this;
var _11785__$1 = this;return self__.meta11784;
});})(cs))
;
cljs.core.async.t11783.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_11785,meta11784__$1){var self__ = this;
var _11785__$1 = this;return (new cljs.core.async.t11783(self__.cs,self__.ch,self__.mult,meta11784__$1));
});})(cs))
;
cljs.core.async.__GT_t11783 = ((function (cs){
return (function __GT_t11783(cs__$1,ch__$1,mult__$1,meta11784){return (new cljs.core.async.t11783(cs__$1,ch__$1,mult__$1,meta11784));
});})(cs))
;
}
return (new cljs.core.async.t11783(cs,ch,mult,null));
})();var dchan = cljs.core.async.chan.call(null,(1));var dctr = cljs.core.atom.call(null,null);var done = ((function (cs,m,dchan,dctr){
return (function (_){if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0)))
{return cljs.core.async.put_BANG_.call(null,dchan,true);
} else
{return null;
}
});})(cs,m,dchan,dctr))
;var c__5915__auto___12004 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto___12004,cs,m,dchan,dctr,done){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto___12004,cs,m,dchan,dctr,done){
return (function (state_11916){var state_val_11917 = (state_11916[(1)]);if((state_val_11917 === (7)))
{var inst_11912 = (state_11916[(2)]);var state_11916__$1 = state_11916;var statearr_11918_12005 = state_11916__$1;(statearr_11918_12005[(2)] = inst_11912);
(statearr_11918_12005[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11917 === (20)))
{var inst_11817 = (state_11916[(7)]);var inst_11827 = cljs.core.first.call(null,inst_11817);var inst_11828 = cljs.core.nth.call(null,inst_11827,(0),null);var inst_11829 = cljs.core.nth.call(null,inst_11827,(1),null);var state_11916__$1 = (function (){var statearr_11919 = state_11916;(statearr_11919[(8)] = inst_11828);
return statearr_11919;
})();if(cljs.core.truth_(inst_11829))
{var statearr_11920_12006 = state_11916__$1;(statearr_11920_12006[(1)] = (22));
} else
{var statearr_11921_12007 = state_11916__$1;(statearr_11921_12007[(1)] = (23));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11917 === (27)))
{var inst_11788 = (state_11916[(9)]);var inst_11864 = (state_11916[(10)]);var inst_11857 = (state_11916[(11)]);var inst_11859 = (state_11916[(12)]);var inst_11864__$1 = cljs.core._nth.call(null,inst_11857,inst_11859);var inst_11865 = cljs.core.async.put_BANG_.call(null,inst_11864__$1,inst_11788,done);var state_11916__$1 = (function (){var statearr_11922 = state_11916;(statearr_11922[(10)] = inst_11864__$1);
return statearr_11922;
})();if(cljs.core.truth_(inst_11865))
{var statearr_11923_12008 = state_11916__$1;(statearr_11923_12008[(1)] = (30));
} else
{var statearr_11924_12009 = state_11916__$1;(statearr_11924_12009[(1)] = (31));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11917 === (1)))
{var state_11916__$1 = state_11916;var statearr_11925_12010 = state_11916__$1;(statearr_11925_12010[(2)] = null);
(statearr_11925_12010[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11917 === (24)))
{var inst_11817 = (state_11916[(7)]);var inst_11834 = (state_11916[(2)]);var inst_11835 = cljs.core.next.call(null,inst_11817);var inst_11797 = inst_11835;var inst_11798 = null;var inst_11799 = (0);var inst_11800 = (0);var state_11916__$1 = (function (){var statearr_11926 = state_11916;(statearr_11926[(13)] = inst_11834);
(statearr_11926[(14)] = inst_11797);
(statearr_11926[(15)] = inst_11799);
(statearr_11926[(16)] = inst_11800);
(statearr_11926[(17)] = inst_11798);
return statearr_11926;
})();var statearr_11927_12011 = state_11916__$1;(statearr_11927_12011[(2)] = null);
(statearr_11927_12011[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11917 === (39)))
{var state_11916__$1 = state_11916;var statearr_11931_12012 = state_11916__$1;(statearr_11931_12012[(2)] = null);
(statearr_11931_12012[(1)] = (41));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11917 === (4)))
{var inst_11788 = (state_11916[(9)]);var inst_11788__$1 = (state_11916[(2)]);var inst_11789 = (inst_11788__$1 == null);var state_11916__$1 = (function (){var statearr_11932 = state_11916;(statearr_11932[(9)] = inst_11788__$1);
return statearr_11932;
})();if(cljs.core.truth_(inst_11789))
{var statearr_11933_12013 = state_11916__$1;(statearr_11933_12013[(1)] = (5));
} else
{var statearr_11934_12014 = state_11916__$1;(statearr_11934_12014[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11917 === (15)))
{var inst_11797 = (state_11916[(14)]);var inst_11799 = (state_11916[(15)]);var inst_11800 = (state_11916[(16)]);var inst_11798 = (state_11916[(17)]);var inst_11813 = (state_11916[(2)]);var inst_11814 = (inst_11800 + (1));var tmp11928 = inst_11797;var tmp11929 = inst_11799;var tmp11930 = inst_11798;var inst_11797__$1 = tmp11928;var inst_11798__$1 = tmp11930;var inst_11799__$1 = tmp11929;var inst_11800__$1 = inst_11814;var state_11916__$1 = (function (){var statearr_11935 = state_11916;(statearr_11935[(14)] = inst_11797__$1);
(statearr_11935[(18)] = inst_11813);
(statearr_11935[(15)] = inst_11799__$1);
(statearr_11935[(16)] = inst_11800__$1);
(statearr_11935[(17)] = inst_11798__$1);
return statearr_11935;
})();var statearr_11936_12015 = state_11916__$1;(statearr_11936_12015[(2)] = null);
(statearr_11936_12015[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11917 === (21)))
{var inst_11838 = (state_11916[(2)]);var state_11916__$1 = state_11916;var statearr_11940_12016 = state_11916__$1;(statearr_11940_12016[(2)] = inst_11838);
(statearr_11940_12016[(1)] = (18));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11917 === (31)))
{var inst_11864 = (state_11916[(10)]);var inst_11868 = done.call(null,null);var inst_11869 = cljs.core.async.untap_STAR_.call(null,m,inst_11864);var state_11916__$1 = (function (){var statearr_11941 = state_11916;(statearr_11941[(19)] = inst_11868);
return statearr_11941;
})();var statearr_11942_12017 = state_11916__$1;(statearr_11942_12017[(2)] = inst_11869);
(statearr_11942_12017[(1)] = (32));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11917 === (32)))
{var inst_11858 = (state_11916[(20)]);var inst_11857 = (state_11916[(11)]);var inst_11859 = (state_11916[(12)]);var inst_11856 = (state_11916[(21)]);var inst_11871 = (state_11916[(2)]);var inst_11872 = (inst_11859 + (1));var tmp11937 = inst_11858;var tmp11938 = inst_11857;var tmp11939 = inst_11856;var inst_11856__$1 = tmp11939;var inst_11857__$1 = tmp11938;var inst_11858__$1 = tmp11937;var inst_11859__$1 = inst_11872;var state_11916__$1 = (function (){var statearr_11943 = state_11916;(statearr_11943[(20)] = inst_11858__$1);
(statearr_11943[(11)] = inst_11857__$1);
(statearr_11943[(22)] = inst_11871);
(statearr_11943[(12)] = inst_11859__$1);
(statearr_11943[(21)] = inst_11856__$1);
return statearr_11943;
})();var statearr_11944_12018 = state_11916__$1;(statearr_11944_12018[(2)] = null);
(statearr_11944_12018[(1)] = (25));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11917 === (40)))
{var inst_11884 = (state_11916[(23)]);var inst_11888 = done.call(null,null);var inst_11889 = cljs.core.async.untap_STAR_.call(null,m,inst_11884);var state_11916__$1 = (function (){var statearr_11945 = state_11916;(statearr_11945[(24)] = inst_11888);
return statearr_11945;
})();var statearr_11946_12019 = state_11916__$1;(statearr_11946_12019[(2)] = inst_11889);
(statearr_11946_12019[(1)] = (41));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11917 === (33)))
{var inst_11875 = (state_11916[(25)]);var inst_11877 = cljs.core.chunked_seq_QMARK_.call(null,inst_11875);var state_11916__$1 = state_11916;if(inst_11877)
{var statearr_11947_12020 = state_11916__$1;(statearr_11947_12020[(1)] = (36));
} else
{var statearr_11948_12021 = state_11916__$1;(statearr_11948_12021[(1)] = (37));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11917 === (13)))
{var inst_11807 = (state_11916[(26)]);var inst_11810 = cljs.core.async.close_BANG_.call(null,inst_11807);var state_11916__$1 = state_11916;var statearr_11949_12022 = state_11916__$1;(statearr_11949_12022[(2)] = inst_11810);
(statearr_11949_12022[(1)] = (15));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11917 === (22)))
{var inst_11828 = (state_11916[(8)]);var inst_11831 = cljs.core.async.close_BANG_.call(null,inst_11828);var state_11916__$1 = state_11916;var statearr_11950_12023 = state_11916__$1;(statearr_11950_12023[(2)] = inst_11831);
(statearr_11950_12023[(1)] = (24));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11917 === (36)))
{var inst_11875 = (state_11916[(25)]);var inst_11879 = cljs.core.chunk_first.call(null,inst_11875);var inst_11880 = cljs.core.chunk_rest.call(null,inst_11875);var inst_11881 = cljs.core.count.call(null,inst_11879);var inst_11856 = inst_11880;var inst_11857 = inst_11879;var inst_11858 = inst_11881;var inst_11859 = (0);var state_11916__$1 = (function (){var statearr_11951 = state_11916;(statearr_11951[(20)] = inst_11858);
(statearr_11951[(11)] = inst_11857);
(statearr_11951[(12)] = inst_11859);
(statearr_11951[(21)] = inst_11856);
return statearr_11951;
})();var statearr_11952_12024 = state_11916__$1;(statearr_11952_12024[(2)] = null);
(statearr_11952_12024[(1)] = (25));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11917 === (41)))
{var inst_11875 = (state_11916[(25)]);var inst_11891 = (state_11916[(2)]);var inst_11892 = cljs.core.next.call(null,inst_11875);var inst_11856 = inst_11892;var inst_11857 = null;var inst_11858 = (0);var inst_11859 = (0);var state_11916__$1 = (function (){var statearr_11953 = state_11916;(statearr_11953[(20)] = inst_11858);
(statearr_11953[(27)] = inst_11891);
(statearr_11953[(11)] = inst_11857);
(statearr_11953[(12)] = inst_11859);
(statearr_11953[(21)] = inst_11856);
return statearr_11953;
})();var statearr_11954_12025 = state_11916__$1;(statearr_11954_12025[(2)] = null);
(statearr_11954_12025[(1)] = (25));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11917 === (43)))
{var state_11916__$1 = state_11916;var statearr_11955_12026 = state_11916__$1;(statearr_11955_12026[(2)] = null);
(statearr_11955_12026[(1)] = (44));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11917 === (29)))
{var inst_11900 = (state_11916[(2)]);var state_11916__$1 = state_11916;var statearr_11956_12027 = state_11916__$1;(statearr_11956_12027[(2)] = inst_11900);
(statearr_11956_12027[(1)] = (26));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11917 === (44)))
{var inst_11909 = (state_11916[(2)]);var state_11916__$1 = (function (){var statearr_11957 = state_11916;(statearr_11957[(28)] = inst_11909);
return statearr_11957;
})();var statearr_11958_12028 = state_11916__$1;(statearr_11958_12028[(2)] = null);
(statearr_11958_12028[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11917 === (6)))
{var inst_11848 = (state_11916[(29)]);var inst_11847 = cljs.core.deref.call(null,cs);var inst_11848__$1 = cljs.core.keys.call(null,inst_11847);var inst_11849 = cljs.core.count.call(null,inst_11848__$1);var inst_11850 = cljs.core.reset_BANG_.call(null,dctr,inst_11849);var inst_11855 = cljs.core.seq.call(null,inst_11848__$1);var inst_11856 = inst_11855;var inst_11857 = null;var inst_11858 = (0);var inst_11859 = (0);var state_11916__$1 = (function (){var statearr_11959 = state_11916;(statearr_11959[(30)] = inst_11850);
(statearr_11959[(20)] = inst_11858);
(statearr_11959[(11)] = inst_11857);
(statearr_11959[(12)] = inst_11859);
(statearr_11959[(21)] = inst_11856);
(statearr_11959[(29)] = inst_11848__$1);
return statearr_11959;
})();var statearr_11960_12029 = state_11916__$1;(statearr_11960_12029[(2)] = null);
(statearr_11960_12029[(1)] = (25));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11917 === (28)))
{var inst_11875 = (state_11916[(25)]);var inst_11856 = (state_11916[(21)]);var inst_11875__$1 = cljs.core.seq.call(null,inst_11856);var state_11916__$1 = (function (){var statearr_11961 = state_11916;(statearr_11961[(25)] = inst_11875__$1);
return statearr_11961;
})();if(inst_11875__$1)
{var statearr_11962_12030 = state_11916__$1;(statearr_11962_12030[(1)] = (33));
} else
{var statearr_11963_12031 = state_11916__$1;(statearr_11963_12031[(1)] = (34));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11917 === (25)))
{var inst_11858 = (state_11916[(20)]);var inst_11859 = (state_11916[(12)]);var inst_11861 = (inst_11859 < inst_11858);var inst_11862 = inst_11861;var state_11916__$1 = state_11916;if(cljs.core.truth_(inst_11862))
{var statearr_11964_12032 = state_11916__$1;(statearr_11964_12032[(1)] = (27));
} else
{var statearr_11965_12033 = state_11916__$1;(statearr_11965_12033[(1)] = (28));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11917 === (34)))
{var state_11916__$1 = state_11916;var statearr_11966_12034 = state_11916__$1;(statearr_11966_12034[(2)] = null);
(statearr_11966_12034[(1)] = (35));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11917 === (17)))
{var state_11916__$1 = state_11916;var statearr_11967_12035 = state_11916__$1;(statearr_11967_12035[(2)] = null);
(statearr_11967_12035[(1)] = (18));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11917 === (3)))
{var inst_11914 = (state_11916[(2)]);var state_11916__$1 = state_11916;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11916__$1,inst_11914);
} else
{if((state_val_11917 === (12)))
{var inst_11843 = (state_11916[(2)]);var state_11916__$1 = state_11916;var statearr_11968_12036 = state_11916__$1;(statearr_11968_12036[(2)] = inst_11843);
(statearr_11968_12036[(1)] = (9));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11917 === (2)))
{var state_11916__$1 = state_11916;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11916__$1,(4),ch);
} else
{if((state_val_11917 === (23)))
{var state_11916__$1 = state_11916;var statearr_11969_12037 = state_11916__$1;(statearr_11969_12037[(2)] = null);
(statearr_11969_12037[(1)] = (24));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11917 === (35)))
{var inst_11898 = (state_11916[(2)]);var state_11916__$1 = state_11916;var statearr_11970_12038 = state_11916__$1;(statearr_11970_12038[(2)] = inst_11898);
(statearr_11970_12038[(1)] = (29));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11917 === (19)))
{var inst_11817 = (state_11916[(7)]);var inst_11821 = cljs.core.chunk_first.call(null,inst_11817);var inst_11822 = cljs.core.chunk_rest.call(null,inst_11817);var inst_11823 = cljs.core.count.call(null,inst_11821);var inst_11797 = inst_11822;var inst_11798 = inst_11821;var inst_11799 = inst_11823;var inst_11800 = (0);var state_11916__$1 = (function (){var statearr_11971 = state_11916;(statearr_11971[(14)] = inst_11797);
(statearr_11971[(15)] = inst_11799);
(statearr_11971[(16)] = inst_11800);
(statearr_11971[(17)] = inst_11798);
return statearr_11971;
})();var statearr_11972_12039 = state_11916__$1;(statearr_11972_12039[(2)] = null);
(statearr_11972_12039[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11917 === (11)))
{var inst_11797 = (state_11916[(14)]);var inst_11817 = (state_11916[(7)]);var inst_11817__$1 = cljs.core.seq.call(null,inst_11797);var state_11916__$1 = (function (){var statearr_11973 = state_11916;(statearr_11973[(7)] = inst_11817__$1);
return statearr_11973;
})();if(inst_11817__$1)
{var statearr_11974_12040 = state_11916__$1;(statearr_11974_12040[(1)] = (16));
} else
{var statearr_11975_12041 = state_11916__$1;(statearr_11975_12041[(1)] = (17));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11917 === (9)))
{var inst_11845 = (state_11916[(2)]);var state_11916__$1 = state_11916;var statearr_11976_12042 = state_11916__$1;(statearr_11976_12042[(2)] = inst_11845);
(statearr_11976_12042[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11917 === (5)))
{var inst_11795 = cljs.core.deref.call(null,cs);var inst_11796 = cljs.core.seq.call(null,inst_11795);var inst_11797 = inst_11796;var inst_11798 = null;var inst_11799 = (0);var inst_11800 = (0);var state_11916__$1 = (function (){var statearr_11977 = state_11916;(statearr_11977[(14)] = inst_11797);
(statearr_11977[(15)] = inst_11799);
(statearr_11977[(16)] = inst_11800);
(statearr_11977[(17)] = inst_11798);
return statearr_11977;
})();var statearr_11978_12043 = state_11916__$1;(statearr_11978_12043[(2)] = null);
(statearr_11978_12043[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11917 === (14)))
{var state_11916__$1 = state_11916;var statearr_11979_12044 = state_11916__$1;(statearr_11979_12044[(2)] = null);
(statearr_11979_12044[(1)] = (15));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11917 === (45)))
{var inst_11906 = (state_11916[(2)]);var state_11916__$1 = state_11916;var statearr_11980_12045 = state_11916__$1;(statearr_11980_12045[(2)] = inst_11906);
(statearr_11980_12045[(1)] = (44));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11917 === (26)))
{var inst_11848 = (state_11916[(29)]);var inst_11902 = (state_11916[(2)]);var inst_11903 = cljs.core.seq.call(null,inst_11848);var state_11916__$1 = (function (){var statearr_11981 = state_11916;(statearr_11981[(31)] = inst_11902);
return statearr_11981;
})();if(inst_11903)
{var statearr_11982_12046 = state_11916__$1;(statearr_11982_12046[(1)] = (42));
} else
{var statearr_11983_12047 = state_11916__$1;(statearr_11983_12047[(1)] = (43));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11917 === (16)))
{var inst_11817 = (state_11916[(7)]);var inst_11819 = cljs.core.chunked_seq_QMARK_.call(null,inst_11817);var state_11916__$1 = state_11916;if(inst_11819)
{var statearr_11984_12048 = state_11916__$1;(statearr_11984_12048[(1)] = (19));
} else
{var statearr_11985_12049 = state_11916__$1;(statearr_11985_12049[(1)] = (20));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11917 === (38)))
{var inst_11895 = (state_11916[(2)]);var state_11916__$1 = state_11916;var statearr_11986_12050 = state_11916__$1;(statearr_11986_12050[(2)] = inst_11895);
(statearr_11986_12050[(1)] = (35));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11917 === (30)))
{var state_11916__$1 = state_11916;var statearr_11987_12051 = state_11916__$1;(statearr_11987_12051[(2)] = null);
(statearr_11987_12051[(1)] = (32));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11917 === (10)))
{var inst_11800 = (state_11916[(16)]);var inst_11798 = (state_11916[(17)]);var inst_11806 = cljs.core._nth.call(null,inst_11798,inst_11800);var inst_11807 = cljs.core.nth.call(null,inst_11806,(0),null);var inst_11808 = cljs.core.nth.call(null,inst_11806,(1),null);var state_11916__$1 = (function (){var statearr_11988 = state_11916;(statearr_11988[(26)] = inst_11807);
return statearr_11988;
})();if(cljs.core.truth_(inst_11808))
{var statearr_11989_12052 = state_11916__$1;(statearr_11989_12052[(1)] = (13));
} else
{var statearr_11990_12053 = state_11916__$1;(statearr_11990_12053[(1)] = (14));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11917 === (18)))
{var inst_11841 = (state_11916[(2)]);var state_11916__$1 = state_11916;var statearr_11991_12054 = state_11916__$1;(statearr_11991_12054[(2)] = inst_11841);
(statearr_11991_12054[(1)] = (12));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11917 === (42)))
{var state_11916__$1 = state_11916;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11916__$1,(45),dchan);
} else
{if((state_val_11917 === (37)))
{var inst_11788 = (state_11916[(9)]);var inst_11884 = (state_11916[(23)]);var inst_11875 = (state_11916[(25)]);var inst_11884__$1 = cljs.core.first.call(null,inst_11875);var inst_11885 = cljs.core.async.put_BANG_.call(null,inst_11884__$1,inst_11788,done);var state_11916__$1 = (function (){var statearr_11992 = state_11916;(statearr_11992[(23)] = inst_11884__$1);
return statearr_11992;
})();if(cljs.core.truth_(inst_11885))
{var statearr_11993_12055 = state_11916__$1;(statearr_11993_12055[(1)] = (39));
} else
{var statearr_11994_12056 = state_11916__$1;(statearr_11994_12056[(1)] = (40));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_11917 === (8)))
{var inst_11799 = (state_11916[(15)]);var inst_11800 = (state_11916[(16)]);var inst_11802 = (inst_11800 < inst_11799);var inst_11803 = inst_11802;var state_11916__$1 = state_11916;if(cljs.core.truth_(inst_11803))
{var statearr_11995_12057 = state_11916__$1;(statearr_11995_12057[(1)] = (10));
} else
{var statearr_11996_12058 = state_11916__$1;(statearr_11996_12058[(1)] = (11));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__5915__auto___12004,cs,m,dchan,dctr,done))
;return ((function (switch__5900__auto__,c__5915__auto___12004,cs,m,dchan,dctr,done){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_12000 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_12000[(0)] = state_machine__5901__auto__);
(statearr_12000[(1)] = (1));
return statearr_12000;
});
var state_machine__5901__auto____1 = (function (state_11916){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_11916);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e12001){if((e12001 instanceof Object))
{var ex__5904__auto__ = e12001;var statearr_12002_12059 = state_11916;(statearr_12002_12059[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11916);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e12001;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__12060 = state_11916;
state_11916 = G__12060;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_11916){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_11916);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto___12004,cs,m,dchan,dctr,done))
})();var state__5917__auto__ = (function (){var statearr_12003 = f__5916__auto__.call(null);(statearr_12003[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto___12004);
return statearr_12003;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto___12004,cs,m,dchan,dctr,done))
);
return m;
});
/**
* Copies the mult source onto the supplied channel.
* 
* By default the channel will be closed when the source closes,
* but can be determined by the close? parameter.
*/
cljs.core.async.tap = (function() {
var tap = null;
var tap__2 = (function (mult,ch){return tap.call(null,mult,ch,true);
});
var tap__3 = (function (mult,ch,close_QMARK_){cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);
return ch;
});
tap = function(mult,ch,close_QMARK_){
switch(arguments.length){
case 2:
return tap__2.call(this,mult,ch);
case 3:
return tap__3.call(this,mult,ch,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
tap.cljs$core$IFn$_invoke$arity$2 = tap__2;
tap.cljs$core$IFn$_invoke$arity$3 = tap__3;
return tap;
})()
;
/**
* Disconnects a target channel from a mult
*/
cljs.core.async.untap = (function untap(mult,ch){return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
* Disconnects all target channels from a mult
*/
cljs.core.async.untap_all = (function untap_all(mult){return cljs.core.async.untap_all_STAR_.call(null,mult);
});
cljs.core.async.Mix = (function (){var obj12062 = {};return obj12062;
})();
cljs.core.async.admix_STAR_ = (function admix_STAR_(m,ch){if((function (){var and__3636__auto__ = m;if(and__3636__auto__)
{return m.cljs$core$async$Mix$admix_STAR_$arity$2;
} else
{return and__3636__auto__;
}
})())
{return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else
{var x__4285__auto__ = (((m == null))?null:m);return (function (){var or__3648__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4285__auto__)]);if(or__3648__auto__)
{return or__3648__auto__;
} else
{var or__3648__auto____$1 = (cljs.core.async.admix_STAR_["_"]);if(or__3648__auto____$1)
{return or__3648__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
})().call(null,m,ch);
}
});
cljs.core.async.unmix_STAR_ = (function unmix_STAR_(m,ch){if((function (){var and__3636__auto__ = m;if(and__3636__auto__)
{return m.cljs$core$async$Mix$unmix_STAR_$arity$2;
} else
{return and__3636__auto__;
}
})())
{return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else
{var x__4285__auto__ = (((m == null))?null:m);return (function (){var or__3648__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4285__auto__)]);if(or__3648__auto__)
{return or__3648__auto__;
} else
{var or__3648__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);if(or__3648__auto____$1)
{return or__3648__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
})().call(null,m,ch);
}
});
cljs.core.async.unmix_all_STAR_ = (function unmix_all_STAR_(m){if((function (){var and__3636__auto__ = m;if(and__3636__auto__)
{return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1;
} else
{return and__3636__auto__;
}
})())
{return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else
{var x__4285__auto__ = (((m == null))?null:m);return (function (){var or__3648__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4285__auto__)]);if(or__3648__auto__)
{return or__3648__auto__;
} else
{var or__3648__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);if(or__3648__auto____$1)
{return or__3648__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
})().call(null,m);
}
});
cljs.core.async.toggle_STAR_ = (function toggle_STAR_(m,state_map){if((function (){var and__3636__auto__ = m;if(and__3636__auto__)
{return m.cljs$core$async$Mix$toggle_STAR_$arity$2;
} else
{return and__3636__auto__;
}
})())
{return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else
{var x__4285__auto__ = (((m == null))?null:m);return (function (){var or__3648__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4285__auto__)]);if(or__3648__auto__)
{return or__3648__auto__;
} else
{var or__3648__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);if(or__3648__auto____$1)
{return or__3648__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
})().call(null,m,state_map);
}
});
cljs.core.async.solo_mode_STAR_ = (function solo_mode_STAR_(m,mode){if((function (){var and__3636__auto__ = m;if(and__3636__auto__)
{return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2;
} else
{return and__3636__auto__;
}
})())
{return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else
{var x__4285__auto__ = (((m == null))?null:m);return (function (){var or__3648__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4285__auto__)]);if(or__3648__auto__)
{return or__3648__auto__;
} else
{var or__3648__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);if(or__3648__auto____$1)
{return or__3648__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
})().call(null,m,mode);
}
});
/**
* @param {...*} var_args
*/
cljs.core.async.ioc_alts_BANG_ = (function() { 
var ioc_alts_BANG___delegate = function (state,cont_block,ports,p__12063){var map__12068 = p__12063;var map__12068__$1 = ((cljs.core.seq_QMARK_.call(null,map__12068))?cljs.core.apply.call(null,cljs.core.hash_map,map__12068):map__12068);var opts = map__12068__$1;var statearr_12069_12072 = state;(statearr_12069_12072[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);
var temp__4126__auto__ = cljs.core.async.do_alts.call(null,((function (map__12068,map__12068__$1,opts){
return (function (val){var statearr_12070_12073 = state;(statearr_12070_12073[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__12068,map__12068__$1,opts))
,ports,opts);if(cljs.core.truth_(temp__4126__auto__))
{var cb = temp__4126__auto__;var statearr_12071_12074 = state;(statearr_12071_12074[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
};
var ioc_alts_BANG_ = function (state,cont_block,ports,var_args){
var p__12063 = null;if (arguments.length > 3) {
  p__12063 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3),0);} 
return ioc_alts_BANG___delegate.call(this,state,cont_block,ports,p__12063);};
ioc_alts_BANG_.cljs$lang$maxFixedArity = 3;
ioc_alts_BANG_.cljs$lang$applyTo = (function (arglist__12075){
var state = cljs.core.first(arglist__12075);
arglist__12075 = cljs.core.next(arglist__12075);
var cont_block = cljs.core.first(arglist__12075);
arglist__12075 = cljs.core.next(arglist__12075);
var ports = cljs.core.first(arglist__12075);
var p__12063 = cljs.core.rest(arglist__12075);
return ioc_alts_BANG___delegate(state,cont_block,ports,p__12063);
});
ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = ioc_alts_BANG___delegate;
return ioc_alts_BANG_;
})()
;
/**
* Creates and returns a mix of one or more input channels which will
* be put on the supplied out channel. Input sources can be added to
* the mix with 'admix', and removed with 'unmix'. A mix supports
* soloing, muting and pausing multiple inputs atomically using
* 'toggle', and can solo using either muting or pausing as determined
* by 'solo-mode'.
* 
* Each channel can have zero or more boolean modes set via 'toggle':
* 
* :solo - when true, only this (ond other soloed) channel(s) will appear
* in the mix output channel. :mute and :pause states of soloed
* channels are ignored. If solo-mode is :mute, non-soloed
* channels are muted, if :pause, non-soloed channels are
* paused.
* 
* :mute - muted channels will have their contents consumed but not included in the mix
* :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
*/
cljs.core.async.mix = (function mix(out){var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));var change = cljs.core.async.chan.call(null);var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){if(cljs.core.truth_(attr.call(null,v)))
{return cljs.core.conj.call(null,ret,c);
} else
{return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){var chs = cljs.core.deref.call(null,cs);var mode = cljs.core.deref.call(null,solo_mode);var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;var m = (function (){if(typeof cljs.core.async.t12195 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t12195 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta12196){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta12196 = meta12196;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t12195.cljs$lang$type = true;
cljs.core.async.t12195.cljs$lang$ctorStr = "cljs.core.async/t12195";
cljs.core.async.t12195.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__4225__auto__,writer__4226__auto__,opt__4227__auto__){return cljs.core._write.call(null,writer__4226__auto__,"cljs.core.async/t12195");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t12195.prototype.cljs$core$async$Mix$ = true;
cljs.core.async.t12195.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){var self__ = this;
var ___$1 = this;cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);
return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t12195.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){var self__ = this;
var ___$1 = this;cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);
return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t12195.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){var self__ = this;
var ___$1 = this;cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);
return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t12195.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){var self__ = this;
var ___$1 = this;cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);
return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t12195.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){var self__ = this;
var ___$1 = this;if(cljs.core.truth_(self__.solo_modes.call(null,mode)))
{} else
{throw (new Error(("Assert failed: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(("mode must be one of: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)))+"\n"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null)))))));
}
cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);
return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t12195.prototype.cljs$core$async$Mux$ = true;
cljs.core.async.t12195.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){var self__ = this;
var ___$1 = this;return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t12195.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_12197){var self__ = this;
var _12197__$1 = this;return self__.meta12196;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t12195.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_12197,meta12196__$1){var self__ = this;
var _12197__$1 = this;return (new cljs.core.async.t12195(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta12196__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.__GT_t12195 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function __GT_t12195(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta12196){return (new cljs.core.async.t12195(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta12196));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
}
return (new cljs.core.async.t12195(change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,null));
})();var c__5915__auto___12314 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto___12314,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto___12314,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_12267){var state_val_12268 = (state_12267[(1)]);if((state_val_12268 === (7)))
{var inst_12211 = (state_12267[(7)]);var inst_12216 = cljs.core.apply.call(null,cljs.core.hash_map,inst_12211);var state_12267__$1 = state_12267;var statearr_12269_12315 = state_12267__$1;(statearr_12269_12315[(2)] = inst_12216);
(statearr_12269_12315[(1)] = (9));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12268 === (20)))
{var inst_12226 = (state_12267[(8)]);var state_12267__$1 = state_12267;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12267__$1,(23),out,inst_12226);
} else
{if((state_val_12268 === (1)))
{var inst_12201 = (state_12267[(9)]);var inst_12201__$1 = calc_state.call(null);var inst_12202 = cljs.core.seq_QMARK_.call(null,inst_12201__$1);var state_12267__$1 = (function (){var statearr_12270 = state_12267;(statearr_12270[(9)] = inst_12201__$1);
return statearr_12270;
})();if(inst_12202)
{var statearr_12271_12316 = state_12267__$1;(statearr_12271_12316[(1)] = (2));
} else
{var statearr_12272_12317 = state_12267__$1;(statearr_12272_12317[(1)] = (3));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12268 === (24)))
{var inst_12219 = (state_12267[(10)]);var inst_12211 = inst_12219;var state_12267__$1 = (function (){var statearr_12273 = state_12267;(statearr_12273[(7)] = inst_12211);
return statearr_12273;
})();var statearr_12274_12318 = state_12267__$1;(statearr_12274_12318[(2)] = null);
(statearr_12274_12318[(1)] = (5));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12268 === (4)))
{var inst_12201 = (state_12267[(9)]);var inst_12207 = (state_12267[(2)]);var inst_12208 = cljs.core.get.call(null,inst_12207,new cljs.core.Keyword(null,"reads","reads",-1215067361));var inst_12209 = cljs.core.get.call(null,inst_12207,new cljs.core.Keyword(null,"mutes","mutes",1068806309));var inst_12210 = cljs.core.get.call(null,inst_12207,new cljs.core.Keyword(null,"solos","solos",1441458643));var inst_12211 = inst_12201;var state_12267__$1 = (function (){var statearr_12275 = state_12267;(statearr_12275[(11)] = inst_12209);
(statearr_12275[(12)] = inst_12208);
(statearr_12275[(7)] = inst_12211);
(statearr_12275[(13)] = inst_12210);
return statearr_12275;
})();var statearr_12276_12319 = state_12267__$1;(statearr_12276_12319[(2)] = null);
(statearr_12276_12319[(1)] = (5));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12268 === (15)))
{var state_12267__$1 = state_12267;var statearr_12277_12320 = state_12267__$1;(statearr_12277_12320[(2)] = null);
(statearr_12277_12320[(1)] = (16));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12268 === (21)))
{var inst_12219 = (state_12267[(10)]);var inst_12211 = inst_12219;var state_12267__$1 = (function (){var statearr_12278 = state_12267;(statearr_12278[(7)] = inst_12211);
return statearr_12278;
})();var statearr_12279_12321 = state_12267__$1;(statearr_12279_12321[(2)] = null);
(statearr_12279_12321[(1)] = (5));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12268 === (13)))
{var inst_12263 = (state_12267[(2)]);var state_12267__$1 = state_12267;var statearr_12280_12322 = state_12267__$1;(statearr_12280_12322[(2)] = inst_12263);
(statearr_12280_12322[(1)] = (6));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12268 === (22)))
{var inst_12261 = (state_12267[(2)]);var state_12267__$1 = state_12267;var statearr_12281_12323 = state_12267__$1;(statearr_12281_12323[(2)] = inst_12261);
(statearr_12281_12323[(1)] = (13));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12268 === (6)))
{var inst_12265 = (state_12267[(2)]);var state_12267__$1 = state_12267;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12267__$1,inst_12265);
} else
{if((state_val_12268 === (25)))
{var state_12267__$1 = state_12267;var statearr_12282_12324 = state_12267__$1;(statearr_12282_12324[(2)] = null);
(statearr_12282_12324[(1)] = (26));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12268 === (17)))
{var inst_12241 = (state_12267[(14)]);var state_12267__$1 = state_12267;var statearr_12283_12325 = state_12267__$1;(statearr_12283_12325[(2)] = inst_12241);
(statearr_12283_12325[(1)] = (19));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12268 === (3)))
{var inst_12201 = (state_12267[(9)]);var state_12267__$1 = state_12267;var statearr_12284_12326 = state_12267__$1;(statearr_12284_12326[(2)] = inst_12201);
(statearr_12284_12326[(1)] = (4));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12268 === (12)))
{var inst_12227 = (state_12267[(15)]);var inst_12222 = (state_12267[(16)]);var inst_12241 = (state_12267[(14)]);var inst_12241__$1 = inst_12222.call(null,inst_12227);var state_12267__$1 = (function (){var statearr_12285 = state_12267;(statearr_12285[(14)] = inst_12241__$1);
return statearr_12285;
})();if(cljs.core.truth_(inst_12241__$1))
{var statearr_12286_12327 = state_12267__$1;(statearr_12286_12327[(1)] = (17));
} else
{var statearr_12287_12328 = state_12267__$1;(statearr_12287_12328[(1)] = (18));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12268 === (2)))
{var inst_12201 = (state_12267[(9)]);var inst_12204 = cljs.core.apply.call(null,cljs.core.hash_map,inst_12201);var state_12267__$1 = state_12267;var statearr_12288_12329 = state_12267__$1;(statearr_12288_12329[(2)] = inst_12204);
(statearr_12288_12329[(1)] = (4));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12268 === (23)))
{var inst_12252 = (state_12267[(2)]);var state_12267__$1 = state_12267;if(cljs.core.truth_(inst_12252))
{var statearr_12289_12330 = state_12267__$1;(statearr_12289_12330[(1)] = (24));
} else
{var statearr_12290_12331 = state_12267__$1;(statearr_12290_12331[(1)] = (25));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12268 === (19)))
{var inst_12249 = (state_12267[(2)]);var state_12267__$1 = state_12267;if(cljs.core.truth_(inst_12249))
{var statearr_12291_12332 = state_12267__$1;(statearr_12291_12332[(1)] = (20));
} else
{var statearr_12292_12333 = state_12267__$1;(statearr_12292_12333[(1)] = (21));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12268 === (11)))
{var inst_12226 = (state_12267[(8)]);var inst_12232 = (inst_12226 == null);var state_12267__$1 = state_12267;if(cljs.core.truth_(inst_12232))
{var statearr_12293_12334 = state_12267__$1;(statearr_12293_12334[(1)] = (14));
} else
{var statearr_12294_12335 = state_12267__$1;(statearr_12294_12335[(1)] = (15));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12268 === (9)))
{var inst_12219 = (state_12267[(10)]);var inst_12219__$1 = (state_12267[(2)]);var inst_12220 = cljs.core.get.call(null,inst_12219__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));var inst_12221 = cljs.core.get.call(null,inst_12219__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));var inst_12222 = cljs.core.get.call(null,inst_12219__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));var state_12267__$1 = (function (){var statearr_12295 = state_12267;(statearr_12295[(16)] = inst_12222);
(statearr_12295[(17)] = inst_12221);
(statearr_12295[(10)] = inst_12219__$1);
return statearr_12295;
})();return cljs.core.async.ioc_alts_BANG_.call(null,state_12267__$1,(10),inst_12220);
} else
{if((state_val_12268 === (5)))
{var inst_12211 = (state_12267[(7)]);var inst_12214 = cljs.core.seq_QMARK_.call(null,inst_12211);var state_12267__$1 = state_12267;if(inst_12214)
{var statearr_12296_12336 = state_12267__$1;(statearr_12296_12336[(1)] = (7));
} else
{var statearr_12297_12337 = state_12267__$1;(statearr_12297_12337[(1)] = (8));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12268 === (14)))
{var inst_12227 = (state_12267[(15)]);var inst_12234 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_12227);var state_12267__$1 = state_12267;var statearr_12298_12338 = state_12267__$1;(statearr_12298_12338[(2)] = inst_12234);
(statearr_12298_12338[(1)] = (16));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12268 === (26)))
{var inst_12257 = (state_12267[(2)]);var state_12267__$1 = state_12267;var statearr_12299_12339 = state_12267__$1;(statearr_12299_12339[(2)] = inst_12257);
(statearr_12299_12339[(1)] = (22));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12268 === (16)))
{var inst_12237 = (state_12267[(2)]);var inst_12238 = calc_state.call(null);var inst_12211 = inst_12238;var state_12267__$1 = (function (){var statearr_12300 = state_12267;(statearr_12300[(7)] = inst_12211);
(statearr_12300[(18)] = inst_12237);
return statearr_12300;
})();var statearr_12301_12340 = state_12267__$1;(statearr_12301_12340[(2)] = null);
(statearr_12301_12340[(1)] = (5));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12268 === (10)))
{var inst_12227 = (state_12267[(15)]);var inst_12226 = (state_12267[(8)]);var inst_12225 = (state_12267[(2)]);var inst_12226__$1 = cljs.core.nth.call(null,inst_12225,(0),null);var inst_12227__$1 = cljs.core.nth.call(null,inst_12225,(1),null);var inst_12228 = (inst_12226__$1 == null);var inst_12229 = cljs.core._EQ_.call(null,inst_12227__$1,change);var inst_12230 = (inst_12228) || (inst_12229);var state_12267__$1 = (function (){var statearr_12302 = state_12267;(statearr_12302[(15)] = inst_12227__$1);
(statearr_12302[(8)] = inst_12226__$1);
return statearr_12302;
})();if(cljs.core.truth_(inst_12230))
{var statearr_12303_12341 = state_12267__$1;(statearr_12303_12341[(1)] = (11));
} else
{var statearr_12304_12342 = state_12267__$1;(statearr_12304_12342[(1)] = (12));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12268 === (18)))
{var inst_12227 = (state_12267[(15)]);var inst_12222 = (state_12267[(16)]);var inst_12221 = (state_12267[(17)]);var inst_12244 = cljs.core.empty_QMARK_.call(null,inst_12222);var inst_12245 = inst_12221.call(null,inst_12227);var inst_12246 = cljs.core.not.call(null,inst_12245);var inst_12247 = (inst_12244) && (inst_12246);var state_12267__$1 = state_12267;var statearr_12305_12343 = state_12267__$1;(statearr_12305_12343[(2)] = inst_12247);
(statearr_12305_12343[(1)] = (19));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12268 === (8)))
{var inst_12211 = (state_12267[(7)]);var state_12267__$1 = state_12267;var statearr_12306_12344 = state_12267__$1;(statearr_12306_12344[(2)] = inst_12211);
(statearr_12306_12344[(1)] = (9));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__5915__auto___12314,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;return ((function (switch__5900__auto__,c__5915__auto___12314,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_12310 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_12310[(0)] = state_machine__5901__auto__);
(statearr_12310[(1)] = (1));
return statearr_12310;
});
var state_machine__5901__auto____1 = (function (state_12267){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_12267);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e12311){if((e12311 instanceof Object))
{var ex__5904__auto__ = e12311;var statearr_12312_12345 = state_12267;(statearr_12312_12345[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12267);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e12311;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__12346 = state_12267;
state_12267 = G__12346;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_12267){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_12267);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto___12314,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();var state__5917__auto__ = (function (){var statearr_12313 = f__5916__auto__.call(null);(statearr_12313[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto___12314);
return statearr_12313;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto___12314,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);
return m;
});
/**
* Adds ch as an input to the mix
*/
cljs.core.async.admix = (function admix(mix,ch){return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
* Removes ch as an input to the mix
*/
cljs.core.async.unmix = (function unmix(mix,ch){return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
* removes all inputs from the mix
*/
cljs.core.async.unmix_all = (function unmix_all(mix){return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
* Atomically sets the state(s) of one or more channels in a mix. The
* state map is a map of channels -> channel-state-map. A
* channel-state-map is a map of attrs -> boolean, where attr is one or
* more of :mute, :pause or :solo. Any states supplied are merged with
* the current state.
* 
* Note that channels can be added to a mix via toggle, which can be
* used to add channels in a particular (e.g. paused) state.
*/
cljs.core.async.toggle = (function toggle(mix,state_map){return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
* Sets the solo mode of the mix. mode must be one of :mute or :pause
*/
cljs.core.async.solo_mode = (function solo_mode(mix,mode){return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});
cljs.core.async.Pub = (function (){var obj12348 = {};return obj12348;
})();
cljs.core.async.sub_STAR_ = (function sub_STAR_(p,v,ch,close_QMARK_){if((function (){var and__3636__auto__ = p;if(and__3636__auto__)
{return p.cljs$core$async$Pub$sub_STAR_$arity$4;
} else
{return and__3636__auto__;
}
})())
{return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else
{var x__4285__auto__ = (((p == null))?null:p);return (function (){var or__3648__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4285__auto__)]);if(or__3648__auto__)
{return or__3648__auto__;
} else
{var or__3648__auto____$1 = (cljs.core.async.sub_STAR_["_"]);if(or__3648__auto____$1)
{return or__3648__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
})().call(null,p,v,ch,close_QMARK_);
}
});
cljs.core.async.unsub_STAR_ = (function unsub_STAR_(p,v,ch){if((function (){var and__3636__auto__ = p;if(and__3636__auto__)
{return p.cljs$core$async$Pub$unsub_STAR_$arity$3;
} else
{return and__3636__auto__;
}
})())
{return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else
{var x__4285__auto__ = (((p == null))?null:p);return (function (){var or__3648__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4285__auto__)]);if(or__3648__auto__)
{return or__3648__auto__;
} else
{var or__3648__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);if(or__3648__auto____$1)
{return or__3648__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
})().call(null,p,v,ch);
}
});
cljs.core.async.unsub_all_STAR_ = (function() {
var unsub_all_STAR_ = null;
var unsub_all_STAR___1 = (function (p){if((function (){var and__3636__auto__ = p;if(and__3636__auto__)
{return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1;
} else
{return and__3636__auto__;
}
})())
{return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else
{var x__4285__auto__ = (((p == null))?null:p);return (function (){var or__3648__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4285__auto__)]);if(or__3648__auto__)
{return or__3648__auto__;
} else
{var or__3648__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);if(or__3648__auto____$1)
{return or__3648__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
})().call(null,p);
}
});
var unsub_all_STAR___2 = (function (p,v){if((function (){var and__3636__auto__ = p;if(and__3636__auto__)
{return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2;
} else
{return and__3636__auto__;
}
})())
{return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else
{var x__4285__auto__ = (((p == null))?null:p);return (function (){var or__3648__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4285__auto__)]);if(or__3648__auto__)
{return or__3648__auto__;
} else
{var or__3648__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);if(or__3648__auto____$1)
{return or__3648__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
})().call(null,p,v);
}
});
unsub_all_STAR_ = function(p,v){
switch(arguments.length){
case 1:
return unsub_all_STAR___1.call(this,p);
case 2:
return unsub_all_STAR___2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = unsub_all_STAR___1;
unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = unsub_all_STAR___2;
return unsub_all_STAR_;
})()
;
/**
* Creates and returns a pub(lication) of the supplied channel,
* partitioned into topics by the topic-fn. topic-fn will be applied to
* each value on the channel and the result will determine the 'topic'
* on which that value will be put. Channels can be subscribed to
* receive copies of topics using 'sub', and unsubscribed using
* 'unsub'. Each topic will be handled by an internal mult on a
* dedicated channel. By default these internal channels are
* unbuffered, but a buf-fn can be supplied which, given a topic,
* creates a buffer with desired properties.
* 
* Each item is distributed to all subs in parallel and synchronously,
* i.e. each sub must accept before the next item is distributed. Use
* buffering/windowing to prevent slow subs from holding up the pub.
* 
* Items received when there are no matching subs get dropped.
* 
* Note that if buf-fns are used then each topic is handled
* asynchronously, i.e. if a channel is subscribed to more than one
* topic it should not expect them to be interleaved identically with
* the source.
*/
cljs.core.async.pub = (function() {
var pub = null;
var pub__2 = (function (ch,topic_fn){return pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});
var pub__3 = (function (ch,topic_fn,buf_fn){var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);var ensure_mult = ((function (mults){
return (function (topic){var or__3648__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);if(cljs.core.truth_(or__3648__auto__))
{return or__3648__auto__;
} else
{return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__3648__auto__,mults){
return (function (p1__12349_SHARP_){if(cljs.core.truth_(p1__12349_SHARP_.call(null,topic)))
{return p1__12349_SHARP_;
} else
{return cljs.core.assoc.call(null,p1__12349_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__3648__auto__,mults))
),topic);
}
});})(mults))
;var p = (function (){if(typeof cljs.core.async.t12472 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t12472 = (function (ensure_mult,mults,buf_fn,topic_fn,ch,pub,meta12473){
this.ensure_mult = ensure_mult;
this.mults = mults;
this.buf_fn = buf_fn;
this.topic_fn = topic_fn;
this.ch = ch;
this.pub = pub;
this.meta12473 = meta12473;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t12472.cljs$lang$type = true;
cljs.core.async.t12472.cljs$lang$ctorStr = "cljs.core.async/t12472";
cljs.core.async.t12472.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__4225__auto__,writer__4226__auto__,opt__4227__auto__){return cljs.core._write.call(null,writer__4226__auto__,"cljs.core.async/t12472");
});})(mults,ensure_mult))
;
cljs.core.async.t12472.prototype.cljs$core$async$Pub$ = true;
cljs.core.async.t12472.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$2,close_QMARK_){var self__ = this;
var p__$1 = this;var m = self__.ensure_mult.call(null,topic);return cljs.core.async.tap.call(null,m,ch__$2,close_QMARK_);
});})(mults,ensure_mult))
;
cljs.core.async.t12472.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$2){var self__ = this;
var p__$1 = this;var temp__4126__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);if(cljs.core.truth_(temp__4126__auto__))
{var m = temp__4126__auto__;return cljs.core.async.untap.call(null,m,ch__$2);
} else
{return null;
}
});})(mults,ensure_mult))
;
cljs.core.async.t12472.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){var self__ = this;
var ___$1 = this;return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;
cljs.core.async.t12472.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){var self__ = this;
var ___$1 = this;return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;
cljs.core.async.t12472.prototype.cljs$core$async$Mux$ = true;
cljs.core.async.t12472.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){var self__ = this;
var ___$1 = this;return self__.ch;
});})(mults,ensure_mult))
;
cljs.core.async.t12472.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_12474){var self__ = this;
var _12474__$1 = this;return self__.meta12473;
});})(mults,ensure_mult))
;
cljs.core.async.t12472.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_12474,meta12473__$1){var self__ = this;
var _12474__$1 = this;return (new cljs.core.async.t12472(self__.ensure_mult,self__.mults,self__.buf_fn,self__.topic_fn,self__.ch,self__.pub,meta12473__$1));
});})(mults,ensure_mult))
;
cljs.core.async.__GT_t12472 = ((function (mults,ensure_mult){
return (function __GT_t12472(ensure_mult__$1,mults__$1,buf_fn__$1,topic_fn__$1,ch__$1,pub__$1,meta12473){return (new cljs.core.async.t12472(ensure_mult__$1,mults__$1,buf_fn__$1,topic_fn__$1,ch__$1,pub__$1,meta12473));
});})(mults,ensure_mult))
;
}
return (new cljs.core.async.t12472(ensure_mult,mults,buf_fn,topic_fn,ch,pub,null));
})();var c__5915__auto___12594 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto___12594,mults,ensure_mult,p){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto___12594,mults,ensure_mult,p){
return (function (state_12546){var state_val_12547 = (state_12546[(1)]);if((state_val_12547 === (7)))
{var inst_12542 = (state_12546[(2)]);var state_12546__$1 = state_12546;var statearr_12548_12595 = state_12546__$1;(statearr_12548_12595[(2)] = inst_12542);
(statearr_12548_12595[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12547 === (20)))
{var state_12546__$1 = state_12546;var statearr_12549_12596 = state_12546__$1;(statearr_12549_12596[(2)] = null);
(statearr_12549_12596[(1)] = (21));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12547 === (1)))
{var state_12546__$1 = state_12546;var statearr_12550_12597 = state_12546__$1;(statearr_12550_12597[(2)] = null);
(statearr_12550_12597[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12547 === (24)))
{var inst_12525 = (state_12546[(7)]);var inst_12534 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_12525);var state_12546__$1 = state_12546;var statearr_12551_12598 = state_12546__$1;(statearr_12551_12598[(2)] = inst_12534);
(statearr_12551_12598[(1)] = (25));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12547 === (4)))
{var inst_12477 = (state_12546[(8)]);var inst_12477__$1 = (state_12546[(2)]);var inst_12478 = (inst_12477__$1 == null);var state_12546__$1 = (function (){var statearr_12552 = state_12546;(statearr_12552[(8)] = inst_12477__$1);
return statearr_12552;
})();if(cljs.core.truth_(inst_12478))
{var statearr_12553_12599 = state_12546__$1;(statearr_12553_12599[(1)] = (5));
} else
{var statearr_12554_12600 = state_12546__$1;(statearr_12554_12600[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12547 === (15)))
{var inst_12519 = (state_12546[(2)]);var state_12546__$1 = state_12546;var statearr_12555_12601 = state_12546__$1;(statearr_12555_12601[(2)] = inst_12519);
(statearr_12555_12601[(1)] = (12));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12547 === (21)))
{var inst_12539 = (state_12546[(2)]);var state_12546__$1 = (function (){var statearr_12556 = state_12546;(statearr_12556[(9)] = inst_12539);
return statearr_12556;
})();var statearr_12557_12602 = state_12546__$1;(statearr_12557_12602[(2)] = null);
(statearr_12557_12602[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12547 === (13)))
{var inst_12501 = (state_12546[(10)]);var inst_12503 = cljs.core.chunked_seq_QMARK_.call(null,inst_12501);var state_12546__$1 = state_12546;if(inst_12503)
{var statearr_12558_12603 = state_12546__$1;(statearr_12558_12603[(1)] = (16));
} else
{var statearr_12559_12604 = state_12546__$1;(statearr_12559_12604[(1)] = (17));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12547 === (22)))
{var inst_12531 = (state_12546[(2)]);var state_12546__$1 = state_12546;if(cljs.core.truth_(inst_12531))
{var statearr_12560_12605 = state_12546__$1;(statearr_12560_12605[(1)] = (23));
} else
{var statearr_12561_12606 = state_12546__$1;(statearr_12561_12606[(1)] = (24));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12547 === (6)))
{var inst_12525 = (state_12546[(7)]);var inst_12477 = (state_12546[(8)]);var inst_12527 = (state_12546[(11)]);var inst_12525__$1 = topic_fn.call(null,inst_12477);var inst_12526 = cljs.core.deref.call(null,mults);var inst_12527__$1 = cljs.core.get.call(null,inst_12526,inst_12525__$1);var state_12546__$1 = (function (){var statearr_12562 = state_12546;(statearr_12562[(7)] = inst_12525__$1);
(statearr_12562[(11)] = inst_12527__$1);
return statearr_12562;
})();if(cljs.core.truth_(inst_12527__$1))
{var statearr_12563_12607 = state_12546__$1;(statearr_12563_12607[(1)] = (19));
} else
{var statearr_12564_12608 = state_12546__$1;(statearr_12564_12608[(1)] = (20));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12547 === (25)))
{var inst_12536 = (state_12546[(2)]);var state_12546__$1 = state_12546;var statearr_12565_12609 = state_12546__$1;(statearr_12565_12609[(2)] = inst_12536);
(statearr_12565_12609[(1)] = (21));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12547 === (17)))
{var inst_12501 = (state_12546[(10)]);var inst_12510 = cljs.core.first.call(null,inst_12501);var inst_12511 = cljs.core.async.muxch_STAR_.call(null,inst_12510);var inst_12512 = cljs.core.async.close_BANG_.call(null,inst_12511);var inst_12513 = cljs.core.next.call(null,inst_12501);var inst_12487 = inst_12513;var inst_12488 = null;var inst_12489 = (0);var inst_12490 = (0);var state_12546__$1 = (function (){var statearr_12566 = state_12546;(statearr_12566[(12)] = inst_12489);
(statearr_12566[(13)] = inst_12490);
(statearr_12566[(14)] = inst_12488);
(statearr_12566[(15)] = inst_12487);
(statearr_12566[(16)] = inst_12512);
return statearr_12566;
})();var statearr_12567_12610 = state_12546__$1;(statearr_12567_12610[(2)] = null);
(statearr_12567_12610[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12547 === (3)))
{var inst_12544 = (state_12546[(2)]);var state_12546__$1 = state_12546;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12546__$1,inst_12544);
} else
{if((state_val_12547 === (12)))
{var inst_12521 = (state_12546[(2)]);var state_12546__$1 = state_12546;var statearr_12568_12611 = state_12546__$1;(statearr_12568_12611[(2)] = inst_12521);
(statearr_12568_12611[(1)] = (9));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12547 === (2)))
{var state_12546__$1 = state_12546;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12546__$1,(4),ch);
} else
{if((state_val_12547 === (23)))
{var state_12546__$1 = state_12546;var statearr_12569_12612 = state_12546__$1;(statearr_12569_12612[(2)] = null);
(statearr_12569_12612[(1)] = (25));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12547 === (19)))
{var inst_12477 = (state_12546[(8)]);var inst_12527 = (state_12546[(11)]);var inst_12529 = cljs.core.async.muxch_STAR_.call(null,inst_12527);var state_12546__$1 = state_12546;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12546__$1,(22),inst_12529,inst_12477);
} else
{if((state_val_12547 === (11)))
{var inst_12501 = (state_12546[(10)]);var inst_12487 = (state_12546[(15)]);var inst_12501__$1 = cljs.core.seq.call(null,inst_12487);var state_12546__$1 = (function (){var statearr_12570 = state_12546;(statearr_12570[(10)] = inst_12501__$1);
return statearr_12570;
})();if(inst_12501__$1)
{var statearr_12571_12613 = state_12546__$1;(statearr_12571_12613[(1)] = (13));
} else
{var statearr_12572_12614 = state_12546__$1;(statearr_12572_12614[(1)] = (14));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12547 === (9)))
{var inst_12523 = (state_12546[(2)]);var state_12546__$1 = state_12546;var statearr_12573_12615 = state_12546__$1;(statearr_12573_12615[(2)] = inst_12523);
(statearr_12573_12615[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12547 === (5)))
{var inst_12484 = cljs.core.deref.call(null,mults);var inst_12485 = cljs.core.vals.call(null,inst_12484);var inst_12486 = cljs.core.seq.call(null,inst_12485);var inst_12487 = inst_12486;var inst_12488 = null;var inst_12489 = (0);var inst_12490 = (0);var state_12546__$1 = (function (){var statearr_12574 = state_12546;(statearr_12574[(12)] = inst_12489);
(statearr_12574[(13)] = inst_12490);
(statearr_12574[(14)] = inst_12488);
(statearr_12574[(15)] = inst_12487);
return statearr_12574;
})();var statearr_12575_12616 = state_12546__$1;(statearr_12575_12616[(2)] = null);
(statearr_12575_12616[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12547 === (14)))
{var state_12546__$1 = state_12546;var statearr_12579_12617 = state_12546__$1;(statearr_12579_12617[(2)] = null);
(statearr_12579_12617[(1)] = (15));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12547 === (16)))
{var inst_12501 = (state_12546[(10)]);var inst_12505 = cljs.core.chunk_first.call(null,inst_12501);var inst_12506 = cljs.core.chunk_rest.call(null,inst_12501);var inst_12507 = cljs.core.count.call(null,inst_12505);var inst_12487 = inst_12506;var inst_12488 = inst_12505;var inst_12489 = inst_12507;var inst_12490 = (0);var state_12546__$1 = (function (){var statearr_12580 = state_12546;(statearr_12580[(12)] = inst_12489);
(statearr_12580[(13)] = inst_12490);
(statearr_12580[(14)] = inst_12488);
(statearr_12580[(15)] = inst_12487);
return statearr_12580;
})();var statearr_12581_12618 = state_12546__$1;(statearr_12581_12618[(2)] = null);
(statearr_12581_12618[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12547 === (10)))
{var inst_12489 = (state_12546[(12)]);var inst_12490 = (state_12546[(13)]);var inst_12488 = (state_12546[(14)]);var inst_12487 = (state_12546[(15)]);var inst_12495 = cljs.core._nth.call(null,inst_12488,inst_12490);var inst_12496 = cljs.core.async.muxch_STAR_.call(null,inst_12495);var inst_12497 = cljs.core.async.close_BANG_.call(null,inst_12496);var inst_12498 = (inst_12490 + (1));var tmp12576 = inst_12489;var tmp12577 = inst_12488;var tmp12578 = inst_12487;var inst_12487__$1 = tmp12578;var inst_12488__$1 = tmp12577;var inst_12489__$1 = tmp12576;var inst_12490__$1 = inst_12498;var state_12546__$1 = (function (){var statearr_12582 = state_12546;(statearr_12582[(12)] = inst_12489__$1);
(statearr_12582[(13)] = inst_12490__$1);
(statearr_12582[(14)] = inst_12488__$1);
(statearr_12582[(15)] = inst_12487__$1);
(statearr_12582[(17)] = inst_12497);
return statearr_12582;
})();var statearr_12583_12619 = state_12546__$1;(statearr_12583_12619[(2)] = null);
(statearr_12583_12619[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12547 === (18)))
{var inst_12516 = (state_12546[(2)]);var state_12546__$1 = state_12546;var statearr_12584_12620 = state_12546__$1;(statearr_12584_12620[(2)] = inst_12516);
(statearr_12584_12620[(1)] = (15));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12547 === (8)))
{var inst_12489 = (state_12546[(12)]);var inst_12490 = (state_12546[(13)]);var inst_12492 = (inst_12490 < inst_12489);var inst_12493 = inst_12492;var state_12546__$1 = state_12546;if(cljs.core.truth_(inst_12493))
{var statearr_12585_12621 = state_12546__$1;(statearr_12585_12621[(1)] = (10));
} else
{var statearr_12586_12622 = state_12546__$1;(statearr_12586_12622[(1)] = (11));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__5915__auto___12594,mults,ensure_mult,p))
;return ((function (switch__5900__auto__,c__5915__auto___12594,mults,ensure_mult,p){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_12590 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_12590[(0)] = state_machine__5901__auto__);
(statearr_12590[(1)] = (1));
return statearr_12590;
});
var state_machine__5901__auto____1 = (function (state_12546){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_12546);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e12591){if((e12591 instanceof Object))
{var ex__5904__auto__ = e12591;var statearr_12592_12623 = state_12546;(statearr_12592_12623[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12546);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e12591;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__12624 = state_12546;
state_12546 = G__12624;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_12546){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_12546);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto___12594,mults,ensure_mult,p))
})();var state__5917__auto__ = (function (){var statearr_12593 = f__5916__auto__.call(null);(statearr_12593[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto___12594);
return statearr_12593;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto___12594,mults,ensure_mult,p))
);
return p;
});
pub = function(ch,topic_fn,buf_fn){
switch(arguments.length){
case 2:
return pub__2.call(this,ch,topic_fn);
case 3:
return pub__3.call(this,ch,topic_fn,buf_fn);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pub.cljs$core$IFn$_invoke$arity$2 = pub__2;
pub.cljs$core$IFn$_invoke$arity$3 = pub__3;
return pub;
})()
;
/**
* Subscribes a channel to a topic of a pub.
* 
* By default the channel will be closed when the source closes,
* but can be determined by the close? parameter.
*/
cljs.core.async.sub = (function() {
var sub = null;
var sub__3 = (function (p,topic,ch){return sub.call(null,p,topic,ch,true);
});
var sub__4 = (function (p,topic,ch,close_QMARK_){return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});
sub = function(p,topic,ch,close_QMARK_){
switch(arguments.length){
case 3:
return sub__3.call(this,p,topic,ch);
case 4:
return sub__4.call(this,p,topic,ch,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
sub.cljs$core$IFn$_invoke$arity$3 = sub__3;
sub.cljs$core$IFn$_invoke$arity$4 = sub__4;
return sub;
})()
;
/**
* Unsubscribes a channel from a topic of a pub
*/
cljs.core.async.unsub = (function unsub(p,topic,ch){return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
* Unsubscribes all channels from a pub, or a topic of a pub
*/
cljs.core.async.unsub_all = (function() {
var unsub_all = null;
var unsub_all__1 = (function (p){return cljs.core.async.unsub_all_STAR_.call(null,p);
});
var unsub_all__2 = (function (p,topic){return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});
unsub_all = function(p,topic){
switch(arguments.length){
case 1:
return unsub_all__1.call(this,p);
case 2:
return unsub_all__2.call(this,p,topic);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unsub_all.cljs$core$IFn$_invoke$arity$1 = unsub_all__1;
unsub_all.cljs$core$IFn$_invoke$arity$2 = unsub_all__2;
return unsub_all;
})()
;
/**
* Takes a function and a collection of source channels, and returns a
* channel which contains the values produced by applying f to the set
* of first items taken from each source channel, followed by applying
* f to the set of second items from each channel, until any one of the
* channels is closed, at which point the output channel will be
* closed. The returned channel will be unbuffered by default, or a
* buf-or-n can be supplied
*/
cljs.core.async.map = (function() {
var map = null;
var map__2 = (function (f,chs){return map.call(null,f,chs,null);
});
var map__3 = (function (f,chs,buf_or_n){var chs__$1 = cljs.core.vec.call(null,chs);var out = cljs.core.async.chan.call(null,buf_or_n);var cnt = cljs.core.count.call(null,chs__$1);var rets = cljs.core.object_array.call(null,cnt);var dchan = cljs.core.async.chan.call(null,(1));var dctr = cljs.core.atom.call(null,null);var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){(rets[i] = ret);
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0)))
{return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else
{return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));var c__5915__auto___12761 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto___12761,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto___12761,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_12731){var state_val_12732 = (state_12731[(1)]);if((state_val_12732 === (7)))
{var state_12731__$1 = state_12731;var statearr_12733_12762 = state_12731__$1;(statearr_12733_12762[(2)] = null);
(statearr_12733_12762[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12732 === (1)))
{var state_12731__$1 = state_12731;var statearr_12734_12763 = state_12731__$1;(statearr_12734_12763[(2)] = null);
(statearr_12734_12763[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12732 === (4)))
{var inst_12695 = (state_12731[(7)]);var inst_12697 = (inst_12695 < cnt);var state_12731__$1 = state_12731;if(cljs.core.truth_(inst_12697))
{var statearr_12735_12764 = state_12731__$1;(statearr_12735_12764[(1)] = (6));
} else
{var statearr_12736_12765 = state_12731__$1;(statearr_12736_12765[(1)] = (7));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12732 === (15)))
{var inst_12727 = (state_12731[(2)]);var state_12731__$1 = state_12731;var statearr_12737_12766 = state_12731__$1;(statearr_12737_12766[(2)] = inst_12727);
(statearr_12737_12766[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12732 === (13)))
{var inst_12720 = cljs.core.async.close_BANG_.call(null,out);var state_12731__$1 = state_12731;var statearr_12738_12767 = state_12731__$1;(statearr_12738_12767[(2)] = inst_12720);
(statearr_12738_12767[(1)] = (15));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12732 === (6)))
{var state_12731__$1 = state_12731;var statearr_12739_12768 = state_12731__$1;(statearr_12739_12768[(2)] = null);
(statearr_12739_12768[(1)] = (11));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12732 === (3)))
{var inst_12729 = (state_12731[(2)]);var state_12731__$1 = state_12731;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12731__$1,inst_12729);
} else
{if((state_val_12732 === (12)))
{var inst_12717 = (state_12731[(8)]);var inst_12717__$1 = (state_12731[(2)]);var inst_12718 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_12717__$1);var state_12731__$1 = (function (){var statearr_12740 = state_12731;(statearr_12740[(8)] = inst_12717__$1);
return statearr_12740;
})();if(cljs.core.truth_(inst_12718))
{var statearr_12741_12769 = state_12731__$1;(statearr_12741_12769[(1)] = (13));
} else
{var statearr_12742_12770 = state_12731__$1;(statearr_12742_12770[(1)] = (14));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12732 === (2)))
{var inst_12694 = cljs.core.reset_BANG_.call(null,dctr,cnt);var inst_12695 = (0);var state_12731__$1 = (function (){var statearr_12743 = state_12731;(statearr_12743[(7)] = inst_12695);
(statearr_12743[(9)] = inst_12694);
return statearr_12743;
})();var statearr_12744_12771 = state_12731__$1;(statearr_12744_12771[(2)] = null);
(statearr_12744_12771[(1)] = (4));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12732 === (11)))
{var inst_12695 = (state_12731[(7)]);var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_12731,(10),Object,null,(9));var inst_12704 = chs__$1.call(null,inst_12695);var inst_12705 = done.call(null,inst_12695);var inst_12706 = cljs.core.async.take_BANG_.call(null,inst_12704,inst_12705);var state_12731__$1 = state_12731;var statearr_12745_12772 = state_12731__$1;(statearr_12745_12772[(2)] = inst_12706);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12731__$1);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12732 === (9)))
{var inst_12695 = (state_12731[(7)]);var inst_12708 = (state_12731[(2)]);var inst_12709 = (inst_12695 + (1));var inst_12695__$1 = inst_12709;var state_12731__$1 = (function (){var statearr_12746 = state_12731;(statearr_12746[(7)] = inst_12695__$1);
(statearr_12746[(10)] = inst_12708);
return statearr_12746;
})();var statearr_12747_12773 = state_12731__$1;(statearr_12747_12773[(2)] = null);
(statearr_12747_12773[(1)] = (4));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12732 === (5)))
{var inst_12715 = (state_12731[(2)]);var state_12731__$1 = (function (){var statearr_12748 = state_12731;(statearr_12748[(11)] = inst_12715);
return statearr_12748;
})();return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12731__$1,(12),dchan);
} else
{if((state_val_12732 === (14)))
{var inst_12717 = (state_12731[(8)]);var inst_12722 = cljs.core.apply.call(null,f,inst_12717);var state_12731__$1 = state_12731;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12731__$1,(16),out,inst_12722);
} else
{if((state_val_12732 === (16)))
{var inst_12724 = (state_12731[(2)]);var state_12731__$1 = (function (){var statearr_12749 = state_12731;(statearr_12749[(12)] = inst_12724);
return statearr_12749;
})();var statearr_12750_12774 = state_12731__$1;(statearr_12750_12774[(2)] = null);
(statearr_12750_12774[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12732 === (10)))
{var inst_12699 = (state_12731[(2)]);var inst_12700 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);var state_12731__$1 = (function (){var statearr_12751 = state_12731;(statearr_12751[(13)] = inst_12699);
return statearr_12751;
})();var statearr_12752_12775 = state_12731__$1;(statearr_12752_12775[(2)] = inst_12700);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12731__$1);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12732 === (8)))
{var inst_12713 = (state_12731[(2)]);var state_12731__$1 = state_12731;var statearr_12753_12776 = state_12731__$1;(statearr_12753_12776[(2)] = inst_12713);
(statearr_12753_12776[(1)] = (5));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__5915__auto___12761,chs__$1,out,cnt,rets,dchan,dctr,done))
;return ((function (switch__5900__auto__,c__5915__auto___12761,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_12757 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_12757[(0)] = state_machine__5901__auto__);
(statearr_12757[(1)] = (1));
return statearr_12757;
});
var state_machine__5901__auto____1 = (function (state_12731){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_12731);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e12758){if((e12758 instanceof Object))
{var ex__5904__auto__ = e12758;var statearr_12759_12777 = state_12731;(statearr_12759_12777[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12731);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e12758;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__12778 = state_12731;
state_12731 = G__12778;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_12731){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_12731);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto___12761,chs__$1,out,cnt,rets,dchan,dctr,done))
})();var state__5917__auto__ = (function (){var statearr_12760 = f__5916__auto__.call(null);(statearr_12760[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto___12761);
return statearr_12760;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto___12761,chs__$1,out,cnt,rets,dchan,dctr,done))
);
return out;
});
map = function(f,chs,buf_or_n){
switch(arguments.length){
case 2:
return map__2.call(this,f,chs);
case 3:
return map__3.call(this,f,chs,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
map.cljs$core$IFn$_invoke$arity$2 = map__2;
map.cljs$core$IFn$_invoke$arity$3 = map__3;
return map;
})()
;
/**
* Takes a collection of source channels and returns a channel which
* contains all values taken from them. The returned channel will be
* unbuffered by default, or a buf-or-n can be supplied. The channel
* will close after all the source channels have closed.
*/
cljs.core.async.merge = (function() {
var merge = null;
var merge__1 = (function (chs){return merge.call(null,chs,null);
});
var merge__2 = (function (chs,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__5915__auto___12886 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto___12886,out){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto___12886,out){
return (function (state_12862){var state_val_12863 = (state_12862[(1)]);if((state_val_12863 === (7)))
{var inst_12841 = (state_12862[(7)]);var inst_12842 = (state_12862[(8)]);var inst_12841__$1 = (state_12862[(2)]);var inst_12842__$1 = cljs.core.nth.call(null,inst_12841__$1,(0),null);var inst_12843 = cljs.core.nth.call(null,inst_12841__$1,(1),null);var inst_12844 = (inst_12842__$1 == null);var state_12862__$1 = (function (){var statearr_12864 = state_12862;(statearr_12864[(7)] = inst_12841__$1);
(statearr_12864[(9)] = inst_12843);
(statearr_12864[(8)] = inst_12842__$1);
return statearr_12864;
})();if(cljs.core.truth_(inst_12844))
{var statearr_12865_12887 = state_12862__$1;(statearr_12865_12887[(1)] = (8));
} else
{var statearr_12866_12888 = state_12862__$1;(statearr_12866_12888[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12863 === (1)))
{var inst_12833 = cljs.core.vec.call(null,chs);var inst_12834 = inst_12833;var state_12862__$1 = (function (){var statearr_12867 = state_12862;(statearr_12867[(10)] = inst_12834);
return statearr_12867;
})();var statearr_12868_12889 = state_12862__$1;(statearr_12868_12889[(2)] = null);
(statearr_12868_12889[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12863 === (4)))
{var inst_12834 = (state_12862[(10)]);var state_12862__$1 = state_12862;return cljs.core.async.ioc_alts_BANG_.call(null,state_12862__$1,(7),inst_12834);
} else
{if((state_val_12863 === (6)))
{var inst_12858 = (state_12862[(2)]);var state_12862__$1 = state_12862;var statearr_12869_12890 = state_12862__$1;(statearr_12869_12890[(2)] = inst_12858);
(statearr_12869_12890[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12863 === (3)))
{var inst_12860 = (state_12862[(2)]);var state_12862__$1 = state_12862;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12862__$1,inst_12860);
} else
{if((state_val_12863 === (2)))
{var inst_12834 = (state_12862[(10)]);var inst_12836 = cljs.core.count.call(null,inst_12834);var inst_12837 = (inst_12836 > (0));var state_12862__$1 = state_12862;if(cljs.core.truth_(inst_12837))
{var statearr_12871_12891 = state_12862__$1;(statearr_12871_12891[(1)] = (4));
} else
{var statearr_12872_12892 = state_12862__$1;(statearr_12872_12892[(1)] = (5));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12863 === (11)))
{var inst_12834 = (state_12862[(10)]);var inst_12851 = (state_12862[(2)]);var tmp12870 = inst_12834;var inst_12834__$1 = tmp12870;var state_12862__$1 = (function (){var statearr_12873 = state_12862;(statearr_12873[(11)] = inst_12851);
(statearr_12873[(10)] = inst_12834__$1);
return statearr_12873;
})();var statearr_12874_12893 = state_12862__$1;(statearr_12874_12893[(2)] = null);
(statearr_12874_12893[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12863 === (9)))
{var inst_12842 = (state_12862[(8)]);var state_12862__$1 = state_12862;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12862__$1,(11),out,inst_12842);
} else
{if((state_val_12863 === (5)))
{var inst_12856 = cljs.core.async.close_BANG_.call(null,out);var state_12862__$1 = state_12862;var statearr_12875_12894 = state_12862__$1;(statearr_12875_12894[(2)] = inst_12856);
(statearr_12875_12894[(1)] = (6));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12863 === (10)))
{var inst_12854 = (state_12862[(2)]);var state_12862__$1 = state_12862;var statearr_12876_12895 = state_12862__$1;(statearr_12876_12895[(2)] = inst_12854);
(statearr_12876_12895[(1)] = (6));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12863 === (8)))
{var inst_12834 = (state_12862[(10)]);var inst_12841 = (state_12862[(7)]);var inst_12843 = (state_12862[(9)]);var inst_12842 = (state_12862[(8)]);var inst_12846 = (function (){var c = inst_12843;var v = inst_12842;var vec__12839 = inst_12841;var cs = inst_12834;return ((function (c,v,vec__12839,cs,inst_12834,inst_12841,inst_12843,inst_12842,state_val_12863,c__5915__auto___12886,out){
return (function (p1__12779_SHARP_){return cljs.core.not_EQ_.call(null,c,p1__12779_SHARP_);
});
;})(c,v,vec__12839,cs,inst_12834,inst_12841,inst_12843,inst_12842,state_val_12863,c__5915__auto___12886,out))
})();var inst_12847 = cljs.core.filterv.call(null,inst_12846,inst_12834);var inst_12834__$1 = inst_12847;var state_12862__$1 = (function (){var statearr_12877 = state_12862;(statearr_12877[(10)] = inst_12834__$1);
return statearr_12877;
})();var statearr_12878_12896 = state_12862__$1;(statearr_12878_12896[(2)] = null);
(statearr_12878_12896[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__5915__auto___12886,out))
;return ((function (switch__5900__auto__,c__5915__auto___12886,out){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_12882 = [null,null,null,null,null,null,null,null,null,null,null,null];(statearr_12882[(0)] = state_machine__5901__auto__);
(statearr_12882[(1)] = (1));
return statearr_12882;
});
var state_machine__5901__auto____1 = (function (state_12862){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_12862);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e12883){if((e12883 instanceof Object))
{var ex__5904__auto__ = e12883;var statearr_12884_12897 = state_12862;(statearr_12884_12897[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12862);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e12883;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__12898 = state_12862;
state_12862 = G__12898;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_12862){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_12862);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto___12886,out))
})();var state__5917__auto__ = (function (){var statearr_12885 = f__5916__auto__.call(null);(statearr_12885[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto___12886);
return statearr_12885;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto___12886,out))
);
return out;
});
merge = function(chs,buf_or_n){
switch(arguments.length){
case 1:
return merge__1.call(this,chs);
case 2:
return merge__2.call(this,chs,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
merge.cljs$core$IFn$_invoke$arity$1 = merge__1;
merge.cljs$core$IFn$_invoke$arity$2 = merge__2;
return merge;
})()
;
/**
* Returns a channel containing the single (collection) result of the
* items taken from the channel conjoined to the supplied
* collection. ch must close before into produces a result.
*/
cljs.core.async.into = (function into(coll,ch){return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
* Returns a channel that will return, at most, n items from ch. After n items
* have been returned, or ch has been closed, the return chanel will close.
* 
* The output channel is unbuffered by default, unless buf-or-n is given.
*/
cljs.core.async.take = (function() {
var take = null;
var take__2 = (function (n,ch){return take.call(null,n,ch,null);
});
var take__3 = (function (n,ch,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__5915__auto___12991 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto___12991,out){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto___12991,out){
return (function (state_12968){var state_val_12969 = (state_12968[(1)]);if((state_val_12969 === (7)))
{var inst_12950 = (state_12968[(7)]);var inst_12950__$1 = (state_12968[(2)]);var inst_12951 = (inst_12950__$1 == null);var inst_12952 = cljs.core.not.call(null,inst_12951);var state_12968__$1 = (function (){var statearr_12970 = state_12968;(statearr_12970[(7)] = inst_12950__$1);
return statearr_12970;
})();if(inst_12952)
{var statearr_12971_12992 = state_12968__$1;(statearr_12971_12992[(1)] = (8));
} else
{var statearr_12972_12993 = state_12968__$1;(statearr_12972_12993[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12969 === (1)))
{var inst_12945 = (0);var state_12968__$1 = (function (){var statearr_12973 = state_12968;(statearr_12973[(8)] = inst_12945);
return statearr_12973;
})();var statearr_12974_12994 = state_12968__$1;(statearr_12974_12994[(2)] = null);
(statearr_12974_12994[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12969 === (4)))
{var state_12968__$1 = state_12968;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12968__$1,(7),ch);
} else
{if((state_val_12969 === (6)))
{var inst_12963 = (state_12968[(2)]);var state_12968__$1 = state_12968;var statearr_12975_12995 = state_12968__$1;(statearr_12975_12995[(2)] = inst_12963);
(statearr_12975_12995[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12969 === (3)))
{var inst_12965 = (state_12968[(2)]);var inst_12966 = cljs.core.async.close_BANG_.call(null,out);var state_12968__$1 = (function (){var statearr_12976 = state_12968;(statearr_12976[(9)] = inst_12965);
return statearr_12976;
})();return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12968__$1,inst_12966);
} else
{if((state_val_12969 === (2)))
{var inst_12945 = (state_12968[(8)]);var inst_12947 = (inst_12945 < n);var state_12968__$1 = state_12968;if(cljs.core.truth_(inst_12947))
{var statearr_12977_12996 = state_12968__$1;(statearr_12977_12996[(1)] = (4));
} else
{var statearr_12978_12997 = state_12968__$1;(statearr_12978_12997[(1)] = (5));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12969 === (11)))
{var inst_12945 = (state_12968[(8)]);var inst_12955 = (state_12968[(2)]);var inst_12956 = (inst_12945 + (1));var inst_12945__$1 = inst_12956;var state_12968__$1 = (function (){var statearr_12979 = state_12968;(statearr_12979[(8)] = inst_12945__$1);
(statearr_12979[(10)] = inst_12955);
return statearr_12979;
})();var statearr_12980_12998 = state_12968__$1;(statearr_12980_12998[(2)] = null);
(statearr_12980_12998[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12969 === (9)))
{var state_12968__$1 = state_12968;var statearr_12981_12999 = state_12968__$1;(statearr_12981_12999[(2)] = null);
(statearr_12981_12999[(1)] = (10));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12969 === (5)))
{var state_12968__$1 = state_12968;var statearr_12982_13000 = state_12968__$1;(statearr_12982_13000[(2)] = null);
(statearr_12982_13000[(1)] = (6));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12969 === (10)))
{var inst_12960 = (state_12968[(2)]);var state_12968__$1 = state_12968;var statearr_12983_13001 = state_12968__$1;(statearr_12983_13001[(2)] = inst_12960);
(statearr_12983_13001[(1)] = (6));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_12969 === (8)))
{var inst_12950 = (state_12968[(7)]);var state_12968__$1 = state_12968;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12968__$1,(11),out,inst_12950);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__5915__auto___12991,out))
;return ((function (switch__5900__auto__,c__5915__auto___12991,out){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_12987 = [null,null,null,null,null,null,null,null,null,null,null];(statearr_12987[(0)] = state_machine__5901__auto__);
(statearr_12987[(1)] = (1));
return statearr_12987;
});
var state_machine__5901__auto____1 = (function (state_12968){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_12968);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e12988){if((e12988 instanceof Object))
{var ex__5904__auto__ = e12988;var statearr_12989_13002 = state_12968;(statearr_12989_13002[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12968);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e12988;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__13003 = state_12968;
state_12968 = G__13003;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_12968){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_12968);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto___12991,out))
})();var state__5917__auto__ = (function (){var statearr_12990 = f__5916__auto__.call(null);(statearr_12990[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto___12991);
return statearr_12990;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto___12991,out))
);
return out;
});
take = function(n,ch,buf_or_n){
switch(arguments.length){
case 2:
return take__2.call(this,n,ch);
case 3:
return take__3.call(this,n,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
take.cljs$core$IFn$_invoke$arity$2 = take__2;
take.cljs$core$IFn$_invoke$arity$3 = take__3;
return take;
})()
;
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.map_LT_ = (function map_LT_(f,ch){if(typeof cljs.core.async.t13011 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t13011 = (function (ch,f,map_LT_,meta13012){
this.ch = ch;
this.f = f;
this.map_LT_ = map_LT_;
this.meta13012 = meta13012;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t13011.cljs$lang$type = true;
cljs.core.async.t13011.cljs$lang$ctorStr = "cljs.core.async/t13011";
cljs.core.async.t13011.cljs$lang$ctorPrWriter = (function (this__4225__auto__,writer__4226__auto__,opt__4227__auto__){return cljs.core._write.call(null,writer__4226__auto__,"cljs.core.async/t13011");
});
cljs.core.async.t13011.prototype.cljs$core$async$impl$protocols$WritePort$ = true;
cljs.core.async.t13011.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});
cljs.core.async.t13011.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;
cljs.core.async.t13011.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){var self__ = this;
var ___$1 = this;var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){if(typeof cljs.core.async.t13014 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t13014 = (function (fn1,_,meta13012,ch,f,map_LT_,meta13015){
this.fn1 = fn1;
this._ = _;
this.meta13012 = meta13012;
this.ch = ch;
this.f = f;
this.map_LT_ = map_LT_;
this.meta13015 = meta13015;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t13014.cljs$lang$type = true;
cljs.core.async.t13014.cljs$lang$ctorStr = "cljs.core.async/t13014";
cljs.core.async.t13014.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__4225__auto__,writer__4226__auto__,opt__4227__auto__){return cljs.core._write.call(null,writer__4226__auto__,"cljs.core.async/t13014");
});})(___$1))
;
cljs.core.async.t13014.prototype.cljs$core$async$impl$protocols$Handler$ = true;
cljs.core.async.t13014.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$3){var self__ = this;
var ___$4 = this;return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;
cljs.core.async.t13014.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$3){var self__ = this;
var ___$4 = this;var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);return ((function (f1,___$4,___$1){
return (function (p1__13004_SHARP_){return f1.call(null,(((p1__13004_SHARP_ == null))?null:self__.f.call(null,p1__13004_SHARP_)));
});
;})(f1,___$4,___$1))
});})(___$1))
;
cljs.core.async.t13014.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_13016){var self__ = this;
var _13016__$1 = this;return self__.meta13015;
});})(___$1))
;
cljs.core.async.t13014.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_13016,meta13015__$1){var self__ = this;
var _13016__$1 = this;return (new cljs.core.async.t13014(self__.fn1,self__._,self__.meta13012,self__.ch,self__.f,self__.map_LT_,meta13015__$1));
});})(___$1))
;
cljs.core.async.__GT_t13014 = ((function (___$1){
return (function __GT_t13014(fn1__$1,___$2,meta13012__$1,ch__$2,f__$2,map_LT___$2,meta13015){return (new cljs.core.async.t13014(fn1__$1,___$2,meta13012__$1,ch__$2,f__$2,map_LT___$2,meta13015));
});})(___$1))
;
}
return (new cljs.core.async.t13014(fn1,___$1,self__.meta13012,self__.ch,self__.f,self__.map_LT_,null));
})());if(cljs.core.truth_((function (){var and__3636__auto__ = ret;if(cljs.core.truth_(and__3636__auto__))
{return !((cljs.core.deref.call(null,ret) == null));
} else
{return and__3636__auto__;
}
})()))
{return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else
{return ret;
}
});
cljs.core.async.t13011.prototype.cljs$core$async$impl$protocols$Channel$ = true;
cljs.core.async.t13011.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});
cljs.core.async.t13011.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});
cljs.core.async.t13011.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13013){var self__ = this;
var _13013__$1 = this;return self__.meta13012;
});
cljs.core.async.t13011.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13013,meta13012__$1){var self__ = this;
var _13013__$1 = this;return (new cljs.core.async.t13011(self__.ch,self__.f,self__.map_LT_,meta13012__$1));
});
cljs.core.async.__GT_t13011 = (function __GT_t13011(ch__$1,f__$1,map_LT___$1,meta13012){return (new cljs.core.async.t13011(ch__$1,f__$1,map_LT___$1,meta13012));
});
}
return (new cljs.core.async.t13011(ch,f,map_LT_,null));
});
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.map_GT_ = (function map_GT_(f,ch){if(typeof cljs.core.async.t13020 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t13020 = (function (ch,f,map_GT_,meta13021){
this.ch = ch;
this.f = f;
this.map_GT_ = map_GT_;
this.meta13021 = meta13021;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t13020.cljs$lang$type = true;
cljs.core.async.t13020.cljs$lang$ctorStr = "cljs.core.async/t13020";
cljs.core.async.t13020.cljs$lang$ctorPrWriter = (function (this__4225__auto__,writer__4226__auto__,opt__4227__auto__){return cljs.core._write.call(null,writer__4226__auto__,"cljs.core.async/t13020");
});
cljs.core.async.t13020.prototype.cljs$core$async$impl$protocols$WritePort$ = true;
cljs.core.async.t13020.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});
cljs.core.async.t13020.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;
cljs.core.async.t13020.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});
cljs.core.async.t13020.prototype.cljs$core$async$impl$protocols$Channel$ = true;
cljs.core.async.t13020.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});
cljs.core.async.t13020.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13022){var self__ = this;
var _13022__$1 = this;return self__.meta13021;
});
cljs.core.async.t13020.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13022,meta13021__$1){var self__ = this;
var _13022__$1 = this;return (new cljs.core.async.t13020(self__.ch,self__.f,self__.map_GT_,meta13021__$1));
});
cljs.core.async.__GT_t13020 = (function __GT_t13020(ch__$1,f__$1,map_GT___$1,meta13021){return (new cljs.core.async.t13020(ch__$1,f__$1,map_GT___$1,meta13021));
});
}
return (new cljs.core.async.t13020(ch,f,map_GT_,null));
});
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.filter_GT_ = (function filter_GT_(p,ch){if(typeof cljs.core.async.t13026 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t13026 = (function (ch,p,filter_GT_,meta13027){
this.ch = ch;
this.p = p;
this.filter_GT_ = filter_GT_;
this.meta13027 = meta13027;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t13026.cljs$lang$type = true;
cljs.core.async.t13026.cljs$lang$ctorStr = "cljs.core.async/t13026";
cljs.core.async.t13026.cljs$lang$ctorPrWriter = (function (this__4225__auto__,writer__4226__auto__,opt__4227__auto__){return cljs.core._write.call(null,writer__4226__auto__,"cljs.core.async/t13026");
});
cljs.core.async.t13026.prototype.cljs$core$async$impl$protocols$WritePort$ = true;
cljs.core.async.t13026.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){var self__ = this;
var ___$1 = this;if(cljs.core.truth_(self__.p.call(null,val)))
{return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else
{return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});
cljs.core.async.t13026.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;
cljs.core.async.t13026.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});
cljs.core.async.t13026.prototype.cljs$core$async$impl$protocols$Channel$ = true;
cljs.core.async.t13026.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});
cljs.core.async.t13026.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});
cljs.core.async.t13026.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13028){var self__ = this;
var _13028__$1 = this;return self__.meta13027;
});
cljs.core.async.t13026.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13028,meta13027__$1){var self__ = this;
var _13028__$1 = this;return (new cljs.core.async.t13026(self__.ch,self__.p,self__.filter_GT_,meta13027__$1));
});
cljs.core.async.__GT_t13026 = (function __GT_t13026(ch__$1,p__$1,filter_GT___$1,meta13027){return (new cljs.core.async.t13026(ch__$1,p__$1,filter_GT___$1,meta13027));
});
}
return (new cljs.core.async.t13026(ch,p,filter_GT_,null));
});
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.remove_GT_ = (function remove_GT_(p,ch){return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.filter_LT_ = (function() {
var filter_LT_ = null;
var filter_LT___2 = (function (p,ch){return filter_LT_.call(null,p,ch,null);
});
var filter_LT___3 = (function (p,ch,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__5915__auto___13111 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto___13111,out){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto___13111,out){
return (function (state_13090){var state_val_13091 = (state_13090[(1)]);if((state_val_13091 === (7)))
{var inst_13086 = (state_13090[(2)]);var state_13090__$1 = state_13090;var statearr_13092_13112 = state_13090__$1;(statearr_13092_13112[(2)] = inst_13086);
(statearr_13092_13112[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13091 === (1)))
{var state_13090__$1 = state_13090;var statearr_13093_13113 = state_13090__$1;(statearr_13093_13113[(2)] = null);
(statearr_13093_13113[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13091 === (4)))
{var inst_13072 = (state_13090[(7)]);var inst_13072__$1 = (state_13090[(2)]);var inst_13073 = (inst_13072__$1 == null);var state_13090__$1 = (function (){var statearr_13094 = state_13090;(statearr_13094[(7)] = inst_13072__$1);
return statearr_13094;
})();if(cljs.core.truth_(inst_13073))
{var statearr_13095_13114 = state_13090__$1;(statearr_13095_13114[(1)] = (5));
} else
{var statearr_13096_13115 = state_13090__$1;(statearr_13096_13115[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13091 === (6)))
{var inst_13072 = (state_13090[(7)]);var inst_13077 = p.call(null,inst_13072);var state_13090__$1 = state_13090;if(cljs.core.truth_(inst_13077))
{var statearr_13097_13116 = state_13090__$1;(statearr_13097_13116[(1)] = (8));
} else
{var statearr_13098_13117 = state_13090__$1;(statearr_13098_13117[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13091 === (3)))
{var inst_13088 = (state_13090[(2)]);var state_13090__$1 = state_13090;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13090__$1,inst_13088);
} else
{if((state_val_13091 === (2)))
{var state_13090__$1 = state_13090;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13090__$1,(4),ch);
} else
{if((state_val_13091 === (11)))
{var inst_13080 = (state_13090[(2)]);var state_13090__$1 = state_13090;var statearr_13099_13118 = state_13090__$1;(statearr_13099_13118[(2)] = inst_13080);
(statearr_13099_13118[(1)] = (10));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13091 === (9)))
{var state_13090__$1 = state_13090;var statearr_13100_13119 = state_13090__$1;(statearr_13100_13119[(2)] = null);
(statearr_13100_13119[(1)] = (10));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13091 === (5)))
{var inst_13075 = cljs.core.async.close_BANG_.call(null,out);var state_13090__$1 = state_13090;var statearr_13101_13120 = state_13090__$1;(statearr_13101_13120[(2)] = inst_13075);
(statearr_13101_13120[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13091 === (10)))
{var inst_13083 = (state_13090[(2)]);var state_13090__$1 = (function (){var statearr_13102 = state_13090;(statearr_13102[(8)] = inst_13083);
return statearr_13102;
})();var statearr_13103_13121 = state_13090__$1;(statearr_13103_13121[(2)] = null);
(statearr_13103_13121[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13091 === (8)))
{var inst_13072 = (state_13090[(7)]);var state_13090__$1 = state_13090;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13090__$1,(11),out,inst_13072);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__5915__auto___13111,out))
;return ((function (switch__5900__auto__,c__5915__auto___13111,out){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_13107 = [null,null,null,null,null,null,null,null,null];(statearr_13107[(0)] = state_machine__5901__auto__);
(statearr_13107[(1)] = (1));
return statearr_13107;
});
var state_machine__5901__auto____1 = (function (state_13090){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_13090);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e13108){if((e13108 instanceof Object))
{var ex__5904__auto__ = e13108;var statearr_13109_13122 = state_13090;(statearr_13109_13122[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13090);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e13108;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__13123 = state_13090;
state_13090 = G__13123;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_13090){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_13090);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto___13111,out))
})();var state__5917__auto__ = (function (){var statearr_13110 = f__5916__auto__.call(null);(statearr_13110[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto___13111);
return statearr_13110;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto___13111,out))
);
return out;
});
filter_LT_ = function(p,ch,buf_or_n){
switch(arguments.length){
case 2:
return filter_LT___2.call(this,p,ch);
case 3:
return filter_LT___3.call(this,p,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
filter_LT_.cljs$core$IFn$_invoke$arity$2 = filter_LT___2;
filter_LT_.cljs$core$IFn$_invoke$arity$3 = filter_LT___3;
return filter_LT_;
})()
;
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.remove_LT_ = (function() {
var remove_LT_ = null;
var remove_LT___2 = (function (p,ch){return remove_LT_.call(null,p,ch,null);
});
var remove_LT___3 = (function (p,ch,buf_or_n){return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});
remove_LT_ = function(p,ch,buf_or_n){
switch(arguments.length){
case 2:
return remove_LT___2.call(this,p,ch);
case 3:
return remove_LT___3.call(this,p,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
remove_LT_.cljs$core$IFn$_invoke$arity$2 = remove_LT___2;
remove_LT_.cljs$core$IFn$_invoke$arity$3 = remove_LT___3;
return remove_LT_;
})()
;
cljs.core.async.mapcat_STAR_ = (function mapcat_STAR_(f,in$,out){var c__5915__auto__ = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto__){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto__){
return (function (state_13289){var state_val_13290 = (state_13289[(1)]);if((state_val_13290 === (7)))
{var inst_13285 = (state_13289[(2)]);var state_13289__$1 = state_13289;var statearr_13291_13332 = state_13289__$1;(statearr_13291_13332[(2)] = inst_13285);
(statearr_13291_13332[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13290 === (20)))
{var inst_13255 = (state_13289[(7)]);var inst_13266 = (state_13289[(2)]);var inst_13267 = cljs.core.next.call(null,inst_13255);var inst_13241 = inst_13267;var inst_13242 = null;var inst_13243 = (0);var inst_13244 = (0);var state_13289__$1 = (function (){var statearr_13292 = state_13289;(statearr_13292[(8)] = inst_13241);
(statearr_13292[(9)] = inst_13244);
(statearr_13292[(10)] = inst_13266);
(statearr_13292[(11)] = inst_13242);
(statearr_13292[(12)] = inst_13243);
return statearr_13292;
})();var statearr_13293_13333 = state_13289__$1;(statearr_13293_13333[(2)] = null);
(statearr_13293_13333[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13290 === (1)))
{var state_13289__$1 = state_13289;var statearr_13294_13334 = state_13289__$1;(statearr_13294_13334[(2)] = null);
(statearr_13294_13334[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13290 === (4)))
{var inst_13230 = (state_13289[(13)]);var inst_13230__$1 = (state_13289[(2)]);var inst_13231 = (inst_13230__$1 == null);var state_13289__$1 = (function (){var statearr_13295 = state_13289;(statearr_13295[(13)] = inst_13230__$1);
return statearr_13295;
})();if(cljs.core.truth_(inst_13231))
{var statearr_13296_13335 = state_13289__$1;(statearr_13296_13335[(1)] = (5));
} else
{var statearr_13297_13336 = state_13289__$1;(statearr_13297_13336[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13290 === (15)))
{var state_13289__$1 = state_13289;var statearr_13301_13337 = state_13289__$1;(statearr_13301_13337[(2)] = null);
(statearr_13301_13337[(1)] = (16));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13290 === (21)))
{var state_13289__$1 = state_13289;var statearr_13302_13338 = state_13289__$1;(statearr_13302_13338[(2)] = null);
(statearr_13302_13338[(1)] = (23));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13290 === (13)))
{var inst_13241 = (state_13289[(8)]);var inst_13244 = (state_13289[(9)]);var inst_13242 = (state_13289[(11)]);var inst_13243 = (state_13289[(12)]);var inst_13251 = (state_13289[(2)]);var inst_13252 = (inst_13244 + (1));var tmp13298 = inst_13241;var tmp13299 = inst_13242;var tmp13300 = inst_13243;var inst_13241__$1 = tmp13298;var inst_13242__$1 = tmp13299;var inst_13243__$1 = tmp13300;var inst_13244__$1 = inst_13252;var state_13289__$1 = (function (){var statearr_13303 = state_13289;(statearr_13303[(8)] = inst_13241__$1);
(statearr_13303[(14)] = inst_13251);
(statearr_13303[(9)] = inst_13244__$1);
(statearr_13303[(11)] = inst_13242__$1);
(statearr_13303[(12)] = inst_13243__$1);
return statearr_13303;
})();var statearr_13304_13339 = state_13289__$1;(statearr_13304_13339[(2)] = null);
(statearr_13304_13339[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13290 === (22)))
{var state_13289__$1 = state_13289;var statearr_13305_13340 = state_13289__$1;(statearr_13305_13340[(2)] = null);
(statearr_13305_13340[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13290 === (6)))
{var inst_13230 = (state_13289[(13)]);var inst_13239 = f.call(null,inst_13230);var inst_13240 = cljs.core.seq.call(null,inst_13239);var inst_13241 = inst_13240;var inst_13242 = null;var inst_13243 = (0);var inst_13244 = (0);var state_13289__$1 = (function (){var statearr_13306 = state_13289;(statearr_13306[(8)] = inst_13241);
(statearr_13306[(9)] = inst_13244);
(statearr_13306[(11)] = inst_13242);
(statearr_13306[(12)] = inst_13243);
return statearr_13306;
})();var statearr_13307_13341 = state_13289__$1;(statearr_13307_13341[(2)] = null);
(statearr_13307_13341[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13290 === (17)))
{var inst_13255 = (state_13289[(7)]);var inst_13259 = cljs.core.chunk_first.call(null,inst_13255);var inst_13260 = cljs.core.chunk_rest.call(null,inst_13255);var inst_13261 = cljs.core.count.call(null,inst_13259);var inst_13241 = inst_13260;var inst_13242 = inst_13259;var inst_13243 = inst_13261;var inst_13244 = (0);var state_13289__$1 = (function (){var statearr_13308 = state_13289;(statearr_13308[(8)] = inst_13241);
(statearr_13308[(9)] = inst_13244);
(statearr_13308[(11)] = inst_13242);
(statearr_13308[(12)] = inst_13243);
return statearr_13308;
})();var statearr_13309_13342 = state_13289__$1;(statearr_13309_13342[(2)] = null);
(statearr_13309_13342[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13290 === (3)))
{var inst_13287 = (state_13289[(2)]);var state_13289__$1 = state_13289;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13289__$1,inst_13287);
} else
{if((state_val_13290 === (12)))
{var inst_13275 = (state_13289[(2)]);var state_13289__$1 = state_13289;var statearr_13310_13343 = state_13289__$1;(statearr_13310_13343[(2)] = inst_13275);
(statearr_13310_13343[(1)] = (9));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13290 === (2)))
{var state_13289__$1 = state_13289;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13289__$1,(4),in$);
} else
{if((state_val_13290 === (23)))
{var inst_13283 = (state_13289[(2)]);var state_13289__$1 = state_13289;var statearr_13311_13344 = state_13289__$1;(statearr_13311_13344[(2)] = inst_13283);
(statearr_13311_13344[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13290 === (19)))
{var inst_13270 = (state_13289[(2)]);var state_13289__$1 = state_13289;var statearr_13312_13345 = state_13289__$1;(statearr_13312_13345[(2)] = inst_13270);
(statearr_13312_13345[(1)] = (16));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13290 === (11)))
{var inst_13241 = (state_13289[(8)]);var inst_13255 = (state_13289[(7)]);var inst_13255__$1 = cljs.core.seq.call(null,inst_13241);var state_13289__$1 = (function (){var statearr_13313 = state_13289;(statearr_13313[(7)] = inst_13255__$1);
return statearr_13313;
})();if(inst_13255__$1)
{var statearr_13314_13346 = state_13289__$1;(statearr_13314_13346[(1)] = (14));
} else
{var statearr_13315_13347 = state_13289__$1;(statearr_13315_13347[(1)] = (15));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13290 === (9)))
{var inst_13277 = (state_13289[(2)]);var inst_13278 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);var state_13289__$1 = (function (){var statearr_13316 = state_13289;(statearr_13316[(15)] = inst_13277);
return statearr_13316;
})();if(cljs.core.truth_(inst_13278))
{var statearr_13317_13348 = state_13289__$1;(statearr_13317_13348[(1)] = (21));
} else
{var statearr_13318_13349 = state_13289__$1;(statearr_13318_13349[(1)] = (22));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13290 === (5)))
{var inst_13233 = cljs.core.async.close_BANG_.call(null,out);var state_13289__$1 = state_13289;var statearr_13319_13350 = state_13289__$1;(statearr_13319_13350[(2)] = inst_13233);
(statearr_13319_13350[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13290 === (14)))
{var inst_13255 = (state_13289[(7)]);var inst_13257 = cljs.core.chunked_seq_QMARK_.call(null,inst_13255);var state_13289__$1 = state_13289;if(inst_13257)
{var statearr_13320_13351 = state_13289__$1;(statearr_13320_13351[(1)] = (17));
} else
{var statearr_13321_13352 = state_13289__$1;(statearr_13321_13352[(1)] = (18));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13290 === (16)))
{var inst_13273 = (state_13289[(2)]);var state_13289__$1 = state_13289;var statearr_13322_13353 = state_13289__$1;(statearr_13322_13353[(2)] = inst_13273);
(statearr_13322_13353[(1)] = (12));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13290 === (10)))
{var inst_13244 = (state_13289[(9)]);var inst_13242 = (state_13289[(11)]);var inst_13249 = cljs.core._nth.call(null,inst_13242,inst_13244);var state_13289__$1 = state_13289;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13289__$1,(13),out,inst_13249);
} else
{if((state_val_13290 === (18)))
{var inst_13255 = (state_13289[(7)]);var inst_13264 = cljs.core.first.call(null,inst_13255);var state_13289__$1 = state_13289;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13289__$1,(20),out,inst_13264);
} else
{if((state_val_13290 === (8)))
{var inst_13244 = (state_13289[(9)]);var inst_13243 = (state_13289[(12)]);var inst_13246 = (inst_13244 < inst_13243);var inst_13247 = inst_13246;var state_13289__$1 = state_13289;if(cljs.core.truth_(inst_13247))
{var statearr_13323_13354 = state_13289__$1;(statearr_13323_13354[(1)] = (10));
} else
{var statearr_13324_13355 = state_13289__$1;(statearr_13324_13355[(1)] = (11));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__5915__auto__))
;return ((function (switch__5900__auto__,c__5915__auto__){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_13328 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_13328[(0)] = state_machine__5901__auto__);
(statearr_13328[(1)] = (1));
return statearr_13328;
});
var state_machine__5901__auto____1 = (function (state_13289){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_13289);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e13329){if((e13329 instanceof Object))
{var ex__5904__auto__ = e13329;var statearr_13330_13356 = state_13289;(statearr_13330_13356[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13289);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e13329;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__13357 = state_13289;
state_13289 = G__13357;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_13289){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_13289);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto__))
})();var state__5917__auto__ = (function (){var statearr_13331 = f__5916__auto__.call(null);(statearr_13331[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto__);
return statearr_13331;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto__))
);
return c__5915__auto__;
});
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.mapcat_LT_ = (function() {
var mapcat_LT_ = null;
var mapcat_LT___2 = (function (f,in$){return mapcat_LT_.call(null,f,in$,null);
});
var mapcat_LT___3 = (function (f,in$,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);cljs.core.async.mapcat_STAR_.call(null,f,in$,out);
return out;
});
mapcat_LT_ = function(f,in$,buf_or_n){
switch(arguments.length){
case 2:
return mapcat_LT___2.call(this,f,in$);
case 3:
return mapcat_LT___3.call(this,f,in$,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = mapcat_LT___2;
mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = mapcat_LT___3;
return mapcat_LT_;
})()
;
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.mapcat_GT_ = (function() {
var mapcat_GT_ = null;
var mapcat_GT___2 = (function (f,out){return mapcat_GT_.call(null,f,out,null);
});
var mapcat_GT___3 = (function (f,out,buf_or_n){var in$ = cljs.core.async.chan.call(null,buf_or_n);cljs.core.async.mapcat_STAR_.call(null,f,in$,out);
return in$;
});
mapcat_GT_ = function(f,out,buf_or_n){
switch(arguments.length){
case 2:
return mapcat_GT___2.call(this,f,out);
case 3:
return mapcat_GT___3.call(this,f,out,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = mapcat_GT___2;
mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = mapcat_GT___3;
return mapcat_GT_;
})()
;
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.unique = (function() {
var unique = null;
var unique__1 = (function (ch){return unique.call(null,ch,null);
});
var unique__2 = (function (ch,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__5915__auto___13454 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto___13454,out){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto___13454,out){
return (function (state_13429){var state_val_13430 = (state_13429[(1)]);if((state_val_13430 === (7)))
{var inst_13424 = (state_13429[(2)]);var state_13429__$1 = state_13429;var statearr_13431_13455 = state_13429__$1;(statearr_13431_13455[(2)] = inst_13424);
(statearr_13431_13455[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13430 === (1)))
{var inst_13406 = null;var state_13429__$1 = (function (){var statearr_13432 = state_13429;(statearr_13432[(7)] = inst_13406);
return statearr_13432;
})();var statearr_13433_13456 = state_13429__$1;(statearr_13433_13456[(2)] = null);
(statearr_13433_13456[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13430 === (4)))
{var inst_13409 = (state_13429[(8)]);var inst_13409__$1 = (state_13429[(2)]);var inst_13410 = (inst_13409__$1 == null);var inst_13411 = cljs.core.not.call(null,inst_13410);var state_13429__$1 = (function (){var statearr_13434 = state_13429;(statearr_13434[(8)] = inst_13409__$1);
return statearr_13434;
})();if(inst_13411)
{var statearr_13435_13457 = state_13429__$1;(statearr_13435_13457[(1)] = (5));
} else
{var statearr_13436_13458 = state_13429__$1;(statearr_13436_13458[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13430 === (6)))
{var state_13429__$1 = state_13429;var statearr_13437_13459 = state_13429__$1;(statearr_13437_13459[(2)] = null);
(statearr_13437_13459[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13430 === (3)))
{var inst_13426 = (state_13429[(2)]);var inst_13427 = cljs.core.async.close_BANG_.call(null,out);var state_13429__$1 = (function (){var statearr_13438 = state_13429;(statearr_13438[(9)] = inst_13426);
return statearr_13438;
})();return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13429__$1,inst_13427);
} else
{if((state_val_13430 === (2)))
{var state_13429__$1 = state_13429;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13429__$1,(4),ch);
} else
{if((state_val_13430 === (11)))
{var inst_13409 = (state_13429[(8)]);var inst_13418 = (state_13429[(2)]);var inst_13406 = inst_13409;var state_13429__$1 = (function (){var statearr_13439 = state_13429;(statearr_13439[(10)] = inst_13418);
(statearr_13439[(7)] = inst_13406);
return statearr_13439;
})();var statearr_13440_13460 = state_13429__$1;(statearr_13440_13460[(2)] = null);
(statearr_13440_13460[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13430 === (9)))
{var inst_13409 = (state_13429[(8)]);var state_13429__$1 = state_13429;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13429__$1,(11),out,inst_13409);
} else
{if((state_val_13430 === (5)))
{var inst_13409 = (state_13429[(8)]);var inst_13406 = (state_13429[(7)]);var inst_13413 = cljs.core._EQ_.call(null,inst_13409,inst_13406);var state_13429__$1 = state_13429;if(inst_13413)
{var statearr_13442_13461 = state_13429__$1;(statearr_13442_13461[(1)] = (8));
} else
{var statearr_13443_13462 = state_13429__$1;(statearr_13443_13462[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13430 === (10)))
{var inst_13421 = (state_13429[(2)]);var state_13429__$1 = state_13429;var statearr_13444_13463 = state_13429__$1;(statearr_13444_13463[(2)] = inst_13421);
(statearr_13444_13463[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13430 === (8)))
{var inst_13406 = (state_13429[(7)]);var tmp13441 = inst_13406;var inst_13406__$1 = tmp13441;var state_13429__$1 = (function (){var statearr_13445 = state_13429;(statearr_13445[(7)] = inst_13406__$1);
return statearr_13445;
})();var statearr_13446_13464 = state_13429__$1;(statearr_13446_13464[(2)] = null);
(statearr_13446_13464[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__5915__auto___13454,out))
;return ((function (switch__5900__auto__,c__5915__auto___13454,out){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_13450 = [null,null,null,null,null,null,null,null,null,null,null];(statearr_13450[(0)] = state_machine__5901__auto__);
(statearr_13450[(1)] = (1));
return statearr_13450;
});
var state_machine__5901__auto____1 = (function (state_13429){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_13429);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e13451){if((e13451 instanceof Object))
{var ex__5904__auto__ = e13451;var statearr_13452_13465 = state_13429;(statearr_13452_13465[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13429);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e13451;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__13466 = state_13429;
state_13429 = G__13466;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_13429){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_13429);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto___13454,out))
})();var state__5917__auto__ = (function (){var statearr_13453 = f__5916__auto__.call(null);(statearr_13453[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto___13454);
return statearr_13453;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto___13454,out))
);
return out;
});
unique = function(ch,buf_or_n){
switch(arguments.length){
case 1:
return unique__1.call(this,ch);
case 2:
return unique__2.call(this,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unique.cljs$core$IFn$_invoke$arity$1 = unique__1;
unique.cljs$core$IFn$_invoke$arity$2 = unique__2;
return unique;
})()
;
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.partition = (function() {
var partition = null;
var partition__2 = (function (n,ch){return partition.call(null,n,ch,null);
});
var partition__3 = (function (n,ch,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__5915__auto___13601 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto___13601,out){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto___13601,out){
return (function (state_13571){var state_val_13572 = (state_13571[(1)]);if((state_val_13572 === (7)))
{var inst_13567 = (state_13571[(2)]);var state_13571__$1 = state_13571;var statearr_13573_13602 = state_13571__$1;(statearr_13573_13602[(2)] = inst_13567);
(statearr_13573_13602[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13572 === (1)))
{var inst_13534 = (new Array(n));var inst_13535 = inst_13534;var inst_13536 = (0);var state_13571__$1 = (function (){var statearr_13574 = state_13571;(statearr_13574[(7)] = inst_13535);
(statearr_13574[(8)] = inst_13536);
return statearr_13574;
})();var statearr_13575_13603 = state_13571__$1;(statearr_13575_13603[(2)] = null);
(statearr_13575_13603[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13572 === (4)))
{var inst_13539 = (state_13571[(9)]);var inst_13539__$1 = (state_13571[(2)]);var inst_13540 = (inst_13539__$1 == null);var inst_13541 = cljs.core.not.call(null,inst_13540);var state_13571__$1 = (function (){var statearr_13576 = state_13571;(statearr_13576[(9)] = inst_13539__$1);
return statearr_13576;
})();if(inst_13541)
{var statearr_13577_13604 = state_13571__$1;(statearr_13577_13604[(1)] = (5));
} else
{var statearr_13578_13605 = state_13571__$1;(statearr_13578_13605[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13572 === (15)))
{var inst_13561 = (state_13571[(2)]);var state_13571__$1 = state_13571;var statearr_13579_13606 = state_13571__$1;(statearr_13579_13606[(2)] = inst_13561);
(statearr_13579_13606[(1)] = (14));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13572 === (13)))
{var state_13571__$1 = state_13571;var statearr_13580_13607 = state_13571__$1;(statearr_13580_13607[(2)] = null);
(statearr_13580_13607[(1)] = (14));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13572 === (6)))
{var inst_13536 = (state_13571[(8)]);var inst_13557 = (inst_13536 > (0));var state_13571__$1 = state_13571;if(cljs.core.truth_(inst_13557))
{var statearr_13581_13608 = state_13571__$1;(statearr_13581_13608[(1)] = (12));
} else
{var statearr_13582_13609 = state_13571__$1;(statearr_13582_13609[(1)] = (13));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13572 === (3)))
{var inst_13569 = (state_13571[(2)]);var state_13571__$1 = state_13571;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13571__$1,inst_13569);
} else
{if((state_val_13572 === (12)))
{var inst_13535 = (state_13571[(7)]);var inst_13559 = cljs.core.vec.call(null,inst_13535);var state_13571__$1 = state_13571;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13571__$1,(15),out,inst_13559);
} else
{if((state_val_13572 === (2)))
{var state_13571__$1 = state_13571;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13571__$1,(4),ch);
} else
{if((state_val_13572 === (11)))
{var inst_13551 = (state_13571[(2)]);var inst_13552 = (new Array(n));var inst_13535 = inst_13552;var inst_13536 = (0);var state_13571__$1 = (function (){var statearr_13583 = state_13571;(statearr_13583[(7)] = inst_13535);
(statearr_13583[(10)] = inst_13551);
(statearr_13583[(8)] = inst_13536);
return statearr_13583;
})();var statearr_13584_13610 = state_13571__$1;(statearr_13584_13610[(2)] = null);
(statearr_13584_13610[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13572 === (9)))
{var inst_13535 = (state_13571[(7)]);var inst_13549 = cljs.core.vec.call(null,inst_13535);var state_13571__$1 = state_13571;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13571__$1,(11),out,inst_13549);
} else
{if((state_val_13572 === (5)))
{var inst_13535 = (state_13571[(7)]);var inst_13544 = (state_13571[(11)]);var inst_13539 = (state_13571[(9)]);var inst_13536 = (state_13571[(8)]);var inst_13543 = (inst_13535[inst_13536] = inst_13539);var inst_13544__$1 = (inst_13536 + (1));var inst_13545 = (inst_13544__$1 < n);var state_13571__$1 = (function (){var statearr_13585 = state_13571;(statearr_13585[(12)] = inst_13543);
(statearr_13585[(11)] = inst_13544__$1);
return statearr_13585;
})();if(cljs.core.truth_(inst_13545))
{var statearr_13586_13611 = state_13571__$1;(statearr_13586_13611[(1)] = (8));
} else
{var statearr_13587_13612 = state_13571__$1;(statearr_13587_13612[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13572 === (14)))
{var inst_13564 = (state_13571[(2)]);var inst_13565 = cljs.core.async.close_BANG_.call(null,out);var state_13571__$1 = (function (){var statearr_13589 = state_13571;(statearr_13589[(13)] = inst_13564);
return statearr_13589;
})();var statearr_13590_13613 = state_13571__$1;(statearr_13590_13613[(2)] = inst_13565);
(statearr_13590_13613[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13572 === (10)))
{var inst_13555 = (state_13571[(2)]);var state_13571__$1 = state_13571;var statearr_13591_13614 = state_13571__$1;(statearr_13591_13614[(2)] = inst_13555);
(statearr_13591_13614[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13572 === (8)))
{var inst_13535 = (state_13571[(7)]);var inst_13544 = (state_13571[(11)]);var tmp13588 = inst_13535;var inst_13535__$1 = tmp13588;var inst_13536 = inst_13544;var state_13571__$1 = (function (){var statearr_13592 = state_13571;(statearr_13592[(7)] = inst_13535__$1);
(statearr_13592[(8)] = inst_13536);
return statearr_13592;
})();var statearr_13593_13615 = state_13571__$1;(statearr_13593_13615[(2)] = null);
(statearr_13593_13615[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__5915__auto___13601,out))
;return ((function (switch__5900__auto__,c__5915__auto___13601,out){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_13597 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_13597[(0)] = state_machine__5901__auto__);
(statearr_13597[(1)] = (1));
return statearr_13597;
});
var state_machine__5901__auto____1 = (function (state_13571){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_13571);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e13598){if((e13598 instanceof Object))
{var ex__5904__auto__ = e13598;var statearr_13599_13616 = state_13571;(statearr_13599_13616[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13571);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e13598;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__13617 = state_13571;
state_13571 = G__13617;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_13571){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_13571);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto___13601,out))
})();var state__5917__auto__ = (function (){var statearr_13600 = f__5916__auto__.call(null);(statearr_13600[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto___13601);
return statearr_13600;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto___13601,out))
);
return out;
});
partition = function(n,ch,buf_or_n){
switch(arguments.length){
case 2:
return partition__2.call(this,n,ch);
case 3:
return partition__3.call(this,n,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
partition.cljs$core$IFn$_invoke$arity$2 = partition__2;
partition.cljs$core$IFn$_invoke$arity$3 = partition__3;
return partition;
})()
;
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.partition_by = (function() {
var partition_by = null;
var partition_by__2 = (function (f,ch){return partition_by.call(null,f,ch,null);
});
var partition_by__3 = (function (f,ch,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__5915__auto___13760 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__5915__auto___13760,out){
return (function (){var f__5916__auto__ = (function (){var switch__5900__auto__ = ((function (c__5915__auto___13760,out){
return (function (state_13730){var state_val_13731 = (state_13730[(1)]);if((state_val_13731 === (7)))
{var inst_13726 = (state_13730[(2)]);var state_13730__$1 = state_13730;var statearr_13732_13761 = state_13730__$1;(statearr_13732_13761[(2)] = inst_13726);
(statearr_13732_13761[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13731 === (1)))
{var inst_13689 = [];var inst_13690 = inst_13689;var inst_13691 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);var state_13730__$1 = (function (){var statearr_13733 = state_13730;(statearr_13733[(7)] = inst_13690);
(statearr_13733[(8)] = inst_13691);
return statearr_13733;
})();var statearr_13734_13762 = state_13730__$1;(statearr_13734_13762[(2)] = null);
(statearr_13734_13762[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13731 === (4)))
{var inst_13694 = (state_13730[(9)]);var inst_13694__$1 = (state_13730[(2)]);var inst_13695 = (inst_13694__$1 == null);var inst_13696 = cljs.core.not.call(null,inst_13695);var state_13730__$1 = (function (){var statearr_13735 = state_13730;(statearr_13735[(9)] = inst_13694__$1);
return statearr_13735;
})();if(inst_13696)
{var statearr_13736_13763 = state_13730__$1;(statearr_13736_13763[(1)] = (5));
} else
{var statearr_13737_13764 = state_13730__$1;(statearr_13737_13764[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13731 === (15)))
{var inst_13720 = (state_13730[(2)]);var state_13730__$1 = state_13730;var statearr_13738_13765 = state_13730__$1;(statearr_13738_13765[(2)] = inst_13720);
(statearr_13738_13765[(1)] = (14));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13731 === (13)))
{var state_13730__$1 = state_13730;var statearr_13739_13766 = state_13730__$1;(statearr_13739_13766[(2)] = null);
(statearr_13739_13766[(1)] = (14));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13731 === (6)))
{var inst_13690 = (state_13730[(7)]);var inst_13715 = inst_13690.length;var inst_13716 = (inst_13715 > (0));var state_13730__$1 = state_13730;if(cljs.core.truth_(inst_13716))
{var statearr_13740_13767 = state_13730__$1;(statearr_13740_13767[(1)] = (12));
} else
{var statearr_13741_13768 = state_13730__$1;(statearr_13741_13768[(1)] = (13));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13731 === (3)))
{var inst_13728 = (state_13730[(2)]);var state_13730__$1 = state_13730;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13730__$1,inst_13728);
} else
{if((state_val_13731 === (12)))
{var inst_13690 = (state_13730[(7)]);var inst_13718 = cljs.core.vec.call(null,inst_13690);var state_13730__$1 = state_13730;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13730__$1,(15),out,inst_13718);
} else
{if((state_val_13731 === (2)))
{var state_13730__$1 = state_13730;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13730__$1,(4),ch);
} else
{if((state_val_13731 === (11)))
{var inst_13698 = (state_13730[(10)]);var inst_13694 = (state_13730[(9)]);var inst_13708 = (state_13730[(2)]);var inst_13709 = [];var inst_13710 = inst_13709.push(inst_13694);var inst_13690 = inst_13709;var inst_13691 = inst_13698;var state_13730__$1 = (function (){var statearr_13742 = state_13730;(statearr_13742[(7)] = inst_13690);
(statearr_13742[(11)] = inst_13708);
(statearr_13742[(8)] = inst_13691);
(statearr_13742[(12)] = inst_13710);
return statearr_13742;
})();var statearr_13743_13769 = state_13730__$1;(statearr_13743_13769[(2)] = null);
(statearr_13743_13769[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13731 === (9)))
{var inst_13690 = (state_13730[(7)]);var inst_13706 = cljs.core.vec.call(null,inst_13690);var state_13730__$1 = state_13730;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13730__$1,(11),out,inst_13706);
} else
{if((state_val_13731 === (5)))
{var inst_13698 = (state_13730[(10)]);var inst_13694 = (state_13730[(9)]);var inst_13691 = (state_13730[(8)]);var inst_13698__$1 = f.call(null,inst_13694);var inst_13699 = cljs.core._EQ_.call(null,inst_13698__$1,inst_13691);var inst_13700 = cljs.core.keyword_identical_QMARK_.call(null,inst_13691,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));var inst_13701 = (inst_13699) || (inst_13700);var state_13730__$1 = (function (){var statearr_13744 = state_13730;(statearr_13744[(10)] = inst_13698__$1);
return statearr_13744;
})();if(cljs.core.truth_(inst_13701))
{var statearr_13745_13770 = state_13730__$1;(statearr_13745_13770[(1)] = (8));
} else
{var statearr_13746_13771 = state_13730__$1;(statearr_13746_13771[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13731 === (14)))
{var inst_13723 = (state_13730[(2)]);var inst_13724 = cljs.core.async.close_BANG_.call(null,out);var state_13730__$1 = (function (){var statearr_13748 = state_13730;(statearr_13748[(13)] = inst_13723);
return statearr_13748;
})();var statearr_13749_13772 = state_13730__$1;(statearr_13749_13772[(2)] = inst_13724);
(statearr_13749_13772[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13731 === (10)))
{var inst_13713 = (state_13730[(2)]);var state_13730__$1 = state_13730;var statearr_13750_13773 = state_13730__$1;(statearr_13750_13773[(2)] = inst_13713);
(statearr_13750_13773[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_13731 === (8)))
{var inst_13690 = (state_13730[(7)]);var inst_13698 = (state_13730[(10)]);var inst_13694 = (state_13730[(9)]);var inst_13703 = inst_13690.push(inst_13694);var tmp13747 = inst_13690;var inst_13690__$1 = tmp13747;var inst_13691 = inst_13698;var state_13730__$1 = (function (){var statearr_13751 = state_13730;(statearr_13751[(7)] = inst_13690__$1);
(statearr_13751[(8)] = inst_13691);
(statearr_13751[(14)] = inst_13703);
return statearr_13751;
})();var statearr_13752_13774 = state_13730__$1;(statearr_13752_13774[(2)] = null);
(statearr_13752_13774[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__5915__auto___13760,out))
;return ((function (switch__5900__auto__,c__5915__auto___13760,out){
return (function() {
var state_machine__5901__auto__ = null;
var state_machine__5901__auto____0 = (function (){var statearr_13756 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_13756[(0)] = state_machine__5901__auto__);
(statearr_13756[(1)] = (1));
return statearr_13756;
});
var state_machine__5901__auto____1 = (function (state_13730){while(true){
var ret_value__5902__auto__ = (function (){try{while(true){
var result__5903__auto__ = switch__5900__auto__.call(null,state_13730);if(cljs.core.keyword_identical_QMARK_.call(null,result__5903__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__5903__auto__;
}
break;
}
}catch (e13757){if((e13757 instanceof Object))
{var ex__5904__auto__ = e13757;var statearr_13758_13775 = state_13730;(statearr_13758_13775[(5)] = ex__5904__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13730);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{throw e13757;

}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__5902__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__13776 = state_13730;
state_13730 = G__13776;
continue;
}
} else
{return ret_value__5902__auto__;
}
break;
}
});
state_machine__5901__auto__ = function(state_13730){
switch(arguments.length){
case 0:
return state_machine__5901__auto____0.call(this);
case 1:
return state_machine__5901__auto____1.call(this,state_13730);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__5901__auto____0;
state_machine__5901__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__5901__auto____1;
return state_machine__5901__auto__;
})()
;})(switch__5900__auto__,c__5915__auto___13760,out))
})();var state__5917__auto__ = (function (){var statearr_13759 = f__5916__auto__.call(null);(statearr_13759[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__5915__auto___13760);
return statearr_13759;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__5917__auto__);
});})(c__5915__auto___13760,out))
);
return out;
});
partition_by = function(f,ch,buf_or_n){
switch(arguments.length){
case 2:
return partition_by__2.call(this,f,ch);
case 3:
return partition_by__3.call(this,f,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
partition_by.cljs$core$IFn$_invoke$arity$2 = partition_by__2;
partition_by.cljs$core$IFn$_invoke$arity$3 = partition_by__3;
return partition_by;
})()
;
