(ns com.invisiblefriend.component.datomic
  "Provides a Datomic database component."
  (:require [com.stuartsierra.component :as component]
            [datomic.api :as d]))

(defrecord Datomic [uri conn]
  component/Lifecycle
  (start [component]
    (if conn
      component
      (do (d/create-database uri)
          (assoc component :conn (d/connect uri)))))
  (stop [component]
    (if-not conn
      component
      (dissoc component :conn))))

(defn new-datomic-db
  "Creates and returns a Datomic component from a map of options.
  **Required**: `{:uri \"a Datomic URI\"}`"
  [options]
  {:pre [((every-pred map? (comp string? :uri)) options)]}
  (map->Datomic options))
