/*
 * Decompiled with CFR 0.152.
 */
package com.instrument.triface;

import com.instrument.triface.IObjectFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;

public class JSObjectFactory
implements IObjectFactory {
    protected final Context context = Context.enter();
    protected final Scriptable scriptable = new ImporterTopLevel(this.context);
    protected Class interfaceType;
    protected File script;

    public JSObjectFactory(Class interfaceType, File script) {
        this.interfaceType = interfaceType;
        this.script = script;
    }

    public Object createObject() {
        Object generator = null;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(this.script));
            Script script = this.context.compileReader((Reader)reader, "source", 0, null);
            Object object = script.exec(this.context, this.scriptable);
            generator = Context.jsToJava((Object)object, (Class)this.interfaceType);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create " + this.interfaceType + " object from: " + this.script.getPath(), e);
        }
        return generator;
    }
}

