/*
 * Decompiled with CFR 0.152.
 */
package com.instrument.triface;

import com.instrument.triface.IObjectFactory;
import com.instrument.triface.util.FileUtils;
import java.io.File;
import org.jruby.embed.ScriptingContainer;

public class JRubyObjectFactory
implements IObjectFactory {
    protected final ScriptingContainer scriptingContainer;
    protected final Class interfaceType;
    protected final File script;

    public JRubyObjectFactory(ScriptingContainer scriptingContainer, Class interfaceType, File script) {
        this.scriptingContainer = scriptingContainer;
        this.interfaceType = interfaceType;
        this.script = script;
    }

    public JRubyObjectFactory(Class interfaceType, File script) {
        this(new ScriptingContainer(), interfaceType, script);
    }

    public Object createObject() {
        Object ret = null;
        try {
            this.scriptingContainer.getLoadPaths().add(FileUtils.getPath(this.script));
            this.scriptingContainer.runScriptlet("load '" + this.script.getName() + "'");
            ret = this.scriptingContainer.runScriptlet(FileUtils.getFileNameSansExtension(this.script) + ".new");
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create " + this.interfaceType + " object from: " + this.script, e);
        }
        return ret;
    }
}

