/*
 * Decompiled with CFR 0.152.
 */
package lamina.stats.sample;

import clojure.lang.IDeref;
import clojure.lang.IFn;
import clojure.lang.IObj;
import clojure.lang.IPersistentVector;
import clojure.lang.IType;
import clojure.lang.Indexed;
import clojure.lang.Numbers;
import clojure.lang.RT;
import clojure.lang.Symbol;
import clojure.lang.Var;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicLong;
import lamina.core.lock.ILock;
import lamina.stats.sample.IExponentiallyDecayingSampler;
import lamina.stats.utils.IUpdatable;
import potemkin.types.PotemkinType;

public final class ExponentiallyDecayingSampler
implements IExponentiallyDecayingSampler,
IUpdatable,
PotemkinType,
IDeref,
IType {
    public final Object samples;
    public final Object counter;
    public final Object next_rescale;
    volatile long start_time;
    public final double alpha;
    public final Object lock;
    public final Object task_queue;
    public final long sample_size;
    public static final Var const__1 = RT.var((String)"clojure.core", (String)"vals");
    public static final Var const__3 = RT.var((String)"lamina.time", (String)"now");
    public static final Var const__8 = RT.var((String)"lamina.stats.sample", (String)"priority");
    public static final Var const__12 = RT.var((String)"lamina.stats.sample", (String)"rescale-interval");
    public static final Var const__15 = RT.var((String)"clojure.core", (String)"seq");
    public static final Var const__16 = RT.var((String)"clojure.core", (String)"keys");
    public static final Var const__19 = RT.var((String)"clojure.core", (String)"chunked-seq?");
    public static final Var const__20 = RT.var((String)"clojure.core", (String)"chunk-first");
    public static final Var const__21 = RT.var((String)"clojure.core", (String)"chunk-rest");
    public static final Var const__24 = RT.var((String)"clojure.core", (String)"first");
    public static final Var const__25 = RT.var((String)"clojure.core", (String)"next");

    public ExponentiallyDecayingSampler(Object object, Object object2, Object object3, long l, double d, Object object4, Object object5, long l2) {
        this.samples = object;
        this.counter = object2;
        this.next_rescale = object3;
        this.start_time = l;
        this.alpha = d;
        this.lock = object4;
        this.task_queue = object5;
        this.sample_size = l2;
    }

    public static IPersistentVector getBasis() {
        return RT.vector((Object[])new Object[]{((IObj)Symbol.intern(null, (String)"samples")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"ConcurrentSkipListMap")})), ((IObj)Symbol.intern(null, (String)"counter")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"AtomicLong")})), ((IObj)Symbol.intern(null, (String)"next-rescale")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"AtomicLong")})), ((IObj)Symbol.intern(null, (String)"start-time")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"volatile-mutable"), Boolean.TRUE, RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"long")})), ((IObj)Symbol.intern(null, (String)"alpha")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"double")})), Symbol.intern(null, (String)"lock"), Symbol.intern(null, (String)"task-queue"), ((IObj)Symbol.intern(null, (String)"sample-size")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"long")}))});
    }

    public Object rescale(Object next) {
        Object v16;
        Object object = next;
        next = null;
        if (((AtomicLong)this.next_rescale).compareAndSet(RT.uncheckedLongCast((Object)((Number)object)), ((IFn.OL)const__3.getRawRoot()).invokePrim(this.task_queue) + RT.longCast((Object)const__12.getRawRoot()))) {
            Object var18_13;
            Object lock__3414__auto__8534 = this.lock;
            ((ILock)lock__3414__auto__8534).acquire_exclusive();
            try {
                long prev_start_time = this.start_time;
                this.start_time = ((IFn.OL)const__3.getRawRoot()).invokePrim(this.task_queue);
                Numbers.num((long)this.start_time);
                double scale_factor = Math.exp(Numbers.unchecked_multiply((double)(-this.alpha), (long)(this.start_time - prev_start_time)));
                Object seq_8527 = ((IFn)const__15.getRawRoot()).invoke(((IFn)const__16.getRawRoot()).invoke(this.samples));
                Object chunk_8528 = null;
                long count_8529 = 0L;
                long i_8530 = 0L;
                while (true) {
                    Object temp__5457__auto__8533;
                    if (i_8530 < count_8529) {
                        Object k = ((Indexed)chunk_8528).nth(RT.uncheckedIntCast((long)i_8530));
                        Object val = ((ConcurrentSkipListMap)this.samples).remove(k);
                        Object object2 = k;
                        k = null;
                        Object v = val;
                        val = null;
                        ((ConcurrentSkipListMap)this.samples).put(Numbers.unchecked_multiply((double)scale_factor, (Object)object2), v);
                        Object object3 = seq_8527;
                        seq_8527 = null;
                        Object object4 = chunk_8528;
                        chunk_8528 = null;
                        ++i_8530;
                        chunk_8528 = object4;
                        seq_8527 = object3;
                        continue;
                    }
                    Object object5 = seq_8527;
                    seq_8527 = null;
                    Object object6 = temp__5457__auto__8533 = ((IFn)const__15.getRawRoot()).invoke(object5);
                    if (object6 == null || object6 == Boolean.FALSE) break;
                    Object object7 = temp__5457__auto__8533;
                    temp__5457__auto__8533 = null;
                    Object seq_85272 = object7;
                    Object object8 = ((IFn)const__19.getRawRoot()).invoke(seq_85272);
                    if (object8 != null && object8 != Boolean.FALSE) {
                        Object c__5719__auto__8532 = ((IFn)const__20.getRawRoot()).invoke(seq_85272);
                        Object object9 = seq_85272;
                        seq_85272 = null;
                        Object object10 = c__5719__auto__8532;
                        Object object11 = c__5719__auto__8532;
                        c__5719__auto__8532 = null;
                        i_8530 = (int)0L;
                        count_8529 = RT.count((Object)object11);
                        chunk_8528 = object10;
                        seq_8527 = ((IFn)const__21.getRawRoot()).invoke(object9);
                        continue;
                    }
                    Object k = ((IFn)const__24.getRawRoot()).invoke(seq_85272);
                    Object val = ((ConcurrentSkipListMap)this.samples).remove(k);
                    Object object12 = k;
                    k = null;
                    Object v = val;
                    val = null;
                    ((ConcurrentSkipListMap)this.samples).put(Numbers.unchecked_multiply((double)scale_factor, (Object)object12), v);
                    Object object13 = seq_85272;
                    seq_85272 = null;
                    i_8530 = 0L;
                    count_8529 = 0L;
                    chunk_8528 = null;
                    seq_8527 = ((IFn)const__25.getRawRoot()).invoke(object13);
                }
                ((AtomicLong)this.counter).set(RT.count((Object)this.samples));
                var18_13 = null;
            }
            finally {
                Object object14 = lock__3414__auto__8534;
                lock__3414__auto__8534 = null;
                ((ILock)object14).release_exclusive();
            }
            v16 = var18_13;
        } else {
            v16 = null;
        }
        return v16;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object update(Object val) {
        Object object;
        Object object2;
        long now2 = ((IFn.OL)const__3.getRawRoot()).invokePrim(this.task_queue);
        if (now2 >= ((AtomicLong)this.next_rescale).get()) {
            ((IExponentiallyDecayingSampler)this).rescale(Numbers.num((long)((AtomicLong)this.next_rescale).get()));
            Object object3 = val;
            val = null;
            object2 = ((IUpdatable)this).update(object3);
            return object2;
        }
        long elapsed = now2 - this.start_time;
        Object pr = ((IFn)const__8.getRawRoot()).invoke((Object)this.alpha, (Object)Numbers.num((long)elapsed));
        Object lock__3412__auto__8535 = this.lock;
        ((ILock)lock__3412__auto__8535).acquire();
        try {
            Object object4;
            block8: {
                Object frst;
                block10: {
                    block9: {
                        block7: {
                            if (((AtomicLong)this.counter).incrementAndGet() >= this.sample_size) break block7;
                            Object object5 = pr;
                            pr = null;
                            Object object6 = val;
                            val = null;
                            object4 = ((ConcurrentSkipListMap)this.samples).put(object5, object6);
                            break block8;
                        }
                        frst = ((ConcurrentSkipListMap)this.samples).firstKey();
                        if (!Numbers.lt(frst, (Object)pr)) break block9;
                        Object object7 = pr;
                        pr = null;
                        Object object8 = val;
                        val = null;
                        Object object9 = ((ConcurrentSkipListMap)this.samples).putIfAbsent(object7, object8);
                        if (object9 == null || object9 == Boolean.FALSE) break block10;
                        object4 = null;
                        break block8;
                    }
                    object4 = null;
                    break block8;
                }
                Object k = frst;
                frst = null;
                Object frst2 = k;
                while (true) {
                    Object k2 = frst2;
                    frst2 = null;
                    Object v = ((ConcurrentSkipListMap)this.samples).remove(k2);
                    if (v != null && v != Boolean.FALSE) {
                        object4 = null;
                        break;
                    }
                    frst2 = ((ConcurrentSkipListMap)this.samples).firstKey();
                }
            }
            object = object4;
        }
        finally {
            Object object10 = lock__3412__auto__8535;
            lock__3412__auto__8535 = null;
            ((ILock)object10).release();
        }
        object2 = object;
        return object2;
    }

    public Object deref() {
        Object object;
        Object lock__3412__auto__8536 = this.lock;
        ((ILock)lock__3412__auto__8536).acquire();
        try {
            object = ((IFn)const__1.getRawRoot()).invoke(this.samples);
        }
        finally {
            Object object2 = lock__3412__auto__8536;
            lock__3412__auto__8536 = null;
            ((ILock)object2).release();
        }
        return object;
    }
}

