/*
 * Decompiled with CFR 0.152.
 */
package lamina.stats.variance;

import clojure.lang.IFn;
import clojure.lang.IObj;
import clojure.lang.IPersistentVector;
import clojure.lang.IType;
import clojure.lang.Numbers;
import clojure.lang.RT;
import clojure.lang.Symbol;
import clojure.lang.Var;
import lamina.stats.utils.IUpdatable;
import lamina.stats.variance.IVariance;
import potemkin.types.PotemkinType;

public final class Variance
implements IUpdatable,
IVariance,
PotemkinType,
IType {
    public static final Var const__0 = RT.var((String)"clojure.core", (String)">");
    public static final Object const__1 = 1L;
    public static final Var const__2 = RT.var((String)"clojure.core", (String)"/");
    public static final Var const__3 = RT.var((String)"clojure.core", (String)"dec");
    public static final Object const__4 = 0L;
    public static final Var const__5 = RT.var((String)"lamina.stats.variance", (String)"variance");
    public static final Var const__6 = RT.var((String)"clojure.core", (String)"inc");
    public static final Var const__7 = RT.var((String)"clojure.core", (String)"-");
    public static final Var const__8 = RT.var((String)"clojure.core", (String)"+");
    public static final Var const__9 = RT.var((String)"clojure.core", (String)"*");
    public final double mean;
    public final double m2;
    public final long count;

    public Variance(double d, double d2, long l) {
        this.mean = d;
        this.m2 = d2;
        this.count = l;
    }

    public static IPersistentVector getBasis() {
        return RT.vector((Object[])new Object[]{((IObj)Symbol.intern(null, (String)"mean")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"double")})), ((IObj)Symbol.intern(null, (String)"m2")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"double")})), ((IObj)Symbol.intern(null, (String)"count")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"long")}))});
    }

    public Object update(Object value) {
        Object m2;
        Object object;
        long count = Numbers.inc((long)this.count);
        double delta = Numbers.minus((Object)value, (double)this.mean);
        double mean = this.mean + Numbers.divide((double)delta, (long)count);
        if (count > 1L) {
            Object object2 = value;
            value = null;
            object = Numbers.add((double)this.m2, (double)(delta * Numbers.minus((Object)object2, (double)mean)));
        } else {
            object = const__4;
        }
        Object object3 = m2 = object;
        m2 = null;
        return new Variance(mean, RT.doubleCast((Object)((Number)object3)), count);
    }

    public Object mean() {
        return this.mean;
    }

    public Object std_dev() {
        return Math.sqrt(RT.doubleCast((Object)((Number)((IFn)const__5.getRawRoot()).invoke((Object)this))));
    }

    public Object variance() {
        return this.count > 1L ? Double.valueOf(Numbers.divide((double)this.m2, (long)Numbers.dec((long)this.count))) : const__4;
    }
}

