(ns leiningen.bundle
  (require [leiningen.core.main :as main]
           (clojure.java [shell :as sh] [io :as io])
           [clojure.string :as s]))

(set! *warn-on-reflection* true)

(defn abort [fmt & args] (main/abort (apply format fmt args)))

(defn sh! [& args]
  (apply println "$" args)
  (let [p (-> (ProcessBuilder. ^"[Ljava.lang.String;" (into-array args))
              (.redirectErrorStream true)
              .start)]
    (io/copy (.getInputStream p) System/out)
    (let [res (.waitFor p)]
      (when-not (zero? res) (abort "Command failed with exit code %s: %s" res args))
      res)))

(defn bundle [project tag]
  (let [bundle-dir "target/lein-bundle"]
    (sh! "mkdir" "-p" bundle-dir)
    (try
      (sh! "sh" "-c" (format "git archive %s | tar -xC %s" tag bundle-dir))
      (sh! "sh" "-c" (format "cd %s ; lein bundle-helper .." bundle-dir))
      (finally (sh! "rm" "-rf" bundle-dir)))))
