(ns leiningen.bundle
  (require (clojure.java [shell :as sh] [io :as io])
           [clojure.string :as s]))

(set! *warn-on-reflection* true)

(defn raise [fmt & args] (throw (RuntimeException. ^String (apply format fmt args))))

(defn sh! [& args]
  (apply println args)
  (let [res (apply sh/sh args)]
    (print (:out res)) (print (:err res)) (flush)
    (when-not (zero? (:exit res)) (raise "Command failed with exit code %s: %s" (:exit res) args))))

(defn bundle [project tag]
  (let [bundle-dir "target/lein-bundle"]
    (sh! "mkdir" "-p" bundle-dir)
    (try
      (sh! "sh" "-c" (format "git archive %s | tar -xC %s" tag bundle-dir))
      (sh! "sh" "-c" (format "cd %s ; lein bundle-helper .." bundle-dir))
      (finally (sh! "rm" "-rf" bundle-dir)))))
