(ns clj-utils.tfm
  (:require [clj-time.format :as tf]
            [clj-time.coerce :as tc]
            [digest])
  (:gen-class))

(defn anon-ip
  "Anonymise an IP address by removing the last octlet.
  Checks to see if the value is nil, if so returns nil."
  [^java.lang.Integer ip]
  (when-not (nil? ip)
    (if (pos? ip)
      (- ip (bit-and ip 255))
      ;; This is a hack to get over badly sized int types.
      (+ 2147483648 (- (- ip) (bit-and ip 255))))))

(defn epoch-to-iso8601
  "Turns a second granular epoch TS to a ISO8601 formatted string."
  [^java.lang.Long ts-long]
  (-> ts-long
      (* 1000)
      (tc/from-long)
      (->> (tf/unparse (tf/formatter :date-time)))))

(defn hash-ip
  "Compute salted MD5 hash of integer IP address.
  Returns nil if IP is nil."
  [^java.lang.Integer ip]
  (let [salt "nonsaltedocean"]
    (if-not (nil? ip)
      (digest/md5 (str ip salt))
      nil)))
