(ns clj-utils.user
  (:require [clojure.data.codec.base64 :as b64]
            [clojure.string :as str]))

(defn user-id-convert
  "Convert user id from bytearray to web safe string"
  [user-bytes]
  (-> user-bytes
      (.toByteArray)
      (b64/encode)
      (String. "UTF-8")
      (str/replace "+" "-")
      (str/replace "/" "")))

(defn device-id-convert
  "Convert b64 device ID to UUID"
  [device-id]
  device-id)


 
