(ns clj-utils.log
  (:require [cheshire.core :as json]
            [clojure.string :as str]
            [gregor.core :as gregor]))


; Set atom to log to the correct kafka topic
(def app (atom nil))
(def producer (atom nil))

(defn log
  "Convert user id from bytearray to web safe string"
  [level message]
  (let [output {:level level :message message}]
    (try 
      (gregor/send @producer @app (json/generate-string output))
      (catch Exception e
        (println (str e))))))

(def error (partial log "error"))
(def warn (partial log "warn"))

(defn run
  [kafka-server app-name]
  (reset! app app-name)
  (reset! producer (gregor/producer kafka-server)))

(defn stop
  []
  (gregor/close @producer)
  (reset! producer nil)
  (reset! app nil))

