(ns clj-utils.user
  (:require [clojure.data.codec.base64 :as b64]
            [clojure.string :as str]))

(defn user-id-convert
  "Convert user id from bytearray to web safe string"
  [user-bytes]
  (str/replace (str/replace (String. (b64/encode (.toByteArray user-bytes)) "UTF-8") "+" "-") "/" "_"))


