/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.AbstractIterator;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnNameBuilder;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ColumnToCollectionType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.utils.ByteBufferUtil;

public class CFDefinition
implements Iterable<Name> {
    public static final AbstractType<?> definitionType = UTF8Type.instance;
    private static final String DEFAULT_KEY_ALIAS = "key";
    private static final String DEFAULT_COLUMN_ALIAS = "column";
    private static final String DEFAULT_VALUE_ALIAS = "value";
    public final CFMetaData cfm;
    public final LinkedHashMap<ColumnIdentifier, Name> keys = new LinkedHashMap();
    public final LinkedHashMap<ColumnIdentifier, Name> columns = new LinkedHashMap();
    public final Name value;
    public final Map<ColumnIdentifier, Name> metadata = new TreeMap<ColumnIdentifier, Name>();
    public final boolean isComposite;
    public final boolean hasCompositeKey;
    public final boolean isCompact;
    public final boolean hasCollections;

    public CFDefinition(CFMetaData cfm) {
        ColumnIdentifier id;
        ColumnIdentifier id2;
        this.cfm = cfm;
        if (cfm.getKeyValidator() instanceof CompositeType) {
            this.hasCompositeKey = true;
            CompositeType keyComposite = (CompositeType)cfm.getKeyValidator();
            assert (keyComposite.types.size() > 1);
            for (int i = 0; i < keyComposite.types.size(); ++i) {
                id2 = CFDefinition.getKeyId(cfm, i);
                this.keys.put(id2, new Name(cfm.ksName, cfm.cfName, id2, Name.Kind.KEY_ALIAS, i, keyComposite.types.get(i)));
            }
        } else {
            this.hasCompositeKey = false;
            id = CFDefinition.getKeyId(cfm, 0);
            this.keys.put(id, new Name(cfm.ksName, cfm.cfName, id, Name.Kind.KEY_ALIAS, 0, cfm.getKeyValidator()));
        }
        if (cfm.comparator instanceof CompositeType) {
            this.isComposite = true;
            CompositeType composite = (CompositeType)cfm.comparator;
            int last = composite.types.size() - 1;
            AbstractType<?> lastType = composite.types.get(last);
            if (lastType instanceof ColumnToCollectionType || cfm.getColumnAliases().size() == last && lastType instanceof UTF8Type) {
                this.isCompact = false;
                this.value = null;
                assert (cfm.getValueAlias() == null);
                if (lastType instanceof ColumnToCollectionType) {
                    --last;
                    this.hasCollections = true;
                } else {
                    this.hasCollections = false;
                }
                for (int i = 0; i < last; ++i) {
                    ColumnIdentifier id3 = CFDefinition.getColumnId(cfm, i);
                    this.columns.put(id3, new Name(cfm.ksName, cfm.cfName, id3, Name.Kind.COLUMN_ALIAS, i, composite.types.get(i)));
                }
                for (Map.Entry<ByteBuffer, ColumnDefinition> def : cfm.getColumn_metadata().entrySet()) {
                    ColumnIdentifier id4 = new ColumnIdentifier(def.getKey(), cfm.getColumnDefinitionComparator(def.getValue()));
                    this.metadata.put(id4, new Name(cfm.ksName, cfm.cfName, id4, Name.Kind.COLUMN_METADATA, def.getValue().getValidator()));
                }
            } else {
                this.isCompact = true;
                this.hasCollections = false;
                for (int i = 0; i < composite.types.size(); ++i) {
                    ColumnIdentifier id5 = CFDefinition.getColumnId(cfm, i);
                    this.columns.put(id5, new Name(cfm.ksName, cfm.cfName, id5, Name.Kind.COLUMN_ALIAS, i, composite.types.get(i)));
                }
                this.value = CFDefinition.createValue(cfm);
            }
        } else {
            this.isComposite = false;
            this.hasCollections = false;
            if (!cfm.getColumnAliases().isEmpty() || cfm.getColumn_metadata().isEmpty()) {
                this.isCompact = true;
                id = CFDefinition.getColumnId(cfm, 0);
                Name name = new Name(cfm.ksName, cfm.cfName, id, Name.Kind.COLUMN_ALIAS, 0, cfm.comparator);
                this.columns.put(id, name);
                this.value = CFDefinition.createValue(cfm);
            } else {
                this.isCompact = false;
                this.value = null;
                assert (cfm.getValueAlias() == null);
                assert (cfm.getColumnAliases() == null || cfm.getColumnAliases().isEmpty());
                for (Map.Entry<ByteBuffer, ColumnDefinition> def : cfm.getColumn_metadata().entrySet()) {
                    id2 = new ColumnIdentifier(def.getKey(), cfm.getColumnDefinitionComparator(def.getValue()));
                    this.metadata.put(id2, new Name(cfm.ksName, cfm.cfName, id2, Name.Kind.COLUMN_METADATA, def.getValue().getValidator()));
                }
            }
        }
        assert (this.value == null || this.metadata.isEmpty());
    }

    private static ColumnIdentifier getKeyId(CFMetaData cfm, int i) {
        List<ByteBuffer> definedNames = cfm.getKeyAliases();
        return definedNames == null || i >= definedNames.size() || cfm.getKeyAliases().get(i) == null ? new ColumnIdentifier(i == 0 ? DEFAULT_KEY_ALIAS : DEFAULT_KEY_ALIAS + (i + 1), false) : new ColumnIdentifier(cfm.getKeyAliases().get(i), definitionType);
    }

    private static ColumnIdentifier getColumnId(CFMetaData cfm, int i) {
        List<ByteBuffer> definedNames = cfm.getColumnAliases();
        return definedNames == null || i >= definedNames.size() || cfm.getColumnAliases().get(i) == null ? new ColumnIdentifier(DEFAULT_COLUMN_ALIAS + (i + 1), false) : new ColumnIdentifier(cfm.getColumnAliases().get(i), definitionType);
    }

    private static ColumnIdentifier getValueId(CFMetaData cfm) {
        return cfm.getValueAlias() == null ? new ColumnIdentifier(DEFAULT_VALUE_ALIAS, false) : new ColumnIdentifier(cfm.getValueAlias(), definitionType);
    }

    public ColumnToCollectionType getCollectionType() {
        if (!this.hasCollections) {
            return null;
        }
        CompositeType composite = (CompositeType)this.cfm.comparator;
        return (ColumnToCollectionType)composite.types.get(composite.types.size() - 1);
    }

    private static Name createValue(CFMetaData cfm) {
        ColumnIdentifier alias = CFDefinition.getValueId(cfm);
        return alias.key.equals(ByteBufferUtil.EMPTY_BYTE_BUFFER) ? null : new Name(cfm.ksName, cfm.cfName, alias, Name.Kind.VALUE_ALIAS, cfm.getDefaultValidator());
    }

    public Name get(ColumnIdentifier name) {
        Name kdef = this.keys.get(name);
        if (kdef != null) {
            return kdef;
        }
        if (this.value != null && name.equals(this.value.name)) {
            return this.value;
        }
        Name def = this.columns.get(name);
        if (def != null) {
            return def;
        }
        return this.metadata.get(name);
    }

    @Override
    public Iterator<Name> iterator() {
        return new AbstractIterator<Name>(){
            private final Iterator<Name> keyIter;
            private final Iterator<Name> columnIter;
            private boolean valueDone;
            private final Iterator<Name> metadataIter;
            {
                this.keyIter = CFDefinition.this.keys.values().iterator();
                this.columnIter = CFDefinition.this.columns.values().iterator();
                this.metadataIter = CFDefinition.this.metadata.values().iterator();
            }

            protected Name computeNext() {
                if (this.keyIter.hasNext()) {
                    return this.keyIter.next();
                }
                if (this.columnIter.hasNext()) {
                    return this.columnIter.next();
                }
                if (CFDefinition.this.value != null && !this.valueDone) {
                    this.valueDone = true;
                    return CFDefinition.this.value;
                }
                if (this.metadataIter.hasNext()) {
                    return this.metadataIter.next();
                }
                return (Name)this.endOfData();
            }
        };
    }

    public ColumnNameBuilder getKeyNameBuilder() {
        return this.hasCompositeKey ? new CompositeType.Builder((CompositeType)this.cfm.getKeyValidator()) : new NonCompositeBuilder(this.cfm.getKeyValidator());
    }

    public ColumnNameBuilder getColumnNameBuilder() {
        return this.isComposite ? new CompositeType.Builder((CompositeType)this.cfm.comparator) : new NonCompositeBuilder(this.cfm.comparator);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Joiner.on((String)", ").join(this.keys.values()));
        if (!this.columns.isEmpty()) {
            sb.append(", ").append(Joiner.on((String)", ").join(this.columns.values()));
        }
        sb.append(" => ");
        if (this.value != null) {
            sb.append(this.value.name);
        }
        if (!this.metadata.isEmpty()) {
            sb.append("{").append(Joiner.on((String)", ").join(this.metadata.values())).append(" }");
        }
        return sb.toString();
    }

    private static class NonCompositeBuilder
    implements ColumnNameBuilder {
        private final AbstractType<?> type;
        private ByteBuffer columnName;

        private NonCompositeBuilder(AbstractType<?> type) {
            this.type = type;
        }

        @Override
        public NonCompositeBuilder add(ByteBuffer bb) {
            if (this.columnName != null) {
                throw new IllegalStateException("Column name is already constructed");
            }
            this.columnName = bb;
            return this;
        }

        @Override
        public NonCompositeBuilder add(ByteBuffer bb, Relation.Type op) {
            return this.add(bb);
        }

        @Override
        public int componentCount() {
            return this.columnName == null ? 0 : 1;
        }

        @Override
        public int remainingCount() {
            return this.columnName == null ? 1 : 0;
        }

        @Override
        public ByteBuffer build() {
            return this.columnName == null ? ByteBufferUtil.EMPTY_BYTE_BUFFER : this.columnName;
        }

        @Override
        public ByteBuffer buildAsEndOfRange() {
            return this.build();
        }

        @Override
        public NonCompositeBuilder copy() {
            NonCompositeBuilder newBuilder = new NonCompositeBuilder(this.type);
            newBuilder.columnName = this.columnName;
            return newBuilder;
        }
    }

    public static class Name
    extends ColumnSpecification {
        public final Kind kind;
        public final int position;

        private Name(String ksName, String cfName, ColumnIdentifier name, Kind kind, AbstractType<?> type) {
            this(ksName, cfName, name, kind, -1, type);
        }

        private Name(String ksName, String cfName, ColumnIdentifier name, Kind kind, int position, AbstractType<?> type) {
            super(ksName, cfName, name, type);
            this.kind = kind;
            this.position = position;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Name)) {
                return false;
            }
            Name that = (Name)o;
            return Objects.equal((Object)this.ksName, (Object)that.ksName) && Objects.equal((Object)this.cfName, (Object)that.cfName) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.type, (Object)that.type) && this.kind == that.kind && this.position == that.position;
        }

        public final int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.ksName, this.cfName, this.name, this.type, this.kind, this.position});
        }

        public static enum Kind {
            KEY_ALIAS,
            COLUMN_ALIAS,
            VALUE_ALIAS,
            COLUMN_METADATA;

        }
    }
}

