# dirwatch

Directory watch utility wrapped the Java7 WatchService.  

[![Build status](https://secure.travis-ci.org/ieknir/dirwatch.png)](http://travis-ci.org/ieknir/dirwatch)

## Installation

Leiningen

```clojure
[com.ieknir/dirwatch "0.1.0-SNAPSHOT"]
```

## Usage

```clojure
(ns foo
  (:require [clojure.core.async :refer (<!!)]
            [dirwatch.core :as dirwatch]))

(let [watcher (dirwatch/watch "/path/to/some/dir") 
      channel (. watcher start)
      fetch #(<!! channel)]
    (loop [event (fetch)]
      (when event
        (println "Event received!" event)
        (recur (fetch)))))
```
