/*
 * Decompiled with CFR 0.152.
 */
package com.ibdknox.socket_io_netty;

import com.ibdknox.socket_io_netty.INSIOHandler;
import com.ibdknox.socket_io_netty.WebSocketServerHandler;
import com.ibdknox.socket_io_netty.WebSocketServerPipelineFactory;
import com.ibdknox.socket_io_netty.flashpolicy.FlashPolicyServer;
import java.net.InetSocketAddress;
import java.util.concurrent.Executors;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;

public class NSIOServer {
    private ServerBootstrap bootstrap;
    private Channel serverChannel;
    private int port;
    private boolean running;
    private INSIOHandler handler;
    private WebSocketServerHandler socketHandler;

    public NSIOServer(INSIOHandler handler, int port) {
        this.port = port;
        this.handler = handler;
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void start() {
        this.bootstrap = new ServerBootstrap(new NioServerSocketChannelFactory(Executors.newCachedThreadPool(), Executors.newCachedThreadPool()));
        this.socketHandler = new WebSocketServerHandler(this.handler);
        this.bootstrap.setPipelineFactory(new WebSocketServerPipelineFactory(this.socketHandler));
        this.serverChannel = this.bootstrap.bind(new InetSocketAddress(this.port));
        this.running = true;
        try {
            FlashPolicyServer.start();
        }
        catch (Exception e) {
            System.out.println("You must run as sudo for flash policy server. X-Domain flash will not currently work.");
        }
        System.out.println("Server Started at port [" + this.port + "]");
    }

    public void stop() {
        if (!this.running) {
            return;
        }
        System.out.println("Server shutting down.");
        this.socketHandler.prepShutDown();
        this.handler.OnShutdown();
        System.out.println("**SHUTDOWN**");
        this.serverChannel = null;
        this.bootstrap = null;
        this.running = false;
    }
}

