/*
 * Decompiled with CFR 0.152.
 */
package com.ibdknox.socket_io_netty;

import com.ibdknox.socket_io_netty.GenericIOClient;
import java.util.LinkedList;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.util.CharsetUtil;

public class PollingIOClient
extends GenericIOClient {
    private List<String> queue = new LinkedList<String>();
    private HttpRequest req;
    private boolean connected;

    public PollingIOClient(ChannelHandlerContext ctx, String uID) {
        super(ctx, uID);
    }

    public void Reconnect(ChannelHandlerContext ctx, HttpRequest req) {
        this.ctx = ctx;
        this.req = req;
        this.connected = true;
        this._payload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _payload() {
        if (!this.connected || this.queue.isEmpty()) {
            return;
        }
        List<String> list = this.queue;
        synchronized (list) {
            StringBuilder sb = new StringBuilder();
            for (String message : this.queue) {
                sb.append(message);
            }
            this._write(sb.toString());
            this.queue.clear();
        }
    }

    private void _write(String message) {
        if (!this.open) {
            return;
        }
        DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        res.addHeader("Content-Type", "text/plain; charset=UTF-8");
        res.addHeader("Access-Control-Allow-Origin", "*");
        res.addHeader("Access-Control-Allow-Credentials", "true");
        res.addHeader("Connection", "keep-alive");
        res.setContent(ChannelBuffers.copiedBuffer((CharSequence)message, CharsetUtil.UTF_8));
        HttpHeaders.setContentLength(res, res.getContent().readableBytes());
        Channel chan = this.ctx.getChannel();
        if (chan.isOpen()) {
            ChannelFuture f = chan.write(res);
            if (!HttpHeaders.isKeepAlive(this.req) || res.getStatus().getCode() != 200) {
                f.addListener(ChannelFutureListener.CLOSE);
            }
        }
        this.connected = false;
    }

    public void sendUnencoded(String message) {
        this.queue.add(message);
        this._payload();
    }

    public void sendPulse() {
        if (this.connected) {
            this._write("");
        }
    }
}

