/*
 * Decompiled with CFR 0.152.
 */
package com.ibdknox.socket_io_netty;

import com.ibdknox.socket_io_netty.INSIOClient;
import com.ibdknox.socket_io_netty.PollingIOClient;
import com.ibdknox.socket_io_netty.SocketIOUtils;
import com.ibdknox.socket_io_netty.WebSocketServerHandler;
import java.util.TimerTask;

public class HeartbeatTask
extends TimerTask {
    private WebSocketServerHandler server;
    private int heartbeatNum = 0;

    public HeartbeatTask(WebSocketServerHandler server) {
        this.server = server;
    }

    public void run() {
        if (this.server.clients.isEmpty() && this.server.pollingClients.isEmpty()) {
            return;
        }
        ++this.heartbeatNum;
        String message = SocketIOUtils.encode("~h~" + this.heartbeatNum);
        for (INSIOClient iNSIOClient : this.server.clients.values()) {
            if (iNSIOClient.heartbeat(this.heartbeatNum)) {
                iNSIOClient.sendUnencoded(message);
                continue;
            }
            this.server.disconnect(iNSIOClient);
        }
        for (PollingIOClient pollingIOClient : this.server.pollingClients.values()) {
            if (pollingIOClient.heartbeat(this.heartbeatNum)) {
                pollingIOClient.sendPulse();
                continue;
            }
            this.server.disconnect(pollingIOClient);
        }
    }
}

