/*
 * Decompiled with CFR 0.152.
 */
package com.ibdknox.socket_io_netty;

import com.ibdknox.socket_io_netty.HeartbeatTask;
import com.ibdknox.socket_io_netty.INSIOClient;
import com.ibdknox.socket_io_netty.INSIOHandler;
import com.ibdknox.socket_io_netty.PollingIOClient;
import com.ibdknox.socket_io_netty.SocketIOUtils;
import com.ibdknox.socket_io_netty.WebSocketIOClient;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.codec.http.QueryStringDecoder;
import org.jboss.netty.handler.codec.http.websocket.WebSocketFrame;
import org.jboss.netty.handler.codec.http.websocket.WebSocketFrameDecoder;
import org.jboss.netty.handler.codec.http.websocket.WebSocketFrameEncoder;
import org.jboss.netty.util.CharsetUtil;

public class WebSocketServerHandler
extends SimpleChannelUpstreamHandler {
    private static final long HEARTBEAT_RATE = 10000L;
    private static final String WEBSOCKET_PATH = "/socket.io/websocket";
    private static final String POLLING_PATH = "/socket.io/xhr-polling";
    private static final String FLASHSOCKET_PATH = "/socket.io/flashsocket";
    private INSIOHandler handler;
    public ConcurrentHashMap<ChannelHandlerContext, INSIOClient> clients = new ConcurrentHashMap(20000, 0.75f, 2);
    private Timer heartbeatTimer;
    ConcurrentHashMap<String, PollingIOClient> pollingClients = new ConcurrentHashMap(20000, 0.75f, 2);

    public WebSocketServerHandler(INSIOHandler handler) {
        this.handler = handler;
        this.heartbeatTimer = new Timer();
        this.heartbeatTimer.schedule((TimerTask)new HeartbeatTask(this), 1000L, 10000L);
    }

    private String getUniqueID() {
        return UUID.randomUUID().toString();
    }

    private INSIOClient getClientByCTX(ChannelHandlerContext ctx) {
        return this.clients.get(ctx);
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        INSIOClient client = this.getClientByCTX(ctx);
        if (client != null) {
            this.disconnect(client);
        }
    }

    public void disconnect(INSIOClient client) {
        System.out.println("Disconnecting a client!");
        client.disconnect();
        if (this.clients.remove(client.getCTX()) == null) {
            this.pollingClients.remove(client.getSessionID());
        }
        this.handler.OnDisconnect(client);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        Object msg = e.getMessage();
        if (msg instanceof HttpRequest) {
            this.handleHttpRequest(ctx, (HttpRequest)msg);
        } else if (msg instanceof WebSocketFrame) {
            this.handleWebSocketFrame(ctx, (WebSocketFrame)msg);
        }
    }

    private void handleHttpRequest(ChannelHandlerContext ctx, HttpRequest req) throws Exception {
        String reqURI = req.getUri();
        if (reqURI.contains(POLLING_PATH)) {
            String[] parts = reqURI.split("/");
            String ID = parts.length > 3 ? parts[3] : "";
            PollingIOClient client = this.pollingClients.get(ID);
            if (client == null) {
                client = this.connectPoller(ctx);
                client.Reconnect(ctx, req);
                return;
            }
            if (req.getMethod() == HttpMethod.GET) {
                client.heartbeat();
                client.Reconnect(ctx, req);
            } else {
                QueryStringDecoder decoder = new QueryStringDecoder("/?" + req.getContent().toString(CharsetUtil.UTF_8));
                String message = (String)((List)decoder.getParameters().get("data")).get(0);
                System.out.println("Polling send: " + message);
                this.handleMessage(client, message);
                this.sendHttpResponse(ctx, req, (HttpResponse)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK));
            }
            return;
        }
        String location = "";
        if (reqURI.equals(WEBSOCKET_PATH)) {
            location = this.getWebSocketLocation(req);
        } else if (reqURI.equals(FLASHSOCKET_PATH)) {
            location = this.getFlashSocketLocation(req);
        }
        if (location != "" && "Upgrade".equalsIgnoreCase(req.getHeader("Connection")) && "WebSocket".equalsIgnoreCase(req.getHeader("Upgrade"))) {
            String protocol;
            DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, new HttpResponseStatus(101, "Web Socket Protocol Handshake"));
            res.addHeader("Upgrade", (Object)"WebSocket");
            res.addHeader("Connection", (Object)"Upgrade");
            if (req.containsHeader("Sec-WebSocket-Key1") && req.containsHeader("Sec-WebSocket-Key2")) {
                res.addHeader("Sec-WebSocket-Origin", (Object)req.getHeader("Origin"));
                res.addHeader("Sec-WebSocket-Location", (Object)this.getWebSocketLocation(req));
                protocol = req.getHeader("Sec-WebSocket-Protocol");
                if (protocol != null) {
                    res.addHeader("Sec-WebSocket-Protocol", (Object)protocol);
                }
                String key1 = req.getHeader("Sec-WebSocket-Key1");
                String key2 = req.getHeader("Sec-WebSocket-Key2");
                int a = (int)(Long.parseLong(key1.replaceAll("[^0-9]", "")) / (long)key1.replaceAll("[^ ]", "").length());
                int b = (int)(Long.parseLong(key2.replaceAll("[^0-9]", "")) / (long)key2.replaceAll("[^ ]", "").length());
                long c = req.getContent().readLong();
                ChannelBuffer input = ChannelBuffers.buffer((int)16);
                input.writeInt(a);
                input.writeInt(b);
                input.writeLong(c);
                ChannelBuffer output = ChannelBuffers.wrappedBuffer((byte[])MessageDigest.getInstance("MD5").digest(input.array()));
                res.setContent(output);
            } else {
                res.addHeader("WebSocket-Origin", (Object)req.getHeader("Origin"));
                res.addHeader("WebSocket-Location", (Object)this.getWebSocketLocation(req));
                protocol = req.getHeader("WebSocket-Protocol");
                if (protocol != null) {
                    res.addHeader("WebSocket-Protocol", (Object)protocol);
                }
            }
            ChannelPipeline p = ctx.getChannel().getPipeline();
            p.remove("aggregator");
            p.replace("decoder", "wsdecoder", (ChannelHandler)new WebSocketFrameDecoder());
            ctx.getChannel().write((Object)res);
            p.replace("encoder", "wsencoder", (ChannelHandler)new WebSocketFrameEncoder());
            this.connectSocket(ctx);
            return;
        }
        this.sendHttpResponse(ctx, req, (HttpResponse)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN));
    }

    private PollingIOClient connectPoller(ChannelHandlerContext ctx) {
        String uID = this.getUniqueID();
        PollingIOClient client = new PollingIOClient(ctx, uID);
        this.pollingClients.put(uID, client);
        client.send(uID);
        this.handler.OnConnect(client);
        return client;
    }

    private void connectSocket(ChannelHandlerContext ctx) {
        String uID = this.getUniqueID();
        WebSocketIOClient ws = new WebSocketIOClient(ctx, uID);
        this.clients.put(ctx, ws);
        ws.send(uID);
        this.handler.OnConnect(ws);
    }

    private void handleWebSocketFrame(ChannelHandlerContext ctx, WebSocketFrame frame) {
        INSIOClient client = this.getClientByCTX(ctx);
        this.handleMessage(client, frame.getTextData());
    }

    private void handleMessage(INSIOClient client, String message) {
        String decoded = SocketIOUtils.decode(message);
        if (decoded.substring(0, 3).equals("~h~")) {
            client.heartbeat();
        } else {
            this.handler.OnMessage(client, decoded);
        }
    }

    private void sendHttpResponse(ChannelHandlerContext ctx, HttpRequest req, HttpResponse res) {
        if (res.getStatus().getCode() != 200) {
            res.setContent(ChannelBuffers.copiedBuffer((CharSequence)res.getStatus().toString(), (Charset)CharsetUtil.UTF_8));
            HttpHeaders.setContentLength((HttpMessage)res, (long)res.getContent().readableBytes());
        }
        ChannelFuture f = ctx.getChannel().write((Object)res);
        if (!HttpHeaders.isKeepAlive((HttpMessage)req) || res.getStatus().getCode() != 200) {
            f.addListener(ChannelFutureListener.CLOSE);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        e.getCause().printStackTrace();
        e.getChannel().close();
    }

    private String getWebSocketLocation(HttpRequest req) {
        return "ws://" + req.getHeader("Host") + WEBSOCKET_PATH;
    }

    private String getFlashSocketLocation(HttpRequest req) {
        return "ws://" + req.getHeader("Host") + FLASHSOCKET_PATH;
    }
}

