/*
 * Decompiled with CFR 0.152.
 */
package com.ib.client;

import com.ib.client.ComboLeg;
import com.ib.client.CommissionReport;
import com.ib.client.Contract;
import com.ib.client.ContractDetails;
import com.ib.client.EClientErrors;
import com.ib.client.EClientSocket;
import com.ib.client.EWrapper;
import com.ib.client.Execution;
import com.ib.client.Order;
import com.ib.client.OrderComboLeg;
import com.ib.client.OrderState;
import com.ib.client.TagValue;
import com.ib.client.UnderComp;
import com.ib.client.Util;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;

public class EReader
extends Thread {
    static final int TICK_PRICE = 1;
    static final int TICK_SIZE = 2;
    static final int ORDER_STATUS = 3;
    static final int ERR_MSG = 4;
    static final int OPEN_ORDER = 5;
    static final int ACCT_VALUE = 6;
    static final int PORTFOLIO_VALUE = 7;
    static final int ACCT_UPDATE_TIME = 8;
    static final int NEXT_VALID_ID = 9;
    static final int CONTRACT_DATA = 10;
    static final int EXECUTION_DATA = 11;
    static final int MARKET_DEPTH = 12;
    static final int MARKET_DEPTH_L2 = 13;
    static final int NEWS_BULLETINS = 14;
    static final int MANAGED_ACCTS = 15;
    static final int RECEIVE_FA = 16;
    static final int HISTORICAL_DATA = 17;
    static final int BOND_CONTRACT_DATA = 18;
    static final int SCANNER_PARAMETERS = 19;
    static final int SCANNER_DATA = 20;
    static final int TICK_OPTION_COMPUTATION = 21;
    static final int TICK_GENERIC = 45;
    static final int TICK_STRING = 46;
    static final int TICK_EFP = 47;
    static final int CURRENT_TIME = 49;
    static final int REAL_TIME_BARS = 50;
    static final int FUNDAMENTAL_DATA = 51;
    static final int CONTRACT_DATA_END = 52;
    static final int OPEN_ORDER_END = 53;
    static final int ACCT_DOWNLOAD_END = 54;
    static final int EXECUTION_DATA_END = 55;
    static final int DELTA_NEUTRAL_VALIDATION = 56;
    static final int TICK_SNAPSHOT_END = 57;
    static final int MARKET_DATA_TYPE = 58;
    static final int COMMISSION_REPORT = 59;
    private EClientSocket m_parent;
    private DataInputStream m_dis;

    protected EClientSocket parent() {
        return this.m_parent;
    }

    private EWrapper eWrapper() {
        return (EWrapper)this.parent().wrapper();
    }

    public EReader(EClientSocket eClientSocket, DataInputStream dataInputStream) {
        this("EReader", eClientSocket, dataInputStream);
    }

    protected EReader(String string, EClientSocket eClientSocket, DataInputStream dataInputStream) {
        this.setName(string);
        this.m_parent = eClientSocket;
        this.m_dis = dataInputStream;
    }

    public void run() {
        block4: {
            try {
                while (!this.isInterrupted() && this.processMsg(this.readInt())) {
                }
            }
            catch (Exception exception) {
                if (!this.parent().isConnected()) break block4;
                this.eWrapper().error(exception);
            }
        }
        if (this.parent().isConnected()) {
            this.m_parent.close();
        }
    }

    protected boolean processMsg(int n) throws IOException {
        if (n == -1) {
            return false;
        }
        switch (n) {
            case 1: {
                int n2 = this.readInt();
                int n3 = this.readInt();
                int n4 = this.readInt();
                double d = this.readDouble();
                int n5 = 0;
                if (n2 >= 2) {
                    n5 = this.readInt();
                }
                int n6 = 0;
                if (n2 >= 3) {
                    n6 = this.readInt();
                }
                this.eWrapper().tickPrice(n3, n4, d, n6);
                if (n2 < 2) break;
                int n7 = -1;
                switch (n4) {
                    case 1: {
                        n7 = 0;
                        break;
                    }
                    case 2: {
                        n7 = 3;
                        break;
                    }
                    case 4: {
                        n7 = 5;
                    }
                }
                if (n7 == -1) break;
                this.eWrapper().tickSize(n3, n7, n5);
                break;
            }
            case 2: {
                int n8 = this.readInt();
                int n9 = this.readInt();
                int n10 = this.readInt();
                int n11 = this.readInt();
                this.eWrapper().tickSize(n9, n10, n11);
                break;
            }
            case 21: {
                double d;
                int n12 = this.readInt();
                int n13 = this.readInt();
                int n14 = this.readInt();
                double d2 = this.readDouble();
                if (d2 < 0.0) {
                    d2 = Double.MAX_VALUE;
                }
                if (Math.abs(d = this.readDouble()) > 1.0) {
                    d = Double.MAX_VALUE;
                }
                double d3 = Double.MAX_VALUE;
                double d4 = Double.MAX_VALUE;
                double d5 = Double.MAX_VALUE;
                double d6 = Double.MAX_VALUE;
                double d7 = Double.MAX_VALUE;
                double d8 = Double.MAX_VALUE;
                if (n12 >= 6 || n14 == 13) {
                    d3 = this.readDouble();
                    if (d3 < 0.0) {
                        d3 = Double.MAX_VALUE;
                    }
                    if ((d4 = this.readDouble()) < 0.0) {
                        d4 = Double.MAX_VALUE;
                    }
                }
                if (n12 >= 6) {
                    d5 = this.readDouble();
                    if (Math.abs(d5) > 1.0) {
                        d5 = Double.MAX_VALUE;
                    }
                    if (Math.abs(d6 = this.readDouble()) > 1.0) {
                        d6 = Double.MAX_VALUE;
                    }
                    if (Math.abs(d7 = this.readDouble()) > 1.0) {
                        d7 = Double.MAX_VALUE;
                    }
                    if ((d8 = this.readDouble()) < 0.0) {
                        d8 = Double.MAX_VALUE;
                    }
                }
                this.eWrapper().tickOptionComputation(n13, n14, d2, d, d3, d4, d5, d6, d7, d8);
                break;
            }
            case 45: {
                int n15 = this.readInt();
                int n16 = this.readInt();
                int n17 = this.readInt();
                double d = this.readDouble();
                this.eWrapper().tickGeneric(n16, n17, d);
                break;
            }
            case 46: {
                int n18 = this.readInt();
                int n19 = this.readInt();
                int n20 = this.readInt();
                String string = this.readStr();
                this.eWrapper().tickString(n19, n20, string);
                break;
            }
            case 47: {
                int n21 = this.readInt();
                int n22 = this.readInt();
                int n23 = this.readInt();
                double d = this.readDouble();
                String string = this.readStr();
                double d9 = this.readDouble();
                int n24 = this.readInt();
                String string2 = this.readStr();
                double d10 = this.readDouble();
                double d11 = this.readDouble();
                this.eWrapper().tickEFP(n22, n23, d, string, d9, n24, string2, d10, d11);
                break;
            }
            case 3: {
                int n25 = this.readInt();
                int n26 = this.readInt();
                String string = this.readStr();
                int n27 = this.readInt();
                int n28 = this.readInt();
                double d = this.readDouble();
                int n29 = 0;
                if (n25 >= 2) {
                    n29 = this.readInt();
                }
                int n30 = 0;
                if (n25 >= 3) {
                    n30 = this.readInt();
                }
                double d12 = 0.0;
                if (n25 >= 4) {
                    d12 = this.readDouble();
                }
                int n31 = 0;
                if (n25 >= 5) {
                    n31 = this.readInt();
                }
                String string3 = null;
                if (n25 >= 6) {
                    string3 = this.readStr();
                }
                this.eWrapper().orderStatus(n26, string, n27, n28, d, n29, n30, d12, n31, string3);
                break;
            }
            case 6: {
                int n32 = this.readInt();
                String string = this.readStr();
                String string4 = this.readStr();
                String string5 = this.readStr();
                String string6 = null;
                if (n32 >= 2) {
                    string6 = this.readStr();
                }
                this.eWrapper().updateAccountValue(string, string4, string5, string6);
                break;
            }
            case 7: {
                int n33 = this.readInt();
                Contract contract = new Contract();
                if (n33 >= 6) {
                    contract.m_conId = this.readInt();
                }
                contract.m_symbol = this.readStr();
                contract.m_secType = this.readStr();
                contract.m_expiry = this.readStr();
                contract.m_strike = this.readDouble();
                contract.m_right = this.readStr();
                if (n33 >= 7) {
                    contract.m_multiplier = this.readStr();
                    contract.m_primaryExch = this.readStr();
                }
                contract.m_currency = this.readStr();
                if (n33 >= 2) {
                    contract.m_localSymbol = this.readStr();
                }
                int n34 = this.readInt();
                double d = this.readDouble();
                double d13 = this.readDouble();
                double d14 = 0.0;
                double d15 = 0.0;
                double d16 = 0.0;
                if (n33 >= 3) {
                    d14 = this.readDouble();
                    d15 = this.readDouble();
                    d16 = this.readDouble();
                }
                String string = null;
                if (n33 >= 4) {
                    string = this.readStr();
                }
                if (n33 == 6 && this.m_parent.serverVersion() == 39) {
                    contract.m_primaryExch = this.readStr();
                }
                this.eWrapper().updatePortfolio(contract, n34, d, d13, d14, d15, d16, string);
                break;
            }
            case 8: {
                int n35 = this.readInt();
                String string = this.readStr();
                this.eWrapper().updateAccountTime(string);
                break;
            }
            case 4: {
                int n36 = this.readInt();
                if (n36 < 2) {
                    String string = this.readStr();
                    this.m_parent.error(string);
                    break;
                }
                int n37 = this.readInt();
                int n38 = this.readInt();
                String string = this.readStr();
                this.m_parent.error(n37, n38, string);
                break;
            }
            case 5: {
                int n39;
                int n40;
                int n41 = this.readInt();
                Order order = new Order();
                order.m_orderId = this.readInt();
                Contract contract = new Contract();
                if (n41 >= 17) {
                    contract.m_conId = this.readInt();
                }
                contract.m_symbol = this.readStr();
                contract.m_secType = this.readStr();
                contract.m_expiry = this.readStr();
                contract.m_strike = this.readDouble();
                contract.m_right = this.readStr();
                contract.m_exchange = this.readStr();
                contract.m_currency = this.readStr();
                if (n41 >= 2) {
                    contract.m_localSymbol = this.readStr();
                }
                order.m_action = this.readStr();
                order.m_totalQuantity = this.readInt();
                order.m_orderType = this.readStr();
                order.m_lmtPrice = n41 < 29 ? this.readDouble() : this.readDoubleMax();
                order.m_auxPrice = n41 < 30 ? this.readDouble() : this.readDoubleMax();
                order.m_tif = this.readStr();
                order.m_ocaGroup = this.readStr();
                order.m_account = this.readStr();
                order.m_openClose = this.readStr();
                order.m_origin = this.readInt();
                order.m_orderRef = this.readStr();
                if (n41 >= 3) {
                    order.m_clientId = this.readInt();
                }
                if (n41 >= 4) {
                    order.m_permId = this.readInt();
                    if (n41 < 18) {
                        this.readBoolFromInt();
                    } else {
                        order.m_outsideRth = this.readBoolFromInt();
                    }
                    order.m_hidden = this.readInt() == 1;
                    order.m_discretionaryAmt = this.readDouble();
                }
                if (n41 >= 5) {
                    order.m_goodAfterTime = this.readStr();
                }
                if (n41 >= 6) {
                    this.readStr();
                }
                if (n41 >= 7) {
                    order.m_faGroup = this.readStr();
                    order.m_faMethod = this.readStr();
                    order.m_faPercentage = this.readStr();
                    order.m_faProfile = this.readStr();
                }
                if (n41 >= 8) {
                    order.m_goodTillDate = this.readStr();
                }
                if (n41 >= 9) {
                    order.m_rule80A = this.readStr();
                    order.m_percentOffset = this.readDoubleMax();
                    order.m_settlingFirm = this.readStr();
                    order.m_shortSaleSlot = this.readInt();
                    order.m_designatedLocation = this.readStr();
                    if (this.m_parent.serverVersion() == 51) {
                        this.readInt();
                    } else if (n41 >= 23) {
                        order.m_exemptCode = this.readInt();
                    }
                    order.m_auctionStrategy = this.readInt();
                    order.m_startingPrice = this.readDoubleMax();
                    order.m_stockRefPrice = this.readDoubleMax();
                    order.m_delta = this.readDoubleMax();
                    order.m_stockRangeLower = this.readDoubleMax();
                    order.m_stockRangeUpper = this.readDoubleMax();
                    order.m_displaySize = this.readInt();
                    if (n41 < 18) {
                        this.readBoolFromInt();
                    }
                    order.m_blockOrder = this.readBoolFromInt();
                    order.m_sweepToFill = this.readBoolFromInt();
                    order.m_allOrNone = this.readBoolFromInt();
                    order.m_minQty = this.readIntMax();
                    order.m_ocaType = this.readInt();
                    order.m_eTradeOnly = this.readBoolFromInt();
                    order.m_firmQuoteOnly = this.readBoolFromInt();
                    order.m_nbboPriceCap = this.readDoubleMax();
                }
                if (n41 >= 10) {
                    order.m_parentId = this.readInt();
                    order.m_triggerMethod = this.readInt();
                }
                if (n41 >= 11) {
                    order.m_volatility = this.readDoubleMax();
                    order.m_volatilityType = this.readInt();
                    if (n41 == 11) {
                        n40 = this.readInt();
                        order.m_deltaNeutralOrderType = n40 == 0 ? "NONE" : "MKT";
                    } else {
                        order.m_deltaNeutralOrderType = this.readStr();
                        order.m_deltaNeutralAuxPrice = this.readDoubleMax();
                        if (n41 >= 27 && !Util.StringIsEmpty(order.m_deltaNeutralOrderType)) {
                            order.m_deltaNeutralConId = this.readInt();
                            order.m_deltaNeutralSettlingFirm = this.readStr();
                            order.m_deltaNeutralClearingAccount = this.readStr();
                            order.m_deltaNeutralClearingIntent = this.readStr();
                        }
                        if (n41 >= 31 && !Util.StringIsEmpty(order.m_deltaNeutralOrderType)) {
                            order.m_deltaNeutralOpenClose = this.readStr();
                            order.m_deltaNeutralShortSale = this.readBoolFromInt();
                            order.m_deltaNeutralShortSaleSlot = this.readInt();
                            order.m_deltaNeutralDesignatedLocation = this.readStr();
                        }
                    }
                    order.m_continuousUpdate = this.readInt();
                    if (this.m_parent.serverVersion() == 26) {
                        order.m_stockRangeLower = this.readDouble();
                        order.m_stockRangeUpper = this.readDouble();
                    }
                    order.m_referencePriceType = this.readInt();
                }
                if (n41 >= 13) {
                    order.m_trailStopPrice = this.readDoubleMax();
                }
                if (n41 >= 30) {
                    order.m_trailingPercent = this.readDoubleMax();
                }
                if (n41 >= 14) {
                    order.m_basisPoints = this.readDoubleMax();
                    order.m_basisPointsType = this.readIntMax();
                    contract.m_comboLegsDescrip = this.readStr();
                }
                if (n41 >= 29) {
                    Object object;
                    int n42;
                    n40 = this.readInt();
                    if (n40 > 0) {
                        contract.m_comboLegs = new Vector(n40);
                        for (n39 = 0; n39 < n40; ++n39) {
                            n42 = this.readInt();
                            int n43 = this.readInt();
                            String string = this.readStr();
                            object = this.readStr();
                            int n44 = this.readInt();
                            int n45 = this.readInt();
                            String string7 = this.readStr();
                            int n46 = this.readInt();
                            ComboLeg comboLeg = new ComboLeg(n42, n43, string, (String)object, n44, n45, string7, n46);
                            contract.m_comboLegs.add(comboLeg);
                        }
                    }
                    if ((n39 = this.readInt()) > 0) {
                        order.m_orderComboLegs = new Vector(n39);
                        for (n42 = 0; n42 < n39; ++n42) {
                            double d = this.readDoubleMax();
                            object = new OrderComboLeg(d);
                            order.m_orderComboLegs.add((OrderComboLeg)object);
                        }
                    }
                }
                if (n41 >= 26 && (n40 = this.readInt()) > 0) {
                    order.m_smartComboRoutingParams = new Vector(n40);
                    for (n39 = 0; n39 < n40; ++n39) {
                        TagValue tagValue = new TagValue();
                        tagValue.m_tag = this.readStr();
                        tagValue.m_value = this.readStr();
                        order.m_smartComboRoutingParams.add(tagValue);
                    }
                }
                if (n41 >= 15) {
                    if (n41 >= 20) {
                        order.m_scaleInitLevelSize = this.readIntMax();
                        order.m_scaleSubsLevelSize = this.readIntMax();
                    } else {
                        this.readIntMax();
                        order.m_scaleInitLevelSize = this.readIntMax();
                    }
                    order.m_scalePriceIncrement = this.readDoubleMax();
                }
                if (n41 >= 28 && order.m_scalePriceIncrement > 0.0 && order.m_scalePriceIncrement != Double.MAX_VALUE) {
                    order.m_scalePriceAdjustValue = this.readDoubleMax();
                    order.m_scalePriceAdjustInterval = this.readIntMax();
                    order.m_scaleProfitOffset = this.readDoubleMax();
                    order.m_scaleAutoReset = this.readBoolFromInt();
                    order.m_scaleInitPosition = this.readIntMax();
                    order.m_scaleInitFillQty = this.readIntMax();
                    order.m_scaleRandomPercent = this.readBoolFromInt();
                }
                if (n41 >= 24) {
                    order.m_hedgeType = this.readStr();
                    if (!Util.StringIsEmpty(order.m_hedgeType)) {
                        order.m_hedgeParam = this.readStr();
                    }
                }
                if (n41 >= 25) {
                    order.m_optOutSmartRouting = this.readBoolFromInt();
                }
                if (n41 >= 19) {
                    order.m_clearingAccount = this.readStr();
                    order.m_clearingIntent = this.readStr();
                }
                if (n41 >= 22) {
                    order.m_notHeld = this.readBoolFromInt();
                }
                if (n41 >= 20 && this.readBoolFromInt()) {
                    UnderComp underComp = new UnderComp();
                    underComp.m_conId = this.readInt();
                    underComp.m_delta = this.readDouble();
                    underComp.m_price = this.readDouble();
                    contract.m_underComp = underComp;
                }
                if (n41 >= 21) {
                    int n47;
                    order.m_algoStrategy = this.readStr();
                    if (!Util.StringIsEmpty(order.m_algoStrategy) && (n47 = this.readInt()) > 0) {
                        order.m_algoParams = new Vector(n47);
                        for (n39 = 0; n39 < n47; ++n39) {
                            TagValue tagValue = new TagValue();
                            tagValue.m_tag = this.readStr();
                            tagValue.m_value = this.readStr();
                            order.m_algoParams.add(tagValue);
                        }
                    }
                }
                OrderState orderState = new OrderState();
                if (n41 >= 16) {
                    order.m_whatIf = this.readBoolFromInt();
                    orderState.m_status = this.readStr();
                    orderState.m_initMargin = this.readStr();
                    orderState.m_maintMargin = this.readStr();
                    orderState.m_equityWithLoan = this.readStr();
                    orderState.m_commission = this.readDoubleMax();
                    orderState.m_minCommission = this.readDoubleMax();
                    orderState.m_maxCommission = this.readDoubleMax();
                    orderState.m_commissionCurrency = this.readStr();
                    orderState.m_warningText = this.readStr();
                }
                this.eWrapper().openOrder(order.m_orderId, contract, order, orderState);
                break;
            }
            case 9: {
                int n48 = this.readInt();
                int n49 = this.readInt();
                this.eWrapper().nextValidId(n49);
                break;
            }
            case 20: {
                ContractDetails contractDetails = new ContractDetails();
                int n50 = this.readInt();
                int n51 = this.readInt();
                int n52 = this.readInt();
                for (int i = 0; i < n52; ++i) {
                    int n53 = this.readInt();
                    if (n50 >= 3) {
                        contractDetails.m_summary.m_conId = this.readInt();
                    }
                    contractDetails.m_summary.m_symbol = this.readStr();
                    contractDetails.m_summary.m_secType = this.readStr();
                    contractDetails.m_summary.m_expiry = this.readStr();
                    contractDetails.m_summary.m_strike = this.readDouble();
                    contractDetails.m_summary.m_right = this.readStr();
                    contractDetails.m_summary.m_exchange = this.readStr();
                    contractDetails.m_summary.m_currency = this.readStr();
                    contractDetails.m_summary.m_localSymbol = this.readStr();
                    contractDetails.m_marketName = this.readStr();
                    contractDetails.m_tradingClass = this.readStr();
                    String string = this.readStr();
                    String string8 = this.readStr();
                    String string9 = this.readStr();
                    String string10 = null;
                    if (n50 >= 2) {
                        string10 = this.readStr();
                    }
                    this.eWrapper().scannerData(n51, n53, contractDetails, string, string8, string9, string10);
                }
                this.eWrapper().scannerDataEnd(n51);
                break;
            }
            case 10: {
                int n54;
                int n55 = this.readInt();
                int n56 = -1;
                if (n55 >= 3) {
                    n56 = this.readInt();
                }
                ContractDetails contractDetails = new ContractDetails();
                contractDetails.m_summary.m_symbol = this.readStr();
                contractDetails.m_summary.m_secType = this.readStr();
                contractDetails.m_summary.m_expiry = this.readStr();
                contractDetails.m_summary.m_strike = this.readDouble();
                contractDetails.m_summary.m_right = this.readStr();
                contractDetails.m_summary.m_exchange = this.readStr();
                contractDetails.m_summary.m_currency = this.readStr();
                contractDetails.m_summary.m_localSymbol = this.readStr();
                contractDetails.m_marketName = this.readStr();
                contractDetails.m_tradingClass = this.readStr();
                contractDetails.m_summary.m_conId = this.readInt();
                contractDetails.m_minTick = this.readDouble();
                contractDetails.m_summary.m_multiplier = this.readStr();
                contractDetails.m_orderTypes = this.readStr();
                contractDetails.m_validExchanges = this.readStr();
                if (n55 >= 2) {
                    contractDetails.m_priceMagnifier = this.readInt();
                }
                if (n55 >= 4) {
                    contractDetails.m_underConId = this.readInt();
                }
                if (n55 >= 5) {
                    contractDetails.m_longName = this.readStr();
                    contractDetails.m_summary.m_primaryExch = this.readStr();
                }
                if (n55 >= 6) {
                    contractDetails.m_contractMonth = this.readStr();
                    contractDetails.m_industry = this.readStr();
                    contractDetails.m_category = this.readStr();
                    contractDetails.m_subcategory = this.readStr();
                    contractDetails.m_timeZoneId = this.readStr();
                    contractDetails.m_tradingHours = this.readStr();
                    contractDetails.m_liquidHours = this.readStr();
                }
                if (n55 >= 8) {
                    contractDetails.m_evRule = this.readStr();
                    contractDetails.m_evMultiplier = this.readDouble();
                }
                if (n55 >= 7 && (n54 = this.readInt()) > 0) {
                    contractDetails.m_secIdList = new Vector(n54);
                    for (int i = 0; i < n54; ++i) {
                        TagValue tagValue = new TagValue();
                        tagValue.m_tag = this.readStr();
                        tagValue.m_value = this.readStr();
                        contractDetails.m_secIdList.add(tagValue);
                    }
                }
                this.eWrapper().contractDetails(n56, contractDetails);
                break;
            }
            case 18: {
                int n57;
                int n58 = this.readInt();
                int n59 = -1;
                if (n58 >= 3) {
                    n59 = this.readInt();
                }
                ContractDetails contractDetails = new ContractDetails();
                contractDetails.m_summary.m_symbol = this.readStr();
                contractDetails.m_summary.m_secType = this.readStr();
                contractDetails.m_cusip = this.readStr();
                contractDetails.m_coupon = this.readDouble();
                contractDetails.m_maturity = this.readStr();
                contractDetails.m_issueDate = this.readStr();
                contractDetails.m_ratings = this.readStr();
                contractDetails.m_bondType = this.readStr();
                contractDetails.m_couponType = this.readStr();
                contractDetails.m_convertible = this.readBoolFromInt();
                contractDetails.m_callable = this.readBoolFromInt();
                contractDetails.m_putable = this.readBoolFromInt();
                contractDetails.m_descAppend = this.readStr();
                contractDetails.m_summary.m_exchange = this.readStr();
                contractDetails.m_summary.m_currency = this.readStr();
                contractDetails.m_marketName = this.readStr();
                contractDetails.m_tradingClass = this.readStr();
                contractDetails.m_summary.m_conId = this.readInt();
                contractDetails.m_minTick = this.readDouble();
                contractDetails.m_orderTypes = this.readStr();
                contractDetails.m_validExchanges = this.readStr();
                if (n58 >= 2) {
                    contractDetails.m_nextOptionDate = this.readStr();
                    contractDetails.m_nextOptionType = this.readStr();
                    contractDetails.m_nextOptionPartial = this.readBoolFromInt();
                    contractDetails.m_notes = this.readStr();
                }
                if (n58 >= 4) {
                    contractDetails.m_longName = this.readStr();
                }
                if (n58 >= 6) {
                    contractDetails.m_evRule = this.readStr();
                    contractDetails.m_evMultiplier = this.readDouble();
                }
                if (n58 >= 5 && (n57 = this.readInt()) > 0) {
                    contractDetails.m_secIdList = new Vector(n57);
                    for (int i = 0; i < n57; ++i) {
                        TagValue tagValue = new TagValue();
                        tagValue.m_tag = this.readStr();
                        tagValue.m_value = this.readStr();
                        contractDetails.m_secIdList.add(tagValue);
                    }
                }
                this.eWrapper().bondContractDetails(n59, contractDetails);
                break;
            }
            case 11: {
                int n60 = this.readInt();
                int n61 = -1;
                if (n60 >= 7) {
                    n61 = this.readInt();
                }
                int n62 = this.readInt();
                Contract contract = new Contract();
                if (n60 >= 5) {
                    contract.m_conId = this.readInt();
                }
                contract.m_symbol = this.readStr();
                contract.m_secType = this.readStr();
                contract.m_expiry = this.readStr();
                contract.m_strike = this.readDouble();
                contract.m_right = this.readStr();
                if (n60 >= 9) {
                    contract.m_multiplier = this.readStr();
                }
                contract.m_exchange = this.readStr();
                contract.m_currency = this.readStr();
                contract.m_localSymbol = this.readStr();
                Execution execution = new Execution();
                execution.m_orderId = n62;
                execution.m_execId = this.readStr();
                execution.m_time = this.readStr();
                execution.m_acctNumber = this.readStr();
                execution.m_exchange = this.readStr();
                execution.m_side = this.readStr();
                execution.m_shares = this.readInt();
                execution.m_price = this.readDouble();
                if (n60 >= 2) {
                    execution.m_permId = this.readInt();
                }
                if (n60 >= 3) {
                    execution.m_clientId = this.readInt();
                }
                if (n60 >= 4) {
                    execution.m_liquidation = this.readInt();
                }
                if (n60 >= 6) {
                    execution.m_cumQty = this.readInt();
                    execution.m_avgPrice = this.readDouble();
                }
                if (n60 >= 8) {
                    execution.m_orderRef = this.readStr();
                }
                if (n60 >= 9) {
                    execution.m_evRule = this.readStr();
                    execution.m_evMultiplier = this.readDouble();
                }
                this.eWrapper().execDetails(n61, contract, execution);
                break;
            }
            case 12: {
                int n63 = this.readInt();
                int n64 = this.readInt();
                int n65 = this.readInt();
                int n66 = this.readInt();
                int n67 = this.readInt();
                double d = this.readDouble();
                int n68 = this.readInt();
                this.eWrapper().updateMktDepth(n64, n65, n66, n67, d, n68);
                break;
            }
            case 13: {
                int n69 = this.readInt();
                int n70 = this.readInt();
                int n71 = this.readInt();
                String string = this.readStr();
                int n72 = this.readInt();
                int n73 = this.readInt();
                double d = this.readDouble();
                int n74 = this.readInt();
                this.eWrapper().updateMktDepthL2(n70, n71, string, n72, n73, d, n74);
                break;
            }
            case 14: {
                int n75 = this.readInt();
                int n76 = this.readInt();
                int n77 = this.readInt();
                String string = this.readStr();
                String string11 = this.readStr();
                this.eWrapper().updateNewsBulletin(n76, n77, string, string11);
                break;
            }
            case 15: {
                int n78 = this.readInt();
                String string = this.readStr();
                this.eWrapper().managedAccounts(string);
                break;
            }
            case 16: {
                int n79 = this.readInt();
                int n80 = this.readInt();
                String string = this.readStr();
                this.eWrapper().receiveFA(n80, string);
                break;
            }
            case 17: {
                int n81 = this.readInt();
                int n82 = this.readInt();
                String string = "finished";
                if (n81 >= 2) {
                    String string12 = this.readStr();
                    String string13 = this.readStr();
                    string = string + "-" + string12 + "-" + string13;
                }
                int n83 = this.readInt();
                for (int i = 0; i < n83; ++i) {
                    String string14 = this.readStr();
                    double d = this.readDouble();
                    double d17 = this.readDouble();
                    double d18 = this.readDouble();
                    double d19 = this.readDouble();
                    int n84 = this.readInt();
                    double d20 = this.readDouble();
                    String string15 = this.readStr();
                    int n85 = -1;
                    if (n81 >= 3) {
                        n85 = this.readInt();
                    }
                    this.eWrapper().historicalData(n82, string14, d, d17, d18, d19, n84, n85, d20, Boolean.valueOf(string15));
                }
                this.eWrapper().historicalData(n82, string, -1.0, -1.0, -1.0, -1.0, -1, -1, -1.0, false);
                break;
            }
            case 19: {
                int n86 = this.readInt();
                String string = this.readStr();
                this.eWrapper().scannerParameters(string);
                break;
            }
            case 49: {
                this.readInt();
                long l = this.readLong();
                this.eWrapper().currentTime(l);
                break;
            }
            case 50: {
                this.readInt();
                int n87 = this.readInt();
                long l = this.readLong();
                double d = this.readDouble();
                double d21 = this.readDouble();
                double d22 = this.readDouble();
                double d23 = this.readDouble();
                long l2 = this.readLong();
                double d24 = this.readDouble();
                int n88 = this.readInt();
                this.eWrapper().realtimeBar(n87, l, d, d21, d22, d23, l2, d24, n88);
                break;
            }
            case 51: {
                this.readInt();
                int n89 = this.readInt();
                String string = this.readStr();
                this.eWrapper().fundamentalData(n89, string);
                break;
            }
            case 52: {
                this.readInt();
                int n90 = this.readInt();
                this.eWrapper().contractDetailsEnd(n90);
                break;
            }
            case 53: {
                this.readInt();
                this.eWrapper().openOrderEnd();
                break;
            }
            case 54: {
                this.readInt();
                String string = this.readStr();
                this.eWrapper().accountDownloadEnd(string);
                break;
            }
            case 55: {
                this.readInt();
                int n91 = this.readInt();
                this.eWrapper().execDetailsEnd(n91);
                break;
            }
            case 56: {
                this.readInt();
                int n92 = this.readInt();
                UnderComp underComp = new UnderComp();
                underComp.m_conId = this.readInt();
                underComp.m_delta = this.readDouble();
                underComp.m_price = this.readDouble();
                this.eWrapper().deltaNeutralValidation(n92, underComp);
                break;
            }
            case 57: {
                this.readInt();
                int n93 = this.readInt();
                this.eWrapper().tickSnapshotEnd(n93);
                break;
            }
            case 58: {
                this.readInt();
                int n94 = this.readInt();
                int n95 = this.readInt();
                this.eWrapper().marketDataType(n94, n95);
                break;
            }
            case 59: {
                this.readInt();
                CommissionReport commissionReport = new CommissionReport();
                commissionReport.m_execId = this.readStr();
                commissionReport.m_commission = this.readDouble();
                commissionReport.m_currency = this.readStr();
                commissionReport.m_realizedPNL = this.readDouble();
                commissionReport.m_yield = this.readDouble();
                commissionReport.m_yieldRedemptionDate = this.readInt();
                this.eWrapper().commissionReport(commissionReport);
                break;
            }
            default: {
                this.m_parent.error(-1, EClientErrors.UNKNOWN_ID.code(), EClientErrors.UNKNOWN_ID.msg());
                return false;
            }
        }
        return true;
    }

    protected String readStr() throws IOException {
        byte by;
        StringBuffer stringBuffer = new StringBuffer();
        while ((by = this.m_dis.readByte()) != 0) {
            stringBuffer.append((char)by);
        }
        String string = stringBuffer.toString();
        return string.length() == 0 ? null : string;
    }

    boolean readBoolFromInt() throws IOException {
        String string = this.readStr();
        return string == null ? false : Integer.parseInt(string) != 0;
    }

    protected int readInt() throws IOException {
        String string = this.readStr();
        return string == null ? 0 : Integer.parseInt(string);
    }

    protected int readIntMax() throws IOException {
        String string = this.readStr();
        return string == null || string.length() == 0 ? Integer.MAX_VALUE : Integer.parseInt(string);
    }

    protected long readLong() throws IOException {
        String string = this.readStr();
        return string == null ? 0L : Long.parseLong(string);
    }

    protected double readDouble() throws IOException {
        String string = this.readStr();
        return string == null ? 0.0 : Double.parseDouble(string);
    }

    protected double readDoubleMax() throws IOException {
        String string = this.readStr();
        return string == null || string.length() == 0 ? Double.MAX_VALUE : Double.parseDouble(string);
    }
}

