/*
 * Decompiled with CFR 0.152.
 */
package com.ib.client;

import com.ib.client.AnyWrapper;
import com.ib.client.ComboLeg;
import com.ib.client.Contract;
import com.ib.client.EClientErrors;
import com.ib.client.EReader;
import com.ib.client.ExecutionFilter;
import com.ib.client.Order;
import com.ib.client.OrderComboLeg;
import com.ib.client.ScannerSubscription;
import com.ib.client.TagValue;
import com.ib.client.UnderComp;
import com.ib.client.Util;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Vector;

public class EClientSocket {
    private static final int CLIENT_VERSION = 60;
    private static final int SERVER_VERSION = 38;
    private static final byte[] EOL = new byte[]{0};
    private static final String BAG_SEC_TYPE = "BAG";
    public static final int GROUPS = 1;
    public static final int PROFILES = 2;
    public static final int ALIASES = 3;
    private static final int REQ_MKT_DATA = 1;
    private static final int CANCEL_MKT_DATA = 2;
    private static final int PLACE_ORDER = 3;
    private static final int CANCEL_ORDER = 4;
    private static final int REQ_OPEN_ORDERS = 5;
    private static final int REQ_ACCOUNT_DATA = 6;
    private static final int REQ_EXECUTIONS = 7;
    private static final int REQ_IDS = 8;
    private static final int REQ_CONTRACT_DATA = 9;
    private static final int REQ_MKT_DEPTH = 10;
    private static final int CANCEL_MKT_DEPTH = 11;
    private static final int REQ_NEWS_BULLETINS = 12;
    private static final int CANCEL_NEWS_BULLETINS = 13;
    private static final int SET_SERVER_LOGLEVEL = 14;
    private static final int REQ_AUTO_OPEN_ORDERS = 15;
    private static final int REQ_ALL_OPEN_ORDERS = 16;
    private static final int REQ_MANAGED_ACCTS = 17;
    private static final int REQ_FA = 18;
    private static final int REPLACE_FA = 19;
    private static final int REQ_HISTORICAL_DATA = 20;
    private static final int EXERCISE_OPTIONS = 21;
    private static final int REQ_SCANNER_SUBSCRIPTION = 22;
    private static final int CANCEL_SCANNER_SUBSCRIPTION = 23;
    private static final int REQ_SCANNER_PARAMETERS = 24;
    private static final int CANCEL_HISTORICAL_DATA = 25;
    private static final int REQ_CURRENT_TIME = 49;
    private static final int REQ_REAL_TIME_BARS = 50;
    private static final int CANCEL_REAL_TIME_BARS = 51;
    private static final int REQ_FUNDAMENTAL_DATA = 52;
    private static final int CANCEL_FUNDAMENTAL_DATA = 53;
    private static final int REQ_CALC_IMPLIED_VOLAT = 54;
    private static final int REQ_CALC_OPTION_PRICE = 55;
    private static final int CANCEL_CALC_IMPLIED_VOLAT = 56;
    private static final int CANCEL_CALC_OPTION_PRICE = 57;
    private static final int REQ_GLOBAL_CANCEL = 58;
    private static final int REQ_MARKET_DATA_TYPE = 59;
    private static final int MIN_SERVER_VER_REAL_TIME_BARS = 34;
    private static final int MIN_SERVER_VER_SCALE_ORDERS = 35;
    private static final int MIN_SERVER_VER_SNAPSHOT_MKT_DATA = 35;
    private static final int MIN_SERVER_VER_SSHORT_COMBO_LEGS = 35;
    private static final int MIN_SERVER_VER_WHAT_IF_ORDERS = 36;
    private static final int MIN_SERVER_VER_CONTRACT_CONID = 37;
    private static final int MIN_SERVER_VER_PTA_ORDERS = 39;
    private static final int MIN_SERVER_VER_FUNDAMENTAL_DATA = 40;
    private static final int MIN_SERVER_VER_UNDER_COMP = 40;
    private static final int MIN_SERVER_VER_CONTRACT_DATA_CHAIN = 40;
    private static final int MIN_SERVER_VER_SCALE_ORDERS2 = 40;
    private static final int MIN_SERVER_VER_ALGO_ORDERS = 41;
    private static final int MIN_SERVER_VER_EXECUTION_DATA_CHAIN = 42;
    private static final int MIN_SERVER_VER_NOT_HELD = 44;
    private static final int MIN_SERVER_VER_SEC_ID_TYPE = 45;
    private static final int MIN_SERVER_VER_PLACE_ORDER_CONID = 46;
    private static final int MIN_SERVER_VER_REQ_MKT_DATA_CONID = 47;
    private static final int MIN_SERVER_VER_REQ_CALC_IMPLIED_VOLAT = 49;
    private static final int MIN_SERVER_VER_REQ_CALC_OPTION_PRICE = 50;
    private static final int MIN_SERVER_VER_CANCEL_CALC_IMPLIED_VOLAT = 50;
    private static final int MIN_SERVER_VER_CANCEL_CALC_OPTION_PRICE = 50;
    private static final int MIN_SERVER_VER_SSHORTX_OLD = 51;
    private static final int MIN_SERVER_VER_SSHORTX = 52;
    private static final int MIN_SERVER_VER_REQ_GLOBAL_CANCEL = 53;
    private static final int MIN_SERVER_VER_HEDGE_ORDERS = 54;
    private static final int MIN_SERVER_VER_REQ_MARKET_DATA_TYPE = 55;
    private static final int MIN_SERVER_VER_OPT_OUT_SMART_ROUTING = 56;
    private static final int MIN_SERVER_VER_SMART_COMBO_ROUTING_PARAMS = 57;
    private static final int MIN_SERVER_VER_DELTA_NEUTRAL_CONID = 58;
    private static final int MIN_SERVER_VER_SCALE_ORDERS3 = 60;
    private static final int MIN_SERVER_VER_ORDER_COMBO_LEGS_PRICE = 61;
    private static final int MIN_SERVER_VER_TRAILING_PERCENT = 62;
    private static final int MIN_SERVER_VER_DELTA_NEUTRAL_OPEN_CLOSE = 66;
    private AnyWrapper m_anyWrapper;
    private DataOutputStream m_dos;
    private boolean m_connected;
    private EReader m_reader;
    private int m_serverVersion = 0;
    private String m_TwsTime;

    public static String faMsgTypeName(int n) {
        switch (n) {
            case 1: {
                return "GROUPS";
            }
            case 2: {
                return "PROFILES";
            }
            case 3: {
                return "ALIASES";
            }
        }
        return null;
    }

    public int serverVersion() {
        return this.m_serverVersion;
    }

    public String TwsConnectionTime() {
        return this.m_TwsTime;
    }

    public AnyWrapper wrapper() {
        return this.m_anyWrapper;
    }

    public EReader reader() {
        return this.m_reader;
    }

    public EClientSocket(AnyWrapper anyWrapper) {
        this.m_anyWrapper = anyWrapper;
    }

    public boolean isConnected() {
        return this.m_connected;
    }

    public synchronized void eConnect(String string, int n, int n2) {
        if ((string = this.checkConnected(string)) == null) {
            return;
        }
        try {
            Socket socket = new Socket(string, n);
            this.eConnect(socket, n2);
        }
        catch (Exception exception) {
            this.eDisconnect();
            this.connectionError();
        }
    }

    protected void connectionError() {
        this.m_anyWrapper.error(-1, EClientErrors.CONNECT_FAIL.code(), EClientErrors.CONNECT_FAIL.msg());
        this.m_reader = null;
    }

    protected String checkConnected(String string) {
        if (this.m_connected) {
            this.m_anyWrapper.error(-1, EClientErrors.ALREADY_CONNECTED.code(), EClientErrors.ALREADY_CONNECTED.msg());
            return null;
        }
        if (EClientSocket.isNull(string)) {
            string = "127.0.0.1";
        }
        return string;
    }

    public EReader createReader(EClientSocket eClientSocket, DataInputStream dataInputStream) {
        return new EReader(eClientSocket, dataInputStream);
    }

    public synchronized void eConnect(Socket socket, int n) throws IOException {
        this.m_dos = new DataOutputStream(socket.getOutputStream());
        this.send(60);
        this.m_reader = this.createReader(this, new DataInputStream(socket.getInputStream()));
        this.m_serverVersion = this.m_reader.readInt();
        System.out.println("Server Version:" + this.m_serverVersion);
        if (this.m_serverVersion >= 20) {
            this.m_TwsTime = this.m_reader.readStr();
            System.out.println("TWS Time at connection:" + this.m_TwsTime);
        }
        if (this.m_serverVersion < 38) {
            this.eDisconnect();
            this.m_anyWrapper.error(-1, EClientErrors.UPDATE_TWS.code(), EClientErrors.UPDATE_TWS.msg());
            return;
        }
        if (this.m_serverVersion >= 3) {
            this.send(n);
        }
        this.m_reader.start();
        this.m_connected = true;
    }

    public synchronized void eDisconnect() {
        if (this.m_dos == null) {
            return;
        }
        this.m_connected = false;
        this.m_serverVersion = 0;
        this.m_TwsTime = "";
        DataOutputStream dataOutputStream = this.m_dos;
        this.m_dos = null;
        EReader eReader = this.m_reader;
        this.m_reader = null;
        try {
            if (eReader != null) {
                eReader.interrupt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (dataOutputStream != null) {
                dataOutputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void cancelScannerSubscription(int n) {
        if (!this.m_connected) {
            this.error(-1, EClientErrors.NOT_CONNECTED, "");
            return;
        }
        if (this.m_serverVersion < 24) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support API scanner subscription.");
            return;
        }
        try {
            this.send(23);
            this.send(1);
            this.send(n);
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_CANSCANNER, "" + exception);
            this.close();
        }
    }

    public synchronized void reqScannerParameters() {
        if (!this.m_connected) {
            this.error(-1, EClientErrors.NOT_CONNECTED, "");
            return;
        }
        if (this.m_serverVersion < 24) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support API scanner subscription.");
            return;
        }
        try {
            this.send(24);
            this.send(1);
        }
        catch (Exception exception) {
            this.error(-1, EClientErrors.FAIL_SEND_REQSCANNERPARAMETERS, "" + exception);
            this.close();
        }
    }

    public synchronized void reqScannerSubscription(int n, ScannerSubscription scannerSubscription) {
        if (!this.m_connected) {
            this.error(-1, EClientErrors.NOT_CONNECTED, "");
            return;
        }
        if (this.m_serverVersion < 24) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support API scanner subscription.");
            return;
        }
        try {
            this.send(22);
            this.send(3);
            this.send(n);
            this.sendMax(scannerSubscription.numberOfRows());
            this.send(scannerSubscription.instrument());
            this.send(scannerSubscription.locationCode());
            this.send(scannerSubscription.scanCode());
            this.sendMax(scannerSubscription.abovePrice());
            this.sendMax(scannerSubscription.belowPrice());
            this.sendMax(scannerSubscription.aboveVolume());
            this.sendMax(scannerSubscription.marketCapAbove());
            this.sendMax(scannerSubscription.marketCapBelow());
            this.send(scannerSubscription.moodyRatingAbove());
            this.send(scannerSubscription.moodyRatingBelow());
            this.send(scannerSubscription.spRatingAbove());
            this.send(scannerSubscription.spRatingBelow());
            this.send(scannerSubscription.maturityDateAbove());
            this.send(scannerSubscription.maturityDateBelow());
            this.sendMax(scannerSubscription.couponRateAbove());
            this.sendMax(scannerSubscription.couponRateBelow());
            this.send(scannerSubscription.excludeConvertible());
            if (this.m_serverVersion >= 25) {
                this.send(scannerSubscription.averageOptionVolumeAbove());
                this.send(scannerSubscription.scannerSettingPairs());
            }
            if (this.m_serverVersion >= 27) {
                this.send(scannerSubscription.stockTypeFilter());
            }
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_REQSCANNER, "" + exception);
            this.close();
        }
    }

    public synchronized void reqMktData(int n, Contract contract, String string, boolean bl) {
        if (!this.m_connected) {
            this.error(-1, EClientErrors.NOT_CONNECTED, "");
            return;
        }
        if (this.m_serverVersion < 35 && bl) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support snapshot market data requests.");
            return;
        }
        if (this.m_serverVersion < 40 && contract.m_underComp != null) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support delta-neutral orders.");
            return;
        }
        if (this.m_serverVersion < 47 && contract.m_conId > 0) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support conId parameter.");
            return;
        }
        try {
            Object object;
            this.send(1);
            this.send(9);
            this.send(n);
            if (this.m_serverVersion >= 47) {
                this.send(contract.m_conId);
            }
            this.send(contract.m_symbol);
            this.send(contract.m_secType);
            this.send(contract.m_expiry);
            this.send(contract.m_strike);
            this.send(contract.m_right);
            if (this.m_serverVersion >= 15) {
                this.send(contract.m_multiplier);
            }
            this.send(contract.m_exchange);
            if (this.m_serverVersion >= 14) {
                this.send(contract.m_primaryExch);
            }
            this.send(contract.m_currency);
            if (this.m_serverVersion >= 2) {
                this.send(contract.m_localSymbol);
            }
            if (this.m_serverVersion >= 8 && BAG_SEC_TYPE.equalsIgnoreCase(contract.m_secType)) {
                if (contract.m_comboLegs == null) {
                    this.send(0);
                } else {
                    this.send(contract.m_comboLegs.size());
                    for (int i = 0; i < contract.m_comboLegs.size(); ++i) {
                        object = (ComboLeg)contract.m_comboLegs.get(i);
                        this.send(((ComboLeg)object).m_conId);
                        this.send(((ComboLeg)object).m_ratio);
                        this.send(((ComboLeg)object).m_action);
                        this.send(((ComboLeg)object).m_exchange);
                    }
                }
            }
            if (this.m_serverVersion >= 40) {
                if (contract.m_underComp != null) {
                    object = contract.m_underComp;
                    this.send(true);
                    this.send(((UnderComp)object).m_conId);
                    this.send(((UnderComp)object).m_delta);
                    this.send(((UnderComp)object).m_price);
                } else {
                    this.send(false);
                }
            }
            if (this.m_serverVersion >= 31) {
                this.send(string);
            }
            if (this.m_serverVersion >= 35) {
                this.send(bl);
            }
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_REQMKT, "" + exception);
            this.close();
        }
    }

    public synchronized void cancelHistoricalData(int n) {
        if (!this.m_connected) {
            this.error(-1, EClientErrors.NOT_CONNECTED, "");
            return;
        }
        if (this.m_serverVersion < 24) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support historical data query cancellation.");
            return;
        }
        try {
            this.send(25);
            this.send(1);
            this.send(n);
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_CANHISTDATA, "" + exception);
            this.close();
        }
    }

    public void cancelRealTimeBars(int n) {
        if (!this.m_connected) {
            this.error(-1, EClientErrors.NOT_CONNECTED, "");
            return;
        }
        if (this.m_serverVersion < 34) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support realtime bar data query cancellation.");
            return;
        }
        try {
            this.send(51);
            this.send(1);
            this.send(n);
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_CANRTBARS, "" + exception);
            this.close();
        }
    }

    public synchronized void reqHistoricalData(int n, Contract contract, String string, String string2, String string3, String string4, int n2, int n3) {
        if (!this.m_connected) {
            this.error(n, EClientErrors.NOT_CONNECTED, "");
            return;
        }
        try {
            if (this.m_serverVersion < 16) {
                this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support historical data backfill.");
                return;
            }
            this.send(20);
            this.send(4);
            this.send(n);
            this.send(contract.m_symbol);
            this.send(contract.m_secType);
            this.send(contract.m_expiry);
            this.send(contract.m_strike);
            this.send(contract.m_right);
            this.send(contract.m_multiplier);
            this.send(contract.m_exchange);
            this.send(contract.m_primaryExch);
            this.send(contract.m_currency);
            this.send(contract.m_localSymbol);
            if (this.m_serverVersion >= 31) {
                this.send(contract.m_includeExpired ? 1 : 0);
            }
            if (this.m_serverVersion >= 20) {
                this.send(string);
                this.send(string3);
            }
            this.send(string2);
            this.send(n2);
            this.send(string4);
            if (this.m_serverVersion > 16) {
                this.send(n3);
            }
            if (BAG_SEC_TYPE.equalsIgnoreCase(contract.m_secType)) {
                if (contract.m_comboLegs == null) {
                    this.send(0);
                } else {
                    this.send(contract.m_comboLegs.size());
                    for (int i = 0; i < contract.m_comboLegs.size(); ++i) {
                        ComboLeg comboLeg = (ComboLeg)contract.m_comboLegs.get(i);
                        this.send(comboLeg.m_conId);
                        this.send(comboLeg.m_ratio);
                        this.send(comboLeg.m_action);
                        this.send(comboLeg.m_exchange);
                    }
                }
            }
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_REQHISTDATA, "" + exception);
            this.close();
        }
    }

    public synchronized void reqRealTimeBars(int n, Contract contract, int n2, String string, boolean bl) {
        if (!this.m_connected) {
            this.error(-1, EClientErrors.NOT_CONNECTED, "");
            return;
        }
        if (this.m_serverVersion < 34) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support real time bars.");
            return;
        }
        try {
            this.send(50);
            this.send(1);
            this.send(n);
            this.send(contract.m_symbol);
            this.send(contract.m_secType);
            this.send(contract.m_expiry);
            this.send(contract.m_strike);
            this.send(contract.m_right);
            this.send(contract.m_multiplier);
            this.send(contract.m_exchange);
            this.send(contract.m_primaryExch);
            this.send(contract.m_currency);
            this.send(contract.m_localSymbol);
            this.send(n2);
            this.send(string);
            this.send(bl);
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_REQRTBARS, "" + exception);
            this.close();
        }
    }

    public synchronized void reqContractDetails(int n, Contract contract) {
        if (!this.m_connected) {
            this.error(-1, EClientErrors.NOT_CONNECTED, "");
            return;
        }
        if (this.m_serverVersion < 4) {
            this.error(-1, EClientErrors.UPDATE_TWS.code(), EClientErrors.UPDATE_TWS.msg());
            return;
        }
        if (!(this.m_serverVersion >= 45 || EClientSocket.IsEmpty(contract.m_secIdType) && EClientSocket.IsEmpty(contract.m_secId))) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support secIdType and secId parameters.");
            return;
        }
        try {
            this.send(9);
            this.send(6);
            if (this.m_serverVersion >= 40) {
                this.send(n);
            }
            if (this.m_serverVersion >= 37) {
                this.send(contract.m_conId);
            }
            this.send(contract.m_symbol);
            this.send(contract.m_secType);
            this.send(contract.m_expiry);
            this.send(contract.m_strike);
            this.send(contract.m_right);
            if (this.m_serverVersion >= 15) {
                this.send(contract.m_multiplier);
            }
            this.send(contract.m_exchange);
            this.send(contract.m_currency);
            this.send(contract.m_localSymbol);
            if (this.m_serverVersion >= 31) {
                this.send(contract.m_includeExpired);
            }
            if (this.m_serverVersion >= 45) {
                this.send(contract.m_secIdType);
                this.send(contract.m_secId);
            }
        }
        catch (Exception exception) {
            this.error(-1, EClientErrors.FAIL_SEND_REQCONTRACT, "" + exception);
            this.close();
        }
    }

    public synchronized void reqMktDepth(int n, Contract contract, int n2) {
        if (!this.m_connected) {
            this.error(-1, EClientErrors.NOT_CONNECTED, "");
            return;
        }
        if (this.m_serverVersion < 6) {
            this.error(-1, EClientErrors.UPDATE_TWS.code(), EClientErrors.UPDATE_TWS.msg());
            return;
        }
        try {
            this.send(10);
            this.send(3);
            this.send(n);
            this.send(contract.m_symbol);
            this.send(contract.m_secType);
            this.send(contract.m_expiry);
            this.send(contract.m_strike);
            this.send(contract.m_right);
            if (this.m_serverVersion >= 15) {
                this.send(contract.m_multiplier);
            }
            this.send(contract.m_exchange);
            this.send(contract.m_currency);
            this.send(contract.m_localSymbol);
            if (this.m_serverVersion >= 19) {
                this.send(n2);
            }
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_REQMKTDEPTH, "" + exception);
            this.close();
        }
    }

    public synchronized void cancelMktData(int n) {
        if (!this.m_connected) {
            this.error(-1, EClientErrors.NOT_CONNECTED, "");
            return;
        }
        try {
            this.send(2);
            this.send(1);
            this.send(n);
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_CANMKT, "" + exception);
            this.close();
        }
    }

    public synchronized void cancelMktDepth(int n) {
        if (!this.m_connected) {
            this.error(-1, EClientErrors.NOT_CONNECTED, "");
            return;
        }
        if (this.m_serverVersion < 6) {
            this.error(-1, EClientErrors.UPDATE_TWS.code(), EClientErrors.UPDATE_TWS.msg());
            return;
        }
        try {
            this.send(11);
            this.send(1);
            this.send(n);
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_CANMKTDEPTH, "" + exception);
            this.close();
        }
    }

    public synchronized void exerciseOptions(int n, Contract contract, int n2, int n3, String string, int n4) {
        if (!this.m_connected) {
            this.error(n, EClientErrors.NOT_CONNECTED, "");
            return;
        }
        try {
            if (this.m_serverVersion < 21) {
                this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support options exercise from the API.");
                return;
            }
            this.send(21);
            this.send(1);
            this.send(n);
            this.send(contract.m_symbol);
            this.send(contract.m_secType);
            this.send(contract.m_expiry);
            this.send(contract.m_strike);
            this.send(contract.m_right);
            this.send(contract.m_multiplier);
            this.send(contract.m_exchange);
            this.send(contract.m_currency);
            this.send(contract.m_localSymbol);
            this.send(n2);
            this.send(n3);
            this.send(string);
            this.send(n4);
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_REQMKT, "" + exception);
            this.close();
        }
    }

    public synchronized void placeOrder(int n, Contract contract, Order order) {
        Object object;
        int n2;
        if (!this.m_connected) {
            this.error(-1, EClientErrors.NOT_CONNECTED, "");
            return;
        }
        if (this.m_serverVersion < 35 && (order.m_scaleInitLevelSize != Integer.MAX_VALUE || order.m_scalePriceIncrement != Double.MAX_VALUE)) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support Scale orders.");
            return;
        }
        if (this.m_serverVersion < 35 && !contract.m_comboLegs.isEmpty()) {
            for (n2 = 0; n2 < contract.m_comboLegs.size(); ++n2) {
                object = (ComboLeg)contract.m_comboLegs.get(n2);
                if (((ComboLeg)object).m_shortSaleSlot == 0 && EClientSocket.IsEmpty(((ComboLeg)object).m_designatedLocation)) continue;
                this.error(n, EClientErrors.UPDATE_TWS, "  It does not support SSHORT flag for combo legs.");
                return;
            }
        }
        if (this.m_serverVersion < 36 && order.m_whatIf) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support what-if orders.");
            return;
        }
        if (this.m_serverVersion < 40 && contract.m_underComp != null) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support delta-neutral orders.");
            return;
        }
        if (this.m_serverVersion < 40 && order.m_scaleSubsLevelSize != Integer.MAX_VALUE) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support Subsequent Level Size for Scale orders.");
            return;
        }
        if (this.m_serverVersion < 41 && !EClientSocket.IsEmpty(order.m_algoStrategy)) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support algo orders.");
            return;
        }
        if (this.m_serverVersion < 44 && order.m_notHeld) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support notHeld parameter.");
            return;
        }
        if (!(this.m_serverVersion >= 45 || EClientSocket.IsEmpty(contract.m_secIdType) && EClientSocket.IsEmpty(contract.m_secId))) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support secIdType and secId parameters.");
            return;
        }
        if (this.m_serverVersion < 46 && contract.m_conId > 0) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support conId parameter.");
            return;
        }
        if (this.m_serverVersion < 52 && order.m_exemptCode != -1) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support exemptCode parameter.");
            return;
        }
        if (this.m_serverVersion < 52 && !contract.m_comboLegs.isEmpty()) {
            for (n2 = 0; n2 < contract.m_comboLegs.size(); ++n2) {
                object = (ComboLeg)contract.m_comboLegs.get(n2);
                if (((ComboLeg)object).m_exemptCode == -1) continue;
                this.error(n, EClientErrors.UPDATE_TWS, "  It does not support exemptCode parameter.");
                return;
            }
        }
        if (this.m_serverVersion < 54 && !EClientSocket.IsEmpty(order.m_hedgeType)) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support hedge orders.");
            return;
        }
        if (this.m_serverVersion < 56 && order.m_optOutSmartRouting) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support optOutSmartRouting parameter.");
            return;
        }
        if (!(this.m_serverVersion >= 58 || order.m_deltaNeutralConId <= 0 && EClientSocket.IsEmpty(order.m_deltaNeutralSettlingFirm) && EClientSocket.IsEmpty(order.m_deltaNeutralClearingAccount) && EClientSocket.IsEmpty(order.m_deltaNeutralClearingIntent))) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support deltaNeutral parameters: ConId, SettlingFirm, ClearingAccount, ClearingIntent");
            return;
        }
        if (!(this.m_serverVersion >= 66 || EClientSocket.IsEmpty(order.m_deltaNeutralOpenClose) && !order.m_deltaNeutralShortSale && order.m_deltaNeutralShortSaleSlot <= 0 && EClientSocket.IsEmpty(order.m_deltaNeutralDesignatedLocation))) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support deltaNeutral parameters: OpenClose, ShortSale, ShortSaleSlot, DesignatedLocation");
            return;
        }
        if (this.m_serverVersion < 60 && order.m_scalePriceIncrement > 0.0 && order.m_scalePriceIncrement != Double.MAX_VALUE && (order.m_scalePriceAdjustValue != Double.MAX_VALUE || order.m_scalePriceAdjustInterval != Integer.MAX_VALUE || order.m_scaleProfitOffset != Double.MAX_VALUE || order.m_scaleAutoReset || order.m_scaleInitPosition != Integer.MAX_VALUE || order.m_scaleInitFillQty != Integer.MAX_VALUE || order.m_scaleRandomPercent)) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support Scale order parameters: PriceAdjustValue, PriceAdjustInterval, ProfitOffset, AutoReset, InitPosition, InitFillQty and RandomPercent");
            return;
        }
        if (this.m_serverVersion < 61 && BAG_SEC_TYPE.equalsIgnoreCase(contract.m_secType) && !order.m_orderComboLegs.isEmpty()) {
            for (n2 = 0; n2 < order.m_orderComboLegs.size(); ++n2) {
                object = order.m_orderComboLegs.get(n2);
                if (((OrderComboLeg)object).m_price == Double.MAX_VALUE) continue;
                this.error(n, EClientErrors.UPDATE_TWS, "  It does not support per-leg prices for order combo legs.");
                return;
            }
        }
        if (this.m_serverVersion < 62 && order.m_trailingPercent != Double.MAX_VALUE) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support trailing percent parameter");
            return;
        }
        int n3 = this.m_serverVersion < 44 ? 27 : 39;
        try {
            TagValue tagValue;
            int n4;
            int n5;
            this.send(3);
            this.send(n3);
            this.send(n);
            if (this.m_serverVersion >= 46) {
                this.send(contract.m_conId);
            }
            this.send(contract.m_symbol);
            this.send(contract.m_secType);
            this.send(contract.m_expiry);
            this.send(contract.m_strike);
            this.send(contract.m_right);
            if (this.m_serverVersion >= 15) {
                this.send(contract.m_multiplier);
            }
            this.send(contract.m_exchange);
            if (this.m_serverVersion >= 14) {
                this.send(contract.m_primaryExch);
            }
            this.send(contract.m_currency);
            if (this.m_serverVersion >= 2) {
                this.send(contract.m_localSymbol);
            }
            if (this.m_serverVersion >= 45) {
                this.send(contract.m_secIdType);
                this.send(contract.m_secId);
            }
            this.send(order.m_action);
            this.send(order.m_totalQuantity);
            this.send(order.m_orderType);
            if (this.m_serverVersion < 61) {
                this.send(order.m_lmtPrice == Double.MAX_VALUE ? 0.0 : order.m_lmtPrice);
            } else {
                this.sendMax(order.m_lmtPrice);
            }
            if (this.m_serverVersion < 62) {
                this.send(order.m_auxPrice == Double.MAX_VALUE ? 0.0 : order.m_auxPrice);
            } else {
                this.sendMax(order.m_auxPrice);
            }
            this.send(order.m_tif);
            this.send(order.m_ocaGroup);
            this.send(order.m_account);
            this.send(order.m_openClose);
            this.send(order.m_origin);
            this.send(order.m_orderRef);
            this.send(order.m_transmit);
            if (this.m_serverVersion >= 4) {
                this.send(order.m_parentId);
            }
            if (this.m_serverVersion >= 5) {
                this.send(order.m_blockOrder);
                this.send(order.m_sweepToFill);
                this.send(order.m_displaySize);
                this.send(order.m_triggerMethod);
                if (this.m_serverVersion < 38) {
                    this.send(false);
                } else {
                    this.send(order.m_outsideRth);
                }
            }
            if (this.m_serverVersion >= 7) {
                this.send(order.m_hidden);
            }
            if (this.m_serverVersion >= 8 && BAG_SEC_TYPE.equalsIgnoreCase(contract.m_secType)) {
                if (contract.m_comboLegs == null) {
                    this.send(0);
                } else {
                    this.send(contract.m_comboLegs.size());
                    for (n5 = 0; n5 < contract.m_comboLegs.size(); ++n5) {
                        ComboLeg comboLeg = (ComboLeg)contract.m_comboLegs.get(n5);
                        this.send(comboLeg.m_conId);
                        this.send(comboLeg.m_ratio);
                        this.send(comboLeg.m_action);
                        this.send(comboLeg.m_exchange);
                        this.send(comboLeg.m_openClose);
                        if (this.m_serverVersion >= 35) {
                            this.send(comboLeg.m_shortSaleSlot);
                            this.send(comboLeg.m_designatedLocation);
                        }
                        if (this.m_serverVersion < 51) continue;
                        this.send(comboLeg.m_exemptCode);
                    }
                }
            }
            if (this.m_serverVersion >= 61 && BAG_SEC_TYPE.equalsIgnoreCase(contract.m_secType)) {
                if (order.m_orderComboLegs == null) {
                    this.send(0);
                } else {
                    this.send(order.m_orderComboLegs.size());
                    for (int i = 0; i < order.m_orderComboLegs.size(); ++i) {
                        OrderComboLeg orderComboLeg = order.m_orderComboLegs.get(i);
                        this.sendMax(orderComboLeg.m_price);
                    }
                }
            }
            if (this.m_serverVersion >= 57 && BAG_SEC_TYPE.equalsIgnoreCase(contract.m_secType)) {
                Vector<TagValue> vector = order.m_smartComboRoutingParams;
                n5 = vector == null ? 0 : vector.size();
                this.send(n5);
                if (n5 > 0) {
                    for (n4 = 0; n4 < n5; ++n4) {
                        tagValue = vector.get(n4);
                        this.send(tagValue.m_tag);
                        this.send(tagValue.m_value);
                    }
                }
            }
            if (this.m_serverVersion >= 9) {
                this.send("");
            }
            if (this.m_serverVersion >= 10) {
                this.send(order.m_discretionaryAmt);
            }
            if (this.m_serverVersion >= 11) {
                this.send(order.m_goodAfterTime);
            }
            if (this.m_serverVersion >= 12) {
                this.send(order.m_goodTillDate);
            }
            if (this.m_serverVersion >= 13) {
                this.send(order.m_faGroup);
                this.send(order.m_faMethod);
                this.send(order.m_faPercentage);
                this.send(order.m_faProfile);
            }
            if (this.m_serverVersion >= 18) {
                this.send(order.m_shortSaleSlot);
                this.send(order.m_designatedLocation);
            }
            if (this.m_serverVersion >= 51) {
                this.send(order.m_exemptCode);
            }
            if (this.m_serverVersion >= 19) {
                this.send(order.m_ocaType);
                if (this.m_serverVersion < 38) {
                    this.send(false);
                }
                this.send(order.m_rule80A);
                this.send(order.m_settlingFirm);
                this.send(order.m_allOrNone);
                this.sendMax(order.m_minQty);
                this.sendMax(order.m_percentOffset);
                this.send(order.m_eTradeOnly);
                this.send(order.m_firmQuoteOnly);
                this.sendMax(order.m_nbboPriceCap);
                this.sendMax(order.m_auctionStrategy);
                this.sendMax(order.m_startingPrice);
                this.sendMax(order.m_stockRefPrice);
                this.sendMax(order.m_delta);
                double d = this.m_serverVersion == 26 && order.m_orderType.equals("VOL") ? Double.MAX_VALUE : order.m_stockRangeLower;
                double d2 = this.m_serverVersion == 26 && order.m_orderType.equals("VOL") ? Double.MAX_VALUE : order.m_stockRangeUpper;
                this.sendMax(d);
                this.sendMax(d2);
            }
            if (this.m_serverVersion >= 22) {
                this.send(order.m_overridePercentageConstraints);
            }
            if (this.m_serverVersion >= 26) {
                this.sendMax(order.m_volatility);
                this.sendMax(order.m_volatilityType);
                if (this.m_serverVersion < 28) {
                    this.send(order.m_deltaNeutralOrderType.equalsIgnoreCase("MKT"));
                } else {
                    this.send(order.m_deltaNeutralOrderType);
                    this.sendMax(order.m_deltaNeutralAuxPrice);
                    if (this.m_serverVersion >= 58 && !EClientSocket.IsEmpty(order.m_deltaNeutralOrderType)) {
                        this.send(order.m_deltaNeutralConId);
                        this.send(order.m_deltaNeutralSettlingFirm);
                        this.send(order.m_deltaNeutralClearingAccount);
                        this.send(order.m_deltaNeutralClearingIntent);
                    }
                    if (this.m_serverVersion >= 66 && !EClientSocket.IsEmpty(order.m_deltaNeutralOrderType)) {
                        this.send(order.m_deltaNeutralOpenClose);
                        this.send(order.m_deltaNeutralShortSale);
                        this.send(order.m_deltaNeutralShortSaleSlot);
                        this.send(order.m_deltaNeutralDesignatedLocation);
                    }
                }
                this.send(order.m_continuousUpdate);
                if (this.m_serverVersion == 26) {
                    double d = order.m_orderType.equals("VOL") ? order.m_stockRangeLower : Double.MAX_VALUE;
                    double d3 = order.m_orderType.equals("VOL") ? order.m_stockRangeUpper : Double.MAX_VALUE;
                    this.sendMax(d);
                    this.sendMax(d3);
                }
                this.sendMax(order.m_referencePriceType);
            }
            if (this.m_serverVersion >= 30) {
                this.sendMax(order.m_trailStopPrice);
            }
            if (this.m_serverVersion >= 62) {
                this.sendMax(order.m_trailingPercent);
            }
            if (this.m_serverVersion >= 35) {
                if (this.m_serverVersion >= 40) {
                    this.sendMax(order.m_scaleInitLevelSize);
                    this.sendMax(order.m_scaleSubsLevelSize);
                } else {
                    this.send("");
                    this.sendMax(order.m_scaleInitLevelSize);
                }
                this.sendMax(order.m_scalePriceIncrement);
            }
            if (this.m_serverVersion >= 60 && order.m_scalePriceIncrement > 0.0 && order.m_scalePriceIncrement != Double.MAX_VALUE) {
                this.sendMax(order.m_scalePriceAdjustValue);
                this.sendMax(order.m_scalePriceAdjustInterval);
                this.sendMax(order.m_scaleProfitOffset);
                this.send(order.m_scaleAutoReset);
                this.sendMax(order.m_scaleInitPosition);
                this.sendMax(order.m_scaleInitFillQty);
                this.send(order.m_scaleRandomPercent);
            }
            if (this.m_serverVersion >= 54) {
                this.send(order.m_hedgeType);
                if (!EClientSocket.IsEmpty(order.m_hedgeType)) {
                    this.send(order.m_hedgeParam);
                }
            }
            if (this.m_serverVersion >= 56) {
                this.send(order.m_optOutSmartRouting);
            }
            if (this.m_serverVersion >= 39) {
                this.send(order.m_clearingAccount);
                this.send(order.m_clearingIntent);
            }
            if (this.m_serverVersion >= 44) {
                this.send(order.m_notHeld);
            }
            if (this.m_serverVersion >= 40) {
                if (contract.m_underComp != null) {
                    UnderComp underComp = contract.m_underComp;
                    this.send(true);
                    this.send(underComp.m_conId);
                    this.send(underComp.m_delta);
                    this.send(underComp.m_price);
                } else {
                    this.send(false);
                }
            }
            if (this.m_serverVersion >= 41) {
                this.send(order.m_algoStrategy);
                if (!EClientSocket.IsEmpty(order.m_algoStrategy)) {
                    Vector<TagValue> vector = order.m_algoParams;
                    n5 = vector == null ? 0 : vector.size();
                    this.send(n5);
                    if (n5 > 0) {
                        for (n4 = 0; n4 < n5; ++n4) {
                            tagValue = vector.get(n4);
                            this.send(tagValue.m_tag);
                            this.send(tagValue.m_value);
                        }
                    }
                }
            }
            if (this.m_serverVersion >= 36) {
                this.send(order.m_whatIf);
            }
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_ORDER, "" + exception);
            this.close();
        }
    }

    public synchronized void reqAccountUpdates(boolean bl, String string) {
        if (!this.m_connected) {
            this.error(-1, EClientErrors.NOT_CONNECTED, "");
            return;
        }
        try {
            this.send(6);
            this.send(2);
            this.send(bl);
            if (this.m_serverVersion >= 9) {
                this.send(string);
            }
        }
        catch (Exception exception) {
            this.error(-1, EClientErrors.FAIL_SEND_ACCT, "" + exception);
            this.close();
        }
    }

    public synchronized void reqExecutions(int n, ExecutionFilter executionFilter) {
        if (!this.m_connected) {
            this.error(-1, EClientErrors.NOT_CONNECTED, "");
            return;
        }
        try {
            this.send(7);
            this.send(3);
            if (this.m_serverVersion >= 42) {
                this.send(n);
            }
            if (this.m_serverVersion >= 9) {
                this.send(executionFilter.m_clientId);
                this.send(executionFilter.m_acctCode);
                this.send(executionFilter.m_time);
                this.send(executionFilter.m_symbol);
                this.send(executionFilter.m_secType);
                this.send(executionFilter.m_exchange);
                this.send(executionFilter.m_side);
            }
        }
        catch (Exception exception) {
            this.error(-1, EClientErrors.FAIL_SEND_EXEC, "" + exception);
            this.close();
        }
    }

    public synchronized void cancelOrder(int n) {
        if (!this.m_connected) {
            this.error(-1, EClientErrors.NOT_CONNECTED, "");
            return;
        }
        try {
            this.send(4);
            this.send(1);
            this.send(n);
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_CORDER, "" + exception);
            this.close();
        }
    }

    public synchronized void reqOpenOrders() {
        if (!this.m_connected) {
            this.error(-1, EClientErrors.NOT_CONNECTED, "");
            return;
        }
        try {
            this.send(5);
            this.send(1);
        }
        catch (Exception exception) {
            this.error(-1, EClientErrors.FAIL_SEND_OORDER, "" + exception);
            this.close();
        }
    }

    public synchronized void reqIds(int n) {
        if (!this.m_connected) {
            this.error(-1, EClientErrors.NOT_CONNECTED, "");
            return;
        }
        try {
            this.send(8);
            this.send(1);
            this.send(n);
        }
        catch (Exception exception) {
            this.error(-1, EClientErrors.FAIL_SEND_CORDER, "" + exception);
            this.close();
        }
    }

    public synchronized void reqNewsBulletins(boolean bl) {
        if (!this.m_connected) {
            this.error(-1, EClientErrors.NOT_CONNECTED, "");
            return;
        }
        try {
            this.send(12);
            this.send(1);
            this.send(bl);
        }
        catch (Exception exception) {
            this.error(-1, EClientErrors.FAIL_SEND_CORDER, "" + exception);
            this.close();
        }
    }

    public synchronized void cancelNewsBulletins() {
        if (!this.m_connected) {
            this.error(-1, EClientErrors.NOT_CONNECTED, "");
            return;
        }
        try {
            this.send(13);
            this.send(1);
        }
        catch (Exception exception) {
            this.error(-1, EClientErrors.FAIL_SEND_CORDER, "" + exception);
            this.close();
        }
    }

    public synchronized void setServerLogLevel(int n) {
        if (!this.m_connected) {
            this.error(-1, EClientErrors.NOT_CONNECTED, "");
            return;
        }
        try {
            this.send(14);
            this.send(1);
            this.send(n);
        }
        catch (Exception exception) {
            this.error(-1, EClientErrors.FAIL_SEND_SERVER_LOG_LEVEL, "" + exception);
            this.close();
        }
    }

    public synchronized void reqAutoOpenOrders(boolean bl) {
        if (!this.m_connected) {
            this.error(-1, EClientErrors.NOT_CONNECTED, "");
            return;
        }
        try {
            this.send(15);
            this.send(1);
            this.send(bl);
        }
        catch (Exception exception) {
            this.error(-1, EClientErrors.FAIL_SEND_OORDER, "" + exception);
            this.close();
        }
    }

    public synchronized void reqAllOpenOrders() {
        if (!this.m_connected) {
            this.error(-1, EClientErrors.NOT_CONNECTED, "");
            return;
        }
        try {
            this.send(16);
            this.send(1);
        }
        catch (Exception exception) {
            this.error(-1, EClientErrors.FAIL_SEND_OORDER, "" + exception);
            this.close();
        }
    }

    public synchronized void reqManagedAccts() {
        if (!this.m_connected) {
            this.error(-1, EClientErrors.NOT_CONNECTED, "");
            return;
        }
        try {
            this.send(17);
            this.send(1);
        }
        catch (Exception exception) {
            this.error(-1, EClientErrors.FAIL_SEND_OORDER, "" + exception);
            this.close();
        }
    }

    public synchronized void requestFA(int n) {
        if (!this.m_connected) {
            this.error(-1, EClientErrors.NOT_CONNECTED, "");
            return;
        }
        if (this.m_serverVersion < 13) {
            this.error(-1, EClientErrors.UPDATE_TWS.code(), EClientErrors.UPDATE_TWS.msg());
            return;
        }
        try {
            this.send(18);
            this.send(1);
            this.send(n);
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_FA_REQUEST, "" + exception);
            this.close();
        }
    }

    public synchronized void replaceFA(int n, String string) {
        if (!this.m_connected) {
            this.error(-1, EClientErrors.NOT_CONNECTED, "");
            return;
        }
        if (this.m_serverVersion < 13) {
            this.error(-1, EClientErrors.UPDATE_TWS.code(), EClientErrors.UPDATE_TWS.msg());
            return;
        }
        try {
            this.send(19);
            this.send(1);
            this.send(n);
            this.send(string);
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_FA_REPLACE, "" + exception);
            this.close();
        }
    }

    public synchronized void reqCurrentTime() {
        if (!this.m_connected) {
            this.error(-1, EClientErrors.NOT_CONNECTED, "");
            return;
        }
        if (this.m_serverVersion < 33) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support current time requests.");
            return;
        }
        try {
            this.send(49);
            this.send(1);
        }
        catch (Exception exception) {
            this.error(-1, EClientErrors.FAIL_SEND_REQCURRTIME, "" + exception);
            this.close();
        }
    }

    public synchronized void reqFundamentalData(int n, Contract contract, String string) {
        if (!this.m_connected) {
            this.error(n, EClientErrors.NOT_CONNECTED, "");
            return;
        }
        if (this.m_serverVersion < 40) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support fundamental data requests.");
            return;
        }
        try {
            this.send(52);
            this.send(1);
            this.send(n);
            this.send(contract.m_symbol);
            this.send(contract.m_secType);
            this.send(contract.m_exchange);
            this.send(contract.m_primaryExch);
            this.send(contract.m_currency);
            this.send(contract.m_localSymbol);
            this.send(string);
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_REQFUNDDATA, "" + exception);
            this.close();
        }
    }

    public synchronized void cancelFundamentalData(int n) {
        if (!this.m_connected) {
            this.error(n, EClientErrors.NOT_CONNECTED, "");
            return;
        }
        if (this.m_serverVersion < 40) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support fundamental data requests.");
            return;
        }
        try {
            this.send(53);
            this.send(1);
            this.send(n);
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_CANFUNDDATA, "" + exception);
            this.close();
        }
    }

    public synchronized void calculateImpliedVolatility(int n, Contract contract, double d, double d2) {
        if (!this.m_connected) {
            this.error(-1, EClientErrors.NOT_CONNECTED, "");
            return;
        }
        if (this.m_serverVersion < 49) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support calculate implied volatility requests.");
            return;
        }
        try {
            this.send(54);
            this.send(1);
            this.send(n);
            this.send(contract.m_conId);
            this.send(contract.m_symbol);
            this.send(contract.m_secType);
            this.send(contract.m_expiry);
            this.send(contract.m_strike);
            this.send(contract.m_right);
            this.send(contract.m_multiplier);
            this.send(contract.m_exchange);
            this.send(contract.m_primaryExch);
            this.send(contract.m_currency);
            this.send(contract.m_localSymbol);
            this.send(d);
            this.send(d2);
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_REQCALCIMPLIEDVOLAT, "" + exception);
            this.close();
        }
    }

    public synchronized void cancelCalculateImpliedVolatility(int n) {
        if (!this.m_connected) {
            this.error(-1, EClientErrors.NOT_CONNECTED, "");
            return;
        }
        if (this.m_serverVersion < 50) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support calculate implied volatility cancellation.");
            return;
        }
        try {
            this.send(56);
            this.send(1);
            this.send(n);
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_CANCALCIMPLIEDVOLAT, "" + exception);
            this.close();
        }
    }

    public synchronized void calculateOptionPrice(int n, Contract contract, double d, double d2) {
        if (!this.m_connected) {
            this.error(-1, EClientErrors.NOT_CONNECTED, "");
            return;
        }
        if (this.m_serverVersion < 50) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support calculate option price requests.");
            return;
        }
        try {
            this.send(55);
            this.send(1);
            this.send(n);
            this.send(contract.m_conId);
            this.send(contract.m_symbol);
            this.send(contract.m_secType);
            this.send(contract.m_expiry);
            this.send(contract.m_strike);
            this.send(contract.m_right);
            this.send(contract.m_multiplier);
            this.send(contract.m_exchange);
            this.send(contract.m_primaryExch);
            this.send(contract.m_currency);
            this.send(contract.m_localSymbol);
            this.send(d);
            this.send(d2);
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_REQCALCOPTIONPRICE, "" + exception);
            this.close();
        }
    }

    public synchronized void cancelCalculateOptionPrice(int n) {
        if (!this.m_connected) {
            this.error(-1, EClientErrors.NOT_CONNECTED, "");
            return;
        }
        if (this.m_serverVersion < 50) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support calculate option price cancellation.");
            return;
        }
        try {
            this.send(57);
            this.send(1);
            this.send(n);
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_CANCALCOPTIONPRICE, "" + exception);
            this.close();
        }
    }

    public synchronized void reqGlobalCancel() {
        if (!this.m_connected) {
            this.error(-1, EClientErrors.NOT_CONNECTED, "");
            return;
        }
        if (this.m_serverVersion < 53) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support globalCancel requests.");
            return;
        }
        try {
            this.send(58);
            this.send(1);
        }
        catch (Exception exception) {
            this.error(-1, EClientErrors.FAIL_SEND_REQGLOBALCANCEL, "" + exception);
            this.close();
        }
    }

    public synchronized void reqMarketDataType(int n) {
        if (!this.m_connected) {
            this.error(-1, EClientErrors.NOT_CONNECTED, "");
            return;
        }
        if (this.m_serverVersion < 55) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support marketDataType requests.");
            return;
        }
        try {
            this.send(59);
            this.send(1);
            this.send(n);
        }
        catch (Exception exception) {
            this.error(-1, EClientErrors.FAIL_SEND_REQMARKETDATATYPE, "" + exception);
            this.close();
        }
    }

    protected synchronized void error(String string) {
        this.m_anyWrapper.error(string);
    }

    protected synchronized void error(int n, int n2, String string) {
        this.m_anyWrapper.error(n, n2, string);
    }

    protected void close() {
        this.eDisconnect();
        this.wrapper().connectionClosed();
    }

    private static boolean is(String string) {
        return string != null && string.length() > 0;
    }

    private static boolean isNull(String string) {
        return !EClientSocket.is(string);
    }

    private void error(int n, EClientErrors.CodeMsgPair codeMsgPair, String string) {
        this.error(n, codeMsgPair.code(), codeMsgPair.msg() + string);
    }

    protected void send(String string) throws IOException {
        if (!EClientSocket.IsEmpty(string)) {
            this.m_dos.write(string.getBytes());
        }
        this.sendEOL();
    }

    private void sendEOL() throws IOException {
        this.m_dos.write(EOL);
    }

    protected void send(int n) throws IOException {
        this.send(String.valueOf(n));
    }

    protected void send(char c) throws IOException {
        this.m_dos.write(c);
        this.sendEOL();
    }

    protected void send(double d) throws IOException {
        this.send(String.valueOf(d));
    }

    protected void send(long l) throws IOException {
        this.send(String.valueOf(l));
    }

    private void sendMax(double d) throws IOException {
        if (d == Double.MAX_VALUE) {
            this.sendEOL();
        } else {
            this.send(String.valueOf(d));
        }
    }

    private void sendMax(int n) throws IOException {
        if (n == Integer.MAX_VALUE) {
            this.sendEOL();
        } else {
            this.send(String.valueOf(n));
        }
    }

    protected void send(boolean bl) throws IOException {
        this.send(bl ? 1 : 0);
    }

    private static boolean IsEmpty(String string) {
        return Util.StringIsEmpty(string);
    }
}

