/*
 * Decompiled with CFR 0.152.
 */
package TestJavaClient;

import TestJavaClient.IBGridBagPanel;
import TestJavaClient.Main;
import com.ib.client.UnderComp;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class UnderCompDlg
extends JDialog {
    private UnderComp m_underComp;
    private JTextField m_txtConId = new JTextField();
    private JTextField m_txtDelta = new JTextField();
    private JTextField m_txtPrice = new JTextField();
    private JButton m_btnOk = new JButton("OK");
    private JButton m_btnReset = new JButton("Reset");
    private JButton m_btnCancel = new JButton("Cancel");
    private boolean m_ok = false;
    private boolean m_reset = false;
    private static final int COL1_WIDTH = 30;
    private static final int COL2_WIDTH = 70;

    public UnderCompDlg(UnderComp underComp, JDialog jDialog) {
        super((Dialog)jDialog, true);
        this.m_underComp = underComp;
        JPanel jPanel = new JPanel();
        jPanel.add(this.m_btnOk);
        jPanel.add(this.m_btnReset);
        jPanel.add(this.m_btnCancel);
        this.m_btnOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UnderCompDlg.this.onOk();
            }
        });
        this.m_btnReset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UnderCompDlg.this.onReset();
            }
        });
        this.m_btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UnderCompDlg.this.onCancel();
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridheight = 1;
        IBGridBagPanel iBGridBagPanel = new IBGridBagPanel();
        iBGridBagPanel.setBorder(BorderFactory.createTitledBorder("Under Comp"));
        UnderCompDlg.addGBComponent(iBGridBagPanel, new JLabel("Contract Id"), gridBagConstraints, 30, -1);
        UnderCompDlg.addGBComponent(iBGridBagPanel, this.m_txtConId, gridBagConstraints, 70, 0);
        UnderCompDlg.addGBComponent(iBGridBagPanel, new JLabel("Delta"), gridBagConstraints, 30, -1);
        UnderCompDlg.addGBComponent(iBGridBagPanel, this.m_txtDelta, gridBagConstraints, 70, 0);
        UnderCompDlg.addGBComponent(iBGridBagPanel, new JLabel("Price"), gridBagConstraints, 30, -1);
        UnderCompDlg.addGBComponent(iBGridBagPanel, this.m_txtPrice, gridBagConstraints, 70, 0);
        this.m_txtConId.setText(Integer.toString(this.m_underComp.m_conId));
        this.m_txtDelta.setText(Double.toString(this.m_underComp.m_delta));
        this.m_txtPrice.setText(Double.toString(this.m_underComp.m_price));
        this.getContentPane().add((Component)iBGridBagPanel, "Center");
        this.getContentPane().add((Component)jPanel, "South");
        this.setTitle("Delta Neutral");
        this.pack();
    }

    private void onOk() {
        try {
            int n = Integer.parseInt(this.m_txtConId.getText());
            double d = Double.parseDouble(this.m_txtDelta.getText());
            double d2 = Double.parseDouble(this.m_txtPrice.getText());
            this.m_underComp.m_conId = n;
            this.m_underComp.m_delta = d;
            this.m_underComp.m_price = d2;
            this.m_ok = true;
            this.setVisible(false);
        }
        catch (Exception exception) {
            Main.inform(this, "Error - " + exception);
        }
    }

    private void onReset() {
        this.m_underComp.m_conId = 0;
        this.m_underComp.m_delta = 0.0;
        this.m_underComp.m_price = 0.0;
        this.m_reset = true;
        this.setVisible(false);
    }

    private void onCancel() {
        this.setVisible(false);
    }

    public boolean ok() {
        return this.m_ok;
    }

    public boolean reset() {
        return this.m_reset;
    }

    private static void addGBComponent(IBGridBagPanel iBGridBagPanel, Component component, GridBagConstraints gridBagConstraints, int n, int n2) {
        gridBagConstraints.weightx = n;
        gridBagConstraints.gridwidth = n2;
        iBGridBagPanel.setConstraints(component, gridBagConstraints);
        iBGridBagPanel.add(component, gridBagConstraints);
    }
}

