/*
 * Decompiled with CFR 0.152.
 */
package TestJavaClient;

import TestJavaClient.AccountDlg;
import TestJavaClient.AcctUpdatesDlg;
import TestJavaClient.ConnectDlg;
import TestJavaClient.ExecFilterDlg;
import TestJavaClient.ExtOrdDlg;
import TestJavaClient.FinancialAdvisorDlg;
import TestJavaClient.IBTextPanel;
import TestJavaClient.LogConfigDlg;
import TestJavaClient.Main;
import TestJavaClient.MktDepthDlg;
import TestJavaClient.NewsBulletinDlg;
import TestJavaClient.OrderDlg;
import TestJavaClient.ScannerDlg;
import com.ib.client.CommissionReport;
import com.ib.client.Contract;
import com.ib.client.ContractDetails;
import com.ib.client.EClientSocket;
import com.ib.client.EWrapper;
import com.ib.client.EWrapperMsgGenerator;
import com.ib.client.Execution;
import com.ib.client.Order;
import com.ib.client.OrderState;
import com.ib.client.UnderComp;
import com.ib.client.Util;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

class SampleFrame
extends JFrame
implements EWrapper {
    private static final int NOT_AN_FA_ACCOUNT_ERROR = 321;
    private int[] faErrorCodes = new int[]{503, 504, 505, 522, 1100, 321};
    private boolean faError;
    private EClientSocket m_client = new EClientSocket(this);
    private IBTextPanel m_tickers = new IBTextPanel("Market and Historical Data", false);
    private IBTextPanel m_TWS = new IBTextPanel("TWS Server Responses", false);
    private IBTextPanel m_errors = new IBTextPanel("Errors and Messages", false);
    private OrderDlg m_orderDlg = new OrderDlg(this);
    private ExtOrdDlg m_extOrdDlg = new ExtOrdDlg(this.m_orderDlg);
    private AccountDlg m_acctDlg = new AccountDlg(this);
    private HashMap<Integer, MktDepthDlg> m_mapRequestToMktDepthDlg = new HashMap();
    private NewsBulletinDlg m_newsBulletinDlg = new NewsBulletinDlg(this);
    private ScannerDlg m_scannerDlg = new ScannerDlg(this);
    String faGroupXML;
    String faProfilesXML;
    String faAliasesXML;
    public String m_FAAcctCodes;
    public boolean m_bIsFAAccount = false;
    private boolean m_disconnectInProgress = false;

    SampleFrame() {
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        jPanel.add(this.m_tickers);
        jPanel.add(this.m_TWS);
        jPanel.add(this.m_errors);
        JPanel jPanel2 = this.createButtonPanel();
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)jPanel2, "East");
        this.setSize(600, 700);
        this.setTitle("Sample");
        this.setDefaultCloseOperation(3);
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        JButton jButton = new JButton("Connect");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SampleFrame.this.onConnect();
            }
        });
        JButton jButton2 = new JButton("Disconnect");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SampleFrame.this.onDisconnect();
            }
        });
        JButton jButton3 = new JButton("Req Mkt Data");
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SampleFrame.this.onReqMktData();
            }
        });
        JButton jButton4 = new JButton("Cancel Mkt Data");
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SampleFrame.this.onCancelMktData();
            }
        });
        JButton jButton5 = new JButton("Req Mkt Depth");
        jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SampleFrame.this.onReqMktDepth();
            }
        });
        JButton jButton6 = new JButton("Cancel Mkt Depth");
        jButton6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SampleFrame.this.onCancelMktDepth();
            }
        });
        JButton jButton7 = new JButton("Historical Data");
        jButton7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SampleFrame.this.onHistoricalData();
            }
        });
        JButton jButton8 = new JButton("Cancel Hist. Data");
        jButton8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SampleFrame.this.onCancelHistoricalData();
            }
        });
        JButton jButton9 = new JButton("Req Real Time Bars");
        jButton9.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SampleFrame.this.onReqRealTimeBars();
            }
        });
        JButton jButton10 = new JButton("Cancel Real Time Bars");
        jButton10.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SampleFrame.this.onCancelRealTimeBars();
            }
        });
        JButton jButton11 = new JButton("Req Current Time");
        jButton11.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SampleFrame.this.onReqCurrentTime();
            }
        });
        JButton jButton12 = new JButton("Market Scanner");
        jButton12.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SampleFrame.this.onScanner();
            }
        });
        JButton jButton13 = new JButton("Req Open Orders");
        jButton13.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SampleFrame.this.onReqOpenOrders();
            }
        });
        JButton jButton14 = new JButton("Calculate Implied Volatility");
        jButton14.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SampleFrame.this.onCalculateImpliedVolatility();
            }
        });
        JButton jButton15 = new JButton("Cancel Calc Impl Volatility");
        jButton15.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SampleFrame.this.onCancelCalculateImpliedVolatility();
            }
        });
        JButton jButton16 = new JButton("Calculate Option Price");
        jButton16.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SampleFrame.this.onCalculateOptionPrice();
            }
        });
        JButton jButton17 = new JButton("Cancel Calc Opt Price");
        jButton17.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SampleFrame.this.onCancelCalculateOptionPrice();
            }
        });
        JButton jButton18 = new JButton("What If");
        jButton18.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SampleFrame.this.onWhatIfOrder();
            }
        });
        JButton jButton19 = new JButton("Place Order");
        jButton19.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SampleFrame.this.onPlaceOrder();
            }
        });
        JButton jButton20 = new JButton("Cancel Order");
        jButton20.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SampleFrame.this.onCancelOrder();
            }
        });
        JButton jButton21 = new JButton("Exercise Options");
        jButton21.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SampleFrame.this.onExerciseOptions();
            }
        });
        JButton jButton22 = new JButton("Extended");
        jButton22.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SampleFrame.this.onExtendedOrder();
            }
        });
        JButton jButton23 = new JButton("Req Acct Data");
        jButton23.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SampleFrame.this.onReqAcctData();
            }
        });
        JButton jButton24 = new JButton("Req Contract Data");
        jButton24.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SampleFrame.this.onReqContractData();
            }
        });
        JButton jButton25 = new JButton("Req Executions");
        jButton25.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SampleFrame.this.onReqExecutions();
            }
        });
        JButton jButton26 = new JButton("Req News Bulletins");
        jButton26.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SampleFrame.this.onReqNewsBulletins();
            }
        });
        JButton jButton27 = new JButton("Server Logging");
        jButton27.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SampleFrame.this.onServerLogging();
            }
        });
        JButton jButton28 = new JButton("Req All Open Orders");
        jButton28.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SampleFrame.this.onReqAllOpenOrders();
            }
        });
        JButton jButton29 = new JButton("Req Auto Open Orders");
        jButton29.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SampleFrame.this.onReqAutoOpenOrders();
            }
        });
        JButton jButton30 = new JButton("Req Accounts");
        jButton30.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SampleFrame.this.onReqManagedAccts();
            }
        });
        JButton jButton31 = new JButton("Financial Advisor");
        jButton31.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SampleFrame.this.onFinancialAdvisor();
            }
        });
        JButton jButton32 = new JButton("Global Cancel");
        jButton32.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SampleFrame.this.onGlobalCancel();
            }
        });
        JButton jButton33 = new JButton("Req Market Data Type");
        jButton33.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SampleFrame.this.onReqMarketDataType();
            }
        });
        JButton jButton34 = new JButton("Clear");
        jButton34.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SampleFrame.this.onClear();
            }
        });
        JButton jButton35 = new JButton("Close");
        jButton35.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SampleFrame.this.onClose();
            }
        });
        jPanel.add(new JPanel());
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(new JPanel());
        jPanel.add(jButton3);
        jPanel.add(jButton4);
        jPanel.add(jButton5);
        jPanel.add(jButton6);
        jPanel.add(jButton7);
        jPanel.add(jButton8);
        jPanel.add(jButton9);
        jPanel.add(jButton10);
        jPanel.add(jButton12);
        jPanel.add(jButton11);
        jPanel.add(jButton14);
        jPanel.add(jButton15);
        jPanel.add(jButton16);
        jPanel.add(jButton17);
        jPanel.add(new JPanel());
        jPanel.add(jButton18);
        jPanel.add(jButton19);
        jPanel.add(jButton20);
        jPanel.add(jButton21);
        jPanel.add(jButton22);
        jPanel.add(new JPanel());
        jPanel.add(jButton24);
        jPanel.add(jButton13);
        jPanel.add(jButton28);
        jPanel.add(jButton29);
        jPanel.add(jButton23);
        jPanel.add(jButton25);
        jPanel.add(jButton26);
        jPanel.add(jButton27);
        jPanel.add(jButton30);
        jPanel.add(jButton31);
        jPanel.add(jButton32);
        jPanel.add(jButton33);
        jPanel.add(new JPanel());
        jPanel.add(jButton34);
        jPanel.add(jButton35);
        return jPanel;
    }

    void onConnect() {
        this.m_bIsFAAccount = false;
        ConnectDlg connectDlg = new ConnectDlg(this);
        connectDlg.setVisible(true);
        if (!connectDlg.m_rc) {
            return;
        }
        this.m_disconnectInProgress = false;
        this.m_client.eConnect(connectDlg.m_retIpAddress, connectDlg.m_retPort, connectDlg.m_retClientId);
        if (this.m_client.isConnected()) {
            this.m_TWS.add("Connected to Tws server version " + this.m_client.serverVersion() + " at " + this.m_client.TwsConnectionTime());
        }
    }

    void onDisconnect() {
        this.m_disconnectInProgress = true;
        this.m_client.eDisconnect();
    }

    void onReqMktData() {
        this.m_orderDlg.show();
        if (!this.m_orderDlg.m_rc) {
            return;
        }
        this.m_client.reqMktData(this.m_orderDlg.m_id, this.m_orderDlg.m_contract, this.m_orderDlg.m_genericTicks, this.m_orderDlg.m_snapshotMktData);
    }

    void onReqRealTimeBars() {
        this.m_orderDlg.show();
        if (!this.m_orderDlg.m_rc) {
            return;
        }
        this.m_client.reqRealTimeBars(this.m_orderDlg.m_id, this.m_orderDlg.m_contract, 5, this.m_orderDlg.m_whatToShow, this.m_orderDlg.m_useRTH > 0);
    }

    void onCancelRealTimeBars() {
        this.m_orderDlg.show();
        if (!this.m_orderDlg.m_rc) {
            return;
        }
        this.m_client.cancelRealTimeBars(this.m_orderDlg.m_id);
    }

    void onScanner() {
        this.m_scannerDlg.show();
        if (this.m_scannerDlg.m_userSelection == 2) {
            this.m_client.cancelScannerSubscription(this.m_scannerDlg.m_id);
        } else if (this.m_scannerDlg.m_userSelection == 1) {
            this.m_client.reqScannerSubscription(this.m_scannerDlg.m_id, this.m_scannerDlg.m_subscription);
        } else if (this.m_scannerDlg.m_userSelection == 3) {
            this.m_client.reqScannerParameters();
        }
    }

    void onReqCurrentTime() {
        this.m_client.reqCurrentTime();
    }

    void onHistoricalData() {
        this.m_orderDlg.show();
        if (!this.m_orderDlg.m_rc) {
            return;
        }
        if (Util.StringCompare(this.m_orderDlg.m_whatToShow, "estimates") == 0 || Util.StringCompare(this.m_orderDlg.m_whatToShow, "finstat") == 0 || Util.StringCompare(this.m_orderDlg.m_whatToShow, "snapshot") == 0) {
            this.m_client.reqFundamentalData(this.m_orderDlg.m_id, this.m_orderDlg.m_contract, this.m_orderDlg.m_whatToShow);
            return;
        }
        this.m_client.reqHistoricalData(this.m_orderDlg.m_id, this.m_orderDlg.m_contract, this.m_orderDlg.m_backfillEndTime, this.m_orderDlg.m_backfillDuration, this.m_orderDlg.m_barSizeSetting, this.m_orderDlg.m_whatToShow, this.m_orderDlg.m_useRTH, this.m_orderDlg.m_formatDate);
    }

    void onCancelHistoricalData() {
        this.m_orderDlg.show();
        if (!this.m_orderDlg.m_rc) {
            return;
        }
        if (Util.StringCompare(this.m_orderDlg.m_whatToShow, "estimates") == 0 || Util.StringCompare(this.m_orderDlg.m_whatToShow, "finstat") == 0 || Util.StringCompare(this.m_orderDlg.m_whatToShow, "snapshot") == 0) {
            this.m_client.cancelFundamentalData(this.m_orderDlg.m_id);
            return;
        }
        this.m_client.cancelHistoricalData(this.m_orderDlg.m_id);
    }

    void onReqContractData() {
        this.m_orderDlg.show();
        if (!this.m_orderDlg.m_rc) {
            return;
        }
        this.m_client.reqContractDetails(this.m_orderDlg.m_id, this.m_orderDlg.m_contract);
    }

    void onReqMktDepth() {
        this.m_orderDlg.show();
        if (!this.m_orderDlg.m_rc) {
            return;
        }
        final Integer n = this.m_orderDlg.m_id;
        MktDepthDlg mktDepthDlg = this.m_mapRequestToMktDepthDlg.get(n);
        if (mktDepthDlg == null) {
            mktDepthDlg = new MktDepthDlg("Market Depth ID [" + n + "]", this);
            this.m_mapRequestToMktDepthDlg.put(n, mktDepthDlg);
            mktDepthDlg.addWindowListener(new WindowAdapter(){

                public void windowClosed(WindowEvent windowEvent) {
                    SampleFrame.this.m_mapRequestToMktDepthDlg.remove(n);
                }
            });
        }
        mktDepthDlg.setParams(this.m_client, n);
        this.m_client.reqMktDepth(n, this.m_orderDlg.m_contract, this.m_orderDlg.m_marketDepthRows);
        mktDepthDlg.setVisible(true);
    }

    void onCancelMktData() {
        this.m_orderDlg.show();
        if (!this.m_orderDlg.m_rc) {
            return;
        }
        this.m_client.cancelMktData(this.m_orderDlg.m_id);
    }

    void onCancelMktDepth() {
        this.m_orderDlg.show();
        if (!this.m_orderDlg.m_rc) {
            return;
        }
        this.m_client.cancelMktDepth(this.m_orderDlg.m_id);
    }

    void onReqOpenOrders() {
        this.m_client.reqOpenOrders();
    }

    void onWhatIfOrder() {
        this.placeOrder(true);
    }

    void onPlaceOrder() {
        this.placeOrder(false);
    }

    void placeOrder(boolean bl) {
        this.m_orderDlg.show();
        if (!this.m_orderDlg.m_rc) {
            return;
        }
        Order order = this.m_orderDlg.m_order;
        boolean bl2 = order.m_whatIf;
        order.m_whatIf = bl;
        this.m_client.placeOrder(this.m_orderDlg.m_id, this.m_orderDlg.m_contract, order);
        order.m_whatIf = bl2;
    }

    void onExerciseOptions() {
        this.m_orderDlg.show();
        if (!this.m_orderDlg.m_rc) {
            return;
        }
        this.m_client.exerciseOptions(this.m_orderDlg.m_id, this.m_orderDlg.m_contract, this.m_orderDlg.m_exerciseAction, this.m_orderDlg.m_exerciseQuantity, this.m_orderDlg.m_order.m_account, this.m_orderDlg.m_override);
    }

    void onCancelOrder() {
        this.m_orderDlg.show();
        if (!this.m_orderDlg.m_rc) {
            return;
        }
        this.m_client.cancelOrder(this.m_orderDlg.m_id);
    }

    void onExtendedOrder() {
        this.m_extOrdDlg.setVisible(true);
        if (!this.m_extOrdDlg.m_rc) {
            return;
        }
        this.copyExtendedOrderDetails(this.m_orderDlg.m_order, this.m_extOrdDlg.m_order);
    }

    void onReqAcctData() {
        AcctUpdatesDlg acctUpdatesDlg = new AcctUpdatesDlg(this);
        acctUpdatesDlg.setVisible(true);
        if (acctUpdatesDlg.m_subscribe) {
            this.m_acctDlg.accountDownloadBegin(acctUpdatesDlg.m_acctCode);
        }
        this.m_client.reqAccountUpdates(acctUpdatesDlg.m_subscribe, acctUpdatesDlg.m_acctCode);
        if (this.m_client.isConnected() && acctUpdatesDlg.m_subscribe) {
            this.m_acctDlg.reset();
            this.m_acctDlg.setVisible(true);
        }
    }

    void onFinancialAdvisor() {
        this.faAliasesXML = null;
        this.faProfilesXML = null;
        this.faGroupXML = null;
        this.faError = false;
        this.m_client.requestFA(1);
        this.m_client.requestFA(2);
        this.m_client.requestFA(3);
    }

    void onServerLogging() {
        LogConfigDlg logConfigDlg = new LogConfigDlg(this);
        logConfigDlg.setVisible(true);
        if (!logConfigDlg.m_rc) {
            return;
        }
        this.m_client.setServerLogLevel(logConfigDlg.m_serverLogLevel);
    }

    void onReqAllOpenOrders() {
        this.m_client.reqAllOpenOrders();
    }

    void onReqAutoOpenOrders() {
        this.m_client.reqAutoOpenOrders(true);
    }

    void onReqManagedAccts() {
        this.m_client.reqManagedAccts();
    }

    void onClear() {
        this.m_tickers.clear();
        this.m_TWS.clear();
        this.m_errors.clear();
    }

    void onClose() {
        System.exit(1);
    }

    void onReqExecutions() {
        ExecFilterDlg execFilterDlg = new ExecFilterDlg(this);
        execFilterDlg.setVisible(true);
        if (execFilterDlg.m_rc) {
            this.m_client.reqExecutions(execFilterDlg.m_reqId, execFilterDlg.m_execFilter);
        }
    }

    void onReqNewsBulletins() {
        this.m_newsBulletinDlg.setVisible(true);
        if (!this.m_newsBulletinDlg.m_rc) {
            return;
        }
        if (this.m_newsBulletinDlg.m_subscribe) {
            this.m_client.reqNewsBulletins(this.m_newsBulletinDlg.m_allMsgs);
        } else {
            this.m_client.cancelNewsBulletins();
        }
    }

    void onCalculateImpliedVolatility() {
        this.m_orderDlg.show();
        if (!this.m_orderDlg.m_rc) {
            return;
        }
        this.m_client.calculateImpliedVolatility(this.m_orderDlg.m_id, this.m_orderDlg.m_contract, this.m_orderDlg.m_order.m_lmtPrice, this.m_orderDlg.m_order.m_auxPrice);
    }

    void onCancelCalculateImpliedVolatility() {
        this.m_orderDlg.show();
        if (!this.m_orderDlg.m_rc) {
            return;
        }
        this.m_client.cancelCalculateImpliedVolatility(this.m_orderDlg.m_id);
    }

    void onCalculateOptionPrice() {
        this.m_orderDlg.show();
        if (!this.m_orderDlg.m_rc) {
            return;
        }
        this.m_client.calculateOptionPrice(this.m_orderDlg.m_id, this.m_orderDlg.m_contract, this.m_orderDlg.m_order.m_lmtPrice, this.m_orderDlg.m_order.m_auxPrice);
    }

    void onCancelCalculateOptionPrice() {
        this.m_orderDlg.show();
        if (!this.m_orderDlg.m_rc) {
            return;
        }
        this.m_client.cancelCalculateOptionPrice(this.m_orderDlg.m_id);
    }

    void onGlobalCancel() {
        this.m_client.reqGlobalCancel();
    }

    void onReqMarketDataType() {
        this.m_orderDlg.show();
        if (!this.m_orderDlg.m_rc) {
            return;
        }
        this.m_client.reqMarketDataType(this.m_orderDlg.m_marketDataType);
    }

    public void tickPrice(int n, int n2, double d, int n3) {
        String string = EWrapperMsgGenerator.tickPrice(n, n2, d, n3);
        this.m_tickers.add(string);
    }

    public void tickOptionComputation(int n, int n2, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        String string = EWrapperMsgGenerator.tickOptionComputation(n, n2, d, d2, d3, d4, d5, d6, d7, d8);
        this.m_tickers.add(string);
    }

    public void tickSize(int n, int n2, int n3) {
        String string = EWrapperMsgGenerator.tickSize(n, n2, n3);
        this.m_tickers.add(string);
    }

    public void tickGeneric(int n, int n2, double d) {
        String string = EWrapperMsgGenerator.tickGeneric(n, n2, d);
        this.m_tickers.add(string);
    }

    public void tickString(int n, int n2, String string) {
        String string2 = EWrapperMsgGenerator.tickString(n, n2, string);
        this.m_tickers.add(string2);
    }

    public void tickSnapshotEnd(int n) {
        String string = EWrapperMsgGenerator.tickSnapshotEnd(n);
        this.m_tickers.add(string);
    }

    public void tickEFP(int n, int n2, double d, String string, double d2, int n3, String string2, double d3, double d4) {
        String string3 = EWrapperMsgGenerator.tickEFP(n, n2, d, string, d2, n3, string2, d3, d4);
        this.m_tickers.add(string3);
    }

    public void orderStatus(int n, String string, int n2, int n3, double d, int n4, int n5, double d2, int n6, String string2) {
        String string3 = EWrapperMsgGenerator.orderStatus(n, string, n2, n3, d, n4, n5, d2, n6, string2);
        this.m_TWS.add(string3);
        this.m_orderDlg.setIdAtLeast(n + 1);
    }

    public void openOrder(int n, Contract contract, Order order, OrderState orderState) {
        String string = EWrapperMsgGenerator.openOrder(n, contract, order, orderState);
        this.m_TWS.add(string);
    }

    public void openOrderEnd() {
        String string = EWrapperMsgGenerator.openOrderEnd();
        this.m_TWS.add(string);
    }

    public void contractDetails(int n, ContractDetails contractDetails) {
        String string = EWrapperMsgGenerator.contractDetails(n, contractDetails);
        this.m_TWS.add(string);
    }

    public void contractDetailsEnd(int n) {
        String string = EWrapperMsgGenerator.contractDetailsEnd(n);
        this.m_TWS.add(string);
    }

    public void scannerData(int n, int n2, ContractDetails contractDetails, String string, String string2, String string3, String string4) {
        String string5 = EWrapperMsgGenerator.scannerData(n, n2, contractDetails, string, string2, string3, string4);
        this.m_tickers.add(string5);
    }

    public void scannerDataEnd(int n) {
        String string = EWrapperMsgGenerator.scannerDataEnd(n);
        this.m_tickers.add(string);
    }

    public void bondContractDetails(int n, ContractDetails contractDetails) {
        String string = EWrapperMsgGenerator.bondContractDetails(n, contractDetails);
        this.m_TWS.add(string);
    }

    public void execDetails(int n, Contract contract, Execution execution) {
        String string = EWrapperMsgGenerator.execDetails(n, contract, execution);
        this.m_TWS.add(string);
    }

    public void execDetailsEnd(int n) {
        String string = EWrapperMsgGenerator.execDetailsEnd(n);
        this.m_TWS.add(string);
    }

    public void updateMktDepth(int n, int n2, int n3, int n4, double d, int n5) {
        MktDepthDlg mktDepthDlg = this.m_mapRequestToMktDepthDlg.get(n);
        if (mktDepthDlg != null) {
            mktDepthDlg.updateMktDepth(n, n2, "", n3, n4, d, n5);
        } else {
            System.err.println("cannot find dialog that corresponds to request id [" + n + "]");
        }
    }

    public void updateMktDepthL2(int n, int n2, String string, int n3, int n4, double d, int n5) {
        MktDepthDlg mktDepthDlg = this.m_mapRequestToMktDepthDlg.get(n);
        if (mktDepthDlg != null) {
            mktDepthDlg.updateMktDepth(n, n2, string, n3, n4, d, n5);
        } else {
            System.err.println("cannot find dialog that corresponds to request id [" + n + "]");
        }
    }

    public void nextValidId(int n) {
        String string = EWrapperMsgGenerator.nextValidId(n);
        this.m_TWS.add(string);
        this.m_orderDlg.setIdAtLeast(n);
    }

    public void error(Exception exception) {
        if (!this.m_disconnectInProgress) {
            String string = EWrapperMsgGenerator.error(exception);
            Main.inform(this, string);
        }
    }

    public void error(String string) {
        String string2 = EWrapperMsgGenerator.error(string);
        this.m_errors.add(string2);
    }

    public void error(int n, int n2, String string) {
        String string2 = EWrapperMsgGenerator.error(n, n2, string);
        this.m_errors.add(string2);
        for (int i = 0; i < this.faErrorCodes.length; ++i) {
            this.faError |= n2 == this.faErrorCodes[i];
        }
        if (n2 == 317) {
            MktDepthDlg mktDepthDlg = this.m_mapRequestToMktDepthDlg.get(n);
            if (mktDepthDlg != null) {
                mktDepthDlg.reset();
            } else {
                System.err.println("cannot find dialog that corresponds to request id [" + n + "]");
            }
        }
    }

    public void connectionClosed() {
        String string = EWrapperMsgGenerator.connectionClosed();
        Main.inform(this, string);
    }

    public void updateAccountValue(String string, String string2, String string3, String string4) {
        this.m_acctDlg.updateAccountValue(string, string2, string3, string4);
    }

    public void updatePortfolio(Contract contract, int n, double d, double d2, double d3, double d4, double d5, String string) {
        this.m_acctDlg.updatePortfolio(contract, n, d, d2, d3, d4, d5, string);
    }

    public void updateAccountTime(String string) {
        this.m_acctDlg.updateAccountTime(string);
    }

    public void accountDownloadEnd(String string) {
        this.m_acctDlg.accountDownloadEnd(string);
        String string2 = EWrapperMsgGenerator.accountDownloadEnd(string);
        this.m_TWS.add(string2);
    }

    public void updateNewsBulletin(int n, int n2, String string, String string2) {
        String string3 = EWrapperMsgGenerator.updateNewsBulletin(n, n2, string, string2);
        JOptionPane.showMessageDialog(this, string3, "IB News Bulletin", 1);
    }

    public void managedAccounts(String string) {
        this.m_bIsFAAccount = true;
        this.m_FAAcctCodes = string;
        String string2 = EWrapperMsgGenerator.managedAccounts(string);
        this.m_TWS.add(string2);
    }

    public void historicalData(int n, String string, double d, double d2, double d3, double d4, int n2, int n3, double d5, boolean bl) {
        String string2 = EWrapperMsgGenerator.historicalData(n, string, d, d2, d3, d4, n2, n3, d5, bl);
        this.m_tickers.add(string2);
    }

    public void realtimeBar(int n, long l, double d, double d2, double d3, double d4, long l2, double d5, int n2) {
        String string = EWrapperMsgGenerator.realtimeBar(n, l, d, d2, d3, d4, l2, d5, n2);
        this.m_tickers.add(string);
    }

    public void scannerParameters(String string) {
        this.displayXML("SCANNER PARAMETERS:", string);
    }

    public void currentTime(long l) {
        String string = EWrapperMsgGenerator.currentTime(l);
        this.m_TWS.add(string);
    }

    public void fundamentalData(int n, String string) {
        String string2 = EWrapperMsgGenerator.fundamentalData(n, string);
        this.m_tickers.add(string2);
    }

    public void deltaNeutralValidation(int n, UnderComp underComp) {
        String string = EWrapperMsgGenerator.deltaNeutralValidation(n, underComp);
        this.m_TWS.add(string);
    }

    void displayXML(String string, String string2) {
        this.m_TWS.add(string);
        this.m_TWS.addText(string2);
    }

    public void receiveFA(int n, String string) {
        this.displayXML("FA: " + EClientSocket.faMsgTypeName(n), string);
        switch (n) {
            case 1: {
                this.faGroupXML = string;
                break;
            }
            case 2: {
                this.faProfilesXML = string;
                break;
            }
            case 3: {
                this.faAliasesXML = string;
            }
        }
        if (!this.faError && this.faGroupXML != null && this.faProfilesXML != null && this.faAliasesXML != null) {
            FinancialAdvisorDlg financialAdvisorDlg = new FinancialAdvisorDlg(this);
            financialAdvisorDlg.receiveInitialXML(this.faGroupXML, this.faProfilesXML, this.faAliasesXML);
            financialAdvisorDlg.setVisible(true);
            if (!financialAdvisorDlg.m_rc) {
                return;
            }
            this.m_client.replaceFA(1, financialAdvisorDlg.groupsXML);
            this.m_client.replaceFA(2, financialAdvisorDlg.profilesXML);
            this.m_client.replaceFA(3, financialAdvisorDlg.aliasesXML);
        }
    }

    public void marketDataType(int n, int n2) {
        String string = EWrapperMsgGenerator.marketDataType(n, n2);
        this.m_tickers.add(string);
    }

    public void commissionReport(CommissionReport commissionReport) {
        String string = EWrapperMsgGenerator.commissionReport(commissionReport);
        this.m_TWS.add(string);
    }

    private void copyExtendedOrderDetails(Order order, Order order2) {
        order.m_tif = order2.m_tif;
        order.m_ocaGroup = order2.m_ocaGroup;
        order.m_ocaType = order2.m_ocaType;
        order.m_openClose = order2.m_openClose;
        order.m_origin = order2.m_origin;
        order.m_orderRef = order2.m_orderRef;
        order.m_transmit = order2.m_transmit;
        order.m_parentId = order2.m_parentId;
        order.m_blockOrder = order2.m_blockOrder;
        order.m_sweepToFill = order2.m_sweepToFill;
        order.m_displaySize = order2.m_displaySize;
        order.m_triggerMethod = order2.m_triggerMethod;
        order.m_outsideRth = order2.m_outsideRth;
        order.m_hidden = order2.m_hidden;
        order.m_discretionaryAmt = order2.m_discretionaryAmt;
        order.m_goodAfterTime = order2.m_goodAfterTime;
        order.m_shortSaleSlot = order2.m_shortSaleSlot;
        order.m_designatedLocation = order2.m_designatedLocation;
        order.m_exemptCode = order2.m_exemptCode;
        order.m_ocaType = order2.m_ocaType;
        order.m_rule80A = order2.m_rule80A;
        order.m_allOrNone = order2.m_allOrNone;
        order.m_minQty = order2.m_minQty;
        order.m_percentOffset = order2.m_percentOffset;
        order.m_eTradeOnly = order2.m_eTradeOnly;
        order.m_firmQuoteOnly = order2.m_firmQuoteOnly;
        order.m_nbboPriceCap = order2.m_nbboPriceCap;
        order.m_optOutSmartRouting = order2.m_optOutSmartRouting;
        order.m_auctionStrategy = order2.m_auctionStrategy;
        order.m_startingPrice = order2.m_startingPrice;
        order.m_stockRefPrice = order2.m_stockRefPrice;
        order.m_delta = order2.m_delta;
        order.m_stockRangeLower = order2.m_stockRangeLower;
        order.m_stockRangeUpper = order2.m_stockRangeUpper;
        order.m_overridePercentageConstraints = order2.m_overridePercentageConstraints;
        order.m_volatility = order2.m_volatility;
        order.m_volatilityType = order2.m_volatilityType;
        order.m_deltaNeutralOrderType = order2.m_deltaNeutralOrderType;
        order.m_deltaNeutralAuxPrice = order2.m_deltaNeutralAuxPrice;
        order.m_deltaNeutralConId = order2.m_deltaNeutralConId;
        order.m_deltaNeutralSettlingFirm = order2.m_deltaNeutralSettlingFirm;
        order.m_deltaNeutralClearingAccount = order2.m_deltaNeutralClearingAccount;
        order.m_deltaNeutralClearingIntent = order2.m_deltaNeutralClearingIntent;
        order.m_deltaNeutralOpenClose = order2.m_deltaNeutralOpenClose;
        order.m_deltaNeutralShortSale = order2.m_deltaNeutralShortSale;
        order.m_deltaNeutralShortSaleSlot = order2.m_deltaNeutralShortSaleSlot;
        order.m_deltaNeutralDesignatedLocation = order2.m_deltaNeutralDesignatedLocation;
        order.m_continuousUpdate = order2.m_continuousUpdate;
        order.m_referencePriceType = order2.m_referencePriceType;
        order.m_trailStopPrice = order2.m_trailStopPrice;
        order.m_trailingPercent = order2.m_trailingPercent;
        order.m_scaleInitLevelSize = order2.m_scaleInitLevelSize;
        order.m_scaleSubsLevelSize = order2.m_scaleSubsLevelSize;
        order.m_scalePriceIncrement = order2.m_scalePriceIncrement;
        order.m_scalePriceAdjustValue = order2.m_scalePriceAdjustValue;
        order.m_scalePriceAdjustInterval = order2.m_scalePriceAdjustInterval;
        order.m_scaleProfitOffset = order2.m_scaleProfitOffset;
        order.m_scaleAutoReset = order2.m_scaleAutoReset;
        order.m_scaleInitPosition = order2.m_scaleInitPosition;
        order.m_scaleInitFillQty = order2.m_scaleInitFillQty;
        order.m_scaleRandomPercent = order2.m_scaleRandomPercent;
        order.m_hedgeType = order2.m_hedgeType;
        order.m_hedgeParam = order2.m_hedgeParam;
        order.m_account = order2.m_account;
        order.m_settlingFirm = order2.m_settlingFirm;
        order.m_clearingAccount = order2.m_clearingAccount;
        order.m_clearingIntent = order2.m_clearingIntent;
    }
}

