/*
 * Decompiled with CFR 0.152.
 */
package TestJavaClient;

import com.ib.client.Contract;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

class PortfolioTable
extends AbstractTableModel {
    Vector m_allData = new Vector();

    PortfolioTable() {
    }

    void updatePortfolio(Contract contract, int n, double d, double d2, double d3, double d4, double d5, String string) {
        PortfolioTableRow portfolioTableRow = new PortfolioTableRow(contract, n, d, d2, d3, d4, d5, string);
        int n2 = this.m_allData.size();
        for (int i = 0; i < n2; ++i) {
            PortfolioTableRow portfolioTableRow2 = (PortfolioTableRow)this.m_allData.get(i);
            if (!portfolioTableRow2.m_contract.equals(portfolioTableRow.m_contract)) continue;
            if (portfolioTableRow.m_position == 0) {
                this.m_allData.remove(i);
            } else {
                this.m_allData.set(i, portfolioTableRow);
            }
            this.fireTableDataChanged();
            return;
        }
        this.m_allData.add(portfolioTableRow);
        this.fireTableDataChanged();
    }

    void reset() {
        this.m_allData.clear();
    }

    public int getRowCount() {
        return this.m_allData.size();
    }

    public int getColumnCount() {
        return 13;
    }

    public Object getValueAt(int n, int n2) {
        return ((PortfolioTableRow)this.m_allData.get(n)).getValue(n2);
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return "Symbol";
            }
            case 1: {
                return "SecType";
            }
            case 2: {
                return "Expiry";
            }
            case 3: {
                return "Strike";
            }
            case 4: {
                return "Right";
            }
            case 5: {
                return "Multiplier";
            }
            case 6: {
                return "Exchange";
            }
            case 7: {
                return "Currency";
            }
            case 8: {
                return "Position";
            }
            case 9: {
                return "Market Price";
            }
            case 10: {
                return "Market Value";
            }
            case 11: {
                return "Average Cost";
            }
            case 12: {
                return "Unrealized P&L";
            }
            case 13: {
                return "Realized P&L";
            }
            case 14: {
                return "Account Name";
            }
        }
        return null;
    }

    class PortfolioTableRow {
        Contract m_contract;
        int m_position;
        double m_marketPrice;
        double m_marketValue;
        double m_averageCost;
        double m_unrealizedPNL;
        double m_realizedPNL;
        String m_accountName;

        PortfolioTableRow(Contract contract, int n, double d, double d2, double d3, double d4, double d5, String string) {
            this.m_contract = contract;
            this.m_position = n;
            this.m_marketPrice = d;
            this.m_marketValue = d2;
            this.m_averageCost = d3;
            this.m_unrealizedPNL = d4;
            this.m_realizedPNL = d5;
            this.m_accountName = string;
        }

        Object getValue(int n) {
            switch (n) {
                case 0: {
                    return this.m_contract.m_symbol;
                }
                case 1: {
                    return this.m_contract.m_secType;
                }
                case 2: {
                    return this.m_contract.m_expiry;
                }
                case 3: {
                    return this.m_contract.m_expiry == null ? null : "" + this.m_contract.m_strike;
                }
                case 4: {
                    return this.m_contract.m_right != null && this.m_contract.m_right.equals("???") ? null : this.m_contract.m_right;
                }
                case 5: {
                    return this.m_contract.m_multiplier;
                }
                case 6: {
                    return this.m_contract.m_primaryExch != null ? this.m_contract.m_primaryExch : "";
                }
                case 7: {
                    return this.m_contract.m_currency;
                }
                case 8: {
                    return "" + this.m_position;
                }
                case 9: {
                    return "" + this.m_marketPrice;
                }
                case 10: {
                    return "" + this.m_marketValue;
                }
                case 11: {
                    return "" + this.m_averageCost;
                }
                case 12: {
                    return "" + this.m_unrealizedPNL;
                }
                case 13: {
                    return "" + this.m_realizedPNL;
                }
                case 14: {
                    return this.m_accountName;
                }
            }
            return null;
        }
    }
}

