/*
 * Decompiled with CFR 0.152.
 */
package TestJavaClient;

import TestJavaClient.MktDepthModel;
import com.ib.client.EClientSocket;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;

public class MktDepthDlg
extends JDialog {
    static final int OPERATION_INSERT = 0;
    static final int OPERATION_UPDATE = 1;
    static final int OPERATION_DELETE = 2;
    static final int SIDE_ASK = 0;
    static final int SIDE_BID = 1;
    static final int MKT_DEPTH_DATA_RESET = 317;
    private JButton m_close = new JButton("Close");
    private MktDepthModel m_bidModel = new MktDepthModel();
    private MktDepthModel m_askModel = new MktDepthModel();
    private EClientSocket m_client;
    private int m_id;

    public MktDepthDlg(String string, JFrame jFrame) {
        super(jFrame, string, false);
        JScrollPane jScrollPane = new JScrollPane(new JTable(this.m_bidModel));
        JScrollPane jScrollPane2 = new JScrollPane(new JTable(this.m_askModel));
        jScrollPane.setBorder(BorderFactory.createTitledBorder("Bid"));
        jScrollPane2.setBorder(BorderFactory.createTitledBorder("Ask"));
        JSplitPane jSplitPane = new JSplitPane(1, jScrollPane, jScrollPane2);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setDividerLocation(300);
        jSplitPane.setPreferredSize(new Dimension(600, 380));
        JPanel jPanel = new JPanel();
        jPanel.add(this.m_close);
        this.m_close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MktDepthDlg.this.onClose();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                MktDepthDlg.this.onClose();
            }
        });
        this.getContentPane().add((Component)jSplitPane, "Center");
        this.getContentPane().add((Component)jPanel, "South");
        this.setLocation(20, 20);
        this.pack();
        this.reset();
    }

    void setParams(EClientSocket eClientSocket, int n) {
        this.m_client = eClientSocket;
        this.m_id = n;
        this.reset();
    }

    void updateMktDepth(int n, int n2, String string, int n3, int n4, double d, int n5) {
        try {
            MktDepthModel.MktDepthTableRow mktDepthTableRow = null;
            if (n3 == 0) {
                if (n4 == 1) {
                    this.m_bidModel.addOrderAt(n2, string, d, n5);
                } else {
                    this.m_askModel.addOrderAt(n2, string, d, n5);
                }
            } else if (n3 == 1) {
                if (n4 == 1) {
                    mktDepthTableRow = this.m_bidModel.getOrderAt(n2);
                    if (mktDepthTableRow != null) {
                        mktDepthTableRow.m_marketMaker = string;
                        mktDepthTableRow.m_price = d;
                        mktDepthTableRow.m_size = n5;
                    }
                    this.m_bidModel.fireTableRowsUpdated(n2, n2);
                } else {
                    mktDepthTableRow = this.m_askModel.getOrderAt(n2);
                    if (mktDepthTableRow != null) {
                        mktDepthTableRow.m_marketMaker = string;
                        mktDepthTableRow.m_price = d;
                        mktDepthTableRow.m_size = n5;
                    }
                    this.m_askModel.fireTableRowsUpdated(n2, n2);
                }
            } else if (n3 == 2) {
                if (n4 == 1) {
                    this.m_bidModel.removeOrderAt(n2);
                } else {
                    this.m_askModel.removeOrderAt(n2);
                }
            }
            if (n4 == 1) {
                this.m_bidModel.updateCumSizesAndAvgPrices(n2);
            } else {
                this.m_askModel.updateCumSizesAndAvgPrices(n2);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.getMessage());
        }
    }

    void reset() {
        this.m_bidModel.reset();
        this.m_askModel.reset();
    }

    void onClose() {
        this.m_client.cancelMktDepth(this.m_id);
        this.setVisible(false);
    }
}

