/*
 * Decompiled with CFR 0.152.
 */
package TestJavaClient;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

class IBTextPanel
extends JPanel {
    public static final Color textBackgroundColor = new Color(5, 5, 5);
    public static final Color textForegroundColor = new Color(0, 245, 0);
    public static final Font textComponentFont = new JList().getFont();
    public static final Color textCaretColor = Color.WHITE;
    public static final String lineSeparator = System.getProperty("line.separator");
    private JTextArea m_textArea = new JTextArea();
    private JScrollPane m_scrollPane = new JScrollPane(this.m_textArea);
    private static final String CRLF = "\r\n";
    private static final String LF = "\n";
    private static final String TAB = "\t";
    private static final String EIGHT_SPACES = "        ";
    private static final String EMPTY_STRING = "";

    IBTextPanel() {
        this((String)null, false);
    }

    IBTextPanel(String string, boolean bl) {
        super(new BorderLayout());
        if (string != null) {
            TitledBorder titledBorder = BorderFactory.createTitledBorder(string);
            this.setBorder(titledBorder);
        }
        this.m_textArea.setBackground(textBackgroundColor);
        this.m_textArea.setForeground(textForegroundColor);
        this.m_textArea.setFont(textComponentFont);
        this.m_textArea.setCaretColor(textCaretColor);
        this.m_textArea.setEditable(bl);
        this.add(this.m_scrollPane);
    }

    public void clear() {
        this.m_textArea.setText(EMPTY_STRING);
    }

    public void setText(String string) {
        this.m_textArea.setText(string);
        if (this.m_textArea.isEditable()) {
            this.moveCursorToBeginning();
        } else {
            this.moveCursorToEnd();
        }
    }

    public void setTextDetabbed(String string) {
        this.m_textArea.setText(this.detabbed(string));
    }

    public String getText() {
        return this.m_textArea.getText();
    }

    public void add(String string) {
        this.m_textArea.append(string + lineSeparator);
        this.moveCursorToEnd();
    }

    public void moveCursorToEnd() {
        this.m_textArea.setCaretPosition(this.m_textArea.getText().length());
    }

    public void moveCursorToBeginning() {
        this.m_textArea.setCaretPosition(0);
    }

    public void add(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add((String)iterator.next());
        }
    }

    public void addText(String string) {
        this.add(IBTextPanel.tokenizedIntoArrayList(this.detabbed(string), LF));
    }

    public static ArrayList tokenizedIntoArrayList(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            arrayList.add(string3);
        }
        return arrayList;
    }

    private String detabbed(String string) {
        return string.replaceAll(TAB, EIGHT_SPACES);
    }
}

