/*
 * Decompiled with CFR 0.152.
 */
package TestJavaClient;

import com.ib.client.ComboLeg;
import com.ib.client.OrderComboLeg;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

class ComboLegModel
extends AbstractTableModel {
    private Vector m_comboLegData = new Vector();
    private Vector m_orderComboLegData = new Vector();

    ComboLegModel() {
    }

    public synchronized void addComboLeg(ComboLeg comboLeg, OrderComboLeg orderComboLeg) {
        this.m_comboLegData.add(comboLeg);
        this.m_orderComboLegData.add(orderComboLeg);
        this.fireTableDataChanged();
    }

    public synchronized void removeComboLeg(int n) {
        this.m_comboLegData.remove(n);
        this.m_orderComboLegData.remove(n);
        this.fireTableDataChanged();
    }

    public synchronized void removeComboLeg(ComboLeg comboLeg) {
        for (int i = 0; i < this.m_comboLegData.size(); ++i) {
            if (!comboLeg.equals((ComboLeg)this.m_comboLegData.get(i))) continue;
            this.m_comboLegData.remove(i);
            this.m_orderComboLegData.remove(i);
            break;
        }
        this.fireTableDataChanged();
    }

    public synchronized void reset() {
        this.m_comboLegData.removeAllElements();
        this.m_orderComboLegData.removeAllElements();
        this.fireTableDataChanged();
    }

    public synchronized int getRowCount() {
        return this.m_comboLegData.size();
    }

    public synchronized int getColumnCount() {
        return 9;
    }

    public synchronized Object getValueAt(int n, int n2) {
        ComboLeg comboLeg = (ComboLeg)this.m_comboLegData.get(n);
        OrderComboLeg orderComboLeg = (OrderComboLeg)this.m_orderComboLegData.get(n);
        switch (n2) {
            case 0: {
                return Integer.toString(comboLeg.m_conId);
            }
            case 1: {
                return Integer.toString(comboLeg.m_ratio);
            }
            case 2: {
                return comboLeg.m_action;
            }
            case 3: {
                return comboLeg.m_exchange;
            }
            case 4: {
                return Integer.toString(comboLeg.m_openClose);
            }
            case 5: {
                return Integer.toString(comboLeg.m_shortSaleSlot);
            }
            case 6: {
                return comboLeg.m_designatedLocation;
            }
            case 7: {
                return Integer.toString(comboLeg.m_exemptCode);
            }
            case 8: {
                return this.parseMaxDoubleToString(orderComboLeg.m_price);
            }
        }
        return "";
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return "ConId";
            }
            case 1: {
                return "Ratio";
            }
            case 2: {
                return "Side";
            }
            case 3: {
                return "Exchange";
            }
            case 4: {
                return "Open/Close";
            }
            case 5: {
                return "Short Sale Slot";
            }
            case 6: {
                return "Designated Location";
            }
            case 7: {
                return "Exempt Code";
            }
            case 8: {
                return "Price";
            }
        }
        return null;
    }

    public Vector comboLegData() {
        return this.m_comboLegData;
    }

    public Vector orderComboLegData() {
        return this.m_orderComboLegData;
    }

    private String parseMaxDoubleToString(double d) {
        return d == Double.MAX_VALUE ? "" : String.valueOf(d);
    }
}

