/*
 * Decompiled with CFR 0.152.
 */
package TestJavaClient;

import TestJavaClient.AlgoParamModel;
import TestJavaClient.Main;
import com.ib.client.Order;
import com.ib.client.TagValue;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;

public class AlgoParamsDlg
extends JDialog {
    private Order m_order;
    private JTextField m_algoStrategy = new JTextField("");
    private Vector m_algoParams;
    private JTextField m_tag = new JTextField("");
    private JTextField m_value = new JTextField("");
    private JButton m_addParam = new JButton("Add");
    private JButton m_removeParam = new JButton("Remove");
    private JButton m_ok = new JButton("OK");
    private JButton m_cancel = new JButton("Cancel");
    private AlgoParamModel m_paramModel = new AlgoParamModel();
    private JTable m_paramTable = new JTable(this.m_paramModel);
    private JScrollPane m_paramPane = new JScrollPane(this.m_paramTable);

    public AlgoParamModel paramModel() {
        return this.m_paramModel;
    }

    public AlgoParamsDlg(Order order, JDialog jDialog) {
        super((Dialog)jDialog, true);
        this.m_order = order;
        this.setTitle("Algo Order Parameters");
        JPanel jPanel = new JPanel(new GridLayout(0, 2, 10, 10));
        jPanel.setBorder(BorderFactory.createTitledBorder("Algorithm"));
        jPanel.add(new JLabel("Strategy:"));
        this.m_algoStrategy.setText(this.m_order.m_algoStrategy);
        jPanel.add(this.m_algoStrategy);
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 10, 10));
        jPanel2.setBorder(BorderFactory.createTitledBorder("Parameters"));
        Vector<TagValue> vector = this.m_order.m_algoParams;
        if (vector != null) {
            this.m_paramModel.algoParams().addAll(vector);
        }
        jPanel2.add(this.m_paramPane);
        JPanel jPanel3 = new JPanel(new GridLayout(0, 2, 10, 10));
        jPanel3.setBorder(BorderFactory.createTitledBorder("Add / Remove"));
        jPanel3.add(new JLabel("Param:"));
        jPanel3.add(this.m_tag);
        jPanel3.add(new JLabel("Value:"));
        jPanel3.add(this.m_value);
        jPanel3.add(this.m_addParam);
        jPanel3.add(this.m_removeParam);
        JPanel jPanel4 = new JPanel();
        jPanel4.add(this.m_ok);
        jPanel4.add(this.m_cancel);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        jPanel5.add(jPanel);
        jPanel5.add(jPanel2);
        jPanel5.add(jPanel3);
        this.getContentPane().add((Component)jPanel5, "Center");
        this.getContentPane().add((Component)jPanel4, "South");
        this.m_addParam.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AlgoParamsDlg.this.onAddParam();
            }
        });
        this.m_removeParam.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AlgoParamsDlg.this.onRemoveParam();
            }
        });
        this.m_ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AlgoParamsDlg.this.onOk();
            }
        });
        this.m_cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AlgoParamsDlg.this.onCancel();
            }
        });
        this.setSize(250, 600);
        this.centerOnOwner(this);
    }

    public void onAddParam() {
        try {
            String string = this.m_tag.getText();
            String string2 = this.m_value.getText();
            this.m_paramModel.addParam(new TagValue(string, string2));
        }
        catch (Exception exception) {
            this.reportError("Error - ", exception);
            return;
        }
    }

    public void onRemoveParam() {
        try {
            if (this.m_paramTable.getSelectedRowCount() != 0) {
                int[] nArray = this.m_paramTable.getSelectedRows();
                for (int i = nArray.length - 1; i >= 0; --i) {
                    this.m_paramModel.removeParam(nArray[i]);
                }
            }
        }
        catch (Exception exception) {
            this.reportError("Error - ", exception);
            return;
        }
    }

    void onOk() {
        this.m_order.m_algoStrategy = this.m_algoStrategy.getText();
        Vector vector = this.m_paramModel.algoParams();
        this.m_order.m_algoParams = vector.isEmpty() ? null : vector;
        this.setVisible(false);
    }

    void onCancel() {
        this.setVisible(false);
    }

    void reportError(String string, Exception exception) {
        Main.inform(this, string + " --" + exception);
    }

    private void centerOnOwner(Window window) {
        Window window2 = window.getOwner();
        if (window2 == null) {
            return;
        }
        int n = window2.getX() + (window2.getWidth() - window.getWidth()) / 2;
        int n2 = window2.getY() + (window2.getHeight() - window.getHeight()) / 2;
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        window.setLocation(n, n2);
    }
}

