/*
 * Decompiled with CFR 0.152.
 */
package com.hystrix.configurator.core;

import com.hystrix.configurator.config.CommandThreadPoolConfig;
import com.hystrix.configurator.config.HystrixCommandConfig;
import com.hystrix.configurator.config.HystrixConfig;
import com.hystrix.configurator.config.HystrixDefaultConfig;
import com.hystrix.configurator.config.ThreadPoolConfig;
import com.netflix.config.ConfigurationManager;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HystrixConfigurationFactory {
    private static final Logger log = LoggerFactory.getLogger(HystrixConfigurationFactory.class);
    private final HystrixConfig config;
    private HystrixDefaultConfig defaultConfig;
    private ConcurrentHashMap<String, HystrixCommand.Setter> commandCache;
    private ConcurrentHashMap<String, HystrixThreadPoolProperties.Setter> poolCache;
    private static HystrixConfigurationFactory factory;

    private HystrixConfigurationFactory(HystrixConfig config) {
        this.config = config;
    }

    public static void init(HystrixConfig config) {
        factory = new HystrixConfigurationFactory(config);
        factory.setup();
    }

    private void setup() {
        this.validateUniqueCommands(this.config);
        this.defaultConfig = this.config.getDefaultConfig();
        this.commandCache = new ConcurrentHashMap();
        this.poolCache = new ConcurrentHashMap();
        this.registerDefaultProperties(this.defaultConfig);
        if (this.config.getPools() != null) {
            this.config.getPools().forEach((pool, poolConfig) -> this.configureThreadPoolIfMissing(this.globalPoolId((String)pool), (ThreadPoolConfig)poolConfig));
        }
        this.config.getCommands().forEach(commandConfig -> {
            if (commandConfig.getCircuitBreaker() == null) {
                commandConfig.setCircuitBreaker(this.defaultConfig.getCircuitBreaker());
            }
            if (commandConfig.getMetrics() == null) {
                commandConfig.setMetrics(this.defaultConfig.getMetrics());
            }
            if (commandConfig.getThreadPool() == null) {
                commandConfig.setThreadPool(this.defaultConfig.getThreadPool());
            }
            this.registerCommandProperties(this.defaultConfig, (HystrixCommandConfig)commandConfig);
            log.info("registered command: {}", (Object)commandConfig.getName());
        });
    }

    private String globalPoolId(String pool) {
        return String.format("global_%s", pool);
    }

    private String commandPoolId(String commandName) {
        return String.format("command_%s", commandName);
    }

    private void registerDefaultProperties(HystrixDefaultConfig defaultConfig) {
        this.configureProperty("hystrix.timer.threadpool.default.coreSize", defaultConfig.getTimer().getConcurrency());
        this.configureProperty("hystrix.threadpool.default.coreSize", defaultConfig.getThreadPool().getConcurrency());
        this.configureProperty("hystrix.threadpool.default.maxQueueSize", defaultConfig.getThreadPool().getMaxRequestQueueSize());
        this.configureProperty("hystrix.threadpool.default.queueSizeRejectionThreshold", defaultConfig.getThreadPool().getDynamicRequestQueueSize());
        this.configureProperty("hystrix.command.default.coreSize", defaultConfig.getThreadPool().getConcurrency());
        this.configureProperty("hystrix.command.default.maxQueueSize", defaultConfig.getThreadPool().getMaxRequestQueueSize());
        this.configureProperty("hystrix.command.default.queueSizeRejectionThreshold", defaultConfig.getThreadPool().getDynamicRequestQueueSize());
        this.configureProperty("hystrix.command.default.execution.isolation.strategy", "THREAD");
        this.configureProperty("hystrix.command.default.execution.thread.timeoutInMilliseconds", defaultConfig.getThreadPool().getTimeout());
        this.configureProperty("hystrix.command.default.execution.timeout.enabled", true);
        this.configureProperty("hystrix.command.default.execution.isolation.thread.interruptOnTimeout", true);
        this.configureProperty("hystrix.command.default.execution.isolation.semaphore.maxConcurrentRequests", defaultConfig.getThreadPool().getConcurrency());
        this.configureProperty("hystrix.command.default.circuitBreaker.enabled", true);
        this.configureProperty("hystrix.command.default.circuitBreaker.requestVolumeThreshold", defaultConfig.getCircuitBreaker().getAcceptableFailuresInWindow());
        this.configureProperty("hystrix.command.default.circuitBreaker.errorThresholdPercentage", defaultConfig.getCircuitBreaker().getErrorThreshold());
        this.configureProperty("hystrix.command.default.circuitBreaker.sleepWindowInMilliseconds", defaultConfig.getCircuitBreaker().getWaitTimeBeforeRetry());
        this.configureProperty("hystrix.command.default.metrics.rollingStats.timeInMilliseconds", defaultConfig.getMetrics().getStatsTimeInMillis());
        this.configureProperty("hystrix.command.default.metrics.rollingStats.numBuckets", defaultConfig.getMetrics().getNumBucketSize());
        this.configureProperty("hystrix.command.default.metrics.rollingPercentile.enabled", true);
        this.configureProperty("hystrix.command.default.metrics.rollingPercentile.timeInMilliseconds", defaultConfig.getMetrics().getPercentileTimeInMillis());
        this.configureProperty("hystrix.command.default.metrics.rollingPercentile.numBuckets", defaultConfig.getMetrics().getNumBucketSize());
        this.configureProperty("hystrix.command.default.metrics.rollingPercentile.bucketSize", defaultConfig.getMetrics().getPercentileBucketSize());
        this.configureProperty("hystrix.command.default.metrics.healthSnapshot.intervalInMilliseconds", defaultConfig.getMetrics().getHealthCheckInterval());
    }

    private void registerCommandProperties(String command) {
        HystrixCommandConfig commandConfig = HystrixCommandConfig.builder().name(command).semaphoreIsolation(false).threadPool(this.defaultConfig.getThreadPool()).metrics(this.defaultConfig.getMetrics()).circuitBreaker(this.defaultConfig.getCircuitBreaker()).fallbackEnabled(false).build();
        this.registerCommandProperties(this.defaultConfig, commandConfig);
    }

    private void registerCommandProperties(HystrixDefaultConfig defaultConfig, HystrixCommandConfig commandConfig) {
        String command = commandConfig.getName();
        boolean semaphoreIsolation = commandConfig.getThreadPool().isSemaphoreIsolation();
        HystrixCommandProperties.ExecutionIsolationStrategy isolationStrategy = semaphoreIsolation ? HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE : HystrixCommandProperties.ExecutionIsolationStrategy.THREAD;
        this.configureProperty(String.format("hystrix.command.%s.execution.isolation.strategy", command), isolationStrategy.name());
        this.configureProperty(String.format("hystrix.command.%s.execution.timeout.enabled", command), true);
        this.configureProperty(String.format("hystrix.command.%s.execution.thread.timeoutInMilliseconds", command), commandConfig.getThreadPool().getTimeout());
        this.configureProperty(String.format("hystrix.command.%s.execution.isolation.thread.interruptOnTimeout", command), true);
        if (semaphoreIsolation) {
            this.configureProperty(String.format("hystrix.command.%s.execution.isolation.semaphore.maxConcurrentRequests", command), commandConfig.getThreadPool().getConcurrency());
        }
        this.configureProperty(String.format("hystrix.command.%s.circuitBreaker.enabled", commandConfig.getName()), true);
        this.configureProperty(String.format("hystrix.command.%s.circuitBreaker.requestVolumeThreshold", commandConfig.getName()), commandConfig.getCircuitBreaker().getAcceptableFailuresInWindow());
        this.configureProperty(String.format("hystrix.command.%s.circuitBreaker.errorThresholdPercentage", commandConfig.getName()), commandConfig.getCircuitBreaker().getErrorThreshold());
        this.configureProperty(String.format("hystrix.command.%s.circuitBreaker.sleepWindowInMilliseconds", commandConfig.getName()), commandConfig.getCircuitBreaker().getWaitTimeBeforeRetry());
        this.configureProperty(String.format("hystrix.command.%s.metrics.rollingStats.timeInMilliseconds", commandConfig.getName()), commandConfig.getMetrics().getStatsTimeInMillis());
        this.configureProperty(String.format("hystrix.command.%s.metrics.rollingStats.numBuckets", commandConfig.getName()), commandConfig.getMetrics().getNumBucketSize());
        this.configureProperty(String.format("hystrix.command.%s.metrics.rollingPercentile.enabled", commandConfig.getName()), true);
        this.configureProperty(String.format("hystrix.command.%s.metrics.rollingPercentile.timeInMilliseconds", commandConfig.getName()), commandConfig.getMetrics().getPercentileTimeInMillis());
        this.configureProperty(String.format("hystrix.command.%s.metrics.rollingPercentile.numBuckets", commandConfig.getName()), commandConfig.getMetrics().getNumBucketSize());
        this.configureProperty(String.format("hystrix.command.%s.metrics.rollingPercentile.bucketSize", commandConfig.getName()), commandConfig.getMetrics().getPercentileBucketSize());
        this.configureProperty(String.format("hystrix.command.%s.metrics.healthSnapshot.intervalInMilliseconds", commandConfig.getName()), commandConfig.getMetrics().getHealthCheckInterval());
        HystrixCommandProperties.Setter commandProperties = HystrixCommandProperties.Setter().withExecutionIsolationStrategy(isolationStrategy).withFallbackEnabled(commandConfig.isFallbackEnabled()).withCircuitBreakerEnabled(true).withCircuitBreakerErrorThresholdPercentage(commandConfig.getCircuitBreaker().getErrorThreshold()).withCircuitBreakerRequestVolumeThreshold(commandConfig.getCircuitBreaker().getAcceptableFailuresInWindow()).withCircuitBreakerSleepWindowInMilliseconds(commandConfig.getCircuitBreaker().getWaitTimeBeforeRetry()).withExecutionTimeoutInMilliseconds(commandConfig.getThreadPool().getTimeout()).withMetricsHealthSnapshotIntervalInMilliseconds(commandConfig.getMetrics().getHealthCheckInterval()).withMetricsRollingPercentileBucketSize(commandConfig.getMetrics().getPercentileBucketSize()).withMetricsRollingPercentileWindowInMilliseconds(commandConfig.getMetrics().getPercentileTimeInMillis());
        if (semaphoreIsolation) {
            commandProperties.withExecutionIsolationSemaphoreMaxConcurrentRequests(commandConfig.getThreadPool().getConcurrency()).withFallbackIsolationSemaphoreMaxConcurrentRequests(commandConfig.getThreadPool().getConcurrency());
        }
        HystrixCommand.Setter commandConfiguration = HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)commandConfig.getName())).andCommandKey(HystrixCommandKey.Factory.asKey((String)commandConfig.getName())).andCommandPropertiesDefaults(commandProperties);
        if (!semaphoreIsolation) {
            String poolName;
            String globalPool = commandConfig.getThreadPool() != null ? commandConfig.getThreadPool().getPool() : null;
            String string = poolName = globalPool != null ? this.globalPoolId(globalPool) : this.commandPoolId(command);
            if (globalPool != null) {
                HystrixThreadPoolProperties.Setter poolConfiguration = this.poolCache.get(poolName);
                if (poolConfiguration == null) {
                    String message = String.format("Undefined global pool [%s] used in command [%s]", globalPool, command);
                    log.error(message);
                    throw new RuntimeException(message);
                }
            } else {
                this.configureThreadPoolIfMissing(poolName, this.toPoolConfig(commandConfig.getThreadPool()));
            }
            commandConfiguration.andThreadPoolKey(HystrixThreadPoolKey.Factory.asKey((String)poolName));
        }
        this.commandCache.put(commandConfig.getName(), commandConfiguration);
    }

    private ThreadPoolConfig toPoolConfig(CommandThreadPoolConfig threadPool) {
        return ThreadPoolConfig.builder().concurrency(threadPool.getConcurrency()).dynamicRequestQueueSize(threadPool.getDynamicRequestQueueSize()).maxRequestQueueSize(threadPool.getMaxRequestQueueSize()).build();
    }

    private void configureThreadPoolIfMissing(String poolName, ThreadPoolConfig poolConfig) {
        if (this.poolCache.containsKey(poolName)) {
            return;
        }
        this.configureProperty(String.format("hystrix.threadpool.%s.coreSize", poolName), poolConfig.getConcurrency());
        this.configureProperty(String.format("hystrix.threadpool.%s.maximumSize", poolName), poolConfig.getConcurrency());
        this.configureProperty(String.format("hystrix.threadpool.%s.maxQueueSize", poolName), poolConfig.getMaxRequestQueueSize());
        this.configureProperty(String.format("hystrix.threadpool.%s.queueSizeRejectionThreshold", poolName), poolConfig.getDynamicRequestQueueSize());
        this.poolCache.put(poolName, HystrixThreadPoolProperties.Setter().withCoreSize(poolConfig.getConcurrency()).withMaximumSize(poolConfig.getConcurrency()).withMaxQueueSize(poolConfig.getMaxRequestQueueSize()).withQueueSizeRejectionThreshold(poolConfig.getDynamicRequestQueueSize()));
    }

    private void validateUniqueCommands(HystrixConfig config) {
        if (config.getCommands() == null) {
            return;
        }
        AtomicBoolean duplicatePresent = new AtomicBoolean(false);
        config.getCommands().stream().collect(Collectors.groupingBy(HystrixCommandConfig::getName, Collectors.counting())).entrySet().stream().filter(x -> (Long)x.getValue() > 1L).forEach(x -> {
            log.warn("Duplicate command configuration for command [{}]", x.getKey());
            duplicatePresent.set(true);
        });
        if (duplicatePresent.get()) {
            throw new RuntimeException("Duplicate Hystrix Command Configurations");
        }
    }

    private void configureProperty(String property, int value) {
        ConfigurationManager.getConfigInstance().setProperty(property, (Object)value);
    }

    private void configureProperty(String property, String value) {
        ConfigurationManager.getConfigInstance().setProperty(property, (Object)value);
    }

    private void configureProperty(String property, boolean value) {
        ConfigurationManager.getConfigInstance().setProperty(property, (Object)value);
    }

    public static HystrixCommand.Setter getCommandConfiguration(String key) {
        if (factory == null) {
            throw new IllegalStateException("Factory not initialized");
        }
        if (!HystrixConfigurationFactory.factory.commandCache.containsKey(key)) {
            factory.registerCommandProperties(key);
        }
        return HystrixConfigurationFactory.factory.commandCache.get(key);
    }

    public static ConcurrentHashMap<String, HystrixCommand.Setter> getCommandCache() {
        return HystrixConfigurationFactory.factory.commandCache;
    }

    public static ConcurrentHashMap<String, HystrixThreadPoolProperties.Setter> getPoolCache() {
        return HystrixConfigurationFactory.factory.poolCache;
    }

    public HystrixDefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }
}

