/*
 * Decompiled with CFR 0.152.
 */
package com.hystrix.configurator.config;

import javax.validation.constraints.Max;

public class MetricsConfig {
    @Max(value=60000L)
    private int statsTimeInMillis = 60000;
    private int healthCheckInterval = 500;
    private int percentileTimeInMillis = 60000;
    private int percentileBucketSize = 100;
    private int numBucketSize = 100;

    public MetricsConfig(int statsTimeInMillis, int healthCheckInterval, int percentileTimeInMillis, int percentileBucketSize, int numBucketSize) {
        this.statsTimeInMillis = statsTimeInMillis;
        this.healthCheckInterval = healthCheckInterval;
        this.percentileTimeInMillis = percentileTimeInMillis;
        this.percentileBucketSize = percentileBucketSize;
        this.numBucketSize = numBucketSize;
    }

    public static MetricsConfigBuilder builder() {
        return new MetricsConfigBuilder();
    }

    public int getStatsTimeInMillis() {
        return this.statsTimeInMillis;
    }

    public int getHealthCheckInterval() {
        return this.healthCheckInterval;
    }

    public int getPercentileTimeInMillis() {
        return this.percentileTimeInMillis;
    }

    public int getPercentileBucketSize() {
        return this.percentileBucketSize;
    }

    public int getNumBucketSize() {
        return this.numBucketSize;
    }

    public void setStatsTimeInMillis(int statsTimeInMillis) {
        this.statsTimeInMillis = statsTimeInMillis;
    }

    public void setHealthCheckInterval(int healthCheckInterval) {
        this.healthCheckInterval = healthCheckInterval;
    }

    public void setPercentileTimeInMillis(int percentileTimeInMillis) {
        this.percentileTimeInMillis = percentileTimeInMillis;
    }

    public void setPercentileBucketSize(int percentileBucketSize) {
        this.percentileBucketSize = percentileBucketSize;
    }

    public void setNumBucketSize(int numBucketSize) {
        this.numBucketSize = numBucketSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetricsConfig)) {
            return false;
        }
        MetricsConfig other = (MetricsConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStatsTimeInMillis() != other.getStatsTimeInMillis()) {
            return false;
        }
        if (this.getHealthCheckInterval() != other.getHealthCheckInterval()) {
            return false;
        }
        if (this.getPercentileTimeInMillis() != other.getPercentileTimeInMillis()) {
            return false;
        }
        if (this.getPercentileBucketSize() != other.getPercentileBucketSize()) {
            return false;
        }
        return this.getNumBucketSize() == other.getNumBucketSize();
    }

    protected boolean canEqual(Object other) {
        return other instanceof MetricsConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStatsTimeInMillis();
        result = result * 59 + this.getHealthCheckInterval();
        result = result * 59 + this.getPercentileTimeInMillis();
        result = result * 59 + this.getPercentileBucketSize();
        result = result * 59 + this.getNumBucketSize();
        return result;
    }

    public String toString() {
        return "MetricsConfig(statsTimeInMillis=" + this.getStatsTimeInMillis() + ", healthCheckInterval=" + this.getHealthCheckInterval() + ", percentileTimeInMillis=" + this.getPercentileTimeInMillis() + ", percentileBucketSize=" + this.getPercentileBucketSize() + ", numBucketSize=" + this.getNumBucketSize() + ")";
    }

    public MetricsConfig() {
    }

    public static class MetricsConfigBuilder {
        private int statsTimeInMillis = 60000;
        private int healthCheckInterval = 500;
        private int percentileTimeInMillis = 60000;
        private int percentileBucketSize = 100;
        private int numBucketSize = 100;

        MetricsConfigBuilder() {
        }

        public MetricsConfigBuilder statsTimeInMillis(int statsTimeInMillis) {
            this.statsTimeInMillis = statsTimeInMillis;
            return this;
        }

        public MetricsConfigBuilder healthCheckInterval(int healthCheckInterval) {
            this.healthCheckInterval = healthCheckInterval;
            return this;
        }

        public MetricsConfigBuilder percentileTimeInMillis(int percentileTimeInMillis) {
            this.percentileTimeInMillis = percentileTimeInMillis;
            return this;
        }

        public MetricsConfigBuilder percentileBucketSize(int percentileBucketSize) {
            this.percentileBucketSize = percentileBucketSize;
            return this;
        }

        public MetricsConfigBuilder numBucketSize(int numBucketSize) {
            this.numBucketSize = numBucketSize;
            return this;
        }

        public MetricsConfig build() {
            return new MetricsConfig(this.statsTimeInMillis, this.healthCheckInterval, this.percentileTimeInMillis, this.percentileBucketSize, this.numBucketSize);
        }

        public String toString() {
            return "MetricsConfig.MetricsConfigBuilder(statsTimeInMillis=" + this.statsTimeInMillis + ", healthCheckInterval=" + this.healthCheckInterval + ", percentileTimeInMillis=" + this.percentileTimeInMillis + ", percentileBucketSize=" + this.percentileBucketSize + ", numBucketSize=" + this.numBucketSize + ")";
        }
    }
}

