/*
 * Decompiled with CFR 0.152.
 */
package com.hystrix.configurator.config;

public class ThreadPoolConfig {
    private int concurrency = 8;
    private int maxRequestQueueSize = 128;
    private int dynamicRequestQueueSize = 16;

    public ThreadPoolConfig(int concurrency, int maxRequestQueueSize, int dynamicRequestQueueSize) {
        this.concurrency = concurrency;
        this.maxRequestQueueSize = maxRequestQueueSize;
        this.dynamicRequestQueueSize = dynamicRequestQueueSize;
    }

    public static ThreadPoolConfigBuilder builder() {
        return new ThreadPoolConfigBuilder();
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    public int getMaxRequestQueueSize() {
        return this.maxRequestQueueSize;
    }

    public int getDynamicRequestQueueSize() {
        return this.dynamicRequestQueueSize;
    }

    public void setConcurrency(int concurrency) {
        this.concurrency = concurrency;
    }

    public void setMaxRequestQueueSize(int maxRequestQueueSize) {
        this.maxRequestQueueSize = maxRequestQueueSize;
    }

    public void setDynamicRequestQueueSize(int dynamicRequestQueueSize) {
        this.dynamicRequestQueueSize = dynamicRequestQueueSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ThreadPoolConfig)) {
            return false;
        }
        ThreadPoolConfig other = (ThreadPoolConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getConcurrency() != other.getConcurrency()) {
            return false;
        }
        if (this.getMaxRequestQueueSize() != other.getMaxRequestQueueSize()) {
            return false;
        }
        return this.getDynamicRequestQueueSize() == other.getDynamicRequestQueueSize();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ThreadPoolConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getConcurrency();
        result = result * 59 + this.getMaxRequestQueueSize();
        result = result * 59 + this.getDynamicRequestQueueSize();
        return result;
    }

    public String toString() {
        return "ThreadPoolConfig(concurrency=" + this.getConcurrency() + ", maxRequestQueueSize=" + this.getMaxRequestQueueSize() + ", dynamicRequestQueueSize=" + this.getDynamicRequestQueueSize() + ")";
    }

    public ThreadPoolConfig() {
    }

    public static class ThreadPoolConfigBuilder {
        private int concurrency = Runtime.getRuntime().availableProcessors();
        private int maxRequestQueueSize = Runtime.getRuntime().availableProcessors() * 4;
        private int dynamicRequestQueueSize = Runtime.getRuntime().availableProcessors() * 2;

        ThreadPoolConfigBuilder() {
        }

        public ThreadPoolConfigBuilder concurrency(int concurrency) {
            this.concurrency = concurrency;
            return this;
        }

        public ThreadPoolConfigBuilder maxRequestQueueSize(int maxRequestQueueSize) {
            this.maxRequestQueueSize = maxRequestQueueSize;
            return this;
        }

        public ThreadPoolConfigBuilder dynamicRequestQueueSize(int dynamicRequestQueueSize) {
            this.dynamicRequestQueueSize = dynamicRequestQueueSize;
            return this;
        }

        public ThreadPoolConfig build() {
            return new ThreadPoolConfig(this.concurrency, this.maxRequestQueueSize, this.dynamicRequestQueueSize);
        }

        public String toString() {
            return "ThreadPoolConfig.ThreadPoolConfigBuilder(concurrency=" + this.concurrency + ", maxRequestQueueSize=" + this.maxRequestQueueSize + ", dynamicRequestQueueSize=" + this.dynamicRequestQueueSize + ")";
        }
    }
}

