/*
 * Decompiled with CFR 0.152.
 */
package com.hystrix.configurator.config;

import com.hystrix.configurator.config.CircuitBreakerConfig;
import com.hystrix.configurator.config.CommandThreadPoolConfig;
import com.hystrix.configurator.config.MetricsConfig;

public class HystrixDefaultConfig {
    private CommandThreadPoolConfig threadPool = CommandThreadPoolConfig.builder().build();
    private CircuitBreakerConfig circuitBreaker = CircuitBreakerConfig.builder().build();
    private MetricsConfig metrics = MetricsConfig.builder().build();

    public HystrixDefaultConfig(int timeout, CommandThreadPoolConfig threadPool, CircuitBreakerConfig circuitBreaker, MetricsConfig metrics) {
        this.threadPool = threadPool;
        this.circuitBreaker = circuitBreaker;
        this.metrics = metrics;
    }

    public static HystrixDefaultConfigBuilder builder() {
        return new HystrixDefaultConfigBuilder();
    }

    public CommandThreadPoolConfig getThreadPool() {
        return this.threadPool;
    }

    public CircuitBreakerConfig getCircuitBreaker() {
        return this.circuitBreaker;
    }

    public MetricsConfig getMetrics() {
        return this.metrics;
    }

    public void setThreadPool(CommandThreadPoolConfig threadPool) {
        this.threadPool = threadPool;
    }

    public void setCircuitBreaker(CircuitBreakerConfig circuitBreaker) {
        this.circuitBreaker = circuitBreaker;
    }

    public void setMetrics(MetricsConfig metrics) {
        this.metrics = metrics;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HystrixDefaultConfig)) {
            return false;
        }
        HystrixDefaultConfig other = (HystrixDefaultConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CommandThreadPoolConfig this$threadPool = this.getThreadPool();
        CommandThreadPoolConfig other$threadPool = other.getThreadPool();
        if (this$threadPool == null ? other$threadPool != null : !((Object)this$threadPool).equals(other$threadPool)) {
            return false;
        }
        CircuitBreakerConfig this$circuitBreaker = this.getCircuitBreaker();
        CircuitBreakerConfig other$circuitBreaker = other.getCircuitBreaker();
        if (this$circuitBreaker == null ? other$circuitBreaker != null : !((Object)this$circuitBreaker).equals(other$circuitBreaker)) {
            return false;
        }
        MetricsConfig this$metrics = this.getMetrics();
        MetricsConfig other$metrics = other.getMetrics();
        return !(this$metrics == null ? other$metrics != null : !((Object)this$metrics).equals(other$metrics));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HystrixDefaultConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CommandThreadPoolConfig $threadPool = this.getThreadPool();
        result = result * 59 + ($threadPool == null ? 43 : ((Object)$threadPool).hashCode());
        CircuitBreakerConfig $circuitBreaker = this.getCircuitBreaker();
        result = result * 59 + ($circuitBreaker == null ? 43 : ((Object)$circuitBreaker).hashCode());
        MetricsConfig $metrics = this.getMetrics();
        result = result * 59 + ($metrics == null ? 43 : ((Object)$metrics).hashCode());
        return result;
    }

    public String toString() {
        return "HystrixDefaultConfig(threadPool=" + this.getThreadPool() + ", circuitBreaker=" + this.getCircuitBreaker() + ", metrics=" + this.getMetrics() + ")";
    }

    public HystrixDefaultConfig() {
    }

    public static class HystrixDefaultConfigBuilder {
        private int timeout;
        private CommandThreadPoolConfig threadPool = CommandThreadPoolConfig.builder().build();
        private CircuitBreakerConfig circuitBreaker = CircuitBreakerConfig.builder().build();
        private MetricsConfig metrics = MetricsConfig.builder().build();

        HystrixDefaultConfigBuilder() {
        }

        public HystrixDefaultConfigBuilder timeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public HystrixDefaultConfigBuilder threadPool(CommandThreadPoolConfig threadPool) {
            this.threadPool = threadPool;
            return this;
        }

        public HystrixDefaultConfigBuilder circuitBreaker(CircuitBreakerConfig circuitBreaker) {
            this.circuitBreaker = circuitBreaker;
            return this;
        }

        public HystrixDefaultConfigBuilder metrics(MetricsConfig metrics) {
            this.metrics = metrics;
            return this;
        }

        public HystrixDefaultConfig build() {
            return new HystrixDefaultConfig(this.timeout, this.threadPool, this.circuitBreaker, this.metrics);
        }

        public String toString() {
            return "HystrixDefaultConfig.HystrixDefaultConfigBuilder(timeout=" + this.timeout + ", threadPool=" + this.threadPool + ", circuitBreaker=" + this.circuitBreaker + ", metrics=" + this.metrics + ")";
        }
    }
}

