/*
 * Decompiled with CFR 0.152.
 */
package com.hystrix.configurator.core;

import com.hystrix.configurator.config.HystrixCommandConfig;
import com.hystrix.configurator.config.HystrixConfig;
import com.hystrix.configurator.config.HystrixDefaultConfig;
import com.netflix.config.ConfigurationManager;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class HystrixConfigurationFactory {
    private final HystrixConfig config;
    private HystrixDefaultConfig defaultConfig;
    private ConcurrentHashMap<String, HystrixCommand.Setter> hystrixConfigCache;
    private static HystrixConfigurationFactory factory;

    private HystrixConfigurationFactory(HystrixConfig config) {
        this.config = config;
    }

    public static void init(HystrixConfig config) {
        if (factory == null) {
            factory = new HystrixConfigurationFactory(config);
        }
        factory.setup();
    }

    private void setup() {
        if (this.config != null) {
            this.defaultConfig = this.config.getDefaultConfig();
            Map<String, HystrixCommandConfig> commandConfigMap = this.config.getCommands().stream().collect(Collectors.toMap(HystrixCommandConfig::getName, c -> c));
            commandConfigMap.forEach((k, v) -> {
                if (v.getCircuitBreaker() == null) {
                    v.setCircuitBreaker(this.defaultConfig.getCircuitBreaker());
                }
                if (v.getThreadPool() == null) {
                    v.setThreadPool(this.defaultConfig.getThreadPool());
                }
                if (v.getMetrics() == null) {
                    v.setMetrics(this.defaultConfig.getMetrics());
                }
            });
            ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.coreSize", (Object)this.defaultConfig.getThreadPool().getConcurrency());
            ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.maxQueueSize", (Object)this.defaultConfig.getThreadPool().getMaxRequestQueueSize());
            ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.queueSizeRejectionThreshold", (Object)this.defaultConfig.getThreadPool().getDynamicRequestQueueSize());
            ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.execution.isolation.strategy", (Object)(this.defaultConfig.getThreadPool().isSemaphoreIsolation() ? "SEMAPHORE" : "THREAD"));
            ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.execution.thread.timeoutInMilliseconds", (Object)this.defaultConfig.getThreadPool().getTimeout());
            ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.execution.timeout.enabled", (Object)true);
            ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.execution.isolation.thread.interruptOnTimeout", (Object)true);
            ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.execution.isolation.semaphore.maxConcurrentRequests", (Object)this.defaultConfig.getThreadPool().getConcurrency());
            ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.circuitBreaker.enabled", (Object)true);
            ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.circuitBreaker.requestVolumeThreshold", (Object)this.defaultConfig.getCircuitBreaker().getAcceptableFailuresInWindow());
            ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.circuitBreaker.errorThresholdPercentage", (Object)this.defaultConfig.getCircuitBreaker().getErrorThreshold());
            ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.circuitBreaker.sleepWindowInMilliseconds", (Object)this.defaultConfig.getCircuitBreaker().getWaitTimeBeforeRetry());
            ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.metrics.rollingStats.timeInMilliseconds", (Object)this.defaultConfig.getMetrics().getStatsTimeInMillis());
            ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.metrics.rollingStats.numBuckets", (Object)this.defaultConfig.getMetrics().getNumBucketSize());
            ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.metrics.rollingPercentile.enabled", (Object)true);
            ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.metrics.rollingPercentile.timeInMilliseconds", (Object)this.defaultConfig.getMetrics().getPercentileTimeInMillis());
            ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.metrics.rollingPercentile.numBuckets", (Object)this.defaultConfig.getMetrics().getNumBucketSize());
            ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.metrics.rollingPercentile.bucketSize", (Object)this.defaultConfig.getMetrics().getPercentileBucketSize());
            ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.metrics.healthSnapshot.intervalInMilliseconds", (Object)this.defaultConfig.getMetrics().getHealthCheckInterval());
            commandConfigMap.values().stream().forEach(c -> {
                ConfigurationManager.getConfigInstance().setProperty(String.format("hystrix.command.%s.coreSize", c.getName()), (Object)c.getThreadPool().getConcurrency());
                ConfigurationManager.getConfigInstance().setProperty(String.format("hystrix.command.%s.maxQueueSize", c.getName()), (Object)c.getThreadPool().getMaxRequestQueueSize());
                ConfigurationManager.getConfigInstance().setProperty(String.format("hystrix.command.%s.queueSizeRejectionThreshold", c.getName()), (Object)c.getThreadPool().getDynamicRequestQueueSize());
                ConfigurationManager.getConfigInstance().setProperty(String.format("hystrix.command.%s.execution.isolation.strategy", c.getName()), (Object)(c.getThreadPool().isSemaphoreIsolation() ? "SEMAPHORE" : "THREAD"));
                ConfigurationManager.getConfigInstance().setProperty(String.format("hystrix.command.%s.execution.thread.timeoutInMilliseconds", c.getName()), (Object)c.getThreadPool().getTimeout());
                ConfigurationManager.getConfigInstance().setProperty(String.format("hystrix.command.%s.execution.timeout.enabled", c.getName()), (Object)true);
                ConfigurationManager.getConfigInstance().setProperty(String.format("hystrix.command.%s.execution.isolation.thread.interruptOnTimeout", c.getName()), (Object)true);
                ConfigurationManager.getConfigInstance().setProperty(String.format("hystrix.command.%s.execution.isolation.semaphore.maxConcurrentRequests", c.getName()), (Object)c.getThreadPool().getConcurrency());
                ConfigurationManager.getConfigInstance().setProperty(String.format("hystrix.command.%s.circuitBreaker.enabled", c.getName()), (Object)true);
                ConfigurationManager.getConfigInstance().setProperty(String.format("hystrix.command.%s.circuitBreaker.requestVolumeThreshold", c.getName()), (Object)c.getCircuitBreaker().getAcceptableFailuresInWindow());
                ConfigurationManager.getConfigInstance().setProperty(String.format("hystrix.command.%s.circuitBreaker.errorThresholdPercentage", c.getName()), (Object)c.getCircuitBreaker().getErrorThreshold());
                ConfigurationManager.getConfigInstance().setProperty(String.format("hystrix.command.%s.circuitBreaker.sleepWindowInMilliseconds", c.getName()), (Object)c.getCircuitBreaker().getWaitTimeBeforeRetry());
                ConfigurationManager.getConfigInstance().setProperty(String.format("hystrix.command.%s.metrics.rollingStats.timeInMilliseconds", c.getName()), (Object)c.getMetrics().getStatsTimeInMillis());
                ConfigurationManager.getConfigInstance().setProperty(String.format("hystrix.command.%s.metrics.rollingStats.numBuckets", c.getName()), (Object)c.getMetrics().getNumBucketSize());
                ConfigurationManager.getConfigInstance().setProperty(String.format("hystrix.command.%s.metrics.rollingPercentile.enabled", c.getName()), (Object)true);
                ConfigurationManager.getConfigInstance().setProperty(String.format("hystrix.command.%s.metrics.rollingPercentile.timeInMilliseconds", c.getName()), (Object)c.getMetrics().getPercentileTimeInMillis());
                ConfigurationManager.getConfigInstance().setProperty(String.format("hystrix.command.%s.metrics.rollingPercentile.numBuckets", c.getName()), (Object)c.getMetrics().getNumBucketSize());
                ConfigurationManager.getConfigInstance().setProperty(String.format("hystrix.command.%s.metrics.rollingPercentile.bucketSize", c.getName()), (Object)c.getMetrics().getPercentileBucketSize());
                ConfigurationManager.getConfigInstance().setProperty(String.format("hystrix.command.%s.metrics.healthSnapshot.intervalInMilliseconds", c.getName()), (Object)c.getMetrics().getHealthCheckInterval());
            });
            Map<String, HystrixCommand.Setter> mapData = commandConfigMap.values().stream().collect(Collectors.toMap(HystrixCommandConfig::getName, c -> HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)c.getName())).andCommandKey(HystrixCommandKey.Factory.asKey((String)c.getName())).andThreadPoolKey(HystrixThreadPoolKey.Factory.asKey((String)c.getName())).andCommandPropertiesDefaults(HystrixCommandProperties.Setter().withExecutionIsolationStrategy(c.getThreadPool().isSemaphoreIsolation() ? HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE : HystrixCommandProperties.ExecutionIsolationStrategy.THREAD).withExecutionIsolationSemaphoreMaxConcurrentRequests(c.getThreadPool().getConcurrency()).withFallbackIsolationSemaphoreMaxConcurrentRequests(c.getThreadPool().getConcurrency()).withFallbackEnabled(c.isFallbackEnabled()).withCircuitBreakerErrorThresholdPercentage(c.getCircuitBreaker().getErrorThreshold()).withCircuitBreakerRequestVolumeThreshold(c.getCircuitBreaker().getAcceptableFailuresInWindow()).withCircuitBreakerSleepWindowInMilliseconds(c.getCircuitBreaker().getWaitTimeBeforeRetry()).withExecutionTimeoutInMilliseconds(c.getThreadPool().getTimeout()).withMetricsHealthSnapshotIntervalInMilliseconds(c.getMetrics().getHealthCheckInterval()).withMetricsRollingPercentileBucketSize(c.getMetrics().getPercentileBucketSize()).withMetricsRollingPercentileWindowInMilliseconds(c.getMetrics().getPercentileTimeInMillis())).andThreadPoolPropertiesDefaults(HystrixThreadPoolProperties.Setter().withCoreSize(c.getThreadPool().getConcurrency()).withMaxQueueSize(c.getThreadPool().getMaxRequestQueueSize()).withQueueSizeRejectionThreshold(c.getThreadPool().getDynamicRequestQueueSize()).withMetricsRollingStatisticalWindowBuckets(c.getMetrics().getNumBucketSize()).withMetricsRollingStatisticalWindowInMilliseconds(c.getMetrics().getStatsTimeInMillis()))));
            this.hystrixConfigCache = new ConcurrentHashMap();
            this.hystrixConfigCache.putAll(mapData);
        }
    }

    public static HystrixCommand.Setter getCommandConfiguration(String key) {
        if (factory == null) {
            throw new IllegalStateException("Factory not initialized");
        }
        if (!HystrixConfigurationFactory.factory.hystrixConfigCache.containsKey(key)) {
            HystrixConfigurationFactory.factory.hystrixConfigCache.putIfAbsent(key, HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)key)).andCommandKey(HystrixCommandKey.Factory.asKey((String)key)).andThreadPoolKey(HystrixThreadPoolKey.Factory.asKey((String)key)).andCommandPropertiesDefaults(HystrixCommandProperties.Setter().withExecutionIsolationStrategy(HystrixCommandProperties.ExecutionIsolationStrategy.THREAD).withExecutionIsolationSemaphoreMaxConcurrentRequests(factory.getDefaultConfig().getThreadPool().getConcurrency()).withFallbackIsolationSemaphoreMaxConcurrentRequests(factory.getDefaultConfig().getThreadPool().getConcurrency()).withFallbackEnabled(false).withCircuitBreakerErrorThresholdPercentage(factory.getDefaultConfig().getCircuitBreaker().getErrorThreshold()).withCircuitBreakerRequestVolumeThreshold(factory.getDefaultConfig().getCircuitBreaker().getAcceptableFailuresInWindow()).withCircuitBreakerSleepWindowInMilliseconds(factory.getDefaultConfig().getCircuitBreaker().getWaitTimeBeforeRetry()).withExecutionTimeoutInMilliseconds(factory.getDefaultConfig().getThreadPool().getTimeout()).withMetricsHealthSnapshotIntervalInMilliseconds(factory.getDefaultConfig().getMetrics().getHealthCheckInterval()).withMetricsRollingPercentileBucketSize(factory.getDefaultConfig().getMetrics().getPercentileBucketSize()).withMetricsRollingPercentileWindowInMilliseconds(factory.getDefaultConfig().getMetrics().getPercentileTimeInMillis())).andThreadPoolPropertiesDefaults(HystrixThreadPoolProperties.Setter().withCoreSize(factory.getDefaultConfig().getThreadPool().getConcurrency()).withMaxQueueSize(factory.getDefaultConfig().getThreadPool().getMaxRequestQueueSize()).withQueueSizeRejectionThreshold(factory.getDefaultConfig().getThreadPool().getDynamicRequestQueueSize()).withMetricsRollingStatisticalWindowBuckets(factory.getDefaultConfig().getMetrics().getNumBucketSize()).withMetricsRollingStatisticalWindowInMilliseconds(factory.getDefaultConfig().getMetrics().getStatsTimeInMillis())));
        }
        return HystrixConfigurationFactory.factory.hystrixConfigCache.get(key);
    }

    public HystrixDefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }
}

