/*
 * Decompiled with CFR 0.152.
 */
package com.hystrix.configurator.config;

import com.hystrix.configurator.config.HystrixCommandConfig;
import com.hystrix.configurator.config.HystrixDefaultConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.NotNull;

public class HystrixConfig {
    @NotNull
    private HystrixDefaultConfig defaultConfig = new HystrixDefaultConfig();
    private List<HystrixCommandConfig> commands = Collections.emptyList();

    public HystrixConfig(HystrixDefaultConfig defaultConfig, List<HystrixCommandConfig> commands) {
        this.defaultConfig = defaultConfig;
        this.commands = commands;
    }

    public static HystrixConfigBuilder builder() {
        return new HystrixConfigBuilder();
    }

    public HystrixDefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public List<HystrixCommandConfig> getCommands() {
        return this.commands;
    }

    public void setDefaultConfig(HystrixDefaultConfig defaultConfig) {
        this.defaultConfig = defaultConfig;
    }

    public void setCommands(List<HystrixCommandConfig> commands) {
        this.commands = commands;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HystrixConfig)) {
            return false;
        }
        HystrixConfig other = (HystrixConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HystrixDefaultConfig this$defaultConfig = this.getDefaultConfig();
        HystrixDefaultConfig other$defaultConfig = other.getDefaultConfig();
        if (this$defaultConfig == null ? other$defaultConfig != null : !((Object)this$defaultConfig).equals(other$defaultConfig)) {
            return false;
        }
        List<HystrixCommandConfig> this$commands = this.getCommands();
        List<HystrixCommandConfig> other$commands = other.getCommands();
        return !(this$commands == null ? other$commands != null : !((Object)this$commands).equals(other$commands));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HystrixConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HystrixDefaultConfig $defaultConfig = this.getDefaultConfig();
        result = result * 59 + ($defaultConfig == null ? 43 : ((Object)$defaultConfig).hashCode());
        List<HystrixCommandConfig> $commands = this.getCommands();
        result = result * 59 + ($commands == null ? 43 : ((Object)$commands).hashCode());
        return result;
    }

    public String toString() {
        return "HystrixConfig(defaultConfig=" + this.getDefaultConfig() + ", commands=" + this.getCommands() + ")";
    }

    public HystrixConfig() {
    }

    public static class HystrixConfigBuilder {
        private HystrixDefaultConfig defaultConfig;
        private ArrayList<HystrixCommandConfig> commands;

        HystrixConfigBuilder() {
        }

        public HystrixConfigBuilder defaultConfig(HystrixDefaultConfig defaultConfig) {
            this.defaultConfig = defaultConfig;
            return this;
        }

        public HystrixConfigBuilder command(HystrixCommandConfig command) {
            if (this.commands == null) {
                this.commands = new ArrayList();
            }
            this.commands.add(command);
            return this;
        }

        public HystrixConfigBuilder commands(Collection<? extends HystrixCommandConfig> commands) {
            if (this.commands == null) {
                this.commands = new ArrayList();
            }
            this.commands.addAll(commands);
            return this;
        }

        public HystrixConfig build() {
            List<HystrixCommandConfig> commands;
            switch (this.commands == null ? 0 : this.commands.size()) {
                case 0: {
                    commands = Collections.emptyList();
                    break;
                }
                case 1: {
                    commands = Collections.singletonList(this.commands.get(0));
                    break;
                }
                default: {
                    commands = Collections.unmodifiableList(new ArrayList<HystrixCommandConfig>(this.commands));
                }
            }
            return new HystrixConfig(this.defaultConfig, commands);
        }

        public String toString() {
            return "HystrixConfig.HystrixConfigBuilder(defaultConfig=" + this.defaultConfig + ", commands=" + this.commands + ")";
        }
    }
}

