/*
 * Decompiled with CFR 0.152.
 */
package com.hystrix.configurator.config;

public class CircuitBreakerConfig {
    private int acceptableFailuresInWindow = 20;
    private int waitTimeBeforeRetry = 5000;
    private int errorThreshold = 50;

    public CircuitBreakerConfig(int acceptableFailuresInWindow, int waitTimeBeforeRetry, int errorThreshold) {
        this.acceptableFailuresInWindow = acceptableFailuresInWindow;
        this.waitTimeBeforeRetry = waitTimeBeforeRetry;
        this.errorThreshold = errorThreshold;
    }

    public static CircuitBreakerConfigBuilder builder() {
        return new CircuitBreakerConfigBuilder();
    }

    public int getAcceptableFailuresInWindow() {
        return this.acceptableFailuresInWindow;
    }

    public int getWaitTimeBeforeRetry() {
        return this.waitTimeBeforeRetry;
    }

    public int getErrorThreshold() {
        return this.errorThreshold;
    }

    public void setAcceptableFailuresInWindow(int acceptableFailuresInWindow) {
        this.acceptableFailuresInWindow = acceptableFailuresInWindow;
    }

    public void setWaitTimeBeforeRetry(int waitTimeBeforeRetry) {
        this.waitTimeBeforeRetry = waitTimeBeforeRetry;
    }

    public void setErrorThreshold(int errorThreshold) {
        this.errorThreshold = errorThreshold;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CircuitBreakerConfig)) {
            return false;
        }
        CircuitBreakerConfig other = (CircuitBreakerConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getAcceptableFailuresInWindow() != other.getAcceptableFailuresInWindow()) {
            return false;
        }
        if (this.getWaitTimeBeforeRetry() != other.getWaitTimeBeforeRetry()) {
            return false;
        }
        return this.getErrorThreshold() == other.getErrorThreshold();
    }

    protected boolean canEqual(Object other) {
        return other instanceof CircuitBreakerConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getAcceptableFailuresInWindow();
        result = result * 59 + this.getWaitTimeBeforeRetry();
        result = result * 59 + this.getErrorThreshold();
        return result;
    }

    public String toString() {
        return "CircuitBreakerConfig(acceptableFailuresInWindow=" + this.getAcceptableFailuresInWindow() + ", waitTimeBeforeRetry=" + this.getWaitTimeBeforeRetry() + ", errorThreshold=" + this.getErrorThreshold() + ")";
    }

    public CircuitBreakerConfig() {
    }

    public static class CircuitBreakerConfigBuilder {
        private int acceptableFailuresInWindow;
        private int waitTimeBeforeRetry;
        private int errorThreshold;

        CircuitBreakerConfigBuilder() {
        }

        public CircuitBreakerConfigBuilder acceptableFailuresInWindow(int acceptableFailuresInWindow) {
            this.acceptableFailuresInWindow = acceptableFailuresInWindow;
            return this;
        }

        public CircuitBreakerConfigBuilder waitTimeBeforeRetry(int waitTimeBeforeRetry) {
            this.waitTimeBeforeRetry = waitTimeBeforeRetry;
            return this;
        }

        public CircuitBreakerConfigBuilder errorThreshold(int errorThreshold) {
            this.errorThreshold = errorThreshold;
            return this;
        }

        public CircuitBreakerConfig build() {
            return new CircuitBreakerConfig(this.acceptableFailuresInWindow, this.waitTimeBeforeRetry, this.errorThreshold);
        }

        public String toString() {
            return "CircuitBreakerConfig.CircuitBreakerConfigBuilder(acceptableFailuresInWindow=" + this.acceptableFailuresInWindow + ", waitTimeBeforeRetry=" + this.waitTimeBeforeRetry + ", errorThreshold=" + this.errorThreshold + ")";
        }
    }
}

