/*
 * Decompiled with CFR 0.152.
 */
package com.hystrix.configurator.core;

import com.hystrix.configurator.config.CircuitBreakerConfig;
import com.hystrix.configurator.config.HystrixCommandConfig;
import com.hystrix.configurator.config.HystrixConfig;
import com.hystrix.configurator.config.HystrixDefaultConfig;
import com.hystrix.configurator.config.MetricsConfig;
import com.hystrix.configurator.config.ThreadPoolConfig;
import com.netflix.config.ConfigurationManager;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import java.security.InvalidParameterException;
import java.util.Map;
import java.util.stream.Collectors;

public class HystrixConfigutationFactory {
    private final HystrixConfig config;
    private HystrixDefaultConfig defaultConfig;
    private Map<String, HystrixCommandConfig> commandConfigMap;
    private Map<String, HystrixCommand.Setter> hystrixConfigCache;
    private static HystrixConfigutationFactory factory;

    private HystrixConfigutationFactory(HystrixConfig config) {
        this.config = config;
    }

    public static void init(HystrixConfig config) {
        if (factory == null) {
            factory = new HystrixConfigutationFactory(config);
        }
        factory.setup();
    }

    private void setup() {
        if (this.config != null) {
            this.defaultConfig = this.config.getDefaultConfig();
            if (this.defaultConfig == null) {
                this.defaultConfig = new HystrixDefaultConfig();
            }
            if (this.defaultConfig.getThreadPool() == null) {
                this.defaultConfig.setThreadPool(new ThreadPoolConfig());
            }
            if (this.defaultConfig.getCircuitBreaker() == null) {
                this.defaultConfig.setCircuitBreaker(new CircuitBreakerConfig());
            }
            if (this.defaultConfig.getMetrics() == null) {
                this.defaultConfig.setMetrics(new MetricsConfig());
            }
            this.commandConfigMap = this.config.getCommands().stream().collect(Collectors.toMap(HystrixCommandConfig::getName, c -> c));
            this.commandConfigMap.forEach((k, v) -> {
                if (v.getCircuitBreaker() == null) {
                    v.setCircuitBreaker(this.defaultConfig.getCircuitBreaker());
                }
                if (v.getThreadPool() == null) {
                    v.setThreadPool(this.defaultConfig.getThreadPool());
                }
                if (v.getMetrics() == null) {
                    v.setMetrics(this.defaultConfig.getMetrics());
                }
            });
            ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.coreSize", (Object)this.defaultConfig.getThreadPool().getConcurrency());
            ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.maxQueueSize", (Object)this.defaultConfig.getThreadPool().getMaxRequestQueueSize());
            ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.queueSizeRejectionThreshold", (Object)this.defaultConfig.getThreadPool().getDynamicRequestQueueSize());
            ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.execution.isolation.strategy", (Object)(this.defaultConfig.getThreadPool().isSemaphoreIsolation() ? "SEMAPHORE" : "THREAD"));
            ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.execution.thread.timeoutInMilliseconds", (Object)this.defaultConfig.getThreadPool().getTimeout());
            ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.execution.timeout.enabled", (Object)true);
            ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.execution.isolation.thread.interruptOnTimeout", (Object)true);
            ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.execution.isolation.semaphore.macConcurrentRequests", (Object)this.defaultConfig.getThreadPool().getConcurrency());
            ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.circuitBreaker.enabled", (Object)true);
            ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.circuitBreaker.requestVolumeThreshold", (Object)this.defaultConfig.getCircuitBreaker().getAcceptableFailuresInWindow());
            ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.circuitBreaker.errorThresholdPercentage", (Object)this.defaultConfig.getCircuitBreaker().getErrorThreshold());
            ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.circuitBreaker.sleepWindowInMilliseconds", (Object)this.defaultConfig.getCircuitBreaker().getWaitTimeBeforeRetry());
            ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.metrics.rollingStats.timeInMilliseconds", (Object)this.defaultConfig.getMetrics().getStatsTimeInMillis());
            ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.metrics.rollingStats.numBuckets", (Object)this.defaultConfig.getMetrics().getNumBucketSize());
            ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.metrics.rollingPercentile.enabled", (Object)true);
            ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.metrics.rollingPercentile.timeInMilliseconds", (Object)this.defaultConfig.getMetrics().getPercentileTimeInMillis());
            ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.metrics.rollingPercentile.numBuckets", (Object)this.defaultConfig.getMetrics().getNumBucketSize());
            ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.metrics.rollingPercentile.bucketSize", (Object)this.defaultConfig.getMetrics().getPercentileBucketSize());
            ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.metrics.healthSnapshot.intervalInMilliseconds", (Object)this.defaultConfig.getMetrics().getHealthCheckInterval());
            this.commandConfigMap.values().stream().forEach(c -> {
                ConfigurationManager.getConfigInstance().setProperty(String.format("hystrix.command.%s.coreSize", c.getName()), (Object)c.getThreadPool().getConcurrency());
                ConfigurationManager.getConfigInstance().setProperty(String.format("hystrix.command.%s.maxQueueSize", c.getName()), (Object)c.getThreadPool().getMaxRequestQueueSize());
                ConfigurationManager.getConfigInstance().setProperty(String.format("hystrix.command.%s.queueSizeRejectionThreshold", c.getName()), (Object)c.getThreadPool().getDynamicRequestQueueSize());
                ConfigurationManager.getConfigInstance().setProperty(String.format("hystrix.command.%s.execution.isolation.strategy", c.getName()), (Object)(c.getThreadPool().isSemaphoreIsolation() ? "SEMAPHORE" : "THREAD"));
                ConfigurationManager.getConfigInstance().setProperty(String.format("hystrix.command.%s.execution.thread.timeoutInMilliseconds", c.getName()), (Object)c.getThreadPool().getTimeout());
                ConfigurationManager.getConfigInstance().setProperty(String.format("hystrix.command.%s.execution.timeout.enabled", c.getName()), (Object)true);
                ConfigurationManager.getConfigInstance().setProperty(String.format("hystrix.command.%s.execution.isolation.thread.interruptOnTimeout", c.getName()), (Object)true);
                ConfigurationManager.getConfigInstance().setProperty(String.format("hystrix.command.%s.execution.isolation.semaphore.macConcurrentRequests", c.getName()), (Object)c.getThreadPool().getConcurrency());
                ConfigurationManager.getConfigInstance().setProperty(String.format("hystrix.command.%s.circuitBreaker.enabled", c.getName()), (Object)true);
                ConfigurationManager.getConfigInstance().setProperty(String.format("hystrix.command.%s.circuitBreaker.requestVolumeThreshold", c.getName()), (Object)c.getCircuitBreaker().getAcceptableFailuresInWindow());
                ConfigurationManager.getConfigInstance().setProperty(String.format("hystrix.command.%s.circuitBreaker.errorThresholdPercentage", c.getName()), (Object)c.getCircuitBreaker().getErrorThreshold());
                ConfigurationManager.getConfigInstance().setProperty(String.format("hystrix.command.%s.circuitBreaker.sleepWindowInMilliseconds", c.getName()), (Object)c.getCircuitBreaker().getWaitTimeBeforeRetry());
                ConfigurationManager.getConfigInstance().setProperty(String.format("hystrix.command.%s.metrics.rollingStats.timeInMilliseconds", c.getName()), (Object)c.getMetrics().getStatsTimeInMillis());
                ConfigurationManager.getConfigInstance().setProperty(String.format("hystrix.command.%s.metrics.rollingStats.numBuckets", c.getName()), (Object)c.getMetrics().getNumBucketSize());
                ConfigurationManager.getConfigInstance().setProperty(String.format("hystrix.command.%s.metrics.rollingPercentile.enabled", c.getName()), (Object)true);
                ConfigurationManager.getConfigInstance().setProperty(String.format("hystrix.command.%s.metrics.rollingPercentile.timeInMilliseconds", c.getName()), (Object)c.getMetrics().getPercentileTimeInMillis());
                ConfigurationManager.getConfigInstance().setProperty(String.format("hystrix.command.%s.metrics.rollingPercentile.numBuckets", c.getName()), (Object)c.getMetrics().getNumBucketSize());
                ConfigurationManager.getConfigInstance().setProperty(String.format("hystrix.command.%s.metrics.rollingPercentile.bucketSize", c.getName()), (Object)c.getMetrics().getPercentileBucketSize());
                ConfigurationManager.getConfigInstance().setProperty(String.format("hystrix.command.%s.metrics.healthSnapshot.intervalInMilliseconds", c.getName()), (Object)c.getMetrics().getHealthCheckInterval());
            });
            this.hystrixConfigCache = this.commandConfigMap.values().stream().collect(Collectors.toMap(HystrixCommandConfig::getName, c -> HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)c.getName())).andCommandKey(HystrixCommandKey.Factory.asKey((String)c.getName())).andThreadPoolKey(HystrixThreadPoolKey.Factory.asKey((String)c.getName())).andCommandPropertiesDefaults(HystrixCommandProperties.Setter().withExecutionIsolationStrategy(c.getThreadPool().isSemaphoreIsolation() ? HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE : HystrixCommandProperties.ExecutionIsolationStrategy.THREAD).withExecutionIsolationSemaphoreMaxConcurrentRequests(c.getThreadPool().getConcurrency()).withFallbackIsolationSemaphoreMaxConcurrentRequests(c.getThreadPool().getConcurrency()).withFallbackEnabled(c.isFallbackEnabled()).withCircuitBreakerErrorThresholdPercentage(c.getCircuitBreaker().getErrorThreshold()).withCircuitBreakerRequestVolumeThreshold(c.getCircuitBreaker().getAcceptableFailuresInWindow()).withCircuitBreakerSleepWindowInMilliseconds(c.getCircuitBreaker().getWaitTimeBeforeRetry()).withExecutionTimeoutInMilliseconds(c.getThreadPool().getTimeout()).withMetricsHealthSnapshotIntervalInMilliseconds(c.getMetrics().getHealthCheckInterval()).withMetricsRollingPercentileBucketSize(c.getMetrics().getPercentileBucketSize()).withMetricsRollingPercentileWindowInMilliseconds(c.getMetrics().getPercentileTimeInMillis())).andThreadPoolPropertiesDefaults(HystrixThreadPoolProperties.Setter().withCoreSize(c.getThreadPool().getConcurrency()).withMaxQueueSize(c.getThreadPool().getMaxRequestQueueSize()).withQueueSizeRejectionThreshold(c.getThreadPool().getDynamicRequestQueueSize()).withMetricsRollingStatisticalWindowBuckets(c.getMetrics().getNumBucketSize()).withMetricsRollingStatisticalWindowInMilliseconds(c.getMetrics().getStatsTimeInMillis()))));
        }
    }

    public static HystrixCommand.Setter getCommandConfiguration(String key) {
        if (factory == null) {
            throw new IllegalStateException("Factory not initialized");
        }
        if (!HystrixConfigutationFactory.factory.hystrixConfigCache.containsKey(key)) {
            throw new InvalidParameterException("Invalid command key");
        }
        return HystrixConfigutationFactory.factory.hystrixConfigCache.get(key);
    }
}

