/*
 * Decompiled with CFR 0.152.
 */
package com.hystrix.configurator.config;

import com.hystrix.configurator.config.CircuitBreakerConfig;
import com.hystrix.configurator.config.MetricsConfig;
import com.hystrix.configurator.config.ThreadPoolConfig;
import java.beans.ConstructorProperties;

public class HystrixCommandConfig {
    private String name;
    private ThreadPoolConfig threadPool;
    private CircuitBreakerConfig circuitBreaker;
    private MetricsConfig metrics = new MetricsConfig();
    private boolean fallbackEnabled = true;

    public static HystrixCommandConfigBuilder builder() {
        return new HystrixCommandConfigBuilder();
    }

    public String getName() {
        return this.name;
    }

    public ThreadPoolConfig getThreadPool() {
        return this.threadPool;
    }

    public CircuitBreakerConfig getCircuitBreaker() {
        return this.circuitBreaker;
    }

    public MetricsConfig getMetrics() {
        return this.metrics;
    }

    public boolean isFallbackEnabled() {
        return this.fallbackEnabled;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setThreadPool(ThreadPoolConfig threadPool) {
        this.threadPool = threadPool;
    }

    public void setCircuitBreaker(CircuitBreakerConfig circuitBreaker) {
        this.circuitBreaker = circuitBreaker;
    }

    public void setMetrics(MetricsConfig metrics) {
        this.metrics = metrics;
    }

    public void setFallbackEnabled(boolean fallbackEnabled) {
        this.fallbackEnabled = fallbackEnabled;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HystrixCommandConfig)) {
            return false;
        }
        HystrixCommandConfig other = (HystrixCommandConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        ThreadPoolConfig this$threadPool = this.getThreadPool();
        ThreadPoolConfig other$threadPool = other.getThreadPool();
        if (this$threadPool == null ? other$threadPool != null : !((Object)this$threadPool).equals(other$threadPool)) {
            return false;
        }
        CircuitBreakerConfig this$circuitBreaker = this.getCircuitBreaker();
        CircuitBreakerConfig other$circuitBreaker = other.getCircuitBreaker();
        if (this$circuitBreaker == null ? other$circuitBreaker != null : !((Object)this$circuitBreaker).equals(other$circuitBreaker)) {
            return false;
        }
        MetricsConfig this$metrics = this.getMetrics();
        MetricsConfig other$metrics = other.getMetrics();
        if (this$metrics == null ? other$metrics != null : !((Object)this$metrics).equals(other$metrics)) {
            return false;
        }
        return this.isFallbackEnabled() == other.isFallbackEnabled();
    }

    protected boolean canEqual(Object other) {
        return other instanceof HystrixCommandConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        ThreadPoolConfig $threadPool = this.getThreadPool();
        result = result * 59 + ($threadPool == null ? 43 : ((Object)$threadPool).hashCode());
        CircuitBreakerConfig $circuitBreaker = this.getCircuitBreaker();
        result = result * 59 + ($circuitBreaker == null ? 43 : ((Object)$circuitBreaker).hashCode());
        MetricsConfig $metrics = this.getMetrics();
        result = result * 59 + ($metrics == null ? 43 : ((Object)$metrics).hashCode());
        result = result * 59 + (this.isFallbackEnabled() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "HystrixCommandConfig(name=" + this.getName() + ", threadPool=" + this.getThreadPool() + ", circuitBreaker=" + this.getCircuitBreaker() + ", metrics=" + this.getMetrics() + ", fallbackEnabled=" + this.isFallbackEnabled() + ")";
    }

    public HystrixCommandConfig() {
    }

    @ConstructorProperties(value={"name", "threadPool", "circuitBreaker", "metrics", "fallbackEnabled"})
    public HystrixCommandConfig(String name, ThreadPoolConfig threadPool, CircuitBreakerConfig circuitBreaker, MetricsConfig metrics, boolean fallbackEnabled) {
        this.name = name;
        this.threadPool = threadPool;
        this.circuitBreaker = circuitBreaker;
        this.metrics = metrics;
        this.fallbackEnabled = fallbackEnabled;
    }

    public static class HystrixCommandConfigBuilder {
        private String name;
        private ThreadPoolConfig threadPool;
        private CircuitBreakerConfig circuitBreaker;
        private MetricsConfig metrics;
        private boolean fallbackEnabled;

        HystrixCommandConfigBuilder() {
        }

        public HystrixCommandConfigBuilder name(String name) {
            this.name = name;
            return this;
        }

        public HystrixCommandConfigBuilder threadPool(ThreadPoolConfig threadPool) {
            this.threadPool = threadPool;
            return this;
        }

        public HystrixCommandConfigBuilder circuitBreaker(CircuitBreakerConfig circuitBreaker) {
            this.circuitBreaker = circuitBreaker;
            return this;
        }

        public HystrixCommandConfigBuilder metrics(MetricsConfig metrics) {
            this.metrics = metrics;
            return this;
        }

        public HystrixCommandConfigBuilder fallbackEnabled(boolean fallbackEnabled) {
            this.fallbackEnabled = fallbackEnabled;
            return this;
        }

        public HystrixCommandConfig build() {
            return new HystrixCommandConfig(this.name, this.threadPool, this.circuitBreaker, this.metrics, this.fallbackEnabled);
        }

        public String toString() {
            return "HystrixCommandConfig.HystrixCommandConfigBuilder(name=" + this.name + ", threadPool=" + this.threadPool + ", circuitBreaker=" + this.circuitBreaker + ", metrics=" + this.metrics + ", fallbackEnabled=" + this.fallbackEnabled + ")";
        }
    }
}

