/*
 * Decompiled with CFR 0.152.
 */
package com.hystrix.configurator.core;

import com.hystrix.configurator.config.CircuitBreakerConfig;
import com.hystrix.configurator.config.HystrixCommandConfig;
import com.hystrix.configurator.config.HystrixConfig;
import com.hystrix.configurator.config.HystrixDefaultConfig;
import com.hystrix.configurator.config.MetricsConfig;
import com.hystrix.configurator.config.ThreadPoolConfig;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import java.security.InvalidParameterException;
import java.util.Map;
import java.util.stream.Collectors;

public class HystrixConfigutationFactory {
    private final HystrixConfig config;
    private HystrixDefaultConfig defaultConfig;
    private Map<String, HystrixCommandConfig> commandConfigMap;
    private Map<String, HystrixCommand.Setter> hystrixConfigCache;
    private static HystrixConfigutationFactory factory;

    private HystrixConfigutationFactory(HystrixConfig config) {
        this.config = config;
    }

    public static void init(HystrixConfig config) {
        if (factory == null) {
            factory = new HystrixConfigutationFactory(config);
        }
        factory.setup();
    }

    private void setup() {
        if (this.config != null) {
            this.defaultConfig = this.config.getDefaultConfig();
            if (this.defaultConfig == null) {
                this.defaultConfig = new HystrixDefaultConfig();
            }
            if (this.defaultConfig.getThreadPool() == null) {
                this.defaultConfig.setThreadPool(new ThreadPoolConfig());
            }
            if (this.defaultConfig.getCircuitBreaker() == null) {
                this.defaultConfig.setCircuitBreaker(new CircuitBreakerConfig());
            }
            if (this.defaultConfig.getMetrics() == null) {
                this.defaultConfig.setMetrics(new MetricsConfig());
            }
            this.commandConfigMap = this.config.getCommands().stream().collect(Collectors.toMap(HystrixCommandConfig::getName, c -> c));
            this.commandConfigMap.forEach((k, v) -> {
                if (v.getCircuitBreaker() == null) {
                    v.setCircuitBreaker(this.defaultConfig.getCircuitBreaker());
                }
                if (v.getThreadPool() == null) {
                    v.setThreadPool(this.defaultConfig.getThreadPool());
                }
                if (v.getMetrics() == null) {
                    v.setMetrics(this.defaultConfig.getMetrics());
                }
            });
            this.hystrixConfigCache = this.commandConfigMap.values().stream().collect(Collectors.toMap(HystrixCommandConfig::getName, c -> HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)c.getName())).andCommandKey(HystrixCommandKey.Factory.asKey((String)c.getName())).andThreadPoolKey(HystrixThreadPoolKey.Factory.asKey((String)c.getName())).andCommandPropertiesDefaults(HystrixCommandProperties.Setter().withExecutionIsolationStrategy(c.getThreadPool().isSemaphoreIsolation() ? HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE : HystrixCommandProperties.ExecutionIsolationStrategy.THREAD).withExecutionIsolationSemaphoreMaxConcurrentRequests(c.getThreadPool().getConcurrency()).withFallbackIsolationSemaphoreMaxConcurrentRequests(c.getThreadPool().getConcurrency()).withFallbackEnabled(c.isFallbackEnabled()).withCircuitBreakerErrorThresholdPercentage(c.getCircuitBreaker().getErrorThreshold()).withCircuitBreakerRequestVolumeThreshold(c.getCircuitBreaker().getAcceptableFailuresInWindow()).withCircuitBreakerSleepWindowInMilliseconds(c.getCircuitBreaker().getWaitTimeBeforeRetry()).withExecutionTimeoutInMilliseconds(c.getThreadPool().getTimeout()).withMetricsHealthSnapshotIntervalInMilliseconds(c.getMetrics().getHealthCheckInterval()).withMetricsRollingPercentileBucketSize(c.getMetrics().getPercentileBucketSize()).withMetricsRollingPercentileWindowInMilliseconds(c.getMetrics().getPercentileTimeInMillis())).andThreadPoolPropertiesDefaults(HystrixThreadPoolProperties.Setter().withCoreSize(c.getThreadPool().getConcurrency()).withMaxQueueSize(c.getThreadPool().getMaxRequestQueueSize()).withQueueSizeRejectionThreshold(c.getThreadPool().getDynamicRequestQueueSize()).withMetricsRollingStatisticalWindowBuckets(c.getMetrics().getNumBucketSize()).withMetricsRollingStatisticalWindowInMilliseconds(c.getMetrics().getStatsTimeInMillis()))));
        }
    }

    public static HystrixCommand.Setter getCommandConfiguration(String key) {
        if (factory == null) {
            throw new IllegalStateException("Factory not initialized");
        }
        if (!HystrixConfigutationFactory.factory.hystrixConfigCache.containsKey(key)) {
            throw new InvalidParameterException("Invalid command key");
        }
        return HystrixConfigutationFactory.factory.hystrixConfigCache.get(key);
    }
}

